package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPlugin invokes the cloudapi.ModifyPlugin API synchronously
func (client *Client) ModifyPlugin(request *ModifyPluginRequest) (response *ModifyPluginResponse, err error) {
	response = CreateModifyPluginResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPluginWithChan invokes the cloudapi.ModifyPlugin API asynchronously
func (client *Client) ModifyPluginWithChan(request *ModifyPluginRequest) (<-chan *ModifyPluginResponse, <-chan error) {
	responseChan := make(chan *ModifyPluginResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPlugin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPluginWithCallback invokes the cloudapi.ModifyPlugin API asynchronously
func (client *Client) ModifyPluginWithCallback(request *ModifyPluginRequest, callback func(response *ModifyPluginResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPluginResponse
		var err error
		defer close(result)
		response, err = client.ModifyPlugin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPluginRequest is the request struct for api ModifyPlugin
type ModifyPluginRequest struct {
	*requests.RpcRequest
	PluginName    string             `position:"Query" name:"PluginName"`
	PluginId      string             `position:"Query" name:"PluginId"`
	PluginData    string             `position:"Query" name:"PluginData"`
	Description   string             `position:"Query" name:"Description"`
	SecurityToken string             `position:"Query" name:"SecurityToken"`
	Tag           *[]ModifyPluginTag `position:"Query" name:"Tag"  type:"Repeated"`
}

// ModifyPluginTag is a repeated param struct in ModifyPluginRequest
type ModifyPluginTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ModifyPluginResponse is the response struct for api ModifyPlugin
type ModifyPluginResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPluginRequest creates a request to invoke ModifyPlugin API
func CreateModifyPluginRequest() (request *ModifyPluginRequest) {
	request = &ModifyPluginRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyPlugin", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyPluginResponse creates a response to parse from ModifyPlugin response
func CreateModifyPluginResponse() (response *ModifyPluginResponse) {
	response = &ModifyPluginResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
