package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePlugin invokes the cloudapi.CreatePlugin API synchronously
func (client *Client) CreatePlugin(request *CreatePluginRequest) (response *CreatePluginResponse, err error) {
	response = CreateCreatePluginResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePluginWithChan invokes the cloudapi.CreatePlugin API asynchronously
func (client *Client) CreatePluginWithChan(request *CreatePluginRequest) (<-chan *CreatePluginResponse, <-chan error) {
	responseChan := make(chan *CreatePluginResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePlugin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePluginWithCallback invokes the cloudapi.CreatePlugin API asynchronously
func (client *Client) CreatePluginWithCallback(request *CreatePluginRequest, callback func(response *CreatePluginResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePluginResponse
		var err error
		defer close(result)
		response, err = client.CreatePlugin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePluginRequest is the request struct for api CreatePlugin
type CreatePluginRequest struct {
	*requests.RpcRequest
	PluginName    string             `position:"Query" name:"PluginName"`
	PluginData    string             `position:"Query" name:"PluginData"`
	Description   string             `position:"Query" name:"Description"`
	PluginType    string             `position:"Query" name:"PluginType"`
	SecurityToken string             `position:"Query" name:"SecurityToken"`
	Tag           *[]CreatePluginTag `position:"Query" name:"Tag"  type:"Repeated"`
}

// CreatePluginTag is a repeated param struct in CreatePluginRequest
type CreatePluginTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreatePluginResponse is the response struct for api CreatePlugin
type CreatePluginResponse struct {
	*responses.BaseResponse
	PluginId  string `json:"PluginId" xml:"PluginId"`
	TagStatus bool   `json:"TagStatus" xml:"TagStatus"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreatePluginRequest creates a request to invoke CreatePlugin API
func CreateCreatePluginRequest() (request *CreatePluginRequest) {
	request = &CreatePluginRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "CreatePlugin", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePluginResponse creates a response to parse from CreatePlugin response
func CreateCreatePluginResponse() (response *CreatePluginResponse) {
	response = &CreatePluginResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
