package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIpControl invokes the cloudapi.CreateIpControl API synchronously
func (client *Client) CreateIpControl(request *CreateIpControlRequest) (response *CreateIpControlResponse, err error) {
	response = CreateCreateIpControlResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIpControlWithChan invokes the cloudapi.CreateIpControl API asynchronously
func (client *Client) CreateIpControlWithChan(request *CreateIpControlRequest) (<-chan *CreateIpControlResponse, <-chan error) {
	responseChan := make(chan *CreateIpControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIpControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIpControlWithCallback invokes the cloudapi.CreateIpControl API asynchronously
func (client *Client) CreateIpControlWithCallback(request *CreateIpControlRequest, callback func(response *CreateIpControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIpControlResponse
		var err error
		defer close(result)
		response, err = client.CreateIpControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIpControlRequest is the request struct for api CreateIpControl
type CreateIpControlRequest struct {
	*requests.RpcRequest
	IpControlName    string                             `position:"Query" name:"IpControlName"`
	IpControlPolicys *[]CreateIpControlIpControlPolicys `position:"Query" name:"IpControlPolicys"  type:"Repeated"`
	Description      string                             `position:"Query" name:"Description"`
	SecurityToken    string                             `position:"Query" name:"SecurityToken"`
	IpControlType    string                             `position:"Query" name:"IpControlType"`
}

// CreateIpControlIpControlPolicys is a repeated param struct in CreateIpControlRequest
type CreateIpControlIpControlPolicys struct {
	AppId  string `name:"AppId"`
	CidrIp string `name:"CidrIp"`
}

// CreateIpControlResponse is the response struct for api CreateIpControl
type CreateIpControlResponse struct {
	*responses.BaseResponse
	IpControlId string `json:"IpControlId" xml:"IpControlId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateIpControlRequest creates a request to invoke CreateIpControl API
func CreateCreateIpControlRequest() (request *CreateIpControlRequest) {
	request = &CreateIpControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "CreateIpControl", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIpControlResponse creates a response to parse from CreateIpControl response
func CreateCreateIpControlResponse() (response *CreateIpControlResponse) {
	response = &CreateIpControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
