package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitImportLogTasks invokes the cloud_siem.SubmitImportLogTasks API synchronously
func (client *Client) SubmitImportLogTasks(request *SubmitImportLogTasksRequest) (response *SubmitImportLogTasksResponse, err error) {
	response = CreateSubmitImportLogTasksResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitImportLogTasksWithChan invokes the cloud_siem.SubmitImportLogTasks API asynchronously
func (client *Client) SubmitImportLogTasksWithChan(request *SubmitImportLogTasksRequest) (<-chan *SubmitImportLogTasksResponse, <-chan error) {
	responseChan := make(chan *SubmitImportLogTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitImportLogTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitImportLogTasksWithCallback invokes the cloud_siem.SubmitImportLogTasks API asynchronously
func (client *Client) SubmitImportLogTasksWithCallback(request *SubmitImportLogTasksRequest, callback func(response *SubmitImportLogTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitImportLogTasksResponse
		var err error
		defer close(result)
		response, err = client.SubmitImportLogTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitImportLogTasksRequest is the request struct for api SubmitImportLogTasks
type SubmitImportLogTasksRequest struct {
	*requests.RpcRequest
	CloudCode    string           `position:"Body" name:"CloudCode"`
	LogCodes     string           `position:"Body" name:"LogCodes"`
	ProdCode     string           `position:"Body" name:"ProdCode"`
	AutoImported requests.Integer `position:"Body" name:"AutoImported"`
	Accounts     string           `position:"Body" name:"Accounts"`
}

// SubmitImportLogTasksResponse is the response struct for api SubmitImportLogTasks
type SubmitImportLogTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSubmitImportLogTasksRequest creates a request to invoke SubmitImportLogTasks API
func CreateSubmitImportLogTasksRequest() (request *SubmitImportLogTasksRequest) {
	request = &SubmitImportLogTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "SubmitImportLogTasks", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitImportLogTasksResponse creates a response to parse from SubmitImportLogTasks response
func CreateSubmitImportLogTasksResponse() (response *SubmitImportLogTasksResponse) {
	response = &SubmitImportLogTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
