package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PostAutomateResponseConfig invokes the cloud_siem.PostAutomateResponseConfig API synchronously
func (client *Client) PostAutomateResponseConfig(request *PostAutomateResponseConfigRequest) (response *PostAutomateResponseConfigResponse, err error) {
	response = CreatePostAutomateResponseConfigResponse()
	err = client.DoAction(request, response)
	return
}

// PostAutomateResponseConfigWithChan invokes the cloud_siem.PostAutomateResponseConfig API asynchronously
func (client *Client) PostAutomateResponseConfigWithChan(request *PostAutomateResponseConfigRequest) (<-chan *PostAutomateResponseConfigResponse, <-chan error) {
	responseChan := make(chan *PostAutomateResponseConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PostAutomateResponseConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PostAutomateResponseConfigWithCallback invokes the cloud_siem.PostAutomateResponseConfig API asynchronously
func (client *Client) PostAutomateResponseConfigWithCallback(request *PostAutomateResponseConfigRequest, callback func(response *PostAutomateResponseConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PostAutomateResponseConfigResponse
		var err error
		defer close(result)
		response, err = client.PostAutomateResponseConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PostAutomateResponseConfigRequest is the request struct for api PostAutomateResponseConfig
type PostAutomateResponseConfigRequest struct {
	*requests.RpcRequest
	ActionType         string           `position:"Body" name:"ActionType"`
	RuleName           string           `position:"Body" name:"RuleName"`
	ExecutionCondition string           `position:"Body" name:"ExecutionCondition"`
	ActionConfig       string           `position:"Body" name:"ActionConfig"`
	SubUserId          requests.Integer `position:"Body" name:"SubUserId"`
	AutoResponseType   string           `position:"Body" name:"AutoResponseType"`
	Id                 requests.Integer `position:"Body" name:"Id"`
}

// PostAutomateResponseConfigResponse is the response struct for api PostAutomateResponseConfig
type PostAutomateResponseConfigResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreatePostAutomateResponseConfigRequest creates a request to invoke PostAutomateResponseConfig API
func CreatePostAutomateResponseConfigRequest() (request *PostAutomateResponseConfigRequest) {
	request = &PostAutomateResponseConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "PostAutomateResponseConfig", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePostAutomateResponseConfigResponse creates a response to parse from PostAutomateResponseConfig response
func CreatePostAutomateResponseConfigResponse() (response *PostAutomateResponseConfigResponse) {
	response = &PostAutomateResponseConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
