package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhiteRuleList invokes the cloud_siem.DescribeWhiteRuleList API synchronously
func (client *Client) DescribeWhiteRuleList(request *DescribeWhiteRuleListRequest) (response *DescribeWhiteRuleListResponse, err error) {
	response = CreateDescribeWhiteRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhiteRuleListWithChan invokes the cloud_siem.DescribeWhiteRuleList API asynchronously
func (client *Client) DescribeWhiteRuleListWithChan(request *DescribeWhiteRuleListRequest) (<-chan *DescribeWhiteRuleListResponse, <-chan error) {
	responseChan := make(chan *DescribeWhiteRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhiteRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhiteRuleListWithCallback invokes the cloud_siem.DescribeWhiteRuleList API asynchronously
func (client *Client) DescribeWhiteRuleListWithCallback(request *DescribeWhiteRuleListRequest, callback func(response *DescribeWhiteRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhiteRuleListResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhiteRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhiteRuleListRequest is the request struct for api DescribeWhiteRuleList
type DescribeWhiteRuleListRequest struct {
	*requests.RpcRequest
	AlertName    string           `position:"Body" name:"AlertName"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	CurrentPage  requests.Integer `position:"Body" name:"CurrentPage"`
	AlertType    string           `position:"Body" name:"AlertType"`
	IncidentUuid string           `position:"Body" name:"IncidentUuid"`
}

// DescribeWhiteRuleListResponse is the response struct for api DescribeWhiteRuleList
type DescribeWhiteRuleListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeWhiteRuleListRequest creates a request to invoke DescribeWhiteRuleList API
func CreateDescribeWhiteRuleListRequest() (request *DescribeWhiteRuleListRequest) {
	request = &DescribeWhiteRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeWhiteRuleList", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWhiteRuleListResponse creates a response to parse from DescribeWhiteRuleList response
func CreateDescribeWhiteRuleListResponse() (response *DescribeWhiteRuleListResponse) {
	response = &DescribeWhiteRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
