package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlertScene invokes the cloud_siem.DescribeAlertScene API synchronously
func (client *Client) DescribeAlertScene(request *DescribeAlertSceneRequest) (response *DescribeAlertSceneResponse, err error) {
	response = CreateDescribeAlertSceneResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlertSceneWithChan invokes the cloud_siem.DescribeAlertScene API asynchronously
func (client *Client) DescribeAlertSceneWithChan(request *DescribeAlertSceneRequest) (<-chan *DescribeAlertSceneResponse, <-chan error) {
	responseChan := make(chan *DescribeAlertSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlertScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlertSceneWithCallback invokes the cloud_siem.DescribeAlertScene API asynchronously
func (client *Client) DescribeAlertSceneWithCallback(request *DescribeAlertSceneRequest, callback func(response *DescribeAlertSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlertSceneResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlertScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlertSceneRequest is the request struct for api DescribeAlertScene
type DescribeAlertSceneRequest struct {
	*requests.RpcRequest
}

// DescribeAlertSceneResponse is the response struct for api DescribeAlertScene
type DescribeAlertSceneResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeAlertSceneRequest creates a request to invoke DescribeAlertScene API
func CreateDescribeAlertSceneRequest() (request *DescribeAlertSceneRequest) {
	request = &DescribeAlertSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAlertScene", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlertSceneResponse creates a response to parse from DescribeAlertScene response
func CreateDescribeAlertSceneResponse() (response *DescribeAlertSceneResponse) {
	response = &DescribeAlertSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
