package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSyndb invokes the clickhouse.DeleteSyndb API synchronously
func (client *Client) DeleteSyndb(request *DeleteSyndbRequest) (response *DeleteSyndbResponse, err error) {
	response = CreateDeleteSyndbResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSyndbWithChan invokes the clickhouse.DeleteSyndb API asynchronously
func (client *Client) DeleteSyndbWithChan(request *DeleteSyndbRequest) (<-chan *DeleteSyndbResponse, <-chan error) {
	responseChan := make(chan *DeleteSyndbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSyndb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSyndbWithCallback invokes the clickhouse.DeleteSyndb API asynchronously
func (client *Client) DeleteSyndbWithCallback(request *DeleteSyndbRequest, callback func(response *DeleteSyndbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSyndbResponse
		var err error
		defer close(result)
		response, err = client.DeleteSyndb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSyndbRequest is the request struct for api DeleteSyndb
type DeleteSyndbRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SynDb                string           `position:"Query" name:"SynDb"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DbClusterId          string           `position:"Query" name:"DbClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteSyndbResponse is the response struct for api DeleteSyndb
type DeleteSyndbResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Status    bool   `json:"Status" xml:"Status"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode int64  `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteSyndbRequest creates a request to invoke DeleteSyndb API
func CreateDeleteSyndbRequest() (request *DeleteSyndbRequest) {
	request = &DeleteSyndbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DeleteSyndb", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSyndbResponse creates a response to parse from DeleteSyndb response
func CreateDeleteSyndbResponse() (response *DeleteSyndbResponse) {
	response = &DeleteSyndbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
