package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainSrcBpsData invokes the cdn.DescribeDomainSrcBpsData API synchronously
func (client *Client) DescribeDomainSrcBpsData(request *DescribeDomainSrcBpsDataRequest) (response *DescribeDomainSrcBpsDataResponse, err error) {
	response = CreateDescribeDomainSrcBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainSrcBpsDataWithChan invokes the cdn.DescribeDomainSrcBpsData API asynchronously
func (client *Client) DescribeDomainSrcBpsDataWithChan(request *DescribeDomainSrcBpsDataRequest) (<-chan *DescribeDomainSrcBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainSrcBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainSrcBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainSrcBpsDataWithCallback invokes the cdn.DescribeDomainSrcBpsData API asynchronously
func (client *Client) DescribeDomainSrcBpsDataWithCallback(request *DescribeDomainSrcBpsDataRequest, callback func(response *DescribeDomainSrcBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainSrcBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainSrcBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainSrcBpsDataRequest is the request struct for api DescribeDomainSrcBpsData
type DescribeDomainSrcBpsDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	Interval   string `position:"Query" name:"Interval"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeDomainSrcBpsDataResponse is the response struct for api DescribeDomainSrcBpsData
type DescribeDomainSrcBpsDataResponse struct {
	*responses.BaseResponse
	EndTime               string                `json:"EndTime" xml:"EndTime"`
	StartTime             string                `json:"StartTime" xml:"StartTime"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	DomainName            string                `json:"DomainName" xml:"DomainName"`
	DataInterval          string                `json:"DataInterval" xml:"DataInterval"`
	SrcBpsDataPerInterval SrcBpsDataPerInterval `json:"SrcBpsDataPerInterval" xml:"SrcBpsDataPerInterval"`
}

// CreateDescribeDomainSrcBpsDataRequest creates a request to invoke DescribeDomainSrcBpsData API
func CreateDescribeDomainSrcBpsDataRequest() (request *DescribeDomainSrcBpsDataRequest) {
	request = &DescribeDomainSrcBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeDomainSrcBpsData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainSrcBpsDataResponse creates a response to parse from DescribeDomainSrcBpsData response
func CreateDescribeDomainSrcBpsDataResponse() (response *DescribeDomainSrcBpsDataResponse) {
	response = &DescribeDomainSrcBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
