package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnDomainLogs invokes the cdn.DescribeCdnDomainLogs API synchronously
func (client *Client) DescribeCdnDomainLogs(request *DescribeCdnDomainLogsRequest) (response *DescribeCdnDomainLogsResponse, err error) {
	response = CreateDescribeCdnDomainLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnDomainLogsWithChan invokes the cdn.DescribeCdnDomainLogs API asynchronously
func (client *Client) DescribeCdnDomainLogsWithChan(request *DescribeCdnDomainLogsRequest) (<-chan *DescribeCdnDomainLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnDomainLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnDomainLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnDomainLogsWithCallback invokes the cdn.DescribeCdnDomainLogs API asynchronously
func (client *Client) DescribeCdnDomainLogsWithCallback(request *DescribeCdnDomainLogsRequest, callback func(response *DescribeCdnDomainLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnDomainLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnDomainLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnDomainLogsRequest is the request struct for api DescribeCdnDomainLogs
type DescribeCdnDomainLogsRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	EndTime    string           `position:"Query" name:"EndTime"`
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeCdnDomainLogsResponse is the response struct for api DescribeCdnDomainLogs
type DescribeCdnDomainLogsResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	DomainLogDetails DomainLogDetails `json:"DomainLogDetails" xml:"DomainLogDetails"`
}

// CreateDescribeCdnDomainLogsRequest creates a request to invoke DescribeCdnDomainLogs API
func CreateDescribeCdnDomainLogsRequest() (request *DescribeCdnDomainLogsRequest) {
	request = &DescribeCdnDomainLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnDomainLogs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnDomainLogsResponse creates a response to parse from DescribeCdnDomainLogs response
func CreateDescribeCdnDomainLogsResponse() (response *DescribeCdnDomainLogsResponse) {
	response = &DescribeCdnDomainLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
