package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOutboundNumbersOfUser invokes the ccc.ListOutboundNumbersOfUser API synchronously
func (client *Client) ListOutboundNumbersOfUser(request *ListOutboundNumbersOfUserRequest) (response *ListOutboundNumbersOfUserResponse, err error) {
	response = CreateListOutboundNumbersOfUserResponse()
	err = client.DoAction(request, response)
	return
}

// ListOutboundNumbersOfUserWithChan invokes the ccc.ListOutboundNumbersOfUser API asynchronously
func (client *Client) ListOutboundNumbersOfUserWithChan(request *ListOutboundNumbersOfUserRequest) (<-chan *ListOutboundNumbersOfUserResponse, <-chan error) {
	responseChan := make(chan *ListOutboundNumbersOfUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOutboundNumbersOfUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOutboundNumbersOfUserWithCallback invokes the ccc.ListOutboundNumbersOfUser API asynchronously
func (client *Client) ListOutboundNumbersOfUserWithCallback(request *ListOutboundNumbersOfUserRequest, callback func(response *ListOutboundNumbersOfUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOutboundNumbersOfUserResponse
		var err error
		defer close(result)
		response, err = client.ListOutboundNumbersOfUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOutboundNumbersOfUserRequest is the request struct for api ListOutboundNumbersOfUser
type ListOutboundNumbersOfUserRequest struct {
	*requests.RpcRequest
	UserId           string           `position:"Query" name:"UserId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	SkillGroupIdList string           `position:"Query" name:"SkillGroupIdList"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
}

// ListOutboundNumbersOfUserResponse is the response struct for api ListOutboundNumbersOfUser
type ListOutboundNumbersOfUserResponse struct {
	*responses.BaseResponse
	Code           string                          `json:"Code" xml:"Code"`
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                          `json:"Message" xml:"Message"`
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Data           DataInListOutboundNumbersOfUser `json:"Data" xml:"Data"`
}

// CreateListOutboundNumbersOfUserRequest creates a request to invoke ListOutboundNumbersOfUser API
func CreateListOutboundNumbersOfUserRequest() (request *ListOutboundNumbersOfUserRequest) {
	request = &ListOutboundNumbersOfUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListOutboundNumbersOfUser", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOutboundNumbersOfUserResponse creates a response to parse from ListOutboundNumbersOfUser response
func CreateListOutboundNumbersOfUserResponse() (response *ListOutboundNumbersOfUserResponse) {
	response = &ListOutboundNumbersOfUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
