package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVideo invokes the ccc.GetVideo API synchronously
func (client *Client) GetVideo(request *GetVideoRequest) (response *GetVideoResponse, err error) {
	response = CreateGetVideoResponse()
	err = client.DoAction(request, response)
	return
}

// GetVideoWithChan invokes the ccc.GetVideo API asynchronously
func (client *Client) GetVideoWithChan(request *GetVideoRequest) (<-chan *GetVideoResponse, <-chan error) {
	responseChan := make(chan *GetVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVideoWithCallback invokes the ccc.GetVideo API asynchronously
func (client *Client) GetVideoWithCallback(request *GetVideoRequest, callback func(response *GetVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVideoResponse
		var err error
		defer close(result)
		response, err = client.GetVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVideoRequest is the request struct for api GetVideo
type GetVideoRequest struct {
	*requests.RpcRequest
	ContactId  string `position:"Query" name:"ContactId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetVideoResponse is the response struct for api GetVideo
type GetVideoResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetVideoRequest creates a request to invoke GetVideo API
func CreateGetVideoRequest() (request *GetVideoRequest) {
	request = &GetVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetVideo", "CCC", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetVideoResponse creates a response to parse from GetVideo response
func CreateGetVideoResponse() (response *GetVideoResponse) {
	response = &GetVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
