package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DiscardEditingContactFlow invokes the ccc.DiscardEditingContactFlow API synchronously
func (client *Client) DiscardEditingContactFlow(request *DiscardEditingContactFlowRequest) (response *DiscardEditingContactFlowResponse, err error) {
	response = CreateDiscardEditingContactFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DiscardEditingContactFlowWithChan invokes the ccc.DiscardEditingContactFlow API asynchronously
func (client *Client) DiscardEditingContactFlowWithChan(request *DiscardEditingContactFlowRequest) (<-chan *DiscardEditingContactFlowResponse, <-chan error) {
	responseChan := make(chan *DiscardEditingContactFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DiscardEditingContactFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DiscardEditingContactFlowWithCallback invokes the ccc.DiscardEditingContactFlow API asynchronously
func (client *Client) DiscardEditingContactFlowWithCallback(request *DiscardEditingContactFlowRequest, callback func(response *DiscardEditingContactFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DiscardEditingContactFlowResponse
		var err error
		defer close(result)
		response, err = client.DiscardEditingContactFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DiscardEditingContactFlowRequest is the request struct for api DiscardEditingContactFlow
type DiscardEditingContactFlowRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	DraftId       string `position:"Query" name:"DraftId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// DiscardEditingContactFlowResponse is the response struct for api DiscardEditingContactFlow
type DiscardEditingContactFlowResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDiscardEditingContactFlowRequest creates a request to invoke DiscardEditingContactFlow API
func CreateDiscardEditingContactFlowRequest() (request *DiscardEditingContactFlowRequest) {
	request = &DiscardEditingContactFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "DiscardEditingContactFlow", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDiscardEditingContactFlowResponse creates a response to parse from DiscardEditingContactFlow response
func CreateDiscardEditingContactFlowResponse() (response *DiscardEditingContactFlowResponse) {
	response = &DiscardEditingContactFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
