package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveWirelessCloudConnectorFromGroup invokes the cc5g.RemoveWirelessCloudConnectorFromGroup API synchronously
func (client *Client) RemoveWirelessCloudConnectorFromGroup(request *RemoveWirelessCloudConnectorFromGroupRequest) (response *RemoveWirelessCloudConnectorFromGroupResponse, err error) {
	response = CreateRemoveWirelessCloudConnectorFromGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveWirelessCloudConnectorFromGroupWithChan invokes the cc5g.RemoveWirelessCloudConnectorFromGroup API asynchronously
func (client *Client) RemoveWirelessCloudConnectorFromGroupWithChan(request *RemoveWirelessCloudConnectorFromGroupRequest) (<-chan *RemoveWirelessCloudConnectorFromGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveWirelessCloudConnectorFromGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveWirelessCloudConnectorFromGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveWirelessCloudConnectorFromGroupWithCallback invokes the cc5g.RemoveWirelessCloudConnectorFromGroup API asynchronously
func (client *Client) RemoveWirelessCloudConnectorFromGroupWithCallback(request *RemoveWirelessCloudConnectorFromGroupRequest, callback func(response *RemoveWirelessCloudConnectorFromGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveWirelessCloudConnectorFromGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveWirelessCloudConnectorFromGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveWirelessCloudConnectorFromGroupRequest is the request struct for api RemoveWirelessCloudConnectorFromGroup
type RemoveWirelessCloudConnectorFromGroupRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorIds     *[]string        `position:"Query" name:"WirelessCloudConnectorIds"  type:"Repeated"`
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	DryRun                        requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
}

// RemoveWirelessCloudConnectorFromGroupResponse is the response struct for api RemoveWirelessCloudConnectorFromGroup
type RemoveWirelessCloudConnectorFromGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveWirelessCloudConnectorFromGroupRequest creates a request to invoke RemoveWirelessCloudConnectorFromGroup API
func CreateRemoveWirelessCloudConnectorFromGroupRequest() (request *RemoveWirelessCloudConnectorFromGroupRequest) {
	request = &RemoveWirelessCloudConnectorFromGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "RemoveWirelessCloudConnectorFromGroup", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveWirelessCloudConnectorFromGroupResponse creates a response to parse from RemoveWirelessCloudConnectorFromGroup response
func CreateRemoveWirelessCloudConnectorFromGroupResponse() (response *RemoveWirelessCloudConnectorFromGroupResponse) {
	response = &RemoveWirelessCloudConnectorFromGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
