package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenCc5gService invokes the cc5g.OpenCc5gService API synchronously
func (client *Client) OpenCc5gService(request *OpenCc5gServiceRequest) (response *OpenCc5gServiceResponse, err error) {
	response = CreateOpenCc5gServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenCc5gServiceWithChan invokes the cc5g.OpenCc5gService API asynchronously
func (client *Client) OpenCc5gServiceWithChan(request *OpenCc5gServiceRequest) (<-chan *OpenCc5gServiceResponse, <-chan error) {
	responseChan := make(chan *OpenCc5gServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenCc5gService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenCc5gServiceWithCallback invokes the cc5g.OpenCc5gService API asynchronously
func (client *Client) OpenCc5gServiceWithCallback(request *OpenCc5gServiceRequest, callback func(response *OpenCc5gServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenCc5gServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenCc5gService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenCc5gServiceRequest is the request struct for api OpenCc5gService
type OpenCc5gServiceRequest struct {
	*requests.RpcRequest
}

// OpenCc5gServiceResponse is the response struct for api OpenCc5gService
type OpenCc5gServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenCc5gServiceRequest creates a request to invoke OpenCc5gService API
func CreateOpenCc5gServiceRequest() (request *OpenCc5gServiceRequest) {
	request = &OpenCc5gServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "OpenCc5gService", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenCc5gServiceResponse creates a response to parse from OpenCc5gService response
func CreateOpenCc5gServiceResponse() (response *OpenCc5gServiceResponse) {
	response = &OpenCc5gServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
