package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterAvailableResource invokes the cbn.ListTransitRouterAvailableResource API synchronously
func (client *Client) ListTransitRouterAvailableResource(request *ListTransitRouterAvailableResourceRequest) (response *ListTransitRouterAvailableResourceResponse, err error) {
	response = CreateListTransitRouterAvailableResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterAvailableResourceWithChan invokes the cbn.ListTransitRouterAvailableResource API asynchronously
func (client *Client) ListTransitRouterAvailableResourceWithChan(request *ListTransitRouterAvailableResourceRequest) (<-chan *ListTransitRouterAvailableResourceResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterAvailableResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterAvailableResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterAvailableResourceWithCallback invokes the cbn.ListTransitRouterAvailableResource API asynchronously
func (client *Client) ListTransitRouterAvailableResourceWithCallback(request *ListTransitRouterAvailableResourceRequest, callback func(response *ListTransitRouterAvailableResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterAvailableResourceResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterAvailableResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterAvailableResourceRequest is the request struct for api ListTransitRouterAvailableResource
type ListTransitRouterAvailableResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SupportMulticast     requests.Boolean `position:"Query" name:"SupportMulticast"`
	Version              string           `position:"Query" name:"Version"`
}

// ListTransitRouterAvailableResourceResponse is the response struct for api ListTransitRouterAvailableResource
type ListTransitRouterAvailableResourceResponse struct {
	*responses.BaseResponse
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	SupportMulticast bool     `json:"SupportMulticast" xml:"SupportMulticast"`
	SlaveZones       []string `json:"SlaveZones" xml:"SlaveZones"`
	MasterZones      []string `json:"MasterZones" xml:"MasterZones"`
	AvailableZones   []string `json:"AvailableZones" xml:"AvailableZones"`
}

// CreateListTransitRouterAvailableResourceRequest creates a request to invoke ListTransitRouterAvailableResource API
func CreateListTransitRouterAvailableResourceRequest() (request *ListTransitRouterAvailableResourceRequest) {
	request = &ListTransitRouterAvailableResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterAvailableResource", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterAvailableResourceResponse creates a response to parse from ListTransitRouterAvailableResource response
func CreateListTransitRouterAvailableResourceResponse() (response *ListTransitRouterAvailableResourceResponse) {
	response = &ListTransitRouterAvailableResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
