package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserCertificateDetail invokes the cas.GetUserCertificateDetail API synchronously
func (client *Client) GetUserCertificateDetail(request *GetUserCertificateDetailRequest) (response *GetUserCertificateDetailResponse, err error) {
	response = CreateGetUserCertificateDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserCertificateDetailWithChan invokes the cas.GetUserCertificateDetail API asynchronously
func (client *Client) GetUserCertificateDetailWithChan(request *GetUserCertificateDetailRequest) (<-chan *GetUserCertificateDetailResponse, <-chan error) {
	responseChan := make(chan *GetUserCertificateDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserCertificateDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserCertificateDetailWithCallback invokes the cas.GetUserCertificateDetail API asynchronously
func (client *Client) GetUserCertificateDetailWithCallback(request *GetUserCertificateDetailRequest, callback func(response *GetUserCertificateDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserCertificateDetailResponse
		var err error
		defer close(result)
		response, err = client.GetUserCertificateDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserCertificateDetailRequest is the request struct for api GetUserCertificateDetail
type GetUserCertificateDetailRequest struct {
	*requests.RpcRequest
	CertId     requests.Integer `position:"Query" name:"CertId"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	CertFilter requests.Boolean `position:"Query" name:"CertFilter"`
}

// GetUserCertificateDetailResponse is the response struct for api GetUserCertificateDetail
type GetUserCertificateDetailResponse struct {
	*responses.BaseResponse
	Cert              string `json:"Cert" xml:"Cert"`
	Key               string `json:"Key" xml:"Key"`
	EncryptCert       string `json:"EncryptCert" xml:"EncryptCert"`
	EncryptPrivateKey string `json:"EncryptPrivateKey" xml:"EncryptPrivateKey"`
	SignCert          string `json:"SignCert" xml:"SignCert"`
	SignPrivateKey    string `json:"SignPrivateKey" xml:"SignPrivateKey"`
	Id                int64  `json:"Id" xml:"Id"`
	Name              string `json:"Name" xml:"Name"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Common            string `json:"Common" xml:"Common"`
	Fingerprint       string `json:"Fingerprint" xml:"Fingerprint"`
	Issuer            string `json:"Issuer" xml:"Issuer"`
	OrgName           string `json:"OrgName" xml:"OrgName"`
	Province          string `json:"Province" xml:"Province"`
	City              string `json:"City" xml:"City"`
	Country           string `json:"Country" xml:"Country"`
	StartDate         string `json:"StartDate" xml:"StartDate"`
	EndDate           string `json:"EndDate" xml:"EndDate"`
	Sans              string `json:"Sans" xml:"Sans"`
	Expired           bool   `json:"Expired" xml:"Expired"`
	BuyInAliyun       bool   `json:"BuyInAliyun" xml:"BuyInAliyun"`
	OrderId           int64  `json:"OrderId" xml:"OrderId"`
	ResourceGroupId   string `json:"ResourceGroupId" xml:"ResourceGroupId"`
	Algorithm         string `json:"Algorithm" xml:"Algorithm"`
}

// CreateGetUserCertificateDetailRequest creates a request to invoke GetUserCertificateDetail API
func CreateGetUserCertificateDetailRequest() (request *GetUserCertificateDetailRequest) {
	request = &GetUserCertificateDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "GetUserCertificateDetail", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserCertificateDetailResponse creates a response to parse from GetUserCertificateDetail response
func CreateGetUserCertificateDetailResponse() (response *GetUserCertificateDetailResponse) {
	response = &GetUserCertificateDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
