package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateIpSegment invokes the biz_ipdb.AllocateIpSegment API synchronously
func (client *Client) AllocateIpSegment(request *AllocateIpSegmentRequest) (response *AllocateIpSegmentResponse, err error) {
	response = CreateAllocateIpSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateIpSegmentWithChan invokes the biz_ipdb.AllocateIpSegment API asynchronously
func (client *Client) AllocateIpSegmentWithChan(request *AllocateIpSegmentRequest) (<-chan *AllocateIpSegmentResponse, <-chan error) {
	responseChan := make(chan *AllocateIpSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateIpSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateIpSegmentWithCallback invokes the biz_ipdb.AllocateIpSegment API asynchronously
func (client *Client) AllocateIpSegmentWithCallback(request *AllocateIpSegmentRequest, callback func(response *AllocateIpSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateIpSegmentResponse
		var err error
		defer close(result)
		response, err = client.AllocateIpSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateIpSegmentRequest is the request struct for api AllocateIpSegment
type AllocateIpSegmentRequest struct {
	*requests.RpcRequest
	LocationNo   string `position:"Query" name:"LocationNo"`
	Submitter    string `position:"Query" name:"Submitter"`
	Segment      string `position:"Query" name:"Segment"`
	LocationType string `position:"Query" name:"LocationType"`
	IpType       string `position:"Query" name:"IpType"`
	BizLine      string `position:"Query" name:"BizLine"`
}

// AllocateIpSegmentResponse is the response struct for api AllocateIpSegment
type AllocateIpSegmentResponse struct {
	*responses.BaseResponse
	Id        int64  `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateIpSegmentRequest creates a request to invoke AllocateIpSegment API
func CreateAllocateIpSegmentRequest() (request *AllocateIpSegmentRequest) {
	request = &AllocateIpSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "AllocateIpSegment", "", "")
	request.Method = requests.POST
	return
}

// CreateAllocateIpSegmentResponse creates a response to parse from AllocateIpSegment response
func CreateAllocateIpSegmentResponse() (response *AllocateIpSegmentResponse) {
	response = &AllocateIpSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
