package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccessorDomainList invokes the beian.QueryAccessorDomainList API synchronously
func (client *Client) QueryAccessorDomainList(request *QueryAccessorDomainListRequest) (response *QueryAccessorDomainListResponse, err error) {
	response = CreateQueryAccessorDomainListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccessorDomainListWithChan invokes the beian.QueryAccessorDomainList API asynchronously
func (client *Client) QueryAccessorDomainListWithChan(request *QueryAccessorDomainListRequest) (<-chan *QueryAccessorDomainListResponse, <-chan error) {
	responseChan := make(chan *QueryAccessorDomainListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccessorDomainList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccessorDomainListWithCallback invokes the beian.QueryAccessorDomainList API asynchronously
func (client *Client) QueryAccessorDomainListWithCallback(request *QueryAccessorDomainListRequest, callback func(response *QueryAccessorDomainListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccessorDomainListResponse
		var err error
		defer close(result)
		response, err = client.QueryAccessorDomainList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccessorDomainListRequest is the request struct for api QueryAccessorDomainList
type QueryAccessorDomainListRequest struct {
	*requests.RpcRequest
	Caller   string           `position:"Query" name:"Caller"`
	PageNo   requests.Integer `position:"Query" name:"PageNo"`
	Domain   string           `position:"Query" name:"Domain"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// QueryAccessorDomainListResponse is the response struct for api QueryAccessorDomainList
type QueryAccessorDomainListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAccessorDomainListRequest creates a request to invoke QueryAccessorDomainList API
func CreateQueryAccessorDomainListRequest() (request *QueryAccessorDomainListRequest) {
	request = &QueryAccessorDomainListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "QueryAccessorDomainList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAccessorDomainListResponse creates a response to parse from QueryAccessorDomainList response
func CreateQueryAccessorDomainListResponse() (response *QueryAccessorDomainListResponse) {
	response = &QueryAccessorDomainListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
