package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricChannel invokes the baas.CreateFabricChannel API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricchannel.html
func (client *Client) CreateFabricChannel(request *CreateFabricChannelRequest) (response *CreateFabricChannelResponse, err error) {
	response = CreateCreateFabricChannelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricChannelWithChan invokes the baas.CreateFabricChannel API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricchannel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricChannelWithChan(request *CreateFabricChannelRequest) (<-chan *CreateFabricChannelResponse, <-chan error) {
	responseChan := make(chan *CreateFabricChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricChannelWithCallback invokes the baas.CreateFabricChannel API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricchannel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricChannelWithCallback(request *CreateFabricChannelRequest, callback func(response *CreateFabricChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricChannelResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricChannelRequest is the request struct for api CreateFabricChannel
type CreateFabricChannelRequest struct {
	*requests.RpcRequest
	PreferredMaxBytes requests.Integer                   `position:"Body" name:"PreferredMaxBytes"`
	MaxMessageCount   requests.Integer                   `position:"Body" name:"MaxMessageCount"`
	ChannelName       string                             `position:"Query" name:"ChannelName"`
	Organization      *[]CreateFabricChannelOrganization `position:"Query" name:"Organization"  type:"Repeated"`
	BatchTimeout      requests.Integer                   `position:"Body" name:"BatchTimeout"`
	ConsortiumId      string                             `position:"Query" name:"ConsortiumId"`
}

// CreateFabricChannelOrganization is a repeated param struct in CreateFabricChannelRequest
type CreateFabricChannelOrganization struct {
	Id string `name:"Id"`
}

// CreateFabricChannelResponse is the response struct for api CreateFabricChannel
type CreateFabricChannelResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Success   bool                        `json:"Success" xml:"Success"`
	ErrorCode int                         `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInCreateFabricChannel `json:"Result" xml:"Result"`
}

// CreateCreateFabricChannelRequest creates a request to invoke CreateFabricChannel API
func CreateCreateFabricChannelRequest() (request *CreateFabricChannelRequest) {
	request = &CreateFabricChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricChannel", "baas", "openAPI")
	return
}

// CreateCreateFabricChannelResponse creates a response to parse from CreateFabricChannel response
func CreateCreateFabricChannelResponse() (response *CreateFabricChannelResponse) {
	response = &CreateFabricChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
