package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelVideoTask invokes the avatar.CancelVideoTask API synchronously
func (client *Client) CancelVideoTask(request *CancelVideoTaskRequest) (response *CancelVideoTaskResponse, err error) {
	response = CreateCancelVideoTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CancelVideoTaskWithChan invokes the avatar.CancelVideoTask API asynchronously
func (client *Client) CancelVideoTaskWithChan(request *CancelVideoTaskRequest) (<-chan *CancelVideoTaskResponse, <-chan error) {
	responseChan := make(chan *CancelVideoTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelVideoTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelVideoTaskWithCallback invokes the avatar.CancelVideoTask API asynchronously
func (client *Client) CancelVideoTaskWithCallback(request *CancelVideoTaskRequest, callback func(response *CancelVideoTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelVideoTaskResponse
		var err error
		defer close(result)
		response, err = client.CancelVideoTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelVideoTaskRequest is the request struct for api CancelVideoTask
type CancelVideoTaskRequest struct {
	*requests.RpcRequest
	App      CancelVideoTaskApp `position:"Query" name:"App"  type:"Struct"`
	TenantId requests.Integer   `position:"Query" name:"TenantId"`
	TaskUuid string             `position:"Query" name:"TaskUuid"`
}

// CancelVideoTaskApp is a repeated param struct in CancelVideoTaskRequest
type CancelVideoTaskApp struct {
	AppId string `name:"AppId"`
}

// CancelVideoTaskResponse is the response struct for api CancelVideoTask
type CancelVideoTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCancelVideoTaskRequest creates a request to invoke CancelVideoTask API
func CreateCancelVideoTaskRequest() (request *CancelVideoTaskRequest) {
	request = &CancelVideoTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "CancelVideoTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelVideoTaskResponse creates a response to parse from CancelVideoTask response
func CreateCancelVideoTaskResponse() (response *CancelVideoTaskResponse) {
	response = &CancelVideoTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
