package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMigrationGroup invokes the apds.CreateMigrationGroup API synchronously
func (client *Client) CreateMigrationGroup(request *CreateMigrationGroupRequest) (response *CreateMigrationGroupResponse, err error) {
	response = CreateCreateMigrationGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMigrationGroupWithChan invokes the apds.CreateMigrationGroup API asynchronously
func (client *Client) CreateMigrationGroupWithChan(request *CreateMigrationGroupRequest) (<-chan *CreateMigrationGroupResponse, <-chan error) {
	responseChan := make(chan *CreateMigrationGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMigrationGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMigrationGroupWithCallback invokes the apds.CreateMigrationGroup API asynchronously
func (client *Client) CreateMigrationGroupWithCallback(request *CreateMigrationGroupRequest, callback func(response *CreateMigrationGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMigrationGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateMigrationGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMigrationGroupRequest is the request struct for api CreateMigrationGroup
type CreateMigrationGroupRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateMigrationGroupResponse is the response struct for api CreateMigrationGroup
type CreateMigrationGroupResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"Error" xml:"Error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateCreateMigrationGroupRequest creates a request to invoke CreateMigrationGroup API
func CreateCreateMigrationGroupRequest() (request *CreateMigrationGroupRequest) {
	request = &CreateMigrationGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "CreateMigrationGroup", "/okss-services/migration-group/save-migration-group", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMigrationGroupResponse creates a response to parse from CreateMigrationGroup response
func CreateCreateMigrationGroupResponse() (response *CreateMigrationGroupResponse) {
	response = &CreateMigrationGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
