package antiddos_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDdosCount invokes the antiddos_public.DescribeDdosCount API synchronously
func (client *Client) DescribeDdosCount(request *DescribeDdosCountRequest) (response *DescribeDdosCountResponse, err error) {
	response = CreateDescribeDdosCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDdosCountWithChan invokes the antiddos_public.DescribeDdosCount API asynchronously
func (client *Client) DescribeDdosCountWithChan(request *DescribeDdosCountRequest) (<-chan *DescribeDdosCountResponse, <-chan error) {
	responseChan := make(chan *DescribeDdosCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDdosCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDdosCountWithCallback invokes the antiddos_public.DescribeDdosCount API asynchronously
func (client *Client) DescribeDdosCountWithCallback(request *DescribeDdosCountRequest, callback func(response *DescribeDdosCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDdosCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeDdosCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDdosCountRequest is the request struct for api DescribeDdosCount
type DescribeDdosCountRequest struct {
	*requests.RpcRequest
	SourceIp     string `position:"Query" name:"SourceIp"`
	DdosRegionId string `position:"Query" name:"DdosRegionId"`
	InstanceType string `position:"Query" name:"InstanceType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDdosCountResponse is the response struct for api DescribeDdosCount
type DescribeDdosCountResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	DdosCount DdosCount `json:"DdosCount" xml:"DdosCount"`
}

// CreateDescribeDdosCountRequest creates a request to invoke DescribeDdosCount API
func CreateDescribeDdosCountRequest() (request *DescribeDdosCountRequest) {
	request = &DescribeDdosCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("antiddos-public", "2017-05-18", "DescribeDdosCount", "ddosbasic", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDdosCountResponse creates a response to parse from DescribeDdosCount response
func CreateDescribeDdosCountResponse() (response *DescribeDdosCountResponse) {
	response = &DescribeDdosCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
