package antiddos_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCap invokes the antiddos_public.DescribeCap API synchronously
func (client *Client) DescribeCap(request *DescribeCapRequest) (response *DescribeCapResponse, err error) {
	response = CreateDescribeCapResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCapWithChan invokes the antiddos_public.DescribeCap API asynchronously
func (client *Client) DescribeCapWithChan(request *DescribeCapRequest) (<-chan *DescribeCapResponse, <-chan error) {
	responseChan := make(chan *DescribeCapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCapWithCallback invokes the antiddos_public.DescribeCap API asynchronously
func (client *Client) DescribeCapWithCallback(request *DescribeCapRequest, callback func(response *DescribeCapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCapResponse
		var err error
		defer close(result)
		response, err = client.DescribeCap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCapRequest is the request struct for api DescribeCap
type DescribeCapRequest struct {
	*requests.RpcRequest
	InternetIp   string           `position:"Query" name:"InternetIp"`
	BegTime      requests.Integer `position:"Query" name:"BegTime"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	DdosRegionId string           `position:"Query" name:"DdosRegionId"`
	InstanceType string           `position:"Query" name:"InstanceType"`
	Lang         string           `position:"Query" name:"Lang"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
}

// DescribeCapResponse is the response struct for api DescribeCap
type DescribeCapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CapUrl    CapUrl `json:"CapUrl" xml:"CapUrl"`
}

// CreateDescribeCapRequest creates a request to invoke DescribeCap API
func CreateDescribeCapRequest() (request *DescribeCapRequest) {
	request = &DescribeCapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("antiddos-public", "2017-05-18", "DescribeCap", "ddosbasic", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCapResponse creates a response to parse from DescribeCap response
func CreateDescribeCapResponse() (response *DescribeCapResponse) {
	response = &DescribeCapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
