package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Asadasdasd invokes the amp.Asadasdasd API synchronously
func (client *Client) Asadasdasd(request *AsadasdasdRequest) (response *AsadasdasdResponse, err error) {
	response = CreateAsadasdasdResponse()
	err = client.DoAction(request, response)
	return
}

// AsadasdasdWithChan invokes the amp.Asadasdasd API asynchronously
func (client *Client) AsadasdasdWithChan(request *AsadasdasdRequest) (<-chan *AsadasdasdResponse, <-chan error) {
	responseChan := make(chan *AsadasdasdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Asadasdasd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AsadasdasdWithCallback invokes the amp.Asadasdasd API asynchronously
func (client *Client) AsadasdasdWithCallback(request *AsadasdasdRequest, callback func(response *AsadasdasdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AsadasdasdResponse
		var err error
		defer close(result)
		response, err = client.Asadasdasd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AsadasdasdRequest is the request struct for api Asadasdasd
type AsadasdasdRequest struct {
	*requests.RoaRequest
	A string `position:"Query" name:"A"`
}

// AsadasdasdResponse is the response struct for api Asadasdasd
type AsadasdasdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateAsadasdasdRequest creates a request to invoke Asadasdasd API
func CreateAsadasdasdRequest() (request *AsadasdasdRequest) {
	request = &AsadasdasdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "Asadasdasd", "/asdxzc", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAsadasdasdResponse creates a response to parse from Asadasdasd response
func CreateAsadasdasdResponse() (response *AsadasdasdResponse) {
	response = &AsadasdasdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
