package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserInternational invokes the aliyuncvc.CreateUserInternational API synchronously
func (client *Client) CreateUserInternational(request *CreateUserInternationalRequest) (response *CreateUserInternationalResponse, err error) {
	response = CreateCreateUserInternationalResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserInternationalWithChan invokes the aliyuncvc.CreateUserInternational API asynchronously
func (client *Client) CreateUserInternationalWithChan(request *CreateUserInternationalRequest) (<-chan *CreateUserInternationalResponse, <-chan error) {
	responseChan := make(chan *CreateUserInternationalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserInternational(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserInternationalWithCallback invokes the aliyuncvc.CreateUserInternational API asynchronously
func (client *Client) CreateUserInternationalWithCallback(request *CreateUserInternationalRequest, callback func(response *CreateUserInternationalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserInternationalResponse
		var err error
		defer close(result)
		response, err = client.CreateUserInternational(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserInternationalRequest is the request struct for api CreateUserInternational
type CreateUserInternationalRequest struct {
	*requests.RpcRequest
	Count    requests.Integer `position:"Body" name:"Count"`
	UserInfo string           `position:"Body" name:"UserInfo"`
}

// CreateUserInternationalResponse is the response struct for api CreateUserInternational
type CreateUserInternationalResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	UserId    string `json:"UserId" xml:"UserId"`
}

// CreateCreateUserInternationalRequest creates a request to invoke CreateUserInternational API
func CreateCreateUserInternationalRequest() (request *CreateUserInternationalRequest) {
	request = &CreateUserInternationalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "CreateUserInternational", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateUserInternationalResponse creates a response to parse from CreateUserInternational response
func CreateCreateUserInternationalResponse() (response *CreateUserInternationalResponse) {
	response = &CreateUserInternationalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
