package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHealthCheckTemplate invokes the alb.CreateHealthCheckTemplate API synchronously
func (client *Client) CreateHealthCheckTemplate(request *CreateHealthCheckTemplateRequest) (response *CreateHealthCheckTemplateResponse, err error) {
	response = CreateCreateHealthCheckTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHealthCheckTemplateWithChan invokes the alb.CreateHealthCheckTemplate API asynchronously
func (client *Client) CreateHealthCheckTemplateWithChan(request *CreateHealthCheckTemplateRequest) (<-chan *CreateHealthCheckTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateHealthCheckTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHealthCheckTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHealthCheckTemplateWithCallback invokes the alb.CreateHealthCheckTemplate API asynchronously
func (client *Client) CreateHealthCheckTemplateWithCallback(request *CreateHealthCheckTemplateRequest, callback func(response *CreateHealthCheckTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHealthCheckTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateHealthCheckTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHealthCheckTemplateRequest is the request struct for api CreateHealthCheckTemplate
type CreateHealthCheckTemplateRequest struct {
	*requests.RpcRequest
	HealthCheckTimeout             requests.Integer                `position:"Query" name:"HealthCheckTimeout"`
	ClientToken                    string                          `position:"Query" name:"ClientToken"`
	HealthCheckProtocol            string                          `position:"Query" name:"HealthCheckProtocol"`
	UnhealthyThreshold             requests.Integer                `position:"Query" name:"UnhealthyThreshold"`
	HealthyThreshold               requests.Integer                `position:"Query" name:"HealthyThreshold"`
	HealthCheckTcpFastCloseEnabled requests.Boolean                `position:"Query" name:"HealthCheckTcpFastCloseEnabled"`
	HealthCheckPath                string                          `position:"Query" name:"HealthCheckPath"`
	Tag                            *[]CreateHealthCheckTemplateTag `position:"Query" name:"Tag"  type:"Repeated"`
	HealthCheckCodes               *[]string                       `position:"Query" name:"HealthCheckCodes"  type:"Repeated"`
	DryRun                         requests.Boolean                `position:"Query" name:"DryRun"`
	HealthCheckMethod              string                          `position:"Query" name:"HealthCheckMethod"`
	HealthCheckHost                string                          `position:"Query" name:"HealthCheckHost"`
	HealthCheckInterval            requests.Integer                `position:"Query" name:"HealthCheckInterval"`
	HealthCheckTemplateName        string                          `position:"Query" name:"HealthCheckTemplateName"`
	HealthCheckHttpCodes           *[]string                       `position:"Query" name:"HealthCheckHttpCodes"  type:"Repeated"`
	HealthCheckHttpVersion         string                          `position:"Query" name:"HealthCheckHttpVersion"`
	HealthCheckConnectPort         requests.Integer                `position:"Query" name:"HealthCheckConnectPort"`
}

// CreateHealthCheckTemplateTag is a repeated param struct in CreateHealthCheckTemplateRequest
type CreateHealthCheckTemplateTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateHealthCheckTemplateResponse is the response struct for api CreateHealthCheckTemplate
type CreateHealthCheckTemplateResponse struct {
	*responses.BaseResponse
	HealthCheckTemplateId string `json:"HealthCheckTemplateId" xml:"HealthCheckTemplateId"`
	RequestId             string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateHealthCheckTemplateRequest creates a request to invoke CreateHealthCheckTemplate API
func CreateCreateHealthCheckTemplateRequest() (request *CreateHealthCheckTemplateRequest) {
	request = &CreateHealthCheckTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "CreateHealthCheckTemplate", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateHealthCheckTemplateResponse creates a response to parse from CreateHealthCheckTemplate response
func CreateCreateHealthCheckTemplateResponse() (response *CreateHealthCheckTemplateResponse) {
	response = &CreateHealthCheckTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
