package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMember invokes the aiworkspace.GetMember API synchronously
func (client *Client) GetMember(request *GetMemberRequest) (response *GetMemberResponse, err error) {
	response = CreateGetMemberResponse()
	err = client.DoAction(request, response)
	return
}

// GetMemberWithChan invokes the aiworkspace.GetMember API asynchronously
func (client *Client) GetMemberWithChan(request *GetMemberRequest) (<-chan *GetMemberResponse, <-chan error) {
	responseChan := make(chan *GetMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMemberWithCallback invokes the aiworkspace.GetMember API asynchronously
func (client *Client) GetMemberWithCallback(request *GetMemberRequest, callback func(response *GetMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMemberResponse
		var err error
		defer close(result)
		response, err = client.GetMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMemberRequest is the request struct for api GetMember
type GetMemberRequest struct {
	*requests.RoaRequest
	UserId      string `position:"Query" name:"UserId"`
	WorkspaceId string `position:"Path" name:"WorkspaceId"`
}

// GetMemberResponse is the response struct for api GetMember
type GetMemberResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	UserId        string   `json:"UserId" xml:"UserId"`
	MemberName    string   `json:"MemberName" xml:"MemberName"`
	GmtCreateTime string   `json:"GmtCreateTime" xml:"GmtCreateTime"`
	DisplayName   string   `json:"DisplayName" xml:"DisplayName"`
	MemberId      string   `json:"MemberId" xml:"MemberId"`
	Roles         []string `json:"Roles" xml:"Roles"`
}

// CreateGetMemberRequest creates a request to invoke GetMember API
func CreateGetMemberRequest() (request *GetMemberRequest) {
	request = &GetMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "GetMember", "/api/v1/workspaces/[WorkspaceId]/member", "", "")
	request.Method = requests.GET
	return
}

// CreateGetMemberResponse creates a response to parse from GetMember response
func CreateGetMemberResponse() (response *GetMemberResponse) {
	response = &GetMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
