package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableFlowRule invokes the ahas_openapi.EnableFlowRule API synchronously
func (client *Client) EnableFlowRule(request *EnableFlowRuleRequest) (response *EnableFlowRuleResponse, err error) {
	response = CreateEnableFlowRuleResponse()
	err = client.DoAction(request, response)
	return
}

// EnableFlowRuleWithChan invokes the ahas_openapi.EnableFlowRule API asynchronously
func (client *Client) EnableFlowRuleWithChan(request *EnableFlowRuleRequest) (<-chan *EnableFlowRuleResponse, <-chan error) {
	responseChan := make(chan *EnableFlowRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableFlowRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableFlowRuleWithCallback invokes the ahas_openapi.EnableFlowRule API asynchronously
func (client *Client) EnableFlowRuleWithCallback(request *EnableFlowRuleRequest, callback func(response *EnableFlowRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableFlowRuleResponse
		var err error
		defer close(result)
		response, err = client.EnableFlowRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableFlowRuleRequest is the request struct for api EnableFlowRule
type EnableFlowRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// EnableFlowRuleResponse is the response struct for api EnableFlowRule
type EnableFlowRuleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEnableFlowRuleRequest creates a request to invoke EnableFlowRule API
func CreateEnableFlowRuleRequest() (request *EnableFlowRuleRequest) {
	request = &EnableFlowRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "EnableFlowRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableFlowRuleResponse creates a response to parse from EnableFlowRule response
func CreateEnableFlowRuleResponse() (response *EnableFlowRuleResponse) {
	response = &EnableFlowRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
