package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBResourceGroup invokes the adb.CreateDBResourceGroup API synchronously
func (client *Client) CreateDBResourceGroup(request *CreateDBResourceGroupRequest) (response *CreateDBResourceGroupResponse, err error) {
	response = CreateCreateDBResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBResourceGroupWithChan invokes the adb.CreateDBResourceGroup API asynchronously
func (client *Client) CreateDBResourceGroupWithChan(request *CreateDBResourceGroupRequest) (<-chan *CreateDBResourceGroupResponse, <-chan error) {
	responseChan := make(chan *CreateDBResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBResourceGroupWithCallback invokes the adb.CreateDBResourceGroup API asynchronously
func (client *Client) CreateDBResourceGroupWithCallback(request *CreateDBResourceGroupRequest, callback func(response *CreateDBResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateDBResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBResourceGroupRequest is the request struct for api CreateDBResourceGroup
type CreateDBResourceGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NodeNum              requests.Integer `position:"Query" name:"NodeNum"`
	GroupType            string           `position:"Query" name:"GroupType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	GroupName            string           `position:"Query" name:"GroupName"`
}

// CreateDBResourceGroupResponse is the response struct for api CreateDBResourceGroup
type CreateDBResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDBResourceGroupRequest creates a request to invoke CreateDBResourceGroup API
func CreateCreateDBResourceGroupRequest() (request *CreateDBResourceGroupRequest) {
	request = &CreateDBResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "CreateDBResourceGroup", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDBResourceGroupResponse creates a response to parse from CreateDBResourceGroup response
func CreateCreateDBResourceGroupResponse() (response *CreateDBResourceGroupResponse) {
	response = &CreateDBResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
