// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/datalabeling/v1beta1/evaluation_job.proto

package datalabelingpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the job.
type EvaluationJob_State int32

const (
	EvaluationJob_STATE_UNSPECIFIED EvaluationJob_State = 0
	// The job is scheduled to run at the [configured interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. You
	// can [pause][google.cloud.datalabeling.v1beta1.DataLabelingService.PauseEvaluationJob] or
	// [delete][google.cloud.datalabeling.v1beta1.DataLabelingService.DeleteEvaluationJob] the job.
	//
	// When the job is in this state, it samples prediction input and output
	// from your model version into your BigQuery table as predictions occur.
	EvaluationJob_SCHEDULED EvaluationJob_State = 1
	// The job is currently running. When the job runs, Data Labeling Service
	// does several things:
	//
	//  1. If you have configured your job to use Data Labeling Service for
	//     ground truth labeling, the service creates a
	//     [Dataset][google.cloud.datalabeling.v1beta1.Dataset] and a labeling task for all data sampled
	//     since the last time the job ran. Human labelers provide ground truth
	//     labels for your data. Human labeling may take hours, or even days,
	//     depending on how much data has been sampled. The job remains in the
	//     `RUNNING` state during this time, and it can even be running multiple
	//     times in parallel if it gets triggered again (for example 24 hours
	//     later) before the earlier run has completed. When human labelers have
	//     finished labeling the data, the next step occurs.
	//     <br><br>
	//     If you have configured your job to provide your own ground truth
	//     labels, Data Labeling Service still creates a [Dataset][google.cloud.datalabeling.v1beta1.Dataset] for newly
	//     sampled data, but it expects that you have already added ground truth
	//     labels to the BigQuery table by this time. The next step occurs
	//     immediately.
	//
	//  2. Data Labeling Service creates an [Evaluation][google.cloud.datalabeling.v1beta1.Evaluation] by comparing your
	//     model version's predictions with the ground truth labels.
	//
	// If the job remains in this state for a long time, it continues to sample
	// prediction data into your BigQuery table and will run again at the next
	// interval, even if it causes the job to run multiple times in parallel.
	EvaluationJob_RUNNING EvaluationJob_State = 2
	// The job is not sampling prediction input and output into your BigQuery
	// table and it will not run according to its schedule. You can
	// [resume][google.cloud.datalabeling.v1beta1.DataLabelingService.ResumeEvaluationJob] the job.
	EvaluationJob_PAUSED EvaluationJob_State = 3
	// The job has this state right before it is deleted.
	EvaluationJob_STOPPED EvaluationJob_State = 4
)

// Enum value maps for EvaluationJob_State.
var (
	EvaluationJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SCHEDULED",
		2: "RUNNING",
		3: "PAUSED",
		4: "STOPPED",
	}
	EvaluationJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SCHEDULED":         1,
		"RUNNING":           2,
		"PAUSED":            3,
		"STOPPED":           4,
	}
)

func (x EvaluationJob_State) Enum() *EvaluationJob_State {
	p := new(EvaluationJob_State)
	*p = x
	return p
}

func (x EvaluationJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EvaluationJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_enumTypes[0].Descriptor()
}

func (EvaluationJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_enumTypes[0]
}

func (x EvaluationJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EvaluationJob_State.Descriptor instead.
func (EvaluationJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescGZIP(), []int{0, 0}
}

// Defines an evaluation job that runs periodically to generate
// [Evaluations][google.cloud.datalabeling.v1beta1.Evaluation]. [Creating an evaluation
// job](/ml-engine/docs/continuous-evaluation/create-job) is the starting point
// for using continuous evaluation.
type EvaluationJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. After you create a job, Data Labeling Service assigns a name
	// to the job with the following format:
	//
	// "projects/<var>{project_id}</var>/evaluationJobs/<var>{evaluation_job_id}</var>"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Description of the job. The description can be up to 25,000
	// characters long.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Describes the current state of the job.
	State EvaluationJob_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.datalabeling.v1beta1.EvaluationJob_State" json:"state,omitempty"`
	// Required. Describes the interval at which the job runs. This interval must
	// be at least 1 day, and it is rounded to the nearest day. For example, if
	// you specify a 50-hour interval, the job runs every 2 days.
	//
	// You can provide the schedule in
	// [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
	// [English-like
	// format](/appengine/docs/standard/python/config/cronref#schedule_format).
	//
	// Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
	// interval from this schedule is used, not the specific time of day.
	Schedule string `protobuf:"bytes,4,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Required. The [AI Platform Prediction model
	// version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
	// input and output is sampled from this model version. When creating an
	// evaluation job, specify the model version in the following format:
	//
	// "projects/<var>{project_id}</var>/models/<var>{model_name}</var>/versions/<var>{version_name}</var>"
	//
	// There can only be one evaluation job per model version.
	ModelVersion string `protobuf:"bytes,5,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	// Required. Configuration details for the evaluation job.
	EvaluationJobConfig *EvaluationJobConfig `protobuf:"bytes,6,opt,name=evaluation_job_config,json=evaluationJobConfig,proto3" json:"evaluation_job_config,omitempty"`
	// Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
	// labels that your machine learning model outputs. You must create this
	// resource before you create an evaluation job and provide its name in the
	// following format:
	//
	// "projects/<var>{project_id}</var>/annotationSpecSets/<var>{annotation_spec_set_id}</var>"
	AnnotationSpecSet string `protobuf:"bytes,7,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Required. Whether you want Data Labeling Service to provide ground truth
	// labels for prediction input. If you want the service to assign human
	// labelers to annotate your data, set this to `true`. If you want to provide
	// your own ground truth labels in the evaluation job's BigQuery table, set
	// this to `false`.
	LabelMissingGroundTruth bool `protobuf:"varint,8,opt,name=label_missing_ground_truth,json=labelMissingGroundTruth,proto3" json:"label_missing_ground_truth,omitempty"`
	// Output only. Every time the evaluation job runs and an error occurs, the
	// failed attempt is appended to this array.
	Attempts []*Attempt `protobuf:"bytes,9,rep,name=attempts,proto3" json:"attempts,omitempty"`
	// Output only. Timestamp of when this evaluation job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *EvaluationJob) Reset() {
	*x = EvaluationJob{}
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluationJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationJob) ProtoMessage() {}

func (x *EvaluationJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationJob.ProtoReflect.Descriptor instead.
func (*EvaluationJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescGZIP(), []int{0}
}

func (x *EvaluationJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EvaluationJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EvaluationJob) GetState() EvaluationJob_State {
	if x != nil {
		return x.State
	}
	return EvaluationJob_STATE_UNSPECIFIED
}

func (x *EvaluationJob) GetSchedule() string {
	if x != nil {
		return x.Schedule
	}
	return ""
}

func (x *EvaluationJob) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

func (x *EvaluationJob) GetEvaluationJobConfig() *EvaluationJobConfig {
	if x != nil {
		return x.EvaluationJobConfig
	}
	return nil
}

func (x *EvaluationJob) GetAnnotationSpecSet() string {
	if x != nil {
		return x.AnnotationSpecSet
	}
	return ""
}

func (x *EvaluationJob) GetLabelMissingGroundTruth() bool {
	if x != nil {
		return x.LabelMissingGroundTruth
	}
	return false
}

func (x *EvaluationJob) GetAttempts() []*Attempt {
	if x != nil {
		return x.Attempts
	}
	return nil
}

func (x *EvaluationJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Configures specific details of how a continuous evaluation job works. Provide
// this configuration when you create an EvaluationJob.
type EvaluationJobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Details for how you want human reviewers to provide ground truth
	// labels.
	//
	// Types that are assignable to HumanAnnotationRequestConfig:
	//
	//	*EvaluationJobConfig_ImageClassificationConfig
	//	*EvaluationJobConfig_BoundingPolyConfig
	//	*EvaluationJobConfig_TextClassificationConfig
	HumanAnnotationRequestConfig isEvaluationJobConfig_HumanAnnotationRequestConfig `protobuf_oneof:"human_annotation_request_config"`
	// Rquired. Details for the sampled prediction input. Within this
	// configuration, there are requirements for several fields:
	//
	//   - `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
	//   - `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
	//     `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
	//     or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
	//   - If your machine learning model performs classification, you must specify
	//     `classificationMetadata.isMultiLabel`.
	//   - You must specify `bigquerySource` (not `gcsSource`).
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. Details for calculating evaluation metrics and creating
	// [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
	// detection, you must specify the `boundingBoxEvaluationOptions` field within
	// this configuration. Otherwise, provide an empty object for this
	// configuration.
	EvaluationConfig *EvaluationConfig `protobuf:"bytes,2,opt,name=evaluation_config,json=evaluationConfig,proto3" json:"evaluation_config,omitempty"`
	// Optional. Details for human annotation of your data. If you set
	// [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
	// `true` for this evaluation job, then you must specify this field. If you
	// plan to provide your own ground truth labels, then omit this field.
	//
	// Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
	// specify this field. Provide the name of the instruction resource in the
	// `instruction` field within this configuration.
	HumanAnnotationConfig *HumanAnnotationConfig `protobuf:"bytes,3,opt,name=human_annotation_config,json=humanAnnotationConfig,proto3" json:"human_annotation_config,omitempty"`
	// Required. Prediction keys that tell Data Labeling Service where to find the
	// data for evaluation in your BigQuery table. When the service samples
	// prediction input and output from your model version and saves it to
	// BigQuery, the data gets stored as JSON strings in the BigQuery table. These
	// keys tell Data Labeling Service how to parse the JSON.
	//
	// You can provide the following entries in this field:
	//
	//   - `data_json_key`: the data key for prediction input. You must provide
	//     either this key or `reference_json_key`.
	//   - `reference_json_key`: the data reference key for prediction input. You
	//     must provide either this key or `data_json_key`.
	//   - `label_json_key`: the label key for prediction output. Required.
	//   - `label_score_json_key`: the score key for prediction output. Required.
	//   - `bounding_box_json_key`: the bounding box key for prediction output.
	//     Required if your model version perform image object detection.
	//
	// Learn [how to configure prediction
	// keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
	BigqueryImportKeys map[string]string `protobuf:"bytes,9,rep,name=bigquery_import_keys,json=bigqueryImportKeys,proto3" json:"bigquery_import_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The maximum number of predictions to sample and save to BigQuery
	// during each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. This limit
	// overrides `example_sample_percentage`: even if the service has not sampled
	// enough predictions to fulfill `example_sample_perecentage` during an
	// interval, it stops sampling predictions when it meets this limit.
	ExampleCount int32 `protobuf:"varint,10,opt,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty"`
	// Required. Fraction of predictions to sample and save to BigQuery during
	// each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. For example, 0.1 means
	// 10% of predictions served by your model version get saved to BigQuery.
	ExampleSamplePercentage float64 `protobuf:"fixed64,11,opt,name=example_sample_percentage,json=exampleSamplePercentage,proto3" json:"example_sample_percentage,omitempty"`
	// Optional. Configuration details for evaluation job alerts. Specify this
	// field if you want to receive email alerts if the evaluation job finds that
	// your predictions have low mean average precision during a run.
	EvaluationJobAlertConfig *EvaluationJobAlertConfig `protobuf:"bytes,13,opt,name=evaluation_job_alert_config,json=evaluationJobAlertConfig,proto3" json:"evaluation_job_alert_config,omitempty"`
}

func (x *EvaluationJobConfig) Reset() {
	*x = EvaluationJobConfig{}
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluationJobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationJobConfig) ProtoMessage() {}

func (x *EvaluationJobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationJobConfig.ProtoReflect.Descriptor instead.
func (*EvaluationJobConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescGZIP(), []int{1}
}

func (m *EvaluationJobConfig) GetHumanAnnotationRequestConfig() isEvaluationJobConfig_HumanAnnotationRequestConfig {
	if m != nil {
		return m.HumanAnnotationRequestConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := x.GetHumanAnnotationRequestConfig().(*EvaluationJobConfig_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := x.GetHumanAnnotationRequestConfig().(*EvaluationJobConfig_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := x.GetHumanAnnotationRequestConfig().(*EvaluationJobConfig_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetEvaluationConfig() *EvaluationConfig {
	if x != nil {
		return x.EvaluationConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetHumanAnnotationConfig() *HumanAnnotationConfig {
	if x != nil {
		return x.HumanAnnotationConfig
	}
	return nil
}

func (x *EvaluationJobConfig) GetBigqueryImportKeys() map[string]string {
	if x != nil {
		return x.BigqueryImportKeys
	}
	return nil
}

func (x *EvaluationJobConfig) GetExampleCount() int32 {
	if x != nil {
		return x.ExampleCount
	}
	return 0
}

func (x *EvaluationJobConfig) GetExampleSamplePercentage() float64 {
	if x != nil {
		return x.ExampleSamplePercentage
	}
	return 0
}

func (x *EvaluationJobConfig) GetEvaluationJobAlertConfig() *EvaluationJobAlertConfig {
	if x != nil {
		return x.EvaluationJobAlertConfig
	}
	return nil
}

type isEvaluationJobConfig_HumanAnnotationRequestConfig interface {
	isEvaluationJobConfig_HumanAnnotationRequestConfig()
}

type EvaluationJobConfig_ImageClassificationConfig struct {
	// Specify this field if your model version performs image classification or
	// general classification.
	//
	// `annotationSpecSet` in this configuration must match
	// [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
	// `allowMultiLabel` in this configuration must match
	// `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,4,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type EvaluationJobConfig_BoundingPolyConfig struct {
	// Specify this field if your model version performs image object detection
	// (bounding box detection).
	//
	// `annotationSpecSet` in this configuration must match
	// [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,5,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type EvaluationJobConfig_TextClassificationConfig struct {
	// Specify this field if your model version performs text classification.
	//
	// `annotationSpecSet` in this configuration must match
	// [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
	// `allowMultiLabel` in this configuration must match
	// `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,8,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

func (*EvaluationJobConfig_ImageClassificationConfig) isEvaluationJobConfig_HumanAnnotationRequestConfig() {
}

func (*EvaluationJobConfig_BoundingPolyConfig) isEvaluationJobConfig_HumanAnnotationRequestConfig() {}

func (*EvaluationJobConfig_TextClassificationConfig) isEvaluationJobConfig_HumanAnnotationRequestConfig() {
}

// Provides details for how an evaluation job sends email alerts based on the
// results of a run.
type EvaluationJobAlertConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An email address to send alerts to.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// Required. A number between 0 and 1 that describes a minimum mean average
	// precision threshold. When the evaluation job runs, if it calculates that
	// your model version's predictions from the recent interval have
	// [meanAveragePrecision][google.cloud.datalabeling.v1beta1.PrCurve.mean_average_precision] below this
	// threshold, then it sends an alert to your specified email.
	MinAcceptableMeanAveragePrecision float64 `protobuf:"fixed64,2,opt,name=min_acceptable_mean_average_precision,json=minAcceptableMeanAveragePrecision,proto3" json:"min_acceptable_mean_average_precision,omitempty"`
}

func (x *EvaluationJobAlertConfig) Reset() {
	*x = EvaluationJobAlertConfig{}
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluationJobAlertConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationJobAlertConfig) ProtoMessage() {}

func (x *EvaluationJobAlertConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationJobAlertConfig.ProtoReflect.Descriptor instead.
func (*EvaluationJobAlertConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescGZIP(), []int{2}
}

func (x *EvaluationJobAlertConfig) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *EvaluationJobAlertConfig) GetMinAcceptableMeanAveragePrecision() float64 {
	if x != nil {
		return x.MinAcceptableMeanAveragePrecision
	}
	return 0
}

// Records a failed evaluation job run.
type Attempt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AttemptTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=attempt_time,json=attemptTime,proto3" json:"attempt_time,omitempty"`
	// Details of errors that occurred.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
}

func (x *Attempt) Reset() {
	*x = Attempt{}
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Attempt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attempt) ProtoMessage() {}

func (x *Attempt) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attempt.ProtoReflect.Descriptor instead.
func (*Attempt) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescGZIP(), []int{3}
}

func (x *Attempt) GetAttemptTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AttemptTime
	}
	return nil
}

func (x *Attempt) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

var File_google_cloud_datalabeling_v1beta1_evaluation_job_proto protoreflect.FileDescriptor

var file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a,
	0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68,
	0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xeb, 0x05, 0x0a, 0x0d, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a,
	0x15, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x1a, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x74, 0x72, 0x75, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x54, 0x72, 0x75, 0x74, 0x68, 0x12, 0x46, 0x0a, 0x08, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x52, 0x08, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x04,
	0x3a, 0x62, 0xea, 0x41, 0x5f, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6a, 0x6f, 0x62, 0x7d, 0x22, 0xee, 0x08, 0x0a, 0x13, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7e, 0x0a, 0x1b,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x19, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x14,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x12, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1a, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x65, 0x78, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x74, 0x65, 0x78, 0x74,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x17, 0x68, 0x75, 0x6d,
	0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48,
	0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x14,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4b, 0x65, 0x79, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x01, 0x52, 0x17, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x7a, 0x0a, 0x1b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x18, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x45, 0x0a, 0x17, 0x42,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4b, 0x65, 0x79,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x21, 0x0a, 0x1f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x82, 0x01, 0x0a, 0x18, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x50, 0x0a, 0x25, 0x6d, 0x69, 0x6e, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x61, 0x6e, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x21, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x61, 0x6e, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x07, 0x41,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x12, 0x3d, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x73, 0x42, 0xe3, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01,
	0x5a, 0x49, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44,
	0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescOnce sync.Once
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescData = file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDesc
)

func file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescGZIP() []byte {
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescData)
	})
	return file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDescData
}

var file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_goTypes = []any{
	(EvaluationJob_State)(0),          // 0: google.cloud.datalabeling.v1beta1.EvaluationJob.State
	(*EvaluationJob)(nil),             // 1: google.cloud.datalabeling.v1beta1.EvaluationJob
	(*EvaluationJobConfig)(nil),       // 2: google.cloud.datalabeling.v1beta1.EvaluationJobConfig
	(*EvaluationJobAlertConfig)(nil),  // 3: google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
	(*Attempt)(nil),                   // 4: google.cloud.datalabeling.v1beta1.Attempt
	nil,                               // 5: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.BigqueryImportKeysEntry
	(*timestamppb.Timestamp)(nil),     // 6: google.protobuf.Timestamp
	(*ImageClassificationConfig)(nil), // 7: google.cloud.datalabeling.v1beta1.ImageClassificationConfig
	(*BoundingPolyConfig)(nil),        // 8: google.cloud.datalabeling.v1beta1.BoundingPolyConfig
	(*TextClassificationConfig)(nil),  // 9: google.cloud.datalabeling.v1beta1.TextClassificationConfig
	(*InputConfig)(nil),               // 10: google.cloud.datalabeling.v1beta1.InputConfig
	(*EvaluationConfig)(nil),          // 11: google.cloud.datalabeling.v1beta1.EvaluationConfig
	(*HumanAnnotationConfig)(nil),     // 12: google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	(*status.Status)(nil),             // 13: google.rpc.Status
}
var file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_depIdxs = []int32{
	0,  // 0: google.cloud.datalabeling.v1beta1.EvaluationJob.state:type_name -> google.cloud.datalabeling.v1beta1.EvaluationJob.State
	2,  // 1: google.cloud.datalabeling.v1beta1.EvaluationJob.evaluation_job_config:type_name -> google.cloud.datalabeling.v1beta1.EvaluationJobConfig
	4,  // 2: google.cloud.datalabeling.v1beta1.EvaluationJob.attempts:type_name -> google.cloud.datalabeling.v1beta1.Attempt
	6,  // 3: google.cloud.datalabeling.v1beta1.EvaluationJob.create_time:type_name -> google.protobuf.Timestamp
	7,  // 4: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.image_classification_config:type_name -> google.cloud.datalabeling.v1beta1.ImageClassificationConfig
	8,  // 5: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.bounding_poly_config:type_name -> google.cloud.datalabeling.v1beta1.BoundingPolyConfig
	9,  // 6: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.text_classification_config:type_name -> google.cloud.datalabeling.v1beta1.TextClassificationConfig
	10, // 7: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config:type_name -> google.cloud.datalabeling.v1beta1.InputConfig
	11, // 8: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.evaluation_config:type_name -> google.cloud.datalabeling.v1beta1.EvaluationConfig
	12, // 9: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.human_annotation_config:type_name -> google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
	5,  // 10: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.bigquery_import_keys:type_name -> google.cloud.datalabeling.v1beta1.EvaluationJobConfig.BigqueryImportKeysEntry
	3,  // 11: google.cloud.datalabeling.v1beta1.EvaluationJobConfig.evaluation_job_alert_config:type_name -> google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
	6,  // 12: google.cloud.datalabeling.v1beta1.Attempt.attempt_time:type_name -> google.protobuf.Timestamp
	13, // 13: google.cloud.datalabeling.v1beta1.Attempt.partial_failures:type_name -> google.rpc.Status
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_init() }
func file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_init() {
	if File_google_cloud_datalabeling_v1beta1_evaluation_job_proto != nil {
		return
	}
	file_google_cloud_datalabeling_v1beta1_dataset_proto_init()
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_init()
	file_google_cloud_datalabeling_v1beta1_human_annotation_config_proto_init()
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes[1].OneofWrappers = []any{
		(*EvaluationJobConfig_ImageClassificationConfig)(nil),
		(*EvaluationJobConfig_BoundingPolyConfig)(nil),
		(*EvaluationJobConfig_TextClassificationConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_msgTypes,
	}.Build()
	File_google_cloud_datalabeling_v1beta1_evaluation_job_proto = out.File
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_rawDesc = nil
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_goTypes = nil
	file_google_cloud_datalabeling_v1beta1_evaluation_job_proto_depIdxs = nil
}
