-- title:  Blit segment demo cart
-- author: ddelemeny
-- desc:   Variable BPP rendering 
-- script: lua

W=16*4
offset =
{
   0,     1,     2,
   W,   W+1,   W+2,
 2*W, 2*W+1, 2*W+2,
}
omap = {0,1,3,2}

function rFrame(x,y,w,h,segment,style)
  local keep = peek4(2*0x03FFC)
  poke4(2*0x03FFC, segment)
  function bdr(xy,rot)
    local hrz=(rot%2)==0, iend, c
    if hrz then c=x iend=w-3
    else c=y iend=h-3 end
    
    for i=0,iend do
      local ci = c+i*8+8
      local bS = math.random(1,4)
      spr(
        style+offset[bS*2],
        hrz and ci or xy,
        hrz and xy or ci,
        0,1,0,omap[bS]+rot
      )
    end
  end

  math.randomseed(x+y)
  local x2=x+(w-1)*8 y2=y+(h-1)*8

  spr(style,x,y,0)
  spr(style+offset[3],x2,y,0)
  spr(style+offset[7],x ,y2,0)
  spr(style+offset[9],x2,y2,0)
  
  bdr(y,0)
  bdr(y2,2)
  bdr(x,3)
  bdr(x2,1)
  
  rect(x+8,y+8,w*8-16,h*8-16,1)
  poke4(2*0x03FFC, keep)
end

function rFontSheet(x, y, segment, alt)
  spr((segment)*4+alt*128,x,y,0,1,0,0,4,8)
end

function rText(text,x,y,segment,alt)
  local keep = peek4(2*0x03FFC)
  poke4(2*0x03FFC, segment)
  font(text,x,y,0,5,8,false,1,alt)
  poke4(2*0x03FFC, keep)
end

-- segments for 1bpp BG page are:
-- 9, 11, 13, 15

local text="The quick brown\nfox jumps over\nthe lazy dog!"
local sel=0
function TIC()
  cls(15)
  poke4(2*0x03FF0+1,0)
    
  if btnp(0) then sel=(sel-1)%8 end
  if btnp(1) then sel=(sel+1)%8 end

  -- 1bpp total indexing
		-- blit segment = 8
  rFrame(10, 10, 9, 14, 8, 1040)
		
		-- 4bpp total indexing
		-- blit segment = 2 (default)
  rFontSheet(30, 30, sel//2, sel%2)
		
		-- 1bpp local indexing (font)
		-- font inverts BG and FG segments
		-- blit segment = 8+4+page
  rText(text, 100, 60, 8+4+sel//2,sel%2==1)
end 

-- <TILES>
-- 032:0020505000205070002000500000007000200050000000000000000000000000
-- 033:6010302030403020602070003010500020406000000000000000000000000000
-- 034:4010000020205020202020702020502040100000000000000000000000000000
-- 035:0000000000000040007000200000001020002000100000000000000000000000
-- 036:0040a0a00040a0f1004000a0000000f1004000a0000000000000000000000000
-- 037:e111204050805020e040610041209000f0116100000000000000000000000000
-- 038:80204000404051404040e0e04040514080204000000000000000000000000000
-- 039:000000010000008000e000400000002040004010200000000000000000000000
-- 040:0001664200013342008100f70081006300c000f70000006300c0006300000000
-- 041:8100c181c7666381605361c0c3b1e60006c6b300e36537008133ed0000000000
-- 042:03c0000081816681c003c381c003ffe7c003c3818181668103c0000000000000
-- 043:0000000c000000060000000300e70081000000c08100816081008130c0000000
-- 044:0040a0010040a04100c050e300c0004100c000e30000004100c0004000000000
-- 045:8000e040c7642040a0622120e301f3008680310086463100e726f30080000000
-- 046:c0c00000608180806081a2806081c1e36081a28060818080c0c0000000000000
-- 047:00000000000000020000000100e1008000000040600060204000601020000000
-- 048:6020303050304040502020205020104030707030000000000000000000000000
-- 049:4070607060101040503070207040501040302010000000000000000000000000
-- 050:6020000050502020207000005040202030300010000000000000000000000000
-- 051:4000107020702040100040202070200040001020000000000000000000000000
-- 052:e040e0e001701111514080c030002011e0f1f160000000000000000000000000
-- 053:80f1e0f1a010100090d0d080b101114080f0c020000000000000000000000000
-- 054:c060000011114040a06100001101000060e04040000000200000000000000000
-- 055:800020e040e04001200080c040e0400080002040000000000000000000000000
-- 056:c30183836601440467810607f381810273c0600333c0f3f3e1c0f3f100000000
-- 057:048703c78440c00646e36103e7063381f70333c006f3f36006e1e16000000000
-- 058:0303000082848181c34681812187000033030000f3e3c0c0e1e1c0c000000060
-- 059:000000830600604481e781066000068381f381c006006000000000c000000000
-- 060:8760e3e1444026024640060265c0c7c7e4c0600664c06006e3c0e7e700000000
-- 061:40c787e7404040044040400262c3e30362066403e766640303e7e70300000000
-- 062:c7c70000442400004424c0c0e7e7c0c0640600006406c0c0e706c08000000040
-- 063:000000e3000000648000200640e040872000808140e040008000208100000000
-- 064:60e0e0c05041512170c1c020105141206021e0c0000000000000000000000000
-- 065:e0d0e1c05121502041e0c0a141204021e0c020c0000000000000000000000000
-- 066:61e0e06151509051c140c1c04140a04161e04061000000000000000000000000
-- 067:606161f050d1d1214041c1214041c121e12141c0008001000000800000000000
-- 068:e00150e051419001d121d01010711111e011d0e0000000000000000000000000
-- 069:10e1e1c15000002090f0f09111101011d0e11061000000000000000000000000
-- 070:11e1e19111000050d14080301140909011f06011000000000000000000000000
-- 071:10b131e0104141101011511100115101f11191e0000000000000000000000000
-- 072:c301c1c366824264a5c2e130a5622230a7e6367460b7f7e7c336f3c300000000
-- 073:c0c7c7c34140406462e1e1302620203737303076f3f730f7f1f730e700000000
-- 074:440102444401024666810363e78103e1f7c003f136c033b336c0f3370000e100
-- 075:40424481404244426063e62620e3e73630f7b737f7b637f3f73636e100000000
-- 076:e083c18751444244d144424010e7e360e0646460006464640064e3c700000000
-- 077:c1c7c787424040444440404064e1e1606460606664606064e3e760c700000000
-- 078:448001444480014244800141e78103e364810366648123666481e36600000000
-- 079:40c6448340c6c44440c7c444604565646064666460646664e36464c300000000
-- 080:e0c0e0c151215120c021c1c04021c01160c041e0000300000000000000000000
-- 081:e161212150515151404141c1404141c160818041000000000000000000000000
-- 082:6161e160d051902040814020a001212090c0f160000000000000000000000000
-- 083:0030200010205000202000004020000000300070000000000000000000000000
-- 084:d0e0d0e111101110d011d0a010801101106111f0000000000000000000000000
-- 085:f111111100111111401121114001214140e041b1000000000000000000000000
-- 086:1111f1c011118040a0e00040110020401140f1c0000000000000000000000000
-- 087:106040002040a0004040110080400000016000e1000000000000000000000000
-- 088:c381c3c346424626662666c0e736e303f337f31630f337f730e736e300060000
-- 089:f744242480442424c0242226c02633b66036f1f360f3f0f360e1703300000000
-- 090:2416c7072213040143a10381c1c0c081e16060c07360f7c03360f7c300000000
-- 091:308381006002c300c00266008103000003030000060300000cc300f300000000
-- 092:c383c18744444244444442406464e383e36464066065646660c364e300020000
-- 093:c7444444014444440144424481646265816461e78164e1e681c3c06400000000
-- 094:4444c7e04444466046640360c3648160e4c3c0606481e0606481e7e000000000
-- 095:00e0400010c0a00020c0110040c0000080c0000001c0000002e000e300000000
-- 096:20002000403060600060a0500050a01000e070e0000000000000000000000000
-- 097:4000c000606020205050705050302070e0e030c0000000300000000000000000
-- 098:20204020600000a0a0206060a0204060b0d050b0000020000000000000000000
-- 099:1000000020e060202061a0502021a05070119020000000000000000000000000
-- 100:200010004061d0c100111110001111100061d0e1000000000000000000000000
-- 101:0100c10061c0006111d1f1111110206161e12001000000e00000000000000000
-- 102:10400110d0000011116081d01140011111c011110000e0000000000000000000
-- 103:2000000020b0f0e02041011000511101c15111e0000000000000000000000000
-- 104:810040008100400003c5e1c3002622600036337000f3f3f100e3f1e100000000
-- 105:040003000400800087c3c0876664c16636f760c7f7706003e7e360e3000000f1
-- 106:4001024040000040e38103666681036336c183f136c081b336c0f1370000f000
-- 107:010000008100000081a3a3c3c0e66666c0b63633c0b636f3813636e100000000
-- 108:200020004000200000c3e1c30002226000c362e0006262e000e3e1c300000000
-- 109:0200830002004000c3c1e1c12222402262e3c0236260c0c3c3c1c003000000c1
-- 110:4000004040810342c30000c344010244c48103c4c48103c4c48123c40000c100
-- 111:800000008000000080c0c383804344448145c4c48145c4c48145c48300000000
-- 112:000000006060d0c0a0502060a050208070e01070204000000000000000000000
-- 113:2000000070509191205090902050a0d0c0e040e0000000000000000000000000
-- 114:00000060a0d0f0205150403040602124b040f060002000000000000000000000
-- 115:2030000020206000006030002020000020300000000000000000000000000000
-- 116:00000000d061f0e11111013011111081d06110f0100100000000000000000000
-- 117:20000000f11111110011111120012141c1e041b1000000000000000000000000
-- 118:000000c01111f140a0118020116120401101f1c000e000000000000000000000
-- 119:40600000404041004080a0004040000040600000000000000000000000000000
-- 120:0000000000000000a385a38366666660e7e73081f1c330f3300330f130030000
-- 121:0100000081000000e3442424c02626a6603633f3e1f3f173c1e3e03100000000
-- 122:00000003000000814826c781c62602c083e38181e3c1c78176c0e70300600000
-- 123:01c000000181e6008181b30081030000c0810000c0810000c0c0000000000000
-- 124:0000000000000000c3c3e1c344222260c4236081c4236022c3c360e140020000
-- 125:0000000040000000e3222222406262a2c06262e2c062c1e383c1806300000000
-- 126:00000081000000c0c444c7c083464660014603c0838781c04606c78100000000
-- 127:8060000080c0000080c000008081050080c0820080c000008060000000000000
-- 160:0020505000205070002000500000007000200050000000000000000000000000
-- 161:6010302030403020602070003010500020406000000000000000000000000000
-- 162:4010000020205020202020702020502040100000000000000000000000000000
-- 163:0000000000000040007000200000001020002000100000000000000000000000
-- 164:00c0a0a000c0a0f100c000a0000000f100c000a0000000000000000000000000
-- 165:e111204050805020e040610041209000f0116100000000000000000000000000
-- 166:80204000404051404040e0e04040514080204000000000000000000000000000
-- 167:000000010000008000e000406000602040006010200000000000000000000000
-- 168:0081636300816363008100f700810063008100f7000000630081006300000000
-- 169:8100c181c7666381605361c0c3b1e60006c6b300e36537008133ed0000000000
-- 170:03c0000081816681c001c381c003ffe7c003c3818181668103c0000000000000
-- 171:0000000c000000060000000300e70081000000c08100816081008130c0000000
-- 172:000082000081820000814141008100e300800041000000e30080004100000000
-- 173:80000080c3e08080a0a24140c361c00086862200a6452100e307c20080000000
-- 174:0180000080010000c0038080c003a280c003c1e3c003a2808001808001800000
-- 175:0000000000000002000000010000008000c30040000000200100800080000000
-- 176:6020303050304040502020205020104030707030000000000000000000000000
-- 177:5070607050101040703070204040501040307010000000000000000000000000
-- 178:7070000050502020707000005040202070400010000000000000000000000000
-- 179:4000107020702040100040202070200040001020000000000000000000000000
-- 180:e0c0f0f1b1e0818171c0e0c031c03091e0e1f1e0000000000000000000000000
-- 181:c0f1e0f1e0303081b0f0f0c0f181316080f0e030000000000000000000000000
-- 182:e0e0606031316060e0e1000031016060e0e06040000000200000000000000000
-- 183:800020e140e04081200080c040e04000800020c0000000000000000000000000
-- 184:c381c3c366c1666667e10606e7810383e68181066681c066c381e7c300000000
-- 185:83e783e7c360c00663e360063306e303f70666810366668103c3c38100000000
-- 186:c3c300006666818166668181c3c700006606000066038181c3c18181000000c0
-- 187:000000c30600606681e781066000060381e78181060060000000008100000000
-- 188:00000000c381c3c366c1260667810683e681830666814066c3c3e7c300000000
-- 189:0000000083e783e74360602643e363032306e681e726668103e3c38100000000
-- 190:00000000c3c3000066660000c367800166c6000066060000c306800100000080
-- 191:00000000000000c10100806380c301034000028180c301000100808000000000
-- 192:6020306050505010707030101050501060503060000000000000000000000000
-- 193:3070706050101010503030505010105030701060000000000000000000000000
-- 194:5070705050204050702040305020505050702050000000000000000000000000
-- 195:1070302010705050105050501050505070505020000000000000000000000000
-- 196:e0e0f0e051313131d131f03010f13131e031f0e0000000000000000000000000
-- 197:f0f1f1e13130303031f0f0b131303031f0f130e1000000000000000000000000
-- 198:31e1f13131c081b0f1c0817031c0b1b031e1e031000000000000000000000000
-- 199:30b131e030f1713130f1f1313051b131f11131e0000000000000000000000000
-- 200:c3c3e387666666c0a5666660a5e7e360a7666660606666c0c366e38700000000
-- 201:e1e7e7c3636060666660606066e1e1676660606663606066e1e760c700000000
-- 202:66c3063666810633668106b1e78106f0668106b16681663366c3c33600000000
-- 203:603636c36077766660f7f66660b6b7666036376660363666e73636c300000000
-- 204:0081f1c3838362664443f33027436430a4e36430a62364764537f3e300000000
-- 205:f1f7f7c3626464666460603064e3e3376460603664646076f3f7f0e300000000
-- 206:72c3877666810363668103e1f78103f3668103636681336376c3e17600000000
-- 207:f07677c360e6666660e7e63460e7e7346065673464646672f77272e100000000
-- 208:3020306050505010305070201070304010605030000000000000000000000000
-- 209:7050505020505050205050502050507020602070000000000000000000000000
-- 210:5050706050504020202020205020102050207060000000000000000000000000
-- 211:0030200010205000202000004020000000300070000000000000000000000000
-- 212:f0e0f0e131313170313131e0f031f0c130e031f0000100000000000000000000
-- 213:e1313111c0313151c03131f1c031e0f1c0e040b1000000000000000000000000
-- 214:3161f1c03161c040e0e1604031c0304031c0f1c0000000000000000000000000
-- 215:106040002040a0004040110080400000016000e1000000000000000000000000
-- 216:e3e1e3c366336666663366e0e333e3c36033630760b3666660e766c300000000
-- 217:e76666368166663681666636816666b68166c3f78166c37781c3813600000000
-- 218:3c3cf7c3666603c0c3c381c08181c0c0c38160c0668130c03c81f7c300000000
-- 219:30c381006003c300c00366008103000003030000060300000cc300f300000000
-- 220:f3c3f1e16666633366346370e334e1e360b4630660336336f0e176e300060000
-- 221:f3323475d4326465c0326465c0326265c032e165c032e065e1e160f200000000
-- 222:1674f38163641380c3e28180c1c3c080e18160806381328034c1f38000000081
-- 223:00818100200142004001240080010000010100000201000000010000008100c3
-- 224:2000100040303060006050100050501000703060000000000000000000000000
-- 225:4000400060602060505070505030207060602040000000200000000000000000
-- 226:1020401030000050502040305020403050205050000020000000000000000000
-- 227:3000000020703020207050502050505070505020000000000000000000000000
-- 228:2000300040e1f0e1009131700091317000e1f0e1000000000000000000000000
-- 229:8100c100e1e060e091b1f191917060f1e1e06081000000e00000000000000000
-- 230:30c08130f000003131c081f031c0813131c091310000e0000000000000000000
-- 231:6000000060b0f0e060f1313160513131c15131e0000000000000000000000000
-- 232:810060008100600003c3e3c30006666000c766600066666000c7e3c300000000
-- 233:060083000600c000c7c3e3c76666c06666e7c0666660c0c7c7c3c006000000c3
-- 234:6081036060000060e381036666810363668103e166810363660303660000e100
-- 235:81000000810000008173e3c381f7666681b6666681366666033666c300000000
-- 236:8000810080816000010263c300c6e662006766600066666200c5e1c100000000
-- 237:8100810006004200c6c160c26762e1676661606666e460c787c36006000000c3
-- 238:c1c081c06000006063e08162e6c0816166c081e366c1c36366c0a1660000c000
-- 239:c000000061000000616361c161e7e262e065626260656262c04d46c100000000
-- 240:0000000030605060505030305050104030601030104000000000000000000000
-- 241:2000000070505050205050502050507040602070000000000000000000000000
-- 242:0000006050507020205060305060102050407060002000000000000000000000
-- 243:2030000020206000006030002020000020300000000000000000000000000000
-- 244:00000000f0e1f0e131913170319130c1f0e130f0308100000000000000000000
-- 245:60000000f1313111603131516031e0f1c1e040b1000000000000000000000000
-- 246:000000c0b191f140e091c060e0e16040b181f1c000e000000000000000000000
-- 247:406000004040410040c0a0004040000040600000000000000000000000000000
-- 248:0000000000000000e3c7e3c366666660666660c3e3c76006600660e360060000
-- 249:c0000000c0000000e3666636c0666636c06666b6c066c3f783c7816300000000
-- 250:00000003000000813666e781636603c0c166818163c3c0813681e70300c00000
-- 251:81c000008181e6008181b30081030000818100008181000081c0000000000000
-- 252:000000000000000063c663c3e667c6606666c083e1c7c0076006c0e360060000
-- 253:40000000c0000000e3626665c0626265c0626265c067616583c2e0e200000000
-- 254:0000000300000081e666e381816681c08167c081c1c662816706e30300c10000
-- 255:80c00000808100008081000080038200808141008081000080c0000000000000
-- </TILES>

-- <SPRITES>
-- 000:b1e0b1c01151b16111f1007111f1b161b151b1c0000000000000000000000000
-- 001:e1f1f1e0211100112111f1e0b1f10040b1f0f140000000000000000000000000
-- 002:01c1550183c10002c7e31404e34100efd14114d7904100937080551100000000
-- 003:77c1e360b622f7f7779aa2607717a2007712a203b620a2f777c1e30300000000
-- 004:0000000000000000c1000000c900c0008fbbc0008feff0008ffff3000fff7200
-- 016:a0f0e0c0a090116040d1f1f1b171b160b1c1f1c0000000000000000000000000
-- 017:8051c0804100c101a011d1e35000e1d13051c090000000000000000000000000
-- 020:0f0070000f0070008f00f000cd00f0008d00f0000f00f0000f00f0008f007000
-- 032:f1f140400000c080d151f1d1d151c080d1514040000000000000000000000000
-- 033:f12050f0f160d001f1e0d111f160d010f12050e1000000000000000000000000
-- 036:0ffff1000ffff1000ffff1000f7cc3000c30f3000e0081000000000000000000
-- 192:eff1f100fff3f300fff3f3effff3f320fffff320fffff320fffff720ffffff20
-- 193:0000000000000000f00000008000000080000000802214008022220080222200
-- 194:000000000000e70000007e000000bd000000bd0000003c000000bd000000e700
-- 195:0e0000008fe30000cf000000ef000000ef001000ff003000ff003010ff002020
-- 208:ffffff20fff7ffeffff3ffeffff3ffeffff3f3effff3f300fff1f100ebf0f000
-- 209:80000000f0000000f022c100f0c12200f0000000000000000000000000000000
-- 210:000000000000e7e700003eff0000bdff00003eff0000bdff00003eff0000e7e7
-- 211:0000000000cf000000200000cf2000002020cfff202060002020200020202000
-- 224:00000000000000cf00010100000101cf00010100000501000005010000050300
-- 225:00000000f0000000000000007000000000000000005500000077770000220000
-- 226:000000000000e7e70000bdfe0000bd7e00007e3e0000bd7e0000bdfe0000e7e7
-- 227:202060002020efff2020efff2060cfff20ef000020ef000020cf000020000000
-- 240:0003050000010500000105000001010000010100000000efc170700000000000
-- 241:000000000000000000e3550000c1a20000000000f00000000000000000000000
-- 242:000000000000e7e70000bdff0000bd7e00007c3c0000fd1800007eff0000e7e7
-- 243:200000c02000c0e12000e1f32000f3c02000f3c0600000c0cfff000000000000
-- </SPRITES>

-- <MAP>
-- 000:203040500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 001:213141510000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- </MAP>

-- <WAVES>
-- 000:00000000ffffffff00000000ffffffff
-- 001:0123456789abcdeffedcba9876543210
-- 002:0123456789abcdef0123456789abcdef
-- </WAVES>

-- <SFX>
-- 000:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000304000000000
-- </SFX>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

