// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebaseappcheck provides access to the Firebase App Check API.
//
// For product documentation, see: https://firebase.google.com/docs/app-check
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/firebaseappcheck/v1beta"
//   ...
//   ctx := context.Background()
//   firebaseappcheckService, err := firebaseappcheck.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   firebaseappcheckService, err := firebaseappcheck.NewService(ctx, option.WithScopes(firebaseappcheck.FirebaseScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   firebaseappcheckService, err := firebaseappcheck.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   firebaseappcheckService, err := firebaseappcheck.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package firebaseappcheck // import "google.golang.org/api/firebaseappcheck/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "firebaseappcheck:v1beta"
const apiName = "firebaseappcheck"
const apiVersion = "v1beta"
const basePath = "https://firebaseappcheck.googleapis.com/"
const mtlsBasePath = "https://firebaseappcheck.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and administer all your Firebase data and settings
	FirebaseScope = "https://www.googleapis.com/auth/firebase"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/firebase",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Jwks = NewJwksService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Jwks *JwksService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewJwksService(s *Service) *JwksService {
	rs := &JwksService{s: s}
	return rs
}

type JwksService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Apps = NewProjectsAppsService(s)
	rs.Services = NewProjectsServicesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Apps *ProjectsAppsService

	Services *ProjectsServicesService
}

func NewProjectsAppsService(s *Service) *ProjectsAppsService {
	rs := &ProjectsAppsService{s: s}
	rs.AppAttestConfig = NewProjectsAppsAppAttestConfigService(s)
	rs.DebugTokens = NewProjectsAppsDebugTokensService(s)
	rs.DeviceCheckConfig = NewProjectsAppsDeviceCheckConfigService(s)
	rs.RecaptchaConfig = NewProjectsAppsRecaptchaConfigService(s)
	rs.SafetyNetConfig = NewProjectsAppsSafetyNetConfigService(s)
	return rs
}

type ProjectsAppsService struct {
	s *Service

	AppAttestConfig *ProjectsAppsAppAttestConfigService

	DebugTokens *ProjectsAppsDebugTokensService

	DeviceCheckConfig *ProjectsAppsDeviceCheckConfigService

	RecaptchaConfig *ProjectsAppsRecaptchaConfigService

	SafetyNetConfig *ProjectsAppsSafetyNetConfigService
}

func NewProjectsAppsAppAttestConfigService(s *Service) *ProjectsAppsAppAttestConfigService {
	rs := &ProjectsAppsAppAttestConfigService{s: s}
	return rs
}

type ProjectsAppsAppAttestConfigService struct {
	s *Service
}

func NewProjectsAppsDebugTokensService(s *Service) *ProjectsAppsDebugTokensService {
	rs := &ProjectsAppsDebugTokensService{s: s}
	return rs
}

type ProjectsAppsDebugTokensService struct {
	s *Service
}

func NewProjectsAppsDeviceCheckConfigService(s *Service) *ProjectsAppsDeviceCheckConfigService {
	rs := &ProjectsAppsDeviceCheckConfigService{s: s}
	return rs
}

type ProjectsAppsDeviceCheckConfigService struct {
	s *Service
}

func NewProjectsAppsRecaptchaConfigService(s *Service) *ProjectsAppsRecaptchaConfigService {
	rs := &ProjectsAppsRecaptchaConfigService{s: s}
	return rs
}

type ProjectsAppsRecaptchaConfigService struct {
	s *Service
}

func NewProjectsAppsSafetyNetConfigService(s *Service) *ProjectsAppsSafetyNetConfigService {
	rs := &ProjectsAppsSafetyNetConfigService{s: s}
	return rs
}

type ProjectsAppsSafetyNetConfigService struct {
	s *Service
}

func NewProjectsServicesService(s *Service) *ProjectsServicesService {
	rs := &ProjectsServicesService{s: s}
	return rs
}

type ProjectsServicesService struct {
	s *Service
}

// GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse: Response
// message for the GenerateAppAttestChallenge method.
type GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse struct {
	// Challenge: A one-time use challenge for the client to pass to the App
	// Attest API.
	Challenge string `json:"challenge,omitempty"`

	// Ttl: The duration from the time this challenge is minted until its
	// expiration. This field is intended to ease client-side token
	// management, since the client may have clock skew, but is still able
	// to accurately measure a duration.
	Ttl string `json:"ttl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Challenge") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Challenge") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaAppAttestConfig: An app's App Attest
// configuration object. This configuration controls certain properties
// of the App Check token returned by ExchangeAppAttestAttestation and
// ExchangeAppAttestAssertion, such as its ttl. Note that the Team ID
// registered with your app is used as part of the validation process.
// Please register it via the Firebase Console or programmatically via
// the Firebase Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.iosApps/patch).
type GoogleFirebaseAppcheckV1betaAppAttestConfig struct {
	// Name: Required. The relative resource name of the App Attest
	// configuration object, in the format: ```
	// projects/{project_number}/apps/{app_id}/appAttestConfig ```
	Name string `json:"name,omitempty"`

	// TokenTtl: Specifies the duration for which App Check tokens exchanged
	// from App Attest artifacts will be valid. If unset, a default value of
	// 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaAppAttestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaAppAttestConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaAttestationTokenResponse: Encapsulates an
// *App Check token*, which are used to access Firebase services
// protected by App Check.
type GoogleFirebaseAppcheckV1betaAttestationTokenResponse struct {
	// AttestationToken: An App Check token. App Check tokens are signed
	// JWTs (https://tools.ietf.org/html/rfc7519) containing claims that
	// identify the attested app and Firebase project. This token is used to
	// access Firebase services protected by App Check.
	AttestationToken string `json:"attestationToken,omitempty"`

	// Ttl: The duration from the time this token is minted until its
	// expiration. This field is intended to ease client-side token
	// management, since the client may have clock skew, but is still able
	// to accurately measure a duration.
	Ttl string `json:"ttl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttestationToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttestationToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaAttestationTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaAttestationTokenResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse:
// Response message for the BatchGetAppAttestConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse struct {
	// Configs: AppAttestConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaAppAttestConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Configs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Configs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse:
// Response message for the BatchGetDeviceCheckConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse struct {
	// Configs: DeviceCheckConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaDeviceCheckConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Configs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Configs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse:
// Response message for the BatchGetRecaptchaConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse struct {
	// Configs: RecaptchaConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaRecaptchaConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Configs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Configs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse:
// Response message for the BatchGetSafetyNetConfigs method.
type GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse struct {
	// Configs: SafetyNetConfigs retrieved.
	Configs []*GoogleFirebaseAppcheckV1betaSafetyNetConfig `json:"configs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Configs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Configs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest: Request
// message for the BatchUpdateServices method.
type GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest struct {
	// Requests: Required. The request messages specifying the Services to
	// update. A maximum of 100 objects can be updated in a batch.
	Requests []*GoogleFirebaseAppcheckV1betaUpdateServiceRequest `json:"requests,omitempty"`

	// UpdateMask: Optional. A comma-separated list of names of fields in
	// the Services to update. Example: `display_name`. If this field is
	// present, the `update_mask` field in the UpdateServiceRequest messages
	// must all match this field, or the entire batch fails and no updates
	// will be committed.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse: Response
// message for the BatchUpdateServices method.
type GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse struct {
	// Services: Service objects after the updates have been applied.
	Services []*GoogleFirebaseAppcheckV1betaService `json:"services,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Services") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Services") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaDebugToken: A *debug token* is a secret
// used during the development or integration testing of an app. It
// essentially allows the development or integration testing to bypass
// app attestation while still allowing App Check to enforce protection
// on supported production Firebase services.
type GoogleFirebaseAppcheckV1betaDebugToken struct {
	// DisplayName: Required. A human readable display name used to identify
	// this debug token.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Required. The relative resource name of the debug token, in the
	// format: ```
	// projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id}
	// ```
	Name string `json:"name,omitempty"`

	// Token: Required. Input only. Immutable. The secret token itself. Must
	// be provided during creation, and must be a UUID4, case insensitive.
	// This field is immutable once set, and cannot be provided during an
	// UpdateDebugToken request. You can, however, delete this debug token
	// using DeleteDebugToken to revoke it. For security reasons, this field
	// will never be populated in any response.
	Token string `json:"token,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaDebugToken) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaDebugToken
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaDeviceCheckConfig: An app's DeviceCheck
// configuration object. This configuration is used by
// ExchangeDeviceCheckToken to validate device tokens issued to apps by
// DeviceCheck. It also controls certain properties of the returned App
// Check token, such as its ttl. Note that the Team ID registered with
// your app is used as part of the validation process. Please register
// it via the Firebase Console or programmatically via the Firebase
// Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.iosApps/patch).
type GoogleFirebaseAppcheckV1betaDeviceCheckConfig struct {
	// KeyId: Required. The key identifier of a private key enabled with
	// DeviceCheck, created in your Apple Developer account.
	KeyId string `json:"keyId,omitempty"`

	// Name: Required. The relative resource name of the DeviceCheck
	// configuration object, in the format: ```
	// projects/{project_number}/apps/{app_id}/deviceCheckConfig ```
	Name string `json:"name,omitempty"`

	// PrivateKey: Required. Input only. The contents of the private key
	// (`.p8`) file associated with the key specified by `key_id`. For
	// security reasons, this field will never be populated in any response.
	PrivateKey string `json:"privateKey,omitempty"`

	// PrivateKeySet: Output only. Whether the `private_key` field was
	// previously set. Since we will never return the `private_key` field,
	// this field is the only way to find out whether it was previously set.
	PrivateKeySet bool `json:"privateKeySet,omitempty"`

	// TokenTtl: Specifies the duration for which App Check tokens exchanged
	// from DeviceCheck tokens will be valid. If unset, a default value of 1
	// hour is assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "KeyId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KeyId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaDeviceCheckConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaDeviceCheckConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest:
// Request message for the ExchangeAppAttestAssertion method.
type GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest struct {
	// Artifact: Required. The artifact returned by a previous call to
	// ExchangeAppAttestAttestation.
	Artifact string `json:"artifact,omitempty"`

	// Assertion: Required. The CBOR-encoded assertion returned by the
	// client-side App Attest API.
	Assertion string `json:"assertion,omitempty"`

	// Challenge: Required. A one-time challenge returned by an immediately
	// prior call to GenerateAppAttestChallenge.
	Challenge string `json:"challenge,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Artifact") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Artifact") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest:
// Request message for the ExchangeAppAttestAttestation method.
type GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest struct {
	// AttestationStatement: Required. The App Attest statement returned by
	// the client-side App Attest API. This is a base64url encoded CBOR
	// object in the JSON response.
	AttestationStatement string `json:"attestationStatement,omitempty"`

	// Challenge: Required. A one-time challenge returned by an immediately
	// prior call to GenerateAppAttestChallenge.
	Challenge string `json:"challenge,omitempty"`

	// KeyId: Required. The key ID generated by App Attest for the client
	// app.
	KeyId string `json:"keyId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AttestationStatement") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttestationStatement") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse:
// Response message for the ExchangeAppAttestAttestation method.
type GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse struct {
	// Artifact: An artifact that can be used in future calls to
	// ExchangeAppAttestAssertion.
	Artifact string `json:"artifact,omitempty"`

	// AttestationToken: Encapsulates an App Check token.
	AttestationToken *GoogleFirebaseAppcheckV1betaAttestationTokenResponse `json:"attestationToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Artifact") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Artifact") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest: Request
// message for the ExchangeCustomToken method.
type GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest struct {
	// CustomToken: Required. A custom token signed using your project's
	// Admin SDK service account credentials.
	CustomToken string `json:"customToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest: Request
// message for the ExchangeDebugToken method.
type GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest struct {
	// DebugToken: Required. A debug token secret. This string must match a
	// debug token secret previously created using CreateDebugToken.
	DebugToken string `json:"debugToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DebugToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugToken") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest: Request
// message for the ExchangeDeviceCheckToken method.
type GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest struct {
	// DeviceToken: Required. The `device_token` as returned by Apple's
	// client-side DeviceCheck API
	// (https://developer.apple.com/documentation/devicecheck/dcdevice).
	// This is the base64 encoded `Data` (Swift) or `NSData` (ObjC) object.
	DeviceToken string `json:"deviceToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest: Request
// message for the ExchangeRecaptchaToken method.
type GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest struct {
	// RecaptchaToken: Required. The reCAPTCHA token as returned by the
	// reCAPTCHA v3 JavaScript API
	// (https://developers.google.com/recaptcha/docs/v3).
	RecaptchaToken string `json:"recaptchaToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RecaptchaToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RecaptchaToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest: Request
// message for the ExchangeSafetyNetToken method.
type GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest struct {
	// SafetyNetToken: Required. The SafetyNet attestation response
	// (https://developer.android.com/training/safetynet/attestation#request-attestation-step)
	// issued to your app.
	SafetyNetToken string `json:"safetyNetToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SafetyNetToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SafetyNetToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest:
// Request message for the GenerateAppAttestChallenge method.
type GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest struct {
}

// GoogleFirebaseAppcheckV1betaListDebugTokensResponse: Response message
// for the ListDebugTokens method.
type GoogleFirebaseAppcheckV1betaListDebugTokensResponse struct {
	// DebugTokens: The DebugTokens retrieved.
	DebugTokens []*GoogleFirebaseAppcheckV1betaDebugToken `json:"debugTokens,omitempty"`

	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token is returned. If the string is empty or
	// omitted, then this response is the last page of results. This token
	// can be used in a subsequent call to ListDebugTokens to find the next
	// group of DebugTokens. Page tokens are short-lived and should not be
	// persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DebugTokens") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DebugTokens") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaListDebugTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaListDebugTokensResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaListServicesResponse: Response message
// for the ListServices method.
type GoogleFirebaseAppcheckV1betaListServicesResponse struct {
	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token is returned. If the string is empty or
	// omitted, then this response is the last page of results. This token
	// can be used in a subsequent call to ListServices to find the next
	// group of Services. Page tokens are short-lived and should not be
	// persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Services: The Services retrieved.
	Services []*GoogleFirebaseAppcheckV1betaService `json:"services,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaListServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaListServicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaPublicJwk: A JWK as specified by section
// 4 of RFC 7517 (https://tools.ietf.org/html/rfc7517#section-4) and
// section 6.3.1 of RFC 7518
// (https://tools.ietf.org/html/rfc7518#section-6.3.1).
type GoogleFirebaseAppcheckV1betaPublicJwk struct {
	// Alg: See section 4.4 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.4).
	Alg string `json:"alg,omitempty"`

	// E: See section 6.3.1.2 of RFC 7518
	// (https://tools.ietf.org/html/rfc7518#section-6.3.1.2).
	E string `json:"e,omitempty"`

	// Kid: See section 4.5 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.5).
	Kid string `json:"kid,omitempty"`

	// Kty: See section 4.1 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.1).
	Kty string `json:"kty,omitempty"`

	// N: See section 6.3.1.1 of RFC 7518
	// (https://tools.ietf.org/html/rfc7518#section-6.3.1.1).
	N string `json:"n,omitempty"`

	// Use: See section 4.2 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-4.2).
	Use string `json:"use,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alg") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alg") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaPublicJwk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaPublicJwk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaPublicJwkSet: The currently active set of
// public keys that can be used to verify App Check tokens. This object
// is a JWK set as specified by section 5 of RFC 7517
// (https://tools.ietf.org/html/rfc7517#section-5). For security, the
// response **must not** be cached for longer than six hours.
type GoogleFirebaseAppcheckV1betaPublicJwkSet struct {
	// Keys: The set of public keys. See section 5.1 of RFC 7517
	// (https://tools.ietf.org/html/rfc7517#section-5).
	Keys []*GoogleFirebaseAppcheckV1betaPublicJwk `json:"keys,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Keys") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Keys") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaPublicJwkSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaPublicJwkSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaRecaptchaConfig: An app's reCAPTCHA v3
// configuration object. This configuration is used by
// ExchangeRecaptchaToken to validate reCAPTCHA tokens issued to apps by
// reCAPTCHA v3. It also controls certain properties of the returned App
// Check token, such as its ttl.
type GoogleFirebaseAppcheckV1betaRecaptchaConfig struct {
	// Name: Required. The relative resource name of the reCAPTCHA v3
	// configuration object, in the format: ```
	// projects/{project_number}/apps/{app_id}/recaptchaConfig ```
	Name string `json:"name,omitempty"`

	// SiteSecret: Required. Input only. The site secret used to identify
	// your service for reCAPTCHA v3 verification. For security reasons,
	// this field will never be populated in any response.
	SiteSecret string `json:"siteSecret,omitempty"`

	// SiteSecretSet: Output only. Whether the `site_secret` field was
	// previously set. Since we will never return the `site_secret` field,
	// this field is the only way to find out whether it was previously set.
	SiteSecretSet bool `json:"siteSecretSet,omitempty"`

	// TokenTtl: Specifies the duration for which App Check tokens exchanged
	// from reCAPTCHA tokens will be valid. If unset, a default value of 1
	// day is assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaRecaptchaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaRecaptchaConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaSafetyNetConfig: An app's SafetyNet
// configuration object. This configuration controls certain properties
// of the App Check token returned by ExchangeSafetyNetToken, such as
// its ttl. Note that your registered SHA-256 certificate fingerprints
// are used to validate tokens issued by SafetyNet; please register them
// via the Firebase Console or programmatically via the Firebase
// Management Service
// (https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects.androidApps.sha/create).
type GoogleFirebaseAppcheckV1betaSafetyNetConfig struct {
	// Name: Required. The relative resource name of the SafetyNet
	// configuration object, in the format: ```
	// projects/{project_number}/apps/{app_id}/safetyNetConfig ```
	Name string `json:"name,omitempty"`

	// TokenTtl: Specifies the duration for which App Check tokens exchanged
	// from SafetyNet tokens will be valid. If unset, a default value of 1
	// hour is assumed. Must be between 30 minutes and 7 days, inclusive.
	TokenTtl string `json:"tokenTtl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaSafetyNetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaSafetyNetConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaService: The enforcement configuration
// for a Firebase service supported by App Check.
type GoogleFirebaseAppcheckV1betaService struct {
	// EnforcementMode: Required. The App Check enforcement mode for this
	// service.
	//
	// Possible values:
	//   "OFF" - Firebase App Check is not enforced for the service, nor are
	// App Check metrics collected. Though the service is not protected by
	// App Check in this mode, other applicable protections, such as user
	// authorization, are still enforced. An unconfigured service is in this
	// mode by default.
	//   "UNENFORCED" - Firebase App Check is not enforced for the service.
	// App Check metrics are collected to help you decide when to turn on
	// enforcement for the service. Though the service is not protected by
	// App Check in this mode, other applicable protections, such as user
	// authorization, are still enforced.
	//   "ENFORCED" - Firebase App Check is enforced for the service. The
	// service will reject any request that attempts to access your
	// project's resources if it does not have valid App Check token
	// attached, with some exceptions depending on the service; for example,
	// some services will still allow requests bearing the developer's
	// privileged service account credentials without an App Check token.
	// App Check metrics continue to be collected to help you detect issues
	// with your App Check integration and monitor the composition of your
	// callers. While the service is protected by App Check, other
	// applicable protections, such as user authorization, continue to be
	// enforced at the same time. Use caution when choosing to enforce App
	// Check on a Firebase service. If your users have not updated to an App
	// Check capable version of your app, their apps will no longer be able
	// to use your Firebase services that are enforcing App Check. App Check
	// metrics can help you decide whether to enforce App Check on your
	// Firebase services. If your app has not launched yet, you should
	// enable enforcement immediately, since there are no outdated clients
	// in use.
	EnforcementMode string `json:"enforcementMode,omitempty"`

	// Name: Required. The relative resource name of the service
	// configuration object, in the format: ```
	// projects/{project_number}/services/{service_id} ``` Note that the
	// `service_id` element must be a supported service ID. Currently, the
	// following service IDs are supported: *
	// `firebasestorage.googleapis.com` (Cloud Storage for Firebase) *
	// `firebasedatabase.googleapis.com` (Firebase Realtime Database) *
	// `firestore.googleapis.com` (Cloud Firestore)
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EnforcementMode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnforcementMode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppcheckV1betaUpdateServiceRequest: Request message for
// the UpdateService method as well as an individual update message for
// the BatchUpdateServices method.
type GoogleFirebaseAppcheckV1betaUpdateServiceRequest struct {
	// Service: Required. The Service to update. The Service's `name` field
	// is used to identify the Service to be updated, in the format: ```
	// projects/{project_number}/services/{service_id} ``` Note that the
	// `service_id` element must be a supported service ID. Currently, the
	// following service IDs are supported: *
	// `firebasestorage.googleapis.com` (Cloud Storage for Firebase) *
	// `firebasedatabase.googleapis.com` (Firebase Realtime Database) *
	// `firestore.googleapis.com` (Cloud Firestore)
	Service *GoogleFirebaseAppcheckV1betaService `json:"service,omitempty"`

	// UpdateMask: Required. A comma-separated list of names of fields in
	// the Service to update. Example: `enforcement_mode`.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppcheckV1betaUpdateServiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppcheckV1betaUpdateServiceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// method id "firebaseappcheck.jwks.get":

type JwksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a public JWK set as specified by RFC 7517
// (https://tools.ietf.org/html/rfc7517) that can be used to verify App
// Check tokens. Exactly one of the public keys in the returned set will
// successfully validate any App Check token that is currently valid.
//
// - name: The relative resource name to the public JWK set. Must always
//   be exactly the string `jwks`.
func (r *JwksService) Get(name string) *JwksGetCall {
	c := &JwksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *JwksGetCall) Fields(s ...googleapi.Field) *JwksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *JwksGetCall) IfNoneMatch(entityTag string) *JwksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *JwksGetCall) Context(ctx context.Context) *JwksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *JwksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JwksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.jwks.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaPublicJwkSet or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaPublicJwkSet.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *JwksGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaPublicJwkSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaPublicJwkSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a public JWK set as specified by [RFC 7517](https://tools.ietf.org/html/rfc7517) that can be used to verify App Check tokens. Exactly one of the public keys in the returned set will successfully validate any App Check token that is currently valid.",
	//   "flatPath": "v1beta/jwks",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.jwks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name to the public JWK set. Must always be exactly the string `jwks`.",
	//       "location": "path",
	//       "pattern": "^jwks$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaPublicJwkSet"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeAppAttestAssertion":

type ProjectsAppsExchangeAppAttestAssertionCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betaexchangeappattestassertionrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// ExchangeAppAttestAssertion: Accepts an App Attest assertion and an
// artifact previously obtained from ExchangeAppAttestAttestation and
// verifies those with Apple. If valid, returns an App Check token
// encapsulated in an AttestationTokenResponse.
//
// - app: The relative resource name of the iOS app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeAppAttestAssertion(appid string, googlefirebaseappcheckv1betaexchangeappattestassertionrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest) *ProjectsAppsExchangeAppAttestAssertionCall {
	c := &ProjectsAppsExchangeAppAttestAssertionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeappattestassertionrequest = googlefirebaseappcheckv1betaexchangeappattestassertionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeAppAttestAssertionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Context(ctx context.Context) *ProjectsAppsExchangeAppAttestAssertionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeAppAttestAssertionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangeappattestassertionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeAppAttestAssertion")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeAppAttestAssertion" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAttestationTokenResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaAttestationTokenResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeAppAttestAssertionCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAttestationTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAttestationTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Accepts an App Attest assertion and an artifact previously obtained from ExchangeAppAttestAttestation and verifies those with Apple. If valid, returns an App Check token encapsulated in an AttestationTokenResponse.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeAppAttestAssertion",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeAppAttestAssertion",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the iOS app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeAppAttestAssertion",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeAppAttestAssertionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAttestationTokenResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeAppAttestAttestation":

type ProjectsAppsExchangeAppAttestAttestationCall struct {
	s                                                               *Service
	appid                                                           string
	googlefirebaseappcheckv1betaexchangeappattestattestationrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest
	urlParams_                                                      gensupport.URLParams
	ctx_                                                            context.Context
	header_                                                         http.Header
}

// ExchangeAppAttestAttestation: Accepts an App Attest CBOR attestation
// and verifies it with Apple using the developer's preconfigured team
// and bundle IDs. If valid, returns an attestation artifact that can
// later be exchanged for an AttestationTokenResponse using
// ExchangeAppAttestAssertion. For convenience and performance, this
// method's response object will also contain an App Check token
// encapsulated in an AttestationTokenResponse (if the verification is
// successful).
//
// - app: The relative resource name of the iOS app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeAppAttestAttestation(appid string, googlefirebaseappcheckv1betaexchangeappattestattestationrequest *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest) *ProjectsAppsExchangeAppAttestAttestationCall {
	c := &ProjectsAppsExchangeAppAttestAttestationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangeappattestattestationrequest = googlefirebaseappcheckv1betaexchangeappattestattestationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeAppAttestAttestationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Context(ctx context.Context) *ProjectsAppsExchangeAppAttestAttestationCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeAppAttestAttestationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangeappattestattestationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeAppAttestAttestation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeAppAttestAttestation" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeAppAttestAttestationCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Accepts an App Attest CBOR attestation and verifies it with Apple using the developer's preconfigured team and bundle IDs. If valid, returns an attestation artifact that can later be exchanged for an AttestationTokenResponse using ExchangeAppAttestAssertion. For convenience and performance, this method's response object will also contain an App Check token encapsulated in an AttestationTokenResponse (if the verification is successful).",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeAppAttestAttestation",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeAppAttestAttestation",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the iOS app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeAppAttestAttestation",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeAppAttestAttestationResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeCustomToken":

type ProjectsAppsExchangeCustomTokenCall struct {
	s                                                      *Service
	appid                                                  string
	googlefirebaseappcheckv1betaexchangecustomtokenrequest *GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// ExchangeCustomToken: Validates a custom token signed using your
// project's Admin SDK service account credentials. If valid, returns an
// App Check token encapsulated in an AttestationTokenResponse.
//
// - app: The relative resource name of the app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeCustomToken(appid string, googlefirebaseappcheckv1betaexchangecustomtokenrequest *GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest) *ProjectsAppsExchangeCustomTokenCall {
	c := &ProjectsAppsExchangeCustomTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangecustomtokenrequest = googlefirebaseappcheckv1betaexchangecustomtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeCustomTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeCustomTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeCustomTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeCustomTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeCustomTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeCustomTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangecustomtokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeCustomToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeCustomToken" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAttestationTokenResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaAttestationTokenResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeCustomTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAttestationTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAttestationTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates a custom token signed using your project's Admin SDK service account credentials. If valid, returns an App Check token encapsulated in an AttestationTokenResponse.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeCustomToken",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeCustomToken",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeCustomToken",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeCustomTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAttestationTokenResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeDebugToken":

type ProjectsAppsExchangeDebugTokenCall struct {
	s                                                     *Service
	appid                                                 string
	googlefirebaseappcheckv1betaexchangedebugtokenrequest *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// ExchangeDebugToken: Validates a debug token secret that you have
// previously created using CreateDebugToken. If valid, returns an App
// Check token encapsulated in an AttestationTokenResponse. Note that a
// restrictive quota is enforced on this method to prevent accidental
// exposure of the app to abuse.
//
// - app: The relative resource name of the app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeDebugToken(appid string, googlefirebaseappcheckv1betaexchangedebugtokenrequest *GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest) *ProjectsAppsExchangeDebugTokenCall {
	c := &ProjectsAppsExchangeDebugTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangedebugtokenrequest = googlefirebaseappcheckv1betaexchangedebugtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeDebugTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeDebugTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeDebugTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeDebugTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeDebugTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeDebugTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangedebugtokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeDebugToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeDebugToken" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAttestationTokenResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaAttestationTokenResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeDebugTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAttestationTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAttestationTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates a debug token secret that you have previously created using CreateDebugToken. If valid, returns an App Check token encapsulated in an AttestationTokenResponse. Note that a restrictive quota is enforced on this method to prevent accidental exposure of the app to abuse.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeDebugToken",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeDebugToken",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeDebugToken",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeDebugTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAttestationTokenResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeDeviceCheckToken":

type ProjectsAppsExchangeDeviceCheckTokenCall struct {
	s                                                           *Service
	appid                                                       string
	googlefirebaseappcheckv1betaexchangedevicechecktokenrequest *GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// ExchangeDeviceCheckToken: Accepts a `device_token`
// (https://developer.apple.com/documentation/devicecheck/dcdevice)
// issued by DeviceCheck, and attempts to validate it with Apple. If
// valid, returns an App Check token encapsulated in an
// AttestationTokenResponse.
//
// - app: The relative resource name of the iOS app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeDeviceCheckToken(appid string, googlefirebaseappcheckv1betaexchangedevicechecktokenrequest *GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest) *ProjectsAppsExchangeDeviceCheckTokenCall {
	c := &ProjectsAppsExchangeDeviceCheckTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangedevicechecktokenrequest = googlefirebaseappcheckv1betaexchangedevicechecktokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeDeviceCheckTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeDeviceCheckTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeDeviceCheckTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangedevicechecktokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeDeviceCheckToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeDeviceCheckToken" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAttestationTokenResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaAttestationTokenResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeDeviceCheckTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAttestationTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAttestationTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Accepts a [`device_token`](https://developer.apple.com/documentation/devicecheck/dcdevice) issued by DeviceCheck, and attempts to validate it with Apple. If valid, returns an App Check token encapsulated in an AttestationTokenResponse.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeDeviceCheckToken",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeDeviceCheckToken",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the iOS app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeDeviceCheckToken",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeDeviceCheckTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAttestationTokenResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeRecaptchaToken":

type ProjectsAppsExchangeRecaptchaTokenCall struct {
	s                                                         *Service
	appid                                                     string
	googlefirebaseappcheckv1betaexchangerecaptchatokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// ExchangeRecaptchaToken: Validates a reCAPTCHA v3 response token
// (https://developers.google.com/recaptcha/docs/v3). If valid, returns
// an App Check token encapsulated in an AttestationTokenResponse.
//
// - app: The relative resource name of the web app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeRecaptchaToken(appid string, googlefirebaseappcheckv1betaexchangerecaptchatokenrequest *GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest) *ProjectsAppsExchangeRecaptchaTokenCall {
	c := &ProjectsAppsExchangeRecaptchaTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangerecaptchatokenrequest = googlefirebaseappcheckv1betaexchangerecaptchatokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeRecaptchaTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeRecaptchaTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeRecaptchaTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangerecaptchatokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeRecaptchaToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeRecaptchaToken" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAttestationTokenResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaAttestationTokenResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeRecaptchaTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAttestationTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAttestationTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates a [reCAPTCHA v3 response token](https://developers.google.com/recaptcha/docs/v3). If valid, returns an App Check token encapsulated in an AttestationTokenResponse.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeRecaptchaToken",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeRecaptchaToken",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the web app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeRecaptchaToken",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeRecaptchaTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAttestationTokenResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.exchangeSafetyNetToken":

type ProjectsAppsExchangeSafetyNetTokenCall struct {
	s                                                         *Service
	appid                                                     string
	googlefirebaseappcheckv1betaexchangesafetynettokenrequest *GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// ExchangeSafetyNetToken: Validates a SafetyNet token
// (https://developer.android.com/training/safetynet/attestation#request-attestation-step).
// If valid, returns an App Check token encapsulated in an
// AttestationTokenResponse.
//
// - app: The relative resource name of the Android app, in the format:
//   ``` projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) ExchangeSafetyNetToken(appid string, googlefirebaseappcheckv1betaexchangesafetynettokenrequest *GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest) *ProjectsAppsExchangeSafetyNetTokenCall {
	c := &ProjectsAppsExchangeSafetyNetTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betaexchangesafetynettokenrequest = googlefirebaseappcheckv1betaexchangesafetynettokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Fields(s ...googleapi.Field) *ProjectsAppsExchangeSafetyNetTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Context(ctx context.Context) *ProjectsAppsExchangeSafetyNetTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsExchangeSafetyNetTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaexchangesafetynettokenrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:exchangeSafetyNetToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.exchangeSafetyNetToken" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAttestationTokenResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaAttestationTokenResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsExchangeSafetyNetTokenCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAttestationTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAttestationTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Validates a [SafetyNet token](https://developer.android.com/training/safetynet/attestation#request-attestation-step). If valid, returns an App Check token encapsulated in an AttestationTokenResponse.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:exchangeSafetyNetToken",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.exchangeSafetyNetToken",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the Android app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:exchangeSafetyNetToken",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaExchangeSafetyNetTokenRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAttestationTokenResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.generateAppAttestChallenge":

type ProjectsAppsGenerateAppAttestChallengeCall struct {
	s                                                             *Service
	appid                                                         string
	googlefirebaseappcheckv1betagenerateappattestchallengerequest *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// GenerateAppAttestChallenge: Generates a challenge that protects the
// integrity of an immediately following call to
// ExchangeAppAttestAttestation or ExchangeAppAttestAssertion. A
// challenge should not be reused for multiple calls.
//
// - app: The relative resource name of the iOS app, in the format: ```
//   projects/{project_number}/apps/{app_id} ``` If necessary, the
//   `project_number` element can be replaced with the project ID of the
//   Firebase project. Learn more about using project identifiers in
//   Google's AIP 2510 (https://google.aip.dev/cloud/2510) standard.
func (r *ProjectsAppsService) GenerateAppAttestChallenge(appid string, googlefirebaseappcheckv1betagenerateappattestchallengerequest *GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest) *ProjectsAppsGenerateAppAttestChallengeCall {
	c := &ProjectsAppsGenerateAppAttestChallengeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.appid = appid
	c.googlefirebaseappcheckv1betagenerateappattestchallengerequest = googlefirebaseappcheckv1betagenerateappattestchallengerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Fields(s ...googleapi.Field) *ProjectsAppsGenerateAppAttestChallengeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Context(ctx context.Context) *ProjectsAppsGenerateAppAttestChallengeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsGenerateAppAttestChallengeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betagenerateappattestchallengerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+app}:generateAppAttestChallenge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"app": c.appid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.generateAppAttestChallenge" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsGenerateAppAttestChallengeCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates a challenge that protects the integrity of an immediately following call to ExchangeAppAttestAttestation or ExchangeAppAttestAssertion. A challenge should not be reused for multiple calls.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}:generateAppAttestChallenge",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.generateAppAttestChallenge",
	//   "parameterOrder": [
	//     "app"
	//   ],
	//   "parameters": {
	//     "app": {
	//       "description": "Required. The relative resource name of the iOS app, in the format: ``` projects/{project_number}/apps/{app_id} ``` If necessary, the `project_number` element can be replaced with the project ID of the Firebase project. Learn more about using project identifiers in Google's [AIP 2510](https://google.aip.dev/cloud/2510) standard.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+app}:generateAppAttestChallenge",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaGenerateAppAttestChallengeRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAppAttestChallengeResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.appAttestConfig.batchGet":

type ProjectsAppsAppAttestConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets the AppAttestConfigs for the specified list of apps
// atomically.
//
// - parent: The parent project name shared by all AppAttestConfigs
//   being retrieved, in the format ``` projects/{project_number} ```
//   The parent collection in the `name` field of any resource being
//   retrieved must match this field, or the entire batch fails.
func (r *ProjectsAppsAppAttestConfigService) BatchGet(parent string) *ProjectsAppsAppAttestConfigBatchGetCall {
	c := &ProjectsAppsAppAttestConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative
// resource names of the AppAttestConfigs to retrieve, in the format ```
// projects/{project_number}/apps/{app_id}/appAttestConfig ``` A maximum
// of 100 objects can be retrieved in a batch.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Names(names ...string) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsAppAttestConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsAppAttestConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/appAttestConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.appAttestConfig.batchGet" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsAppAttestConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the AppAttestConfigs for the specified list of apps atomically.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/-/appAttestConfig:batchGet",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.appAttestConfig.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The relative resource names of the AppAttestConfigs to retrieve, in the format ``` projects/{project_number}/apps/{app_id}/appAttestConfig ``` A maximum of 100 objects can be retrieved in a batch.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent project name shared by all AppAttestConfigs being retrieved, in the format ``` projects/{project_number} ``` The parent collection in the `name` field of any resource being retrieved must match this field, or the entire batch fails.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/apps/-/appAttestConfig:batchGet",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaBatchGetAppAttestConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.appAttestConfig.get":

type ProjectsAppsAppAttestConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the AppAttestConfig for the specified app.
//
// - name: The relative resource name of the AppAttestConfig, in the
//   format: ``` projects/{project_number}/apps/{app_id}/appAttestConfig
//   ```.
func (r *ProjectsAppsAppAttestConfigService) Get(name string) *ProjectsAppsAppAttestConfigGetCall {
	c := &ProjectsAppsAppAttestConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsAppAttestConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsAppAttestConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsAppAttestConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsAppAttestConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsAppAttestConfigGetCall) Context(ctx context.Context) *ProjectsAppsAppAttestConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsAppAttestConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsAppAttestConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.appAttestConfig.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAppAttestConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaAppAttestConfig.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsAppAttestConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppAttestConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAppAttestConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the AppAttestConfig for the specified app.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/appAttestConfig",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.appAttestConfig.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the AppAttestConfig, in the format: ``` projects/{project_number}/apps/{app_id}/appAttestConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/appAttestConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAppAttestConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.appAttestConfig.patch":

type ProjectsAppsAppAttestConfigPatchCall struct {
	s                                           *Service
	name                                        string
	googlefirebaseappcheckv1betaappattestconfig *GoogleFirebaseAppcheckV1betaAppAttestConfig
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates the AppAttestConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to
// exchange AppAttest tokens for App Check tokens.
//
// - name: The relative resource name of the App Attest configuration
//   object, in the format: ```
//   projects/{project_number}/apps/{app_id}/appAttestConfig ```.
func (r *ProjectsAppsAppAttestConfigService) Patch(name string, googlefirebaseappcheckv1betaappattestconfig *GoogleFirebaseAppcheckV1betaAppAttestConfig) *ProjectsAppsAppAttestConfigPatchCall {
	c := &ProjectsAppsAppAttestConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betaappattestconfig = googlefirebaseappcheckv1betaappattestconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the AppAttestConfig Gets
// to update. Example: `token_ttl`.
func (c *ProjectsAppsAppAttestConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsAppAttestConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsAppAttestConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsAppAttestConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsAppAttestConfigPatchCall) Context(ctx context.Context) *ProjectsAppsAppAttestConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsAppAttestConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsAppAttestConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaappattestconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.appAttestConfig.patch" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaAppAttestConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaAppAttestConfig.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsAppAttestConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaAppAttestConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaAppAttestConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the AppAttestConfig for the specified app. While this configuration is incomplete or invalid, the app will be unable to exchange AppAttest tokens for App Check tokens.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/appAttestConfig",
	//   "httpMethod": "PATCH",
	//   "id": "firebaseappcheck.projects.apps.appAttestConfig.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the App Attest configuration object, in the format: ``` projects/{project_number}/apps/{app_id}/appAttestConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/appAttestConfig$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of names of fields in the AppAttestConfig Gets to update. Example: `token_ttl`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAppAttestConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaAppAttestConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.debugTokens.create":

type ProjectsAppsDebugTokensCreateCall struct {
	s                                      *Service
	parent                                 string
	googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a new DebugToken for the specified app. For security
// reasons, after the creation operation completes, the `token` field
// cannot be updated or retrieved, but you can revoke the debug token
// using DeleteDebugToken. Each app can have a maximum of 20 debug
// tokens.
//
// - parent: The relative resource name of the parent app in which the
//   specified DebugToken will be created, in the format: ```
//   projects/{project_number}/apps/{app_id} ```.
func (r *ProjectsAppsDebugTokensService) Create(parent string, googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken) *ProjectsAppsDebugTokensCreateCall {
	c := &ProjectsAppsDebugTokensCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappcheckv1betadebugtoken = googlefirebaseappcheckv1betadebugtoken
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDebugTokensCreateCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDebugTokensCreateCall) Context(ctx context.Context) *ProjectsAppsDebugTokensCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDebugTokensCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betadebugtoken)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/debugTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.create" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaDebugToken or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleFirebaseAppcheckV1betaDebugToken.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensCreateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDebugToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaDebugToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new DebugToken for the specified app. For security reasons, after the creation operation completes, the `token` field cannot be updated or retrieved, but you can revoke the debug token using DeleteDebugToken. Each app can have a maximum of 20 debug tokens.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/debugTokens",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.apps.debugTokens.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The relative resource name of the parent app in which the specified DebugToken will be created, in the format: ``` projects/{project_number}/apps/{app_id} ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/debugTokens",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDebugToken"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDebugToken"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.debugTokens.delete":

type ProjectsAppsDebugTokensDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified DebugToken. A deleted debug token
// cannot be used to exchange for an App Check token. Use this method
// when you suspect the secret `token` has been compromised or when you
// no longer need the debug token.
//
// - name: The relative resource name of the DebugToken to delete, in
//   the format: ```
//   projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id}
//    ```.
func (r *ProjectsAppsDebugTokensService) Delete(name string) *ProjectsAppsDebugTokensDeleteCall {
	c := &ProjectsAppsDebugTokensDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDebugTokensDeleteCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDebugTokensDeleteCall) Context(ctx context.Context) *ProjectsAppsDebugTokensDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDebugTokensDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified DebugToken. A deleted debug token cannot be used to exchange for an App Check token. Use this method when you suspect the secret `token` has been compromised or when you no longer need the debug token.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/debugTokens/{debugTokensId}",
	//   "httpMethod": "DELETE",
	//   "id": "firebaseappcheck.projects.apps.debugTokens.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the DebugToken to delete, in the format: ``` projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/debugTokens/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.debugTokens.get":

type ProjectsAppsDebugTokensGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified DebugToken. For security reasons, the `token`
// field is never populated in the response.
//
// - name: The relative resource name of the debug token, in the format:
//   ```
//   projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id}
//    ```.
func (r *ProjectsAppsDebugTokensService) Get(name string) *ProjectsAppsDebugTokensGetCall {
	c := &ProjectsAppsDebugTokensGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDebugTokensGetCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsDebugTokensGetCall) IfNoneMatch(entityTag string) *ProjectsAppsDebugTokensGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDebugTokensGetCall) Context(ctx context.Context) *ProjectsAppsDebugTokensGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDebugTokensGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaDebugToken or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleFirebaseAppcheckV1betaDebugToken.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDebugToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaDebugToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the specified DebugToken. For security reasons, the `token` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/debugTokens/{debugTokensId}",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.debugTokens.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the debug token, in the format: ``` projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/debugTokens/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDebugToken"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.debugTokens.list":

type ProjectsAppsDebugTokensListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all DebugTokens for the specified app. For security
// reasons, the `token` field is never populated in the response.
//
// - parent: The relative resource name of the parent app for which to
//   list each associated DebugToken, in the format: ```
//   projects/{project_number}/apps/{app_id} ```.
func (r *ProjectsAppsDebugTokensService) List(parent string) *ProjectsAppsDebugTokensListCall {
	c := &ProjectsAppsDebugTokensListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of DebugTokens to return in the response. Note that an app can have
// at most 20 debug tokens. The server may return fewer than this at its
// own discretion. If no value is specified (or too large a value is
// specified), the server will impose its own limit.
func (c *ProjectsAppsDebugTokensListCall) PageSize(pageSize int64) *ProjectsAppsDebugTokensListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to ListDebugTokens indicating where in the set
// of DebugTokens to resume listing. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// ListDebugTokens must match the call that provided the page token; if
// they do not match, the result is undefined.
func (c *ProjectsAppsDebugTokensListCall) PageToken(pageToken string) *ProjectsAppsDebugTokensListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDebugTokensListCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsDebugTokensListCall) IfNoneMatch(entityTag string) *ProjectsAppsDebugTokensListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDebugTokensListCall) Context(ctx context.Context) *ProjectsAppsDebugTokensListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDebugTokensListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/debugTokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.list" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaListDebugTokensResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleFirebaseAppcheckV1betaListDebugTokensResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsDebugTokensListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaListDebugTokensResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaListDebugTokensResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all DebugTokens for the specified app. For security reasons, the `token` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/debugTokens",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.debugTokens.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of DebugTokens to return in the response. Note that an app can have at most 20 debug tokens. The server may return fewer than this at its own discretion. If no value is specified (or too large a value is specified), the server will impose its own limit.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to ListDebugTokens indicating where in the set of DebugTokens to resume listing. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListDebugTokens must match the call that provided the page token; if they do not match, the result is undefined.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The relative resource name of the parent app for which to list each associated DebugToken, in the format: ``` projects/{project_number}/apps/{app_id} ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/debugTokens",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaListDebugTokensResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAppsDebugTokensListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppcheckV1betaListDebugTokensResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebaseappcheck.projects.apps.debugTokens.patch":

type ProjectsAppsDebugTokensPatchCall struct {
	s                                      *Service
	name                                   string
	googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Updates the specified DebugToken. For security reasons, the
// `token` field cannot be updated, nor will it be populated in the
// response, but you can revoke the debug token using DeleteDebugToken.
//
// - name: The relative resource name of the debug token, in the format:
//   ```
//   projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id}
//    ```.
func (r *ProjectsAppsDebugTokensService) Patch(name string, googlefirebaseappcheckv1betadebugtoken *GoogleFirebaseAppcheckV1betaDebugToken) *ProjectsAppsDebugTokensPatchCall {
	c := &ProjectsAppsDebugTokensPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betadebugtoken = googlefirebaseappcheckv1betadebugtoken
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the DebugToken to update.
// Example: `display_name`.
func (c *ProjectsAppsDebugTokensPatchCall) UpdateMask(updateMask string) *ProjectsAppsDebugTokensPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDebugTokensPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsDebugTokensPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDebugTokensPatchCall) Context(ctx context.Context) *ProjectsAppsDebugTokensPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDebugTokensPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDebugTokensPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betadebugtoken)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.debugTokens.patch" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaDebugToken or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleFirebaseAppcheckV1betaDebugToken.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAppsDebugTokensPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDebugToken, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaDebugToken{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified DebugToken. For security reasons, the `token` field cannot be updated, nor will it be populated in the response, but you can revoke the debug token using DeleteDebugToken.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/debugTokens/{debugTokensId}",
	//   "httpMethod": "PATCH",
	//   "id": "firebaseappcheck.projects.apps.debugTokens.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the debug token, in the format: ``` projects/{project_number}/apps/{app_id}/debugTokens/{debug_token_id} ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/debugTokens/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of names of fields in the DebugToken to update. Example: `display_name`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDebugToken"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDebugToken"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.deviceCheckConfig.batchGet":

type ProjectsAppsDeviceCheckConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets the DeviceCheckConfigs for the specified list of apps
// atomically. For security reasons, the `private_key` field is never
// populated in the response.
//
// - parent: The parent project name shared by all DeviceCheckConfigs
//   being retrieved, in the format ``` projects/{project_number} ```
//   The parent collection in the `name` field of any resource being
//   retrieved must match this field, or the entire batch fails.
func (r *ProjectsAppsDeviceCheckConfigService) BatchGet(parent string) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c := &ProjectsAppsDeviceCheckConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative
// resource names of the DeviceCheckConfigs to retrieve, in the format
// ``` projects/{project_number}/apps/{app_id}/deviceCheckConfig ``` A
// maximum of 100 objects can be retrieved in a batch.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Names(names ...string) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsDeviceCheckConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/deviceCheckConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.deviceCheckConfig.batchGet" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsDeviceCheckConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the DeviceCheckConfigs for the specified list of apps atomically. For security reasons, the `private_key` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/-/deviceCheckConfig:batchGet",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.deviceCheckConfig.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The relative resource names of the DeviceCheckConfigs to retrieve, in the format ``` projects/{project_number}/apps/{app_id}/deviceCheckConfig ``` A maximum of 100 objects can be retrieved in a batch.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent project name shared by all DeviceCheckConfigs being retrieved, in the format ``` projects/{project_number} ``` The parent collection in the `name` field of any resource being retrieved must match this field, or the entire batch fails.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/apps/-/deviceCheckConfig:batchGet",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaBatchGetDeviceCheckConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.deviceCheckConfig.get":

type ProjectsAppsDeviceCheckConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the DeviceCheckConfig for the specified app. For security
// reasons, the `private_key` field is never populated in the response.
//
// - name: The relative resource name of the DeviceCheckConfig, in the
//   format: ```
//   projects/{project_number}/apps/{app_id}/deviceCheckConfig ```.
func (r *ProjectsAppsDeviceCheckConfigService) Get(name string) *ProjectsAppsDeviceCheckConfigGetCall {
	c := &ProjectsAppsDeviceCheckConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsDeviceCheckConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsDeviceCheckConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsDeviceCheckConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Context(ctx context.Context) *ProjectsAppsDeviceCheckConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDeviceCheckConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.deviceCheckConfig.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaDeviceCheckConfig or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaDeviceCheckConfig.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsDeviceCheckConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDeviceCheckConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaDeviceCheckConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the DeviceCheckConfig for the specified app. For security reasons, the `private_key` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/deviceCheckConfig",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.deviceCheckConfig.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the DeviceCheckConfig, in the format: ``` projects/{project_number}/apps/{app_id}/deviceCheckConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/deviceCheckConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDeviceCheckConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.deviceCheckConfig.patch":

type ProjectsAppsDeviceCheckConfigPatchCall struct {
	s                                             *Service
	name                                          string
	googlefirebaseappcheckv1betadevicecheckconfig *GoogleFirebaseAppcheckV1betaDeviceCheckConfig
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates the DeviceCheckConfig for the specified app. While
// this configuration is incomplete or invalid, the app will be unable
// to exchange DeviceCheck tokens for App Check tokens. For security
// reasons, the `private_key` field is never populated in the response.
//
// - name: The relative resource name of the DeviceCheck configuration
//   object, in the format: ```
//   projects/{project_number}/apps/{app_id}/deviceCheckConfig ```.
func (r *ProjectsAppsDeviceCheckConfigService) Patch(name string, googlefirebaseappcheckv1betadevicecheckconfig *GoogleFirebaseAppcheckV1betaDeviceCheckConfig) *ProjectsAppsDeviceCheckConfigPatchCall {
	c := &ProjectsAppsDeviceCheckConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betadevicecheckconfig = googlefirebaseappcheckv1betadevicecheckconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the DeviceCheckConfig Gets
// to update. Example: `key_id,private_key`.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsDeviceCheckConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsDeviceCheckConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Context(ctx context.Context) *ProjectsAppsDeviceCheckConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsDeviceCheckConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betadevicecheckconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.deviceCheckConfig.patch" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaDeviceCheckConfig or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaDeviceCheckConfig.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsDeviceCheckConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaDeviceCheckConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaDeviceCheckConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the DeviceCheckConfig for the specified app. While this configuration is incomplete or invalid, the app will be unable to exchange DeviceCheck tokens for App Check tokens. For security reasons, the `private_key` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/deviceCheckConfig",
	//   "httpMethod": "PATCH",
	//   "id": "firebaseappcheck.projects.apps.deviceCheckConfig.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the DeviceCheck configuration object, in the format: ``` projects/{project_number}/apps/{app_id}/deviceCheckConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/deviceCheckConfig$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of names of fields in the DeviceCheckConfig Gets to update. Example: `key_id,private_key`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDeviceCheckConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaDeviceCheckConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.recaptchaConfig.batchGet":

type ProjectsAppsRecaptchaConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets the RecaptchaConfigs for the specified list of apps
// atomically. For security reasons, the `site_secret` field is never
// populated in the response.
//
// - parent: The parent project name shared by all RecaptchaConfigs
//   being retrieved, in the format ``` projects/{project_number} ```
//   The parent collection in the `name` field of any resource being
//   retrieved must match this field, or the entire batch fails.
func (r *ProjectsAppsRecaptchaConfigService) BatchGet(parent string) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c := &ProjectsAppsRecaptchaConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative
// resource names of the RecaptchaConfigs to retrieve, in the format:
// ``` projects/{project_number}/apps/{app_id}/recaptchaConfig ``` A
// maximum of 100 objects can be retrieved in a batch.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Names(names ...string) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/recaptchaConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaConfig.batchGet" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsRecaptchaConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the RecaptchaConfigs for the specified list of apps atomically. For security reasons, the `site_secret` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/-/recaptchaConfig:batchGet",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.recaptchaConfig.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The relative resource names of the RecaptchaConfigs to retrieve, in the format: ``` projects/{project_number}/apps/{app_id}/recaptchaConfig ``` A maximum of 100 objects can be retrieved in a batch.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent project name shared by all RecaptchaConfigs being retrieved, in the format ``` projects/{project_number} ``` The parent collection in the `name` field of any resource being retrieved must match this field, or the entire batch fails.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/apps/-/recaptchaConfig:batchGet",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaBatchGetRecaptchaConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.recaptchaConfig.get":

type ProjectsAppsRecaptchaConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the RecaptchaConfig for the specified app. For security
// reasons, the `site_secret` field is never populated in the response.
//
// - name: The relative resource name of the RecaptchaConfig, in the
//   format: ``` projects/{project_number}/apps/{app_id}/recaptchaConfig
//   ```.
func (r *ProjectsAppsRecaptchaConfigService) Get(name string) *ProjectsAppsRecaptchaConfigGetCall {
	c := &ProjectsAppsRecaptchaConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsRecaptchaConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsRecaptchaConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsRecaptchaConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsRecaptchaConfigGetCall) Context(ctx context.Context) *ProjectsAppsRecaptchaConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsRecaptchaConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaConfig.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaRecaptchaConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaConfig.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsRecaptchaConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the RecaptchaConfig for the specified app. For security reasons, the `site_secret` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/recaptchaConfig",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.recaptchaConfig.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the RecaptchaConfig, in the format: ``` projects/{project_number}/apps/{app_id}/recaptchaConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/recaptchaConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaRecaptchaConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.recaptchaConfig.patch":

type ProjectsAppsRecaptchaConfigPatchCall struct {
	s                                           *Service
	name                                        string
	googlefirebaseappcheckv1betarecaptchaconfig *GoogleFirebaseAppcheckV1betaRecaptchaConfig
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates the RecaptchaConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to
// exchange reCAPTCHA tokens for App Check tokens. For security reasons,
// the `site_secret` field is never populated in the response.
//
// - name: The relative resource name of the reCAPTCHA v3 configuration
//   object, in the format: ```
//   projects/{project_number}/apps/{app_id}/recaptchaConfig ```.
func (r *ProjectsAppsRecaptchaConfigService) Patch(name string, googlefirebaseappcheckv1betarecaptchaconfig *GoogleFirebaseAppcheckV1betaRecaptchaConfig) *ProjectsAppsRecaptchaConfigPatchCall {
	c := &ProjectsAppsRecaptchaConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betarecaptchaconfig = googlefirebaseappcheckv1betarecaptchaconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the RecaptchaConfig to
// update. Example: `site_secret`.
func (c *ProjectsAppsRecaptchaConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsRecaptchaConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsRecaptchaConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Context(ctx context.Context) *ProjectsAppsRecaptchaConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsRecaptchaConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betarecaptchaconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.recaptchaConfig.patch" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaRecaptchaConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaRecaptchaConfig.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsRecaptchaConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaRecaptchaConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaRecaptchaConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the RecaptchaConfig for the specified app. While this configuration is incomplete or invalid, the app will be unable to exchange reCAPTCHA tokens for App Check tokens. For security reasons, the `site_secret` field is never populated in the response.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/recaptchaConfig",
	//   "httpMethod": "PATCH",
	//   "id": "firebaseappcheck.projects.apps.recaptchaConfig.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the reCAPTCHA v3 configuration object, in the format: ``` projects/{project_number}/apps/{app_id}/recaptchaConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/recaptchaConfig$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of names of fields in the RecaptchaConfig to update. Example: `site_secret`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaRecaptchaConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaRecaptchaConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.safetyNetConfig.batchGet":

type ProjectsAppsSafetyNetConfigBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets the SafetyNetConfigs for the specified list of apps
// atomically.
//
// - parent: The parent project name shared by all SafetyNetConfigs
//   being retrieved, in the format ``` projects/{project_number} ```
//   The parent collection in the `name` field of any resource being
//   retrieved must match this field, or the entire batch fails.
func (r *ProjectsAppsSafetyNetConfigService) BatchGet(parent string) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c := &ProjectsAppsSafetyNetConfigBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The relative
// resource names of the SafetyNetConfigs to retrieve, in the format ```
// projects/{project_number}/apps/{app_id}/safetyNetConfig ``` A maximum
// of 100 objects can be retrieved in a batch.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Names(names ...string) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Context(ctx context.Context) *ProjectsAppsSafetyNetConfigBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsSafetyNetConfigBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/apps/-/safetyNetConfig:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.safetyNetConfig.batchGet" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsSafetyNetConfigBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the SafetyNetConfigs for the specified list of apps atomically.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/-/safetyNetConfig:batchGet",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.safetyNetConfig.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The relative resource names of the SafetyNetConfigs to retrieve, in the format ``` projects/{project_number}/apps/{app_id}/safetyNetConfig ``` A maximum of 100 objects can be retrieved in a batch.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent project name shared by all SafetyNetConfigs being retrieved, in the format ``` projects/{project_number} ``` The parent collection in the `name` field of any resource being retrieved must match this field, or the entire batch fails.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/apps/-/safetyNetConfig:batchGet",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaBatchGetSafetyNetConfigsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.safetyNetConfig.get":

type ProjectsAppsSafetyNetConfigGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the SafetyNetConfig for the specified app.
//
// - name: The relative resource name of the SafetyNetConfig, in the
//   format: ``` projects/{project_number}/apps/{app_id}/safetyNetConfig
//   ```.
func (r *ProjectsAppsSafetyNetConfigService) Get(name string) *ProjectsAppsSafetyNetConfigGetCall {
	c := &ProjectsAppsSafetyNetConfigGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsSafetyNetConfigGetCall) Fields(s ...googleapi.Field) *ProjectsAppsSafetyNetConfigGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAppsSafetyNetConfigGetCall) IfNoneMatch(entityTag string) *ProjectsAppsSafetyNetConfigGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsSafetyNetConfigGetCall) Context(ctx context.Context) *ProjectsAppsSafetyNetConfigGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsSafetyNetConfigGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsSafetyNetConfigGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.safetyNetConfig.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaSafetyNetConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaSafetyNetConfig.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsSafetyNetConfigGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaSafetyNetConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaSafetyNetConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the SafetyNetConfig for the specified app.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/safetyNetConfig",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.apps.safetyNetConfig.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the SafetyNetConfig, in the format: ``` projects/{project_number}/apps/{app_id}/safetyNetConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/safetyNetConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaSafetyNetConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.apps.safetyNetConfig.patch":

type ProjectsAppsSafetyNetConfigPatchCall struct {
	s                                           *Service
	name                                        string
	googlefirebaseappcheckv1betasafetynetconfig *GoogleFirebaseAppcheckV1betaSafetyNetConfig
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates the SafetyNetConfig for the specified app. While this
// configuration is incomplete or invalid, the app will be unable to
// exchange SafetyNet tokens for App Check tokens.
//
// - name: The relative resource name of the SafetyNet configuration
//   object, in the format: ```
//   projects/{project_number}/apps/{app_id}/safetyNetConfig ```.
func (r *ProjectsAppsSafetyNetConfigService) Patch(name string, googlefirebaseappcheckv1betasafetynetconfig *GoogleFirebaseAppcheckV1betaSafetyNetConfig) *ProjectsAppsSafetyNetConfigPatchCall {
	c := &ProjectsAppsSafetyNetConfigPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betasafetynetconfig = googlefirebaseappcheckv1betasafetynetconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the SafetyNetConfig Gets
// to update. Example: `token_ttl`.
func (c *ProjectsAppsSafetyNetConfigPatchCall) UpdateMask(updateMask string) *ProjectsAppsSafetyNetConfigPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsSafetyNetConfigPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Context(ctx context.Context) *ProjectsAppsSafetyNetConfigPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsSafetyNetConfigPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betasafetynetconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.apps.safetyNetConfig.patch" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaSafetyNetConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaSafetyNetConfig.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsSafetyNetConfigPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaSafetyNetConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaSafetyNetConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the SafetyNetConfig for the specified app. While this configuration is incomplete or invalid, the app will be unable to exchange SafetyNet tokens for App Check tokens.",
	//   "flatPath": "v1beta/projects/{projectsId}/apps/{appsId}/safetyNetConfig",
	//   "httpMethod": "PATCH",
	//   "id": "firebaseappcheck.projects.apps.safetyNetConfig.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the SafetyNet configuration object, in the format: ``` projects/{project_number}/apps/{app_id}/safetyNetConfig ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/apps/[^/]+/safetyNetConfig$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of names of fields in the SafetyNetConfig Gets to update. Example: `token_ttl`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaSafetyNetConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaSafetyNetConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.services.batchUpdate":

type ProjectsServicesBatchUpdateCall struct {
	s                                                      *Service
	parent                                                 string
	googlefirebaseappcheckv1betabatchupdateservicesrequest *GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchUpdate: Updates the specified Service configurations atomically.
//
// - parent: The parent project name shared by all Service
//   configurations being updated, in the format ```
//   projects/{project_number} ``` The parent collection in the `name`
//   field of any resource being updated must match this field, or the
//   entire batch fails.
func (r *ProjectsServicesService) BatchUpdate(parent string, googlefirebaseappcheckv1betabatchupdateservicesrequest *GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest) *ProjectsServicesBatchUpdateCall {
	c := &ProjectsServicesBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappcheckv1betabatchupdateservicesrequest = googlefirebaseappcheckv1betabatchupdateservicesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsServicesBatchUpdateCall) Fields(s ...googleapi.Field) *ProjectsServicesBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsServicesBatchUpdateCall) Context(ctx context.Context) *ProjectsServicesBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsServicesBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betabatchupdateservicesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/services:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.batchUpdate" call.
// Exactly one of
// *GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsServicesBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified Service configurations atomically.",
	//   "flatPath": "v1beta/projects/{projectsId}/services:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "firebaseappcheck.projects.services.batchUpdate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent project name shared by all Service configurations being updated, in the format ``` projects/{project_number} ``` The parent collection in the `name` field of any resource being updated must match this field, or the entire batch fails.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/services:batchUpdate",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaBatchUpdateServicesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaBatchUpdateServicesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.services.get":

type ProjectsServicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the Service configuration for the specified service name.
//
// - name: The relative resource name of the Service to retrieve, in the
//   format: ``` projects/{project_number}/services/{service_id} ```
//   Note that the `service_id` element must be a supported service ID.
//   Currently, the following service IDs are supported: *
//   `firebasestorage.googleapis.com` (Cloud Storage for Firebase) *
//   `firebasedatabase.googleapis.com` (Firebase Realtime Database) *
//   `firestore.googleapis.com` (Cloud Firestore).
func (r *ProjectsServicesService) Get(name string) *ProjectsServicesGetCall {
	c := &ProjectsServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsServicesGetCall) Fields(s ...googleapi.Field) *ProjectsServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsServicesGetCall) IfNoneMatch(entityTag string) *ProjectsServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsServicesGetCall) Context(ctx context.Context) *ProjectsServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.get" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaService or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleFirebaseAppcheckV1betaService.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsServicesGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaService, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaService{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the Service configuration for the specified service name.",
	//   "flatPath": "v1beta/projects/{projectsId}/services/{servicesId}",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.services.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the Service to retrieve, in the format: ``` projects/{project_number}/services/{service_id} ``` Note that the `service_id` element must be a supported service ID. Currently, the following service IDs are supported: * `firebasestorage.googleapis.com` (Cloud Storage for Firebase) * `firebasedatabase.googleapis.com` (Firebase Realtime Database) * `firestore.googleapis.com` (Cloud Firestore)",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/services/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaService"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebaseappcheck.projects.services.list":

type ProjectsServicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Service configurations for the specified project.
// Only Services which were explicitly configured using UpdateService or
// BatchUpdateServices will be returned.
//
// - parent: The relative resource name of the parent project for which
//   to list each associated Service, in the format: ```
//   projects/{project_number} ```.
func (r *ProjectsServicesService) List(parent string) *ProjectsServicesListCall {
	c := &ProjectsServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Services to return in the response. Only explicitly configured
// services are returned. The server may return fewer than this at its
// own discretion. If no value is specified (or too large a value is
// specified), the server will impose its own limit.
func (c *ProjectsServicesListCall) PageSize(pageSize int64) *ProjectsServicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to ListServices indicating where in the set of
// Services to resume listing. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to ListServices
// must match the call that provided the page token; if they do not
// match, the result is undefined.
func (c *ProjectsServicesListCall) PageToken(pageToken string) *ProjectsServicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsServicesListCall) Fields(s ...googleapi.Field) *ProjectsServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsServicesListCall) IfNoneMatch(entityTag string) *ProjectsServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsServicesListCall) Context(ctx context.Context) *ProjectsServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.list" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaListServicesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleFirebaseAppcheckV1betaListServicesResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsServicesListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaListServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaListServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all Service configurations for the specified project. Only Services which were explicitly configured using UpdateService or BatchUpdateServices will be returned.",
	//   "flatPath": "v1beta/projects/{projectsId}/services",
	//   "httpMethod": "GET",
	//   "id": "firebaseappcheck.projects.services.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Services to return in the response. Only explicitly configured services are returned. The server may return fewer than this at its own discretion. If no value is specified (or too large a value is specified), the server will impose its own limit.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to ListServices indicating where in the set of Services to resume listing. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListServices must match the call that provided the page token; if they do not match, the result is undefined.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The relative resource name of the parent project for which to list each associated Service, in the format: ``` projects/{project_number} ```",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+parent}/services",
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaListServicesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsServicesListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppcheckV1betaListServicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebaseappcheck.projects.services.patch":

type ProjectsServicesPatchCall struct {
	s                                   *Service
	name                                string
	googlefirebaseappcheckv1betaservice *GoogleFirebaseAppcheckV1betaService
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates the specified Service configuration.
//
// - name: The relative resource name of the service configuration
//   object, in the format: ```
//   projects/{project_number}/services/{service_id} ``` Note that the
//   `service_id` element must be a supported service ID. Currently, the
//   following service IDs are supported: *
//   `firebasestorage.googleapis.com` (Cloud Storage for Firebase) *
//   `firebasedatabase.googleapis.com` (Firebase Realtime Database) *
//   `firestore.googleapis.com` (Cloud Firestore).
func (r *ProjectsServicesService) Patch(name string, googlefirebaseappcheckv1betaservice *GoogleFirebaseAppcheckV1betaService) *ProjectsServicesPatchCall {
	c := &ProjectsServicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappcheckv1betaservice = googlefirebaseappcheckv1betaservice
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A
// comma-separated list of names of fields in the Service to update.
// Example: `enforcement_mode`.
func (c *ProjectsServicesPatchCall) UpdateMask(updateMask string) *ProjectsServicesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsServicesPatchCall) Fields(s ...googleapi.Field) *ProjectsServicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsServicesPatchCall) Context(ctx context.Context) *ProjectsServicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsServicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsServicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210930")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappcheckv1betaservice)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappcheck.projects.services.patch" call.
// Exactly one of *GoogleFirebaseAppcheckV1betaService or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleFirebaseAppcheckV1betaService.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsServicesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppcheckV1betaService, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleFirebaseAppcheckV1betaService{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified Service configuration.",
	//   "flatPath": "v1beta/projects/{projectsId}/services/{servicesId}",
	//   "httpMethod": "PATCH",
	//   "id": "firebaseappcheck.projects.services.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The relative resource name of the service configuration object, in the format: ``` projects/{project_number}/services/{service_id} ``` Note that the `service_id` element must be a supported service ID. Currently, the following service IDs are supported: * `firebasestorage.googleapis.com` (Cloud Storage for Firebase) * `firebasedatabase.googleapis.com` (Firebase Realtime Database) * `firestore.googleapis.com` (Cloud Firestore)",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/services/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. A comma-separated list of names of fields in the Service to update. Example: `enforcement_mode`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta/{+name}",
	//   "request": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaService"
	//   },
	//   "response": {
	//     "$ref": "GoogleFirebaseAppcheckV1betaService"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}
