// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package networkservices provides access to the Network Services API.
//
// For product documentation, see: https://cloud.google.com/networking
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/networkservices/v1beta1"
//	...
//	ctx := context.Background()
//	networkservicesService, err := networkservices.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	networkservicesService, err := networkservices.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	networkservicesService, err := networkservices.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package networkservices // import "google.golang.org/api/networkservices/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "networkservices:v1beta1"
const apiName = "networkservices"
const apiVersion = "v1beta1"
const basePath = "https://networkservices.googleapis.com/"
const basePathTemplate = "https://networkservices.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://networkservices.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AuthzExtensions = NewProjectsLocationsAuthzExtensionsService(s)
	rs.EndpointPolicies = NewProjectsLocationsEndpointPoliciesService(s)
	rs.Gateways = NewProjectsLocationsGatewaysService(s)
	rs.GrpcRoutes = NewProjectsLocationsGrpcRoutesService(s)
	rs.HttpRoutes = NewProjectsLocationsHttpRoutesService(s)
	rs.LbEdgeExtensions = NewProjectsLocationsLbEdgeExtensionsService(s)
	rs.LbRouteExtensions = NewProjectsLocationsLbRouteExtensionsService(s)
	rs.LbTrafficExtensions = NewProjectsLocationsLbTrafficExtensionsService(s)
	rs.Meshes = NewProjectsLocationsMeshesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.ServiceBindings = NewProjectsLocationsServiceBindingsService(s)
	rs.ServiceLbPolicies = NewProjectsLocationsServiceLbPoliciesService(s)
	rs.TcpRoutes = NewProjectsLocationsTcpRoutesService(s)
	rs.TlsRoutes = NewProjectsLocationsTlsRoutesService(s)
	rs.WasmPlugins = NewProjectsLocationsWasmPluginsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AuthzExtensions *ProjectsLocationsAuthzExtensionsService

	EndpointPolicies *ProjectsLocationsEndpointPoliciesService

	Gateways *ProjectsLocationsGatewaysService

	GrpcRoutes *ProjectsLocationsGrpcRoutesService

	HttpRoutes *ProjectsLocationsHttpRoutesService

	LbEdgeExtensions *ProjectsLocationsLbEdgeExtensionsService

	LbRouteExtensions *ProjectsLocationsLbRouteExtensionsService

	LbTrafficExtensions *ProjectsLocationsLbTrafficExtensionsService

	Meshes *ProjectsLocationsMeshesService

	Operations *ProjectsLocationsOperationsService

	ServiceBindings *ProjectsLocationsServiceBindingsService

	ServiceLbPolicies *ProjectsLocationsServiceLbPoliciesService

	TcpRoutes *ProjectsLocationsTcpRoutesService

	TlsRoutes *ProjectsLocationsTlsRoutesService

	WasmPlugins *ProjectsLocationsWasmPluginsService
}

func NewProjectsLocationsAuthzExtensionsService(s *Service) *ProjectsLocationsAuthzExtensionsService {
	rs := &ProjectsLocationsAuthzExtensionsService{s: s}
	return rs
}

type ProjectsLocationsAuthzExtensionsService struct {
	s *Service
}

func NewProjectsLocationsEndpointPoliciesService(s *Service) *ProjectsLocationsEndpointPoliciesService {
	rs := &ProjectsLocationsEndpointPoliciesService{s: s}
	return rs
}

type ProjectsLocationsEndpointPoliciesService struct {
	s *Service
}

func NewProjectsLocationsGatewaysService(s *Service) *ProjectsLocationsGatewaysService {
	rs := &ProjectsLocationsGatewaysService{s: s}
	rs.RouteViews = NewProjectsLocationsGatewaysRouteViewsService(s)
	return rs
}

type ProjectsLocationsGatewaysService struct {
	s *Service

	RouteViews *ProjectsLocationsGatewaysRouteViewsService
}

func NewProjectsLocationsGatewaysRouteViewsService(s *Service) *ProjectsLocationsGatewaysRouteViewsService {
	rs := &ProjectsLocationsGatewaysRouteViewsService{s: s}
	return rs
}

type ProjectsLocationsGatewaysRouteViewsService struct {
	s *Service
}

func NewProjectsLocationsGrpcRoutesService(s *Service) *ProjectsLocationsGrpcRoutesService {
	rs := &ProjectsLocationsGrpcRoutesService{s: s}
	return rs
}

type ProjectsLocationsGrpcRoutesService struct {
	s *Service
}

func NewProjectsLocationsHttpRoutesService(s *Service) *ProjectsLocationsHttpRoutesService {
	rs := &ProjectsLocationsHttpRoutesService{s: s}
	return rs
}

type ProjectsLocationsHttpRoutesService struct {
	s *Service
}

func NewProjectsLocationsLbEdgeExtensionsService(s *Service) *ProjectsLocationsLbEdgeExtensionsService {
	rs := &ProjectsLocationsLbEdgeExtensionsService{s: s}
	return rs
}

type ProjectsLocationsLbEdgeExtensionsService struct {
	s *Service
}

func NewProjectsLocationsLbRouteExtensionsService(s *Service) *ProjectsLocationsLbRouteExtensionsService {
	rs := &ProjectsLocationsLbRouteExtensionsService{s: s}
	return rs
}

type ProjectsLocationsLbRouteExtensionsService struct {
	s *Service
}

func NewProjectsLocationsLbTrafficExtensionsService(s *Service) *ProjectsLocationsLbTrafficExtensionsService {
	rs := &ProjectsLocationsLbTrafficExtensionsService{s: s}
	return rs
}

type ProjectsLocationsLbTrafficExtensionsService struct {
	s *Service
}

func NewProjectsLocationsMeshesService(s *Service) *ProjectsLocationsMeshesService {
	rs := &ProjectsLocationsMeshesService{s: s}
	rs.RouteViews = NewProjectsLocationsMeshesRouteViewsService(s)
	return rs
}

type ProjectsLocationsMeshesService struct {
	s *Service

	RouteViews *ProjectsLocationsMeshesRouteViewsService
}

func NewProjectsLocationsMeshesRouteViewsService(s *Service) *ProjectsLocationsMeshesRouteViewsService {
	rs := &ProjectsLocationsMeshesRouteViewsService{s: s}
	return rs
}

type ProjectsLocationsMeshesRouteViewsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsServiceBindingsService(s *Service) *ProjectsLocationsServiceBindingsService {
	rs := &ProjectsLocationsServiceBindingsService{s: s}
	return rs
}

type ProjectsLocationsServiceBindingsService struct {
	s *Service
}

func NewProjectsLocationsServiceLbPoliciesService(s *Service) *ProjectsLocationsServiceLbPoliciesService {
	rs := &ProjectsLocationsServiceLbPoliciesService{s: s}
	return rs
}

type ProjectsLocationsServiceLbPoliciesService struct {
	s *Service
}

func NewProjectsLocationsTcpRoutesService(s *Service) *ProjectsLocationsTcpRoutesService {
	rs := &ProjectsLocationsTcpRoutesService{s: s}
	return rs
}

type ProjectsLocationsTcpRoutesService struct {
	s *Service
}

func NewProjectsLocationsTlsRoutesService(s *Service) *ProjectsLocationsTlsRoutesService {
	rs := &ProjectsLocationsTlsRoutesService{s: s}
	return rs
}

type ProjectsLocationsTlsRoutesService struct {
	s *Service
}

func NewProjectsLocationsWasmPluginsService(s *Service) *ProjectsLocationsWasmPluginsService {
	rs := &ProjectsLocationsWasmPluginsService{s: s}
	rs.Versions = NewProjectsLocationsWasmPluginsVersionsService(s)
	return rs
}

type ProjectsLocationsWasmPluginsService struct {
	s *Service

	Versions *ProjectsLocationsWasmPluginsVersionsService
}

func NewProjectsLocationsWasmPluginsVersionsService(s *Service) *ProjectsLocationsWasmPluginsVersionsService {
	rs := &ProjectsLocationsWasmPluginsVersionsService{s: s}
	return rs
}

type ProjectsLocationsWasmPluginsVersionsService struct {
	s *Service
}

// AuthzExtension: `AuthzExtension` is a resource that allows traffic
// forwarding to a callout backend service to make an authorization decision.
type AuthzExtension struct {
	// Authority: Required. The `:authority` header in the gRPC request sent from
	// Envoy to the extension service.
	Authority string `json:"authority,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// FailOpen: Optional. Determines how the proxy behaves if the call to the
	// extension fails or times out. When set to `TRUE`, request or response
	// processing continues without error. Any subsequent extensions in the
	// extension chain are also executed. When set to `FALSE` or the default
	// setting of `FALSE` is used, one of the following happens: * If response
	// headers have not been delivered to the downstream client, a generic 500
	// error is returned to the client. The error response can be tailored by
	// configuring a custom error response in the load balancer. * If response
	// headers have been delivered, then the HTTP stream to the downstream client
	// is reset.
	FailOpen bool `json:"failOpen,omitempty"`
	// ForwardHeaders: Optional. List of the HTTP headers to forward to the
	// extension (from the client). If omitted, all headers are sent. Each element
	// is a string indicating the header name.
	ForwardHeaders []string `json:"forwardHeaders,omitempty"`
	// Labels: Optional. Set of labels associated with the `AuthzExtension`
	// resource. The format must comply with the requirements for labels
	// (/compute/docs/labeling-resources#requirements) for Google Cloud resources.
	Labels map[string]string `json:"labels,omitempty"`
	// LoadBalancingScheme: Required. All backend services and forwarding rules
	// referenced by this extension must share the same load balancing scheme.
	// Supported values: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more
	// information, refer to Backend services overview
	// (https://cloud.google.com/load-balancing/docs/backend-service).
	//
	// Possible values:
	//   "LOAD_BALANCING_SCHEME_UNSPECIFIED" - Default value. Do not use.
	//   "INTERNAL_MANAGED" - Signifies that this is used for Internal HTTP(S) Load
	// Balancing.
	//   "EXTERNAL_MANAGED" - Signifies that this is used for External Managed
	// HTTP(S) Load Balancing.
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`
	// Metadata: Optional. The metadata provided here is included as part of the
	// `metadata_context` (of type `google.protobuf.Struct`) in the
	// `ProcessingRequest` message sent to the extension server. The metadata is
	// available under the namespace `com.google.authz_extension.`. The following
	// variables are supported in the metadata Struct: `{forwarding_rule_id}` -
	// substituted with the forwarding rule's fully qualified resource name.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Required. Identifier. Name of the `AuthzExtension` resource in the
	// following format:
	// `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`.
	Name string `json:"name,omitempty"`
	// Service: Required. The reference to the service that runs the extension. To
	// configure a callout extension, `service` must be a fully-qualified reference
	// to a backend service
	// (https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in
	// the format:
	// `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/ba
	// ckendServices/{backendService}` or
	// `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServi
	// ces/{backendService}`.
	Service string `json:"service,omitempty"`
	// Timeout: Required. Specifies the timeout for each individual message on the
	// stream. The timeout must be between 10-10000 milliseconds.
	Timeout string `json:"timeout,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WireFormat: Optional. The format of communication supported by the callout
	// extension. If not specified, the default value `EXT_PROC_GRPC` is used.
	//
	// Possible values:
	//   "WIRE_FORMAT_UNSPECIFIED" - Not specified.
	//   "EXT_PROC_GRPC" - The extension service uses ext_proc gRPC API over a gRPC
	// stream. This is the default value if the wire format is not specified. The
	// backend service for the extension must use HTTP2 or H2C as the protocol. All
	// `supported_events` for a client request are sent as part of the same gRPC
	// stream.
	//   "EXT_AUTHZ_GRPC" - The extension service uses Envoy's `ext_authz` gRPC
	// API. The backend service for the extension must use HTTP2, or H2C as the
	// protocol. `EXT_AUTHZ_GRPC` is only supported for `AuthzExtension` resources.
	WireFormat string `json:"wireFormat,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Authority") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Authority") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthzExtension) MarshalJSON() ([]byte, error) {
	type NoMethod AuthzExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EndpointMatcher: A definition of a matcher that selects endpoints to which
// the policies should be applied.
type EndpointMatcher struct {
	// MetadataLabelMatcher: The matcher is based on node metadata presented by xDS
	// clients.
	MetadataLabelMatcher *MetadataLabelMatcher `json:"metadataLabelMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataLabelMatcher") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataLabelMatcher") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndpointMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod EndpointMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndpointPolicy: EndpointPolicy is a resource that helps apply desired
// configuration on the endpoints that match specific criteria. For example,
// this resource can be used to apply "authentication config" an all endpoints
// that serve on port 8080.
type EndpointPolicy struct {
	// AuthorizationPolicy: Optional. This field specifies the URL of
	// AuthorizationPolicy resource that applies authorization policies to the
	// inbound traffic at the matched endpoints. Refer to Authorization. If this
	// field is not specified, authorization is disabled(no authz checks) for this
	// endpoint.
	AuthorizationPolicy string `json:"authorizationPolicy,omitempty"`
	// ClientTlsPolicy: Optional. A URL referring to a ClientTlsPolicy resource.
	// ClientTlsPolicy can be set to specify the authentication for traffic from
	// the proxy to the actual endpoints. More specifically, it is applied to the
	// outgoing traffic from the proxy to the endpoint. This is typically used for
	// sidecar model where the proxy identifies itself as endpoint to the control
	// plane, with the connection between sidecar and endpoint requiring
	// authentication. If this field is not set, authentication is disabled(open).
	// Applicable only when EndpointPolicyType is SIDECAR_PROXY.
	ClientTlsPolicy string `json:"clientTlsPolicy,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// EndpointMatcher: Required. A matcher that selects endpoints to which the
	// policies should be applied.
	EndpointMatcher *EndpointMatcher `json:"endpointMatcher,omitempty"`
	// Labels: Optional. Set of label tags associated with the EndpointPolicy
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the EndpointPolicy resource. It matches pattern
	// `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
	Name string `json:"name,omitempty"`
	// SecurityPolicy: Optional. A URL referring to a SecurityPolicy resource.
	// SecurityPolicy is used to enforce rate limiting policy on the inbound
	// traffic at the identified backends. If this field is not set, rate limiting
	// is disabled for this endpoint.
	SecurityPolicy string `json:"securityPolicy,omitempty"`
	// ServerTlsPolicy: Optional. A URL referring to ServerTlsPolicy resource.
	// ServerTlsPolicy is used to determine the authentication policy to be applied
	// to terminate the inbound traffic at the identified backends. If this field
	// is not set, authentication is disabled(open) for this endpoint.
	ServerTlsPolicy string `json:"serverTlsPolicy,omitempty"`
	// TrafficPortSelector: Optional. Port selector for the (matched) endpoints. If
	// no port selector is provided, the matched config is applied to all ports.
	TrafficPortSelector *TrafficPortSelector `json:"trafficPortSelector,omitempty"`
	// Type: Required. The type of endpoint policy. This is primarily used to
	// validate the configuration.
	//
	// Possible values:
	//   "ENDPOINT_POLICY_TYPE_UNSPECIFIED" - Default value. Must not be used.
	//   "SIDECAR_PROXY" - Represents a proxy deployed as a sidecar.
	//   "GRPC_SERVER" - Represents a proxyless gRPC backend.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizationPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizationPolicy") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndpointPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod EndpointPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExtensionChain: A single extension chain wrapper that contains the match
// conditions and extensions to execute.
type ExtensionChain struct {
	// Extensions: Required. A set of extensions to execute for the matching
	// request. At least one extension is required. Up to 3 extensions can be
	// defined for each extension chain for `LbTrafficExtension` resource.
	// `LbRouteExtension` and `LbEdgeExtension` chains are limited to 1 extension
	// per extension chain.
	Extensions []*ExtensionChainExtension `json:"extensions,omitempty"`
	// MatchCondition: Required. Conditions under which this chain is invoked for a
	// request.
	MatchCondition *ExtensionChainMatchCondition `json:"matchCondition,omitempty"`
	// Name: Required. The name for this extension chain. The name is logged as
	// part of the HTTP request logs. The name must conform with RFC-1034, is
	// restricted to lower-cased letters, numbers and hyphens, and can have a
	// maximum length of 63 characters. Additionally, the first character must be a
	// letter and the last a letter or a number.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Extensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Extensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExtensionChain) MarshalJSON() ([]byte, error) {
	type NoMethod ExtensionChain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExtensionChainExtension: A single extension in the chain to execute for the
// matching request.
type ExtensionChainExtension struct {
	// AllowDynamicForwarding: Optional. When set to `TRUE`, the response from an
	// extension service is allowed to set the
	// `com.google.envoy.dynamic_forwarding` namespace in the dynamic metadata.
	// This field is not supported for plugin extensions. Setting it results in a
	// validation error.
	AllowDynamicForwarding bool `json:"allowDynamicForwarding,omitempty"`
	// Authority: Optional. The `:authority` header in the gRPC request sent from
	// Envoy to the extension service. Required for Callout extensions. This field
	// is not supported for plugin extensions. Setting it results in a validation
	// error.
	Authority string `json:"authority,omitempty"`
	// FailOpen: Optional. Determines how the proxy behaves if the call to the
	// extension fails or times out. When set to `TRUE`, request or response
	// processing continues without error. Any subsequent extensions in the
	// extension chain are also executed. When set to `FALSE` or the default
	// setting of `FALSE` is used, one of the following happens: * If response
	// headers have not been delivered to the downstream client, a generic 500
	// error is returned to the client. The error response can be tailored by
	// configuring a custom error response in the load balancer. * If response
	// headers have been delivered, then the HTTP stream to the downstream client
	// is reset.
	FailOpen bool `json:"failOpen,omitempty"`
	// ForwardHeaders: Optional. List of the HTTP headers to forward to the
	// extension (from the client or backend). If omitted, all headers are sent.
	// Each element is a string indicating the header name.
	ForwardHeaders []string `json:"forwardHeaders,omitempty"`
	// Metadata: Optional. The metadata provided here is included as part of the
	// `metadata_context` (of type `google.protobuf.Struct`) in the
	// `ProcessingRequest` message sent to the extension server. The metadata is
	// available under the namespace `com.google....`. For example:
	// `com.google.lb_traffic_extension.lbtrafficextension1.chain1.ext1`. The
	// following variables are supported in the metadata: `{forwarding_rule_id}` -
	// substituted with the forwarding rule's fully qualified resource name. This
	// field must not be set for plugin extensions. Setting it results in a
	// validation error. You can set metadata at either the resource level or the
	// extension level. The extension level metadata is recommended because you can
	// pass a different set of metadata through each extension to the backend. This
	// field is subject to following limitations: * The total size of the metadata
	// must be less than 1KiB. * The total number of keys in the metadata must be
	// less than 16. * The length of each key must be less than 64 characters. *
	// The length of each value must be less than 1024 characters. * All values
	// must be strings.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Required. The name for this extension. The name is logged as part of
	// the HTTP request logs. The name must conform with RFC-1034, is restricted to
	// lower-cased letters, numbers and hyphens, and can have a maximum length of
	// 63 characters. Additionally, the first character must be a letter and the
	// last a letter or a number.
	Name string `json:"name,omitempty"`
	// RequestBodySendMode: Optional. Configures the send mode for request body
	// processing. The field can only be set if `supported_events` includes
	// `REQUEST_BODY`. If `supported_events` includes `REQUEST_BODY`, but
	// `request_body_send_mode` is unset, the default value `STREAMED` is used.
	// When this field is set to `FULL_DUPLEX_STREAMED`, `supported_events` must
	// include both `REQUEST_BODY` and `REQUEST_TRAILERS`. This field can be set
	// only for `LbTrafficExtension` and `LbRouteExtension` resources, and only
	// when the `service` field of the extension points to a `BackendService`. Only
	// `FULL_DUPLEX_STREAMED` mode is supported for `LbRouteExtension` resources.
	//
	// Possible values:
	//   "BODY_SEND_MODE_UNSPECIFIED" - Default value. Do not use.
	//   "BODY_SEND_MODE_STREAMED" - Calls to the extension are executed in the
	// streamed mode. Subsequent chunks will be sent only after the previous chunks
	// have been processed. The content of the body chunks is sent one way to the
	// extension. Extension may send modified chunks back. This is the default
	// value if the processing mode is not specified.
	//   "BODY_SEND_MODE_FULL_DUPLEX_STREAMED" - Calls are executed in the full
	// duplex mode. Subsequent chunks will be sent for processing without waiting
	// for the response for the previous chunk or for the response for
	// `REQUEST_HEADERS` event. Extension can freely modify or chunk the body
	// contents. If the extension doesn't send the body contents back, the next
	// extension in the chain or the upstream will receive an empty body.
	RequestBodySendMode string `json:"requestBodySendMode,omitempty"`
	// ResponseBodySendMode: Optional. Configures the send mode for response
	// processing. If unspecified, the default value `STREAMED` is used. When this
	// field is set to `FULL_DUPLEX_STREAMED`, `supported_events` must include both
	// `RESPONSE_BODY` and `RESPONSE_TRAILERS`. This field can be set only for
	// `LbTrafficExtension` resources, and only when the `service` field of the
	// extension points to a `BackendService`.
	//
	// Possible values:
	//   "BODY_SEND_MODE_UNSPECIFIED" - Default value. Do not use.
	//   "BODY_SEND_MODE_STREAMED" - Calls to the extension are executed in the
	// streamed mode. Subsequent chunks will be sent only after the previous chunks
	// have been processed. The content of the body chunks is sent one way to the
	// extension. Extension may send modified chunks back. This is the default
	// value if the processing mode is not specified.
	//   "BODY_SEND_MODE_FULL_DUPLEX_STREAMED" - Calls are executed in the full
	// duplex mode. Subsequent chunks will be sent for processing without waiting
	// for the response for the previous chunk or for the response for
	// `REQUEST_HEADERS` event. Extension can freely modify or chunk the body
	// contents. If the extension doesn't send the body contents back, the next
	// extension in the chain or the upstream will receive an empty body.
	ResponseBodySendMode string `json:"responseBodySendMode,omitempty"`
	// Service: Required. The reference to the service that runs the extension. To
	// configure a callout extension, `service` must be a fully-qualified reference
	// to a backend service
	// (https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) in
	// the format:
	// `https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/ba
	// ckendServices/{backendService}` or
	// `https://www.googleapis.com/compute/v1/projects/{project}/global/backendServi
	// ces/{backendService}`. To configure a plugin extension, `service` must be a
	// reference to a `WasmPlugin` resource
	// (https://cloud.google.com/service-extensions/docs/reference/rest/v1beta1/projects.locations.wasmPlugins)
	// in the format:
	// `projects/{project}/locations/{location}/wasmPlugins/{plugin}` or
	// `//networkservices.googleapis.com/projects/{project}/locations/{location}/was
	// mPlugins/{wasmPlugin}`. Plugin extensions are currently supported for the
	// `LbTrafficExtension`, the `LbRouteExtension`, and the `LbEdgeExtension`
	// resources.
	Service string `json:"service,omitempty"`
	// SupportedEvents: Optional. A set of events during request or response
	// processing for which this extension is called. For the `LbTrafficExtension`
	// resource, this field is required. For the `LbRouteExtension` resource, this
	// field is optional. If unspecified, `REQUEST_HEADERS` event is assumed as
	// supported. For the `LbEdgeExtension` resource, this field is required and
	// must only contain `REQUEST_HEADERS` event.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Unspecified value. Do not use.
	//   "REQUEST_HEADERS" - If included in `supported_events`, the extension is
	// called when the HTTP request headers arrive.
	//   "REQUEST_BODY" - If included in `supported_events`, the extension is
	// called when the HTTP request body arrives.
	//   "RESPONSE_HEADERS" - If included in `supported_events`, the extension is
	// called when the HTTP response headers arrive.
	//   "RESPONSE_BODY" - If included in `supported_events`, the extension is
	// called when the HTTP response body arrives.
	//   "REQUEST_TRAILERS" - If included in `supported_events`, the extension is
	// called when the HTTP request trailers arrives.
	//   "RESPONSE_TRAILERS" - If included in `supported_events`, the extension is
	// called when the HTTP response trailers arrives.
	SupportedEvents []string `json:"supportedEvents,omitempty"`
	// Timeout: Optional. Specifies the timeout for each individual message on the
	// stream. The timeout must be between `10`-`10000` milliseconds. Required for
	// callout extensions. This field is not supported for plugin extensions.
	// Setting it results in a validation error.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowDynamicForwarding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowDynamicForwarding") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExtensionChainExtension) MarshalJSON() ([]byte, error) {
	type NoMethod ExtensionChainExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExtensionChainMatchCondition: Conditions under which this chain is invoked
// for a request.
type ExtensionChainMatchCondition struct {
	// CelExpression: Required. A Common Expression Language (CEL) expression that
	// is used to match requests for which the extension chain is executed. For
	// more information, see CEL matcher language reference
	// (https://cloud.google.com/service-extensions/docs/cel-matcher-language-reference).
	CelExpression string `json:"celExpression,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CelExpression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CelExpression") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExtensionChainMatchCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ExtensionChainMatchCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Gateway: Gateway represents the configuration for a proxy, typically a load
// balancer. It captures the ip:port over which the services are exposed by the
// proxy, along with any policy configurations. Routes have reference to to
// Gateways to dictate how requests should be routed by this Gateway.
type Gateway struct {
	// Addresses: Optional. Zero or one IPv4 or IPv6 address on which the Gateway
	// will receive the traffic. When no address is provided, an IP from the
	// subnetwork is allocated This field only applies to gateways of type
	// 'SECURE_WEB_GATEWAY'. Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for
	// IPv4 and :: for IPv6.
	Addresses []string `json:"addresses,omitempty"`
	// CertificateUrls: Optional. A fully-qualified Certificates URL reference. The
	// proxy presents a Certificate (selected based on SNI) when establishing a TLS
	// connection. This feature only applies to gateways of type
	// 'SECURE_WEB_GATEWAY'.
	CertificateUrls []string `json:"certificateUrls,omitempty"`
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// EnvoyHeaders: Optional. Determines if envoy will insert internal debug
	// headers into upstream requests. Other Envoy headers may still be injected.
	// By default, envoy will not insert any debug headers.
	//
	// Possible values:
	//   "ENVOY_HEADERS_UNSPECIFIED" - Defaults to NONE.
	//   "NONE" - Suppress envoy debug headers.
	//   "DEBUG_HEADERS" - Envoy will insert default internal debug headers into
	// upstream requests: x-envoy-attempt-count x-envoy-is-timeout-retry
	// x-envoy-expected-rq-timeout-ms x-envoy-original-path
	// x-envoy-upstream-stream-duration-ms
	EnvoyHeaders string `json:"envoyHeaders,omitempty"`
	// GatewaySecurityPolicy: Optional. A fully-qualified GatewaySecurityPolicy URL
	// reference. Defines how a server should apply security policy to inbound (VM
	// to Proxy) initiated connections. For example:
	// `projects/*/locations/*/gatewaySecurityPolicies/swg-policy`. This policy is
	// specific to gateways of type 'SECURE_WEB_GATEWAY'.
	GatewaySecurityPolicy string `json:"gatewaySecurityPolicy,omitempty"`
	// IpVersion: Optional. The IP Version that will be used by this gateway. Valid
	// options are IPV4 or IPV6. Default is IPV4.
	//
	// Possible values:
	//   "IP_VERSION_UNSPECIFIED" - The type when IP version is not specified.
	// Defaults to IPV4.
	//   "IPV4" - The type for IP version 4.
	//   "IPV6" - The type for IP version 6.
	IpVersion string `json:"ipVersion,omitempty"`
	// Labels: Optional. Set of label tags associated with the Gateway resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the Gateway resource. It matches pattern
	// `projects/*/locations/*/gateways/`.
	Name string `json:"name,omitempty"`
	// Network: Optional. The relative resource name identifying the VPC network
	// that is using this configuration. For example:
	// `projects/*/global/networks/network-1`. Currently, this field is specific to
	// gateways of type 'SECURE_WEB_GATEWAY'.
	Network string `json:"network,omitempty"`
	// Ports: Required. One or more port numbers (1-65535), on which the Gateway
	// will receive traffic. The proxy binds to the specified ports. Gateways of
	// type 'SECURE_WEB_GATEWAY' are limited to 5 ports. Gateways of type
	// 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and support multiple
	// ports.
	Ports []int64 `json:"ports,omitempty"`
	// RoutingMode: Optional. The routing mode of the Gateway. This field is
	// configurable only for gateways of type SECURE_WEB_GATEWAY. This field is
	// required for gateways of type SECURE_WEB_GATEWAY.
	//
	// Possible values:
	//   "EXPLICIT_ROUTING_MODE" - The routing mode is explicit; clients are
	// configured to send traffic through the gateway. This is the default routing
	// mode.
	//   "NEXT_HOP_ROUTING_MODE" - The routing mode is next-hop. Clients are
	// unaware of the gateway, and a route (advanced route or other route type) can
	// be configured to direct traffic from client to gateway. The gateway then
	// acts as a next-hop to the destination.
	RoutingMode string `json:"routingMode,omitempty"`
	// Scope: Optional. Scope determines how configuration across multiple Gateway
	// instances are merged. The configuration for multiple Gateway instances with
	// the same scope will be merged as presented as a single configuration to the
	// proxy/load balancer. Max length 64 characters. Scope should start with a
	// letter and can only have letters, numbers, hyphens.
	Scope string `json:"scope,omitempty"`
	// SelfLink: Output only. Server-defined URL of this resource
	SelfLink string `json:"selfLink,omitempty"`
	// ServerTlsPolicy: Optional. A fully-qualified ServerTLSPolicy URL reference.
	// Specifies how TLS traffic is terminated. If empty, TLS termination is
	// disabled.
	ServerTlsPolicy string `json:"serverTlsPolicy,omitempty"`
	// Subnetwork: Optional. The relative resource name identifying the subnetwork
	// in which this SWG is allocated. For example:
	// `projects/*/regions/us-central1/subnetworks/network-1` Currently, this field
	// is specific to gateways of type 'SECURE_WEB_GATEWAY".
	Subnetwork string `json:"subnetwork,omitempty"`
	// Type: Immutable. The type of the customer managed gateway. This field is
	// required. If unspecified, an error is returned.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type of the customer managed gateway is
	// unspecified.
	//   "OPEN_MESH" - The type of the customer managed gateway is TrafficDirector
	// Open Mesh.
	//   "SECURE_WEB_GATEWAY" - The type of the customer managed gateway is
	// SecureWebGateway (SWG).
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Addresses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Gateway) MarshalJSON() ([]byte, error) {
	type NoMethod Gateway
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GatewayRouteView: GatewayRouteView defines view-only resource for Routes to
// a Gateway
type GatewayRouteView struct {
	// Name: Output only. Identifier. Full path name of the GatewayRouteView
	// resource. Format:
	// projects/{project_number}/locations/{location}/gateways/{gateway}/routeViews/
	// {route_view}
	Name string `json:"name,omitempty"`
	// RouteId: Output only. The resource id for the route.
	RouteId string `json:"routeId,omitempty"`
	// RouteLocation: Output only. Location where the route exists.
	RouteLocation string `json:"routeLocation,omitempty"`
	// RouteProjectNumber: Output only. Project number where the route exists.
	RouteProjectNumber int64 `json:"routeProjectNumber,omitempty,string"`
	// RouteType: Output only. Type of the route: HttpRoute,GrpcRoute,TcpRoute, or
	// TlsRoute
	RouteType string `json:"routeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GatewayRouteView) MarshalJSON() ([]byte, error) {
	type NoMethod GatewayRouteView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRoute: GrpcRoute is the resource defining how gRPC traffic routed by a
// Mesh or Gateway resource is routed.
type GrpcRoute struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Gateways: Optional. Gateways defines a list of gateways this GrpcRoute is
	// attached to, as one of the routing rules to route the requests served by the
	// gateway. Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/`
	Gateways []string `json:"gateways,omitempty"`
	// Hostnames: Required. Service hostnames with an optional port for which this
	// route describes traffic. Format: [:] Hostname is the fully qualified domain
	// name of a network host. This matches the RFC 1123 definition of a hostname
	// with 2 notable exceptions: - IPs are not allowed. - A hostname may be
	// prefixed with a wildcard label (`*.`). The wildcard label must appear by
	// itself as the first label. Hostname can be "precise" which is a domain name
	// without the terminating dot of a network host (e.g. `foo.example.com`) or
	// "wildcard", which is a domain name prefixed with a single wildcard label
	// (e.g. `*.example.com`). Note that as per RFC1035 and RFC1123, a label must
	// consist of lower case alphanumeric characters or '-', and must start and end
	// with an alphanumeric character. No other punctuation is allowed. The routes
	// associated with a Mesh or Gateway must have unique hostnames. If you attempt
	// to attach multiple routes with conflicting hostnames, the configuration will
	// be rejected. For example, while it is acceptable for routes for the
	// hostnames `*.foo.bar.com` and `*.bar.com` to be associated with the same
	// route, it is not possible to associate two routes both with `*.bar.com` or
	// both with `bar.com`. If a port is specified, then gRPC clients must use the
	// channel URI with the port to match this rule (i.e. "xds:///service:123"),
	// otherwise they must supply the URI without a port (i.e. "xds:///service").
	Hostnames []string `json:"hostnames,omitempty"`
	// Labels: Optional. Set of label tags associated with the GrpcRoute resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Meshes: Optional. Meshes defines a list of meshes this GrpcRoute is attached
	// to, as one of the routing rules to route the requests served by the mesh.
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/`
	Meshes []string `json:"meshes,omitempty"`
	// Name: Identifier. Name of the GrpcRoute resource. It matches pattern
	// `projects/*/locations/global/grpcRoutes/`
	Name string `json:"name,omitempty"`
	// Rules: Required. A list of detailed rules defining how to route traffic.
	// Within a single GrpcRoute, the GrpcRoute.RouteAction associated with the
	// first matching GrpcRoute.RouteRule will be executed. At least one rule must
	// be supplied.
	Rules []*GrpcRouteRouteRule `json:"rules,omitempty"`
	// SelfLink: Output only. Server-defined URL of this resource
	SelfLink string `json:"selfLink,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteDestination: The destination to which traffic will be routed.
type GrpcRouteDestination struct {
	// ServiceName: Required. The URL of a destination service to which to route
	// traffic. Must refer to either a BackendService or ServiceDirectoryService.
	ServiceName string `json:"serviceName,omitempty"`
	// Weight: Optional. Specifies the proportion of requests forwarded to the
	// backend referenced by the serviceName field. This is computed as: -
	// weight/Sum(weights in this destination list). For non-zero values, there may
	// be some epsilon from the exact proportion defined here depending on the
	// precision an implementation supports. If only one serviceName is specified
	// and it has a weight greater than 0, 100% of the traffic is forwarded to that
	// backend. If weights are specified for any one service name, they need to be
	// specified for all of them. If weights are unspecified for all services,
	// then, traffic is distributed in equal proportions to all of them.
	Weight int64 `json:"weight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteFaultInjectionPolicy: The specification for fault injection
// introduced into traffic to test the resiliency of clients to destination
// service failure. As part of fault injection, when clients send requests to a
// destination, delays can be introduced on a percentage of requests before
// sending those requests to the destination service. Similarly requests from
// clients can be aborted by for a percentage of requests.
type GrpcRouteFaultInjectionPolicy struct {
	// Abort: The specification for aborting to client requests.
	Abort *GrpcRouteFaultInjectionPolicyAbort `json:"abort,omitempty"`
	// Delay: The specification for injecting delay to client requests.
	Delay *GrpcRouteFaultInjectionPolicyDelay `json:"delay,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Abort") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Abort") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteFaultInjectionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteFaultInjectionPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteFaultInjectionPolicyAbort: Specification of how client requests are
// aborted as part of fault injection before being sent to a destination.
type GrpcRouteFaultInjectionPolicyAbort struct {
	// HttpStatus: The HTTP status code used to abort the request. The value must
	// be between 200 and 599 inclusive.
	HttpStatus int64 `json:"httpStatus,omitempty"`
	// Percentage: The percentage of traffic which will be aborted. The value must
	// be between [0, 100]
	Percentage int64 `json:"percentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteFaultInjectionPolicyAbort) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteFaultInjectionPolicyAbort
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteFaultInjectionPolicyDelay: Specification of how client requests are
// delayed as part of fault injection before being sent to a destination.
type GrpcRouteFaultInjectionPolicyDelay struct {
	// FixedDelay: Specify a fixed delay before forwarding the request.
	FixedDelay string `json:"fixedDelay,omitempty"`
	// Percentage: The percentage of traffic on which delay will be injected. The
	// value must be between [0, 100]
	Percentage int64 `json:"percentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedDelay") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedDelay") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteFaultInjectionPolicyDelay) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteFaultInjectionPolicyDelay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteHeaderMatch: A match against a collection of headers.
type GrpcRouteHeaderMatch struct {
	// Key: Required. The key of the header.
	Key string `json:"key,omitempty"`
	// Type: Optional. Specifies how to match against the value of the header. If
	// not specified, a default value of EXACT is used.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "EXACT" - Will only match the exact value provided.
	//   "REGULAR_EXPRESSION" - Will match paths conforming to the prefix specified
	// by value. RE2 syntax is supported.
	Type string `json:"type,omitempty"`
	// Value: Required. The value of the header.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteHeaderMatch) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteHeaderMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteMethodMatch: Specifies a match against a method.
type GrpcRouteMethodMatch struct {
	// CaseSensitive: Optional. Specifies that matches are case sensitive. The
	// default value is true. case_sensitive must not be used with a type of
	// REGULAR_EXPRESSION.
	CaseSensitive bool `json:"caseSensitive,omitempty"`
	// GrpcMethod: Required. Name of the method to match against. If unspecified,
	// will match all methods.
	GrpcMethod string `json:"grpcMethod,omitempty"`
	// GrpcService: Required. Name of the service to match against. If unspecified,
	// will match all services.
	GrpcService string `json:"grpcService,omitempty"`
	// Type: Optional. Specifies how to match against the name. If not specified, a
	// default value of "EXACT" is used.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "EXACT" - Will only match the exact name provided.
	//   "REGULAR_EXPRESSION" - Will interpret grpc_method and grpc_service as
	// regexes. RE2 syntax is supported.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseSensitive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteMethodMatch) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteMethodMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteRetryPolicy: The specifications for retries. Specifies one or more
// conditions for which this retry rule applies. Valid values are:
type GrpcRouteRetryPolicy struct {
	// NumRetries: Specifies the allowed number of retries. This number must be >
	// 0. If not specified, default to 1.
	NumRetries int64 `json:"numRetries,omitempty"`
	// RetryConditions: - connect-failure: Router will retry on failures connecting
	// to Backend Services, for example due to connection timeouts. -
	// refused-stream: Router will retry if the backend service resets the stream
	// with a REFUSED_STREAM error code. This reset type indicates that it is safe
	// to retry. - cancelled: Router will retry if the gRPC status code in the
	// response header is set to cancelled - deadline-exceeded: Router will retry
	// if the gRPC status code in the response header is set to deadline-exceeded -
	// resource-exhausted: Router will retry if the gRPC status code in the
	// response header is set to resource-exhausted - unavailable: Router will
	// retry if the gRPC status code in the response header is set to unavailable
	RetryConditions []string `json:"retryConditions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumRetries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumRetries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteRetryPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteRetryPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteRouteAction: Specifies how to route matched traffic.
type GrpcRouteRouteAction struct {
	// Destinations: Optional. The destination services to which traffic should be
	// forwarded. If multiple destinations are specified, traffic will be split
	// between Backend Service(s) according to the weight field of these
	// destinations.
	Destinations []*GrpcRouteDestination `json:"destinations,omitempty"`
	// FaultInjectionPolicy: Optional. The specification for fault injection
	// introduced into traffic to test the resiliency of clients to destination
	// service failure. As part of fault injection, when clients send requests to a
	// destination, delays can be introduced on a percentage of requests before
	// sending those requests to the destination service. Similarly requests from
	// clients can be aborted by for a percentage of requests. timeout and
	// retry_policy will be ignored by clients that are configured with a
	// fault_injection_policy
	FaultInjectionPolicy *GrpcRouteFaultInjectionPolicy `json:"faultInjectionPolicy,omitempty"`
	// IdleTimeout: Optional. Specifies the idle timeout for the selected route.
	// The idle timeout is defined as the period in which there are no bytes sent
	// or received on either the upstream or downstream connection. If not set, the
	// default idle timeout is 1 hour. If set to 0s, the timeout will be disabled.
	IdleTimeout string `json:"idleTimeout,omitempty"`
	// RetryPolicy: Optional. Specifies the retry policy associated with this
	// route.
	RetryPolicy *GrpcRouteRetryPolicy `json:"retryPolicy,omitempty"`
	// StatefulSessionAffinity: Optional. Specifies cookie-based stateful session
	// affinity.
	StatefulSessionAffinity *GrpcRouteStatefulSessionAffinityPolicy `json:"statefulSessionAffinity,omitempty"`
	// Timeout: Optional. Specifies the timeout for selected route. Timeout is
	// computed from the time the request has been fully processed (i.e. end of
	// stream) up until the response has been completely processed. Timeout
	// includes all retries.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destinations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destinations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteRouteAction) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteRouteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteRouteMatch: Criteria for matching traffic. A RouteMatch will be
// considered to match when all supplied fields match.
type GrpcRouteRouteMatch struct {
	// Headers: Optional. Specifies a collection of headers to match.
	Headers []*GrpcRouteHeaderMatch `json:"headers,omitempty"`
	// Method: Optional. A gRPC method to match against. If this field is empty or
	// omitted, will match all methods.
	Method *GrpcRouteMethodMatch `json:"method,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Headers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Headers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteRouteMatch) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteRouteMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteRouteRule: Describes how to route traffic.
type GrpcRouteRouteRule struct {
	// Action: Required. A detailed rule defining how to route traffic. This field
	// is required.
	Action *GrpcRouteRouteAction `json:"action,omitempty"`
	// Matches: Optional. Matches define conditions used for matching the rule
	// against incoming gRPC requests. Each match is independent, i.e. this rule
	// will be matched if ANY one of the matches is satisfied. If no matches field
	// is specified, this rule will unconditionally match traffic.
	Matches []*GrpcRouteRouteMatch `json:"matches,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteRouteRule) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteRouteRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrpcRouteStatefulSessionAffinityPolicy: The specification for cookie-based
// stateful session affinity where the date plane supplies a “session
// cookie” with the name "GSSA" which encodes a specific destination host and
// each request containing that cookie will be directed to that host as long as
// the destination host remains up and healthy. The gRPC proxyless mesh library
// or sidecar proxy will manage the session cookie but the client application
// code is responsible for copying the cookie from each RPC in the session to
// the next.
type GrpcRouteStatefulSessionAffinityPolicy struct {
	// CookieTtl: Required. The cookie TTL value for the Set-Cookie header
	// generated by the data plane. The lifetime of the cookie may be set to a
	// value from 0 to 86400 seconds (24 hours) inclusive. Set this to 0s to use a
	// session cookie and disable cookie expiration.
	CookieTtl string `json:"cookieTtl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CookieTtl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CookieTtl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrpcRouteStatefulSessionAffinityPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcRouteStatefulSessionAffinityPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRoute: HttpRoute is the resource defining how HTTP traffic should be
// routed by a Mesh or Gateway resource.
type HttpRoute struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Gateways: Optional. Gateways defines a list of gateways this HttpRoute is
	// attached to, as one of the routing rules to route the requests served by the
	// gateway. Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/`
	Gateways []string `json:"gateways,omitempty"`
	// Hostnames: Required. Hostnames define a set of hosts that should match
	// against the HTTP host header to select a HttpRoute to process the request.
	// Hostname is the fully qualified domain name of a network host, as defined by
	// RFC 1123 with the exception that: - IPs are not allowed. - A hostname may be
	// prefixed with a wildcard label (`*.`). The wildcard label must appear by
	// itself as the first label. Hostname can be "precise" which is a domain name
	// without the terminating dot of a network host (e.g. `foo.example.com`) or
	// "wildcard", which is a domain name prefixed with a single wildcard label
	// (e.g. `*.example.com`). Note that as per RFC1035 and RFC1123, a label must
	// consist of lower case alphanumeric characters or '-', and must start and end
	// with an alphanumeric character. No other punctuation is allowed. The routes
	// associated with a Mesh or Gateways must have unique hostnames. If you
	// attempt to attach multiple routes with conflicting hostnames, the
	// configuration will be rejected. For example, while it is acceptable for
	// routes for the hostnames `*.foo.bar.com` and `*.bar.com` to be associated
	// with the same Mesh (or Gateways under the same scope), it is not possible to
	// associate two routes both with `*.bar.com` or both with `bar.com`.
	Hostnames []string `json:"hostnames,omitempty"`
	// Labels: Optional. Set of label tags associated with the HttpRoute resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Meshes: Optional. Meshes defines a list of meshes this HttpRoute is attached
	// to, as one of the routing rules to route the requests served by the mesh.
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/` The attached Mesh should be of a type
	// SIDECAR
	Meshes []string `json:"meshes,omitempty"`
	// Name: Identifier. Name of the HttpRoute resource. It matches pattern
	// `projects/*/locations/global/httpRoutes/http_route_name>`.
	Name string `json:"name,omitempty"`
	// Rules: Required. Rules that define how traffic is routed and handled. Rules
	// will be matched sequentially based on the RouteMatch specified for the rule.
	Rules []*HttpRouteRouteRule `json:"rules,omitempty"`
	// SelfLink: Output only. Server-defined URL of this resource
	SelfLink string `json:"selfLink,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRoute) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteCorsPolicy: The Specification for allowing client side cross-origin
// requests.
type HttpRouteCorsPolicy struct {
	// AllowCredentials: In response to a preflight request, setting this to true
	// indicates that the actual request can include user credentials. This
	// translates to the Access-Control-Allow-Credentials header. Default value is
	// false.
	AllowCredentials bool `json:"allowCredentials,omitempty"`
	// AllowHeaders: Specifies the content for Access-Control-Allow-Headers header.
	AllowHeaders []string `json:"allowHeaders,omitempty"`
	// AllowMethods: Specifies the content for Access-Control-Allow-Methods header.
	AllowMethods []string `json:"allowMethods,omitempty"`
	// AllowOriginRegexes: Specifies the regular expression patterns that match
	// allowed origins. For regular expression grammar, please see
	// https://github.com/google/re2/wiki/Syntax.
	AllowOriginRegexes []string `json:"allowOriginRegexes,omitempty"`
	// AllowOrigins: Specifies the list of origins that will be allowed to do CORS
	// requests. An origin is allowed if it matches either an item in allow_origins
	// or an item in allow_origin_regexes.
	AllowOrigins []string `json:"allowOrigins,omitempty"`
	// Disabled: If true, the CORS policy is disabled. The default value is false,
	// which indicates that the CORS policy is in effect.
	Disabled bool `json:"disabled,omitempty"`
	// ExposeHeaders: Specifies the content for Access-Control-Expose-Headers
	// header.
	ExposeHeaders []string `json:"exposeHeaders,omitempty"`
	// MaxAge: Specifies how long result of a preflight request can be cached in
	// seconds. This translates to the Access-Control-Max-Age header.
	MaxAge string `json:"maxAge,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowCredentials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowCredentials") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteCorsPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteCorsPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteDestination: Specifications of a destination to which the request
// should be routed to.
type HttpRouteDestination struct {
	// RequestHeaderModifier: Optional. The specification for modifying the headers
	// of a matching request prior to delivery of the request to the destination.
	// If HeaderModifiers are set on both the Destination and the RouteAction, they
	// will be merged. Conflicts between the two will not be resolved on the
	// configuration.
	RequestHeaderModifier *HttpRouteHeaderModifier `json:"requestHeaderModifier,omitempty"`
	// ResponseHeaderModifier: Optional. The specification for modifying the
	// headers of a response prior to sending the response back to the client. If
	// HeaderModifiers are set on both the Destination and the RouteAction, they
	// will be merged. Conflicts between the two will not be resolved on the
	// configuration.
	ResponseHeaderModifier *HttpRouteHeaderModifier `json:"responseHeaderModifier,omitempty"`
	// ServiceName: The URL of a BackendService to route traffic to.
	ServiceName string `json:"serviceName,omitempty"`
	// Weight: Specifies the proportion of requests forwarded to the backend
	// referenced by the serviceName field. This is computed as: -
	// weight/Sum(weights in this destination list). For non-zero values, there may
	// be some epsilon from the exact proportion defined here depending on the
	// precision an implementation supports. If only one serviceName is specified
	// and it has a weight greater than 0, 100% of the traffic is forwarded to that
	// backend. If weights are specified for any one service name, they need to be
	// specified for all of them. If weights are unspecified for all services,
	// then, traffic is distributed in equal proportions to all of them.
	Weight int64 `json:"weight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestHeaderModifier") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestHeaderModifier") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteDestination) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteFaultInjectionPolicy: The specification for fault injection
// introduced into traffic to test the resiliency of clients to destination
// service failure. As part of fault injection, when clients send requests to a
// destination, delays can be introduced by client proxy on a percentage of
// requests before sending those requests to the destination service. Similarly
// requests can be aborted by client proxy for a percentage of requests.
type HttpRouteFaultInjectionPolicy struct {
	// Abort: The specification for aborting to client requests.
	Abort *HttpRouteFaultInjectionPolicyAbort `json:"abort,omitempty"`
	// Delay: The specification for injecting delay to client requests.
	Delay *HttpRouteFaultInjectionPolicyDelay `json:"delay,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Abort") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Abort") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteFaultInjectionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteFaultInjectionPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteFaultInjectionPolicyAbort: Specification of how client requests are
// aborted as part of fault injection before being sent to a destination.
type HttpRouteFaultInjectionPolicyAbort struct {
	// HttpStatus: The HTTP status code used to abort the request. The value must
	// be between 200 and 599 inclusive.
	HttpStatus int64 `json:"httpStatus,omitempty"`
	// Percentage: The percentage of traffic which will be aborted. The value must
	// be between [0, 100]
	Percentage int64 `json:"percentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteFaultInjectionPolicyAbort) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteFaultInjectionPolicyAbort
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteFaultInjectionPolicyDelay: Specification of how client requests are
// delayed as part of fault injection before being sent to a destination.
type HttpRouteFaultInjectionPolicyDelay struct {
	// FixedDelay: Specify a fixed delay before forwarding the request.
	FixedDelay string `json:"fixedDelay,omitempty"`
	// Percentage: The percentage of traffic on which delay will be injected. The
	// value must be between [0, 100]
	Percentage int64 `json:"percentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedDelay") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedDelay") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteFaultInjectionPolicyDelay) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteFaultInjectionPolicyDelay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteHeaderMatch: Specifies how to select a route rule based on HTTP
// request headers.
type HttpRouteHeaderMatch struct {
	// ExactMatch: The value of the header should match exactly the content of
	// exact_match.
	ExactMatch string `json:"exactMatch,omitempty"`
	// Header: The name of the HTTP header to match against.
	Header string `json:"header,omitempty"`
	// InvertMatch: If specified, the match result will be inverted before
	// checking. Default value is set to false.
	InvertMatch bool `json:"invertMatch,omitempty"`
	// PrefixMatch: The value of the header must start with the contents of
	// prefix_match.
	PrefixMatch string `json:"prefixMatch,omitempty"`
	// PresentMatch: A header with header_name must exist. The match takes place
	// whether or not the header has a value.
	PresentMatch bool `json:"presentMatch,omitempty"`
	// RangeMatch: If specified, the rule will match if the request header value is
	// within the range.
	RangeMatch *HttpRouteHeaderMatchIntegerRange `json:"rangeMatch,omitempty"`
	// RegexMatch: The value of the header must match the regular expression
	// specified in regex_match. For regular expression grammar, please see:
	// https://github.com/google/re2/wiki/Syntax
	RegexMatch string `json:"regexMatch,omitempty"`
	// SuffixMatch: The value of the header must end with the contents of
	// suffix_match.
	SuffixMatch string `json:"suffixMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteHeaderMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteHeaderMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteHeaderMatchIntegerRange: Represents an integer value range.
type HttpRouteHeaderMatchIntegerRange struct {
	// End: End of the range (exclusive)
	End int64 `json:"end,omitempty"`
	// Start: Start of the range (inclusive)
	Start int64 `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteHeaderMatchIntegerRange) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteHeaderMatchIntegerRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteHeaderModifier: The specification for modifying HTTP header in HTTP
// request and HTTP response.
type HttpRouteHeaderModifier struct {
	// Add: Add the headers with given map where key is the name of the header,
	// value is the value of the header.
	Add map[string]string `json:"add,omitempty"`
	// Remove: Remove headers (matching by header names) specified in the list.
	Remove []string `json:"remove,omitempty"`
	// Set: Completely overwrite/replace the headers with given map where key is
	// the name of the header, value is the value of the header.
	Set map[string]string `json:"set,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Add") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Add") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteHeaderModifier) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteHeaderModifier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteHttpDirectResponse: Static HTTP response object to be returned.
type HttpRouteHttpDirectResponse struct {
	// BytesBody: Optional. Response body as bytes. Maximum body size is 4096B.
	BytesBody string `json:"bytesBody,omitempty"`
	// Status: Required. Status to return as part of HTTP Response. Must be a
	// positive integer.
	Status int64 `json:"status,omitempty"`
	// StringBody: Optional. Response body as a string. Maximum body length is 1024
	// characters.
	StringBody string `json:"stringBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesBody") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesBody") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteHttpDirectResponse) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteHttpDirectResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteQueryParameterMatch: Specifications to match a query parameter in
// the request.
type HttpRouteQueryParameterMatch struct {
	// ExactMatch: The value of the query parameter must exactly match the contents
	// of exact_match. Only one of exact_match, regex_match, or present_match must
	// be set.
	ExactMatch string `json:"exactMatch,omitempty"`
	// PresentMatch: Specifies that the QueryParameterMatcher matches if request
	// contains query parameter, irrespective of whether the parameter has a value
	// or not. Only one of exact_match, regex_match, or present_match must be set.
	PresentMatch bool `json:"presentMatch,omitempty"`
	// QueryParameter: The name of the query parameter to match.
	QueryParameter string `json:"queryParameter,omitempty"`
	// RegexMatch: The value of the query parameter must match the regular
	// expression specified by regex_match. For regular expression grammar, please
	// see https://github.com/google/re2/wiki/Syntax Only one of exact_match,
	// regex_match, or present_match must be set.
	RegexMatch string `json:"regexMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteQueryParameterMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteQueryParameterMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteRedirect: The specification for redirecting traffic.
type HttpRouteRedirect struct {
	// HostRedirect: The host that will be used in the redirect response instead of
	// the one that was supplied in the request.
	HostRedirect string `json:"hostRedirect,omitempty"`
	// HttpsRedirect: If set to true, the URL scheme in the redirected request is
	// set to https. If set to false, the URL scheme of the redirected request will
	// remain the same as that of the request. The default is set to false.
	HttpsRedirect bool `json:"httpsRedirect,omitempty"`
	// PathRedirect: The path that will be used in the redirect response instead of
	// the one that was supplied in the request. path_redirect can not be supplied
	// together with prefix_redirect. Supply one alone or neither. If neither is
	// supplied, the path of the original request will be used for the redirect.
	PathRedirect string `json:"pathRedirect,omitempty"`
	// PortRedirect: The port that will be used in the redirected request instead
	// of the one that was supplied in the request.
	PortRedirect int64 `json:"portRedirect,omitempty"`
	// PrefixRewrite: Indicates that during redirection, the matched prefix (or
	// path) should be swapped with this value. This option allows URLs be
	// dynamically created based on the request.
	PrefixRewrite string `json:"prefixRewrite,omitempty"`
	// ResponseCode: The HTTP Status code to use for the redirect.
	//
	// Possible values:
	//   "RESPONSE_CODE_UNSPECIFIED" - Default value
	//   "MOVED_PERMANENTLY_DEFAULT" - Corresponds to 301.
	//   "FOUND" - Corresponds to 302.
	//   "SEE_OTHER" - Corresponds to 303.
	//   "TEMPORARY_REDIRECT" - Corresponds to 307. In this case, the request
	// method will be retained.
	//   "PERMANENT_REDIRECT" - Corresponds to 308. In this case, the request
	// method will be retained.
	ResponseCode string `json:"responseCode,omitempty"`
	// StripQuery: if set to true, any accompanying query portion of the original
	// URL is removed prior to redirecting the request. If set to false, the query
	// portion of the original URL is retained. The default is set to false.
	StripQuery bool `json:"stripQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HostRedirect") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostRedirect") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteRedirect) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRedirect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteRequestMirrorPolicy: Specifies the policy on how requests are
// shadowed to a separate mirrored destination service. The proxy does not wait
// for responses from the shadow service. Prior to sending traffic to the
// shadow service, the host/authority header is suffixed with -shadow.
// Mirroring is currently not supported for Cloud Run destinations.
type HttpRouteRequestMirrorPolicy struct {
	// Destination: The destination the requests will be mirrored to. The weight of
	// the destination will be ignored.
	Destination *HttpRouteDestination `json:"destination,omitempty"`
	// MirrorPercent: Optional. The percentage of requests to get mirrored to the
	// desired destination.
	MirrorPercent float64 `json:"mirrorPercent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteRequestMirrorPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRequestMirrorPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *HttpRouteRequestMirrorPolicy) UnmarshalJSON(data []byte) error {
	type NoMethod HttpRouteRequestMirrorPolicy
	var s1 struct {
		MirrorPercent gensupport.JSONFloat64 `json:"mirrorPercent"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MirrorPercent = float64(s1.MirrorPercent)
	return nil
}

// HttpRouteRetryPolicy: The specifications for retries.
type HttpRouteRetryPolicy struct {
	// NumRetries: Specifies the allowed number of retries. This number must be >
	// 0. If not specified, default to 1.
	NumRetries int64 `json:"numRetries,omitempty"`
	// PerTryTimeout: Specifies a non-zero timeout per retry attempt.
	PerTryTimeout string `json:"perTryTimeout,omitempty"`
	// RetryConditions: Specifies one or more conditions when this retry policy
	// applies. Valid values are: 5xx: Proxy will attempt a retry if the
	// destination service responds with any 5xx response code, of if the
	// destination service does not respond at all, example: disconnect, reset,
	// read timeout, connection failure and refused streams. gateway-error: Similar
	// to 5xx, but only applies to response codes 502, 503, 504. reset: Proxy will
	// attempt a retry if the destination service does not respond at all
	// (disconnect/reset/read timeout) connect-failure: Proxy will retry on
	// failures connecting to destination for example due to connection timeouts.
	// retriable-4xx: Proxy will retry fro retriable 4xx response codes. Currently
	// the only retriable error supported is 409. refused-stream: Proxy will retry
	// if the destination resets the stream with a REFUSED_STREAM error code. This
	// reset type indicates that it is safe to retry.
	RetryConditions []string `json:"retryConditions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumRetries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumRetries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteRetryPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRetryPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteRouteAction: The specifications for routing traffic and applying
// associated policies.
type HttpRouteRouteAction struct {
	// CorsPolicy: The specification for allowing client side cross-origin
	// requests.
	CorsPolicy *HttpRouteCorsPolicy `json:"corsPolicy,omitempty"`
	// Destinations: The destination to which traffic should be forwarded.
	Destinations []*HttpRouteDestination `json:"destinations,omitempty"`
	// DirectResponse: Optional. Static HTTP Response object to be returned
	// regardless of the request.
	DirectResponse *HttpRouteHttpDirectResponse `json:"directResponse,omitempty"`
	// FaultInjectionPolicy: The specification for fault injection introduced into
	// traffic to test the resiliency of clients to backend service failure. As
	// part of fault injection, when clients send requests to a backend service,
	// delays can be introduced on a percentage of requests before sending those
	// requests to the backend service. Similarly requests from clients can be
	// aborted for a percentage of requests. timeout and retry_policy will be
	// ignored by clients that are configured with a fault_injection_policy
	FaultInjectionPolicy *HttpRouteFaultInjectionPolicy `json:"faultInjectionPolicy,omitempty"`
	// IdleTimeout: Optional. Specifies the idle timeout for the selected route.
	// The idle timeout is defined as the period in which there are no bytes sent
	// or received on either the upstream or downstream connection. If not set, the
	// default idle timeout is 1 hour. If set to 0s, the timeout will be disabled.
	IdleTimeout string `json:"idleTimeout,omitempty"`
	// Redirect: If set, the request is directed as configured by this field.
	Redirect *HttpRouteRedirect `json:"redirect,omitempty"`
	// RequestHeaderModifier: The specification for modifying the headers of a
	// matching request prior to delivery of the request to the destination. If
	// HeaderModifiers are set on both the Destination and the RouteAction, they
	// will be merged. Conflicts between the two will not be resolved on the
	// configuration.
	RequestHeaderModifier *HttpRouteHeaderModifier `json:"requestHeaderModifier,omitempty"`
	// RequestMirrorPolicy: Specifies the policy on how requests intended for the
	// routes destination are shadowed to a separate mirrored destination. Proxy
	// will not wait for the shadow destination to respond before returning the
	// response. Prior to sending traffic to the shadow service, the host/authority
	// header is suffixed with -shadow.
	RequestMirrorPolicy *HttpRouteRequestMirrorPolicy `json:"requestMirrorPolicy,omitempty"`
	// ResponseHeaderModifier: The specification for modifying the headers of a
	// response prior to sending the response back to the client. If
	// HeaderModifiers are set on both the Destination and the RouteAction, they
	// will be merged. Conflicts between the two will not be resolved on the
	// configuration.
	ResponseHeaderModifier *HttpRouteHeaderModifier `json:"responseHeaderModifier,omitempty"`
	// RetryPolicy: Specifies the retry policy associated with this route.
	RetryPolicy *HttpRouteRetryPolicy `json:"retryPolicy,omitempty"`
	// StatefulSessionAffinity: Optional. Specifies cookie-based stateful session
	// affinity.
	StatefulSessionAffinity *HttpRouteStatefulSessionAffinityPolicy `json:"statefulSessionAffinity,omitempty"`
	// Timeout: Specifies the timeout for selected route. Timeout is computed from
	// the time the request has been fully processed (i.e. end of stream) up until
	// the response has been completely processed. Timeout includes all retries.
	Timeout string `json:"timeout,omitempty"`
	// UrlRewrite: The specification for rewrite URL before forwarding requests to
	// the destination.
	UrlRewrite *HttpRouteURLRewrite `json:"urlRewrite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorsPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorsPolicy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteRouteAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRouteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteRouteMatch: RouteMatch defines specifications used to match
// requests. If multiple match types are set, this RouteMatch will match if ALL
// type of matches are matched.
type HttpRouteRouteMatch struct {
	// FullPathMatch: The HTTP request path value should exactly match this value.
	// Only one of full_path_match, prefix_match, or regex_match should be used.
	FullPathMatch string `json:"fullPathMatch,omitempty"`
	// Headers: Specifies a list of HTTP request headers to match against. ALL of
	// the supplied headers must be matched.
	Headers []*HttpRouteHeaderMatch `json:"headers,omitempty"`
	// IgnoreCase: Specifies if prefix_match and full_path_match matches are case
	// sensitive. The default value is false.
	IgnoreCase bool `json:"ignoreCase,omitempty"`
	// PrefixMatch: The HTTP request path value must begin with specified
	// prefix_match. prefix_match must begin with a /. Only one of full_path_match,
	// prefix_match, or regex_match should be used.
	PrefixMatch string `json:"prefixMatch,omitempty"`
	// QueryParameters: Specifies a list of query parameters to match against. ALL
	// of the query parameters must be matched.
	QueryParameters []*HttpRouteQueryParameterMatch `json:"queryParameters,omitempty"`
	// RegexMatch: The HTTP request path value must satisfy the regular expression
	// specified by regex_match after removing any query parameters and anchor
	// supplied with the original URL. For regular expression grammar, please see
	// https://github.com/google/re2/wiki/Syntax Only one of full_path_match,
	// prefix_match, or regex_match should be used.
	RegexMatch string `json:"regexMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullPathMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullPathMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteRouteMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRouteMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteRouteRule: Specifies how to match traffic and how to route traffic
// when traffic is matched.
type HttpRouteRouteRule struct {
	// Action: The detailed rule defining how to route matched traffic.
	Action *HttpRouteRouteAction `json:"action,omitempty"`
	// Matches: A list of matches define conditions used for matching the rule
	// against incoming HTTP requests. Each match is independent, i.e. this rule
	// will be matched if ANY one of the matches is satisfied. If no matches field
	// is specified, this rule will unconditionally match traffic. If a default
	// rule is desired to be configured, add a rule with no matches specified to
	// the end of the rules list.
	Matches []*HttpRouteRouteMatch `json:"matches,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteRouteRule) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRouteRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteStatefulSessionAffinityPolicy: The specification for cookie-based
// stateful session affinity where the date plane supplies a “session
// cookie” with the name "GSSA" which encodes a specific destination host and
// each request containing that cookie will be directed to that host as long as
// the destination host remains up and healthy. The gRPC proxyless mesh library
// or sidecar proxy will manage the session cookie but the client application
// code is responsible for copying the cookie from each RPC in the session to
// the next.
type HttpRouteStatefulSessionAffinityPolicy struct {
	// CookieTtl: Required. The cookie TTL value for the Set-Cookie header
	// generated by the data plane. The lifetime of the cookie may be set to a
	// value from 0 to 86400 seconds (24 hours) inclusive. Set this to 0s to use a
	// session cookie and disable cookie expiration.
	CookieTtl string `json:"cookieTtl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CookieTtl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CookieTtl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteStatefulSessionAffinityPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteStatefulSessionAffinityPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRouteURLRewrite: The specification for modifying the URL of the request,
// prior to forwarding the request to the destination.
type HttpRouteURLRewrite struct {
	// HostRewrite: Prior to forwarding the request to the selected destination,
	// the requests host header is replaced by this value.
	HostRewrite string `json:"hostRewrite,omitempty"`
	// PathPrefixRewrite: Prior to forwarding the request to the selected
	// destination, the matching portion of the requests path is replaced by this
	// value.
	PathPrefixRewrite string `json:"pathPrefixRewrite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HostRewrite") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostRewrite") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRouteURLRewrite) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteURLRewrite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LbEdgeExtension: `LbEdgeExtension` is a resource that lets the extension
// service influence the selection of backend services and Cloud CDN cache keys
// by modifying request headers.
type LbEdgeExtension struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// ExtensionChains: Required. A set of ordered extension chains that contain
	// the match conditions and extensions to execute. Match conditions for each
	// extension chain are evaluated in sequence for a given request. The first
	// extension chain that has a condition that matches the request is executed.
	// Any subsequent extension chains do not execute. Limited to 5 extension
	// chains per resource.
	ExtensionChains []*ExtensionChain `json:"extensionChains,omitempty"`
	// ForwardingRules: Required. A list of references to the forwarding rules to
	// which this service extension is attached. At least one forwarding rule is
	// required. Only one `LbEdgeExtension` resource can be associated with a
	// forwarding rule.
	ForwardingRules []string `json:"forwardingRules,omitempty"`
	// Labels: Optional. Set of labels associated with the `LbEdgeExtension`
	// resource. The format must comply with the requirements for labels
	// (https://cloud.google.com/compute/docs/labeling-resources#requirements) for
	// Google Cloud resources.
	Labels map[string]string `json:"labels,omitempty"`
	// LoadBalancingScheme: Required. All forwarding rules referenced by this
	// extension must share the same load balancing scheme. Supported values:
	// `EXTERNAL_MANAGED`.
	//
	// Possible values:
	//   "LOAD_BALANCING_SCHEME_UNSPECIFIED" - Default value. Do not use.
	//   "INTERNAL_MANAGED" - Signifies that this is used for Internal HTTP(S) Load
	// Balancing.
	//   "EXTERNAL_MANAGED" - Signifies that this is used for External Managed
	// HTTP(S) Load Balancing.
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`
	// Name: Required. Identifier. Name of the `LbEdgeExtension` resource in the
	// following format:
	// `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extension}
	// `.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LbEdgeExtension) MarshalJSON() ([]byte, error) {
	type NoMethod LbEdgeExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LbRouteExtension: `LbRouteExtension` is a resource that lets you control
// where traffic is routed to for a given request.
type LbRouteExtension struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// ExtensionChains: Required. A set of ordered extension chains that contain
	// the match conditions and extensions to execute. Match conditions for each
	// extension chain are evaluated in sequence for a given request. The first
	// extension chain that has a condition that matches the request is executed.
	// Any subsequent extension chains do not execute. Limited to 5 extension
	// chains per resource.
	ExtensionChains []*ExtensionChain `json:"extensionChains,omitempty"`
	// ForwardingRules: Required. A list of references to the forwarding rules to
	// which this service extension is attached. At least one forwarding rule is
	// required. Only one `LbRouteExtension` resource can be associated with a
	// forwarding rule.
	ForwardingRules []string `json:"forwardingRules,omitempty"`
	// Labels: Optional. Set of labels associated with the `LbRouteExtension`
	// resource. The format must comply with the requirements for labels
	// (https://cloud.google.com/compute/docs/labeling-resources#requirements) for
	// Google Cloud resources.
	Labels map[string]string `json:"labels,omitempty"`
	// LoadBalancingScheme: Required. All backend services and forwarding rules
	// referenced by this extension must share the same load balancing scheme.
	// Supported values: `INTERNAL_MANAGED`, `EXTERNAL_MANAGED`. For more
	// information, refer to Backend services overview
	// (https://cloud.google.com/load-balancing/docs/backend-service).
	//
	// Possible values:
	//   "LOAD_BALANCING_SCHEME_UNSPECIFIED" - Default value. Do not use.
	//   "INTERNAL_MANAGED" - Signifies that this is used for Internal HTTP(S) Load
	// Balancing.
	//   "EXTERNAL_MANAGED" - Signifies that this is used for External Managed
	// HTTP(S) Load Balancing.
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`
	// Metadata: Optional. The metadata provided here is included as part of the
	// `metadata_context` (of type `google.protobuf.Struct`) in the
	// `ProcessingRequest` message sent to the extension server. The metadata
	// applies to all extensions in all extensions chains in this resource. The
	// metadata is available under the key `com.google.lb_route_extension.`. The
	// following variables are supported in the metadata: `{forwarding_rule_id}` -
	// substituted with the forwarding rule's fully qualified resource name. This
	// field must not be set if at least one of the extension chains contains
	// plugin extensions. Setting it results in a validation error. You can set
	// metadata at either the resource level or the extension level. The extension
	// level metadata is recommended because you can pass a different set of
	// metadata through each extension to the backend.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Required. Identifier. Name of the `LbRouteExtension` resource in the
	// following format:
	// `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extensio
	// n}`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LbRouteExtension) MarshalJSON() ([]byte, error) {
	type NoMethod LbRouteExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LbTrafficExtension: `LbTrafficExtension` is a resource that lets the
// extension service modify the headers and payloads of both requests and
// responses without impacting the choice of backend services or any other
// security policies associated with the backend service.
type LbTrafficExtension struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// ExtensionChains: Required. A set of ordered extension chains that contain
	// the match conditions and extensions to execute. Match conditions for each
	// extension chain are evaluated in sequence for a given request. The first
	// extension chain that has a condition that matches the request is executed.
	// Any subsequent extension chains do not execute. Limited to 5 extension
	// chains per resource.
	ExtensionChains []*ExtensionChain `json:"extensionChains,omitempty"`
	// ForwardingRules: Optional. A list of references to the forwarding rules to
	// which this service extension is attached. At least one forwarding rule is
	// required. Only one `LbTrafficExtension` resource can be associated with a
	// forwarding rule.
	ForwardingRules []string `json:"forwardingRules,omitempty"`
	// Labels: Optional. Set of labels associated with the `LbTrafficExtension`
	// resource. The format must comply with the requirements for labels
	// (https://cloud.google.com/compute/docs/labeling-resources#requirements) for
	// Google Cloud resources.
	Labels map[string]string `json:"labels,omitempty"`
	// LoadBalancingScheme: Required. All backend services and forwarding rules
	// referenced by this extension must share the same load balancing scheme.
	// Supported values: `INTERNAL_MANAGED` and `EXTERNAL_MANAGED`. For more
	// information, refer to Backend services overview
	// (https://cloud.google.com/load-balancing/docs/backend-service).
	//
	// Possible values:
	//   "LOAD_BALANCING_SCHEME_UNSPECIFIED" - Default value. Do not use.
	//   "INTERNAL_MANAGED" - Signifies that this is used for Internal HTTP(S) Load
	// Balancing.
	//   "EXTERNAL_MANAGED" - Signifies that this is used for External Managed
	// HTTP(S) Load Balancing.
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`
	// Metadata: Optional. The metadata provided here is included as part of the
	// `metadata_context` (of type `google.protobuf.Struct`) in the
	// `ProcessingRequest` message sent to the extension server. The metadata
	// applies to all extensions in all extensions chains in this resource. The
	// metadata is available under the key `com.google.lb_traffic_extension.`. The
	// following variables are supported in the metadata: `{forwarding_rule_id}` -
	// substituted with the forwarding rule's fully qualified resource name. This
	// field must not be set if at least one of the extension chains contains
	// plugin extensions. Setting it results in a validation error. You can set
	// metadata at either the resource level or the extension level. The extension
	// level metadata is recommended because you can pass a different set of
	// metadata through each extension to the backend.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Required. Identifier. Name of the `LbTrafficExtension` resource in the
	// following format:
	// `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_exte
	// nsion}`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LbTrafficExtension) MarshalJSON() ([]byte, error) {
	type NoMethod LbTrafficExtension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAuthzExtensionsResponse: Message for response to listing
// `AuthzExtension` resources.
type ListAuthzExtensionsResponse struct {
	// AuthzExtensions: The list of `AuthzExtension` resources.
	AuthzExtensions []*AuthzExtension `json:"authzExtensions,omitempty"`
	// NextPageToken: A token identifying a page of results that the server
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthzExtensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthzExtensions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAuthzExtensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAuthzExtensionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEndpointPoliciesResponse: Response returned by the ListEndpointPolicies
// method.
type ListEndpointPoliciesResponse struct {
	// EndpointPolicies: List of EndpointPolicy resources.
	EndpointPolicies []*EndpointPolicy `json:"endpointPolicies,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// return_partial_success and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndpointPolicies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointPolicies") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEndpointPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEndpointPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGatewayRouteViewsResponse: Response returned by the
// ListGatewayRouteViews method.
type ListGatewayRouteViewsResponse struct {
	// GatewayRouteViews: List of GatewayRouteView resources.
	GatewayRouteViews []*GatewayRouteView `json:"gatewayRouteViews,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request attempts to
	// list all resources across all supported locations, while some locations are
	// temporarily unavailable.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GatewayRouteViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GatewayRouteViews") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGatewayRouteViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGatewayRouteViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGatewaysResponse: Response returned by the ListGateways method.
type ListGatewaysResponse struct {
	// Gateways: List of Gateway resources.
	Gateways []*Gateway `json:"gateways,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Gateways") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Gateways") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGatewaysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGatewaysResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGrpcRoutesResponse: Response returned by the ListGrpcRoutes method.
type ListGrpcRoutesResponse struct {
	// GrpcRoutes: List of GrpcRoute resources.
	GrpcRoutes []*GrpcRoute `json:"grpcRoutes,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// return_partial_success and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GrpcRoutes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GrpcRoutes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGrpcRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGrpcRoutesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListHttpRoutesResponse: Response returned by the ListHttpRoutes method.
type ListHttpRoutesResponse struct {
	// HttpRoutes: List of HttpRoute resources.
	HttpRoutes []*HttpRoute `json:"httpRoutes,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// return_partial_success and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HttpRoutes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpRoutes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListHttpRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListHttpRoutesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLbEdgeExtensionsResponse: Message for response to listing
// `LbEdgeExtension` resources.
type ListLbEdgeExtensionsResponse struct {
	// LbEdgeExtensions: The list of `LbEdgeExtension` resources.
	LbEdgeExtensions []*LbEdgeExtension `json:"lbEdgeExtensions,omitempty"`
	// NextPageToken: A token identifying a page of results that the server
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LbEdgeExtensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LbEdgeExtensions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLbEdgeExtensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLbEdgeExtensionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLbRouteExtensionsResponse: Message for response to listing
// `LbRouteExtension` resources.
type ListLbRouteExtensionsResponse struct {
	// LbRouteExtensions: The list of `LbRouteExtension` resources.
	LbRouteExtensions []*LbRouteExtension `json:"lbRouteExtensions,omitempty"`
	// NextPageToken: A token identifying a page of results that the server
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LbRouteExtensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LbRouteExtensions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLbRouteExtensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLbRouteExtensionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLbTrafficExtensionsResponse: Message for response to listing
// `LbTrafficExtension` resources.
type ListLbTrafficExtensionsResponse struct {
	// LbTrafficExtensions: The list of `LbTrafficExtension` resources.
	LbTrafficExtensions []*LbTrafficExtension `json:"lbTrafficExtensions,omitempty"`
	// NextPageToken: A token identifying a page of results that the server
	// returns.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LbTrafficExtensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LbTrafficExtensions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLbTrafficExtensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLbTrafficExtensionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMeshRouteViewsResponse: Response returned by the ListMeshRouteViews
// method.
type ListMeshRouteViewsResponse struct {
	// MeshRouteViews: List of MeshRouteView resources.
	MeshRouteViews []*MeshRouteView `json:"meshRouteViews,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request attempts to
	// list all resources across all supported locations, while some locations are
	// temporarily unavailable.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MeshRouteViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MeshRouteViews") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMeshRouteViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMeshRouteViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMeshesResponse: Response returned by the ListMeshes method.
type ListMeshesResponse struct {
	// Meshes: List of Mesh resources.
	Meshes []*Mesh `json:"meshes,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// `return_partial_success` and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Meshes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Meshes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMeshesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMeshesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListServiceBindingsResponse: Response returned by the ListServiceBindings
// method.
type ListServiceBindingsResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ServiceBindings: List of ServiceBinding resources.
	ServiceBindings []*ServiceBinding `json:"serviceBindings,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request attempts to
	// list all resources across all supported locations, while some locations are
	// temporarily unavailable.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListServiceBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListServiceBindingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListServiceLbPoliciesResponse: Response returned by the
// ListServiceLbPolicies method.
type ListServiceLbPoliciesResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ServiceLbPolicies: List of ServiceLbPolicy resources.
	ServiceLbPolicies []*ServiceLbPolicy `json:"serviceLbPolicies,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request attempts to
	// list all resources across all supported locations, while some locations are
	// temporarily unavailable.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListServiceLbPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListServiceLbPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTcpRoutesResponse: Response returned by the ListTcpRoutes method.
type ListTcpRoutesResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TcpRoutes: List of TcpRoute resources.
	TcpRoutes []*TcpRoute `json:"tcpRoutes,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// return_partial_success and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTcpRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTcpRoutesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTlsRoutesResponse: Response returned by the ListTlsRoutes method.
type ListTlsRoutesResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TlsRoutes: List of TlsRoute resources.
	TlsRoutes []*TlsRoute `json:"tlsRoutes,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request opts into
	// return_partial_success and reading across collections e.g. when attempting
	// to list all resources across all supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTlsRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTlsRoutesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWasmPluginVersionsResponse: Response returned by the
// `ListWasmPluginVersions` method.
type ListWasmPluginVersionsResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request attempts to
	// list all resources across all supported locations, while some locations are
	// temporarily unavailable.
	Unreachable []string `json:"unreachable,omitempty"`
	// WasmPluginVersions: List of `WasmPluginVersion` resources.
	WasmPluginVersions []*WasmPluginVersion `json:"wasmPluginVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWasmPluginVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWasmPluginVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWasmPluginsResponse: Response returned by the `ListWasmPlugins` method.
type ListWasmPluginsResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token` as
	// `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Unreachable resources. Populated when the request attempts to
	// list all resources across all supported locations, while some locations are
	// temporarily unavailable.
	Unreachable []string `json:"unreachable,omitempty"`
	// WasmPlugins: List of `WasmPlugin` resources.
	WasmPlugins []*WasmPlugin `json:"wasmPlugins,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWasmPluginsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWasmPluginsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingConfig: The configuration for Platform Telemetry logging for Eventarc
// Advanced resources.
type LoggingConfig struct {
	// LogSeverity: Optional. The minimum severity of logs that will be sent to
	// Stackdriver/Platform Telemetry. Logs at severitiy ≥ this value will be
	// sent, unless it is NONE.
	//
	// Possible values:
	//   "LOG_SEVERITY_UNSPECIFIED" - Log severity is not specified. This value is
	// treated the same as NONE, but is used to distinguish between no update and
	// update to NONE in update_masks.
	//   "NONE" - Default value at resource creation, presence of this value must
	// be treated as no logging/disable logging.
	//   "DEBUG" - Debug or trace level logging.
	//   "INFO" - Routine information, such as ongoing status or performance.
	//   "NOTICE" - Normal but significant events, such as start up, shut down, or
	// a configuration change.
	//   "WARNING" - Warning events might cause problems.
	//   "ERROR" - Error events are likely to cause problems.
	//   "CRITICAL" - Critical events cause more severe problems or outages.
	//   "ALERT" - A person must take action immediately.
	//   "EMERGENCY" - One or more systems are unusable.
	LogSeverity string `json:"logSeverity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogSeverity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogSeverity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Mesh: Mesh represents a logical configuration grouping for workload to
// workload communication within a service mesh. Routes that point to mesh
// dictate how requests are routed within this logical mesh boundary.
type Mesh struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// EnvoyHeaders: Optional. Determines if envoy will insert internal debug
	// headers into upstream requests. Other Envoy headers may still be injected.
	// By default, envoy will not insert any debug headers.
	//
	// Possible values:
	//   "ENVOY_HEADERS_UNSPECIFIED" - Defaults to NONE.
	//   "NONE" - Suppress envoy debug headers.
	//   "DEBUG_HEADERS" - Envoy will insert default internal debug headers into
	// upstream requests: x-envoy-attempt-count x-envoy-is-timeout-retry
	// x-envoy-expected-rq-timeout-ms x-envoy-original-path
	// x-envoy-upstream-stream-duration-ms
	EnvoyHeaders string `json:"envoyHeaders,omitempty"`
	// InterceptionPort: Optional. If set to a valid TCP port (1-65535), instructs
	// the SIDECAR proxy to listen on the specified port of localhost (127.0.0.1)
	// address. The SIDECAR proxy will expect all traffic to be redirected to this
	// port regardless of its actual ip:port destination. If unset, a port '15001'
	// is used as the interception port. This is applicable only for sidecar proxy
	// deployments.
	InterceptionPort int64 `json:"interceptionPort,omitempty"`
	// Labels: Optional. Set of label tags associated with the Mesh resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the Mesh resource. It matches pattern
	// `projects/*/locations/global/meshes/`.
	Name string `json:"name,omitempty"`
	// SelfLink: Output only. Server-defined URL of this resource
	SelfLink string `json:"selfLink,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Mesh) MarshalJSON() ([]byte, error) {
	type NoMethod Mesh
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MeshRouteView: MeshRouteView defines view-only resource for Routes to a Mesh
type MeshRouteView struct {
	// Name: Output only. Identifier. Full path name of the MeshRouteView resource.
	// Format:
	// projects/{project_number}/locations/{location}/meshes/{mesh}/routeViews/{rout
	// e_view}
	Name string `json:"name,omitempty"`
	// RouteId: Output only. The resource id for the route.
	RouteId string `json:"routeId,omitempty"`
	// RouteLocation: Output only. Location where the route exists.
	RouteLocation string `json:"routeLocation,omitempty"`
	// RouteProjectNumber: Output only. Project number where the route exists.
	RouteProjectNumber int64 `json:"routeProjectNumber,omitempty,string"`
	// RouteType: Output only. Type of the route: HttpRoute,GrpcRoute,TcpRoute, or
	// TlsRoute
	RouteType string `json:"routeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MeshRouteView) MarshalJSON() ([]byte, error) {
	type NoMethod MeshRouteView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetadataLabelMatcher: The matcher that is based on node metadata presented
// by xDS clients.
type MetadataLabelMatcher struct {
	// MetadataLabelMatchCriteria: Specifies how matching should be done. Supported
	// values are: MATCH_ANY: At least one of the Labels specified in the matcher
	// should match the metadata presented by xDS client. MATCH_ALL: The metadata
	// presented by the xDS client should contain all of the labels specified here.
	// The selection is determined based on the best match. For example, suppose
	// there are three EndpointPolicy resources P1, P2 and P3 and if P1 has a the
	// matcher as MATCH_ANY , P2 has MATCH_ALL , and P3 has MATCH_ALL . If a client
	// with label connects, the config from P1 will be selected. If a client with
	// label connects, the config from P2 will be selected. If a client with label
	// connects, the config from P3 will be selected. If there is more than one
	// best match, (for example, if a config P4 with selector exists and if a
	// client with label connects), pick up the one with older creation time.
	//
	// Possible values:
	//   "METADATA_LABEL_MATCH_CRITERIA_UNSPECIFIED" - Default value. Should not be
	// used.
	//   "MATCH_ANY" - At least one of the Labels specified in the matcher should
	// match the metadata presented by xDS client.
	//   "MATCH_ALL" - The metadata presented by the xDS client should contain all
	// of the labels specified here.
	MetadataLabelMatchCriteria string `json:"metadataLabelMatchCriteria,omitempty"`
	// MetadataLabels: The list of label value pairs that must match labels in the
	// provided metadata based on filterMatchCriteria This list can have at most 64
	// entries. The list can be empty if the match criteria is MATCH_ANY, to
	// specify a wildcard match (i.e this matches any client).
	MetadataLabels []*MetadataLabels `json:"metadataLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetadataLabelMatchCriteria")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataLabelMatchCriteria") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetadataLabelMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod MetadataLabelMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetadataLabels: Defines a name-pair value for a single label.
type MetadataLabels struct {
	// LabelName: Required. Label name presented as key in xDS Node Metadata.
	LabelName string `json:"labelName,omitempty"`
	// LabelValue: Required. Label value presented as value corresponding to the
	// above key, in xDS Node Metadata.
	LabelValue string `json:"labelValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetadataLabels) MarshalJSON() ([]byte, error) {
	type NoMethod MetadataLabels
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have Operation.error value with a google.rpc.Status.code of
	// 1, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RetryFilterPerRouteConfig struct {
	// CryptoKeyName: The name of the crypto key to use for encrypting event data.
	CryptoKeyName string `json:"cryptoKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RetryFilterPerRouteConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RetryFilterPerRouteConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceBinding: ServiceBinding can be used to: - Bind a Service Directory
// Service to be used in a BackendService resource. This feature will be
// deprecated soon. - Bind a Private Service Connect producer service to be
// used in consumer Cloud Service Mesh or Application Load Balancers. - Bind a
// Cloud Run service to be used in consumer Cloud Service Mesh or Application
// Load Balancers.
type ServiceBinding struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Set of label tags associated with the ServiceBinding
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the ServiceBinding resource. It matches pattern
	// `projects/*/locations/*/serviceBindings/`.
	Name string `json:"name,omitempty"`
	// Service: Optional. The full Service Directory Service name of the format
	// `projects/*/locations/*/namespaces/*/services/*`. This field is for Service
	// Directory integration which will be deprecated soon.
	Service string `json:"service,omitempty"`
	// ServiceId: Output only. The unique identifier of the Service Directory
	// Service against which the ServiceBinding resource is validated. This is
	// populated when the Service Binding resource is used in another resource
	// (like Backend Service). This is of the UUID4 format. This field is for
	// Service Directory integration which will be deprecated soon.
	ServiceId string `json:"serviceId,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceBinding) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceLbPolicy: ServiceLbPolicy holds global load balancing and traffic
// distribution configuration that can be applied to a BackendService.
type ServiceLbPolicy struct {
	// AutoCapacityDrain: Optional. Configuration to automatically move traffic
	// away for unhealthy IG/NEG for the associated Backend Service.
	AutoCapacityDrain *ServiceLbPolicyAutoCapacityDrain `json:"autoCapacityDrain,omitempty"`
	// CreateTime: Output only. The timestamp when this resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// FailoverConfig: Optional. Configuration related to health based failover.
	FailoverConfig *ServiceLbPolicyFailoverConfig `json:"failoverConfig,omitempty"`
	// IsolationConfig: Optional. Configuration to provide isolation support for
	// the associated Backend Service.
	IsolationConfig *ServiceLbPolicyIsolationConfig `json:"isolationConfig,omitempty"`
	// Labels: Optional. Set of label tags associated with the ServiceLbPolicy
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// LoadBalancingAlgorithm: Optional. The type of load balancing algorithm to be
	// used. The default behavior is WATERFALL_BY_REGION.
	//
	// Possible values:
	//   "LOAD_BALANCING_ALGORITHM_UNSPECIFIED" - The type of the loadbalancing
	// algorithm is unspecified.
	//   "SPRAY_TO_WORLD" - Balance traffic across all backends across the world
	// proportionally based on capacity.
	//   "SPRAY_TO_REGION" - Direct traffic to the nearest region with endpoints
	// and capacity before spilling over to other regions and spread the traffic
	// from each client to all the MIGs/NEGs in a region.
	//   "WATERFALL_BY_REGION" - Direct traffic to the nearest region with
	// endpoints and capacity before spilling over to other regions. All MIGs/NEGs
	// within a region are evenly loaded but each client might not spread the
	// traffic to all the MIGs/NEGs in the region.
	//   "WATERFALL_BY_ZONE" - Attempt to keep traffic in a single zone closest to
	// the client, before spilling over to other zones.
	LoadBalancingAlgorithm string `json:"loadBalancingAlgorithm,omitempty"`
	// Name: Identifier. Name of the ServiceLbPolicy resource. It matches pattern
	// `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy
	// _name}`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when this resource was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoCapacityDrain") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoCapacityDrain") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceLbPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceLbPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceLbPolicyAutoCapacityDrain: Option to specify if an unhealthy IG/NEG
// should be considered for global load balancing and traffic routing.
type ServiceLbPolicyAutoCapacityDrain struct {
	// Enable: Optional. If set to 'True', an unhealthy IG/NEG will be set as
	// drained. - An IG/NEG is considered unhealthy if less than 25% of the
	// instances/endpoints in the IG/NEG are healthy. - This option will never
	// result in draining more than 50% of the configured IGs/NEGs for the Backend
	// Service.
	Enable bool `json:"enable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceLbPolicyAutoCapacityDrain) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceLbPolicyAutoCapacityDrain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceLbPolicyFailoverConfig: Option to specify health based failover
// behavior. This is not related to Network load balancer FailoverPolicy.
type ServiceLbPolicyFailoverConfig struct {
	// FailoverHealthThreshold: Optional. The percentage threshold that a load
	// balancer will begin to send traffic to failover backends. If the percentage
	// of endpoints in a MIG/NEG is smaller than this value, traffic would be sent
	// to failover backends if possible. This field should be set to a value
	// between 1 and 99. The default value is 50 for Global external HTTP(S) load
	// balancer (classic) and Proxyless service mesh, and 70 for others.
	FailoverHealthThreshold int64 `json:"failoverHealthThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailoverHealthThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailoverHealthThreshold") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceLbPolicyFailoverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceLbPolicyFailoverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceLbPolicyIsolationConfig: Configuration to provide isolation support
// for the associated Backend Service.
type ServiceLbPolicyIsolationConfig struct {
	// IsolationGranularity: Optional. The isolation granularity of the load
	// balancer.
	//
	// Possible values:
	//   "ISOLATION_GRANULARITY_UNSPECIFIED" - No isolation is configured for the
	// backend service. Traffic can overflow based on the load balancing algorithm.
	//   "REGION" - Traffic for this service will be isolated at the cloud region
	// level.
	IsolationGranularity string `json:"isolationGranularity,omitempty"`
	// IsolationMode: Optional. The isolation mode of the load balancer.
	//
	// Possible values:
	//   "ISOLATION_MODE_UNSPECIFIED" - No isolation mode is configured for the
	// backend service.
	//   "NEAREST" - Traffic will be sent to the nearest region.
	//   "STRICT" - Traffic will fail if no serving backends are available in the
	// same region as the load balancer.
	IsolationMode string `json:"isolationMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsolationGranularity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsolationGranularity") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceLbPolicyIsolationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceLbPolicyIsolationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TcpRoute: TcpRoute is the resource defining how TCP traffic should be routed
// by a Mesh/Gateway resource.
type TcpRoute struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Gateways: Optional. Gateways defines a list of gateways this TcpRoute is
	// attached to, as one of the routing rules to route the requests served by the
	// gateway. Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/`
	Gateways []string `json:"gateways,omitempty"`
	// Labels: Optional. Set of label tags associated with the TcpRoute resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Meshes: Optional. Meshes defines a list of meshes this TcpRoute is attached
	// to, as one of the routing rules to route the requests served by the mesh.
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/` The attached Mesh should be of a type
	// SIDECAR
	Meshes []string `json:"meshes,omitempty"`
	// Name: Identifier. Name of the TcpRoute resource. It matches pattern
	// `projects/*/locations/global/tcpRoutes/tcp_route_name>`.
	Name string `json:"name,omitempty"`
	// Rules: Required. Rules that define how traffic is routed and handled. At
	// least one RouteRule must be supplied. If there are multiple rules then the
	// action taken will be the first rule to match.
	Rules []*TcpRouteRouteRule `json:"rules,omitempty"`
	// SelfLink: Output only. Server-defined URL of this resource
	SelfLink string `json:"selfLink,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TcpRoute) MarshalJSON() ([]byte, error) {
	type NoMethod TcpRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TcpRouteRouteAction: The specifications for routing traffic and applying
// associated policies.
type TcpRouteRouteAction struct {
	// Destinations: Optional. The destination services to which traffic should be
	// forwarded. At least one destination service is required. Only one of route
	// destination or original destination can be set.
	Destinations []*TcpRouteRouteDestination `json:"destinations,omitempty"`
	// IdleTimeout: Optional. Specifies the idle timeout for the selected route.
	// The idle timeout is defined as the period in which there are no bytes sent
	// or received on either the upstream or downstream connection. If not set, the
	// default idle timeout is 30 seconds. If set to 0s, the timeout will be
	// disabled.
	IdleTimeout string `json:"idleTimeout,omitempty"`
	// OriginalDestination: Optional. If true, Router will use the destination IP
	// and port of the original connection as the destination of the request.
	// Default is false. Only one of route destinations or original destination can
	// be set.
	OriginalDestination bool `json:"originalDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destinations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destinations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TcpRouteRouteAction) MarshalJSON() ([]byte, error) {
	type NoMethod TcpRouteRouteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TcpRouteRouteDestination: Describe the destination for traffic to be routed
// to.
type TcpRouteRouteDestination struct {
	// ServiceName: Required. The URL of a BackendService to route traffic to.
	ServiceName string `json:"serviceName,omitempty"`
	// Weight: Optional. Specifies the proportion of requests forwarded to the
	// backend referenced by the serviceName field. This is computed as: -
	// weight/Sum(weights in this destination list). For non-zero values, there may
	// be some epsilon from the exact proportion defined here depending on the
	// precision an implementation supports. If only one serviceName is specified
	// and it has a weight greater than 0, 100% of the traffic is forwarded to that
	// backend. If weights are specified for any one service name, they need to be
	// specified for all of them. If weights are unspecified for all services,
	// then, traffic is distributed in equal proportions to all of them.
	Weight int64 `json:"weight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TcpRouteRouteDestination) MarshalJSON() ([]byte, error) {
	type NoMethod TcpRouteRouteDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TcpRouteRouteMatch: RouteMatch defines the predicate used to match requests
// to a given action. Multiple match types are "OR"ed for evaluation. If no
// routeMatch field is specified, this rule will unconditionally match traffic.
type TcpRouteRouteMatch struct {
	// Address: Required. Must be specified in the CIDR range format. A CIDR range
	// consists of an IP Address and a prefix length to construct the subnet mask.
	// By default, the prefix length is 32 (i.e. matches a single IP address). Only
	// IPV4 addresses are supported. Examples: "10.0.0.1" - matches against this
	// exact IP address. "10.0.0.0/8" - matches against any IP address within the
	// 10.0.0.0 subnet and 255.255.255.0 mask. "0.0.0.0/0" - matches against any IP
	// address'.
	Address string `json:"address,omitempty"`
	// Port: Required. Specifies the destination port to match against.
	Port string `json:"port,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TcpRouteRouteMatch) MarshalJSON() ([]byte, error) {
	type NoMethod TcpRouteRouteMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TcpRouteRouteRule: Specifies how to match traffic and how to route traffic
// when traffic is matched.
type TcpRouteRouteRule struct {
	// Action: Required. The detailed rule defining how to route matched traffic.
	Action *TcpRouteRouteAction `json:"action,omitempty"`
	// Matches: Optional. RouteMatch defines the predicate used to match requests
	// to a given action. Multiple match types are "OR"ed for evaluation. If no
	// routeMatch field is specified, this rule will unconditionally match traffic.
	Matches []*TcpRouteRouteMatch `json:"matches,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TcpRouteRouteRule) MarshalJSON() ([]byte, error) {
	type NoMethod TcpRouteRouteRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsRoute: TlsRoute defines how traffic should be routed based on SNI and
// other matching L3 attributes.
type TlsRoute struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A free-text description of the resource. Max length
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Gateways: Optional. Gateways defines a list of gateways this TlsRoute is
	// attached to, as one of the routing rules to route the requests served by the
	// gateway. Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/`
	Gateways []string `json:"gateways,omitempty"`
	// Labels: Optional. Set of label tags associated with the TlsRoute resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Meshes: Optional. Meshes defines a list of meshes this TlsRoute is attached
	// to, as one of the routing rules to route the requests served by the mesh.
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/` The attached Mesh should be of a type
	// SIDECAR
	Meshes []string `json:"meshes,omitempty"`
	// Name: Identifier. Name of the TlsRoute resource. It matches pattern
	// `projects/*/locations/global/tlsRoutes/tls_route_name>`.
	Name string `json:"name,omitempty"`
	// Rules: Required. Rules that define how traffic is routed and handled. At
	// least one RouteRule must be supplied. If there are multiple rules then the
	// action taken will be the first rule to match.
	Rules []*TlsRouteRouteRule `json:"rules,omitempty"`
	// SelfLink: Output only. Server-defined URL of this resource
	SelfLink string `json:"selfLink,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsRoute) MarshalJSON() ([]byte, error) {
	type NoMethod TlsRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsRouteRouteAction: The specifications for routing traffic and applying
// associated policies.
type TlsRouteRouteAction struct {
	// Destinations: Required. The destination services to which traffic should be
	// forwarded. At least one destination service is required.
	Destinations []*TlsRouteRouteDestination `json:"destinations,omitempty"`
	// IdleTimeout: Optional. Specifies the idle timeout for the selected route.
	// The idle timeout is defined as the period in which there are no bytes sent
	// or received on either the upstream or downstream connection. If not set, the
	// default idle timeout is 1 hour. If set to 0s, the timeout will be disabled.
	IdleTimeout string `json:"idleTimeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destinations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destinations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsRouteRouteAction) MarshalJSON() ([]byte, error) {
	type NoMethod TlsRouteRouteAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsRouteRouteDestination: Describe the destination for traffic to be routed
// to.
type TlsRouteRouteDestination struct {
	// ServiceName: Required. The URL of a BackendService to route traffic to.
	ServiceName string `json:"serviceName,omitempty"`
	// Weight: Optional. Specifies the proportion of requests forwarded to the
	// backend referenced by the service_name field. This is computed as: -
	// weight/Sum(weights in destinations) Weights in all destinations does not
	// need to sum up to 100.
	Weight int64 `json:"weight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsRouteRouteDestination) MarshalJSON() ([]byte, error) {
	type NoMethod TlsRouteRouteDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsRouteRouteMatch: RouteMatch defines the predicate used to match requests
// to a given action. Multiple match types are "AND"ed for evaluation.
type TlsRouteRouteMatch struct {
	// Alpn: Optional. ALPN (Application-Layer Protocol Negotiation) to match
	// against. Examples: "http/1.1", "h2". At least one of sni_host and alpn is
	// required. Up to 5 alpns across all matches can be set.
	Alpn []string `json:"alpn,omitempty"`
	// SniHost: Optional. SNI (server name indicator) to match against. SNI will be
	// matched against all wildcard domains, i.e. `www.example.com` will be first
	// matched against `www.example.com`, then `*.example.com`, then `*.com.`
	// Partial wildcards are not supported, and values like *w.example.com are
	// invalid. At least one of sni_host and alpn is required. Up to 100 sni hosts
	// across all matches can be set.
	SniHost []string `json:"sniHost,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpn") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpn") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsRouteRouteMatch) MarshalJSON() ([]byte, error) {
	type NoMethod TlsRouteRouteMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TlsRouteRouteRule: Specifies how to match traffic and how to route traffic
// when traffic is matched.
type TlsRouteRouteRule struct {
	// Action: Required. The detailed rule defining how to route matched traffic.
	Action *TlsRouteRouteAction `json:"action,omitempty"`
	// Matches: Required. RouteMatch defines the predicate used to match requests
	// to a given action. Multiple match types are "OR"ed for evaluation. Atleast
	// one RouteMatch must be supplied.
	Matches []*TlsRouteRouteMatch `json:"matches,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TlsRouteRouteRule) MarshalJSON() ([]byte, error) {
	type NoMethod TlsRouteRouteRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrafficPortSelector: Specification of a port-based selector.
type TrafficPortSelector struct {
	// Ports: Optional. A list of ports. Can be port numbers or port range
	// (example, [80-90] specifies all ports from 80 to 90, including 80 and 90) or
	// named ports or * to specify all ports. If the list is empty, all ports are
	// selected.
	Ports []string `json:"ports,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ports") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ports") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrafficPortSelector) MarshalJSON() ([]byte, error) {
	type NoMethod TrafficPortSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WasmPlugin: `WasmPlugin` is a resource representing a service executing a
// customer-provided Wasm module.
type WasmPlugin struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Set of labels associated with the `WasmPlugin` resource.
	// The format must comply with the following requirements
	// (/compute/docs/labeling-resources#requirements).
	Labels map[string]string `json:"labels,omitempty"`
	// LogConfig: Optional. Specifies the logging options for the activity
	// performed by this plugin. If logging is enabled, plugin logs are exported to
	// Cloud Logging. Note that the settings relate to the logs generated by using
	// logging statements in your Wasm code.
	LogConfig *WasmPluginLogConfig `json:"logConfig,omitempty"`
	// MainVersionId: Optional. The ID of the `WasmPluginVersion` resource that is
	// the currently serving one. The version referred to must be a child of this
	// `WasmPlugin` resource.
	MainVersionId string `json:"mainVersionId,omitempty"`
	// Name: Identifier. Name of the `WasmPlugin` resource in the following format:
	// `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// UsedBy: Output only. List of all extensions
	// (https://cloud.google.com/service-extensions/docs/overview) that use this
	// `WasmPlugin` resource.
	UsedBy []*WasmPluginUsedBy `json:"usedBy,omitempty"`
	// Versions: Optional. All versions of this `WasmPlugin` resource in the
	// key-value format. The key is the resource ID, and the value is the
	// `VersionDetails` object. Lets you create or update a `WasmPlugin` resource
	// and its versions in a single request. When the `main_version_id` field is
	// not empty, it must point to one of the `VersionDetails` objects in the map.
	// If provided in a `PATCH` request, the new versions replace the previous set.
	// Any version omitted from the `versions` field is removed. Because the
	// `WasmPluginVersion` resource is immutable, if a `WasmPluginVersion` resource
	// with the same name already exists and differs, the request fails. Note: In a
	// `GET` request, this field is populated only if the field
	// `GetWasmPluginRequest.view` is set to `WASM_PLUGIN_VIEW_FULL`.
	Versions map[string]WasmPluginVersionDetails `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WasmPlugin) MarshalJSON() ([]byte, error) {
	type NoMethod WasmPlugin
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WasmPluginLogConfig: Specifies the logging options for the activity
// performed by this plugin. If logging is enabled, plugin logs are exported to
// Cloud Logging.
type WasmPluginLogConfig struct {
	// Enable: Optional. Specifies whether to enable logging for activity by this
	// plugin. Defaults to `false`.
	Enable bool `json:"enable,omitempty"`
	// MinLogLevel: Non-empty default. Specifies the lowest level of the plugin
	// logs that are exported to Cloud Logging. This setting relates to the logs
	// generated by using logging statements in your Wasm code. This field is can
	// be set only if logging is enabled for the plugin. If the field is not
	// provided when logging is enabled, it is set to `INFO` by default.
	//
	// Possible values:
	//   "LOG_LEVEL_UNSPECIFIED" - Unspecified value. Defaults to `LogLevel.INFO`.
	//   "TRACE" - Report logs with TRACE level and above.
	//   "DEBUG" - Report logs with DEBUG level and above.
	//   "INFO" - Report logs with INFO level and above.
	//   "WARN" - Report logs with WARN level and above.
	//   "ERROR" - Report logs with ERROR level and above.
	//   "CRITICAL" - Report logs with CRITICAL level only.
	MinLogLevel string `json:"minLogLevel,omitempty"`
	// SampleRate: Non-empty default. Configures the sampling rate of activity
	// logs, where `1.0` means all logged activity is reported and `0.0` means no
	// activity is reported. A floating point value between `0.0` and `1.0`
	// indicates that a percentage of log messages is stored. The default value
	// when logging is enabled is `1.0`. The value of the field must be between `0`
	// and `1` (inclusive). This field can be specified only if logging is enabled
	// for this plugin.
	SampleRate float64 `json:"sampleRate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enable") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WasmPluginLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WasmPluginLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *WasmPluginLogConfig) UnmarshalJSON(data []byte) error {
	type NoMethod WasmPluginLogConfig
	var s1 struct {
		SampleRate gensupport.JSONFloat64 `json:"sampleRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SampleRate = float64(s1.SampleRate)
	return nil
}

// WasmPluginUsedBy: Defines a resource that uses the `WasmPlugin` resource.
type WasmPluginUsedBy struct {
	// Name: Output only. Full name of the resource
	// https://google.aip.dev/122#full-resource-names, for example
	// `//networkservices.googleapis.com/projects/{project}/locations/{location}/lbR
	// outeExtensions/{extension}`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WasmPluginUsedBy) MarshalJSON() ([]byte, error) {
	type NoMethod WasmPluginUsedBy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WasmPluginVersion: A single immutable version of a `WasmPlugin` resource.
// Defines the Wasm module used and optionally its runtime config.
type WasmPluginVersion struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// ImageDigest: Output only. This field holds the digest (usually checksum)
	// value for the plugin image. The value is calculated based on the `image_uri`
	// field. If the `image_uri` field refers to a container image, the digest
	// value is obtained from the container image. If the `image_uri` field refers
	// to a generic artifact, the digest value is calculated based on the contents
	// of the file.
	ImageDigest string `json:"imageDigest,omitempty"`
	// ImageUri: Optional. URI of the image containing the Wasm module, stored in
	// Artifact Registry. The URI can refer to one of the following repository
	// formats: * Container images: the `image_uri` must point to a container that
	// contains a single file with the name `plugin.wasm`. When a new
	// `WasmPluginVersion` resource is created, the digest of the image is saved in
	// the `image_digest` field. When pulling a container image from Artifact
	// Registry, the digest value is used instead of an image tag. * Generic
	// artifacts: the `image_uri` must be in this format:
	// `projects/{project}/locations/{location}/repositories/{repository}/
	// genericArtifacts/{package}:{version}`. The specified package and version
	// must contain a file with the name `plugin.wasm`. When a new
	// `WasmPluginVersion` resource is created, the checksum of the contents of the
	// file is saved in the `image_digest` field.
	ImageUri string `json:"imageUri,omitempty"`
	// Labels: Optional. Set of labels associated with the `WasmPluginVersion`
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the `WasmPluginVersion` resource in the following
	// format: `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}/
	// versions/{wasm_plugin_version}`.
	Name string `json:"name,omitempty"`
	// PluginConfigData: Configuration for the plugin. The configuration is
	// provided to the plugin at runtime through the `ON_CONFIGURE` callback. When
	// a new `WasmPluginVersion` resource is created, the digest of the contents is
	// saved in the `plugin_config_digest` field.
	PluginConfigData string `json:"pluginConfigData,omitempty"`
	// PluginConfigDigest: Output only. This field holds the digest (usually
	// checksum) value for the plugin configuration. The value is calculated based
	// on the contents of `plugin_config_data` field or the image defined by the
	// `plugin_config_uri` field.
	PluginConfigDigest string `json:"pluginConfigDigest,omitempty"`
	// PluginConfigUri: URI of the plugin configuration stored in the Artifact
	// Registry. The configuration is provided to the plugin at runtime through the
	// `ON_CONFIGURE` callback. The URI can refer to one of the following
	// repository formats: * Container images: the `plugin_config_uri` must point
	// to a container that contains a single file with the name `plugin.config`.
	// When a new `WasmPluginVersion` resource is created, the digest of the image
	// is saved in the `plugin_config_digest` field. When pulling a container image
	// from Artifact Registry, the digest value is used instead of an image tag. *
	// Generic artifacts: the `plugin_config_uri` must be in this format:
	// `projects/{project}/locations/{location}/repositories/{repository}/
	// genericArtifacts/{package}:{version}`. The specified package and version
	// must contain a file with the name `plugin.config`. When a new
	// `WasmPluginVersion` resource is created, the checksum of the contents of the
	// file is saved in the `plugin_config_digest` field.
	PluginConfigUri string `json:"pluginConfigUri,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WasmPluginVersion) MarshalJSON() ([]byte, error) {
	type NoMethod WasmPluginVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WasmPluginVersionDetails: Details of a `WasmPluginVersion` resource to be
// inlined in the `WasmPlugin` resource.
type WasmPluginVersionDetails struct {
	// CreateTime: Output only. The timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human-readable description of the resource.
	Description string `json:"description,omitempty"`
	// ImageDigest: Output only. This field holds the digest (usually checksum)
	// value for the plugin image. The value is calculated based on the `image_uri`
	// field. If the `image_uri` field refers to a container image, the digest
	// value is obtained from the container image. If the `image_uri` field refers
	// to a generic artifact, the digest value is calculated based on the contents
	// of the file.
	ImageDigest string `json:"imageDigest,omitempty"`
	// ImageUri: Optional. URI of the image containing the Wasm module, stored in
	// Artifact Registry. The URI can refer to one of the following repository
	// formats: * Container images: the `image_uri` must point to a container that
	// contains a single file with the name `plugin.wasm`. When a new
	// `WasmPluginVersion` resource is created, the digest of the image is saved in
	// the `image_digest` field. When pulling a container image from Artifact
	// Registry, the digest value is used instead of an image tag. * Generic
	// artifacts: the `image_uri` must be in this format:
	// `projects/{project}/locations/{location}/repositories/{repository}/
	// genericArtifacts/{package}:{version}`. The specified package and version
	// must contain a file with the name `plugin.wasm`. When a new
	// `WasmPluginVersion` resource is created, the checksum of the contents of the
	// file is saved in the `image_digest` field.
	ImageUri string `json:"imageUri,omitempty"`
	// Labels: Optional. Set of labels associated with the `WasmPluginVersion`
	// resource.
	Labels map[string]string `json:"labels,omitempty"`
	// PluginConfigData: Configuration for the plugin. The configuration is
	// provided to the plugin at runtime through the `ON_CONFIGURE` callback. When
	// a new `WasmPluginVersion` version is created, the digest of the contents is
	// saved in the `plugin_config_digest` field.
	PluginConfigData string `json:"pluginConfigData,omitempty"`
	// PluginConfigDigest: Output only. This field holds the digest (usually
	// checksum) value for the plugin configuration. The value is calculated based
	// on the contents of `plugin_config_data` field or the image defined by the
	// `plugin_config_uri` field.
	PluginConfigDigest string `json:"pluginConfigDigest,omitempty"`
	// PluginConfigUri: URI of the plugin configuration stored in the Artifact
	// Registry. The configuration is provided to the plugin at runtime through the
	// `ON_CONFIGURE` callback. The URI can refer to one of the following
	// repository formats: * Container images: the `plugin_config_uri` must point
	// to a container that contains a single file with the name `plugin.config`.
	// When a new `WasmPluginVersion` resource is created, the digest of the image
	// is saved in the `plugin_config_digest` field. When pulling a container image
	// from Artifact Registry, the digest value is used instead of an image tag. *
	// Generic artifacts: the `plugin_config_uri` must be in this format:
	// `projects/{project}/locations/{location}/repositories/{repository}/
	// genericArtifacts/{package}:{version}`. The specified package and version
	// must contain a file with the name `plugin.config`. When a new
	// `WasmPluginVersion` resource is created, the checksum of the contents of the
	// file is saved in the `plugin_config_digest` field.
	PluginConfigUri string `json:"pluginConfigUri,omitempty"`
	// UpdateTime: Output only. The timestamp when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WasmPluginVersionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod WasmPluginVersionDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthzExtensionsCreateCall struct {
	s              *Service
	parent         string
	authzextension *AuthzExtension
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new `AuthzExtension` resource in a given project and
// location.
//
//   - parent: The parent resource of the `AuthzExtension` resource. Must be in
//     the format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAuthzExtensionsService) Create(parent string, authzextension *AuthzExtension) *ProjectsLocationsAuthzExtensionsCreateCall {
	c := &ProjectsLocationsAuthzExtensionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.authzextension = authzextension
	return c
}

// AuthzExtensionId sets the optional parameter "authzExtensionId": Required.
// User-provided ID of the `AuthzExtension` resource to be created.
func (c *ProjectsLocationsAuthzExtensionsCreateCall) AuthzExtensionId(authzExtensionId string) *ProjectsLocationsAuthzExtensionsCreateCall {
	c.urlParams_.Set("authzExtensionId", authzExtensionId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAuthzExtensionsCreateCall) RequestId(requestId string) *ProjectsLocationsAuthzExtensionsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzExtensionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzExtensionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzExtensionsCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthzExtensionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzExtensionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzExtensionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.authzextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/authzExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.authzExtensions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzExtensionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzExtensionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `AuthzExtension` resource.
//
//   - name: The name of the `AuthzExtension` resource to delete. Must be in the
//     format
//     `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`
//     .
func (r *ProjectsLocationsAuthzExtensionsService) Delete(name string) *ProjectsLocationsAuthzExtensionsDeleteCall {
	c := &ProjectsLocationsAuthzExtensionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes after the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAuthzExtensionsDeleteCall) RequestId(requestId string) *ProjectsLocationsAuthzExtensionsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzExtensionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzExtensionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzExtensionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthzExtensionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzExtensionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzExtensionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.authzExtensions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzExtensionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzExtensionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified `AuthzExtension` resource.
//
//   - name: A name of the `AuthzExtension` resource to get. Must be in the
//     format
//     `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`
//     .
func (r *ProjectsLocationsAuthzExtensionsService) Get(name string) *ProjectsLocationsAuthzExtensionsGetCall {
	c := &ProjectsLocationsAuthzExtensionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzExtensionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzExtensionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthzExtensionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthzExtensionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzExtensionsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthzExtensionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzExtensionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzExtensionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.authzExtensions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AuthzExtension.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzExtensionsGetCall) Do(opts ...googleapi.CallOption) (*AuthzExtension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AuthzExtension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthzExtensionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `AuthzExtension` resources in a given project and location.
//
//   - parent: The project and location from which the `AuthzExtension` resources
//     are listed. These values are specified in the following format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAuthzExtensionsService) List(parent string) *ProjectsLocationsAuthzExtensionsListCall {
	c := &ProjectsLocationsAuthzExtensionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsAuthzExtensionsListCall) Filter(filter string) *ProjectsLocationsAuthzExtensionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint about how to order the
// results.
func (c *ProjectsLocationsAuthzExtensionsListCall) OrderBy(orderBy string) *ProjectsLocationsAuthzExtensionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server might return fewer items than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsLocationsAuthzExtensionsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthzExtensionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server returns.
func (c *ProjectsLocationsAuthzExtensionsListCall) PageToken(pageToken string) *ProjectsLocationsAuthzExtensionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzExtensionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzExtensionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthzExtensionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthzExtensionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzExtensionsListCall) Context(ctx context.Context) *ProjectsLocationsAuthzExtensionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzExtensionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzExtensionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/authzExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.authzExtensions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuthzExtensionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzExtensionsListCall) Do(opts ...googleapi.CallOption) (*ListAuthzExtensionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuthzExtensionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthzExtensionsListCall) Pages(ctx context.Context, f func(*ListAuthzExtensionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthzExtensionsPatchCall struct {
	s              *Service
	name           string
	authzextension *AuthzExtension
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates the parameters of the specified `AuthzExtension` resource.
//
//   - name: Identifier. Name of the `AuthzExtension` resource in the following
//     format:
//     `projects/{project}/locations/{location}/authzExtensions/{authz_extension}`
//     .
func (r *ProjectsLocationsAuthzExtensionsService) Patch(name string, authzextension *AuthzExtension) *ProjectsLocationsAuthzExtensionsPatchCall {
	c := &ProjectsLocationsAuthzExtensionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.authzextension = authzextension
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsAuthzExtensionsPatchCall) RequestId(requestId string) *ProjectsLocationsAuthzExtensionsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Used to
// specify the fields to be overwritten in the `AuthzExtension` resource by the
// update. The fields specified in the `update_mask` are relative to the
// resource, not the full request. A field is overwritten if it is in the mask.
// If the user does not specify a mask, then all fields are overwritten.
func (c *ProjectsLocationsAuthzExtensionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthzExtensionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthzExtensionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthzExtensionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthzExtensionsPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthzExtensionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthzExtensionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthzExtensionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.authzextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.authzExtensions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthzExtensionsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.authzExtensions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEndpointPoliciesCreateCall struct {
	s              *Service
	parent         string
	endpointpolicy *EndpointPolicy
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new EndpointPolicy in a given project and location.
//
//   - parent: The parent resource of the EndpointPolicy. Must be in the format
//     `projects/*/locations/global`.
func (r *ProjectsLocationsEndpointPoliciesService) Create(parent string, endpointpolicy *EndpointPolicy) *ProjectsLocationsEndpointPoliciesCreateCall {
	c := &ProjectsLocationsEndpointPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.endpointpolicy = endpointpolicy
	return c
}

// EndpointPolicyId sets the optional parameter "endpointPolicyId": Required.
// Short name of the EndpointPolicy resource to be created. E.g. "CustomECS".
func (c *ProjectsLocationsEndpointPoliciesCreateCall) EndpointPolicyId(endpointPolicyId string) *ProjectsLocationsEndpointPoliciesCreateCall {
	c.urlParams_.Set("endpointPolicyId", endpointPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEndpointPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsEndpointPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEndpointPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsEndpointPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEndpointPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEndpointPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.endpointpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/endpointPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.endpointPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEndpointPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEndpointPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single EndpointPolicy.
//
//   - name: A name of the EndpointPolicy to delete. Must be in the format
//     `projects/*/locations/global/endpointPolicies/*`.
func (r *ProjectsLocationsEndpointPoliciesService) Delete(name string) *ProjectsLocationsEndpointPoliciesDeleteCall {
	c := &ProjectsLocationsEndpointPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEndpointPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsEndpointPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEndpointPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsEndpointPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEndpointPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEndpointPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.endpointPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEndpointPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEndpointPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single EndpointPolicy.
//
//   - name: A name of the EndpointPolicy to get. Must be in the format
//     `projects/*/locations/global/endpointPolicies/*`.
func (r *ProjectsLocationsEndpointPoliciesService) Get(name string) *ProjectsLocationsEndpointPoliciesGetCall {
	c := &ProjectsLocationsEndpointPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEndpointPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsEndpointPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsEndpointPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsEndpointPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEndpointPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsEndpointPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEndpointPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEndpointPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.endpointPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *EndpointPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEndpointPoliciesGetCall) Do(opts ...googleapi.CallOption) (*EndpointPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EndpointPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsEndpointPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists EndpointPolicies in a given project and location.
//
//   - parent: The project and location from which the EndpointPolicies should be
//     listed, specified in the format `projects/*/locations/global`.
func (r *ProjectsLocationsEndpointPoliciesService) List(parent string) *ProjectsLocationsEndpointPoliciesListCall {
	c := &ProjectsLocationsEndpointPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// EndpointPolicies to return per call.
func (c *ProjectsLocationsEndpointPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsEndpointPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListEndpointPoliciesResponse` Indicates that this is a continuation of
// a prior `ListEndpointPolicies` call, and that the system should return the
// next page of data.
func (c *ProjectsLocationsEndpointPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsEndpointPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
// Otherwise if one of the locations is down or unreachable, the Aggregated
// List request will fail.
func (c *ProjectsLocationsEndpointPoliciesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsEndpointPoliciesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEndpointPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEndpointPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsEndpointPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEndpointPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEndpointPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsEndpointPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEndpointPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEndpointPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/endpointPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.endpointPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEndpointPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEndpointPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListEndpointPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEndpointPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEndpointPoliciesListCall) Pages(ctx context.Context, f func(*ListEndpointPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsEndpointPoliciesPatchCall struct {
	s              *Service
	name           string
	endpointpolicy *EndpointPolicy
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates the parameters of a single EndpointPolicy.
//
//   - name: Identifier. Name of the EndpointPolicy resource. It matches pattern
//     `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
func (r *ProjectsLocationsEndpointPoliciesService) Patch(name string, endpointpolicy *EndpointPolicy) *ProjectsLocationsEndpointPoliciesPatchCall {
	c := &ProjectsLocationsEndpointPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.endpointpolicy = endpointpolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the EndpointPolicy resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsEndpointPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsEndpointPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEndpointPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsEndpointPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEndpointPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsEndpointPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEndpointPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEndpointPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.endpointpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.endpointPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsEndpointPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.endpointPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaysCreateCall struct {
	s          *Service
	parent     string
	gateway    *Gateway
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Gateway in a given project and location.
//
//   - parent: The parent resource of the Gateway. Must be in the format
//     `projects/*/locations/*`.
func (r *ProjectsLocationsGatewaysService) Create(parent string, gateway *Gateway) *ProjectsLocationsGatewaysCreateCall {
	c := &ProjectsLocationsGatewaysCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.gateway = gateway
	return c
}

// GatewayId sets the optional parameter "gatewayId": Required. Short name of
// the Gateway resource to be created.
func (c *ProjectsLocationsGatewaysCreateCall) GatewayId(gatewayId string) *ProjectsLocationsGatewaysCreateCall {
	c.urlParams_.Set("gatewayId", gatewayId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysCreateCall) Context(ctx context.Context) *ProjectsLocationsGatewaysCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gateway)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/gateways")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaysCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaysDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Gateway.
//
//   - name: A name of the Gateway to delete. Must be in the format
//     `projects/*/locations/*/gateways/*`.
func (r *ProjectsLocationsGatewaysService) Delete(name string) *ProjectsLocationsGatewaysDeleteCall {
	c := &ProjectsLocationsGatewaysDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysDeleteCall) Context(ctx context.Context) *ProjectsLocationsGatewaysDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaysDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaysGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Gateway.
//
//   - name: A name of the Gateway to get. Must be in the format
//     `projects/*/locations/*/gateways/*`.
func (r *ProjectsLocationsGatewaysService) Get(name string) *ProjectsLocationsGatewaysGetCall {
	c := &ProjectsLocationsGatewaysGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaysGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaysGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysGetCall) Context(ctx context.Context) *ProjectsLocationsGatewaysGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Gateway.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaysGetCall) Do(opts ...googleapi.CallOption) (*Gateway, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Gateway{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaysListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Gateways in a given project and location.
//
//   - parent: The project and location from which the Gateways should be listed,
//     specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsGatewaysService) List(parent string) *ProjectsLocationsGatewaysListCall {
	c := &ProjectsLocationsGatewaysListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Gateways
// to return per call.
func (c *ProjectsLocationsGatewaysListCall) PageSize(pageSize int64) *ProjectsLocationsGatewaysListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListGatewaysResponse` Indicates that this is a continuation of a prior
// `ListGateways` call, and that the system should return the next page of
// data.
func (c *ProjectsLocationsGatewaysListCall) PageToken(pageToken string) *ProjectsLocationsGatewaysListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaysListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaysListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysListCall) Context(ctx context.Context) *ProjectsLocationsGatewaysListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/gateways")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGatewaysResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGatewaysListCall) Do(opts ...googleapi.CallOption) (*ListGatewaysResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGatewaysResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGatewaysListCall) Pages(ctx context.Context, f func(*ListGatewaysResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGatewaysPatchCall struct {
	s          *Service
	name       string
	gateway    *Gateway
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single Gateway.
//
//   - name: Identifier. Name of the Gateway resource. It matches pattern
//     `projects/*/locations/*/gateways/`.
func (r *ProjectsLocationsGatewaysService) Patch(name string, gateway *Gateway) *ProjectsLocationsGatewaysPatchCall {
	c := &ProjectsLocationsGatewaysPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.gateway = gateway
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Gateway resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsGatewaysPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGatewaysPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysPatchCall) Context(ctx context.Context) *ProjectsLocationsGatewaysPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.gateway)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaysPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaysRouteViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a single RouteView of a Gateway.
//
//   - name: Name of the GatewayRouteView resource. Formats:
//     projects/{project_number}/locations/{location}/gateways/{gateway}/routeView
//     s/{route_view}.
func (r *ProjectsLocationsGatewaysRouteViewsService) Get(name string) *ProjectsLocationsGatewaysRouteViewsGetCall {
	c := &ProjectsLocationsGatewaysRouteViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysRouteViewsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysRouteViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaysRouteViewsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaysRouteViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysRouteViewsGetCall) Context(ctx context.Context) *ProjectsLocationsGatewaysRouteViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysRouteViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysRouteViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.routeViews.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.routeViews.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GatewayRouteView.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGatewaysRouteViewsGetCall) Do(opts ...googleapi.CallOption) (*GatewayRouteView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GatewayRouteView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.routeViews.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGatewaysRouteViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists RouteViews
//
//   - parent: The Gateway to which a Route is associated. Formats:
//     projects/{project_number}/locations/{location}/gateways/{gateway}.
func (r *ProjectsLocationsGatewaysRouteViewsService) List(parent string) *ProjectsLocationsGatewaysRouteViewsListCall {
	c := &ProjectsLocationsGatewaysRouteViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// GatewayRouteViews to return per call.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) PageSize(pageSize int64) *ProjectsLocationsGatewaysRouteViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListGatewayRouteViewsResponse` Indicates that this is a continuation
// of a prior `ListGatewayRouteViews` call, and that the system should return
// the next page of data.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) PageToken(pageToken string) *ProjectsLocationsGatewaysRouteViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGatewaysRouteViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGatewaysRouteViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) Context(ctx context.Context) *ProjectsLocationsGatewaysRouteViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGatewaysRouteViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/routeViews")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.routeViews.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.gateways.routeViews.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGatewayRouteViewsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) Do(opts ...googleapi.CallOption) (*ListGatewayRouteViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGatewayRouteViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.gateways.routeViews.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGatewaysRouteViewsListCall) Pages(ctx context.Context, f func(*ListGatewayRouteViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGrpcRoutesCreateCall struct {
	s          *Service
	parent     string
	grpcroute  *GrpcRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new GrpcRoute in a given project and location.
//
//   - parent: The parent resource of the GrpcRoute. Must be in the format
//     `projects/*/locations/global`.
func (r *ProjectsLocationsGrpcRoutesService) Create(parent string, grpcroute *GrpcRoute) *ProjectsLocationsGrpcRoutesCreateCall {
	c := &ProjectsLocationsGrpcRoutesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.grpcroute = grpcroute
	return c
}

// GrpcRouteId sets the optional parameter "grpcRouteId": Required. Short name
// of the GrpcRoute resource to be created.
func (c *ProjectsLocationsGrpcRoutesCreateCall) GrpcRouteId(grpcRouteId string) *ProjectsLocationsGrpcRoutesCreateCall {
	c.urlParams_.Set("grpcRouteId", grpcRouteId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGrpcRoutesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGrpcRoutesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGrpcRoutesCreateCall) Context(ctx context.Context) *ProjectsLocationsGrpcRoutesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGrpcRoutesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGrpcRoutesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.grpcroute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/grpcRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.grpcRoutes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGrpcRoutesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGrpcRoutesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single GrpcRoute.
//
//   - name: A name of the GrpcRoute to delete. Must be in the format
//     `projects/*/locations/global/grpcRoutes/*`.
func (r *ProjectsLocationsGrpcRoutesService) Delete(name string) *ProjectsLocationsGrpcRoutesDeleteCall {
	c := &ProjectsLocationsGrpcRoutesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGrpcRoutesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGrpcRoutesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGrpcRoutesDeleteCall) Context(ctx context.Context) *ProjectsLocationsGrpcRoutesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGrpcRoutesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGrpcRoutesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.grpcRoutes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGrpcRoutesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGrpcRoutesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single GrpcRoute.
//
//   - name: A name of the GrpcRoute to get. Must be in the format
//     `projects/*/locations/global/grpcRoutes/*`.
func (r *ProjectsLocationsGrpcRoutesService) Get(name string) *ProjectsLocationsGrpcRoutesGetCall {
	c := &ProjectsLocationsGrpcRoutesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGrpcRoutesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGrpcRoutesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGrpcRoutesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGrpcRoutesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGrpcRoutesGetCall) Context(ctx context.Context) *ProjectsLocationsGrpcRoutesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGrpcRoutesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGrpcRoutesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.grpcRoutes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GrpcRoute.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGrpcRoutesGetCall) Do(opts ...googleapi.CallOption) (*GrpcRoute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GrpcRoute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGrpcRoutesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists GrpcRoutes in a given project and location.
//
//   - parent: The project and location from which the GrpcRoutes should be
//     listed, specified in the format `projects/*/locations/global`.
func (r *ProjectsLocationsGrpcRoutesService) List(parent string) *ProjectsLocationsGrpcRoutesListCall {
	c := &ProjectsLocationsGrpcRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// GrpcRoutes to return per call.
func (c *ProjectsLocationsGrpcRoutesListCall) PageSize(pageSize int64) *ProjectsLocationsGrpcRoutesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListGrpcRoutesResponse` Indicates that this is a continuation of a
// prior `ListGrpcRoutes` call, and that the system should return the next page
// of data.
func (c *ProjectsLocationsGrpcRoutesListCall) PageToken(pageToken string) *ProjectsLocationsGrpcRoutesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
// Otherwise if one of the locations is down or unreachable, the Aggregated
// List request will fail.
func (c *ProjectsLocationsGrpcRoutesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsGrpcRoutesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGrpcRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGrpcRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGrpcRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGrpcRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGrpcRoutesListCall) Context(ctx context.Context) *ProjectsLocationsGrpcRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGrpcRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGrpcRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/grpcRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.grpcRoutes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGrpcRoutesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGrpcRoutesListCall) Do(opts ...googleapi.CallOption) (*ListGrpcRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGrpcRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGrpcRoutesListCall) Pages(ctx context.Context, f func(*ListGrpcRoutesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGrpcRoutesPatchCall struct {
	s          *Service
	name       string
	grpcroute  *GrpcRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single GrpcRoute.
//
//   - name: Identifier. Name of the GrpcRoute resource. It matches pattern
//     `projects/*/locations/global/grpcRoutes/`.
func (r *ProjectsLocationsGrpcRoutesService) Patch(name string, grpcroute *GrpcRoute) *ProjectsLocationsGrpcRoutesPatchCall {
	c := &ProjectsLocationsGrpcRoutesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.grpcroute = grpcroute
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the GrpcRoute resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsGrpcRoutesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGrpcRoutesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGrpcRoutesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGrpcRoutesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGrpcRoutesPatchCall) Context(ctx context.Context) *ProjectsLocationsGrpcRoutesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGrpcRoutesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGrpcRoutesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.grpcroute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.grpcRoutes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGrpcRoutesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.grpcRoutes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHttpRoutesCreateCall struct {
	s          *Service
	parent     string
	httproute  *HttpRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new HttpRoute in a given project and location.
//
//   - parent: The parent resource of the HttpRoute. Must be in the format
//     `projects/*/locations/global`.
func (r *ProjectsLocationsHttpRoutesService) Create(parent string, httproute *HttpRoute) *ProjectsLocationsHttpRoutesCreateCall {
	c := &ProjectsLocationsHttpRoutesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.httproute = httproute
	return c
}

// HttpRouteId sets the optional parameter "httpRouteId": Required. Short name
// of the HttpRoute resource to be created.
func (c *ProjectsLocationsHttpRoutesCreateCall) HttpRouteId(httpRouteId string) *ProjectsLocationsHttpRoutesCreateCall {
	c.urlParams_.Set("httpRouteId", httpRouteId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHttpRoutesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsHttpRoutesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHttpRoutesCreateCall) Context(ctx context.Context) *ProjectsLocationsHttpRoutesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHttpRoutesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHttpRoutesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.httproute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/httpRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.httpRoutes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsHttpRoutesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHttpRoutesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single HttpRoute.
//
//   - name: A name of the HttpRoute to delete. Must be in the format
//     `projects/*/locations/global/httpRoutes/*`.
func (r *ProjectsLocationsHttpRoutesService) Delete(name string) *ProjectsLocationsHttpRoutesDeleteCall {
	c := &ProjectsLocationsHttpRoutesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHttpRoutesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsHttpRoutesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHttpRoutesDeleteCall) Context(ctx context.Context) *ProjectsLocationsHttpRoutesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHttpRoutesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHttpRoutesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.httpRoutes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsHttpRoutesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHttpRoutesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single HttpRoute.
//
//   - name: A name of the HttpRoute to get. Must be in the format
//     `projects/*/locations/global/httpRoutes/*`.
func (r *ProjectsLocationsHttpRoutesService) Get(name string) *ProjectsLocationsHttpRoutesGetCall {
	c := &ProjectsLocationsHttpRoutesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHttpRoutesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsHttpRoutesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsHttpRoutesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsHttpRoutesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHttpRoutesGetCall) Context(ctx context.Context) *ProjectsLocationsHttpRoutesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHttpRoutesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHttpRoutesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.httpRoutes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *HttpRoute.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsHttpRoutesGetCall) Do(opts ...googleapi.CallOption) (*HttpRoute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HttpRoute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHttpRoutesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists HttpRoute in a given project and location.
//
//   - parent: The project and location from which the HttpRoutes should be
//     listed, specified in the format `projects/*/locations/global`.
func (r *ProjectsLocationsHttpRoutesService) List(parent string) *ProjectsLocationsHttpRoutesListCall {
	c := &ProjectsLocationsHttpRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// HttpRoutes to return per call.
func (c *ProjectsLocationsHttpRoutesListCall) PageSize(pageSize int64) *ProjectsLocationsHttpRoutesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListHttpRoutesResponse` Indicates that this is a continuation of a
// prior `ListHttpRoutes` call, and that the system should return the next page
// of data.
func (c *ProjectsLocationsHttpRoutesListCall) PageToken(pageToken string) *ProjectsLocationsHttpRoutesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
// Otherwise if one of the locations is down or unreachable, the Aggregated
// List request will fail.
func (c *ProjectsLocationsHttpRoutesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsHttpRoutesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHttpRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsHttpRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsHttpRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsHttpRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHttpRoutesListCall) Context(ctx context.Context) *ProjectsLocationsHttpRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHttpRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHttpRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/httpRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.httpRoutes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListHttpRoutesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsHttpRoutesListCall) Do(opts ...googleapi.CallOption) (*ListHttpRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListHttpRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsHttpRoutesListCall) Pages(ctx context.Context, f func(*ListHttpRoutesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsHttpRoutesPatchCall struct {
	s          *Service
	name       string
	httproute  *HttpRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single HttpRoute.
//
//   - name: Identifier. Name of the HttpRoute resource. It matches pattern
//     `projects/*/locations/global/httpRoutes/http_route_name>`.
func (r *ProjectsLocationsHttpRoutesService) Patch(name string, httproute *HttpRoute) *ProjectsLocationsHttpRoutesPatchCall {
	c := &ProjectsLocationsHttpRoutesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.httproute = httproute
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the HttpRoute resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsHttpRoutesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsHttpRoutesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHttpRoutesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsHttpRoutesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHttpRoutesPatchCall) Context(ctx context.Context) *ProjectsLocationsHttpRoutesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHttpRoutesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHttpRoutesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.httproute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.httpRoutes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsHttpRoutesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.httpRoutes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbEdgeExtensionsCreateCall struct {
	s               *Service
	parent          string
	lbedgeextension *LbEdgeExtension
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new `LbEdgeExtension` resource in a given project and
// location.
//
//   - parent: The parent resource of the `LbEdgeExtension` resource. Must be in
//     the format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsLbEdgeExtensionsService) Create(parent string, lbedgeextension *LbEdgeExtension) *ProjectsLocationsLbEdgeExtensionsCreateCall {
	c := &ProjectsLocationsLbEdgeExtensionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.lbedgeextension = lbedgeextension
	return c
}

// LbEdgeExtensionId sets the optional parameter "lbEdgeExtensionId": Required.
// User-provided ID of the `LbEdgeExtension` resource to be created.
func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) LbEdgeExtensionId(lbEdgeExtensionId string) *ProjectsLocationsLbEdgeExtensionsCreateCall {
	c.urlParams_.Set("lbEdgeExtensionId", lbEdgeExtensionId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) RequestId(requestId string) *ProjectsLocationsLbEdgeExtensionsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbEdgeExtensionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) Context(ctx context.Context) *ProjectsLocationsLbEdgeExtensionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lbedgeextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/lbEdgeExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbEdgeExtensions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbEdgeExtensionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbEdgeExtensionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `LbEdgeExtension` resource.
//
//   - name: The name of the `LbEdgeExtension` resource to delete. Must be in the
//     format
//     `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extensio
//     n}`.
func (r *ProjectsLocationsLbEdgeExtensionsService) Delete(name string) *ProjectsLocationsLbEdgeExtensionsDeleteCall {
	c := &ProjectsLocationsLbEdgeExtensionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes after the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbEdgeExtensionsDeleteCall) RequestId(requestId string) *ProjectsLocationsLbEdgeExtensionsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbEdgeExtensionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbEdgeExtensionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbEdgeExtensionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsLbEdgeExtensionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbEdgeExtensionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbEdgeExtensionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbEdgeExtensions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbEdgeExtensionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbEdgeExtensionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified `LbEdgeExtension` resource.
//
//   - name: A name of the `LbEdgeExtension` resource to get. Must be in the
//     format
//     `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extensio
//     n}`.
func (r *ProjectsLocationsLbEdgeExtensionsService) Get(name string) *ProjectsLocationsLbEdgeExtensionsGetCall {
	c := &ProjectsLocationsLbEdgeExtensionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbEdgeExtensionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbEdgeExtensionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLbEdgeExtensionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsLbEdgeExtensionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbEdgeExtensionsGetCall) Context(ctx context.Context) *ProjectsLocationsLbEdgeExtensionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbEdgeExtensionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbEdgeExtensionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbEdgeExtensions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LbEdgeExtension.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsLbEdgeExtensionsGetCall) Do(opts ...googleapi.CallOption) (*LbEdgeExtension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LbEdgeExtension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbEdgeExtensionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `LbEdgeExtension` resources in a given project and location.
//
//   - parent: The project and location from which the `LbEdgeExtension`
//     resources are listed. These values are specified in the following format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsLbEdgeExtensionsService) List(parent string) *ProjectsLocationsLbEdgeExtensionsListCall {
	c := &ProjectsLocationsLbEdgeExtensionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) Filter(filter string) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint about how to order the
// results.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) OrderBy(orderBy string) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server might return fewer items than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) PageSize(pageSize int64) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server returns.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) PageToken(pageToken string) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) Context(ctx context.Context) *ProjectsLocationsLbEdgeExtensionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbEdgeExtensionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/lbEdgeExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbEdgeExtensions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLbEdgeExtensionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) Do(opts ...googleapi.CallOption) (*ListLbEdgeExtensionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLbEdgeExtensionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsLbEdgeExtensionsListCall) Pages(ctx context.Context, f func(*ListLbEdgeExtensionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsLbEdgeExtensionsPatchCall struct {
	s               *Service
	name            string
	lbedgeextension *LbEdgeExtension
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the parameters of the specified `LbEdgeExtension` resource.
//
//   - name: Identifier. Name of the `LbEdgeExtension` resource in the following
//     format:
//     `projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extensio
//     n}`.
func (r *ProjectsLocationsLbEdgeExtensionsService) Patch(name string, lbedgeextension *LbEdgeExtension) *ProjectsLocationsLbEdgeExtensionsPatchCall {
	c := &ProjectsLocationsLbEdgeExtensionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.lbedgeextension = lbedgeextension
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) RequestId(requestId string) *ProjectsLocationsLbEdgeExtensionsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Used to specify the
// fields to be overwritten in the `LbEdgeExtension` resource by the update.
// The fields specified in the `update_mask` are relative to the resource, not
// the full request. A field is overwritten if it is in the mask. If the user
// does not specify a mask, then all fields are overwritten.
func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsLbEdgeExtensionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbEdgeExtensionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) Context(ctx context.Context) *ProjectsLocationsLbEdgeExtensionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lbedgeextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbEdgeExtensions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbEdgeExtensionsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbEdgeExtensions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbRouteExtensionsCreateCall struct {
	s                *Service
	parent           string
	lbrouteextension *LbRouteExtension
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new `LbRouteExtension` resource in a given project and
// location.
//
//   - parent: The parent resource of the `LbRouteExtension` resource. Must be in
//     the format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsLbRouteExtensionsService) Create(parent string, lbrouteextension *LbRouteExtension) *ProjectsLocationsLbRouteExtensionsCreateCall {
	c := &ProjectsLocationsLbRouteExtensionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.lbrouteextension = lbrouteextension
	return c
}

// LbRouteExtensionId sets the optional parameter "lbRouteExtensionId":
// Required. User-provided ID of the `LbRouteExtension` resource to be created.
func (c *ProjectsLocationsLbRouteExtensionsCreateCall) LbRouteExtensionId(lbRouteExtensionId string) *ProjectsLocationsLbRouteExtensionsCreateCall {
	c.urlParams_.Set("lbRouteExtensionId", lbRouteExtensionId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbRouteExtensionsCreateCall) RequestId(requestId string) *ProjectsLocationsLbRouteExtensionsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbRouteExtensionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbRouteExtensionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbRouteExtensionsCreateCall) Context(ctx context.Context) *ProjectsLocationsLbRouteExtensionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbRouteExtensionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbRouteExtensionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lbrouteextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/lbRouteExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbRouteExtensions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbRouteExtensionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbRouteExtensionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `LbRouteExtension` resource.
//
//   - name: The name of the `LbRouteExtension` resource to delete. Must be in
//     the format
//     `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extens
//     ion}`.
func (r *ProjectsLocationsLbRouteExtensionsService) Delete(name string) *ProjectsLocationsLbRouteExtensionsDeleteCall {
	c := &ProjectsLocationsLbRouteExtensionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes after the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbRouteExtensionsDeleteCall) RequestId(requestId string) *ProjectsLocationsLbRouteExtensionsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbRouteExtensionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbRouteExtensionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbRouteExtensionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsLbRouteExtensionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbRouteExtensionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbRouteExtensionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbRouteExtensions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbRouteExtensionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbRouteExtensionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified `LbRouteExtension` resource.
//
//   - name: A name of the `LbRouteExtension` resource to get. Must be in the
//     format
//     `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extens
//     ion}`.
func (r *ProjectsLocationsLbRouteExtensionsService) Get(name string) *ProjectsLocationsLbRouteExtensionsGetCall {
	c := &ProjectsLocationsLbRouteExtensionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbRouteExtensionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbRouteExtensionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLbRouteExtensionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsLbRouteExtensionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbRouteExtensionsGetCall) Context(ctx context.Context) *ProjectsLocationsLbRouteExtensionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbRouteExtensionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbRouteExtensionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbRouteExtensions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LbRouteExtension.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsLbRouteExtensionsGetCall) Do(opts ...googleapi.CallOption) (*LbRouteExtension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LbRouteExtension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbRouteExtensionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `LbRouteExtension` resources in a given project and location.
//
//   - parent: The project and location from which the `LbRouteExtension`
//     resources are listed. These values are specified in the following format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsLbRouteExtensionsService) List(parent string) *ProjectsLocationsLbRouteExtensionsListCall {
	c := &ProjectsLocationsLbRouteExtensionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsLbRouteExtensionsListCall) Filter(filter string) *ProjectsLocationsLbRouteExtensionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint about how to order the
// results.
func (c *ProjectsLocationsLbRouteExtensionsListCall) OrderBy(orderBy string) *ProjectsLocationsLbRouteExtensionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server might return fewer items than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsLocationsLbRouteExtensionsListCall) PageSize(pageSize int64) *ProjectsLocationsLbRouteExtensionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server returns.
func (c *ProjectsLocationsLbRouteExtensionsListCall) PageToken(pageToken string) *ProjectsLocationsLbRouteExtensionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbRouteExtensionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbRouteExtensionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLbRouteExtensionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsLbRouteExtensionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbRouteExtensionsListCall) Context(ctx context.Context) *ProjectsLocationsLbRouteExtensionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbRouteExtensionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbRouteExtensionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/lbRouteExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbRouteExtensions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLbRouteExtensionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsLbRouteExtensionsListCall) Do(opts ...googleapi.CallOption) (*ListLbRouteExtensionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLbRouteExtensionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsLbRouteExtensionsListCall) Pages(ctx context.Context, f func(*ListLbRouteExtensionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsLbRouteExtensionsPatchCall struct {
	s                *Service
	name             string
	lbrouteextension *LbRouteExtension
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Patch: Updates the parameters of the specified `LbRouteExtension` resource.
//
//   - name: Identifier. Name of the `LbRouteExtension` resource in the following
//     format:
//     `projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extens
//     ion}`.
func (r *ProjectsLocationsLbRouteExtensionsService) Patch(name string, lbrouteextension *LbRouteExtension) *ProjectsLocationsLbRouteExtensionsPatchCall {
	c := &ProjectsLocationsLbRouteExtensionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.lbrouteextension = lbrouteextension
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbRouteExtensionsPatchCall) RequestId(requestId string) *ProjectsLocationsLbRouteExtensionsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Used to specify the
// fields to be overwritten in the `LbRouteExtension` resource by the update.
// The fields specified in the `update_mask` are relative to the resource, not
// the full request. A field is overwritten if it is in the mask. If the user
// does not specify a mask, then all fields are overwritten.
func (c *ProjectsLocationsLbRouteExtensionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsLbRouteExtensionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbRouteExtensionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbRouteExtensionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbRouteExtensionsPatchCall) Context(ctx context.Context) *ProjectsLocationsLbRouteExtensionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbRouteExtensionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbRouteExtensionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lbrouteextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbRouteExtensions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbRouteExtensionsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbRouteExtensions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbTrafficExtensionsCreateCall struct {
	s                  *Service
	parent             string
	lbtrafficextension *LbTrafficExtension
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Creates a new `LbTrafficExtension` resource in a given project and
// location.
//
//   - parent: The parent resource of the `LbTrafficExtension` resource. Must be
//     in the format `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsLbTrafficExtensionsService) Create(parent string, lbtrafficextension *LbTrafficExtension) *ProjectsLocationsLbTrafficExtensionsCreateCall {
	c := &ProjectsLocationsLbTrafficExtensionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.lbtrafficextension = lbtrafficextension
	return c
}

// LbTrafficExtensionId sets the optional parameter "lbTrafficExtensionId":
// Required. User-provided ID of the `LbTrafficExtension` resource to be
// created.
func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) LbTrafficExtensionId(lbTrafficExtensionId string) *ProjectsLocationsLbTrafficExtensionsCreateCall {
	c.urlParams_.Set("lbTrafficExtensionId", lbTrafficExtensionId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) RequestId(requestId string) *ProjectsLocationsLbTrafficExtensionsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbTrafficExtensionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) Context(ctx context.Context) *ProjectsLocationsLbTrafficExtensionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lbtrafficextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/lbTrafficExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbTrafficExtensions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbTrafficExtensionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbTrafficExtensionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `LbTrafficExtension` resource.
//
//   - name: The name of the `LbTrafficExtension` resource to delete. Must be in
//     the format
//     `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_ex
//     tension}`.
func (r *ProjectsLocationsLbTrafficExtensionsService) Delete(name string) *ProjectsLocationsLbTrafficExtensionsDeleteCall {
	c := &ProjectsLocationsLbTrafficExtensionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes after the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbTrafficExtensionsDeleteCall) RequestId(requestId string) *ProjectsLocationsLbTrafficExtensionsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbTrafficExtensionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbTrafficExtensionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbTrafficExtensionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsLbTrafficExtensionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbTrafficExtensionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbTrafficExtensionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbTrafficExtensions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbTrafficExtensionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbTrafficExtensionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified `LbTrafficExtension` resource.
//
//   - name: A name of the `LbTrafficExtension` resource to get. Must be in the
//     format
//     `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_ex
//     tension}`.
func (r *ProjectsLocationsLbTrafficExtensionsService) Get(name string) *ProjectsLocationsLbTrafficExtensionsGetCall {
	c := &ProjectsLocationsLbTrafficExtensionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbTrafficExtensionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbTrafficExtensionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLbTrafficExtensionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsLbTrafficExtensionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbTrafficExtensionsGetCall) Context(ctx context.Context) *ProjectsLocationsLbTrafficExtensionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbTrafficExtensionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbTrafficExtensionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbTrafficExtensions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LbTrafficExtension.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsLbTrafficExtensionsGetCall) Do(opts ...googleapi.CallOption) (*LbTrafficExtension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LbTrafficExtension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsLbTrafficExtensionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `LbTrafficExtension` resources in a given project and location.
//
//   - parent: The project and location from which the `LbTrafficExtension`
//     resources are listed. These values are specified in the following format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsLbTrafficExtensionsService) List(parent string) *ProjectsLocationsLbTrafficExtensionsListCall {
	c := &ProjectsLocationsLbTrafficExtensionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) Filter(filter string) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint about how to order the
// results.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) OrderBy(orderBy string) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server might return fewer items than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) PageSize(pageSize int64) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results that the server returns.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) PageToken(pageToken string) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) Context(ctx context.Context) *ProjectsLocationsLbTrafficExtensionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbTrafficExtensionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/lbTrafficExtensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbTrafficExtensions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLbTrafficExtensionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) Do(opts ...googleapi.CallOption) (*ListLbTrafficExtensionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLbTrafficExtensionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsLbTrafficExtensionsListCall) Pages(ctx context.Context, f func(*ListLbTrafficExtensionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsLbTrafficExtensionsPatchCall struct {
	s                  *Service
	name               string
	lbtrafficextension *LbTrafficExtension
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates the parameters of the specified `LbTrafficExtension`
// resource.
//
//   - name: Identifier. Name of the `LbTrafficExtension` resource in the
//     following format:
//     `projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_ex
//     tension}`.
func (r *ProjectsLocationsLbTrafficExtensionsService) Patch(name string, lbtrafficextension *LbTrafficExtension) *ProjectsLocationsLbTrafficExtensionsPatchCall {
	c := &ProjectsLocationsLbTrafficExtensionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.lbtrafficextension = lbtrafficextension
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server can ignore the request if it has already been
// completed. The server guarantees that for 60 minutes since the first
// request. For example, consider a situation where you make an initial request
// and the request times out. If you make the request again with the same
// request ID, the server ignores the second request This prevents clients from
// accidentally creating duplicate commitments. The request ID must be a valid
// UUID with the exception that zero UUID is not supported
// (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) RequestId(requestId string) *ProjectsLocationsLbTrafficExtensionsPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Used to specify the
// fields to be overwritten in the `LbTrafficExtension` resource by the update.
// The fields specified in the `update_mask` are relative to the resource, not
// the full request. A field is overwritten if it is in the mask. If the user
// does not specify a mask, then all fields are overwritten.
func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsLbTrafficExtensionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsLbTrafficExtensionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) Context(ctx context.Context) *ProjectsLocationsLbTrafficExtensionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lbtrafficextension)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.lbTrafficExtensions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLbTrafficExtensionsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.lbTrafficExtensions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMeshesCreateCall struct {
	s          *Service
	parent     string
	mesh       *Mesh
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Mesh in a given project and location.
//
//   - parent: The parent resource of the Mesh. Must be in the format
//     `projects/*/locations/global`.
func (r *ProjectsLocationsMeshesService) Create(parent string, mesh *Mesh) *ProjectsLocationsMeshesCreateCall {
	c := &ProjectsLocationsMeshesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.mesh = mesh
	return c
}

// MeshId sets the optional parameter "meshId": Required. Short name of the
// Mesh resource to be created.
func (c *ProjectsLocationsMeshesCreateCall) MeshId(meshId string) *ProjectsLocationsMeshesCreateCall {
	c.urlParams_.Set("meshId", meshId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesCreateCall) Context(ctx context.Context) *ProjectsLocationsMeshesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mesh)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/meshes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMeshesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMeshesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single Mesh.
//
//   - name: A name of the Mesh to delete. Must be in the format
//     `projects/*/locations/global/meshes/*`.
func (r *ProjectsLocationsMeshesService) Delete(name string) *ProjectsLocationsMeshesDeleteCall {
	c := &ProjectsLocationsMeshesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesDeleteCall) Context(ctx context.Context) *ProjectsLocationsMeshesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMeshesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMeshesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single Mesh.
//
//   - name: A name of the Mesh to get. Must be in the format
//     `projects/*/locations/global/meshes/*`.
func (r *ProjectsLocationsMeshesService) Get(name string) *ProjectsLocationsMeshesGetCall {
	c := &ProjectsLocationsMeshesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMeshesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMeshesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesGetCall) Context(ctx context.Context) *ProjectsLocationsMeshesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Mesh.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMeshesGetCall) Do(opts ...googleapi.CallOption) (*Mesh, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Mesh{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMeshesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Meshes in a given project and location.
//
//   - parent: The project and location from which the Meshes should be listed,
//     specified in the format `projects/*/locations/global`.
func (r *ProjectsLocationsMeshesService) List(parent string) *ProjectsLocationsMeshesListCall {
	c := &ProjectsLocationsMeshesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Meshes to
// return per call.
func (c *ProjectsLocationsMeshesListCall) PageSize(pageSize int64) *ProjectsLocationsMeshesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListMeshesResponse` Indicates that this is a continuation of a prior
// `ListMeshes` call, and that the system should return the next page of data.
func (c *ProjectsLocationsMeshesListCall) PageToken(pageToken string) *ProjectsLocationsMeshesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
// Otherwise if one of the locations is down or unreachable, the Aggregated
// List request will fail.
func (c *ProjectsLocationsMeshesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsMeshesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMeshesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMeshesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesListCall) Context(ctx context.Context) *ProjectsLocationsMeshesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/meshes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMeshesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsMeshesListCall) Do(opts ...googleapi.CallOption) (*ListMeshesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMeshesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMeshesListCall) Pages(ctx context.Context, f func(*ListMeshesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsMeshesPatchCall struct {
	s          *Service
	name       string
	mesh       *Mesh
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single Mesh.
//
//   - name: Identifier. Name of the Mesh resource. It matches pattern
//     `projects/*/locations/global/meshes/`.
func (r *ProjectsLocationsMeshesService) Patch(name string, mesh *Mesh) *ProjectsLocationsMeshesPatchCall {
	c := &ProjectsLocationsMeshesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.mesh = mesh
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the Mesh resource by the update. The
// fields specified in the update_mask are relative to the resource, not the
// full request. A field will be overwritten if it is in the mask. If the user
// does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsMeshesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsMeshesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesPatchCall) Context(ctx context.Context) *ProjectsLocationsMeshesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.mesh)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMeshesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMeshesRouteViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a single RouteView of a Mesh.
//
//   - name: Name of the MeshRouteView resource. Format:
//     projects/{project_number}/locations/{location}/meshes/{mesh}/routeViews/{ro
//     ute_view}.
func (r *ProjectsLocationsMeshesRouteViewsService) Get(name string) *ProjectsLocationsMeshesRouteViewsGetCall {
	c := &ProjectsLocationsMeshesRouteViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesRouteViewsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesRouteViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMeshesRouteViewsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsMeshesRouteViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesRouteViewsGetCall) Context(ctx context.Context) *ProjectsLocationsMeshesRouteViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesRouteViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesRouteViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.routeViews.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.routeViews.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MeshRouteView.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsMeshesRouteViewsGetCall) Do(opts ...googleapi.CallOption) (*MeshRouteView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MeshRouteView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.routeViews.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsMeshesRouteViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists RouteViews
//
//   - parent: The Mesh to which a Route is associated. Format:
//     projects/{project_number}/locations/{location}/meshes/{mesh}.
func (r *ProjectsLocationsMeshesRouteViewsService) List(parent string) *ProjectsLocationsMeshesRouteViewsListCall {
	c := &ProjectsLocationsMeshesRouteViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// MeshRouteViews to return per call.
func (c *ProjectsLocationsMeshesRouteViewsListCall) PageSize(pageSize int64) *ProjectsLocationsMeshesRouteViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListMeshRouteViewsResponse` Indicates that this is a continuation of a
// prior `ListMeshRouteViews` call, and that the system should return the next
// page of data.
func (c *ProjectsLocationsMeshesRouteViewsListCall) PageToken(pageToken string) *ProjectsLocationsMeshesRouteViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsMeshesRouteViewsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsMeshesRouteViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsMeshesRouteViewsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsMeshesRouteViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsMeshesRouteViewsListCall) Context(ctx context.Context) *ProjectsLocationsMeshesRouteViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsMeshesRouteViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsMeshesRouteViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/routeViews")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.routeViews.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.meshes.routeViews.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMeshRouteViewsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsMeshesRouteViewsListCall) Do(opts ...googleapi.CallOption) (*ListMeshRouteViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMeshRouteViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.meshes.routeViews.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsMeshesRouteViewsListCall) Pages(ctx context.Context, f func(*ListMeshRouteViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServiceBindingsCreateCall struct {
	s              *Service
	parent         string
	servicebinding *ServiceBinding
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new ServiceBinding in a given project and location.
//
//   - parent: The parent resource of the ServiceBinding. Must be in the format
//     `projects/*/locations/*`.
func (r *ProjectsLocationsServiceBindingsService) Create(parent string, servicebinding *ServiceBinding) *ProjectsLocationsServiceBindingsCreateCall {
	c := &ProjectsLocationsServiceBindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.servicebinding = servicebinding
	return c
}

// ServiceBindingId sets the optional parameter "serviceBindingId": Required.
// Short name of the ServiceBinding resource to be created.
func (c *ProjectsLocationsServiceBindingsCreateCall) ServiceBindingId(serviceBindingId string) *ProjectsLocationsServiceBindingsCreateCall {
	c.urlParams_.Set("serviceBindingId", serviceBindingId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceBindingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceBindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceBindingsCreateCall) Context(ctx context.Context) *ProjectsLocationsServiceBindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceBindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceBindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.servicebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/serviceBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceBindings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceBindingsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceBindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ServiceBinding.
//
//   - name: A name of the ServiceBinding to delete. Must be in the format
//     `projects/*/locations/*/serviceBindings/*`.
func (r *ProjectsLocationsServiceBindingsService) Delete(name string) *ProjectsLocationsServiceBindingsDeleteCall {
	c := &ProjectsLocationsServiceBindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceBindingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceBindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceBindingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsServiceBindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceBindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceBindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceBindings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceBindingsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceBindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ServiceBinding.
//
//   - name: A name of the ServiceBinding to get. Must be in the format
//     `projects/*/locations/*/serviceBindings/*`.
func (r *ProjectsLocationsServiceBindingsService) Get(name string) *ProjectsLocationsServiceBindingsGetCall {
	c := &ProjectsLocationsServiceBindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceBindingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceBindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServiceBindingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServiceBindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceBindingsGetCall) Context(ctx context.Context) *ProjectsLocationsServiceBindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceBindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceBindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceBindings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ServiceBinding.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceBindingsGetCall) Do(opts ...googleapi.CallOption) (*ServiceBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ServiceBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceBindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ServiceBinding in a given project and location.
//
//   - parent: The project and location from which the ServiceBindings should be
//     listed, specified in the format `projects/*/locations/*`.
func (r *ProjectsLocationsServiceBindingsService) List(parent string) *ProjectsLocationsServiceBindingsListCall {
	c := &ProjectsLocationsServiceBindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// ServiceBindings to return per call.
func (c *ProjectsLocationsServiceBindingsListCall) PageSize(pageSize int64) *ProjectsLocationsServiceBindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListServiceBindingsResponse` Indicates that this is a continuation of
// a prior `ListRouters` call, and that the system should return the next page
// of data.
func (c *ProjectsLocationsServiceBindingsListCall) PageToken(pageToken string) *ProjectsLocationsServiceBindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceBindingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceBindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServiceBindingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServiceBindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceBindingsListCall) Context(ctx context.Context) *ProjectsLocationsServiceBindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceBindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceBindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/serviceBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceBindings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListServiceBindingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceBindingsListCall) Do(opts ...googleapi.CallOption) (*ListServiceBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListServiceBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServiceBindingsListCall) Pages(ctx context.Context, f func(*ListServiceBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServiceBindingsPatchCall struct {
	s              *Service
	name           string
	servicebinding *ServiceBinding
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates the parameters of a single ServiceBinding.
//
//   - name: Identifier. Name of the ServiceBinding resource. It matches pattern
//     `projects/*/locations/*/serviceBindings/`.
func (r *ProjectsLocationsServiceBindingsService) Patch(name string, servicebinding *ServiceBinding) *ProjectsLocationsServiceBindingsPatchCall {
	c := &ProjectsLocationsServiceBindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.servicebinding = servicebinding
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the ServiceBinding resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsServiceBindingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsServiceBindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceBindingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceBindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceBindingsPatchCall) Context(ctx context.Context) *ProjectsLocationsServiceBindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceBindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceBindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.servicebinding)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceBindings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceBindingsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceBindings.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceLbPoliciesCreateCall struct {
	s               *Service
	parent          string
	servicelbpolicy *ServiceLbPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a new ServiceLbPolicy in a given project and location.
//
//   - parent: The parent resource of the ServiceLbPolicy. Must be in the format
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsServiceLbPoliciesService) Create(parent string, servicelbpolicy *ServiceLbPolicy) *ProjectsLocationsServiceLbPoliciesCreateCall {
	c := &ProjectsLocationsServiceLbPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.servicelbpolicy = servicelbpolicy
	return c
}

// ServiceLbPolicyId sets the optional parameter "serviceLbPolicyId": Required.
// Short name of the ServiceLbPolicy resource to be created. E.g. for resource
// name
// `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy
// _name}`. the id is value of {service_lb_policy_name}
func (c *ProjectsLocationsServiceLbPoliciesCreateCall) ServiceLbPolicyId(serviceLbPolicyId string) *ProjectsLocationsServiceLbPoliciesCreateCall {
	c.urlParams_.Set("serviceLbPolicyId", serviceLbPolicyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceLbPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceLbPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceLbPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsServiceLbPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceLbPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceLbPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.servicelbpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/serviceLbPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceLbPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceLbPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceLbPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ServiceLbPolicy.
//
//   - name: A name of the ServiceLbPolicy to delete. Must be in the format
//     `projects/{project}/locations/{location}/serviceLbPolicies/*`.
func (r *ProjectsLocationsServiceLbPoliciesService) Delete(name string) *ProjectsLocationsServiceLbPoliciesDeleteCall {
	c := &ProjectsLocationsServiceLbPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceLbPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceLbPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceLbPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsServiceLbPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceLbPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceLbPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceLbPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceLbPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceLbPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ServiceLbPolicy.
//
//   - name: A name of the ServiceLbPolicy to get. Must be in the format
//     `projects/{project}/locations/{location}/serviceLbPolicies/*`.
func (r *ProjectsLocationsServiceLbPoliciesService) Get(name string) *ProjectsLocationsServiceLbPoliciesGetCall {
	c := &ProjectsLocationsServiceLbPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceLbPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceLbPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServiceLbPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServiceLbPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceLbPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsServiceLbPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceLbPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceLbPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceLbPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ServiceLbPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServiceLbPoliciesGetCall) Do(opts ...googleapi.CallOption) (*ServiceLbPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ServiceLbPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServiceLbPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ServiceLbPolicies in a given project and location.
//
//   - parent: The project and location from which the ServiceLbPolicies should
//     be listed, specified in the format
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsServiceLbPoliciesService) List(parent string) *ProjectsLocationsServiceLbPoliciesListCall {
	c := &ProjectsLocationsServiceLbPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// ServiceLbPolicies to return per call.
func (c *ProjectsLocationsServiceLbPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsServiceLbPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListServiceLbPoliciesResponse` Indicates that this is a continuation
// of a prior `ListRouters` call, and that the system should return the next
// page of data.
func (c *ProjectsLocationsServiceLbPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsServiceLbPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceLbPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceLbPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServiceLbPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServiceLbPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceLbPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsServiceLbPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceLbPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceLbPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/serviceLbPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceLbPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListServiceLbPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceLbPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListServiceLbPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListServiceLbPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServiceLbPoliciesListCall) Pages(ctx context.Context, f func(*ListServiceLbPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServiceLbPoliciesPatchCall struct {
	s               *Service
	name            string
	servicelbpolicy *ServiceLbPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the parameters of a single ServiceLbPolicy.
//
//   - name: Identifier. Name of the ServiceLbPolicy resource. It matches pattern
//     `projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_poli
//     cy_name}`.
func (r *ProjectsLocationsServiceLbPoliciesService) Patch(name string, servicelbpolicy *ServiceLbPolicy) *ProjectsLocationsServiceLbPoliciesPatchCall {
	c := &ProjectsLocationsServiceLbPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.servicelbpolicy = servicelbpolicy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the ServiceLbPolicy resource by the
// update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsServiceLbPoliciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsServiceLbPoliciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServiceLbPoliciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsServiceLbPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServiceLbPoliciesPatchCall) Context(ctx context.Context) *ProjectsLocationsServiceLbPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServiceLbPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServiceLbPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.servicelbpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.serviceLbPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServiceLbPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.serviceLbPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTcpRoutesCreateCall struct {
	s          *Service
	parent     string
	tcproute   *TcpRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new TcpRoute in a given project and location.
//
//   - parent: The parent resource of the TcpRoute. Must be in the format
//     `projects/*/locations/global`.
func (r *ProjectsLocationsTcpRoutesService) Create(parent string, tcproute *TcpRoute) *ProjectsLocationsTcpRoutesCreateCall {
	c := &ProjectsLocationsTcpRoutesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.tcproute = tcproute
	return c
}

// TcpRouteId sets the optional parameter "tcpRouteId": Required. Short name of
// the TcpRoute resource to be created.
func (c *ProjectsLocationsTcpRoutesCreateCall) TcpRouteId(tcpRouteId string) *ProjectsLocationsTcpRoutesCreateCall {
	c.urlParams_.Set("tcpRouteId", tcpRouteId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTcpRoutesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsTcpRoutesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTcpRoutesCreateCall) Context(ctx context.Context) *ProjectsLocationsTcpRoutesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTcpRoutesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTcpRoutesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tcproute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/tcpRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tcpRoutes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTcpRoutesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTcpRoutesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single TcpRoute.
//
//   - name: A name of the TcpRoute to delete. Must be in the format
//     `projects/*/locations/global/tcpRoutes/*`.
func (r *ProjectsLocationsTcpRoutesService) Delete(name string) *ProjectsLocationsTcpRoutesDeleteCall {
	c := &ProjectsLocationsTcpRoutesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTcpRoutesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsTcpRoutesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTcpRoutesDeleteCall) Context(ctx context.Context) *ProjectsLocationsTcpRoutesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTcpRoutesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTcpRoutesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tcpRoutes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTcpRoutesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTcpRoutesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single TcpRoute.
//
//   - name: A name of the TcpRoute to get. Must be in the format
//     `projects/*/locations/global/tcpRoutes/*`.
func (r *ProjectsLocationsTcpRoutesService) Get(name string) *ProjectsLocationsTcpRoutesGetCall {
	c := &ProjectsLocationsTcpRoutesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTcpRoutesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsTcpRoutesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTcpRoutesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsTcpRoutesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTcpRoutesGetCall) Context(ctx context.Context) *ProjectsLocationsTcpRoutesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTcpRoutesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTcpRoutesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tcpRoutes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TcpRoute.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTcpRoutesGetCall) Do(opts ...googleapi.CallOption) (*TcpRoute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TcpRoute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTcpRoutesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists TcpRoute in a given project and location.
//
//   - parent: The project and location from which the TcpRoutes should be
//     listed, specified in the format `projects/*/locations/global`.
func (r *ProjectsLocationsTcpRoutesService) List(parent string) *ProjectsLocationsTcpRoutesListCall {
	c := &ProjectsLocationsTcpRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of TcpRoutes
// to return per call.
func (c *ProjectsLocationsTcpRoutesListCall) PageSize(pageSize int64) *ProjectsLocationsTcpRoutesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListTcpRoutesResponse` Indicates that this is a continuation of a
// prior `ListTcpRoutes` call, and that the system should return the next page
// of data.
func (c *ProjectsLocationsTcpRoutesListCall) PageToken(pageToken string) *ProjectsLocationsTcpRoutesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
// Otherwise if one of the locations is down or unreachable, the Aggregated
// List request will fail.
func (c *ProjectsLocationsTcpRoutesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsTcpRoutesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTcpRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsTcpRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTcpRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsTcpRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTcpRoutesListCall) Context(ctx context.Context) *ProjectsLocationsTcpRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTcpRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTcpRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/tcpRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tcpRoutes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTcpRoutesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsTcpRoutesListCall) Do(opts ...googleapi.CallOption) (*ListTcpRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTcpRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsTcpRoutesListCall) Pages(ctx context.Context, f func(*ListTcpRoutesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsTcpRoutesPatchCall struct {
	s          *Service
	name       string
	tcproute   *TcpRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single TcpRoute.
//
//   - name: Identifier. Name of the TcpRoute resource. It matches pattern
//     `projects/*/locations/global/tcpRoutes/tcp_route_name>`.
func (r *ProjectsLocationsTcpRoutesService) Patch(name string, tcproute *TcpRoute) *ProjectsLocationsTcpRoutesPatchCall {
	c := &ProjectsLocationsTcpRoutesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.tcproute = tcproute
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the TcpRoute resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsTcpRoutesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsTcpRoutesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTcpRoutesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsTcpRoutesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTcpRoutesPatchCall) Context(ctx context.Context) *ProjectsLocationsTcpRoutesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTcpRoutesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTcpRoutesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tcproute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tcpRoutes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTcpRoutesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tcpRoutes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsRoutesCreateCall struct {
	s          *Service
	parent     string
	tlsroute   *TlsRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new TlsRoute in a given project and location.
//
//   - parent: The parent resource of the TlsRoute. Must be in the format
//     `projects/*/locations/global`.
func (r *ProjectsLocationsTlsRoutesService) Create(parent string, tlsroute *TlsRoute) *ProjectsLocationsTlsRoutesCreateCall {
	c := &ProjectsLocationsTlsRoutesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.tlsroute = tlsroute
	return c
}

// TlsRouteId sets the optional parameter "tlsRouteId": Required. Short name of
// the TlsRoute resource to be created.
func (c *ProjectsLocationsTlsRoutesCreateCall) TlsRouteId(tlsRouteId string) *ProjectsLocationsTlsRoutesCreateCall {
	c.urlParams_.Set("tlsRouteId", tlsRouteId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsRoutesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsRoutesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsRoutesCreateCall) Context(ctx context.Context) *ProjectsLocationsTlsRoutesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsRoutesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsRoutesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tlsroute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/tlsRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tlsRoutes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsRoutesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsRoutesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single TlsRoute.
//
//   - name: A name of the TlsRoute to delete. Must be in the format
//     `projects/*/locations/global/tlsRoutes/*`.
func (r *ProjectsLocationsTlsRoutesService) Delete(name string) *ProjectsLocationsTlsRoutesDeleteCall {
	c := &ProjectsLocationsTlsRoutesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsRoutesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsRoutesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsRoutesDeleteCall) Context(ctx context.Context) *ProjectsLocationsTlsRoutesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsRoutesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsRoutesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tlsRoutes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsRoutesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsRoutesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single TlsRoute.
//
//   - name: A name of the TlsRoute to get. Must be in the format
//     `projects/*/locations/global/tlsRoutes/*`.
func (r *ProjectsLocationsTlsRoutesService) Get(name string) *ProjectsLocationsTlsRoutesGetCall {
	c := &ProjectsLocationsTlsRoutesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsRoutesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsRoutesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTlsRoutesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsTlsRoutesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsRoutesGetCall) Context(ctx context.Context) *ProjectsLocationsTlsRoutesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsRoutesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsRoutesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tlsRoutes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *TlsRoute.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsRoutesGetCall) Do(opts ...googleapi.CallOption) (*TlsRoute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TlsRoute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTlsRoutesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists TlsRoute in a given project and location.
//
//   - parent: The project and location from which the TlsRoutes should be
//     listed, specified in the format `projects/*/locations/global`.
func (r *ProjectsLocationsTlsRoutesService) List(parent string) *ProjectsLocationsTlsRoutesListCall {
	c := &ProjectsLocationsTlsRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of TlsRoutes
// to return per call.
func (c *ProjectsLocationsTlsRoutesListCall) PageSize(pageSize int64) *ProjectsLocationsTlsRoutesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListTlsRoutesResponse` Indicates that this is a continuation of a
// prior `ListTlsRoutes` call, and that the system should return the next page
// of data.
func (c *ProjectsLocationsTlsRoutesListCall) PageToken(pageToken string) *ProjectsLocationsTlsRoutesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess": If
// true, allow partial responses for multi-regional Aggregated List requests.
// Otherwise if one of the locations is down or unreachable, the Aggregated
// List request will fail.
func (c *ProjectsLocationsTlsRoutesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsTlsRoutesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsTlsRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsTlsRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsRoutesListCall) Context(ctx context.Context) *ProjectsLocationsTlsRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/tlsRoutes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tlsRoutes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTlsRoutesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsTlsRoutesListCall) Do(opts ...googleapi.CallOption) (*ListTlsRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTlsRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsTlsRoutesListCall) Pages(ctx context.Context, f func(*ListTlsRoutesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsTlsRoutesPatchCall struct {
	s          *Service
	name       string
	tlsroute   *TlsRoute
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of a single TlsRoute.
//
//   - name: Identifier. Name of the TlsRoute resource. It matches pattern
//     `projects/*/locations/global/tlsRoutes/tls_route_name>`.
func (r *ProjectsLocationsTlsRoutesService) Patch(name string, tlsroute *TlsRoute) *ProjectsLocationsTlsRoutesPatchCall {
	c := &ProjectsLocationsTlsRoutesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.tlsroute = tlsroute
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask is used to
// specify the fields to be overwritten in the TlsRoute resource by the update.
// The fields specified in the update_mask are relative to the resource, not
// the full request. A field will be overwritten if it is in the mask. If the
// user does not provide a mask then all fields will be overwritten.
func (c *ProjectsLocationsTlsRoutesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsTlsRoutesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTlsRoutesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsTlsRoutesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTlsRoutesPatchCall) Context(ctx context.Context) *ProjectsLocationsTlsRoutesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTlsRoutesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTlsRoutesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tlsroute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.tlsRoutes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsTlsRoutesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.tlsRoutes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsCreateCall struct {
	s          *Service
	parent     string
	wasmplugin *WasmPlugin
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new `WasmPlugin` resource in a given project and location.
//
//   - parent: The parent resource of the `WasmPlugin` resource. Must be in the
//     format `projects/{project}/locations/global`.
func (r *ProjectsLocationsWasmPluginsService) Create(parent string, wasmplugin *WasmPlugin) *ProjectsLocationsWasmPluginsCreateCall {
	c := &ProjectsLocationsWasmPluginsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.wasmplugin = wasmplugin
	return c
}

// WasmPluginId sets the optional parameter "wasmPluginId": Required.
// User-provided ID of the `WasmPlugin` resource to be created.
func (c *ProjectsLocationsWasmPluginsCreateCall) WasmPluginId(wasmPluginId string) *ProjectsLocationsWasmPluginsCreateCall {
	c.urlParams_.Set("wasmPluginId", wasmPluginId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsCreateCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.wasmplugin)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/wasmPlugins")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `WasmPlugin` resource.
//
//   - name: A name of the `WasmPlugin` resource to delete. Must be in the format
//     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
func (r *ProjectsLocationsWasmPluginsService) Delete(name string) *ProjectsLocationsWasmPluginsDeleteCall {
	c := &ProjectsLocationsWasmPluginsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsDeleteCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified `WasmPlugin` resource.
//
//   - name: A name of the `WasmPlugin` resource to get. Must be in the format
//     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
func (r *ProjectsLocationsWasmPluginsService) Get(name string) *ProjectsLocationsWasmPluginsGetCall {
	c := &ProjectsLocationsWasmPluginsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Determines how much data must be
// returned in the response. See AIP-157 (https://google.aip.dev/157).
//
// Possible values:
//
//	"WASM_PLUGIN_VIEW_UNSPECIFIED" - Unspecified value. Do not use.
//	"WASM_PLUGIN_VIEW_BASIC" - If specified in the `GET` request for a
//
// `WasmPlugin` resource, the server's response includes just the `WasmPlugin`
// resource.
//
//	"WASM_PLUGIN_VIEW_FULL" - If specified in the `GET` request for a
//
// `WasmPlugin` resource, the server's response includes the `WasmPlugin`
// resource with all its versions.
func (c *ProjectsLocationsWasmPluginsGetCall) View(view string) *ProjectsLocationsWasmPluginsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWasmPluginsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWasmPluginsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsGetCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *WasmPlugin.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsGetCall) Do(opts ...googleapi.CallOption) (*WasmPlugin, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WasmPlugin{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `WasmPlugin` resources in a given project and location.
//
//   - parent: The project and location from which the `WasmPlugin` resources are
//     listed, specified in the following format:
//     `projects/{project}/locations/global`.
func (r *ProjectsLocationsWasmPluginsService) List(parent string) *ProjectsLocationsWasmPluginsListCall {
	c := &ProjectsLocationsWasmPluginsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// `WasmPlugin` resources to return per call. If not specified, at most 50
// `WasmPlugin` resources are returned. The maximum value is 1000; values above
// 1000 are coerced to 1000.
func (c *ProjectsLocationsWasmPluginsListCall) PageSize(pageSize int64) *ProjectsLocationsWasmPluginsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListWasmPluginsResponse` call. Indicates that this is a continuation
// of a prior `ListWasmPlugins` call, and that the next page of data is to be
// returned.
func (c *ProjectsLocationsWasmPluginsListCall) PageToken(pageToken string) *ProjectsLocationsWasmPluginsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWasmPluginsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWasmPluginsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsListCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/wasmPlugins")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWasmPluginsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsListCall) Do(opts ...googleapi.CallOption) (*ListWasmPluginsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWasmPluginsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWasmPluginsListCall) Pages(ctx context.Context, f func(*ListWasmPluginsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsWasmPluginsPatchCall struct {
	s          *Service
	name       string
	wasmplugin *WasmPlugin
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the parameters of the specified `WasmPlugin` resource.
//
//   - name: Identifier. Name of the `WasmPlugin` resource in the following
//     format:
//     `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}`.
func (r *ProjectsLocationsWasmPluginsService) Patch(name string, wasmplugin *WasmPlugin) *ProjectsLocationsWasmPluginsPatchCall {
	c := &ProjectsLocationsWasmPluginsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.wasmplugin = wasmplugin
	return c
}

// UpdateMask sets the optional parameter "updateMask": Used to specify the
// fields to be overwritten in the `WasmPlugin` resource by the update. The
// fields specified in the `update_mask` field are relative to the resource,
// not the full request. An omitted `update_mask` field is treated as an
// implied `update_mask` field equivalent to all fields that are populated
// (that have a non-empty value). The `update_mask` field supports a special
// value `*`, which means that each field in the given `WasmPlugin` resource
// (including the empty ones) replaces the current value.
func (c *ProjectsLocationsWasmPluginsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsWasmPluginsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsPatchCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.wasmplugin)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsVersionsCreateCall struct {
	s                 *Service
	parent            string
	wasmpluginversion *WasmPluginVersion
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a new `WasmPluginVersion` resource in a given project and
// location.
//
//   - parent: The parent resource of the `WasmPluginVersion` resource. Must be
//     in the format
//     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
func (r *ProjectsLocationsWasmPluginsVersionsService) Create(parent string, wasmpluginversion *WasmPluginVersion) *ProjectsLocationsWasmPluginsVersionsCreateCall {
	c := &ProjectsLocationsWasmPluginsVersionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.wasmpluginversion = wasmpluginversion
	return c
}

// WasmPluginVersionId sets the optional parameter "wasmPluginVersionId":
// Required. User-provided ID of the `WasmPluginVersion` resource to be
// created.
func (c *ProjectsLocationsWasmPluginsVersionsCreateCall) WasmPluginVersionId(wasmPluginVersionId string) *ProjectsLocationsWasmPluginsVersionsCreateCall {
	c.urlParams_.Set("wasmPluginVersionId", wasmPluginVersionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsVersionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsVersionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsVersionsCreateCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsVersionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsVersionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsVersionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.wasmpluginversion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/versions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.versions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsVersionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsVersionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified `WasmPluginVersion` resource.
//
//   - name: A name of the `WasmPluginVersion` resource to delete. Must be in the
//     format
//     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}/versions/{wa
//     sm_plugin_version}`.
func (r *ProjectsLocationsWasmPluginsVersionsService) Delete(name string) *ProjectsLocationsWasmPluginsVersionsDeleteCall {
	c := &ProjectsLocationsWasmPluginsVersionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsVersionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsVersionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsVersionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsVersionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsVersionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsVersionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.versions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsVersionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsVersionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of the specified `WasmPluginVersion` resource.
//
//   - name: A name of the `WasmPluginVersion` resource to get. Must be in the
//     format
//     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}/versions/{wa
//     sm_plugin_version}`.
func (r *ProjectsLocationsWasmPluginsVersionsService) Get(name string) *ProjectsLocationsWasmPluginsVersionsGetCall {
	c := &ProjectsLocationsWasmPluginsVersionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsVersionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsVersionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWasmPluginsVersionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWasmPluginsVersionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsVersionsGetCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsVersionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsVersionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsVersionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.versions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *WasmPluginVersion.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsWasmPluginsVersionsGetCall) Do(opts ...googleapi.CallOption) (*WasmPluginVersion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WasmPluginVersion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWasmPluginsVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists `WasmPluginVersion` resources in a given project and location.
//
//   - parent: The `WasmPlugin` resource whose `WasmPluginVersion`s are listed,
//     specified in the following format:
//     `projects/{project}/locations/global/wasmPlugins/{wasm_plugin}`.
func (r *ProjectsLocationsWasmPluginsVersionsService) List(parent string) *ProjectsLocationsWasmPluginsVersionsListCall {
	c := &ProjectsLocationsWasmPluginsVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// `WasmPluginVersion` resources to return per call. If not specified, at most
// 50 `WasmPluginVersion` resources are returned. The maximum value is 1000;
// values above 1000 are coerced to 1000.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsWasmPluginsVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListWasmPluginVersionsResponse` call. Indicates that this is a
// continuation of a prior `ListWasmPluginVersions` call, and that the next
// page of data is to be returned.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) PageToken(pageToken string) *ProjectsLocationsWasmPluginsVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWasmPluginsVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWasmPluginsVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) Context(ctx context.Context) *ProjectsLocationsWasmPluginsVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWasmPluginsVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/versions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkservices.projects.locations.wasmPlugins.versions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWasmPluginVersionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) Do(opts ...googleapi.CallOption) (*ListWasmPluginVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWasmPluginVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkservices.projects.locations.wasmPlugins.versions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWasmPluginsVersionsListCall) Pages(ctx context.Context, f func(*ListWasmPluginVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
