---
layout: "docs"
page_title: "Command: version"
sidebar_current: "docs-commands-version"
description: |-
  The `terraform version` command displays the version of Terraform and all installed plugins.
---

# Command: version

The `terraform version` displays the current version of Terraform and all
installed plugins.

## Usage

Usage: `terraform version [options]`

With no additional arguments, `version` will display the version of Terraform,
the platform it's installed on, installed providers, and the results of upgrade
and security checks [unless disabled](/docs/cli/commands/index.html#upgrade-and-security-bulletin-checks).

This command has one optional flag:

* `-json` - If specified, the version information is formatted as a JSON object, 
    and no upgrade or security information is included.

-> **Note:** Platform information was added to the `version` command in Terraform 0.15. 

## Example

Basic usage, with upgrade and security information shown if relevant:

```shellsession
$ terraform version
Terraform v0.15.0
on darwin_amd64
+ provider registry.terraform.io/hashicorp/null v3.0.0

Your version of Terraform is out of date! The latest version
is X.Y.Z. You can update by downloading from https://www.terraform.io/downloads.html
```

As JSON:

```shellsession
$ terraform version -json
{
  "terraform_version": "0.15.0",
  "platform": "darwin_amd64",
  "provider_selections": {
    "registry.terraform.io/hashicorp/null": "3.0.0"
  },
  "terraform_outdated": true
}
```