/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;

@BugPattern(summary="Use grouping parenthesis to make the operator precedence explicit", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class OperatorPrecedence
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final ImmutableSet<Tree.Kind> CONDITIONAL = Sets.immutableEnumSet((Enum)Tree.Kind.AND, (Enum[])new Tree.Kind[]{Tree.Kind.OR, Tree.Kind.XOR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    private static final ImmutableSet<Tree.Kind> SHIFT = Sets.immutableEnumSet((Enum)Tree.Kind.LEFT_SHIFT, (Enum[])new Tree.Kind[]{Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT});
    private static final ImmutableSet<Tree.Kind> ARITHMETIC = Sets.immutableEnumSet((Enum)Tree.Kind.PLUS, (Enum[])new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.MINUS});
    private static final ImmutableSet<Tree.Kind> SAFE_ASSOCIATIVE_OPERATORS = Sets.immutableEnumSet((Enum)Tree.Kind.CONDITIONAL_AND, (Enum[])new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR, Tree.Kind.PLUS});

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof BinaryTree)) {
            return Description.NO_MATCH;
        }
        if (TreeInfo.opPrec(((JCTree.JCBinary)tree).getTag()) == TreeInfo.opPrec(((JCTree.JCBinary)parent).getTag())) {
            return Description.NO_MATCH;
        }
        if (!OperatorPrecedence.isConfusing(tree.getKind(), parent.getKind())) {
            return Description.NO_MATCH;
        }
        return this.createAppropriateFix(tree, state);
    }

    private static boolean isConfusing(Tree.Kind thisKind, Tree.Kind parentKind) {
        if (CONDITIONAL.contains((Object)thisKind) && CONDITIONAL.contains((Object)parentKind)) {
            return true;
        }
        return SHIFT.contains((Object)thisKind) && ARITHMETIC.contains((Object)parentKind) || SHIFT.contains((Object)parentKind) && ARITHMETIC.contains((Object)thisKind);
    }

    private Description createAppropriateFix(BinaryTree tree, VisitorState state) {
        return SAFE_ASSOCIATIVE_OPERATORS.contains((Object)tree.getKind()) && tree.getLeftOperand() instanceof ParenthesizedTree != tree.getRightOperand() instanceof ParenthesizedTree && OperatorPrecedence.parenthesizedChildHasKind(tree, tree.getKind()) ? this.leftOrRightFix(tree, state) : this.basicFix(tree);
    }

    private Description leftOrRightFix(BinaryTree tree, VisitorState state) {
        int endPos;
        int startPos;
        String prefix = "(";
        String postfix = ")";
        if (tree.getRightOperand() instanceof ParenthesizedTree) {
            startPos = ASTHelpers.getStartPosition((Tree)tree.getRightOperand());
            endPos = ASTHelpers.getStartPosition((Tree)tree.getRightOperand()) + 1;
            postfix = "";
        } else {
            startPos = state.getEndPosition((Tree)tree.getLeftOperand()) - 1;
            endPos = state.getEndPosition((Tree)tree.getLeftOperand());
            prefix = "";
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)tree, prefix).replace(startPos, endPos, "").postfixWith((Tree)tree, postfix).build());
    }

    private Description basicFix(BinaryTree tree) {
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)tree, "(").postfixWith((Tree)tree, ")").build());
    }

    private static boolean parenthesizedChildHasKind(BinaryTree tree, Tree.Kind kind) {
        Tree.Kind childKind = ASTHelpers.stripParentheses((ExpressionTree)(tree.getLeftOperand() instanceof ParenthesizedTree ? tree.getLeftOperand() : tree.getRightOperand())).getKind();
        return childKind == kind;
    }
}

