/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

class BodyCodegen {
    private final int JAVASCRIPT_EXCEPTION = 0;
    private final int EVALUATOR_EXCEPTION = 1;
    private final int ECMAERROR_EXCEPTION = 2;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptOrFnNode scriptOrFn;
    private OptFunctionNode fnCurrent;
    private boolean isTopLevel;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private OptLocalVariable[] debugVars;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int epilogueLabel;
    private short variableObjectLocal;
    private short popvLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private short scriptRegexpLocal;

    BodyCodegen() {
    }

    void generateBodyCode() {
        this.initBodyGeneration();
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.generatePrologue();
        Node treeTop = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateCodeFromNode(treeTop, null);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1), this.debugVars);
    }

    private void initBodyGeneration() {
        this.fnCurrent = this.scriptOrFn.getType() == 87 ? OptFunctionNode.get(this.scriptOrFn) : null;
        this.isTopLevel = this.scriptOrFn == this.codegen.scriptOrFnNodes[0];
        this.inDirectCallFunction = this.fnCurrent == null ? false : this.fnCurrent.isTargetOfDirectCall();
        this.hasVarsInRegs = this.fnCurrent != null && !this.fnCurrent.fnode.requiresActivation();
        this.locals = new boolean[256];
        this.funObjLocal = 0;
        this.contextLocal = 1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.scriptRegexpLocal = (short)-1;
        this.epilogueLabel = -1;
    }

    private void generatePrologue() {
        String debugVariableName;
        int i;
        OptLocalVariable lVar;
        int directParameterCount = -1;
        if (this.inDirectCallFunction) {
            directParameterCount = this.scriptOrFn.getParamCount();
            short jReg = 4;
            int i2 = 0;
            while (i2 != directParameterCount) {
                OptLocalVariable lVar2 = this.fnCurrent.getVar(i2);
                lVar2.assignJRegister(jReg);
                jReg = (short)(jReg + 3);
                ++i2;
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                int i3 = 0;
                while (i3 != directParameterCount) {
                    lVar = this.fnCurrent.getVar(i3);
                    this.cfw.addALoad(lVar.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isObjectLabel = this.cfw.acquireLabel();
                    this.cfw.add((byte)-90, isObjectLabel);
                    this.cfw.addDLoad(lVar.getJRegister() + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(lVar.getJRegister());
                    this.cfw.markLabel(isObjectLabel);
                    ++i3;
                }
            }
        }
        if (this.fnCurrent != null && directParameterCount == -1 && (!this.compilerEnv.isUseDynamicScope() || this.fnCurrent.fnode.getIgnoreDynamicScope())) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        if (directParameterCount > 0) {
            i = 0;
            while (i < 3 * directParameterCount) {
                this.reserveWordLocal(i + 4);
                ++i;
            }
        }
        this.argsLocal = this.reserveWordLocal(directParameterCount <= 0 ? 4 : 3 * directParameterCount + 4);
        if (this.fnCurrent == null && this.scriptOrFn.getRegexpCount() != 0) {
            this.scriptRegexpLocal = this.getNewWordLocal();
            this.codegen.pushRegExpArray(this.cfw, this.scriptOrFn, this.contextLocal, this.variableObjectLocal);
            this.cfw.addAStore(this.scriptRegexpLocal);
        }
        if (this.fnCurrent != null && this.fnCurrent.fnode.getCheckThis()) {
            this.cfw.addALoad(this.thisObjLocal);
            this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.thisObjLocal);
        }
        if (this.hasVarsInRegs) {
            int parmCount = this.scriptOrFn.getParamCount();
            if (parmCount > 0 && directParameterCount < 0) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add((byte)-66);
                this.cfw.addPush(parmCount);
                int label = this.cfw.acquireLabel();
                this.cfw.add((byte)-94, label);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(parmCount);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(label);
            }
            int firstUndefVar = -1;
            int i4 = 0;
            while (i4 < this.fnCurrent.getVarCount()) {
                lVar = this.fnCurrent.getVar(i4);
                if (lVar.isNumber()) {
                    lVar.assignJRegister(this.getNewWordPairLocal());
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(lVar.getJRegister());
                } else if (lVar.isParameter()) {
                    if (directParameterCount < 0) {
                        lVar.assignJRegister(this.getNewWordLocal());
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(i4);
                        this.cfw.add((byte)50);
                        this.cfw.addAStore(lVar.getJRegister());
                    }
                } else {
                    lVar.assignJRegister(this.getNewWordLocal());
                    if (firstUndefVar == -1) {
                        Codegen.pushUndefined(this.cfw);
                        firstUndefVar = lVar.getJRegister();
                    } else {
                        this.cfw.addALoad(firstUndefVar);
                    }
                    this.cfw.addAStore(lVar.getJRegister());
                }
                lVar.setStartPC(this.cfw.getCurrentCodeOffset());
                ++i4;
            }
            this.debugVars = this.fnCurrent.getVarsArray();
            return;
        }
        if (directParameterCount > 0) {
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addPush(directParameterCount);
            this.addOptRuntimeInvoke("padStart", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
            this.cfw.addAStore(this.argsLocal);
            i = 0;
            while (i < directParameterCount) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(i);
                this.cfw.addALoad(3 * i + 4);
                this.cfw.add((byte)83);
                ++i;
            }
        }
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.addScriptRuntimeInvoke("initVarObj", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            debugVariableName = "activation";
        } else {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Z)V");
            debugVariableName = "global";
        }
        int functionCount = this.scriptOrFn.getFunctionCount();
        int i5 = 0;
        while (i5 != functionCount) {
            OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, i5);
            if (ofn.fnode.getFunctionType() == 1) {
                this.visitFunction(ofn, 1);
            }
            ++i5;
        }
        if (this.compilerEnv.isGenerateDebugInfo()) {
            OptLocalVariable lv = new OptLocalVariable(debugVariableName, false);
            lv.assignJRegister(this.variableObjectLocal);
            lv.setStartPC(this.cfw.getCurrentCodeOffset());
            this.debugVars = new OptLocalVariable[1];
            this.debugVars[0] = lv;
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            int linenum = this.scriptOrFn.getEndLineno();
            if (linenum != -1) {
                this.cfw.addLineNumberEntry((short)linenum);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add((byte)-67, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.epilogueLabel != -1) {
            this.cfw.markLabel(this.epilogueLabel);
        }
        if (this.fnCurrent == null || !this.hasVarsInRegs) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("popActivation", "(Lorg/mozilla/javascript/Context;)V");
            if (this.fnCurrent == null) {
                this.cfw.addALoad(this.popvLocal);
            }
        }
        this.cfw.add((byte)-80);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateCodeFromNode(Node node, Node parent) {
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 101: 
            case 110: 
            case 112: {
                this.visitStatement(node);
                while (true) {
                    if (child == null) {
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    child = child.getNext();
                }
            }
            case 93: 
            case 94: 
            case 106: 
            case 107: 
            case 118: {
                this.visitStatement(node);
                while (true) {
                    if (child == null) {
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    child = child.getNext();
                }
            }
            case 124: {
                this.visitStatement(node);
                short local = this.getNewWordLocal();
                node.putIntProp(3, local);
                while (true) {
                    if (child == null) {
                        this.releaseWordLocal(local);
                        node.removeProp(3);
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    child = child.getNext();
                }
            }
            case 120: {
                return;
            }
            case 87: {
                if (this.fnCurrent == null) {
                    if (parent.getType() == 118) return;
                }
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t == 1) return;
                this.visitFunction(ofn, t);
                return;
            }
            case 39: {
                this.visitName(node);
                return;
            }
            case 31: 
            case 38: {
                this.visitCall(node, type, child);
                return;
            }
            case 40: 
            case 41: {
                this.visitLiteral(node);
                return;
            }
            case 45: {
                this.cfw.addALoad(this.thisObjLocal);
                return;
            }
            case 66: {
                this.cfw.add((byte)42);
                return;
            }
            case 44: {
                this.cfw.add((byte)1);
                return;
            }
            case 47: {
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                return;
            }
            case 46: {
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                return;
            }
            case 61: {
                Codegen.pushUndefined(this.cfw);
                return;
            }
            case 50: {
                this.visitRegexp(node);
                return;
            }
            case 69: {
                this.visitTryCatchFinally((Node.Jump)node, child);
                return;
            }
            case 53: {
                this.visitThrow(node, child);
                return;
            }
            case 67: {
                if (this.fnCurrent == null) {
                    Codegen.badTree();
                }
            }
            case 5: {
                this.visitStatement(node);
                if (child != null) {
                    do {
                        this.generateCodeFromNode(child, node);
                    } while ((child = child.getNext()) != null);
                } else if (this.fnCurrent != null && type == 5) {
                    Codegen.pushUndefined(this.cfw);
                } else {
                    if (this.popvLocal < 0) {
                        Codegen.badTree();
                    }
                    this.cfw.addALoad(this.popvLocal);
                }
                if (this.epilogueLabel == -1) {
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add((byte)-89, this.epilogueLabel);
                return;
            }
            case 92: {
                this.visitSwitch((Node.Jump)node, child);
                return;
            }
            case 77: {
                Node next = child.getNext();
                while (true) {
                    if (next == null) {
                        this.generateCodeFromNode(child, node);
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    this.cfw.add((byte)87);
                    child = next;
                    next = next.getNext();
                }
            }
            case 123: {
                this.generateCodeFromNode(child, node);
                while (true) {
                    if (null == (child = child.getNext())) {
                        return;
                    }
                    this.cfw.add((byte)89);
                    this.generateCodeFromNode(child, node);
                    this.cfw.add((byte)87);
                }
            }
            case 62: {
                this.cfw.addPush(node.getString());
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("newCatchScope", "(Ljava/lang/String;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 3: {
                this.visitEnterWith(node, child);
                return;
            }
            case 4: {
                this.visitLeaveWith(node, child);
                return;
            }
            case 63: {
                this.generateCodeFromNode(child, node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enumInit", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                int local = this.getLocalBlockRegister(node);
                this.cfw.addAStore(local);
                return;
            }
            case 64: 
            case 65: {
                int local = this.getLocalBlockRegister(node);
                this.cfw.addALoad(local);
                if (type == 64) {
                    this.addScriptRuntimeInvoke("enumNext", "(Ljava/lang/Object;)Ljava/lang/Boolean;");
                    return;
                }
                this.addScriptRuntimeInvoke("enumId", "(Ljava/lang/Object;)Ljava/lang/String;");
                return;
            }
            case 51: {
                this.visitStatement(node);
                if (child.getType() == 60) {
                    this.visitSetVar(child, child.getFirstChild(), false);
                    return;
                }
                while (true) {
                    if (child == null) {
                        if (node.getIntProp(15, -1) == -1) break;
                        this.cfw.add((byte)88);
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    child = child.getNext();
                }
                this.cfw.add((byte)87);
                return;
            }
            case 2: {
                this.visitStatement(node);
                this.generateCodeFromNode(child, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                return;
            }
            case 111: {
                this.visitTarget((Node.Target)node);
                return;
            }
            case 6: 
            case 7: 
            case 8: 
            case 115: {
                this.visitGOTO((Node.Jump)node, type, child);
                return;
            }
            case 103: {
                this.visitFinally(node, child);
                return;
            }
            case 27: {
                int trueTarget = this.cfw.acquireLabel();
                int falseTarget = this.cfw.acquireLabel();
                int beyond = this.cfw.acquireLabel();
                this.generateIfJump(child, node, trueTarget, falseTarget);
                this.cfw.markLabel(trueTarget);
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.cfw.add((byte)-89, beyond);
                this.cfw.markLabel(falseTarget);
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.cfw.markLabel(beyond);
                this.cfw.adjustStackTop(-1);
                return;
            }
            case 28: {
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
                this.cfw.addPush(-1);
                this.cfw.add((byte)-126);
                this.cfw.add((byte)-121);
                this.addDoubleWrap();
                return;
            }
            case 104: {
                this.generateCodeFromNode(child, node);
                this.cfw.add((byte)87);
                Codegen.pushUndefined(this.cfw);
                return;
            }
            case 33: {
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                return;
            }
            case 119: {
                this.visitTypeofname(node);
                return;
            }
            case 84: {
                this.visitIncDec(node, true);
                return;
            }
            case 85: {
                this.visitIncDec(node, false);
                return;
            }
            case 82: 
            case 83: {
                this.generateCodeFromNode(child, node);
                this.cfw.add((byte)89);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int falseTarget = this.cfw.acquireLabel();
                if (type == 83) {
                    this.cfw.add((byte)-103, falseTarget);
                } else {
                    this.cfw.add((byte)-102, falseTarget);
                }
                this.cfw.add((byte)87);
                this.generateCodeFromNode(child.getNext(), node);
                this.cfw.markLabel(falseTarget);
                return;
            }
            case 80: {
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int elseTarget = this.cfw.acquireLabel();
                this.cfw.add((byte)-103, elseTarget);
                short stack = this.cfw.getStackTop();
                this.generateCodeFromNode(ifThen, node);
                int afterHook = this.cfw.acquireLabel();
                this.cfw.add((byte)-89, afterHook);
                this.cfw.markLabel(elseTarget, stack);
                this.generateCodeFromNode(ifElse, node);
                this.cfw.markLabel(afterHook);
                return;
            }
            case 22: {
                this.generateCodeFromNode(child, node);
                this.generateCodeFromNode(child.getNext(), node);
                switch (node.getIntProp(15, -1)) {
                    case 0: {
                        this.cfw.add((byte)99);
                        return;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)Ljava/lang/Object;");
                        return;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)Ljava/lang/Object;");
                        return;
                    }
                }
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                return;
            }
            case 24: {
                this.visitArithmetic(node, (byte)107, child, parent);
                return;
            }
            case 23: {
                this.visitArithmetic(node, (byte)103, child, parent);
                return;
            }
            case 25: 
            case 26: {
                this.visitArithmetic(node, type == 25 ? (byte)111 : 115, child, parent);
                return;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                this.visitBitOp(node, type, child);
                return;
            }
            case 29: 
            case 30: {
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
                if (type == 30) {
                    this.cfw.add((byte)119);
                }
                this.addDoubleWrap();
                return;
            }
            case 126: {
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
                return;
            }
            case 125: {
                int prop = -1;
                if (child.getType() == 40) {
                    prop = child.getIntProp(15, -1);
                }
                if (prop != -1) {
                    child.removeProp(15);
                    this.generateCodeFromNode(child, node);
                    child.putIntProp(15, prop);
                    return;
                }
                this.generateCodeFromNode(child, node);
                this.addDoubleWrap();
                return;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 54: 
            case 55: {
                this.visitRelOp(node, child);
                return;
            }
            case 13: 
            case 14: 
            case 48: 
            case 49: {
                this.visitEqOp(node, child);
                return;
            }
            case 34: {
                this.visitGetProp(node, child);
                return;
            }
            case 36: {
                while (true) {
                    if (child == null) {
                        this.cfw.addALoad(this.variableObjectLocal);
                        if (node.getIntProp(15, -1) == -1) break;
                        this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    child = child.getNext();
                }
                this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                return;
            }
            case 59: {
                OptLocalVariable lVar = (OptLocalVariable)node.getProp(13);
                this.visitGetVar(lVar, node.getIntProp(15, -1) != -1, node.getString());
                return;
            }
            case 60: {
                this.visitSetVar(node, child, true);
                return;
            }
            case 9: {
                this.visitSetName(node, child);
                return;
            }
            case 35: 
            case 121: {
                this.visitSetProp(type, node, child);
                return;
            }
            case 37: 
            case 122: {
                boolean indexIsNumber;
                this.generateCodeFromNode(child, node);
                child = child.getNext();
                if (type == 122) {
                    this.cfw.add((byte)89);
                }
                this.generateCodeFromNode(child, node);
                child = child.getNext();
                boolean bl = indexIsNumber = node.getIntProp(15, -1) != -1;
                if (type == 122) {
                    if (indexIsNumber) {
                        this.cfw.add((byte)93);
                        this.cfw.addALoad(this.variableObjectLocal);
                        this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    } else {
                        this.cfw.add((byte)90);
                        this.cfw.addALoad(this.variableObjectLocal);
                        this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    }
                }
                this.generateCodeFromNode(child, node);
                this.cfw.addALoad(this.variableObjectLocal);
                if (indexIsNumber) {
                    this.addOptRuntimeInvoke("setElem", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    return;
                }
                this.addScriptRuntimeInvoke("setElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                return;
            }
            case 32: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                while (true) {
                    if (child == null) {
                        this.addScriptRuntimeInvoke("delete", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(child, node);
                    child = child.getNext();
                }
            }
            case 52: 
            case 58: {
                this.visitBind(node, type, child);
                return;
            }
            case 68: {
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 114: {
                this.generateCodeFromNode(child, node);
                this.addScriptRuntimeInvoke("getParent", "(Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 116: {
                this.visitNewTemp(node, child);
                return;
            }
            case 117: {
                this.visitUseTemp(node, child);
                return;
            }
            case 57: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                return;
            }
        }
        throw new RuntimeException("Unexpected node type " + type);
    }

    private void generateIfJump(Node node, Node parent, int trueLabel, int falseLabel) {
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 27: {
                this.generateIfJump(child, node, falseLabel, trueLabel);
                break;
            }
            case 82: 
            case 83: {
                int interLabel = this.cfw.acquireLabel();
                if (type == 83) {
                    this.generateIfJump(child, node, interLabel, falseLabel);
                } else {
                    this.generateIfJump(child, node, trueLabel, interLabel);
                }
                this.cfw.markLabel(interLabel);
                child = child.getNext();
                this.generateIfJump(child, node, trueLabel, falseLabel);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 54: 
            case 55: {
                this.visitIfJumpRelOp(node, child, trueLabel, falseLabel);
                break;
            }
            case 13: 
            case 14: 
            case 48: 
            case 49: {
                this.visitIfJumpEqOp(node, child, trueLabel, falseLabel);
                break;
            }
            default: {
                this.generateCodeFromNode(node, parent);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                this.cfw.add((byte)-102, trueLabel);
                this.cfw.add((byte)-89, falseLabel);
            }
        }
    }

    private void visitFunction(OptFunctionNode ofn, int functionType) {
        int fnIndex = this.codegen.getIndex(ofn.fnode);
        this.cfw.add((byte)-69, this.codegen.mainClassName);
        this.cfw.add((byte)89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(fnIndex);
        this.cfw.addInvoke((byte)-73, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        this.cfw.add((byte)89);
        if (this.isTopLevel) {
            this.cfw.add((byte)42);
        } else {
            this.cfw.add((byte)42);
            this.cfw.add((byte)-76, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        }
        this.cfw.add((byte)-75, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        int directTargetIndex = ofn.getDirectTargetIndex();
        if (directTargetIndex >= 0) {
            this.cfw.add((byte)89);
            if (this.isTopLevel) {
                this.cfw.add((byte)42);
            } else {
                this.cfw.add((byte)42);
                this.cfw.add((byte)-76, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
            }
            this.cfw.add((byte)95);
            this.cfw.add((byte)-75, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(directTargetIndex), this.codegen.mainClassSignature);
        }
        if (functionType != 1) {
            this.cfw.add((byte)89);
        }
        this.cfw.addPush(functionType);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V");
    }

    private void visitTarget(Node.Target node) {
        int label = node.labelId;
        if (label == -1) {
            node.labelId = label = this.cfw.acquireLabel();
        }
        this.cfw.markLabel(label);
    }

    /*
     * Unable to fully structure code
     */
    private void visitGOTO(Node.Jump node, int type, Node child) {
        block10: {
            target = node.target;
            targetLabel = target.labelId;
            if (targetLabel == -1) {
                target.labelId = targetLabel = this.cfw.acquireLabel();
            }
            fallThruLabel = this.cfw.acquireLabel();
            if (type != 7 && type != 8) ** GOTO lbl21
            if (child == null) {
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                if (type == 7) {
                    this.cfw.add((byte)-102, targetLabel);
                } else {
                    this.cfw.add((byte)-103, targetLabel);
                }
            } else if (type == 7) {
                this.generateIfJump(child, node, targetLabel, fallThruLabel);
            } else {
                this.generateIfJump(child, node, fallThruLabel, targetLabel);
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                this.generateCodeFromNode(child, node);
                child = child.getNext();
lbl21:
                // 2 sources

                ** while (child != null)
            }
lbl22:
            // 1 sources

            if (type == 115) {
                this.cfw.add((byte)-88, targetLabel);
            } else {
                this.cfw.add((byte)-89, targetLabel);
            }
        }
        this.cfw.markLabel(fallThruLabel);
    }

    private void visitFinally(Node node, Node child) {
        short finallyRegister = this.getNewWordLocal();
        this.cfw.addAStore(finallyRegister);
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        this.cfw.add((byte)-87, finallyRegister);
        this.releaseWordLocal(finallyRegister);
    }

    private void visitEnterWith(Node node, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private void visitLeaveWith(Node node, Node child) {
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private void resetTargets(Node node) {
        if (node.getType() == 111) {
            ((Node.Target)node).labelId = -1;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.resetTargets(child);
            child = child.getNext();
        }
    }

    private void visitCall(Node node, int type, Node child) {
        Node chelsea = child;
        OptFunctionNode target = (OptFunctionNode)node.getProp(16);
        if (target != null) {
            this.generateCodeFromNode(child, node);
            int regularCall = this.cfw.acquireLabel();
            int directTargetIndex = target.getDirectTargetIndex();
            if (this.isTopLevel) {
                this.cfw.add((byte)42);
            } else {
                this.cfw.add((byte)42);
                this.cfw.add((byte)-76, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
            }
            this.cfw.add((byte)-76, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(directTargetIndex), this.codegen.mainClassSignature);
            short stackHeight = this.cfw.getStackTop();
            this.cfw.add((byte)92);
            this.cfw.add((byte)-90, regularCall);
            this.cfw.add((byte)95);
            this.cfw.add((byte)87);
            if (!this.compilerEnv.isUseDynamicScope()) {
                this.cfw.add((byte)89);
                this.cfw.addInvoke((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            } else {
                this.cfw.addALoad(this.variableObjectLocal);
            }
            this.cfw.addALoad(this.contextLocal);
            this.cfw.add((byte)95);
            if (type == 31) {
                this.cfw.add((byte)1);
            } else {
                child = child.getNext();
                this.generateCodeFromNode(child, node);
            }
            child = child.getNext();
            while (child != null) {
                OptLocalVariable lVar;
                boolean handled = false;
                if (child.getType() == 59 && this.inDirectCallFunction && (lVar = (OptLocalVariable)child.getProp(13)) != null && lVar.isParameter()) {
                    handled = true;
                    this.cfw.addALoad(lVar.getJRegister());
                    this.cfw.addDLoad(lVar.getJRegister() + 1);
                }
                if (!handled) {
                    int childNumberFlag = child.getIntProp(15, -1);
                    if (childNumberFlag == 0) {
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.generateCodeFromNode(child, node);
                    } else {
                        this.generateCodeFromNode(child, node);
                        this.cfw.addPush(0.0);
                    }
                }
                this.resetTargets(child);
                child = child.getNext();
            }
            this.cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            this.cfw.addInvoke((byte)-72, this.codegen.mainClassName, type == 31 ? this.codegen.getDirectCtorName(target.fnode) : this.codegen.getBodyMethodName(target.fnode), this.codegen.getBodyMethodSignature(target.fnode));
            int beyond = this.cfw.acquireLabel();
            this.cfw.add((byte)-89, beyond);
            this.cfw.markLabel(regularCall, stackHeight);
            this.cfw.add((byte)87);
            this.visitRegularCall(node, type, chelsea, true);
            this.cfw.markLabel(beyond);
        } else {
            this.visitRegularCall(node, type, chelsea, false);
        }
    }

    private String getSimpleCallName(Node callNode) {
        Node callBaseChild;
        Node callBase = callNode.getFirstChild();
        if (callBase.getType() == 34 && (callBaseChild = callBase.getFirstChild()).getType() == 116) {
            Node callBaseID = callBaseChild.getNext();
            Node tempChild = callBaseChild.getFirstChild();
            if (tempChild.getType() == 58) {
                Node useChild;
                Node thisChild;
                String functionName = tempChild.getString();
                if (callBaseID != null && callBaseID.getType() == 41 && functionName.equals(callBaseID.getString()) && (thisChild = callBase.getNext()).getType() == 68 && (useChild = thisChild.getFirstChild()).getType() == 117 && useChild.getProp(2) == callBaseChild) {
                    return functionName;
                }
            }
        }
        return null;
    }

    private void constructArgArray(int argCount) {
        if (argCount == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else if (argCount == 1) {
            if (this.itsOneArgArray >= 0) {
                this.cfw.addALoad(this.itsOneArgArray);
            } else {
                this.cfw.addPush(1);
                this.cfw.add((byte)-67, "java/lang/Object");
            }
        } else {
            this.cfw.addPush(argCount);
            this.cfw.add((byte)-67, "java/lang/Object");
        }
    }

    private void visitRegularCall(Node node, int type, Node child, boolean firstArgDone) {
        String callSignature;
        String methodName;
        String className;
        String simpleCallName;
        OptFunctionNode target = (OptFunctionNode)node.getProp(16);
        Node chelsea = child;
        int childCount = 0;
        int argSkipCount = type == 31 ? 1 : 2;
        while (child != null) {
            ++childCount;
            child = child.getNext();
        }
        child = chelsea;
        int argIndex = -argSkipCount;
        if (firstArgDone && child != null) {
            child = child.getNext();
            ++argIndex;
            this.cfw.addALoad(this.contextLocal);
            this.cfw.add((byte)95);
        } else {
            this.cfw.addALoad(this.contextLocal);
        }
        if (firstArgDone && type == 31) {
            this.constructArgArray(childCount - argSkipCount);
        }
        int callType = node.getIntProp(17, 0);
        boolean isSimpleCall = false;
        if (!firstArgDone && type != 31 && (simpleCallName = this.getSimpleCallName(node)) != null && callType == 0) {
            isSimpleCall = true;
            this.cfw.addPush(simpleCallName);
            this.cfw.addALoad(this.variableObjectLocal);
            child = child.getNext().getNext();
            argIndex = 0;
            this.constructArgArray(childCount - argSkipCount);
        }
        while (child != null) {
            if (argIndex < 0) {
                this.generateCodeFromNode(child, node);
            } else {
                this.cfw.add((byte)89);
                this.cfw.addPush(argIndex);
                if (target != null) {
                    OptLocalVariable lVar;
                    boolean handled = false;
                    if (child.getType() == 59 && this.inDirectCallFunction && (lVar = (OptLocalVariable)child.getProp(13)) != null && lVar.isParameter()) {
                        child.removeProp(15);
                        this.generateCodeFromNode(child, node);
                        handled = true;
                    }
                    if (!handled) {
                        this.generateCodeFromNode(child, node);
                        int childNumberFlag = child.getIntProp(15, -1);
                        if (childNumberFlag == 0) {
                            this.addDoubleWrap();
                        }
                    }
                } else {
                    this.generateCodeFromNode(child, node);
                }
                this.cfw.add((byte)83);
            }
            if (++argIndex == 0) {
                this.constructArgArray(childCount - argSkipCount);
            }
            child = child.getNext();
        }
        if (callType != 0) {
            className = "org/mozilla/javascript/optimizer/OptRuntime";
            if (type == 31) {
                methodName = "newObjectSpecial";
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;";
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addPush(callType);
            } else {
                methodName = "callSpecial";
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;I)Ljava/lang/Object;";
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addPush(callType);
                String sourceName = this.scriptOrFn.getSourceName();
                this.cfw.addPush(sourceName == null ? "" : sourceName);
                this.cfw.addPush(this.itsLineNumber);
            }
        } else if (isSimpleCall) {
            className = "org/mozilla/javascript/optimizer/OptRuntime";
            methodName = "callSimple";
            callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;";
        } else {
            className = "org/mozilla/javascript/ScriptRuntime";
            this.cfw.addALoad(this.variableObjectLocal);
            if (type == 31) {
                methodName = "newObject";
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;";
            } else {
                methodName = "call";
                callSignature = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        }
        this.cfw.addInvoke((byte)-72, className, methodName, callSignature);
    }

    private void visitStatement(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node.Jump node, Node child) {
        short savedVariableObject = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(savedVariableObject);
        int startLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(startLabel, (short)1);
        this.visitStatement(node);
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        Node.Target catchTarget = node.target;
        Node.Target finallyTarget = node.getFinally();
        int realEnd = this.cfw.acquireLabel();
        this.cfw.add((byte)-89, realEnd);
        int exceptionLocal = this.getLocalBlockRegister(node);
        if (catchTarget != null) {
            int catchLabel = catchTarget.labelId;
            this.generateCatchBlock(0, savedVariableObject, catchLabel, startLabel, exceptionLocal);
            this.generateCatchBlock(1, savedVariableObject, catchLabel, startLabel, exceptionLocal);
            this.generateCatchBlock(2, savedVariableObject, catchLabel, startLabel, exceptionLocal);
        }
        if (finallyTarget != null) {
            int finallyHandler = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            this.cfw.addAStore(exceptionLocal);
            this.cfw.addALoad(savedVariableObject);
            this.cfw.addAStore(this.variableObjectLocal);
            int finallyLabel = finallyTarget.labelId;
            this.cfw.add((byte)-88, finallyLabel);
            this.cfw.addALoad(exceptionLocal);
            this.cfw.add((byte)-65);
            this.cfw.addExceptionHandler(startLabel, finallyLabel, finallyHandler, null);
        }
        this.releaseWordLocal(savedVariableObject);
        this.cfw.markLabel(realEnd);
    }

    private void generateCatchBlock(int exceptionType, short savedVariableObject, int catchLabel, int startLabel, int exceptionLocal) {
        String exceptionName;
        int handler = this.cfw.acquireLabel();
        this.cfw.markHandler(handler);
        short exceptionObject = this.getNewWordLocal();
        this.cfw.addAStore(exceptionObject);
        this.cfw.addALoad(savedVariableObject);
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(exceptionObject);
        this.releaseWordLocal(exceptionObject);
        this.addScriptRuntimeInvoke("getCatchObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Throwable;)Ljava/lang/Object;");
        this.cfw.addAStore(exceptionLocal);
        if (exceptionType == 0) {
            exceptionName = "org/mozilla/javascript/JavaScriptException";
        } else if (exceptionType == 1) {
            exceptionName = "org/mozilla/javascript/EvaluatorException";
        } else {
            if (exceptionType != 2) {
                Kit.codeBug();
            }
            exceptionName = "org/mozilla/javascript/EcmaError";
        }
        this.cfw.addExceptionHandler(startLabel, catchLabel, handler, exceptionName);
        this.cfw.add((byte)-89, catchLabel);
    }

    private void visitThrow(Node node, Node child) {
        this.visitStatement(node);
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        this.cfw.add((byte)-69, "org/mozilla/javascript/JavaScriptException");
        this.cfw.add((byte)90);
        this.cfw.add((byte)95);
        this.cfw.addPush(this.scriptOrFn.getSourceName());
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addInvoke((byte)-73, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
        this.cfw.add((byte)-65);
    }

    private void visitSwitch(Node.Jump node, Node child) {
        this.visitStatement(node);
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        short selector = this.getNewWordLocal();
        this.cfw.addAStore(selector);
        ObjArray cases = (ObjArray)node.getProp(8);
        int i = 0;
        while (i < cases.size()) {
            Node thisCase = (Node)cases.get(i);
            Node first = thisCase.getFirstChild();
            this.generateCodeFromNode(first, thisCase);
            this.cfw.addALoad(selector);
            this.addScriptRuntimeInvoke("seqB", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;");
            Node.Target target = new Node.Target();
            thisCase.replaceChild(first, target);
            this.generateGOTO(7, target);
            ++i;
        }
        this.releaseWordLocal(selector);
        Node defaultNode = (Node)node.getProp(9);
        if (defaultNode != null) {
            Node.Target defaultTarget = new Node.Target();
            defaultNode.getFirstChild().addChildToFront(defaultTarget);
            this.generateGOTO(6, defaultTarget);
        }
        Node.Target breakTarget = node.target;
        this.generateGOTO(6, breakTarget);
    }

    private void generateGOTO(int type, Node.Target target) {
        Node.Jump GOTO = new Node.Jump(type);
        GOTO.target = target;
        this.visitGOTO(GOTO, type, null);
    }

    private void visitTypeofname(Node node) {
        OptLocalVariable lVar;
        String name = node.getString();
        if (this.hasVarsInRegs && (lVar = this.fnCurrent.getVar(name)) != null) {
            if (lVar.isNumber()) {
                this.cfw.addPush("number");
                return;
            }
            this.visitGetVar(lVar, false, name);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    private void visitIncDec(Node node, boolean isInc) {
        Node child = node.getFirstChild();
        if (node.getIntProp(15, -1) != -1) {
            OptLocalVariable lVar = (OptLocalVariable)child.getProp(13);
            if (lVar.getJRegister() == -1) {
                lVar.assignJRegister(this.getNewWordPairLocal());
            }
            this.cfw.addDLoad(lVar.getJRegister());
            this.cfw.add((byte)92);
            this.cfw.addPush(1.0);
            this.cfw.add(isInc ? (byte)99 : 103);
            this.cfw.addDStore(lVar.getJRegister());
        } else {
            OptLocalVariable lVar = (OptLocalVariable)child.getProp(13);
            String routine = isInc ? "postIncrement" : "postDecrement";
            int childType = child.getType();
            if (this.hasVarsInRegs && childType == 59) {
                if (lVar == null) {
                    lVar = this.fnCurrent.getVar(child.getString());
                }
                if (lVar.getJRegister() == -1) {
                    lVar.assignJRegister(this.getNewWordLocal());
                }
                this.cfw.addALoad(lVar.getJRegister());
                this.cfw.add((byte)89);
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;)Ljava/lang/Object;");
                this.cfw.addAStore(lVar.getJRegister());
            } else if (childType == 34) {
                Node getPropChild = child.getFirstChild();
                this.generateCodeFromNode(getPropChild, node);
                this.generateCodeFromNode(getPropChild.getNext(), node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else if (childType == 36) {
                routine = routine + "Elem";
                Node getPropChild = child.getFirstChild();
                this.generateCodeFromNode(getPropChild, node);
                this.generateCodeFromNode(getPropChild.getNext(), node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(child.getString());
                this.addScriptRuntimeInvoke(routine, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
            }
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int type = node.getType();
        return type == 23 || type == 26 || type == 25 || type == 24;
    }

    private void visitArithmetic(Node node, byte opCode, Node child, Node parent) {
        int childNumberFlag = node.getIntProp(15, -1);
        if (childNumberFlag != -1) {
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(child.getNext(), node);
            this.cfw.add(opCode);
        } else {
            boolean childOfArithmetic = BodyCodegen.isArithmeticNode(parent);
            this.generateCodeFromNode(child, node);
            if (!BodyCodegen.isArithmeticNode(child)) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
            }
            this.generateCodeFromNode(child.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(child.getNext())) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
            }
            this.cfw.add(opCode);
            if (!childOfArithmetic) {
                this.addDoubleWrap();
            }
        }
    }

    private void visitBitOp(Node node, int type, Node child) {
        int childNumberFlag = node.getIntProp(15, -1);
        this.generateCodeFromNode(child, node);
        if (type == 21) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)J");
            this.generateCodeFromNode(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.cfw.addPush(31);
            this.cfw.add((byte)126);
            this.cfw.add((byte)125);
            this.cfw.add((byte)-118);
            this.addDoubleWrap();
            return;
        }
        if (childNumberFlag == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.generateCodeFromNode(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateCodeFromNode(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
        }
        switch (type) {
            case 10: {
                this.cfw.add((byte)-128);
                break;
            }
            case 11: {
                this.cfw.add((byte)-126);
                break;
            }
            case 12: {
                this.cfw.add((byte)126);
                break;
            }
            case 20: {
                this.cfw.add((byte)122);
                break;
            }
            case 19: {
                this.cfw.add((byte)120);
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
        this.cfw.add((byte)-121);
        if (childNumberFlag == -1) {
            this.addDoubleWrap();
        }
    }

    private boolean nodeIsDirectCallParameter(Node node) {
        OptLocalVariable lVar;
        return node.getType() == 59 && (lVar = (OptLocalVariable)node.getProp(13)) != null && lVar.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int type, int trueGOTO, int falseGOTO) {
        switch (type) {
            case 16: {
                this.cfw.add((byte)-104);
                this.cfw.add((byte)-98, trueGOTO);
                break;
            }
            case 18: {
                this.cfw.add((byte)-105);
                this.cfw.add((byte)-100, trueGOTO);
                break;
            }
            case 15: {
                this.cfw.add((byte)-104);
                this.cfw.add((byte)-101, trueGOTO);
                break;
            }
            case 17: {
                this.cfw.add((byte)-105);
                this.cfw.add((byte)-99, trueGOTO);
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
        if (falseGOTO != -1) {
            this.cfw.add((byte)-89, falseGOTO);
        }
    }

    private void visitIfJumpRelOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        int type = node.getType();
        if (type == 55 || type == 54) {
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(child.getNext(), node);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke(type == 55 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Z");
            this.cfw.add((byte)-102, trueGOTO);
            this.cfw.add((byte)-89, falseGOTO);
            return;
        }
        int childNumberFlag = node.getIntProp(15, -1);
        if (childNumberFlag == 0) {
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(child.getNext(), node);
            this.genSimpleCompare(type, trueGOTO, falseGOTO);
        } else {
            Node rChild = child.getNext();
            boolean leftIsDCP = this.nodeIsDirectCallParameter(child);
            boolean rightIsDCP = this.nodeIsDirectCallParameter(rChild);
            if (leftIsDCP || rightIsDCP) {
                if (leftIsDCP) {
                    OptLocalVariable lVar1;
                    if (rightIsDCP) {
                        lVar1 = (OptLocalVariable)child.getProp(13);
                        this.cfw.addALoad(lVar1.getJRegister());
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int notNumbersLabel = this.cfw.acquireLabel();
                        this.cfw.add((byte)-90, notNumbersLabel);
                        OptLocalVariable lVar2 = (OptLocalVariable)rChild.getProp(13);
                        this.cfw.addALoad(lVar2.getJRegister());
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.cfw.add((byte)-90, notNumbersLabel);
                        this.cfw.addDLoad(lVar1.getJRegister() + 1);
                        this.cfw.addDLoad(lVar2.getJRegister() + 1);
                        this.genSimpleCompare(type, trueGOTO, falseGOTO);
                        this.cfw.markLabel(notNumbersLabel);
                    } else if (childNumberFlag == 2) {
                        lVar1 = (OptLocalVariable)child.getProp(13);
                        this.cfw.addALoad(lVar1.getJRegister());
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int notNumbersLabel = this.cfw.acquireLabel();
                        this.cfw.add((byte)-90, notNumbersLabel);
                        this.cfw.addDLoad(lVar1.getJRegister() + 1);
                        this.generateCodeFromNode(rChild, node);
                        this.genSimpleCompare(type, trueGOTO, falseGOTO);
                        this.cfw.markLabel(notNumbersLabel);
                    }
                } else if (childNumberFlag == 1) {
                    OptLocalVariable lVar2 = (OptLocalVariable)rChild.getProp(13);
                    this.cfw.addALoad(lVar2.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int notNumbersLabel = this.cfw.acquireLabel();
                    this.cfw.add((byte)-90, notNumbersLabel);
                    this.generateCodeFromNode(child, node);
                    this.cfw.addDLoad(lVar2.getJRegister() + 1);
                    this.genSimpleCompare(type, trueGOTO, falseGOTO);
                    this.cfw.markLabel(notNumbersLabel);
                }
            }
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(rChild, node);
            if (childNumberFlag == -1) {
                if (type == 18 || type == 17) {
                    this.cfw.add((byte)95);
                }
                String routine = type == 15 || type == 17 ? "cmp_LT" : "cmp_LE";
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;)I");
            } else {
                String routine;
                boolean doubleThenObject;
                boolean bl = doubleThenObject = childNumberFlag == 1;
                if (type == 18 || type == 17) {
                    if (doubleThenObject) {
                        this.cfw.add((byte)91);
                        this.cfw.add((byte)87);
                        doubleThenObject = false;
                    } else {
                        this.cfw.add((byte)93);
                        this.cfw.add((byte)88);
                        doubleThenObject = true;
                    }
                }
                String string = routine = type == 15 || type == 17 ? "cmp_LT" : "cmp_LE";
                if (doubleThenObject) {
                    this.addOptRuntimeInvoke(routine, "(DLjava/lang/Object;)I");
                } else {
                    this.addOptRuntimeInvoke(routine, "(Ljava/lang/Object;D)I");
                }
            }
            this.cfw.add((byte)-102, trueGOTO);
            this.cfw.add((byte)-89, falseGOTO);
        }
    }

    private void visitRelOp(Node node, Node child) {
        int type = node.getType();
        if (type == 55 || type == 54) {
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(child.getNext(), node);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke(type == 55 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Z");
            int trueGOTO = this.cfw.acquireLabel();
            int skip = this.cfw.acquireLabel();
            this.cfw.add((byte)-102, trueGOTO);
            this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.cfw.add((byte)-89, skip);
            this.cfw.markLabel(trueGOTO);
            this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.cfw.markLabel(skip);
            this.cfw.adjustStackTop(-1);
            return;
        }
        int childNumberFlag = node.getIntProp(15, -1);
        if (childNumberFlag == 0) {
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(child.getNext(), node);
            int trueGOTO = this.cfw.acquireLabel();
            int skip = this.cfw.acquireLabel();
            this.genSimpleCompare(type, trueGOTO, -1);
            this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.cfw.add((byte)-89, skip);
            this.cfw.markLabel(trueGOTO);
            this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.cfw.markLabel(skip);
            this.cfw.adjustStackTop(-1);
        } else {
            String routine = type == 15 || type == 17 ? "cmp_LTB" : "cmp_LEB";
            this.generateCodeFromNode(child, node);
            this.generateCodeFromNode(child.getNext(), node);
            if (childNumberFlag == -1) {
                if (type == 18 || type == 17) {
                    this.cfw.add((byte)95);
                }
                this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;");
            } else {
                boolean doubleThenObject;
                boolean bl = doubleThenObject = childNumberFlag == 1;
                if (type == 18 || type == 17) {
                    if (doubleThenObject) {
                        this.cfw.add((byte)91);
                        this.cfw.add((byte)87);
                        doubleThenObject = false;
                    } else {
                        this.cfw.add((byte)93);
                        this.cfw.add((byte)88);
                        doubleThenObject = true;
                    }
                }
                if (doubleThenObject) {
                    this.addOptRuntimeInvoke(routine, "(DLjava/lang/Object;)Ljava/lang/Boolean;");
                } else {
                    this.addOptRuntimeInvoke(routine, "(Ljava/lang/Object;D)Ljava/lang/Boolean;");
                }
            }
        }
    }

    private Node getConvertToObjectOfNumberNode(Node node) {
        Node convertChild;
        if (node.getType() == 125 && (convertChild = node.getFirstChild()).getType() == 40) {
            return convertChild;
        }
        return null;
    }

    private void visitEqOp(Node node, Node child) {
        String name;
        boolean isStrict;
        int type = node.getType();
        Node rightChild = child.getNext();
        boolean bl = isStrict = type == 48 || type == 49;
        if (rightChild.getType() == 44) {
            this.generateCodeFromNode(child, node);
            if (isStrict) {
                this.cfw.add((byte)-58, 9);
            } else {
                this.cfw.add((byte)89);
                this.cfw.add((byte)-58, 15);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add((byte)-91, 10);
            }
            if (type == 13 || type == 48) {
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            } else {
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            }
            if (isStrict) {
                this.cfw.add((byte)-89, 6);
            } else {
                this.cfw.add((byte)-89, 7);
                this.cfw.add((byte)87);
            }
            if (type == 13 || type == 48) {
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            } else {
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            }
            return;
        }
        this.generateCodeFromNode(child, node);
        this.generateCodeFromNode(child.getNext(), node);
        switch (type) {
            case 13: {
                name = "eqB";
                break;
            }
            case 14: {
                name = "neB";
                break;
            }
            case 48: {
                name = "seqB";
                break;
            }
            case 49: {
                name = "sneB";
                break;
            }
            default: {
                name = null;
                Codegen.badTree();
            }
        }
        this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;");
    }

    private void visitIfJumpEqOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        Node convertChild;
        boolean isStrict;
        int type = node.getType();
        Node rightChild = child.getNext();
        boolean bl = isStrict = type == 48 || type == 49;
        if (rightChild.getType() == 44) {
            boolean simpleChild;
            if (type != 13 && type != 48) {
                int temp = trueGOTO;
                trueGOTO = falseGOTO;
                falseGOTO = temp;
            }
            this.generateCodeFromNode(child, node);
            if (isStrict) {
                this.cfw.add((byte)-58, trueGOTO);
                this.cfw.add((byte)-89, falseGOTO);
                return;
            }
            boolean bl2 = simpleChild = child.getType() == 59;
            if (!simpleChild) {
                this.cfw.add((byte)89);
            }
            int popGOTO = this.cfw.acquireLabel();
            this.cfw.add((byte)-58, simpleChild ? trueGOTO : popGOTO);
            short popStack = this.cfw.getStackTop();
            if (simpleChild) {
                this.generateCodeFromNode(child, node);
            }
            Codegen.pushUndefined(this.cfw);
            this.cfw.add((byte)-91, trueGOTO);
            this.cfw.add((byte)-89, falseGOTO);
            if (!simpleChild) {
                this.cfw.markLabel(popGOTO, popStack);
                this.cfw.add((byte)87);
                this.cfw.add((byte)-89, trueGOTO);
            }
            return;
        }
        Node rChild = child.getNext();
        if (this.nodeIsDirectCallParameter(child) && (convertChild = this.getConvertToObjectOfNumberNode(rChild)) != null) {
            OptLocalVariable lVar1 = (OptLocalVariable)child.getProp(13);
            this.cfw.addALoad(lVar1.getJRegister());
            this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
            int notNumbersLabel = this.cfw.acquireLabel();
            this.cfw.add((byte)-90, notNumbersLabel);
            this.cfw.addDLoad(lVar1.getJRegister() + 1);
            this.cfw.addPush(convertChild.getDouble());
            this.cfw.add((byte)-105);
            if (type == 13) {
                this.cfw.add((byte)-103, trueGOTO);
            } else {
                this.cfw.add((byte)-102, trueGOTO);
            }
            this.cfw.add((byte)-89, falseGOTO);
            this.cfw.markLabel(notNumbersLabel);
        }
        this.generateCodeFromNode(child, node);
        this.generateCodeFromNode(rChild, node);
        switch (type) {
            case 13: {
                String name = "eq";
                this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            case 14: {
                String name = "neq";
                this.addOptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            case 48: {
                String name = "shallowEq";
                this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            case 49: {
                String name = "shallowNeq";
                this.addOptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            default: {
                String name = null;
                Codegen.badTree();
            }
        }
        this.cfw.add((byte)-102, trueGOTO);
        this.cfw.add((byte)-89, falseGOTO);
    }

    private void visitLiteral(Node node) {
        if (node.getType() == 41) {
            this.cfw.addPush(node.getString());
        } else {
            double num = node.getDouble();
            if (node.getIntProp(15, -1) != -1) {
                this.cfw.addPush(num);
            } else {
                this.codegen.pushNumberAsObject(this.cfw, num);
            }
        }
    }

    private void visitRegexp(Node node) {
        int i = node.getExistingIntProp(7);
        if (this.fnCurrent == null) {
            this.cfw.addALoad(this.scriptRegexpLocal);
        } else {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.add((byte)-76, this.codegen.mainClassName, "_re", "[Ljava/lang/Object;");
        }
        this.cfw.addPush(i);
        this.cfw.add((byte)50);
    }

    private void visitName(Node node) {
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitGetVar(OptLocalVariable lVar, boolean isNumber, String name) {
        if (this.hasVarsInRegs && lVar == null) {
            lVar = this.fnCurrent.getVar(name);
        }
        if (lVar != null) {
            if (lVar.getJRegister() == -1) {
                if (lVar.isNumber()) {
                    lVar.assignJRegister(this.getNewWordPairLocal());
                } else {
                    lVar.assignJRegister(this.getNewWordLocal());
                }
            }
            if (lVar.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (isNumber) {
                    this.cfw.addALoad(lVar.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isNumberLabel = this.cfw.acquireLabel();
                    int beyond = this.cfw.acquireLabel();
                    this.cfw.add((byte)-91, isNumberLabel);
                    this.cfw.addALoad(lVar.getJRegister());
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
                    this.cfw.add((byte)-89, beyond);
                    this.cfw.markLabel(isNumberLabel);
                    this.cfw.addDLoad(lVar.getJRegister() + 1);
                    this.cfw.markLabel(beyond);
                } else {
                    this.cfw.addALoad(lVar.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isNumberLabel = this.cfw.acquireLabel();
                    int beyond = this.cfw.acquireLabel();
                    this.cfw.add((byte)-91, isNumberLabel);
                    this.cfw.addALoad(lVar.getJRegister());
                    this.cfw.add((byte)-89, beyond);
                    this.cfw.markLabel(isNumberLabel);
                    this.cfw.addDLoad(lVar.getJRegister() + 1);
                    this.addDoubleWrap();
                    this.cfw.markLabel(beyond);
                }
            } else if (lVar.isNumber()) {
                this.cfw.addDLoad(lVar.getJRegister());
            } else {
                this.cfw.addALoad(lVar.getJRegister());
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node child, boolean needValue) {
        OptLocalVariable lVar = (OptLocalVariable)node.getProp(13);
        if (this.hasVarsInRegs && lVar == null) {
            lVar = this.fnCurrent.getVar(child.getString());
        }
        if (lVar != null) {
            this.generateCodeFromNode(child.getNext(), node);
            if (lVar.getJRegister() == -1) {
                if (lVar.isNumber()) {
                    lVar.assignJRegister(this.getNewWordPairLocal());
                } else {
                    lVar.assignJRegister(this.getNewWordLocal());
                }
            }
            if (lVar.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (node.getIntProp(15, -1) != -1) {
                    if (needValue) {
                        this.cfw.add((byte)92);
                    }
                    this.cfw.addALoad(lVar.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isNumberLabel = this.cfw.acquireLabel();
                    int beyond = this.cfw.acquireLabel();
                    this.cfw.add((byte)-91, isNumberLabel);
                    this.addDoubleWrap();
                    this.cfw.addAStore(lVar.getJRegister());
                    this.cfw.add((byte)-89, beyond);
                    this.cfw.markLabel(isNumberLabel);
                    this.cfw.addDStore(lVar.getJRegister() + 1);
                    this.cfw.markLabel(beyond);
                } else {
                    if (needValue) {
                        this.cfw.add((byte)89);
                    }
                    this.cfw.addAStore(lVar.getJRegister());
                }
            } else if (node.getIntProp(15, -1) != -1) {
                this.cfw.addDStore(lVar.getJRegister());
                if (needValue) {
                    this.cfw.addDLoad(lVar.getJRegister());
                }
            } else {
                this.cfw.addAStore(lVar.getJRegister());
                if (needValue) {
                    this.cfw.addALoad(lVar.getJRegister());
                }
            }
            return;
        }
        child.setType(52);
        node.setType(9);
        this.visitSetName(node, child);
        if (!needValue) {
            this.cfw.add((byte)87);
        }
    }

    private void visitGetProp(Node node, Node child) {
        int special = node.getIntProp(11, 0);
        if (special != 0) {
            while (child != null) {
                this.generateCodeFromNode(child, node);
                child = child.getNext();
            }
            this.cfw.addALoad(this.variableObjectLocal);
            String runtimeMethod = null;
            if (special == 1) {
                runtimeMethod = "getProto";
            } else if (special == 2) {
                runtimeMethod = "getParent";
            } else {
                Codegen.badTree();
            }
            this.addScriptRuntimeInvoke(runtimeMethod, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        Node nameChild = child.getNext();
        this.generateCodeFromNode(child, node);
        this.generateCodeFromNode(nameChild, node);
        this.cfw.addALoad(this.variableObjectLocal);
        int childType = child.getType();
        if ((childType == 45 || childType == 116 && child.getFirstChild().getType() == 45) && nameChild.getType() == 41) {
            this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitSetProp(int type, Node node, Node child) {
        Node objectChild = child;
        this.generateCodeFromNode(child, node);
        child = child.getNext();
        int special = node.getIntProp(11, 0);
        if (special != 0) {
            String runtimeMethod;
            if (type == 121) {
                this.cfw.add((byte)89);
                runtimeMethod = null;
                if (special == 1) {
                    runtimeMethod = "getProto";
                } else if (special == 2) {
                    runtimeMethod = "getParent";
                } else {
                    Codegen.badTree();
                }
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(runtimeMethod, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
            }
            this.generateCodeFromNode(child, node);
            this.cfw.addALoad(this.variableObjectLocal);
            runtimeMethod = null;
            if (special == 1) {
                runtimeMethod = "setProto";
            } else if (special == 2) {
                runtimeMethod = "setParent";
            } else {
                Codegen.badTree();
            }
            this.addScriptRuntimeInvoke(runtimeMethod, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            return;
        }
        if (type == 121) {
            this.cfw.add((byte)89);
        }
        Node nameChild = child;
        this.generateCodeFromNode(child, node);
        child = child.getNext();
        if (type == 121) {
            this.cfw.add((byte)90);
            this.cfw.addALoad(this.variableObjectLocal);
            if (objectChild.getType() == 45 && nameChild.getType() == 41) {
                this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateCodeFromNode(child, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitBind(Node node, int type, Node child) {
        while (child != null) {
            this.generateCodeFromNode(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke(type == 52 ? "bind" : "getBase", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Scriptable;");
    }

    private int getLocalBlockRegister(Node node) {
        Node localBlock = (Node)node.getProp(4);
        int localSlot = localBlock.getExistingIntProp(3);
        return localSlot;
    }

    private void visitNewTemp(Node node, Node child) {
        this.generateCodeFromNode(child, node);
        short local = this.getNewWordLocal();
        node.putIntProp(3, local);
        this.cfw.add((byte)89);
        this.cfw.addAStore(local);
        if (node.getIntProp(6, 0) == 0) {
            this.releaseWordLocal(local);
        }
    }

    private void visitUseTemp(Node node, Node child) {
        Node temp = (Node)node.getProp(2);
        int local = temp.getExistingIntProp(3);
        this.cfw.addALoad(local);
        int n = temp.getIntProp(6, 0);
        if (n <= 1) {
            this.releaseWordLocal((short)local);
        }
        if (n != 0 && n != Integer.MAX_VALUE) {
            temp.putIntProp(6, n - 1);
        }
    }

    private void addScriptRuntimeInvoke(String methodName, String methodSignature) {
        this.cfw.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", methodName, methodSignature);
    }

    private void addOptRuntimeInvoke(String methodName, String methodSignature) {
        this.cfw.addInvoke((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", methodName, methodSignature);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private short getNewWordPairLocal() {
        short result;
        for (result = this.firstFreeLocal; result < 255 && (this.locals[result] || this.locals[result + 1]); result = (short)(result + 1)) {
        }
        if (result < 255) {
            this.locals[result] = true;
            this.locals[result + 1] = true;
            if (result == this.firstFreeLocal) {
                int i = this.firstFreeLocal + 2;
                while (i < 256) {
                    if (!this.locals[i]) {
                        this.firstFreeLocal = (short)i;
                        if (this.localsMax < this.firstFreeLocal) {
                            this.localsMax = this.firstFreeLocal;
                        }
                        return result;
                    }
                    ++i;
                }
            } else {
                return result;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short reserveWordLocal(int local) {
        if (this.getNewWordLocal() != local) {
            throw new RuntimeException("Local allocation error");
        }
        return (short)local;
    }

    private short getNewWordLocal() {
        short result = this.firstFreeLocal;
        this.locals[result] = true;
        int i = this.firstFreeLocal + 1;
        while (i < 256) {
            if (!this.locals[i]) {
                this.firstFreeLocal = (short)i;
                if (this.localsMax < this.firstFreeLocal) {
                    this.localsMax = this.firstFreeLocal;
                }
                return result;
            }
            ++i;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void releaseWordpairLocal(short local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = false;
        this.locals[local + 1] = false;
    }

    private void releaseWordLocal(short local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = false;
    }
}

