/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeNumber
extends IdScriptable {
    private static final int MAX_PRECISION = 100;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int Id_toFixed = 6;
    private static final int Id_toExponential = 7;
    private static final int Id_toPrecision = 8;
    private static final int MAX_PROTOTYPE_ID = 8;
    private double doubleValue;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeNumber obj = new NativeNumber();
        obj.prototypeFlag = true;
        obj.addAsPrototype(8, cx, scope, sealed);
    }

    private NativeNumber() {
    }

    private NativeNumber(double number) {
        this.doubleValue = number;
    }

    public String getClassName() {
        return "Number";
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
        int attr = 7;
        ctor.defineProperty("NaN", ScriptRuntime.NaNobj, 7);
        ctor.defineProperty("POSITIVE_INFINITY", this.wrap_double(Double.POSITIVE_INFINITY), 7);
        ctor.defineProperty("NEGATIVE_INFINITY", this.wrap_double(Double.NEGATIVE_INFINITY), 7);
        ctor.defineProperty("MAX_VALUE", this.wrap_double(Double.MAX_VALUE), 7);
        ctor.defineProperty("MIN_VALUE", this.wrap_double(Double.MIN_VALUE), 7);
        super.fillConstructorProperties(cx, ctor, sealed);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    double val;
                    double d = val = args.length >= 1 ? ScriptRuntime.toNumber(args[0]) : 0.0;
                    if (thisObj == null) {
                        return new NativeNumber(val);
                    }
                    return this.wrap_double(val);
                }
                case 2: 
                case 3: {
                    double val = NativeNumber.realThisValue(thisObj, f);
                    int base = args.length == 0 ? 10 : ScriptRuntime.toInt32(args[0]);
                    return ScriptRuntime.numberToString(val, base);
                }
                case 4: {
                    double val = NativeNumber.realThisValue(thisObj, f);
                    return "(new Number(" + ScriptRuntime.toString(val) + "))";
                }
                case 5: {
                    return this.wrap_double(NativeNumber.realThisValue(thisObj, f));
                }
                case 6: {
                    return NativeNumber.num_to(f, thisObj, args, 2, 2, -20, 0);
                }
                case 7: {
                    return NativeNumber.num_to(f, thisObj, args, 1, 3, 0, 1);
                }
                case 8: {
                    return NativeNumber.num_to(f, thisObj, args, 0, 4, 1, 0);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static double realThisValue(Scriptable thisObj, IdFunction f) {
        if (!(thisObj instanceof NativeNumber)) {
            throw IdScriptable.incompatibleCallError(f);
        }
        return ((NativeNumber)thisObj).doubleValue;
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }

    private static String num_to(IdFunction f, Scriptable thisObj, Object[] args, int zeroArgMode, int oneArgMode, int precisionMin, int precisionOffset) {
        int precision;
        double val = NativeNumber.realThisValue(thisObj, f);
        if (args.length == 0) {
            precision = 0;
            oneArgMode = zeroArgMode;
        } else {
            precision = ScriptRuntime.toInt32(args[0]);
            if (precision < precisionMin || precision > 100) {
                String msg = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(args[0]));
                throw ScriptRuntime.constructError("RangeError", msg);
            }
        }
        StringBuffer sb = new StringBuffer();
        DToA.JS_dtostr(sb, oneArgMode, precision + precisionOffset, val);
        return sb.toString();
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            switch (id) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toLocaleString";
                }
                case 4: {
                    return "toSource";
                }
                case 5: {
                    return "valueOf";
                }
                case 6: {
                    return "toFixed";
                }
                case 7: {
                    return "toExponential";
                }
                case 8: {
                    return "toPrecision";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                char c = s.charAt(0);
                if (c == 't') {
                    X = "toFixed";
                    id = 6;
                    break;
                }
                if (c != 'v') break;
                X = "valueOf";
                id = 5;
                break;
            }
            case 8: {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 4;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "constructor";
                    id = 1;
                    break;
                }
                if (c != 't') break;
                X = "toPrecision";
                id = 8;
                break;
            }
            case 13: {
                X = "toExponential";
                id = 7;
                break;
            }
            case 14: {
                X = "toLocaleString";
                id = 3;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

