# Release (2024-11-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.4
  * **Bug Fix**: Fix potential for user agent language mismatch in tests.
* `github.com/aws/aws-sdk-go-v2/feature/cloudfront/sign`: [v1.8.0](feature/cloudfront/sign/CHANGELOG.md#v180-2024-11-06)
  * **Feature**: Add Expires field to CookieOptions.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.48.0](service/codebuild/CHANGELOG.md#v1480-2024-11-06)
  * **Feature**: AWS CodeBuild now adds additional compute types for reserved capacity fleet.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.51.0](service/guardduty/CHANGELOG.md#v1510-2024-11-06)
  * **Feature**: GuardDuty RDS Protection expands support for Amazon Aurora PostgreSQL Limitless Databases.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.38.0](service/lakeformation/CHANGELOG.md#v1380-2024-11-06)
  * **Feature**: API changes for new named tag expressions feature.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.4.0](service/qapps/CHANGELOG.md#v140-2024-11-06)
  * **Feature**: Introduces category apis in AmazonQApps. Web experience users use Categories to tag and filter library items.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.50.0](service/s3control/CHANGELOG.md#v1500-2024-11-06)
  * **Feature**: Fix ListStorageLensConfigurations and ListStorageLensGroups deserialization for Smithy SDKs.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.20.0](service/verifiedpermissions/CHANGELOG.md#v1200-2024-11-06)
  * **Feature**: Adding BatchGetPolicy API which supports the retrieval of multiple policies across multiple policy stores within a single request.

# Release (2024-11-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.26.0](service/bedrockagent/CHANGELOG.md#v1260-2024-11-01)
  * **Feature**: Amazon Bedrock Knowledge Bases now supports using application inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.14.0](service/docdbelastic/CHANGELOG.md#v1140-2024-11-01)
  * **Feature**: Amazon DocumentDB Elastic Clusters adds support for pending maintenance actions feature with APIs GetPendingMaintenanceAction, ListPendingMaintenanceActions and ApplyPendingMaintenanceAction
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.6.0](service/taxsettings/CHANGELOG.md#v160-2024-11-01)
  * **Feature**: Add support for supplemental tax registrations via these new APIs: PutSupplementalTaxRegistration, ListSupplementalTaxRegistrations, and DeleteSupplementalTaxRegistration.

# Release (2024-10-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.30.0](service/amp/CHANGELOG.md#v1300-2024-10-31)
  * **Feature**: Added support for UpdateScraper API, to enable updating collector configuration in-place
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.47.0](service/autoscaling/CHANGELOG.md#v1470-2024-10-31)
  * **Feature**: Adds bake time for Auto Scaling group Instance Refresh
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.47.0](service/batch/CHANGELOG.md#v1470-2024-10-31)
  * **Feature**: Add `podNamespace` to `EksAttemptDetail` and `containerID` to `EksAttemptContainerDetail`.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.41.0](service/elasticloadbalancingv2/CHANGELOG.md#v1410-2024-10-31)
  * **Feature**: Add UDP support for AWS PrivateLink and dual-stack Network Load Balancers
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.101.0](service/glue/CHANGELOG.md#v11010-2024-10-31)
  * **Feature**: Add schedule support for AWS Glue column statistics
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.166.0](service/sagemaker/CHANGELOG.md#v11660-2024-10-31)
  * **Feature**: SageMaker HyperPod adds scale-down at instance level via BatchDeleteClusterNodes API and group level via UpdateCluster API. SageMaker Training exposes secondary job status in TrainingJobSummary from ListTrainingJobs API. SageMaker now supports G6, G6e, P5e instances for HyperPod and Training.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.38.0](service/sesv2/CHANGELOG.md#v1380-2024-10-31)
  * **Feature**: This release enables customers to provide the email template content in the SESv2 SendEmail and SendBulkEmail APIs instead of the name or the ARN of a stored email template.

# Release (2024-10-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.39.0](service/appsync/CHANGELOG.md#v1390-2024-10-30)
  * **Feature**: This release adds support for AppSync Event APIs.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.115.0](service/connect/CHANGELOG.md#v11150-2024-10-30)
  * **Feature**: Updated the public documentation for the UserIdentityInfo object to accurately reflect the character limits for the FirstName and LastName fields, which were previously listed as 1-100 characters.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.43.0](service/datasync/CHANGELOG.md#v1430-2024-10-30)
  * **Feature**: AWS DataSync now supports Enhanced mode tasks. This task mode supports transfer of virtually unlimited numbers of objects with enhanced metrics, more detailed logs, and higher performance than Basic mode. This mode currently supports transfers between Amazon S3 locations.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.187.0](service/ec2/CHANGELOG.md#v11870-2024-10-30)
  * **Feature**: This release adds two new capabilities to VPC Security Groups: Security Group VPC Associations and Shared Security Groups.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.49.0](service/ecs/CHANGELOG.md#v1490-2024-10-30)
  * **Feature**: This release supports service deployments and service revisions which provide a comprehensive view of your Amazon ECS service history.
* `github.com/aws/aws-sdk-go-v2/service/geomaps`: [v1.0.0](service/geomaps/CHANGELOG.md#v100-2024-10-30)
  * **Release**: New AWS service client module
  * **Feature**: Release of Amazon Location Maps API. Maps enables you to build digital maps that showcase your locations, visualize your data, and unlock insights to drive your business
* `github.com/aws/aws-sdk-go-v2/service/geoplaces`: [v1.0.0](service/geoplaces/CHANGELOG.md#v100-2024-10-30)
  * **Release**: New AWS service client module
  * **Feature**: Release of Amazon Location Places API. Places enables you to quickly search, display, and filter places, businesses, and locations based on proximity, category, and name
* `github.com/aws/aws-sdk-go-v2/service/georoutes`: [v1.0.0](service/georoutes/CHANGELOG.md#v100-2024-10-30)
  * **Release**: New AWS service client module
  * **Feature**: Release of Amazon Location Routes API. Routes enables you to plan efficient routes and streamline deliveries by leveraging real-time traffic, vehicle restrictions, and turn-by-turn directions.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.15.0](service/keyspaces/CHANGELOG.md#v1150-2024-10-30)
  * **Feature**: Adds support for interacting with user-defined types (UDTs) through the following new operations: Create-Type, Delete-Type, List-Types, Get-Type.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.44.0](service/networkfirewall/CHANGELOG.md#v1440-2024-10-30)
  * **Feature**: AWS Network Firewall now supports configuring TCP idle timeout
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.43.0](service/opensearch/CHANGELOG.md#v1430-2024-10-30)
  * **Feature**: This release introduces the new OpenSearch user interface (Dashboards), a new web-based application that can be associated with multiple data sources across OpenSearch managed clusters, serverless collections, and Amazon S3, so that users can gain a comprehensive insights in an unified interface.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.17.0](service/opensearchserverless/CHANGELOG.md#v1170-2024-10-30)
  * **Feature**: Neo Integration via IAM Identity Center (IdC)
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.51.0](service/redshift/CHANGELOG.md#v1510-2024-10-30)
  * **Feature**: This release launches S3 event integrations to create and manage integrations from an Amazon S3 source into an Amazon Redshift database.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.24.0](service/redshiftserverless/CHANGELOG.md#v1240-2024-10-30)
  * **Feature**: Adds and updates API members for the Redshift Serverless AI-driven scaling and optimization feature using the price-performance target setting.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.46.0](service/route53/CHANGELOG.md#v1460-2024-10-30)
  * **Feature**: This release adds support for TLSA, SSHFP, SVCB, and HTTPS record types.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.165.0](service/sagemaker/CHANGELOG.md#v11650-2024-10-30)
  * **Feature**: Added support for Model Registry Staging construct. Users can define series of stages that models can progress through for model workflows and lifecycle. This simplifies tracking and managing models as they transition through development, testing, and production stages.
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.30.0](service/workmail/CHANGELOG.md#v1300-2024-10-30)
  * **Feature**: This release adds support for Multi-Factor Authentication (MFA) and Personal Access Tokens through integration with AWS IAM Identity Center.

# Release (2024-10-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.22.0](service/bedrock/CHANGELOG.md#v1220-2024-10-29)
  * **Feature**: Update Application Inference Profile
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.19.0](service/cleanrooms/CHANGELOG.md#v1190-2024-10-29)
  * **Feature**: This release adds the option for customers to configure analytics engine when creating a collaboration, and introduces the new SPARK analytics engine type in addition to maintaining the legacy CLEAN_ROOMS_SQL engine type.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.43.0](service/cloudwatchlogs/CHANGELOG.md#v1430-2024-10-29)
  * **Feature**: Added support for new optional baseline parameter in the UpdateAnomaly API. For UpdateAnomaly requests with baseline set to True, The anomaly behavior is then treated as baseline behavior. However, more severe occurrences of this behavior will still be reported as anomalies.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.21.0](service/iotfleetwise/CHANGELOG.md#v1210-2024-10-29)
  * **Feature**: Updated BatchCreateVehicle and BatchUpdateVehicle APIs: LimitExceededException has been added and the maximum number of vehicles in a batch has been set to 10 explicitly
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.31.0](service/redshiftdata/CHANGELOG.md#v1310-2024-10-29)
  * **Feature**: Adding a new API GetStatementResultV2 that supports CSV formatted results from ExecuteStatement and BatchExecuteStatement calls.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.164.0](service/sagemaker/CHANGELOG.md#v11640-2024-10-29)
  * **Feature**: Adding `notebook-al2-v3` as allowed value to SageMaker NotebookInstance PlatformIdentifier attribute

# Release (2024-10-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.3
  * **Bug Fix**: Improve handling of whitespace (or lack thereof) in sigv4 GetSignedRequestSignature.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.19.0](service/mediapackagev2/CHANGELOG.md#v1190-2024-10-28)
  * **Feature**: MediaPackage V2 Live to VOD Harvester is a MediaPackage V2 feature, which is used to export content from an origin endpoint to a S3 bucket.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.42.0](service/opensearch/CHANGELOG.md#v1420-2024-10-28)
  * **Feature**: Adds support for provisioning dedicated coordinator nodes. Coordinator nodes can be specified using the new NodeOptions parameter in ClusterConfig.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.89.0](service/rds/CHANGELOG.md#v1890-2024-10-28)
  * **Feature**: This release adds support for Enhanced Monitoring and Performance Insights when restoring Aurora Limitless Database DB clusters. It also adds support for the os-upgrade pending maintenance action.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.34.3](service/storagegateway/CHANGELOG.md#v1343-2024-10-28)
  * **Documentation**: Documentation update: Amazon FSx File Gateway will no longer be available to new customers.

# Release (2024-10-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.25.0](service/bedrockagent/CHANGELOG.md#v1250-2024-10-25)
  * **Feature**: Add support of new model types for Bedrock Agents, Adding inference profile support for Flows and Prompt Management, Adding new field to configure additional inference configurations for Flows and Prompt Management
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.42.0](service/cloudwatchlogs/CHANGELOG.md#v1420-2024-10-25)
  * **Feature**: Adding inferred token name for dynamic tokens in Anomalies.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.47.0](service/codebuild/CHANGELOG.md#v1470-2024-10-25)
  * **Feature**: AWS CodeBuild now supports automatically retrying failed builds
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.64.0](service/lambda/CHANGELOG.md#v1640-2024-10-25)
  * **Feature**: Add TagsError field in Lambda GetFunctionResponse. The TagsError field contains details related to errors retrieving tags.
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.29.0](service/nimble/CHANGELOG.md#v1290-2024-10-25)
  * **Feature**: Mark service/nimble as deprecated. This service is no longer available for use. See https://aws.amazon.com/nimble-studio/faqs/.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.66.1](service/s3/CHANGELOG.md#v1661-2024-10-25)
  * **Bug Fix**: Update presign post URL resolution to use the exact result from EndpointResolverV2
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.10.0](service/supplychain/CHANGELOG.md#v1100-2024-10-25)
  * **Feature**: API doc updates, and also support showing error message on a failed instance

# Release (2024-10-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.35.0](service/appconfig/CHANGELOG.md#v1350-2024-10-24)
  * **Feature**: This release improves deployment safety by granting customers the ability to REVERT completed deployments, to the last known good state.In the StopDeployment API revert case the status of a COMPLETE deployment will be REVERTED. AppConfig only allows a revert within 72 hours of deployment completion.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.186.0](service/ec2/CHANGELOG.md#v11860-2024-10-24)
  * **Feature**: This release includes a new API to describe some details of the Amazon Machine Images (AMIs) that were used to launch EC2 instances, even if those AMIs are no longer available for use.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.48.0](service/ecs/CHANGELOG.md#v1480-2024-10-24)
  * **Feature**: This release adds support for EBS volumes attached to Amazon ECS Windows tasks running on EC2 instances.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.2.3](service/pcs/CHANGELOG.md#v123-2024-10-24)
  * **Documentation**: Documentation update: added the default value of the Slurm configuration parameter scaleDownIdleTimeInSeconds to its description.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.15.0](service/qbusiness/CHANGELOG.md#v1150-2024-10-24)
  * **Feature**: Add a new field in chat response. This field can be used to support nested schemas in array fields

# Release (2024-10-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.21.1](service/bedrock/CHANGELOG.md#v1211-2024-10-23)
  * **Documentation**: Doc updates for supporting converse
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.114.0](service/connect/CHANGELOG.md#v11140-2024-10-23)
  * **Feature**: Amazon Connect Service Feature: Add support to start screen sharing for a web calling contact.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.185.0](service/ec2/CHANGELOG.md#v11850-2024-10-23)
  * **Feature**: Amazon EC2 X8g, C8g and M8g instances are powered by AWS Graviton4 processors. X8g provide the lowest cost per GiB of memory among Graviton4 instances. C8g provide the best price performance for compute-intensive workloads. M8g provide the best price performance in for general purpose workloads.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.32.0](service/mwaa/CHANGELOG.md#v1320-2024-10-23)
  * **Feature**: Introducing InvokeRestApi which allows users to invoke the Apache Airflow REST API on the webserver with the specified inputs.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.15.0](service/paymentcryptography/CHANGELOG.md#v1150-2024-10-23)
  * **Feature**: Add support for ECC P-256 and P-384 Keys.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.16.0](service/paymentcryptographydata/CHANGELOG.md#v1160-2024-10-23)
  * **Feature**: Add ECDH support on PIN operations.

# Release (2024-10-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.38.0](service/imagebuilder/CHANGELOG.md#v1380-2024-10-22)
  * **Feature**: Add macOS platform and instance placement options
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.18.0](service/m2/CHANGELOG.md#v1180-2024-10-22)
  * **Feature**: Add AuthSecretsManagerArn optional parameter to batch job APIs, expand batch parameter limits, and introduce clientToken constraints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.88.0](service/rds/CHANGELOG.md#v1880-2024-10-22)
  * **Feature**: Global clusters now expose the Endpoint attribute as one of its fields. It is a Read/Write endpoint for the global cluster which resolves to the Global Cluster writer instance.
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.8.0](service/repostspace/CHANGELOG.md#v180-2024-10-22)
  * **Feature**: Adds the BatchAddRole and BatchRemoveRole APIs.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.28.0](service/timestreamquery/CHANGELOG.md#v1280-2024-10-22)
  * **Feature**: This release adds support for Query Insights, a feature that provides details of query execution, enabling users to identify areas for improvement to optimize their queries, resulting in improved query performance and lower query costs.

# Release (2024-10-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.29.0](service/applicationinsights/CHANGELOG.md#v1290-2024-10-21)
  * **Feature**: This feature enables customers to specify SNS Topic ARN. CloudWatch Application Insights (CWAI) will utilize this ARN to send problem notifications.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.46.0](service/autoscaling/CHANGELOG.md#v1460-2024-10-21)
  * **Feature**: Adds support for removing the PlacementGroup setting on an Auto Scaling Group through the UpdateAutoScalingGroup API.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.23.0](service/bedrockagentruntime/CHANGELOG.md#v1230-2024-10-21)
  * **Feature**: Knowledge Bases for Amazon Bedrock now supports custom prompts and model parameters in the orchestrationConfiguration of the RetrieveAndGenerate API. The modelArn field accepts Custom Models and Imported Models ARNs.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.44.0](service/databasemigrationservice/CHANGELOG.md#v1440-2024-10-21)
  * **Feature**: Added support for tagging in StartReplicationTaskAssessmentRun API and introduced IsLatestTaskAssessmentRun and ResultStatistic fields for enhanced tracking and assessment result statistics.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.184.0](service/ec2/CHANGELOG.md#v11840-2024-10-21)
  * **Feature**: Amazon EC2 now allows you to create network interfaces with just the EFA driver and no ENA driver by specifying the network interface type as efa-only.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.51.0](service/eks/CHANGELOG.md#v1510-2024-10-21)
  * **Feature**: This release adds support for Amazon Application Recovery Controller (ARC) zonal shift and zonal autoshift with EKS that enhances the resiliency of multi-AZ cluster environments
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.38.0](service/fms/CHANGELOG.md#v1380-2024-10-21)
  * **Feature**: Update AWS WAF policy - add the option to retrofit existing web ACLs instead of creating all new web ACLs.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.15.0](service/paymentcryptographydata/CHANGELOG.md#v1150-2024-10-21)
  * **Feature**: Adding new API to generate authenticated scripts for EMV pin change use cases.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.55.0](service/wafv2/CHANGELOG.md#v1550-2024-10-21)
  * **Feature**: Add a property to WebACL to indicate whether it's been retrofitted by Firewall Manager.

# Release (2024-10-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.48.0](service/athena/CHANGELOG.md#v1480-2024-10-18)
  * **Feature**: **BREAKING CHANGE**: Remove DataCatalog from Create/DeleteDataCatalog. Remove Status, ConnectionType, and Error from DataCatalog and DataCatalogSummary. These were released inadvertently with no functionality. They were not populated or populated with a default value. Code related to these changes can be safely removed.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.21.0](service/bedrock/CHANGELOG.md#v1210-2024-10-18)
  * **Feature**: Adding converse support to CMI API's
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.23.0](service/datazone/CHANGELOG.md#v1230-2024-10-18)
  * **Feature**: Adding the following project member designations: PROJECT_CATALOG_VIEWER, PROJECT_CATALOG_CONSUMER and PROJECT_CATALOG_STEWARD in the CreateProjectMembership API and PROJECT_CATALOG_STEWARD designation in the AddPolicyGrant API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.183.0](service/ec2/CHANGELOG.md#v11830-2024-10-18)
  * **Feature**: RequestSpotInstances and RequestSpotFleet feature release.

# Release (2024-10-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.24.0](service/bedrockagent/CHANGELOG.md#v1240-2024-10-17)
  * **Feature**: Removing support for topK property in PromptModelInferenceConfiguration object, Making PromptTemplateConfiguration property as required, Limiting the maximum PromptVariant to 1
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.33.0](service/dataexchange/CHANGELOG.md#v1330-2024-10-17)
  * **Feature**: This release adds Data Grant support, through which customers can programmatically create data grants to share with other AWS accounts and accept data grants from other AWS accounts.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.47.4](service/ecs/CHANGELOG.md#v1474-2024-10-17)
  * **Documentation**: This is an Amazon ECS documentation only update to address tickets.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.16.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1160-2024-10-17)
  * **Feature**: Added the registrations status of REQUIRES_AUTHENTICATION
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.18.0](service/pipes/CHANGELOG.md#v1180-2024-10-17)
  * **Feature**: This release adds validation to require specifying a SecurityGroup and Subnets in the Vpc object under PipesSourceSelfManagedKafkaParameters. It also adds support for iso-e, iso-f, and other non-commercial partitions in ARN parameters.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.77.0](service/quicksight/CHANGELOG.md#v1770-2024-10-17)
  * **Feature**: Add StartDashboardSnapshotJobSchedule API. RestoreAnalysis now supports restoring analysis to folders.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.87.3](service/rds/CHANGELOG.md#v1873-2024-10-17)
  * **Documentation**: Updates Amazon RDS documentation for TAZ IAM support

# Release (2024-10-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.28.0](config/CHANGELOG.md#v1280-2024-10-16)
  * **Feature**: Adds the LoadOptions hook `WithBaseEndpoint` for setting global endpoint override in-code.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.37.3](service/imagebuilder/CHANGELOG.md#v1373-2024-10-16)
  * **Bug Fix**: **BREAKING CHANGE**: The type of LaunchTemplateConfiguration.SetDefaultVersion has been changed from `bool` to `*bool`. Before this change, the field was incorrectly marked as having a default value of false by the service, which made it functionally impossible for users to express the full range of values for the field (true, false, and unset/nil), each of which have distinctly different behaviors.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.66.0](service/s3/CHANGELOG.md#v1660-2024-10-16)
  * **Feature**: Add support for the new optional bucket-region and prefix query parameters in the ListBuckets API. For ListBuckets requests that express pagination, Amazon S3 will now return both the bucket names and associated AWS regions in the response.

# Release (2024-10-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.27.0](service/amplify/CHANGELOG.md#v1270-2024-10-15)
  * **Feature**: Added sourceUrlType field to StartDeployment request
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.55.3](service/cloudformation/CHANGELOG.md#v1553-2024-10-15)
  * **Documentation**: Documentation update for AWS CloudFormation API Reference.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.46.0](service/codebuild/CHANGELOG.md#v1460-2024-10-15)
  * **Feature**: Enable proxy for reserved capacity fleet.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.41.0](service/ivs/CHANGELOG.md#v1410-2024-10-15)
  * **Feature**: On a channel that you own, you can now replace an ongoing stream with a new stream by streaming up with the priority parameter appended to the stream key.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.14.0](service/qbusiness/CHANGELOG.md#v1140-2024-10-15)
  * **Feature**: Amazon Q Business now supports embedding the Amazon Q Business web experience on third-party websites.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.50.0](service/redshift/CHANGELOG.md#v1500-2024-10-15)
  * **Feature**: This release launches the CreateIntegration, DeleteIntegration, DescribeIntegrations and ModifyIntegration APIs to create and manage Amazon Redshift Zero-ETL Integrations.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.27.0](service/resiliencehub/CHANGELOG.md#v1270-2024-10-15)
  * **Feature**: AWS Resilience Hub now integrates with the myApplications platform, enabling customers to easily assess the resilience of applications defined in myApplications. The new Resiliency widget provides visibility into application resilience and actionable recommendations for improvement.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.37.0](service/sesv2/CHANGELOG.md#v1370-2024-10-15)
  * **Feature**: This release adds support for email maximum delivery seconds that allows senders to control the time within which their emails are attempted for delivery.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.22.0](service/transcribestreaming/CHANGELOG.md#v1220-2024-10-15)
  * **Feature**: We are expanding support for 40 new locales in AWS Transcribe Streaming.

# Release (2024-10-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.36.0](service/codepipeline/CHANGELOG.md#v1360-2024-10-14)
  * **Feature**: AWS CodePipeline V2 type pipelines now support automatically retrying failed stages and skipping stage for failed entry conditions.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.6.0](service/mailmanager/CHANGELOG.md#v160-2024-10-14)
  * **Feature**: Mail Manager support for viewing and exporting metadata of archived messages.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.19.0](service/securitylake/CHANGELOG.md#v1190-2024-10-14)
  * **Feature**: This release updates request validation regex for resource ARNs.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.9.0](service/supplychain/CHANGELOG.md#v190-2024-10-14)
  * **Feature**: This release adds AWS Supply Chain instance management functionality. Specifically adding CreateInstance, DeleteInstance, GetInstance, ListInstances, and UpdateInstance APIs.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.53.0](service/transfer/CHANGELOG.md#v1530-2024-10-14)
  * **Feature**: This release enables customers using SFTP connectors to query the transfer status of their files to meet their monitoring needs as well as orchestrate post transfer actions.

# Release (2024-10-11)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.45.3](service/appflow/CHANGELOG.md#v1453-2024-10-11)
  * **Documentation**: Doc only updates for clarification around OAuth2GrantType for Salesforce.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.40.0](service/elasticloadbalancingv2/CHANGELOG.md#v1400-2024-10-11)
  * **Feature**: Add zonal_shift.config.enabled attribute. Add new AdministrativeOverride construct in the describe-target-health API response to include information about the override status applied to a target.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.46.0](service/emr/CHANGELOG.md#v1460-2024-10-11)
  * **Feature**: This release provides new parameter "Context" in instance fleet clusters.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.50.0](service/guardduty/CHANGELOG.md#v1500-2024-10-11)
  * **Feature**: Added a new field for network connection details.
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.30.3](service/robomaker/CHANGELOG.md#v1303-2024-10-11)
  * **Documentation**: Documentation update: added support notices to each API action.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.65.3](service/s3/CHANGELOG.md#v1653-2024-10-11)
  * **Bug Fix**: **BREAKING CHANGE**: S3 ReplicationRuleFilter and LifecycleRuleFilter shapes are being changed from union to structure types

# Release (2024-10-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.37.3](service/acmpca/CHANGELOG.md#v1373-2024-10-10)
  * **Documentation**: Documentation updates for AWS Private CA.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.43.0](service/databasemigrationservice/CHANGELOG.md#v1430-2024-10-10)
  * **Feature**: Introduces DescribeDataMigrations, CreateDataMigration, ModifyDataMigration, DeleteDataMigration, StartDataMigration, StopDataMigration operations to SDK. Provides FailedDependencyFault error message.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.182.0](service/ec2/CHANGELOG.md#v11820-2024-10-10)
  * **Feature**: This release adds support for assigning the billing of shared Amazon EC2 On-Demand Capacity Reservations.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.47.3](service/ecs/CHANGELOG.md#v1473-2024-10-10)
  * **Documentation**: This is a documentation only release that updates to documentation to let customers know that Amazon Elastic Inference is no longer available.
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.23.3](service/elasticinference/CHANGELOG.md#v1233-2024-10-10)
  * **Documentation**: Elastic Inference - Documentation update to add service shutdown notice.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.20.0](service/iotfleetwise/CHANGELOG.md#v1200-2024-10-10)
  * **Feature**: Refine campaign related API validations
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.14.0](service/neptunegraph/CHANGELOG.md#v1140-2024-10-10)
  * **Feature**: Support for 16 m-NCU graphs available through account allowlisting
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.45.0](service/outposts/CHANGELOG.md#v1450-2024-10-10)
  * **Feature**: Adding new "DELIVERED" enum value for Outposts Order status
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.33.0](service/route53resolver/CHANGELOG.md#v1330-2024-10-10)
  * **Feature**: Route 53 Resolver Forwarding Rules can now include a server name indication (SNI) in the target address for rules that use the DNS-over-HTTPS (DoH) protocol. When a DoH-enabled Outbound Resolver Endpoint forwards a request to a DoH server, it will provide the SNI in the TLS handshake.
* `github.com/aws/aws-sdk-go-v2/service/socialmessaging`: [v1.0.0](service/socialmessaging/CHANGELOG.md#v100-2024-10-10)
  * **Release**: New AWS service client module
  * **Feature**: This release for AWS End User Messaging includes a public SDK, providing a suite of APIs that enable sending WhatsApp messages to end users.

# Release (2024-10-09)

## General Highlights
* **Bug Fix**: Fixup some integration tests.

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.35.0](service/codepipeline/CHANGELOG.md#v1350-2024-10-09)
  * **Feature**: AWS CodePipeline introduces a Compute category

# Release (2024-10-08)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.34.2](service/chime/CHANGELOG.md#v1342-2024-10-08)
  * **Documentation**: Doc-only update to generate deprecated annotation for services that have been marked as deprecated.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.43.0](service/elasticache/CHANGELOG.md#v1430-2024-10-08)
  * **Feature**: AWS ElastiCache SDK now supports using APIs with newly launched Valkey engine. Please refer to updated AWS ElastiCache public documentation for detailed information on API usage.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.24.0](service/memorydb/CHANGELOG.md#v1240-2024-10-08)
  * **Feature**: Amazon MemoryDB SDK now supports all APIs for newly launched Valkey engine. Please refer to the updated Amazon MemoryDB public documentation for detailed information on API usage.
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.24.2](service/sms/CHANGELOG.md#v1242-2024-10-08)
  * **Documentation**: Doc-only update to generate deprecated annotation for services that have been marked as deprecated.

# Release (2024-10-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.32.1
  * **Bug Fix**: Remove private metrics collection APIs. These APIs were annotated at the package level that they should not be used by callers and could be removed at any time. With the release of self-instrumented clients for SDK metrics, this internal code is obsolete.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.32.1](service/dataexchange/CHANGELOG.md#v1321-2024-10-07)
  * **Bug Fix**: Allow serialization of headers with empty string for prefix headers
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.6.0](service/deadline/CHANGELOG.md#v160-2024-10-07)
  * **Feature**: Add support for using the template from a previous job during job creation and listing parameter definitions for a job.
* `github.com/aws/aws-sdk-go-v2/service/marketplacereporting`: [v1.1.1](service/marketplacereporting/CHANGELOG.md#v111-2024-10-07)
  * **Documentation**: Documentation-only update for AWS Marketplace Reporting API.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.12.0](service/qconnect/CHANGELOG.md#v1120-2024-10-07)
  * **Feature**: This release adds support for the following capabilities: Configuration of the Gen AI system via AIAgent and AIPrompts. Integration support for Bedrock Knowledge Base.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.49.0](service/redshift/CHANGELOG.md#v1490-2024-10-07)
  * **Feature**: Add validation pattern to S3KeyPrefix on the EnableLogging API
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.65.1](service/s3/CHANGELOG.md#v1651-2024-10-07)
  * **Bug Fix**: **CHANGE IN BEHAVIOR**: Allow serialization of headers with empty string for prefix headers. We are deploying this fix because the behavior is actively preventing users from transmitting keys with empty values to the service. If you were setting metadata keys with empty values before this change, they will now actually be sent to the service.

# Release (2024-10-04)

## General Highlights
* **Feature**: Add support for HTTP client metrics.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.181.0](service/ec2/CHANGELOG.md#v11810-2024-10-04)
  * **Feature**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.26.0](service/iotdataplane/CHANGELOG.md#v1260-2024-10-04)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-10-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.33.0](service/codepipeline/CHANGELOG.md#v1330-2024-10-03)
  * **Feature**: AWS CodePipeline introduces Commands action that enables you to easily run shell commands as part of your pipeline execution.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.112.0](service/connect/CHANGELOG.md#v11120-2024-10-03)
  * **Feature**: Public GetMetricDataV2 Grouping increase from 3 to 4
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.180.0](service/ec2/CHANGELOG.md#v11800-2024-10-03)
  * **Feature**: This release includes a new API for modifying instance cpu-options after launch.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.58.0](service/iot/CHANGELOG.md#v1580-2024-10-03)
  * **Feature**: This release adds support for Custom Authentication with X.509 Client Certificates, support for Custom Client Certificate validation, and support for selecting application protocol and authentication type without requiring TLS ALPN for customer's AWS IoT Domain Configurations.
* `github.com/aws/aws-sdk-go-v2/service/marketplacereporting`: [v1.0.0](service/marketplacereporting/CHANGELOG.md#v100-2024-10-03)
  * **Release**: New AWS service client module
  * **Feature**: The AWS Marketplace Reporting service introduces the GetBuyerDashboard API. This API returns a dashboard that provides visibility into your organization's AWS Marketplace agreements and associated spend across the AWS accounts in your organization.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.17.0](service/mediapackagev2/CHANGELOG.md#v1170-2024-10-03)
  * **Feature**: Added support for ClipStartTime on the FilterConfiguration object on OriginEndpoint manifest settings objects. Added support for EXT-X-START tags on produced HLS child playlists.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.75.0](service/quicksight/CHANGELOG.md#v1750-2024-10-03)
  * **Feature**: QuickSight: Add support for exporting and importing folders in AssetBundle APIs

# Release (2024-10-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.40.0](service/appstream/CHANGELOG.md#v1400-2024-10-02)
  * **Feature**: Added support for Automatic Time Zone Redirection on Amazon AppStream 2.0
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.44](service/b2bi/CHANGELOG.md#v100-preview44-2024-10-02)
  * **Feature**: Added and updated APIs to support outbound EDI transformations
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.21.0](service/bedrockagentruntime/CHANGELOG.md#v1210-2024-10-02)
  * **Feature**: Added raw model response and usage metrics to PreProcessing and PostProcessing Trace
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.18.0](service/bedrockruntime/CHANGELOG.md#v1180-2024-10-02)
  * **Feature**: Added new fields to Amazon Bedrock Guardrails trace
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.30.0](service/iotdeviceadvisor/CHANGELOG.md#v1300-2024-10-02)
  * **Feature**: Add clientToken attribute and implement idempotency for CreateSuiteDefinition.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.19.0](service/ivsrealtime/CHANGELOG.md#v1190-2024-10-02)
  * **Feature**: Adds new Stage Health EventErrorCodes applicable to RTMP(S) broadcasts. Bug Fix: Enforces that EncoderConfiguration Video height and width must be even-number values.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.64.0](service/s3/CHANGELOG.md#v1640-2024-10-02)
  * **Feature**: This release introduces a header representing the minimum object size limit for Lifecycle transitions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.162.0](service/sagemaker/CHANGELOG.md#v11620-2024-10-02)
  * **Feature**: releasing builtinlcc to public
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.47.4](service/workspaces/CHANGELOG.md#v1474-2024-10-02)
  * **Documentation**: WSP is being rebranded to become DCV.

# Release (2024-10-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.22.0](service/bedrockagent/CHANGELOG.md#v1220-2024-10-01)
  * **Feature**: This release adds support to stop an ongoing ingestion job using the StopIngestionJob API in Agents for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.32.0](service/codeartifact/CHANGELOG.md#v1320-2024-10-01)
  * **Feature**: Add support for the dual stack endpoints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.86.0](service/rds/CHANGELOG.md#v1860-2024-10-01)
  * **Feature**: This release provides additional support for enabling Aurora Limitless Database DB clusters.

# Release (2024-09-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.23.4](service/clouddirectory/CHANGELOG.md#v1234-2024-09-30)
  * **Documentation**: Add examples for API operations in model.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.111.0](service/connect/CHANGELOG.md#v11110-2024-09-30)
  * **Feature**: Amazon Connect introduces StartOutboundChatContact API allowing customers to initiate outbound chat contacts
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.31.4](service/pricing/CHANGELOG.md#v1314-2024-09-30)
  * **Documentation**: Add examples for API operations in model.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.26.0](service/resourcegroups/CHANGELOG.md#v1260-2024-09-30)
  * **Feature**: This update includes new APIs to support application groups and to allow users to manage resource tag-sync tasks in applications.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.7.0](service/supplychain/CHANGELOG.md#v170-2024-09-30)
  * **Feature**: Release DataLakeDataset, DataIntegrationFlow and ResourceTagging APIs for AWS Supply Chain
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.5.0](service/timestreaminfluxdb/CHANGELOG.md#v150-2024-09-30)
  * **Feature**: Timestream for InfluxDB now supports port configuration and additional customer-modifiable InfluxDB v2 parameters. This release adds Port to the CreateDbInstance and UpdateDbInstance API, and additional InfluxDB v2 parameters to the CreateDbParameterGroup API.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.18.4](service/verifiedpermissions/CHANGELOG.md#v1184-2024-09-30)
  * **Documentation**: Add examples for API operations in model.

# Release (2024-09-27)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.41.0](service/customerprofiles/CHANGELOG.md#v1410-2024-09-27)
  * **Feature**: Introduces optional RoleArn parameter for PutIntegration request and includes RoleArn in the response of PutIntegration, GetIntegration and ListIntegrations
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.74.0](service/quicksight/CHANGELOG.md#v1740-2024-09-27)
  * **Feature**: Adding personalization in QuickSight data stories. Admins can enable or disable personalization through QuickSight settings.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.53.3](service/securityhub/CHANGELOG.md#v1533-2024-09-27)
  * **Documentation**: Documentation updates for AWS Security Hub
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.35.0](service/sesv2/CHANGELOG.md#v1350-2024-09-27)
  * **Feature**: This release adds support for engagement tracking over Https using custom domains.

# Release (2024-09-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.7.0](service/chatbot/CHANGELOG.md#v170-2024-09-26)
  * **Feature**: Return State and StateReason fields for Chatbot Channel Configurations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.62.0](service/lambda/CHANGELOG.md#v1620-2024-09-26)
  * **Feature**: Reverting Lambda resource-based policy and block public access APIs.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.33.0](service/organizations/CHANGELOG.md#v1330-2024-09-26)
  * **Feature**: Add support for policy operations on the CHATBOT_POLICY policy type.
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.1.3](service/pcs/CHANGELOG.md#v113-2024-09-26)
  * **Documentation**: AWS PCS API documentation - Edited the description of the iamInstanceProfileArn parameter of the CreateComputeNodeGroup and UpdateComputeNodeGroup actions; edited the description of the SlurmCustomSetting data type to list the supported parameters for clusters and compute node groups.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.24.3](service/rdsdata/CHANGELOG.md#v1243-2024-09-26)
  * **Documentation**: Documentation update for RDS Data API to reflect support for Aurora MySQL Serverless v2 and Provisioned DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.161.0](service/sagemaker/CHANGELOG.md#v11610-2024-09-26)
  * **Feature**: Adding `TagPropagation` attribute to Sagemaker API

# Release (2024-09-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.43.2](service/cloudtrail/CHANGELOG.md#v1432-2024-09-25)
  * **Documentation**: Doc-only update for CloudTrail network activity events release (in preview)
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.179.1](service/ec2/CHANGELOG.md#v11791-2024-09-25)
  * **Documentation**: Updates to documentation for the transit gateway security group referencing feature.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.48.2](service/fsx/CHANGELOG.md#v1482-2024-09-25)
  * **Documentation**: Doc-only update to address Lustre S3 hard-coded names.

# Release (2024-09-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.19.0](service/bedrock/CHANGELOG.md#v1190-2024-09-24)
  * **Feature**: Add support for Cross Region Inference in Bedrock Model Evaluations.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.27.0](service/budgets/CHANGELOG.md#v1270-2024-09-24)
  * **Feature**: Releasing minor partitional endpoint updates
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.31.0](service/kinesis/CHANGELOG.md#v1310-2024-09-24)
  * **Feature**: This release includes support to add tags when creating a stream
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.14.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1140-2024-09-24)
  * **Feature**: AWS End User Messaging SMS-Voice V2 has added support for resource policies. Use the three new APIs to create, view, edit, and delete resource policies.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.160.0](service/sagemaker/CHANGELOG.md#v11600-2024-09-24)
  * **Feature**: Adding `HiddenInstanceTypes` and `HiddenSageMakerImageVersionAliases` attribute to SageMaker API

# Release (2024-09-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.26.1](service/apigateway/CHANGELOG.md#v1261-2024-09-23)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.46.0](service/athena/CHANGELOG.md#v1460-2024-09-23)
  * **Feature**: List/Get/Update/Delete/CreateDataCatalog now integrate with AWS Glue connections. Users can create a Glue connection through Athena or use a Glue connection to define their Athena federated parameters.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.21.0](service/bedrockagent/CHANGELOG.md#v1210-2024-09-23)
  * **Feature**: Amazon Bedrock Prompt Flows and Prompt Management now supports using inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.179.0](service/ec2/CHANGELOG.md#v11790-2024-09-23)
  * **Feature**: Amazon EC2 G6e instances powered by NVIDIA L40S Tensor Core GPUs are the most cost-efficient GPU instances for deploying generative AI models and the highest performance GPU instances for spatial computing workloads.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.25.0](service/emrserverless/CHANGELOG.md#v1250-2024-09-23)
  * **Feature**: This release adds support for job concurrency and queuing configuration at Application level.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.99.0](service/glue/CHANGELOG.md#v1990-2024-09-23)
  * **Feature**: Added AthenaProperties parameter to Glue Connections, allowing Athena to store service specific properties on Glue Connections.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.85.0](service/rds/CHANGELOG.md#v1850-2024-09-23)
  * **Feature**: Support ComputeRedundancy parameter in ModifyDBShardGroup API. Add DBShardGroupArn in DBShardGroup API response. Remove InvalidMaxAcuFault from CreateDBShardGroup and ModifyDBShardGroup API. Both API will throw InvalidParameterValueException for invalid ACU configuration.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.14.0](service/resourceexplorer2/CHANGELOG.md#v1140-2024-09-23)
  * **Feature**: AWS Resource Explorer released ListResources feature which allows customers to list all indexed AWS resources within a view.

# Release (2024-09-20)

## General Highlights
* **Feature**: Add tracing and metrics support to service clients.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.35.0](service/dynamodb/CHANGELOG.md#v1350-2024-09-20)
  * **Feature**: Generate and use AWS-account-based endpoints for DynamoDB requests when the account ID is available. The new endpoint URL pattern will be https://<account-id>.ddb.<region>.amazonaws.com. See the documentation for details: https://docs.aws.amazon.com/sdkref/latest/guide/feature-account-endpoints.html.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.34.0](service/neptune/CHANGELOG.md#v1340-2024-09-20)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.159.0](service/sagemaker/CHANGELOG.md#v11590-2024-09-20)
  * **Feature**: Amazon SageMaker now supports using manifest files to specify the location of uncompressed model artifacts within Model Packages
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.11.0](service/sagemakermetrics/CHANGELOG.md#v1110-2024-09-20)
  * **Feature**: This release introduces support for the SageMaker Metrics BatchGetMetrics API.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.47.0](service/workspaces/CHANGELOG.md#v1470-2024-09-20)
  * **Feature**: Releasing new ErrorCodes for SysPrep failures during ImageImport and CreateImage process

# Release (2024-09-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.3.0](service/codeconnections/CHANGELOG.md#v130-2024-09-19)
  * **Feature**: This release adds the PullRequestComment field to CreateSyncConfiguration API input, UpdateSyncConfiguration API input, GetSyncConfiguration API output and ListSyncConfiguration API output
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.97.0](service/glue/CHANGELOG.md#v1970-2024-09-19)
  * **Feature**: This change is for releasing TestConnection api SDK model
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.60.0](service/lambda/CHANGELOG.md#v1600-2024-09-19)
  * **Feature**: Tagging support for Lambda event source mapping, and code signing configuration resources.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.59.0](service/mediaconvert/CHANGELOG.md#v1590-2024-09-19)
  * **Feature**: This release provides support for additional DRM configurations per SPEKE Version 2.0.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.60.0](service/medialive/CHANGELOG.md#v1600-2024-09-19)
  * **Feature**: Adds Bandwidth Reduction Filtering for HD AVC and HEVC encodes, multiplex container settings.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.72.0](service/quicksight/CHANGELOG.md#v1720-2024-09-19)
  * **Feature**: QuickSight: 1. Add new API - ListFoldersForResource. 2. Commit mode adds visibility configuration of Apply button on multi-select controls for authors.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.158.0](service/sagemaker/CHANGELOG.md#v11580-2024-09-19)
  * **Feature**: Introduced support for G6e instance types on SageMaker Studio for JupyterLab and CodeEditor applications.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.22.0](service/workspacesweb/CHANGELOG.md#v1220-2024-09-19)
  * **Feature**: WorkSpaces Secure Browser now enables Administrators to view and manage end-user browsing sessions via Session Management APIs.

# Release (2024-09-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.41.0](service/costexplorer/CHANGELOG.md#v1410-2024-09-18)
  * **Feature**: This release extends the GetReservationPurchaseRecommendation API to support recommendations for Amazon DynamoDB reservations.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.28.0](service/directoryservice/CHANGELOG.md#v1280-2024-09-18)
  * **Feature**: Added new APIs for enabling, disabling, and describing access to the AWS Directory Service Data API
* `github.com/aws/aws-sdk-go-v2/service/directoryservicedata`: [v1.0.0](service/directoryservicedata/CHANGELOG.md#v100-2024-09-18)
  * **Release**: New AWS service client module
  * **Feature**: Added new AWS Directory Service Data API, enabling you to manage data stored in AWS Directory Service directories. This includes APIs for creating, reading, updating, and deleting directory users, groups, and group memberships.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.47.0](service/guardduty/CHANGELOG.md#v1470-2024-09-18)
  * **Feature**: Add `launchType` and `sourceIPs` fields to GuardDuty findings.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.3.0](service/mailmanager/CHANGELOG.md#v130-2024-09-18)
  * **Feature**: Introduce a new RuleSet condition evaluation, where customers can set up a StringExpression with a MimeHeader condition. This condition will perform the necessary validation based on the X-header provided by customers.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.83.2](service/rds/CHANGELOG.md#v1832-2024-09-18)
  * **Documentation**: Updates Amazon RDS documentation with information upgrading snapshots with unsupported engine versions for RDS for MySQL and RDS for PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.62.0](service/s3/CHANGELOG.md#v1620-2024-09-18)
  * **Feature**: Added SSE-KMS support for directory buckets.

# Release (2024-09-17)

## General Highlights
* **Bug Fix**: **BREAKFIX**: Only generate AccountIDEndpointMode config for services that use it. This is a compiler break, but removes no actual functionality, as no services currently use the account ID in endpoint resolution.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.43.0](service/codebuild/CHANGELOG.md#v1430-2024-09-17)
  * **Feature**: GitLab Enhancements - Add support for Self-Hosted GitLab runners in CodeBuild. Add group webhooks
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.34.0](service/ecr/CHANGELOG.md#v1340-2024-09-17)
  * **Feature**: The `DescribeImageScanning` API now includes `fixAvailable`, `exploitAvailable`, and `fixedInVersion` fields to provide more detailed information about the availability of fixes, exploits, and fixed versions for identified image vulnerabilities.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.45.5](service/ecs/CHANGELOG.md#v1455-2024-09-17)
  * **Documentation**: This is a documentation only release to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.59.0](service/lambda/CHANGELOG.md#v1590-2024-09-17)
  * **Feature**: Support for JSON resource-based policies and block public access
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.83.1](service/rds/CHANGELOG.md#v1831-2024-09-17)
  * **Documentation**: Updates Amazon RDS documentation with configuration information about the BYOL model for RDS for Db2.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.53.0](service/ssm/CHANGELOG.md#v1530-2024-09-17)
  * **Feature**: Support for additional levels of cross-account, cross-Region organizational units in Automation. Various documentation updates.

# Release (2024-09-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.27.34](config/CHANGELOG.md#v12734-2024-09-16)
  * **Bug Fix**: Read `AWS_CONTAINER_CREDENTIALS_FULL_URI` env variable if set when reading a profile with `credential_source`. Also ensure `AWS_CONTAINER_CREDENTIALS_RELATIVE_URI` is always read before it
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.17.0](service/bedrock/CHANGELOG.md#v1170-2024-09-16)
  * **Feature**: This feature adds cross account s3 bucket and VPC support to ModelInvocation jobs. To use a cross account bucket, pass in the accountId of the bucket to s3BucketOwner in the ModelInvocationJobInputDataConfig or ModelInvocationJobOutputDataConfig.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.56.0](service/iot/CHANGELOG.md#v1560-2024-09-16)
  * **Feature**: This release adds additional enhancements to AWS IoT Device Management Software Package Catalog and Jobs. It also adds SBOM support in Software Package Version.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.59.0](service/medialive/CHANGELOG.md#v1590-2024-09-16)
  * **Feature**: Removing the ON_PREMISE enum from the input settings field.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.31.3](service/organizations/CHANGELOG.md#v1313-2024-09-16)
  * **Documentation**: Doc only update for AWS Organizations that fixes several customer-reported issues
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep`: [v1.2.7](service/pcaconnectorscep/CHANGELOG.md#v127-2024-09-16)
  * **Documentation**: This is a general availability (GA) release of Connector for SCEP, a feature of AWS Private CA. Connector for SCEP links your SCEP-enabled and mobile device management systems to AWS Private CA for digital signature installation and certificate management.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.83.0](service/rds/CHANGELOG.md#v1830-2024-09-16)
  * **Feature**: Launching Global Cluster tagging.

# Release (2024-09-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.24.4](service/amplify/CHANGELOG.md#v1244-2024-09-13)
  * **Documentation**: Doc only update to Amplify to explain platform setting for Next.js 14 SSG only applications
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.38.4](service/ivs/CHANGELOG.md#v1384-2024-09-13)
  * **Documentation**: Updates to all tags descriptions.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.14.8](service/ivschat/CHANGELOG.md#v1148-2024-09-13)
  * **Documentation**: Updates to all tags descriptions.

# Release (2024-09-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.44.0](service/cognitoidentityprovider/CHANGELOG.md#v1440-2024-09-12)
  * **Feature**: Added email MFA option to user pools with advanced security features.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.37.0](service/elasticloadbalancingv2/CHANGELOG.md#v1370-2024-09-12)
  * **Feature**: Correct incorrectly mapped error in ELBv2 waiters
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.43.0](service/emr/CHANGELOG.md#v1430-2024-09-12)
  * **Feature**: Update APIs to allow modification of ODCR options, allocation strategy, and InstanceTypeConfigs on running InstanceFleet clusters.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.96.0](service/glue/CHANGELOG.md#v1960-2024-09-12)
  * **Feature**: AWS Glue is introducing two new optimizers for Apache Iceberg tables: snapshot retention and orphan file deletion. Customers can enable these optimizers and customize their configurations to perform daily maintenance tasks on their Iceberg tables based on their specific requirements.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.58.0](service/mediaconvert/CHANGELOG.md#v1580-2024-09-12)
  * **Feature**: This release includes support for dynamic video overlay workflows, including picture-in-picture and squeezeback
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.82.5](service/rds/CHANGELOG.md#v1825-2024-09-12)
  * **Documentation**: This release adds support for the os-upgrade pending maintenance action for Amazon Aurora DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.32.0](service/storagegateway/CHANGELOG.md#v1320-2024-09-12)
  * **Feature**: The S3 File Gateway now supports DSSE-KMS encryption. A new parameter EncryptionType is added to these APIs: CreateSmbFileShare, CreateNfsFileShare, UpdateSmbFileShare, UpdateNfsFileShare, DescribeSmbFileShares, DescribeNfsFileShares. Also, in favor of EncryptionType, KmsEncrypted is deprecated.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.27.0](service/synthetics/CHANGELOG.md#v1270-2024-09-12)
  * **Feature**: This release introduces two features. The first is tag replication, which allows for the propagation of canary tags onto Synthetics related resources, such as Lambda functions. The second is a limit increase in canary name length, which has now been increased from 21 to 255 characters.

# Release (2024-09-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.19.0](service/bedrockagent/CHANGELOG.md#v1190-2024-09-11)
  * **Feature**: Amazon Bedrock Knowledge Bases now supports using inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.19.0](service/bedrockagentruntime/CHANGELOG.md#v1190-2024-09-11)
  * **Feature**: Amazon Bedrock Knowledge Bases now supports using inference profiles to increase throughput and improve resilience.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.33.0](service/ecr/CHANGELOG.md#v1330-2024-09-11)
  * **Feature**: Added KMS_DSSE to EncryptionType
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.46.0](service/guardduty/CHANGELOG.md#v1460-2024-09-11)
  * **Feature**: Add support for new statistic types in GetFindingsStatistics.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.47.0](service/lexmodelsv2/CHANGELOG.md#v1470-2024-09-11)
  * **Feature**: Support new Polly voice engines in VoiceSettings: long-form and generative
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.58.0](service/medialive/CHANGELOG.md#v1580-2024-09-11)
  * **Feature**: Adds AV1 Codec support, SRT ouputs, and MediaLive Anywhere support.

# Release (2024-09-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.17.7](service/chimesdkvoice/CHANGELOG.md#v1177-2024-09-10)
  * **Documentation**: Documentation-only update that clarifies the ValidateE911Address action of the Amazon Chime SDK Voice APIs.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.15.0](service/pipes/CHANGELOG.md#v1150-2024-09-10)
  * **Feature**: This release adds support for customer managed KMS keys in Amazon EventBridge Pipe
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.52.3](service/securityhub/CHANGELOG.md#v1523-2024-09-10)
  * **Documentation**: Documentation update for Security Hub

# Release (2024-09-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.34.9](service/dynamodb/CHANGELOG.md#v1349-2024-09-09)
  * **Documentation**: Doc-only update for DynamoDB. Added information about async behavior for TagResource and UntagResource APIs and updated the description of ResourceInUseException.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.36.0](service/elasticloadbalancingv2/CHANGELOG.md#v1360-2024-09-09)
  * **Feature**: Add paginators for the ELBv2 DescribeListenerCertificates and DescribeRules APIs. Fix broken waiter for the ELBv2 DescribeLoadBalancers API.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.17.0](service/ivsrealtime/CHANGELOG.md#v1170-2024-09-09)
  * **Feature**: IVS Real-Time now offers customers the ability to broadcast to Stages using RTMP(S).
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.36.0](service/kafka/CHANGELOG.md#v1360-2024-09-09)
  * **Feature**: Amazon MSK Replicator can now replicate data to identically named topics between MSK clusters within the same AWS Region or across different AWS Regions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.157.0](service/sagemaker/CHANGELOG.md#v11570-2024-09-09)
  * **Feature**: Amazon Sagemaker supports orchestrating SageMaker HyperPod clusters with Amazon EKS
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.30.0](service/sagemakerruntime/CHANGELOG.md#v1300-2024-09-09)
  * **Feature**: AWS SageMaker Runtime feature: Add sticky routing to support stateful inference models.

# Release (2024-09-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.1.0](service/qapps/CHANGELOG.md#v110-2024-09-06)
  * **Feature**: Adds UpdateLibraryItemMetadata api to change status of app for admin verification feature and returns isVerified field in any api returning the app or library item.

# Release (2024-09-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.4.0](service/applicationsignals/CHANGELOG.md#v140-2024-09-05)
  * **Feature**: Amazon CloudWatch Application Signals now supports creating Service Level Objectives using a new calculation type. Users can now create SLOs which are configured with request-based SLIs to help meet their specific business requirements.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.31.4](service/codepipeline/CHANGELOG.md#v1314-2024-09-05)
  * **Documentation**: Updates to add recent notes to APIs and to replace example S3 bucket names globally.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.109.0](service/connect/CHANGELOG.md#v11090-2024-09-05)
  * **Feature**: Amazon Connect Custom Vocabulary now supports Catalan (Spain), Danish (Denmark), Dutch (Netherlands), Finnish (Finland), Indonesian (Indonesia), Malay (Malaysia), Norwegian Bokmal (Norway), Polish (Poland), Swedish (Sweden), and Tagalog/Filipino (Philippines).
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.34.0](service/gamelift/CHANGELOG.md#v1340-2024-09-05)
  * **Feature**: Amazon GameLift provides additional events for tracking the fleet creation process.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.29.0](service/kinesisanalyticsv2/CHANGELOG.md#v1290-2024-09-05)
  * **Feature**: Support for Flink 1.20 in Managed Service for Apache Flink
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.156.0](service/sagemaker/CHANGELOG.md#v11560-2024-09-05)
  * **Feature**: Amazon SageMaker now supports idle shutdown of JupyterLab and CodeEditor applications on SageMaker Studio.

# Release (2024-09-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.36.0](service/appsync/CHANGELOG.md#v1360-2024-09-04)
  * **Feature**: Adds new logging levels (INFO and DEBUG) for additional log output control
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.18.0](service/bedrockagent/CHANGELOG.md#v1180-2024-09-04)
  * **Feature**: Add support for user metadata inside PromptVariant.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.39.0](service/cloudwatchlogs/CHANGELOG.md#v1390-2024-09-04)
  * **Feature**: Update to support new APIs for delivery of logs from AWS services.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.26.6](service/finspace/CHANGELOG.md#v1266-2024-09-04)
  * **Documentation**: Updates Finspace documentation for smaller instances.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.28.0](service/fis/CHANGELOG.md#v1280-2024-09-04)
  * **Feature**: This release adds safety levers, a new mechanism to stop all running experiments and prevent new experiments from starting.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.47.0](service/s3control/CHANGELOG.md#v1470-2024-09-04)
  * **Feature**: Amazon Simple Storage Service /S3 Access Grants / Features : This release launches new Access Grants API - ListCallerAccessGrants.

# Release (2024-09-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.5
  * **Bug Fix**: Change requestPayer behaviour from signedHeader to hoisted query parameter 
  * **Bug Fix**: refactoring of buildQuery to accept a map of hand maintained headers to lowercase because of an S3 limitation
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.108.0](service/connect/CHANGELOG.md#v11080-2024-09-03)
  * **Feature**: Release ReplicaConfiguration as part of DescribeInstance
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.20.0](service/datazone/CHANGELOG.md#v1200-2024-09-03)
  * **Feature**: Add support to let data publisher specify a subset of the data asset that a subscriber will have access to based on the asset filters provided, when accepting a subscription request.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.35.0](service/elasticloadbalancingv2/CHANGELOG.md#v1350-2024-09-03)
  * **Feature**: This release adds support for configuring TCP idle timeout on NLB and GWLB listeners.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.33.0](service/mediaconnect/CHANGELOG.md#v1330-2024-09-03)
  * **Feature**: AWS Elemental MediaConnect introduces thumbnails for Flow source monitoring. Thumbnails provide still image previews of the live content feeding your MediaConnect Flow allowing you to easily verify that your source is operating as expected.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.57.0](service/medialive/CHANGELOG.md#v1570-2024-09-03)
  * **Feature**: Added MinQP as a Rate Control option for H264 and H265 encodes.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.155.0](service/sagemaker/CHANGELOG.md#v11550-2024-09-03)
  * **Feature**: Amazon SageMaker now supports automatic mounting of a user's home folder in the Amazon Elastic File System (EFS) associated with the SageMaker Studio domain to their Studio Spaces to enable users to share data between their own private spaces.
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.3.0](service/timestreaminfluxdb/CHANGELOG.md#v130-2024-09-03)
  * **Feature**: Timestream for InfluxDB now supports compute scaling and deployment type conversion. This release adds the DbInstanceType and DeploymentType parameters to the UpdateDbInstance API.

# Release (2024-08-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.37.0](service/backup/CHANGELOG.md#v1370-2024-08-30)
  * **Feature**: The latest update introduces two new attributes, VaultType and VaultState, to the DescribeBackupVault and ListBackupVaults APIs. The VaultState attribute reflects the current status of the vault, while the VaultType attribute indicates the specific category of the vault.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.38.0](service/cloudwatchlogs/CHANGELOG.md#v1380-2024-08-30)
  * **Feature**: This release introduces a new optional parameter: Entity, in PutLogEvents request
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.19.0](service/datazone/CHANGELOG.md#v1190-2024-08-30)
  * **Feature**: Amazon DataZone now adds new governance capabilities of Domain Units for organization within your Data Domains, and Authorization Policies for tighter controls.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.28.0](service/redshiftdata/CHANGELOG.md#v1280-2024-08-30)
  * **Feature**: The release include the new Redshift DataAPI feature for session use, customer execute query with --session-keep-alive-seconds parameter and can submit follow-up queries to same sessions with returned`session-id`
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.34.6](service/sqs/CHANGELOG.md#v1346-2024-08-30)
  * **Bug Fix**: Fix issue where SDK could not send a VisibilityTimeout of 0 in a ChangeMessageVisibilityBatchRequestEntry.

# Release (2024-08-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.18.0](service/bedrockagentruntime/CHANGELOG.md#v1180-2024-08-29)
  * **Feature**: Lifting the maximum length on Bedrock KnowledgeBase RetrievalFilter array
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.16.0](service/bedrockruntime/CHANGELOG.md#v1160-2024-08-29)
  * **Feature**: Add support for imported-model in invokeModel and InvokeModelWithResponseStream.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.37.0](service/personalize/CHANGELOG.md#v1370-2024-08-29)
  * **Feature**: This releases ability to update automatic training scheduler for customer solutions
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.71.0](service/quicksight/CHANGELOG.md#v1710-2024-08-29)
  * **Feature**: Increased Character Limit for Dataset Calculation Field expressions
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.31.0](service/sfn/CHANGELOG.md#v1310-2024-08-29)
  * **Feature**: This release adds support for static analysis to ValidateStateMachineDefinition API, which can now return optional WARNING diagnostics for semantic errors on the definition of an Amazon States Language (ASL) state machine.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.52.0](service/wafv2/CHANGELOG.md#v1520-2024-08-29)
  * **Feature**: The minimum request rate for a rate-based rule is now 10. Before this, it was 100.

# Release (2024-08-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.32.0](service/appconfig/CHANGELOG.md#v1320-2024-08-28)
  * **Feature**: This release adds support for deletion protection, which is a safety guardrail to prevent the unintentional deletion of a recently used AWS AppConfig Configuration Profile or Environment. This also includes a change to increase the maximum length of the Name parameter in UpdateConfigurationProfile.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.18.0](service/datazone/CHANGELOG.md#v1180-2024-08-28)
  * **Feature**: Update regex to include dot character to be consistent with IAM role creation in the authorized principal field for create and update subscription target.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.26.0](service/devicefarm/CHANGELOG.md#v1260-2024-08-28)
  * **Feature**: This release removed support for Calabash, UI Automation, Built-in Explorer, remote access record, remote access replay, and web performance profile framework in ScheduleRun API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.177.0](service/ec2/CHANGELOG.md#v11770-2024-08-28)
  * **Feature**: Amazon VPC IP Address Manager (IPAM) now allows customers to provision IPv4 CIDR blocks and allocate Elastic IP Addresses directly from IPAM pools with public IPv4 space
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.17.0](service/internetmonitor/CHANGELOG.md#v1170-2024-08-28)
  * **Feature**: Adds new querying types to show overall traffic suggestion information for monitors
* `github.com/aws/aws-sdk-go-v2/service/pcs`: [v1.0.0](service/pcs/CHANGELOG.md#v100-2024-08-28)
  * **Release**: New AWS service client module
  * **Feature**: Introducing AWS Parallel Computing Service (AWS PCS), a new service makes it easy to setup and manage high performance computing (HPC) clusters, and build scientific and engineering models at virtually any scale on AWS.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.61.0](service/s3/CHANGELOG.md#v1610-2024-08-28)
  * **Feature**: Add presignPost for s3 PutObject
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.46.1](service/workspaces/CHANGELOG.md#v1461-2024-08-28)
  * **Documentation**: Documentation-only update that clarifies the StartWorkspaces and StopWorkspaces actions, and a few other minor edits.

# Release (2024-08-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.16.0](service/bedrock/CHANGELOG.md#v1160-2024-08-27)
  * **Feature**: Amazon Bedrock SDK updates for Inference Profile.
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.5.0](service/chatbot/CHANGELOG.md#v150-2024-08-27)
  * **Feature**: Update documentation to be consistent with the API docs
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.24.0](service/omics/CHANGELOG.md#v1240-2024-08-27)
  * **Feature**: Adds data provenance to import jobs from read sets and references
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.43.0](service/polly/CHANGELOG.md#v1430-2024-08-27)
  * **Feature**: Amazon Polly adds 2 new voices: Jitka (cs-CZ) and Sabrina (de-CH).

# Release (2024-08-26)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/credentials`: [v1.17.30](credentials/CHANGELOG.md#v11730-2024-08-26)
  * **Bug Fix**: Save SSO cached token expiry in UTC to ensure cross-SDK compatibility.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.15.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1150-2024-08-26)
  * **Feature**: Add Encoder option to obey omitempty tag for NULL attribute values.
* `github.com/aws/aws-sdk-go-v2/feature/dynamodbstreams/attributevalue`: [v1.14.0](feature/dynamodbstreams/attributevalue/CHANGELOG.md#v1140-2024-08-26)
  * **Feature**: Add Encoder option to obey omitempty tag for NULL attribute values.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.41.0](service/iotsitewise/CHANGELOG.md#v1410-2024-08-26)
  * **Feature**: AWS IoT SiteWise now supports versioning for asset models. It enables users to retrieve active version of their asset model and perform asset model writes with optimistic lock.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.46.0](service/workspaces/CHANGELOG.md#v1460-2024-08-26)
  * **Feature**: This release adds support for creating and managing directories that use AWS IAM Identity Center as user identity source. Such directories can be used to create non-Active Directory domain joined WorkSpaces Personal.Updated RegisterWorkspaceDirectory and DescribeWorkspaceDirectories APIs.

# Release (2024-08-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.27.30](config/CHANGELOG.md#v12730-2024-08-23)
  * **Bug Fix**: Don't fail credentials unit tests if credentials are found on a file
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.17.0](service/bedrockagent/CHANGELOG.md#v1170-2024-08-23)
  * **Feature**: Releasing the support for Action User Confirmation.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.17.0](service/bedrockagentruntime/CHANGELOG.md#v1170-2024-08-23)
  * **Feature**: Releasing the support for Action User Confirmation.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.42.1](service/codebuild/CHANGELOG.md#v1421-2024-08-23)
  * **Documentation**: Added support for the MAC_ARM environment type for CodeBuild fleets.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.31.0](service/organizations/CHANGELOG.md#v1310-2024-08-23)
  * **Feature**: Releasing minor partitional endpoint updates.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.11.0](service/qbusiness/CHANGELOG.md#v1110-2024-08-23)
  * **Feature**: Amazon QBusiness: Enable support for SAML and OIDC federation through AWS IAM Identity Provider integration.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.5.5](service/supplychain/CHANGELOG.md#v155-2024-08-23)
  * **Documentation**: Update API documentation to clarify the event SLA as well as the data model expectations

# Release (2024-08-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.43.5](service/autoscaling/CHANGELOG.md#v1435-2024-08-22)
  * **Documentation**: Amazon EC2 Auto Scaling now provides EBS health check to manage EC2 instance replacement
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.15.0](service/bedrock/CHANGELOG.md#v1150-2024-08-22)
  * **Feature**: Amazon Bedrock Evaluation BatchDeleteEvaluationJob API allows customers to delete evaluation jobs under terminated evaluation job statuses - Stopped, Failed, or Completed. Customers can submit a batch of 25 evaluation jobs to be deleted at once.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.31.0](service/emrcontainers/CHANGELOG.md#v1310-2024-08-22)
  * **Feature**: Correct endpoint for FIPS is configured for US Gov Regions.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.30.0](service/inspector2/CHANGELOG.md#v1300-2024-08-22)
  * **Feature**: Add enums for Agentless scan statuses and EC2 enablement error states
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.70.0](service/quicksight/CHANGELOG.md#v1700-2024-08-22)
  * **Feature**: Explicit query for authors and dashboard viewing sharing for embedded users
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.43.0](service/route53/CHANGELOG.md#v1430-2024-08-22)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (Malaysia) Region (ap-southeast-5) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

# Release (2024-08-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.176.0](service/ec2/CHANGELOG.md#v11760-2024-08-21)
  * **Feature**: DescribeInstanceStatus now returns health information on EBS volumes attached to Nitro instances
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.95.0](service/glue/CHANGELOG.md#v1950-2024-08-21)
  * **Feature**: Add optional field JobRunQueuingEnabled to CreateJob and UpdateJob APIs.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.58.0](service/lambda/CHANGELOG.md#v1580-2024-08-21)
  * **Feature**: Release FilterCriteria encryption for Lambda EventSourceMapping,  enabling customers to encrypt their filter criteria using a customer-owned KMS key.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.52.0](service/securityhub/CHANGELOG.md#v1520-2024-08-21)
  * **Feature**: Security Hub documentation and definition updates
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.26.0](service/ses/CHANGELOG.md#v1260-2024-08-21)
  * **Feature**: Enable email receiving customers to provide SES with access to their S3 buckets via an IAM role for "Deliver to S3 Action"

# Release (2024-08-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.45.1](service/ecs/CHANGELOG.md#v1451-2024-08-20)
  * **Documentation**: Documentation only release to address various tickets
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.14.0](service/opensearchserverless/CHANGELOG.md#v1140-2024-08-20)
  * **Feature**: Added FailureCode and FailureMessage to BatchGetCollectionResponse for BatchGetVPCEResponse for non-Active Collection and VPCE.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.60.0](service/s3/CHANGELOG.md#v1600-2024-08-20)
  * **Feature**: Amazon Simple Storage Service / Features : Add support for conditional writes for PutObject and CompleteMultipartUpload APIs.

# Release (2024-08-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.14.0](service/bedrock/CHANGELOG.md#v1140-2024-08-19)
  * **Feature**: Amazon Bedrock Batch Inference/ Model Invocation is a feature which allows customers to asynchronously run inference on a large set of records/files stored in S3.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.42.0](service/codebuild/CHANGELOG.md#v1420-2024-08-19)
  * **Feature**: AWS CodeBuild now supports creating fleets with macOS platform for running builds.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.3.0](service/deadline/CHANGELOG.md#v130-2024-08-19)
  * **Feature**: This release adds additional search fields and provides sorting by multiple fields.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.57.0](service/lambda/CHANGELOG.md#v1570-2024-08-19)
  * **Feature**: Release Lambda FunctionRecursiveConfig, enabling customers to turn recursive loop detection on or off on individual functions. This release adds two new APIs, GetFunctionRecursionConfig and PutFunctionRecursionConfig.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.16.0](service/ssmsap/CHANGELOG.md#v1160-2024-08-19)
  * **Feature**: Add new attributes to the outputs of GetApplication and GetDatabase APIs.

# Release (2024-08-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.44.0](service/batch/CHANGELOG.md#v1440-2024-08-16)
  * **Feature**: Improvements of integration between AWS Batch and EC2.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.29.0](service/inspector2/CHANGELOG.md#v1290-2024-08-16)
  * **Feature**: Update the correct format of key and values for resource tags
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.69.0](service/quicksight/CHANGELOG.md#v1690-2024-08-16)
  * **Feature**: Amazon QuickSight launches Customer Managed Key (CMK) encryption for Data Source metadata
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.154.0](service/sagemaker/CHANGELOG.md#v11540-2024-08-16)
  * **Feature**: Introduce Endpoint and EndpointConfig Arns in sagemaker:ListPipelineExecutionSteps API response
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.33.0](service/sesv2/CHANGELOG.md#v1330-2024-08-16)
  * **Feature**: Marking use case description field of account details as deprecated.

# Release (2024-08-15)

## General Highlights
* **Dependency Update**: Bump minimum Go version to 1.21.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.37.0](service/docdb/CHANGELOG.md#v1370-2024-08-15)
  * **Feature**: This release adds Global Cluster Failover capability which enables you to change your global cluster's primary AWS region, the region that serves writes, during a regional outage. Performing a failover action preserves your Global Cluster setup.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.45.0](service/ecs/CHANGELOG.md#v1450-2024-08-15)
  * **Feature**: This release introduces a new ContainerDefinition configuration to support the customer-managed keys for ECS container restart feature.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.35.0](service/iam/CHANGELOG.md#v1350-2024-08-15)
  * **Feature**: Make the LastUsedDate field in the GetAccessKeyLastUsed response optional. This may break customers who only call the API for access keys with a valid LastUsedDate. This fixes a deserialization issue for access keys without a LastUsedDate, because the field was marked as required but could be null.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.59.0](service/s3/CHANGELOG.md#v1590-2024-08-15)
  * **Feature**: Amazon Simple Storage Service / Features  : Adds support for pagination in the S3 ListBuckets API.

# Release (2024-08-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.41.0](service/codebuild/CHANGELOG.md#v1410-2024-08-14)
  * **Feature**: AWS CodeBuild now supports using Secrets Manager to store git credentials and using multiple source credentials in a single project.

# Release (2024-08-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.24.0](service/amplify/CHANGELOG.md#v1240-2024-08-13)
  * **Feature**: Add a new field "cacheConfig" that enables users to configure the CDN cache settings for an App
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.38.0](service/appstream/CHANGELOG.md#v1380-2024-08-13)
  * **Feature**: This release includes following new APIs: CreateThemeForStack, DescribeThemeForStack, UpdateThemeForStack, DeleteThemeForStack to support custom branding programmatically.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.27.0](service/fis/CHANGELOG.md#v1270-2024-08-13)
  * **Feature**: This release adds support for additional error information on experiment failure. It adds the error code, location, and account id on relevant failures to the GetExperiment and ListExperiment API responses.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.94.0](service/glue/CHANGELOG.md#v1940-2024-08-13)
  * **Feature**: Add AttributesToGet parameter support for Glue GetTables
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.11.0](service/neptunegraph/CHANGELOG.md#v1110-2024-08-13)
  * **Feature**: Amazon Neptune Analytics provides a new option for customers to load data into a graph using the RDF (Resource Description Framework) NTRIPLES format. When loading NTRIPLES files, use the value `convertToIri` for the `blankNodeHandling` parameter.

# Release (2024-08-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.37.4](service/computeoptimizer/CHANGELOG.md#v1374-2024-08-12)
  * **Documentation**: Doc only update for Compute Optimizer that fixes several customer-reported issues relating to ECS finding classifications
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.175.0](service/ec2/CHANGELOG.md#v11750-2024-08-12)
  * **Feature**: This release adds new capabilities to manage On-Demand Capacity Reservations including the ability to split your reservation, move capacity between reservations, and modify the instance eligibility of your reservation.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.48.0](service/eks/CHANGELOG.md#v1480-2024-08-12)
  * **Feature**: Added support for new AL2023 GPU AMIs to the supported AMITypes.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.29.4](service/groundstation/CHANGELOG.md#v1294-2024-08-12)
  * **Documentation**: Updating documentation for OEMEphemeris to link to AWS Ground Station User Guide
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.56.0](service/medialive/CHANGELOG.md#v1560-2024-08-12)
  * **Feature**: AWS Elemental MediaLive now supports now supports editing the PID values for a Multiplex.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.153.0](service/sagemaker/CHANGELOG.md#v11530-2024-08-12)
  * **Feature**: Releasing large data support as part of CreateAutoMLJobV2 in SageMaker Autopilot and CreateDomain API for SageMaker Canvas.

# Release (2024-08-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.43.1](service/cognitoidentityprovider/CHANGELOG.md#v1431-2024-08-09)
  * **Documentation**: Fixed a description of AdvancedSecurityAdditionalFlows in Amazon Cognito user pool configuration.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.107.0](service/connect/CHANGELOG.md#v11070-2024-08-09)
  * **Feature**: This release supports adding RoutingCriteria via UpdateContactRoutingData public API.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.52.4](service/ssm/CHANGELOG.md#v1524-2024-08-09)
  * **Documentation**: Systems Manager doc-only updates for August 2024.

# Release (2024-08-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.43.0](service/cognitoidentityprovider/CHANGELOG.md#v1430-2024-08-08)
  * **Feature**: Added support for threat protection for custom authentication in Amazon Cognito user pools.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.174.0](service/ec2/CHANGELOG.md#v11740-2024-08-08)
  * **Feature**: Launch of private IPv6 addressing for VPCs and Subnets. VPC IPAM supports the planning and monitoring of private IPv6 usage.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.93.0](service/glue/CHANGELOG.md#v1930-2024-08-08)
  * **Feature**: This release adds support to retrieve the validation status when creating or updating Glue Data Catalog Views. Also added is support for BasicCatalogTarget partition keys.

# Release (2024-08-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.28.0](service/appintegrations/CHANGELOG.md#v1280-2024-08-07)
  * **Feature**: Updated CreateDataIntegration and CreateDataIntegrationAssociation API to support bulk data export from Amazon Connect Customer Profiles to the customer S3 bucket.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.92.0](service/glue/CHANGELOG.md#v1920-2024-08-07)
  * **Feature**: Introducing AWS Glue Data Quality anomaly detection, a new functionality that uses ML-based solutions to detect data anomalies users have not explicitly defined rules for.

# Release (2024-08-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.16.0](service/bedrockagentruntime/CHANGELOG.md#v1160-2024-08-06)
  * **Feature**: Introduce model invocation output traces for orchestration traces, which contain the model's raw response and usage.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.42.0](service/cognitoidentityprovider/CHANGELOG.md#v1420-2024-08-06)
  * **Feature**: Advanced security feature updates to include password history and log export for Cognito user pools.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.8.0](service/costoptimizationhub/CHANGELOG.md#v180-2024-08-06)
  * **Feature**: This release adds savings percentage support to the ListRecommendationSummaries API.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.45.0](service/workspaces/CHANGELOG.md#v1450-2024-08-06)
  * **Feature**: Added support for BYOL_GRAPHICS_G4DN_WSP IngestionProcess

# Release (2024-08-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.17.0](service/datazone/CHANGELOG.md#v1170-2024-08-05)
  * **Feature**: This releases Data Product feature. Data Products allow grouping data assets into cohesive, self-contained units for ease of publishing for data producers, and ease of finding and accessing for data consumers.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.32.0](service/ecr/CHANGELOG.md#v1320-2024-08-05)
  * **Feature**: Released two new APIs along with documentation updates. The GetAccountSetting API is used to view the current basic scan type version setting for your registry, while the PutAccountSetting API is used to update the basic scan type version for your registry.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.12.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v1120-2024-08-05)
  * **Feature**: Add JoinStorageSessionAsViewer API
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.27.5](service/pi/CHANGELOG.md#v1275-2024-08-05)
  * **Documentation**: Added a description for the Dimension db.sql.tokenized_id on the DimensionGroup data type page.

# Release (2024-08-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.24.0](service/resiliencehub/CHANGELOG.md#v1240-2024-08-02)
  * **Feature**: Customers are presented with the grouping recommendations and can determine if the recommendations are accurate and apply to their case. This feature simplifies onboarding by organizing resources into appropriate AppComponents.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.58.3](service/s3/CHANGELOG.md#v1583-2024-08-02)
  * **Bug Fix**: Add assurance tests for auth scheme selection logic.

# Release (2024-08-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.13.0](service/bedrock/CHANGELOG.md#v1130-2024-08-01)
  * **Feature**: API and Documentation for Bedrock Model Copy feature. This feature lets you share and copy a custom model from one region to another or one account to another.
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.3.0](service/controlcatalog/CHANGELOG.md#v130-2024-08-01)
  * **Feature**: AWS Control Tower provides two new public APIs controlcatalog:ListControls and controlcatalog:GetControl under controlcatalog service namespace, which enable customers to programmatically retrieve control metadata of available controls.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.16.4](service/controltower/CHANGELOG.md#v1164-2024-08-01)
  * **Documentation**: Updated Control Tower service documentation for controlcatalog control ARN support with existing Control Tower public APIs
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.21.5](service/memorydb/CHANGELOG.md#v1215-2024-08-01)
  * **Documentation**: Doc only update for changes to deletion API.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.82.0](service/rds/CHANGELOG.md#v1820-2024-08-01)
  * **Feature**: This release adds support for specifying optional MinACU parameter in CreateDBShardGroup and ModifyDBShardGroup API. DBShardGroup response will contain MinACU if specified.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.152.0](service/sagemaker/CHANGELOG.md#v11520-2024-08-01)
  * **Feature**: This release adds support for Amazon EMR Serverless applications in SageMaker Studio for running data processing jobs.
* `github.com/aws/aws-sdk-go-v2/service/ssmquicksetup`: [v1.0.0](service/ssmquicksetup/CHANGELOG.md#v100-2024-08-01)
  * **Release**: New AWS service client module
  * **Feature**: This release adds API support for the QuickSetup feature of AWS Systems Manager
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.24.4](service/support/CHANGELOG.md#v1244-2024-08-01)
  * **Documentation**: Doc only updates to CaseDetails

# Release (2024-07-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.37.0](service/appstream/CHANGELOG.md#v1370-2024-07-30)
  * **Feature**: Added support for Red Hat Enterprise Linux 8 on Amazon AppStream 2.0
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.31.0](service/codepipeline/CHANGELOG.md#v1310-2024-07-30)
  * **Feature**: AWS CodePipeline V2 type pipelines now support stage level conditions to enable development teams to safely release changes that meet quality and compliance requirements.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.40.5](service/elasticache/CHANGELOG.md#v1405-2024-07-30)
  * **Documentation**: Doc only update for changes to deletion API.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.46.0](service/lexmodelsv2/CHANGELOG.md#v1460-2024-07-30)
  * **Feature**: This release adds new capabilities to the AMAZON.QnAIntent: Custom prompting, Guardrails integration and ExactResponse support for Bedrock Knowledge Base.
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.14.0](service/rolesanywhere/CHANGELOG.md#v1140-2024-07-30)
  * **Feature**: IAM RolesAnywhere now supports custom role session name on the CreateSession. This release adds the acceptRoleSessionName option to a profile to control whether a role session name will be accepted in a session request with a given profile.
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.11.0](service/tnb/CHANGELOG.md#v1110-2024-07-30)
  * **Feature**: This release adds Network Service Update, through which customers will be able to update their instantiated networks to a new network package. See the documentation for limitations. The release also enhances the Get network operation API to return parameter overrides used during the operation.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.44.3](service/workspaces/CHANGELOG.md#v1443-2024-07-30)
  * **Documentation**: Removing multi-session as it isn't supported for pools

# Release (2024-07-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.40.4](service/elasticache/CHANGELOG.md#v1404-2024-07-29)
  * **Documentation**: Renaming full service name as it appears in developer documentation.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.21.4](service/memorydb/CHANGELOG.md#v1214-2024-07-29)
  * **Documentation**: Renaming full service name as it appears in developer documentation.

# Release (2024-07-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.31.0](service/applicationautoscaling/CHANGELOG.md#v1310-2024-07-25)
  * **Feature**: Application Auto Scaling is now more responsive to the changes in demand of your SageMaker Inference endpoints. To get started, create or update a Target Tracking policy based on High Resolution CloudWatch metrics.
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.3.0](service/applicationsignals/CHANGELOG.md#v130-2024-07-25)
  * **Feature**: CloudWatch Application Signals now supports application logs correlation with traces and operational health metrics of applications running on EC2 instances. Users can view the most relevant telemetry to troubleshoot application health anomalies such as spikes in latency, errors, and availability.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.15.0](service/bedrockruntime/CHANGELOG.md#v1150-2024-07-25)
  * **Feature**: Provides ServiceUnavailableException error message
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.25.0](service/codecommit/CHANGELOG.md#v1250-2024-07-25)
  * **Feature**: CreateRepository API now throws OperationNotAllowedException when the account has been restricted from creating a repository.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.16.0](service/datazone/CHANGELOG.md#v1160-2024-07-25)
  * **Feature**: Introduces GetEnvironmentCredentials operation to SDK
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.173.0](service/ec2/CHANGELOG.md#v11730-2024-07-25)
  * **Feature**: EC2 Fleet now supports using custom identifiers to reference Amazon Machine Images (AMI) in launch requests that are configured to choose from a diversified list of instance types.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.31.0](service/ecr/CHANGELOG.md#v1310-2024-07-25)
  * **Feature**: API and documentation updates for Amazon ECR, adding support for creating, updating, describing and deleting ECR Repository Creation Template.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.47.0](service/eks/CHANGELOG.md#v1470-2024-07-25)
  * **Feature**: This release adds support for EKS cluster to manage extended support.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.34.0](service/elasticloadbalancingv2/CHANGELOG.md#v1340-2024-07-25)
  * **Feature**: This release adds support for sharing trust stores across accounts and organizations through integration with AWS Resource Access Manager.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.41.0](service/networkfirewall/CHANGELOG.md#v1410-2024-07-25)
  * **Feature**: You can now log events that are related to TLS inspection, in addition to the existing alert and flow logging.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.42.0](service/outposts/CHANGELOG.md#v1420-2024-07-25)
  * **Feature**: Adding default vCPU information to GetOutpostSupportedInstanceTypes and GetOutpostInstanceTypes responses
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.30.0](service/sfn/CHANGELOG.md#v1300-2024-07-25)
  * **Feature**: This release adds support to customer managed KMS key encryption in AWS Step Functions.

# Release (2024-07-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.17.9](feature/s3/manager/CHANGELOG.md#v1179-2024-07-24)
  * **Documentation**: Clarify region hint and credential usage in HeadBucketRegion.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.16.0](service/cleanrooms/CHANGELOG.md#v1160-2024-07-24)
  * **Feature**: Three enhancements to the AWS Clean Rooms: Disallowed Output Columns, Flexible Result Receivers, SQL as a Seed
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.34.4](service/dynamodb/CHANGELOG.md#v1344-2024-07-24)
  * **Documentation**: DynamoDB doc only update for July
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.40.0](service/iotsitewise/CHANGELOG.md#v1400-2024-07-24)
  * **Feature**: Adds support for creating SiteWise Edge gateways that run on a Siemens Industrial Edge Device.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.15.0](service/mediapackagev2/CHANGELOG.md#v1150-2024-07-24)
  * **Feature**: This release adds support for Irdeto DRM encryption in DASH manifests.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.12.0](service/medicalimaging/CHANGELOG.md#v1120-2024-07-24)
  * **Feature**: CopyImageSet API adds copying selected instances between image sets, and overriding inconsistent metadata with a force parameter. UpdateImageSetMetadata API enables reverting to prior versions; updates to Study, Series, and SOP Instance UIDs; and updates to private elements, with a force parameter.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.12.5](service/pinpointsmsvoicev2/CHANGELOG.md#v1125-2024-07-24)
  * **Documentation**: Update for rebrand to AWS End User Messaging SMS and Voice.

# Release (2024-07-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.35.0](service/appsync/CHANGELOG.md#v1350-2024-07-23)
  * **Feature**: Adding support for paginators in AppSync list APIs
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.15.0](service/cleanrooms/CHANGELOG.md#v1150-2024-07-23)
  * **Feature**: This release adds AWS Entity Resolution integration to associate ID namespaces & ID mapping workflow resources as part of ID namespace association and  ID mapping table  in AWS Clean Rooms. It also introduces a new ID_MAPPING_TABLE analysis rule to manage the protection on ID mapping table.
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.7.0](service/cleanroomsml/CHANGELOG.md#v170-2024-07-23)
  * **Feature**: Adds SQL query as the source of seed audience for audience generation job.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.106.0](service/connect/CHANGELOG.md#v11060-2024-07-23)
  * **Feature**: Added PostContactSummary segment type on ListRealTimeContactAnalysisSegmentsV2 API
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.24.0](service/connectcontactlens/CHANGELOG.md#v1240-2024-07-23)
  * **Feature**: Added PostContactSummary segment type on ListRealTimeContactAnalysisSegments API
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.15.0](service/datazone/CHANGELOG.md#v1150-2024-07-23)
  * **Feature**: This release removes the deprecated dataProductItem field from Search API output.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.172.0](service/ec2/CHANGELOG.md#v11720-2024-07-23)
  * **Feature**: Switch to new waiter matching implementation, which conveys a slight performance boost and removes the need for the go-jmespath runtime dependency.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.13.0](service/entityresolution/CHANGELOG.md#v1130-2024-07-23)
  * **Feature**: Support First Party ID Mapping

# Release (2024-07-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.14.0](service/datazone/CHANGELOG.md#v1140-2024-07-22)
  * **Feature**: This release adds 1/ support of register S3 locations of assets in AWS Lake Formation hybrid access mode for DefaultDataLake blueprint. 2/ support of CRUD operations for Asset Filters.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.38.0](service/ivs/CHANGELOG.md#v1380-2024-07-22)
  * **Feature**: Documentation update for IVS Low Latency API Reference.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.21.0](service/redshiftserverless/CHANGELOG.md#v1210-2024-07-22)
  * **Feature**: Adds dualstack support for Redshift Serverless workgroup.

# Release (2024-07-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.35.0](service/acmpca/CHANGELOG.md#v1350-2024-07-18)
  * **Feature**: Fix broken waiters for the acm-pca client.  Waiters broke in version 1.13.144 of the Boto3 SDK.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.105.0](service/connect/CHANGELOG.md#v11050-2024-07-18)
  * **Feature**: Amazon Connect expands search API coverage for additional resources.  Search for hierarchy groups by name, ID, tag, or other criteria (new endpoint). Search for agent statuses by name, ID, tag, or other criteria (new endpoint). Search for users by their assigned proficiencies (enhanced endpoint)
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.171.0](service/ec2/CHANGELOG.md#v11710-2024-07-18)
  * **Feature**: Amazon VPC IP Address Manager (IPAM) now supports Bring-Your-Own-IP (BYOIP) for IP addresses registered with any Internet Registry. This feature uses DNS TXT records to validate ownership of a public IP address range.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.32.0](service/firehose/CHANGELOG.md#v1320-2024-07-18)
  * **Feature**: This release 1) Add configurable buffering hints for Snowflake as destination. 2) Add ReadFromTimestamp for MSK As Source. Firehose will start reading data from MSK Cluster using offset associated with this timestamp. 3) Gated public beta release to add Apache Iceberg tables as destination.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.14.4](service/ivschat/CHANGELOG.md#v1144-2024-07-18)
  * **Documentation**: Documentation update for IVS Chat API Reference.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.55.0](service/medialive/CHANGELOG.md#v1550-2024-07-18)
  * **Feature**: AWS Elemental MediaLive now supports the SRT protocol via the new SRT Caller input type.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.81.5](service/rds/CHANGELOG.md#v1815-2024-07-18)
  * **Documentation**: Updates Amazon RDS documentation to specify an eventual consistency model for DescribePendingMaintenanceActions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.151.0](service/sagemaker/CHANGELOG.md#v11510-2024-07-18)
  * **Feature**: SageMaker Training supports R5, T3 and R5D instances family. And SageMaker Processing supports G5 and R5D instances family.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.32.4](service/secretsmanager/CHANGELOG.md#v1324-2024-07-18)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.3.0](service/taxsettings/CHANGELOG.md#v130-2024-07-18)
  * **Feature**: Set default endpoint for aws partition. Requests from all regions in aws partition will be forward to us-east-1 endpoint.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.25.4](service/timestreamquery/CHANGELOG.md#v1254-2024-07-18)
  * **Documentation**: Doc-only update for TimestreamQuery. Added guidance about the accepted valid value for the QueryPricingModel parameter.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.8.4](service/workspacesthinclient/CHANGELOG.md#v184-2024-07-18)
  * **Documentation**: Documentation update for WorkSpaces Thin Client.

# Release (2024-07-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.34.0](service/acmpca/CHANGELOG.md#v1340-2024-07-12)
  * **Feature**: Minor refactoring of C2J model for AWS Private CA
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.12.0](service/arczonalshift/CHANGELOG.md#v1120-2024-07-12)
  * **Feature**: Adds the option to subscribe to get notifications when a zonal autoshift occurs in a region.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.27.0](service/globalaccelerator/CHANGELOG.md#v1270-2024-07-12)
  * **Feature**: This feature adds exceptions to the Customer API to avoid throwing Internal Service errors
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.68.0](service/quicksight/CHANGELOG.md#v1680-2024-07-12)
  * **Feature**: Vega ally control options and Support for Reviewed Answers in Topics

# Release (2024-07-10.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.3
  * **Dependency Update**: Temporarily re-add jmespath dependency.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.43.0](service/batch/CHANGELOG.md#v1430-2024-07-102)
  * **Feature**: This feature allows AWS Batch Jobs with EKS container orchestration type to be run as Multi-Node Parallel Jobs.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.12.0](service/bedrock/CHANGELOG.md#v1120-2024-07-102)
  * **Feature**: Add support for contextual grounding check for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.16.0](service/bedrockagent/CHANGELOG.md#v1160-2024-07-102)
  * **Feature**: Introduces new data sources and chunking strategies for Knowledge bases, advanced parsing logic using FMs, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.15.0](service/bedrockagentruntime/CHANGELOG.md#v1150-2024-07-102)
  * **Feature**: Introduces query decomposition, enhanced Agents integration with Knowledge bases, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources for end-to-end solutions.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.14.0](service/bedrockruntime/CHANGELOG.md#v1140-2024-07-102)
  * **Feature**: Add support for contextual grounding check and ApplyGuardrail API for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.170.0](service/ec2/CHANGELOG.md#v11700-2024-07-102)
  * **Feature**: Add parameters to enable provisioning IPAM BYOIPv4 space at a Local Zone Network Border Group level
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.91.0](service/glue/CHANGELOG.md#v1910-2024-07-102)
  * **Feature**: Add recipe step support for recipe node
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.29.3](service/groundstation/CHANGELOG.md#v1293-2024-07-102)
  * **Documentation**: Documentation update specifying OEM ephemeris units of measurement
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.12.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v1120-2024-07-102)
  * **Feature**: Add support for third party subscription providers, starting with RHEL subscriptions through Red Hat Subscription Manager (RHSM). Additionally, add support for tagging subscription provider resources, and detect when an instance has more than one Linux subscription and notify the customer.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.32.0](service/mediaconnect/CHANGELOG.md#v1320-2024-07-102)
  * **Feature**: AWS Elemental MediaConnect introduces the ability to disable outputs. Disabling an output allows you to keep the output attached to the flow, but stop streaming to the output destination. A disabled output does not incur data transfer costs.

# Release (2024-07-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.2
  * **Dependency Update**: Remove unused go-jmespath dependency from main module.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.42.0](service/batch/CHANGELOG.md#v1420-2024-07-10)
  * **Feature**: This feature allows AWS Batch Jobs with EKS container orchestration type to be run as Multi-Node Parallel Jobs.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.11.0](service/bedrock/CHANGELOG.md#v1110-2024-07-10)
  * **Feature**: Add support for contextual grounding check for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.15.0](service/bedrockagent/CHANGELOG.md#v1150-2024-07-10)
  * **Feature**: Introduces new data sources and chunking strategies for Knowledge bases, advanced parsing logic using FMs, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.14.0](service/bedrockagentruntime/CHANGELOG.md#v1140-2024-07-10)
  * **Feature**: Introduces query decomposition, enhanced Agents integration with Knowledge bases, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources for end-to-end solutions.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.13.0](service/bedrockruntime/CHANGELOG.md#v1130-2024-07-10)
  * **Feature**: Add support for contextual grounding check and ApplyGuardrail API for Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.169.0](service/ec2/CHANGELOG.md#v11690-2024-07-10)
  * **Feature**: Add parameters to enable provisioning IPAM BYOIPv4 space at a Local Zone Network Border Group level
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.90.0](service/glue/CHANGELOG.md#v1900-2024-07-10)
  * **Feature**: Add recipe step support for recipe node
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.29.2](service/groundstation/CHANGELOG.md#v1292-2024-07-10)
  * **Documentation**: Documentation update specifying OEM ephemeris units of measurement
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.11.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v1110-2024-07-10)
  * **Feature**: Add support for third party subscription providers, starting with RHEL subscriptions through Red Hat Subscription Manager (RHSM). Additionally, add support for tagging subscription provider resources, and detect when an instance has more than one Linux subscription and notify the customer.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.31.0](service/mediaconnect/CHANGELOG.md#v1310-2024-07-10)
  * **Feature**: AWS Elemental MediaConnect introduces the ability to disable outputs. Disabling an output allows you to keep the output attached to the flow, but stop streaming to the output destination. A disabled output does not incur data transfer costs.

# Release (2024-07-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.13.0](service/datazone/CHANGELOG.md#v1130-2024-07-09)
  * **Feature**: This release deprecates dataProductItem field from SearchInventoryResultItem, along with some unused DataProduct shapes
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.47.0](service/fsx/CHANGELOG.md#v1470-2024-07-09)
  * **Feature**: Adds support for FSx for NetApp ONTAP 2nd Generation file systems, and FSx for OpenZFS Single AZ HA file systems.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.39.0](service/opensearch/CHANGELOG.md#v1390-2024-07-09)
  * **Feature**: This release adds support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains, and provides visibility into the current state of the setup or tear-down.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.150.0](service/sagemaker/CHANGELOG.md#v11500-2024-07-09)
  * **Feature**: This release 1/ enables optimization jobs that allows customers to perform Ahead-of-time compilation and quantization. 2/ allows customers to control access to Amazon Q integration in SageMaker Studio. 3/ enables AdditionalModelDataSources for CreateModel action.

# Release (2024-07-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.25.0](service/devicefarm/CHANGELOG.md#v1250-2024-07-08)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.26.0](service/elasticbeanstalk/CHANGELOG.md#v1260-2024-07-08)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/qapps`: [v1.0.0](service/qapps/CHANGELOG.md#v100-2024-07-08)
  * **Release**: New AWS service client module
  * **Feature**: This is a general availability (GA) release of Amazon Q Apps, a capability of Amazon Q Business. Q Apps leverages data sources your company has provided to enable users to build, share, and customize apps within your organization.
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.25.0](service/ses/CHANGELOG.md#v1250-2024-07-08)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-07-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.28.2](service/acm/CHANGELOG.md#v1282-2024-07-05)
  * **Documentation**: Documentation updates, including fixes for xml formatting, broken links, and ListCertificates description.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.12.0](service/paymentcryptographydata/CHANGELOG.md#v1120-2024-07-05)
  * **Feature**: Added further restrictions on logging of potentially sensitive inputs and outputs.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.10.0](service/qbusiness/CHANGELOG.md#v1100-2024-07-05)
  * **Feature**: Add personalization to Q Applications. Customers can enable or disable personalization when creating or updating a Q application with the personalization configuration.

# Release (2024-07-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.30.2](service/applicationautoscaling/CHANGELOG.md#v1302-2024-07-03)
  * **Documentation**: Doc only update for Application Auto Scaling that fixes resource name.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.27.2](service/directconnect/CHANGELOG.md#v1272-2024-07-03)
  * **Documentation**: This update includes documentation for support of new native 400 GBps ports for Direct Connect.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.30.0](service/organizations/CHANGELOG.md#v1300-2024-07-03)
  * **Feature**: Added a new reason under ConstraintViolationException in RegisterDelegatedAdministrator API to prevent registering suspended accounts as delegated administrator of a service.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.43.0](service/rekognition/CHANGELOG.md#v1430-2024-07-03)
  * **Feature**: This release adds support for tagging projects and datasets with the CreateProject and CreateDataset APIs.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.44.0](service/workspaces/CHANGELOG.md#v1440-2024-07-03)
  * **Feature**: Fix create workspace bundle RootStorage/UserStorage to accept non null values

# Release (2024-07-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.168.0](service/ec2/CHANGELOG.md#v11680-2024-07-02)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.58.0](service/s3/CHANGELOG.md#v1580-2024-07-02)
  * **Feature**: Added response overrides to Head Object requests.

# Release (2024-07-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.104.0](service/connect/CHANGELOG.md#v11040-2024-07-01)
  * **Feature**: Authentication profiles are Amazon Connect resources (in gated preview) that allow you to configure authentication settings for users in your contact center. This release adds support for new ListAuthenticationProfiles, DescribeAuthenticationProfile and UpdateAuthenticationProfile APIs.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.46.0](service/eks/CHANGELOG.md#v1460-2024-07-01)
  * **Feature**: Updates EKS managed node groups to support EC2 Capacity Blocks for ML
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.11.0](service/paymentcryptographydata/CHANGELOG.md#v1110-2024-07-01)
  * **Feature**: Adding support for dynamic keys for encrypt, decrypt, re-encrypt and translate pin functions.  With this change, customers can use one-time TR-31 keys directly in dataplane operations without the need to first import them into the service.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.51.2](service/wafv2/CHANGELOG.md#v1512-2024-07-01)
  * **Documentation**: JSON body inspection: Update documentation to clarify that JSON parsing doesn't include full validation.

# Release (2024-06-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.33.0](service/acmpca/CHANGELOG.md#v1330-2024-06-28)
  * **Feature**: Added CCPC_LEVEL_1_OR_HIGHER KeyStorageSecurityStandard and SM2 KeyAlgorithm and SM3WITHSM2 SigningAlgorithm for China regions.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.25.0](service/cloudhsmv2/CHANGELOG.md#v1250-2024-06-28)
  * **Feature**: Added 3 new APIs to support backup sharing: GetResourcePolicy, PutResourcePolicy, and DeleteResourcePolicy. Added BackupArn to the output of the DescribeBackups API. Added support for BackupArn in the CreateCluster API.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.103.0](service/connect/CHANGELOG.md#v11030-2024-06-28)
  * **Feature**: This release supports showing PreferredAgentRouting step via DescribeContact API.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.42.0](service/emr/CHANGELOG.md#v1420-2024-06-28)
  * **Feature**: This release provides the support for new allocation strategies i.e. CAPACITY_OPTIMIZED_PRIORITIZED for Spot and PRIORITIZED for On-Demand by taking input of priority value for each instance type for instance fleet clusters.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.89.0](service/glue/CHANGELOG.md#v1890-2024-06-28)
  * **Feature**: Added AttributesToGet parameter to Glue GetDatabases, allowing caller to limit output to include only the database name.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.28.0](service/kinesisanalyticsv2/CHANGELOG.md#v1280-2024-06-28)
  * **Feature**: Support for Flink 1.19 in Managed Service for Apache Flink
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.38.0](service/opensearch/CHANGELOG.md#v1380-2024-06-28)
  * **Feature**: This release removes support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.27.1](service/pi/CHANGELOG.md#v1271-2024-06-28)
  * **Documentation**: Noting that the filter db.sql.db_id isn't available for RDS for SQL Server DB instances.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.43.0](service/workspaces/CHANGELOG.md#v1430-2024-06-28)
  * **Feature**: Added support for Red Hat Enterprise Linux 8 on Amazon WorkSpaces Personal.

# Release (2024-06-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.30.0](service/applicationautoscaling/CHANGELOG.md#v1300-2024-06-27)
  * **Feature**: Amazon WorkSpaces customers can now use Application Auto Scaling to automatically scale the number of virtual desktops in a WorkSpaces pool.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.18.0](service/chimesdkmediapipelines/CHANGELOG.md#v1180-2024-06-27)
  * **Feature**: Added Amazon Transcribe multi language identification to Chime SDK call analytics. Enabling customers sending single stream audio to generate call recordings using Chime SDK call analytics
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.38.1](service/cloudfront/CHANGELOG.md#v1381-2024-06-27)
  * **Documentation**: Doc only update for CloudFront that fixes customer-reported issue
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.12.0](service/datazone/CHANGELOG.md#v1120-2024-06-27)
  * **Feature**: This release supports the data lineage feature of business data catalog in Amazon DataZone.
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.25.0](service/mq/CHANGELOG.md#v1250-2024-06-27)
  * **Feature**: This release makes the EngineVersion field optional for both broker and configuration and uses the latest available version by default. The AutoMinorVersionUpgrade field is also now optional for broker creation and defaults to 'true'.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.9.0](service/qconnect/CHANGELOG.md#v190-2024-06-27)
  * **Feature**: Adds CreateContentAssociation, ListContentAssociations, GetContentAssociation, and DeleteContentAssociation APIs.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.67.0](service/quicksight/CHANGELOG.md#v1670-2024-06-27)
  * **Feature**: Adding support for Repeating Sections, Nested Filters
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.81.1](service/rds/CHANGELOG.md#v1811-2024-06-27)
  * **Documentation**: Updates Amazon RDS documentation for TAZ export to S3.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.149.0](service/sagemaker/CHANGELOG.md#v11490-2024-06-27)
  * **Feature**: Add capability for Admins to customize Studio experience for the user by showing or hiding Apps and MLTools.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.42.0](service/workspaces/CHANGELOG.md#v1420-2024-06-27)
  * **Feature**: Added support for WorkSpaces Pools.

# Release (2024-06-26)

## General Highlights
* **Feature**: Support list-of-string endpoint parameter.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.16.0](service/controltower/CHANGELOG.md#v1160-2024-06-26)
  * **Feature**: Added ListLandingZoneOperations API.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.45.0](service/eks/CHANGELOG.md#v1450-2024-06-26)
  * **Feature**: Added support for disabling unmanaged addons during cluster creation.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.16.0](service/ivsrealtime/CHANGELOG.md#v1160-2024-06-26)
  * **Feature**: IVS Real-Time now offers customers the ability to upload public keys for customer vended participant tokens.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.27.0](service/kinesisanalyticsv2/CHANGELOG.md#v1270-2024-06-26)
  * **Feature**: This release adds support for new ListApplicationOperations and DescribeApplicationOperation APIs. It adds a new configuration to enable system rollbacks, adds field ApplicationVersionCreateTimestamp for clarity and improves support for pagination for APIs.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.37.0](service/opensearch/CHANGELOG.md#v1370-2024-06-26)
  * **Feature**: This release adds support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains, and provides visibility into the current state of the setup or tear-down.

# Release (2024-06-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.42.0](service/autoscaling/CHANGELOG.md#v1420-2024-06-25)
  * **Feature**: Doc only update for Auto Scaling's TargetTrackingMetricDataQuery
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.166.0](service/ec2/CHANGELOG.md#v11660-2024-06-25)
  * **Feature**: This release is for the launch of the new u7ib-12tb.224xlarge, R8g, c7gn.metal and mac2-m1ultra.metal instance types
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.28.0](service/networkmanager/CHANGELOG.md#v1280-2024-06-25)
  * **Feature**: This is model changes & documentation update for the Asynchronous Error Reporting feature for AWS Cloud WAN. This feature allows customers to view errors that occur while their resources are being provisioned, enabling customers to fix their resources without needing external support.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.7.0](service/workspacesthinclient/CHANGELOG.md#v170-2024-06-25)
  * **Feature**: This release adds the deviceCreationTags field to CreateEnvironment API input, UpdateEnvironment API input and GetEnvironment API output.

# Release (2024-06-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.38.0](service/customerprofiles/CHANGELOG.md#v1380-2024-06-24)
  * **Feature**: This release includes changes to ProfileObjectType APIs, adds functionality top set and get capacity for profile object types.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.8.0](service/qbusiness/CHANGELOG.md#v180-2024-06-24)
  * **Feature**: Allow enable/disable Q Apps when creating/updating a Q application; Return the Q Apps enablement information when getting a Q application.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.20.0](service/workspacesweb/CHANGELOG.md#v1200-2024-06-24)
  * **Feature**: Added ability to enable DeepLinking functionality on a Portal via UserSettings as well as added support for IdentityProvider resource tagging.

# Release (2024-06-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.11.0](service/bedrockruntime/CHANGELOG.md#v1110-2024-06-20)
  * **Feature**: This release adds document support to Converse and ConverseStream APIs
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.29.0](service/codeartifact/CHANGELOG.md#v1290-2024-06-20)
  * **Feature**: Add support for the Cargo package format.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.36.0](service/computeoptimizer/CHANGELOG.md#v1360-2024-06-20)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for Amazon RDS MySQL and RDS PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.6.0](service/costoptimizationhub/CHANGELOG.md#v160-2024-06-20)
  * **Feature**: This release enables AWS Cost Optimization Hub to show cost optimization recommendations for Amazon RDS MySQL and RDS PostgreSQL.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.33.2](service/dynamodb/CHANGELOG.md#v1332-2024-06-20)
  * **Documentation**: Doc-only update for DynamoDB. Fixed Important note in 6 Global table APIs - CreateGlobalTable, DescribeGlobalTable, DescribeGlobalTableSettings, ListGlobalTables, UpdateGlobalTable, and UpdateGlobalTableSettings.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.15.0](service/ivsrealtime/CHANGELOG.md#v1150-2024-06-20)
  * **Feature**: IVS Real-Time now offers customers the ability to record individual stage participants to S3.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.147.0](service/sagemaker/CHANGELOG.md#v11470-2024-06-20)
  * **Feature**: Adds support for model references in Hub service, and adds support for cross-account access of Hubs
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.50.2](service/securityhub/CHANGELOG.md#v1502-2024-06-20)
  * **Documentation**: Documentation updates for Security Hub

# Release (2024-06-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.30.0
  * **Feature**: Add implicit global region to internal endpoint resolution metadata.
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.3.0](service/artifact/CHANGELOG.md#v130-2024-06-19)
  * **Feature**: This release adds an acceptanceType field to the ReportSummary structure (used in the ListReports API response).
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.43.0](service/athena/CHANGELOG.md#v1430-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.25.0](service/costandusagereportservice/CHANGELOG.md#v1250-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.26.0](service/directconnect/CHANGELOG.md#v1260-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.24.0](service/elastictranscoder/CHANGELOG.md#v1240-2024-06-19)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.36.0](service/opensearch/CHANGELOG.md#v1360-2024-06-19)
  * **Feature**: This release enables customers to use JSON Web Tokens (JWT) for authentication on their Amazon OpenSearch Service domains.

# Release (2024-06-18)

## General Highlights
* **Feature**: Add framework for tracking specific features in user-agent string.
* **Feature**: Track usage of various AWS SDK features in user-agent string.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.10.0](service/bedrockruntime/CHANGELOG.md#v1100-2024-06-18)
  * **Feature**: This release adds support for using Guardrails with the Converse and ConverseStream APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.41.0](service/cloudtrail/CHANGELOG.md#v1410-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.47.0](service/configservice/CHANGELOG.md#v1470-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.44.0](service/eks/CHANGELOG.md#v1440-2024-06-18)
  * **Feature**: This release adds support to surface async fargate customer errors from async path to customer through describe-fargate-profile API response.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.39.0](service/lightsail/CHANGELOG.md#v1390-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.41.0](service/polly/CHANGELOG.md#v1410-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.41.0](service/rekognition/CHANGELOG.md#v1410-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.146.0](service/sagemaker/CHANGELOG.md#v11460-2024-06-18)
  * **Feature**: Launched a new feature in SageMaker to provide managed MLflow Tracking Servers for customers to track ML experiments. This release also adds a new capability of attaching additional storage to SageMaker HyperPod cluster instances.
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.26.0](service/shield/CHANGELOG.md#v1260-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.27.0](service/snowball/CHANGELOG.md#v1270-2024-06-18)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-06-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.28.0
  * **Feature**: Support accountID-based endpoint routing.
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.30.4](service/acmpca/CHANGELOG.md#v1304-2024-06-17)
  * **Documentation**: Doc-only update that adds name constraints as an allowed extension for ImportCertificateAuthorityCertificate.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.39.0](service/batch/CHANGELOG.md#v1390-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.38.0](service/codebuild/CHANGELOG.md#v1380-2024-06-17)
  * **Feature**: AWS CodeBuild now supports global and organization GitHub webhooks
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.39.0](service/cognitoidentityprovider/CHANGELOG.md#v1390-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.25.0](service/directoryservice/CHANGELOG.md#v1250-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.29.0](service/efs/CHANGELOG.md#v1290-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.86.0](service/glue/CHANGELOG.md#v1860-2024-06-17)
  * **Feature**: This release introduces a new feature, Usage profiles. Usage profiles allow the AWS Glue admin to create different profiles for various classes of users within the account, enforcing limits and defaults for jobs and sessions.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.33.1](service/kms/CHANGELOG.md#v1331-2024-06-17)
  * **Documentation**: Updating SDK example for KMS DeriveSharedSecret API.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.55.0](service/mediaconvert/CHANGELOG.md#v1550-2024-06-17)
  * **Feature**: This release includes support for creating I-frame only video segments for DASH trick play.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.30.1](service/secretsmanager/CHANGELOG.md#v1301-2024-06-17)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.21.0](service/waf/CHANGELOG.md#v1210-2024-06-17)
  * **Feature**: Add v2 smoke tests and smithy smokeTests trait for SDK testing.

# Release (2024-06-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.9.0](service/datazone/CHANGELOG.md#v190-2024-06-14)
  * **Feature**: This release introduces a new default service blueprint for custom environment creation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.164.1](service/ec2/CHANGELOG.md#v11641-2024-06-14)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.39.0](service/macie2/CHANGELOG.md#v1390-2024-06-14)
  * **Feature**: This release adds support for managing the status of automated sensitive data discovery for individual accounts in an organization, and determining whether individual S3 buckets are included in the scope of the analyses.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.54.0](service/mediaconvert/CHANGELOG.md#v1540-2024-06-14)
  * **Feature**: This release adds the ability to search for historical job records within the management console using a search box and/or via the SDK/CLI with partial string matching search on input file name.

# Release (2024-06-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.22.0](service/cloudhsmv2/CHANGELOG.md#v1220-2024-06-13)
  * **Feature**: Added support for hsm type hsm2m.medium. Added supported for creating a cluster in FIPS or NON_FIPS mode.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.85.0](service/glue/CHANGELOG.md#v1850-2024-06-13)
  * **Feature**: This release adds support for configuration of evaluation method for composite rules in Glue Data Quality rulesets.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.40.0](service/iotwireless/CHANGELOG.md#v1400-2024-06-13)
  * **Feature**: Add RoamingDeviceSNR and RoamingDeviceRSSI to Customer Metrics.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.33.0](service/kms/CHANGELOG.md#v1330-2024-06-13)
  * **Feature**: This feature allows customers to use their keys stored in KMS to derive a shared secret which can then be used to establish a secured channel for communication, provide proof of possession, or establish trust with other parties.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.12.0](service/mediapackagev2/CHANGELOG.md#v1120-2024-06-13)
  * **Feature**: This release adds support for CMAF ingest (DASH-IF live media ingest protocol interface 1)

# Release (2024-06-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apptest`: [v1.0.0](service/apptest/CHANGELOG.md#v100-2024-06-12)
  * **Release**: New AWS service client module
  * **Feature**: AWS Mainframe Modernization Application Testing is an AWS Mainframe Modernization service feature that automates functional equivalence testing for mainframe application modernization and migration to AWS, and regression testing.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.164.0](service/ec2/CHANGELOG.md#v11640-2024-06-12)
  * **Feature**: Tagging support for Traffic Mirroring FilterRule resource
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.10.0](service/osis/CHANGELOG.md#v1100-2024-06-12)
  * **Feature**: SDK changes for self-managed vpc endpoint to OpenSearch ingestion pipelines.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.44.7](service/redshift/CHANGELOG.md#v1447-2024-06-12)
  * **Documentation**: Updates to remove DC1 and DS2 node types.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.30.0](service/secretsmanager/CHANGELOG.md#v1300-2024-06-12)
  * **Feature**: Introducing RotationToken parameter for PutSecretValue API
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.14.0](service/securitylake/CHANGELOG.md#v1140-2024-06-12)
  * **Feature**: This release updates request validation regex to account for non-commercial aws partitions.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.30.0](service/sesv2/CHANGELOG.md#v1300-2024-06-12)
  * **Feature**: This release adds support for Amazon EventBridge as an email sending events destination.

# Release (2024-06-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.30.0](service/accessanalyzer/CHANGELOG.md#v1300-2024-06-11)
  * **Feature**: IAM Access Analyzer now provides policy recommendations to help resolve unused permissions for IAM roles and users. Additionally, IAM Access Analyzer now extends its custom policy checks to detect when IAM policies grant public access or access to critical resources ahead of deployments.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.43.0](service/guardduty/CHANGELOG.md#v1430-2024-06-11)
  * **Feature**: Added API support for GuardDuty Malware Protection for S3.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.26.0](service/networkmanager/CHANGELOG.md#v1260-2024-06-11)
  * **Feature**: This is model changes & documentation update for Service Insertion feature for AWS Cloud WAN. This feature allows insertion of AWS/3rd party security services on Cloud WAN. This allows to steer inter/intra segment traffic via security appliances and provide visibility to the route updates.
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep`: [v1.0.0](service/pcaconnectorscep/CHANGELOG.md#v100-2024-06-11)
  * **Release**: New AWS service client module
  * **Feature**: Connector for SCEP allows you to use a managed, cloud CA to enroll mobile devices and networking gear. SCEP is a widely-adopted protocol used by mobile device management (MDM) solutions for enrolling mobile devices. With the connector, you can use AWS Private CA with popular MDM solutions.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.145.0](service/sagemaker/CHANGELOG.md#v11450-2024-06-11)
  * **Feature**: Introduced Scope and AuthenticationRequestExtraParams to SageMaker Workforce OIDC configuration; this allows customers to modify these options for their private Workforce IdP integration. Model Registry Cross-account model package groups are discoverable.

# Release (2024-06-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationsignals`: [v1.0.0](service/applicationsignals/CHANGELOG.md#v100-2024-06-10)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon CloudWatch Application Signals. Amazon CloudWatch Application Signals provides curated application performance monitoring for developers to monitor and troubleshoot application health using pre-built dashboards and Service Level Objectives.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.42.0](service/ecs/CHANGELOG.md#v1420-2024-06-10)
  * **Feature**: This release introduces a new cluster configuration to support the customer-managed keys for ECS managed storage encryption.

# Release (2024-06-07)

## General Highlights
* **Bug Fix**: Add clock skew correction on all service clients
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.33.0](service/auditmanager/CHANGELOG.md#v1330-2024-06-07)
  * **Feature**: New feature: common controls. When creating custom controls, you can now use pre-grouped AWS data sources based on common compliance themes. Also, the awsServices parameter is deprecated because we now manage services in scope for you. If used, the input is ignored and an empty list is returned.
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.28](service/b2bi/CHANGELOG.md#v100-preview28-2024-06-07)
  * **Feature**: Added exceptions to B2Bi List operations and ConflictException to B2Bi StartTransformerJob operation. Also made capabilities field explicitly required when creating a Partnership.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.28.0](service/codepipeline/CHANGELOG.md#v1280-2024-06-07)
  * **Feature**: CodePipeline now supports overriding S3 Source Object Key during StartPipelineExecution, as part of Source Overrides.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.144.0](service/sagemaker/CHANGELOG.md#v11440-2024-06-07)
  * **Feature**: This release introduces a new optional parameter: InferenceAmiVersion, in ProductionVariant.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.15.0](service/verifiedpermissions/CHANGELOG.md#v1150-2024-06-07)
  * **Feature**: This release adds OpenIdConnect (OIDC) configuration support for IdentitySources, allowing for external IDPs to be used in authorization requests.

# Release (2024-06-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.17.0](service/account/CHANGELOG.md#v1170-2024-06-06)
  * **Feature**: This release adds 3 new APIs (AcceptPrimaryEmailUpdate, GetPrimaryEmail, and StartPrimaryEmailUpdate) used to centrally manage the root user email address of member accounts within an AWS organization.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.29.0](service/firehose/CHANGELOG.md#v1290-2024-06-06)
  * **Feature**: Adds integration with Secrets Manager for Redshift, Splunk, HttpEndpoint, and Snowflake destinations
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.44.0](service/fsx/CHANGELOG.md#v1440-2024-06-06)
  * **Feature**: This release adds support to increase metadata performance on FSx for Lustre file systems beyond the default level provisioned when a file system is created. This can be done by specifying MetadataConfiguration during the creation of Persistent_2 file systems or by updating it on demand.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.84.0](service/glue/CHANGELOG.md#v1840-2024-06-06)
  * **Feature**: This release adds support for creating and updating Glue Data Catalog Views.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.39.0](service/iotwireless/CHANGELOG.md#v1390-2024-06-06)
  * **Feature**: Adds support for wireless device to be in Conflict FUOTA Device Status due to a FUOTA Task, so it couldn't be attached to a new one.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.38.0](service/location/CHANGELOG.md#v1380-2024-06-06)
  * **Feature**: Added two new APIs, VerifyDevicePosition and ForecastGeofenceEvents. Added support for putting larger geofences up to 100,000 vertices with Geobuf fields.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.29.10](service/sns/CHANGELOG.md#v12910-2024-06-06)
  * **Documentation**: Doc-only update for SNS. These changes include customer-reported issues and TXC3 updates.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.32.5](service/sqs/CHANGELOG.md#v1325-2024-06-06)
  * **Documentation**: Doc only updates for SQS. These updates include customer-reported issues and TCX3 modifications.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.29.0](service/storagegateway/CHANGELOG.md#v1290-2024-06-06)
  * **Feature**: Adds SoftwareUpdatePreferences to DescribeMaintenanceStartTime and UpdateMaintenanceStartTime, a structure which contains AutomaticUpdatePolicy.

# Release (2024-06-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.14.0](feature/dynamodb/attributevalue/CHANGELOG.md#v1140-2024-06-05)
  * **Feature**: Add codec options to use encoding.Text/Binary(Un)Marshaler when present on targets.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.24.0](service/globalaccelerator/CHANGELOG.md#v1240-2024-06-05)
  * **Feature**: This release contains a new optional ip-addresses input field for the update accelerator and update custom routing accelerator apis. This input enables consumers to replace IPv4 addresses on existing accelerators with addresses provided in the input.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.83.0](service/glue/CHANGELOG.md#v1830-2024-06-05)
  * **Feature**: AWS Glue now supports native SaaS connectivity: Salesforce connector available now
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.55.0](service/s3/CHANGELOG.md#v1550-2024-06-05)
  * **Feature**: Added new params copySource and key to copyObject API for supporting S3 Access Grants plugin. These changes will not change any of the existing S3 API functionality.
  * **Bug Fix**: Add S3-specific smithy protocol tests.

# Release (2024-06-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.163.0](service/ec2/CHANGELOG.md#v11630-2024-06-04)
  * **Feature**: U7i instances with up to 32 TiB of DDR5 memory and 896 vCPUs are now available. C7i-flex instances are launched and are lower-priced variants of the Amazon EC2 C7i instances that offer a baseline level of CPU performance with the ability to scale up to the full compute performance 95% of the time.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.12.0](service/pipes/CHANGELOG.md#v1120-2024-06-04)
  * **Feature**: This release adds Timestream for LiveAnalytics as a supported target in EventBridge Pipes
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.143.0](service/sagemaker/CHANGELOG.md#v11430-2024-06-04)
  * **Feature**: Extend DescribeClusterNode response with private DNS hostname and IP address, and placement information about availability zone and availability zone ID.
* `github.com/aws/aws-sdk-go-v2/service/taxsettings`: [v1.0.0](service/taxsettings/CHANGELOG.md#v100-2024-06-04)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS Tax Settings API

# Release (2024-06-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.27.1
  * **Bug Fix**: Re-enable hoisting of `X-Amz-Expected-Bucket-Owner` in presigning, but in lowercase form, such that it is correctly enforced.
  * **Documentation**: Add deprecation docs to global endpoint resolution interfaces. These APIs were previously deprecated with the introduction of service-specific endpoint resolution (EndpointResolverV2 and BaseEndpoint on service client options).
* `github.com/aws/aws-sdk-go-v2/config`: [v1.27.17](config/CHANGELOG.md#v12717-2024-06-03)
  * **Documentation**: Add deprecation docs to global endpoint resolution interfaces. These APIs were previously deprecated with the introduction of service-specific endpoint resolution (EndpointResolverV2 and BaseEndpoint on service client options).
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.21.10](service/amplify/CHANGELOG.md#v12110-2024-06-03)
  * **Documentation**: This doc-only update identifies fields that are specific to Gen 1 and Gen 2 applications.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.38.0](service/batch/CHANGELOG.md#v1380-2024-06-03)
  * **Feature**: This release adds support for the AWS Batch GetJobQueueSnapshot API operation.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.43.0](service/eks/CHANGELOG.md#v1430-2024-06-03)
  * **Feature**: Adds support for EKS add-ons pod identity associations integration
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.20.0](service/iottwinmaker/CHANGELOG.md#v1200-2024-06-03)
  * **Feature**: Support RESET_VALUE UpdateType for PropertyUpdates to reset property value to default or null

# Release (2024-05-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.37.1](service/codebuild/CHANGELOG.md#v1371-2024-05-31)
  * **Documentation**: AWS CodeBuild now supports Self-hosted GitHub Actions runners for Github Enterprise
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.8.0](service/codegurusecurity/CHANGELOG.md#v180-2024-05-31)
  * **Feature**: This release includes minor model updates and documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.38.6](service/elasticache/CHANGELOG.md#v1386-2024-05-31)
  * **Documentation**: Update to attributes of TestFailover and minor revisions.
* `github.com/aws/aws-sdk-go-v2/service/launchwizard`: [v1.4.0](service/launchwizard/CHANGELOG.md#v140-2024-05-31)
  * **Feature**: This release adds support for describing workload deployment specifications, deploying additional workload types, and managing tags for Launch Wizard resources with API operations.

# Release (2024-05-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.26.0](service/acm/CHANGELOG.md#v1260-2024-05-30)
  * **Feature**: add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.12.0](service/bedrockagent/CHANGELOG.md#v1120-2024-05-30)
  * **Feature**: With this release, Knowledge bases for Bedrock adds support for Titan Text Embedding v2.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.9.0](service/bedrockruntime/CHANGELOG.md#v190-2024-05-30)
  * **Feature**: This release adds Converse and ConverseStream APIs to Bedrock Runtime
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.40.0](service/cloudtrail/CHANGELOG.md#v1400-2024-05-30)
  * **Feature**: CloudTrail Lake returns PartitionKeys in the GetEventDataStore API response. Events are grouped into partitions based on these keys for better query performance. For example, the calendarday key groups events by day, while combining the calendarday key with the hour key groups them by day and hour.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.100.0](service/connect/CHANGELOG.md#v11000-2024-05-30)
  * **Feature**: Adding associatedQueueIds as a SearchCriteria and response field to the SearchRoutingProfiles API
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.21.0](service/emrserverless/CHANGELOG.md#v1210-2024-05-30)
  * **Feature**: The release adds support for spark structured streaming.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.79.3](service/rds/CHANGELOG.md#v1793-2024-05-30)
  * **Documentation**: Updates Amazon RDS documentation for Aurora Postgres DBname.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.142.0](service/sagemaker/CHANGELOG.md#v11420-2024-05-30)
  * **Feature**: Adds Model Card information as a new component to Model Package. Autopilot launches algorithm selection for TimeSeries modality to generate AutoML candidates per algorithm.

# Release (2024-05-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.41.0](service/athena/CHANGELOG.md#v1410-2024-05-29)
  * **Feature**: Throwing validation errors on CreateNotebook with Name containing `/`,`:`,`\`
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.37.0](service/codebuild/CHANGELOG.md#v1370-2024-05-29)
  * **Feature**: AWS CodeBuild now supports manually creating GitHub webhooks
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.99.0](service/connect/CHANGELOG.md#v1990-2024-05-29)
  * **Feature**: This release includes changes to DescribeContact API's response by including ConnectedToSystemTimestamp, RoutingCriteria, Customer, Campaign, AnsweringMachineDetectionStatus, CustomerVoiceActivity, QualityMetrics, DisconnectDetails, and SegmentAttributes information from a contact in Amazon Connect.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.82.0](service/glue/CHANGELOG.md#v1820-2024-05-29)
  * **Feature**: Add optional field JobMode to CreateJob and UpdateJob APIs.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.49.0](service/securityhub/CHANGELOG.md#v1490-2024-05-29)
  * **Feature**: Add ROOT type for TargetType model

# Release (2024-05-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.32.6](service/dynamodb/CHANGELOG.md#v1326-2024-05-28)
  * **Documentation**: Doc-only update for DynamoDB. Specified the IAM actions needed to authorize a user to create a table with a resource-based policy.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.162.0](service/ec2/CHANGELOG.md#v11620-2024-05-28)
  * **Feature**: Providing support to accept BgpAsnExtended attribute
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.33.0](service/kafka/CHANGELOG.md#v1330-2024-05-28)
  * **Feature**: Adds ControllerNodeInfo in ListNodes response to support Raft mode for MSK
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.23.0](service/swf/CHANGELOG.md#v1230-2024-05-28)
  * **Feature**: This release adds new APIs for deleting activity type and workflow type resources.

# Release (2024-05-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.32.5](service/dynamodb/CHANGELOG.md#v1325-2024-05-24)
  * **Documentation**: Documentation only updates for DynamoDB.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.15.0](service/iotfleetwise/CHANGELOG.md#v1150-2024-05-24)
  * **Feature**: AWS IoT FleetWise now supports listing vehicles with attributes filter, ListVehicles API is updated to support additional attributes filter.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.22.9](service/managedblockchain/CHANGELOG.md#v1229-2024-05-24)
  * **Documentation**: This is a minor documentation update to address the impact of the shut down of the Goerli and Polygon networks.

# Release (2024-05-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.20.0](service/emrserverless/CHANGELOG.md#v1200-2024-05-23)
  * **Feature**: This release adds the capability to run interactive workloads using Apache Livy Endpoint.
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.22.8](service/opsworks/CHANGELOG.md#v1228-2024-05-23)
  * **Documentation**: Documentation-only update for OpsWorks Stacks.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.54.3](service/s3/CHANGELOG.md#v1543-2024-05-23)
  * **Bug Fix**: Prevent parsing failures for nonstandard `Expires` values in responses. If the SDK cannot parse the value set in the response header for this field it will now be returned as `nil`. A new field, `ExpiresString`, has been added that will retain the unparsed value from the response (regardless of whether it came back in a format recognized by the SDK).

# Release (2024-05-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.2.0](service/chatbot/CHANGELOG.md#v120-2024-05-22)
  * **Feature**: This change adds support for tagging Chatbot configurations.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.51.0](service/cloudformation/CHANGELOG.md#v1510-2024-05-22)
  * **Feature**: Added DeletionMode FORCE_DELETE_STACK for deleting a stack that is stuck in DELETE_FAILED state due to resource deletion failure.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.32.0](service/kms/CHANGELOG.md#v1320-2024-05-22)
  * **Feature**: This release includes feature to import customer's asymmetric (RSA, ECC and SM2) and HMAC keys into KMS in China.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.34.0](service/opensearch/CHANGELOG.md#v1340-2024-05-22)
  * **Feature**: This release adds support for enabling or disabling a data source configured as part of Zero-ETL integration with Amazon S3, by setting its status.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.49.0](service/wafv2/CHANGELOG.md#v1490-2024-05-22)
  * **Feature**: You can now use Security Lake to collect web ACL traffic data.

# Release (2024-05-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.81.0](service/glue/CHANGELOG.md#v1810-2024-05-21)
  * **Feature**: Add Maintenance window to CreateJob and UpdateJob APIs and JobRun response. Add a new Job Run State for EXPIRED.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.38.0](service/lightsail/CHANGELOG.md#v1380-2024-05-21)
  * **Feature**: This release adds support for Amazon Lightsail instances to switch between dual-stack or IPv4 only and IPv6-only public IP address types.
* `github.com/aws/aws-sdk-go-v2/service/mailmanager`: [v1.0.0](service/mailmanager/CHANGELOG.md#v100-2024-05-21)
  * **Release**: New AWS service client module
  * **Feature**: This release includes a new Amazon SES feature called Mail Manager, which is a set of email gateway capabilities designed to help customers strengthen their organization's email infrastructure, simplify email workflow management, and streamline email compliance control.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.25.0](service/pi/CHANGELOG.md#v1250-2024-05-21)
  * **Feature**: Performance Insights added a new input parameter called AuthorizedActions to support the fine-grained access feature. Performance Insights also restricted the acceptable input characters.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.79.1](service/rds/CHANGELOG.md#v1791-2024-05-21)
  * **Documentation**: Updates Amazon RDS documentation for Db2 license through AWS Marketplace.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.28.0](service/storagegateway/CHANGELOG.md#v1280-2024-05-21)
  * **Feature**: Added new SMBSecurityStrategy enum named MandatoryEncryptionNoAes128, new mode enforces encryption and disables AES 128-bit algorithums.

# Release (2024-05-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.11.0](service/bedrockagent/CHANGELOG.md#v1110-2024-05-20)
  * **Feature**: This release adds support for using Guardrails with Bedrock Agents.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.11.0](service/bedrockagentruntime/CHANGELOG.md#v1110-2024-05-20)
  * **Feature**: This release adds support for using Guardrails with Bedrock Agents.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.14.0](service/controltower/CHANGELOG.md#v1140-2024-05-20)
  * **Feature**: Added ListControlOperations API and filtering support for ListEnabledControls API. Updates also includes added metadata for enabled controls and control operations.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.9.0](service/osis/CHANGELOG.md#v190-2024-05-20)
  * **Feature**: Add support for creating an OpenSearch Ingestion pipeline that is attached to a provided VPC. Add information about the destinations of an OpenSearch Ingestion pipeline to the GetPipeline and ListPipelines APIs.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.79.0](service/rds/CHANGELOG.md#v1790-2024-05-20)
  * **Feature**: This release adds support for EngineLifecycleSupport on DBInstances, DBClusters, and GlobalClusters.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.29.0](service/secretsmanager/CHANGELOG.md#v1290-2024-05-20)
  * **Feature**: add v2 smoke tests and smithy smokeTests trait for SDK testing

# Release (2024-05-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.36.0](service/codebuild/CHANGELOG.md#v1360-2024-05-17)
  * **Feature**: Aws CodeBuild now supports 36 hours build timeout
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.31.0](service/elasticloadbalancingv2/CHANGELOG.md#v1310-2024-05-17)
  * **Feature**: This release adds dualstack-without-public-ipv4 IP address type for ALB.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.33.0](service/lakeformation/CHANGELOG.md#v1330-2024-05-17)
  * **Feature**: Introduces a new API, GetDataLakePrincipal, that returns the identity of the invoking principal
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.48.0](service/transfer/CHANGELOG.md#v1480-2024-05-17)
  * **Feature**: Enable use of CloudFormation traits in Smithy model to improve generated CloudFormation schema from the Smithy API model.

# Release (2024-05-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.27.0
  * **Feature**: Capture user agent in internal metrics.
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.30.0](service/acmpca/CHANGELOG.md#v1300-2024-05-16)
  * **Feature**: This release adds support for waiters to fail on AccessDeniedException when having insufficient permissions
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.98.2](service/connect/CHANGELOG.md#v1982-2024-05-16)
  * **Documentation**: Adding Contact Flow metrics to the GetMetricDataV2 API
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.32.0](service/kafka/CHANGELOG.md#v1320-2024-05-16)
  * **Feature**: AWS MSK support for Broker Removal.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.27.0](service/mwaa/CHANGELOG.md#v1270-2024-05-16)
  * **Feature**: Amazon MWAA now supports Airflow web server auto scaling to automatically handle increased demand from REST APIs, Command Line Interface (CLI), or more Airflow User Interface (UI) users. Customers can specify maximum and minimum web server instances during environment creation and update workflow.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.64.0](service/quicksight/CHANGELOG.md#v1640-2024-05-16)
  * **Feature**: This release adds DescribeKeyRegistration and UpdateKeyRegistration APIs to manage QuickSight Customer Managed Keys (CMK).
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.141.0](service/sagemaker/CHANGELOG.md#v11410-2024-05-16)
  * **Feature**: Introduced WorkerAccessConfiguration to SageMaker Workteam. This allows customers to configure resource access for workers in a workteam.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.28.9](service/secretsmanager/CHANGELOG.md#v1289-2024-05-16)
  * **Documentation**: Documentation updates for AWS Secrets Manager

# Release (2024-05-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.26.2
  * **Bug Fix**: Adjust internal metrics collection for revised authentication workflow.
  * **Bug Fix**: Fix confusing doc header in `aws/signer/v4` package.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.10.0](service/bedrockagentruntime/CHANGELOG.md#v1100-2024-05-15)
  * **Feature**: Updating Bedrock Knowledge Base Metadata & Filters feature with two new filters listContains and stringContains
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.35.0](service/codebuild/CHANGELOG.md#v1350-2024-05-15)
  * **Feature**: CodeBuild Reserved Capacity VPC Support
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.38.0](service/datasync/CHANGELOG.md#v1380-2024-05-15)
  * **Feature**: Task executions now display a CANCELLING status when an execution is in the process of being cancelled.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.22.0](service/grafana/CHANGELOG.md#v1220-2024-05-15)
  * **Feature**: This release adds new ServiceAccount and ServiceAccountToken APIs.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.9.0](service/medicalimaging/CHANGELOG.md#v190-2024-05-15)
  * **Feature**: Added support for importing medical imaging data from Amazon S3 buckets across accounts and regions.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.48.2](service/securityhub/CHANGELOG.md#v1482-2024-05-15)
  * **Documentation**: Documentation-only update for AWS Security Hub

# Release (2024-05-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.98.0](service/connect/CHANGELOG.md#v1980-2024-05-14)
  * **Feature**: Amazon Connect provides enhanced search capabilities for flows & flow modules on the Connect admin website and programmatically using APIs. You can search for flows and flow modules by name, description, type, status, and tags, to filter and identify a specific flow in your Connect instances.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.54.0](service/s3/CHANGELOG.md#v1540-2024-05-14)
  * **Feature**: Updated a few x-id in the http uri traits

# Release (2024-05-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.31.0](service/eventbridge/CHANGELOG.md#v1310-2024-05-13)
  * **Feature**: Amazon EventBridge introduces KMS customer-managed key (CMK) encryption support for custom and partner events published on EventBridge Event Bus (including default bus) and UpdateEventBus API.
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.8.0](service/vpclattice/CHANGELOG.md#v180-2024-05-13)
  * **Feature**: This release adds TLS Passthrough support. It also increases max number of target group per rule to 10.

# Release (2024-05-10)

## General Highlights
* **Feature**: Drop test dependency on x/net, h2 support is now available in the stdlib.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.161.1](service/ec2/CHANGELOG.md#v11611-2024-05-10)
  * **Bug Fix**: Fix serialization behavior of empty lists.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.31.0](service/greengrassv2/CHANGELOG.md#v1310-2024-05-10)
  * **Feature**: Mark ComponentVersion in ComponentDeploymentSpecification as required.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.140.0](service/sagemaker/CHANGELOG.md#v11400-2024-05-10)
  * **Feature**: Introduced support for G6 instance types on Sagemaker Notebook Instances and on SageMaker Studio for JupyterLab and CodeEditor applications.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.24.0](service/ssooidc/CHANGELOG.md#v1240-2024-05-10)
  * **Feature**: Updated request parameters for PKCE support.

# Release (2024-05-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.9.0](service/bedrockagentruntime/CHANGELOG.md#v190-2024-05-09)
  * **Feature**: This release adds support to provide guardrail configuration and modify inference parameters that are then used in RetrieveAndGenerate API in Agents for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.30.0](service/pinpoint/CHANGELOG.md#v1300-2024-05-09)
  * **Feature**: This release adds support for specifying email message headers for Email Templates, Campaigns, Journeys and Send Messages.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.28.2](service/route53resolver/CHANGELOG.md#v1282-2024-05-09)
  * **Documentation**: Update the DNS Firewall settings to correct a spelling issue.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.13.0](service/ssmsap/CHANGELOG.md#v1130-2024-05-09)
  * **Feature**: Added support for application-aware start/stop of SAP applications running on EC2 instances, with SSM for SAP
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.14.0](service/verifiedpermissions/CHANGELOG.md#v1140-2024-05-09)
  * **Feature**: Adds policy effect and actions fields to Policy API's.

# Release (2024-05-08)

## General Highlights
* **Bug Fix**: GoDoc improvement
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.38.0](service/cognitoidentityprovider/CHANGELOG.md#v1380-2024-05-08)
  * **Feature**: Add EXTERNAL_PROVIDER enum value to UserStatusType.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.161.0](service/ec2/CHANGELOG.md#v11610-2024-05-08)
  * **Feature**: Adding Precision Hardware Clock (PHC) to public API DescribeInstanceTypes
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.28.0](service/ecr/CHANGELOG.md#v1280-2024-05-08)
  * **Feature**: This release adds pull through cache rules support for GitLab container registry in Amazon ECR.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.33.2](service/fms/CHANGELOG.md#v1332-2024-05-08)
  * **Documentation**: The policy scope resource tag is always a string value, either a non-empty string or an empty string.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.40.0](service/polly/CHANGELOG.md#v1400-2024-05-08)
  * **Feature**: Add new engine - generative - that builds the most expressive conversational voices.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.32.0](service/sqs/CHANGELOG.md#v1320-2024-05-08)
  * **Feature**: This release adds MessageSystemAttributeNames to ReceiveMessageRequest to replace AttributeNames.

# Release (2024-05-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.22](service/b2bi/CHANGELOG.md#v100-preview22-2024-05-07)
  * **Documentation**: Documentation update to clarify the MappingTemplate definition.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.23.0](service/budgets/CHANGELOG.md#v1230-2024-05-07)
  * **Feature**: This release adds tag support for budgets and budget actions.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.21.0](service/resiliencehub/CHANGELOG.md#v1210-2024-05-07)
  * **Feature**: AWS Resilience Hub has expanded its drift detection capabilities by introducing a new type of drift detection - application resource drift. This new enhancement detects changes, such as the addition or deletion of resources within the application's input sources.
* `github.com/aws/aws-sdk-go-v2/service/route53profiles`: [v1.0.1](service/route53profiles/CHANGELOG.md#v101-2024-05-07)
  * **Documentation**: Doc only update for Route 53 profiles that fixes some link  issues

# Release (2024-05-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.52.0](service/medialive/CHANGELOG.md#v1520-2024-05-06)
  * **Feature**: AWS Elemental MediaLive now supports configuring how SCTE 35 passthrough triggers segment breaks in HLS and MediaPackage output groups. Previously, messages triggered breaks in all these output groups. The new option is to trigger segment breaks only in groups that have SCTE 35 passthrough enabled.

# Release (2024-05-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.10.0](service/bedrockagent/CHANGELOG.md#v1100-2024-05-03)
  * **Feature**: This release adds support for using Provisioned Throughput with Bedrock Agents.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.97.0](service/connect/CHANGELOG.md#v1970-2024-05-03)
  * **Feature**: This release adds 5 new APIs for managing attachments: StartAttachedFileUpload, CompleteAttachedFileUpload, GetAttachedFile, BatchGetAttachedFileMetadata, DeleteAttachedFile. These APIs can be used to programmatically upload and download attachments to Connect resources, like cases.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.17.0](service/connectcases/CHANGELOG.md#v1170-2024-05-03)
  * **Feature**: This feature supports the release of Files related items
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.37.1](service/datasync/CHANGELOG.md#v1371-2024-05-03)
  * **Documentation**: Updated guidance on using private or self-signed certificate authorities (CAs) with AWS DataSync object storage locations.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.26.0](service/inspector2/CHANGELOG.md#v1260-2024-05-03)
  * **Feature**: This release adds CSV format to GetCisScanReport for Inspector v2
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.139.0](service/sagemaker/CHANGELOG.md#v11390-2024-05-03)
  * **Feature**: Amazon SageMaker Inference now supports m6i, c6i, r6i, m7i, c7i, r7i and g5 instance types for Batch Transform Jobs
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.29.0](service/sesv2/CHANGELOG.md#v1290-2024-05-03)
  * **Feature**: Adds support for specifying replacement headers per BulkEmailEntry in SendBulkEmail in SESv2.

# Release (2024-05-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.32.0](service/dynamodb/CHANGELOG.md#v1320-2024-05-02)
  * **Feature**: This release adds support to specify an optional, maximum OnDemandThroughput for DynamoDB tables and global secondary indexes in the CreateTable or UpdateTable APIs. You can also override the OnDemandThroughput settings by calling the ImportTable, RestoreFromPointInTime, or RestoreFromBackup APIs.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.160.0](service/ec2/CHANGELOG.md#v11600-2024-05-02)
  * **Feature**: This release includes a new API for retrieving the public endorsement key of the EC2 instance's Nitro Trusted Platform Module (NitroTPM).
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.34.0](service/personalize/CHANGELOG.md#v1340-2024-05-02)
  * **Feature**: This releases ability to delete users and their data, including their metadata and interactions data, from a dataset group.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.18.0](service/redshiftserverless/CHANGELOG.md#v1180-2024-05-02)
  * **Feature**: Update Redshift Serverless List Scheduled Actions Output Response to include Namespace Name.

# Release (2024-05-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.9.0](service/bedrockagent/CHANGELOG.md#v190-2024-05-01)
  * **Feature**: This release adds support for using MongoDB Atlas as a vector store when creating a knowledge base.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.159.1](service/ec2/CHANGELOG.md#v11591-2024-05-01)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.23.0](service/personalizeruntime/CHANGELOG.md#v1230-2024-05-01)
  * **Feature**: This release adds support for a Reason attribute for predicted items generated by User-Personalization-v2.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.48.0](service/securityhub/CHANGELOG.md#v1480-2024-05-01)
  * **Feature**: Updated CreateMembers API request with limits.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.28.0](service/sesv2/CHANGELOG.md#v1280-2024-05-01)
  * **Feature**: Fixes ListContacts and ListImportJobs APIs to use POST instead of GET.

# Release (2024-04-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.15.0](service/chimesdkvoice/CHANGELOG.md#v1150-2024-04-30)
  * **Feature**: Due to changes made by the Amazon Alexa service, GetSipMediaApplicationAlexaSkillConfiguration and PutSipMediaApplicationAlexaSkillConfiguration APIs are no longer available for use. For more information, refer to the Alexa Smart Properties page.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.27.0](service/codeartifact/CHANGELOG.md#v1270-2024-04-30)
  * **Feature**: Add support for the Ruby package format.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.33.0](service/fms/CHANGELOG.md#v1330-2024-04-30)
  * **Feature**: AWS Firewall Manager now supports the network firewall service stream exception policy feature for accounts within your organization.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.21.0](service/omics/CHANGELOG.md#v1210-2024-04-30)
  * **Feature**: Add support for workflow sharing and dynamic run storage
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.33.0](service/opensearch/CHANGELOG.md#v1330-2024-04-30)
  * **Feature**: This release enables customers to create Route53 A and AAAA alias record types to point custom endpoint domain to OpenSearch domain's dualstack search endpoint.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.10.0](service/pinpointsmsvoicev2/CHANGELOG.md#v1100-2024-04-30)
  * **Feature**: Amazon Pinpoint has added two new features Multimedia services (MMS) and protect configurations. Use the three new MMS APIs to send media messages to a mobile phone which includes image, audio, text, or video files. Use the ten new protect configurations APIs to block messages to specific countries.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.6.0](service/qbusiness/CHANGELOG.md#v160-2024-04-30)
  * **Feature**: This is a general availability (GA) release of Amazon Q Business. Q Business enables employees in an enterprise to get comprehensive answers to complex questions and take actions through a unified, intuitive web-based chat experience - using an enterprise's existing content, data, and systems.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.63.0](service/quicksight/CHANGELOG.md#v1630-2024-04-30)
  * **Feature**: New Q embedding supporting Generative Q&A
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.28.0](service/route53resolver/CHANGELOG.md#v1280-2024-04-30)
  * **Feature**: Release of FirewallDomainRedirectionAction parameter on the Route 53 DNS Firewall Rule.  This allows customers to configure a DNS Firewall rule to inspect all the domains in the DNS redirection chain (default) , such as CNAME, ALIAS, DNAME, etc., or just the first domain and trust the rest.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.138.0](service/sagemaker/CHANGELOG.md#v11380-2024-04-30)
  * **Feature**: Amazon SageMaker Training now supports the use of attribute-based access control (ABAC) roles for training job execution roles. Amazon SageMaker Inference now supports G6 instance types.
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.22.7](service/signer/CHANGELOG.md#v1227-2024-04-30)
  * **Documentation**: Documentation updates for AWS Signer. Adds cross-account signing constraint and definitions for cross-account actions.

# Release (2024-04-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.16.0](service/connectcases/CHANGELOG.md#v1160-2024-04-29)
  * **Feature**: This feature releases DeleteField, DeletedLayout, and DeleteTemplate API's
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.25.0](service/inspector2/CHANGELOG.md#v1250-2024-04-29)
  * **Feature**: Update Inspector2 to include new Agentless API parameters.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.23.0](service/timestreamquery/CHANGELOG.md#v1230-2024-04-29)
  * **Feature**: This change allows users to update and describe account settings associated with their accounts.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.37.0](service/transcribe/CHANGELOG.md#v1370-2024-04-29)
  * **Feature**: This update provides error messaging for generative call summarization in Transcribe Call Analytics
* `github.com/aws/aws-sdk-go-v2/service/trustedadvisor`: [v1.4.0](service/trustedadvisor/CHANGELOG.md#v140-2024-04-29)
  * **Feature**: This release adds the BatchUpdateRecommendationResourceExclusion API to support batch updates of Recommendation Resource exclusion statuses and introduces a new exclusion status filter to the ListRecommendationResources and ListOrganizationRecommendationResources APIs.

# Release (2024-04-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.27.0](service/codepipeline/CHANGELOG.md#v1270-2024-04-26)
  * **Feature**: Add ability to manually and automatically roll back a pipeline stage to a previously successful execution.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.37.0](service/cognitoidentityprovider/CHANGELOG.md#v1370-2024-04-26)
  * **Feature**: Add LimitExceededException to SignUp errors
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.11.0](service/connectcampaigns/CHANGELOG.md#v1110-2024-04-26)
  * **Feature**: This release adds support for specifying if Answering Machine should wait for prompt sound.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.21.0](service/marketplaceentitlementservice/CHANGELOG.md#v1210-2024-04-26)
  * **Feature**: Releasing minor endpoint updates.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.11.0](service/oam/CHANGELOG.md#v1110-2024-04-26)
  * **Feature**: This release introduces support for Source Accounts to define which Metrics and Logs to share with the Monitoring Account
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.78.0](service/rds/CHANGELOG.md#v1780-2024-04-26)
  * **Feature**: SupportsLimitlessDatabase field added to describe-db-engine-versions to indicate whether the DB engine version supports Aurora Limitless Database.
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.22.0](service/support/CHANGELOG.md#v1220-2024-04-26)
  * **Feature**: Releasing minor endpoint updates.

# Release (2024-04-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.32.0](service/appsync/CHANGELOG.md#v1320-2024-04-25)
  * **Feature**: UpdateGraphQLAPI documentation update and datasource introspection secret arn update
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.32.0](service/fms/CHANGELOG.md#v1320-2024-04-25)
  * **Feature**: AWS Firewall Manager adds support for network ACL policies to manage Amazon Virtual Private Cloud (VPC) network access control lists (ACLs) for accounts in your organization.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.35.0](service/ivs/CHANGELOG.md#v1350-2024-04-25)
  * **Feature**: Bug Fix: IVS does not support arns with the `svs` prefix
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.13.0](service/ivsrealtime/CHANGELOG.md#v1130-2024-04-25)
  * **Feature**: Bug Fix: IVS Real Time does not support ARNs using the `svs` prefix.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.3](service/rds/CHANGELOG.md#v1773-2024-04-25)
  * **Documentation**: Updates Amazon RDS documentation for setting local time zones for RDS for Db2 DB instances.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.27.0](service/sfn/CHANGELOG.md#v1270-2024-04-25)
  * **Feature**: Add new ValidateStateMachineDefinition operation, which performs syntax checking on the definition of a Amazon States Language (ASL) state machine.

# Release (2024-04-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.37.0](service/datasync/CHANGELOG.md#v1370-2024-04-24)
  * **Feature**: This change allows users to disable and enable the schedules associated with their tasks.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.159.0](service/ec2/CHANGELOG.md#v11590-2024-04-24)
  * **Feature**: Launching capability for customers to enable or disable automatic assignment of public IPv4 addresses to their network interface
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.28.0](service/emrcontainers/CHANGELOG.md#v1280-2024-04-24)
  * **Feature**: EMRonEKS Service support for SecurityConfiguration enforcement for Spark Jobs.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.10.0](service/entityresolution/CHANGELOG.md#v1100-2024-04-24)
  * **Feature**: Support Batch Unique IDs Deletion.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.31.0](service/gamelift/CHANGELOG.md#v1310-2024-04-24)
  * **Feature**: Amazon GameLift releases container fleets support for public preview. Deploy Linux-based containerized game server software for hosting on Amazon GameLift.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.50.0](service/ssm/CHANGELOG.md#v1500-2024-04-24)
  * **Feature**: Add SSM DescribeInstanceProperties API to public AWS SDK.

# Release (2024-04-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.8.0](service/bedrock/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: This release introduces Model Evaluation and Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.8.0](service/bedrockagent/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: Introducing the ability to create multiple data sources per knowledge base, specify S3 buckets as data sources from external accounts, and exposing levers to define the deletion behavior of the underlying vector store data.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.8.0](service/bedrockagentruntime/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: This release introduces zero-setup file upload support for the RetrieveAndGenerate API. This allows you to chat with your data without setting up a Knowledge Base.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.8.0](service/bedrockruntime/CHANGELOG.md#v180-2024-04-23)
  * **Feature**: This release introduces Guardrails for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.38.0](service/costexplorer/CHANGELOG.md#v1380-2024-04-23)
  * **Feature**: Added additional metadata that might be applicable to your reservation recommendations.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.158.0](service/ec2/CHANGELOG.md#v11580-2024-04-23)
  * **Feature**: This release introduces EC2 AMI Deregistration Protection, a new AMI property that can be enabled by customers to protect an AMI against an unintended deregistration. This release also enables the AMI owners to view the AMI 'LastLaunchedTime' in DescribeImages API.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.24.5](service/pi/CHANGELOG.md#v1245-2024-04-23)
  * **Documentation**: Clarifies how aggregation works for GetResourceMetrics in the Performance Insights API.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.2](service/rds/CHANGELOG.md#v1772-2024-04-23)
  * **Documentation**: Fix the example ARN for ModifyActivityStreamRequest
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.18.0](service/workspacesweb/CHANGELOG.md#v1180-2024-04-23)
  * **Feature**: Added InstanceType and MaxConcurrentSessions parameters on CreatePortal and UpdatePortal Operations as well as the ability to read Customer Managed Key & Additional Encryption Context parameters on supported resources (Portal, BrowserSettings, UserSettings, IPAccessSettings)

# Release (2024-04-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.7.0](service/bedrockagent/CHANGELOG.md#v170-2024-04-22)
  * **Feature**: Releasing the support for simplified configuration and return of control
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.7.0](service/bedrockagentruntime/CHANGELOG.md#v170-2024-04-22)
  * **Feature**: Releasing the support for simplified configuration and return of control
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.10.0](service/paymentcryptography/CHANGELOG.md#v1100-2024-04-22)
  * **Feature**: Adding support to TR-31/TR-34 exports for optional headers, allowing customers to add additional metadata (such as key version and KSN) when exporting keys from the service.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.17.5](service/redshiftserverless/CHANGELOG.md#v1175-2024-04-22)
  * **Documentation**: Updates description of schedule field for scheduled actions.
* `github.com/aws/aws-sdk-go-v2/service/route53profiles`: [v1.0.0](service/route53profiles/CHANGELOG.md#v100-2024-04-22)
  * **Release**: New AWS service client module
  * **Feature**: Route 53 Profiles allows you to apply a central DNS configuration across many VPCs regardless of account.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.137.0](service/sagemaker/CHANGELOG.md#v11370-2024-04-22)
  * **Feature**: This release adds support for Real-Time Collaboration and Shared Space for JupyterLab App on SageMaker Studio.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.29.6](service/servicediscovery/CHANGELOG.md#v1296-2024-04-22)
  * **Documentation**: This release adds examples to several Cloud Map actions.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.47.0](service/transfer/CHANGELOG.md#v1470-2024-04-22)
  * **Feature**: Adding new API to support remote directory listing using SFTP connector

# Release (2024-04-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.80.0](service/glue/CHANGELOG.md#v1800-2024-04-19)
  * **Feature**: Adding RowFilter in the response for GetUnfilteredTableMetadata API
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.14.0](service/internetmonitor/CHANGELOG.md#v1140-2024-04-19)
  * **Feature**: This update introduces the GetInternetEvent and ListInternetEvents APIs, which provide access to internet events displayed on the Amazon CloudWatch Internet Weather Map.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.33.0](service/personalize/CHANGELOG.md#v1330-2024-04-19)
  * **Feature**: This releases auto training capability while creating a solution and automatically syncing latest solution versions when creating/updating a campaign

# Release (2024-04-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.26.0](service/drs/CHANGELOG.md#v1260-2024-04-18)
  * **Feature**: Outpost ARN added to Source Server and Recovery Instance
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.19.0](service/emrserverless/CHANGELOG.md#v1190-2024-04-18)
  * **Feature**: This release adds the capability to publish detailed Spark engine metrics to Amazon Managed Service for Prometheus (AMP) for  enhanced monitoring for Spark jobs.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.42.0](service/guardduty/CHANGELOG.md#v1420-2024-04-18)
  * **Feature**: Added IPv6Address fields for local and remote IP addresses
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.62.0](service/quicksight/CHANGELOG.md#v1620-2024-04-18)
  * **Feature**: This release adds support for the Cross Sheet Filter and Control features, and support for warnings in asset imports for any permitted errors encountered during execution
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.11.0](service/rolesanywhere/CHANGELOG.md#v1110-2024-04-18)
  * **Feature**: This release introduces the PutAttributeMapping and DeleteAttributeMapping APIs. IAM Roles Anywhere now provides the capability to define a set of mapping rules, allowing customers to specify which data is extracted from their X.509 end-entity certificates.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.136.0](service/sagemaker/CHANGELOG.md#v11360-2024-04-18)
  * **Feature**: Removed deprecated enum values and updated API documentation.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.39.0](service/workspaces/CHANGELOG.md#v1390-2024-04-18)
  * **Feature**: Adds new APIs for managing and sharing WorkSpaces BYOL configuration across accounts.

# Release (2024-04-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.157.0](service/ec2/CHANGELOG.md#v11570-2024-04-17)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.5.0](service/qbusiness/CHANGELOG.md#v150-2024-04-17)
  * **Feature**: This release adds support for IAM Identity Center (IDC) as the identity gateway for Q Business. It also allows users to provide an explicit intent for Q Business to identify how the Chat request should be handled.

# Release (2024-04-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.6.0](service/bedrockagent/CHANGELOG.md#v160-2024-04-16)
  * **Feature**: For Create Agent API, the agentResourceRoleArn parameter is no longer required.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.18.0](service/emrserverless/CHANGELOG.md#v1180-2024-04-16)
  * **Feature**: This release adds support for shuffle optimized disks that allow larger disk sizes and higher IOPS to efficiently run shuffle heavy workloads.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.9.0](service/entityresolution/CHANGELOG.md#v190-2024-04-16)
  * **Feature**: Cross Account Resource Support .
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.38.0](service/iotwireless/CHANGELOG.md#v1380-2024-04-16)
  * **Feature**: Add PublicGateways in the GetWirelessStatistics call response, indicating the LoRaWAN public network accessed by the device.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.32.0](service/lakeformation/CHANGELOG.md#v1320-2024-04-16)
  * **Feature**: This release adds Lake Formation managed RAM support for the 4 APIs - "DescribeLakeFormationIdentityCenterConfiguration", "CreateLakeFormationIdentityCenterConfiguration", "DescribeLakeFormationIdentityCenterConfiguration", and "DeleteLakeFormationIdentityCenterConfiguration"
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.13.0](service/m2/CHANGELOG.md#v1130-2024-04-16)
  * **Feature**: Adding new ListBatchJobRestartPoints API and support for restart batch job.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.11.0](service/mediapackagev2/CHANGELOG.md#v1110-2024-04-16)
  * **Feature**: Dash v2 is a MediaPackage V2 feature to support egressing on DASH manifest format.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.39.0](service/outposts/CHANGELOG.md#v1390-2024-04-16)
  * **Feature**: This release adds new APIs to allow customers to configure their Outpost capacity at order-time.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.30.0](service/wellarchitected/CHANGELOG.md#v1300-2024-04-16)
  * **Feature**: AWS Well-Architected now has a Connector for Jira to allow customers to efficiently track workload risks and improvement efforts and create closed-loop mechanisms.

# Release (2024-04-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.50.0](service/cloudformation/CHANGELOG.md#v1500-2024-04-12)
  * **Feature**: Adding support for the new parameter "IncludePropertyValues" in the CloudFormation DescribeChangeSet API. When this parameter is included, the DescribeChangeSet response will include more detailed information such as before and after values for the resource properties that will change.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.46.5](service/configservice/CHANGELOG.md#v1465-2024-04-12)
  * **Documentation**: Updates documentation for AWS Config
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.79.0](service/glue/CHANGELOG.md#v1790-2024-04-12)
  * **Feature**: Modifying request for GetUnfilteredTableMetadata for view-related fields.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.24.0](service/healthlake/CHANGELOG.md#v1240-2024-04-12)
  * **Feature**: Added new CREATE_FAILED status for data stores. Added new errorCause to DescribeFHIRDatastore API and ListFHIRDatastores API response for additional insights into data store creation and deletion workflows.
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.20.5](service/iotfleethub/CHANGELOG.md#v1205-2024-04-12)
  * **Documentation**: Documentation updates for AWS IoT Fleet Hub to clarify that Fleet Hub supports organization instance of IAM Identity Center.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.31.0](service/kms/CHANGELOG.md#v1310-2024-04-12)
  * **Feature**: This feature supports the ability to specify a custom rotation period for automatic key rotations, the ability to perform on-demand key rotations, and visibility into your key material rotations.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.38.0](service/mediatailor/CHANGELOG.md#v1380-2024-04-12)
  * **Feature**: Added InsertionMode to PlaybackConfigurations. This setting controls whether players can use stitched or guided ad insertion. The default for players that do not specify an insertion mode is stitched.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.8.1](service/neptunegraph/CHANGELOG.md#v181-2024-04-12)
  * **Documentation**: Update to API documentation to resolve customer reported issues.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.38.0](service/outposts/CHANGELOG.md#v1380-2024-04-12)
  * **Feature**: This release adds EXPEDITORS as a valid shipment carrier.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.44.0](service/redshift/CHANGELOG.md#v1440-2024-04-12)
  * **Feature**: Adds support for Amazon Redshift DescribeClusterSnapshots API to include Snapshot ARN response field.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.46.0](service/transfer/CHANGELOG.md#v1460-2024-04-12)
  * **Feature**: This change releases support for importing self signed certificates to the Transfer Family for sending outbound file transfers over TLS/HTTPS.

# Release (2024-04-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.37.0](service/batch/CHANGELOG.md#v1370-2024-04-11)
  * **Feature**: This release adds the task properties field to attempt details and the name field on EKS container detail.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.36.0](service/cloudfront/CHANGELOG.md#v1360-2024-04-11)
  * **Feature**: CloudFront origin access control extends support to AWS Lambda function URLs and AWS Elemental MediaPackage v2 origins.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.38.0](service/cloudwatch/CHANGELOG.md#v1380-2024-04-11)
  * **Feature**: This release adds support for Metric Characteristics for CloudWatch Anomaly Detection. Anomaly Detector now takes Metric Characteristics object with Periodic Spikes boolean field that tells Anomaly Detection that spikes that repeat at the same time every week are part of the expected pattern.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.34.1](service/codebuild/CHANGELOG.md#v1341-2024-04-11)
  * **Documentation**: Support access tokens for Bitbucket sources
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.32.0](service/iam/CHANGELOG.md#v1320-2024-04-11)
  * **Feature**: For CreateOpenIDConnectProvider API, the ThumbprintList parameter is no longer required.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.51.0](service/medialive/CHANGELOG.md#v1510-2024-04-11)
  * **Feature**: AWS Elemental MediaLive introduces workflow monitor, a new feature that enables the visualization and monitoring of your media workflows. Create signal maps of your existing workflows and monitor them by creating notification and monitoring template groups.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.20.0](service/omics/CHANGELOG.md#v1200-2024-04-11)
  * **Feature**: This release adds support for retrieval of S3 direct access metadata on sequence stores and read sets, and adds support for SHA256up and SHA512up HealthOmics ETags.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.1](service/rds/CHANGELOG.md#v1771-2024-04-11)
  * **Documentation**: Updates Amazon RDS documentation for Standard Edition 2 support in RDS Custom for Oracle.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.44.5](service/s3control/CHANGELOG.md#v1445-2024-04-11)
  * **Documentation**: Documentation updates for Amazon S3-control.

# Release (2024-04-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.12.0](service/cleanrooms/CHANGELOG.md#v1120-2024-04-10)
  * **Feature**: AWS Clean Rooms Differential Privacy is now fully available. Differential privacy protects against user-identification attempts.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.96.0](service/connect/CHANGELOG.md#v1960-2024-04-10)
  * **Feature**: This release adds new Submit Auto Evaluation Action for Amazon Connect Rules.
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.3.1](service/networkmonitor/CHANGELOG.md#v131-2024-04-10)
  * **Documentation**: Examples were added to CloudWatch Network Monitor commands.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.6.0](service/qconnect/CHANGELOG.md#v160-2024-04-10)
  * **Feature**: This release adds a new QiC public API updateSession and updates an existing QiC public API createSession
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.40.0](service/rekognition/CHANGELOG.md#v1400-2024-04-10)
  * **Feature**: Added support for ContentType to content moderation detections.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.3.0](service/supplychain/CHANGELOG.md#v130-2024-04-10)
  * **Feature**: This release includes API SendDataIntegrationEvent for AWS Supply Chain
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.5.0](service/workspacesthinclient/CHANGELOG.md#v150-2024-04-10)
  * **Feature**: Adding tags field to SoftwareSet. Removing tags fields from Summary objects. Changing the list of exceptions in tagging APIs. Fixing an issue where the SDK returns empty tags in Get APIs.

# Release (2024-04-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.34.0](service/codebuild/CHANGELOG.md#v1340-2024-04-09)
  * **Feature**: Add new webhook filter types for GitHub webhooks
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.53.0](service/mediaconvert/CHANGELOG.md#v1530-2024-04-09)
  * **Feature**: This release includes support for bringing your own fonts to use for burn-in or DVB-Sub captioning workflows.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.29.0](service/pinpoint/CHANGELOG.md#v1290-2024-04-09)
  * **Feature**: The OrchestrationSendingRoleArn has been added to the email channel and is used to send emails from campaigns or journeys.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.77.0](service/rds/CHANGELOG.md#v1770-2024-04-09)
  * **Feature**: This release adds support for specifying the CA certificate to use for the new db instance when restoring from db snapshot, restoring from s3, restoring to point in time, and creating a db instance read replica.

# Release (2024-04-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controlcatalog`: [v1.0.0](service/controlcatalog/CHANGELOG.md#v100-2024-04-08)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for AWS Control Catalog, a central catalog for AWS managed controls. This release includes 3 new APIs - ListDomains, ListObjectives, and ListCommonControls - that vend high-level data to categorize controls across the AWS platform.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.28.0](service/mgn/CHANGELOG.md#v1280-2024-04-08)
  * **Feature**: Added USE_SOURCE as default option to LaunchConfigurationTemplate bootMode parameter.
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.3.0](service/networkmonitor/CHANGELOG.md#v130-2024-04-08)
  * **Feature**: Updated the allowed monitorName length for CloudWatch Network Monitor.

# Release (2024-04-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.61.0](service/quicksight/CHANGELOG.md#v1610-2024-04-05)
  * **Feature**: Adding IAMIdentityCenterInstanceArn parameter to CreateAccountSubscription
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.22.0](service/resourcegroups/CHANGELOG.md#v1220-2024-04-05)
  * **Feature**: Added a new QueryErrorCode RESOURCE_TYPE_NOT_SUPPORTED that is returned by the ListGroupResources operation if the group query contains unsupported resource types.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.13.0](service/verifiedpermissions/CHANGELOG.md#v1130-2024-04-05)
  * **Feature**: Adding BatchIsAuthorizedWithToken API which supports multiple authorization requests against a PolicyStore given a bearer token.

# Release (2024-04-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.21](service/b2bi/CHANGELOG.md#v100-preview21-2024-04-04)
  * **Feature**: Adding support for X12 5010 HIPAA EDI version and associated transaction sets.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.11.0](service/cleanrooms/CHANGELOG.md#v1110-2024-04-04)
  * **Feature**: Feature: New schemaStatusDetails field to the existing Schema object that displays a status on Schema API responses to show whether a schema is queryable or not. New BatchGetSchemaAnalysisRule API to retrieve multiple schemaAnalysisRules using a single API call.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.156.0](service/ec2/CHANGELOG.md#v11560-2024-04-04)
  * **Feature**: Amazon EC2 G6 instances powered by NVIDIA L4 Tensor Core GPUs can be used for a wide range of graphics-intensive and machine learning use cases. Gr6 instances also feature NVIDIA L4 GPUs and can be used for graphics workloads with higher memory requirements.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.27.0](service/emrcontainers/CHANGELOG.md#v1270-2024-04-04)
  * **Feature**: This release adds support for integration with EKS AccessEntry APIs to enable automatic Cluster Access for EMR on EKS.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.34.0](service/ivs/CHANGELOG.md#v1340-2024-04-04)
  * **Feature**: API update to include an SRT ingest endpoint and passphrase for all channels.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.12.0](service/verifiedpermissions/CHANGELOG.md#v1120-2024-04-04)
  * **Feature**: Adds GroupConfiguration field to Identity Source API's

# Release (2024-04-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.4.0](service/cleanroomsml/CHANGELOG.md#v140-2024-04-03)
  * **Feature**: The release includes a public SDK for AWS Clean Rooms ML APIs, making them globally available to developers worldwide.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.49.0](service/cloudformation/CHANGELOG.md#v1490-2024-04-03)
  * **Feature**: This release would return a new field - PolicyAction in cloudformation's existed DescribeChangeSetResponse, showing actions we are going to apply on the physical resource (e.g., Delete, Retain) according to the user's template
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.8.0](service/datazone/CHANGELOG.md#v180-2024-04-03)
  * **Feature**: This release supports the feature of dataQuality to enrich asset with dataQualityResult in Amazon DataZone.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.34.0](service/docdb/CHANGELOG.md#v1340-2024-04-03)
  * **Feature**: This release adds Global Cluster Switchover capability which enables you to change your global cluster's primary AWS Region, the region that serves writes, while preserving the replication between all regions in the global cluster.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.27.0](service/groundstation/CHANGELOG.md#v1270-2024-04-03)
  * **Feature**: This release adds visibilityStartTime and visibilityEndTime to DescribeContact and ListContacts responses.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.54.0](service/lambda/CHANGELOG.md#v1540-2024-04-03)
  * **Feature**: Add Ruby 3.3 (ruby3.3) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.50.0](service/medialive/CHANGELOG.md#v1500-2024-04-03)
  * **Feature**: Cmaf Ingest outputs are now supported in Media Live
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.8.0](service/medicalimaging/CHANGELOG.md#v180-2024-04-03)
  * **Feature**: SearchImageSets API now supports following enhancements - Additional support for searching on UpdatedAt and SeriesInstanceUID - Support for searching existing filters between dates/times - Support for sorting the search result by Ascending/Descending - Additional parameters returned in the response
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.45.0](service/transfer/CHANGELOG.md#v1450-2024-04-03)
  * **Feature**: Add ability to specify Security Policies for SFTP Connectors

# Release (2024-04-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.41.7](service/ecs/CHANGELOG.md#v1417-2024-04-02)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.78.0](service/glue/CHANGELOG.md#v1780-2024-04-02)
  * **Feature**: Adding View related fields to responses of read-only Table APIs.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.12.5](service/ivschat/CHANGELOG.md#v1125-2024-04-02)
  * **Documentation**: Doc-only update. Changed "Resources" to "Key Concepts" in docs and updated text.
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.10.0](service/rolesanywhere/CHANGELOG.md#v1100-2024-04-02)
  * **Feature**: This release increases the limit on the roleArns request parameter for the *Profile APIs that support it. This parameter can now take up to 250 role ARNs.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.47.2](service/securityhub/CHANGELOG.md#v1472-2024-04-02)
  * **Documentation**: Documentation updates for AWS Security Hub

# Release (2024-04-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.37.0](service/cloudwatch/CHANGELOG.md#v1370-2024-04-01)
  * **Feature**: This release adds support for CloudWatch Anomaly Detection on cross-account metrics. SingleMetricAnomalyDetector and MetricDataQuery inputs to Anomaly Detection APIs now take an optional AccountId field.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.7.0](service/datazone/CHANGELOG.md#v170-2024-04-01)
  * **Feature**: This release supports the feature of AI recommendations for descriptions to enrich the business data catalog in Amazon DataZone.
* `github.com/aws/aws-sdk-go-v2/service/deadline`: [v1.0.0](service/deadline/CHANGELOG.md#v100-2024-04-01)
  * **Release**: New AWS service client module
  * **Feature**: AWS Deadline Cloud is a new fully managed service that helps customers set up, deploy, and scale rendering projects in minutes, so they can improve the efficiency of their rendering pipelines and take on more projects.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.39.5](service/emr/CHANGELOG.md#v1395-2024-04-01)
  * **Documentation**: This release fixes a broken link in the documentation.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.37.0](service/lightsail/CHANGELOG.md#v1370-2024-04-01)
  * **Feature**: This release adds support to upgrade the TLS version of the distribution.

# Release (2024-03-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.20](service/b2bi/CHANGELOG.md#v100-preview20-2024-03-29)
  * **Feature**: Supporting new EDI X12 transaction sets for X12 versions 4010, 4030, and 5010.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.33.0](service/codebuild/CHANGELOG.md#v1330-2024-03-29)
  * **Feature**: Add new fleet status code for Reserved Capacity.
* `github.com/aws/aws-sdk-go-v2/service/codeconnections`: [v1.0.0](service/codeconnections/CHANGELOG.md#v100-2024-03-29)
  * **Release**: New AWS service client module
  * **Feature**: Duplicating the CodeStar Connections service into the new, rebranded AWS CodeConnections service.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.13.0](service/internetmonitor/CHANGELOG.md#v1130-2024-03-29)
  * **Feature**: This release adds support to allow customers to track cross account monitors through ListMonitor, GetMonitor, ListHealthEvents, GetHealthEvent, StartQuery APIs.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.37.0](service/iotwireless/CHANGELOG.md#v1370-2024-03-29)
  * **Feature**: Add support for retrieving key historical and live metrics for LoRaWAN devices and gateways
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.26.0](service/marketplacecatalog/CHANGELOG.md#v1260-2024-03-29)
  * **Feature**: This release enhances the ListEntities API to support ResaleAuthorizationId filter and sort for OfferEntity in the request and the addition of a ResaleAuthorizationId field in the response of OfferSummary.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.8.0](service/neptunegraph/CHANGELOG.md#v180-2024-03-29)
  * **Feature**: Add the new API Start-Import-Task for Amazon Neptune Analytics.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.135.0](service/sagemaker/CHANGELOG.md#v11350-2024-03-29)
  * **Feature**: This release adds support for custom images for the CodeEditor App on SageMaker Studio

# Release (2024-03-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.13.0](service/codecatalyst/CHANGELOG.md#v1130-2024-03-28)
  * **Feature**: This release adds support for understanding pending changes to subscriptions by including two new response parameters for the GetSubscription API for Amazon CodeCatalyst.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.34.0](service/computeoptimizer/CHANGELOG.md#v1340-2024-03-28)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate recommendations with a new customization preference, Memory Utilization.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.155.0](service/ec2/CHANGELOG.md#v11550-2024-03-28)
  * **Feature**: Amazon EC2 C7gd, M7gd and R7gd metal instances with up to 3.8 TB of local NVMe-based SSD block-level storage have up to 45% improved real-time NVMe storage performance than comparable Graviton2-based instances.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.42.0](service/eks/CHANGELOG.md#v1420-2024-03-28)
  * **Feature**: Add multiple customer error code to handle customer caused failure when managing EKS node groups
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.41.0](service/guardduty/CHANGELOG.md#v1410-2024-03-28)
  * **Feature**: Add EC2 support for GuardDuty Runtime Monitoring auto management.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.7.0](service/neptunegraph/CHANGELOG.md#v170-2024-03-28)
  * **Feature**: Update ImportTaskCancelled waiter to evaluate task state correctly and minor documentation changes.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.10.0](service/oam/CHANGELOG.md#v1100-2024-03-28)
  * **Feature**: This release adds support for sharing AWS::InternetMonitor::Monitor resources.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.60.0](service/quicksight/CHANGELOG.md#v1600-2024-03-28)
  * **Feature**: Amazon QuickSight: Adds support for setting up VPC Endpoint restrictions for accessing QuickSight Website.

# Release (2024-03-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.36.0](service/batch/CHANGELOG.md#v1360-2024-03-27)
  * **Feature**: This feature allows AWS Batch to support configuration of imagePullSecrets and allowPrivilegeEscalation for jobs running on EKS
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.5.0](service/bedrockagent/CHANGELOG.md#v150-2024-03-27)
  * **Feature**: This changes introduces metadata documents statistics and also updates the documentation for bedrock agent.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.6.0](service/bedrockagentruntime/CHANGELOG.md#v160-2024-03-27)
  * **Feature**: This release introduces filtering support on Retrieve and RetrieveAndGenerate APIs.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.38.0](service/elasticache/CHANGELOG.md#v1380-2024-03-27)
  * **Feature**: Added minimum capacity to  Amazon ElastiCache Serverless. This feature allows customer to ensure minimum capacity even without current load
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.28.5](service/secretsmanager/CHANGELOG.md#v1285-2024-03-27)
  * **Documentation**: Documentation updates for Secrets Manager

# Release (2024-03-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.5.0](service/bedrockagentruntime/CHANGELOG.md#v150-2024-03-26)
  * **Feature**: This release adds support to customize prompts sent through the RetrieveAndGenerate API in Agents for Amazon Bedrock.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.37.0](service/costexplorer/CHANGELOG.md#v1370-2024-03-26)
  * **Feature**: Adds support for backfill of cost allocation tags, with new StartCostAllocationTagBackfill and ListCostAllocationTagBackfillHistory API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.154.0](service/ec2/CHANGELOG.md#v11540-2024-03-26)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.41.5](service/ecs/CHANGELOG.md#v1415-2024-03-26)
  * **Documentation**: This is a documentation update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.24.0](service/finspace/CHANGELOG.md#v1240-2024-03-26)
  * **Feature**: Add new operation delete-kx-cluster-node and add status parameter to list-kx-cluster-node operation.

# Release (2024-03-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/dynamodb/attributevalue`: [v1.13.12](feature/dynamodb/attributevalue/CHANGELOG.md#v11312-2024-03-25)
  * **Bug Fix**: Removes some duplicated reflection-based calls in the marshaler.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.32.0](service/codebuild/CHANGELOG.md#v1320-2024-03-25)
  * **Feature**: Supporting GitLab and GitLab Self Managed as source types in AWS CodeBuild.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.153.0](service/ec2/CHANGELOG.md#v11530-2024-03-25)
  * **Feature**: Added support for ModifyInstanceMetadataDefaults and GetInstanceMetadataDefaults to set Instance Metadata Service account defaults
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.41.4](service/ecs/CHANGELOG.md#v1414-2024-03-25)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.26.0](service/emrcontainers/CHANGELOG.md#v1260-2024-03-25)
  * **Feature**: This release increases the number of supported job template parameters from 20 to 100.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.23.0](service/globalaccelerator/CHANGELOG.md#v1230-2024-03-25)
  * **Feature**: AWS Global Accelerator now supports cross-account sharing for bring your own IP addresses.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.49.0](service/medialive/CHANGELOG.md#v1490-2024-03-25)
  * **Feature**: Exposing TileMedia H265 options
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.134.0](service/sagemaker/CHANGELOG.md#v11340-2024-03-25)
  * **Feature**: Introduced support for the following new instance types on SageMaker Studio for JupyterLab and CodeEditor applications: m6i, m6id, m7i, c6i, c6id, c7i, r6i, r6id, r7i, and p5

# Release (2024-03-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.28.4](service/firehose/CHANGELOG.md#v1284-2024-03-22)
  * **Documentation**: Updates Amazon Firehose documentation for message regarding Enforcing Tags IAM Policy.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.50.0](service/kendra/CHANGELOG.md#v1500-2024-03-22)
  * **Feature**: Documentation update, March 2024. Corrects some docs for Amazon Kendra.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.28.0](service/pricing/CHANGELOG.md#v1280-2024-03-22)
  * **Feature**: Add ResourceNotFoundException to ListPriceLists and GetPriceListFileUrl APIs
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.9.0](service/rolesanywhere/CHANGELOG.md#v190-2024-03-22)
  * **Feature**: This release relaxes constraints on the durationSeconds request parameter for the *Profile APIs that support it. This parameter can now take on values that go up to 43200.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.47.0](service/securityhub/CHANGELOG.md#v1470-2024-03-22)
  * **Feature**: Added new resource detail object to ASFF, including resource for LastKnownExploitAt

# Release (2024-03-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/ec2/imds`: [v1.16.0](feature/ec2/imds/CHANGELOG.md#v1160-2024-03-21)
  * **Feature**: Add config switch `DisableDefaultTimeout` that allows you to disable the default operation timeout (5 seconds) for IMDS calls.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.26.0](service/codeartifact/CHANGELOG.md#v1260-2024-03-21)
  * **Feature**: This release adds Package groups to CodeArtifact so you can more conveniently configure package origin controls for multiple packages.

# Release (2024-03-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.29.0](service/accessanalyzer/CHANGELOG.md#v1290-2024-03-20)
  * **Feature**: This release adds support for policy validation and external access findings for DynamoDB tables and streams. IAM Access Analyzer helps you author functional and secure resource-based policies and identify cross-account access. Updated service API, documentation, and paginators.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.31.2](service/codebuild/CHANGELOG.md#v1312-2024-03-20)
  * **Documentation**: This release adds support for new webhook events (RELEASED and PRERELEASED) and filter types (TAG_NAME and RELEASE_NAME).
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.95.0](service/connect/CHANGELOG.md#v1950-2024-03-20)
  * **Feature**: This release updates the *InstanceStorageConfig APIs to support a new ResourceType: REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS. Use this resource type to enable streaming for real-time analysis of chat contacts and to associate a Kinesis stream where real-time analysis chat segments will be published.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.31.0](service/dynamodb/CHANGELOG.md#v1310-2024-03-20)
  * **Feature**: This release introduces 3 new APIs ('GetResourcePolicy', 'PutResourcePolicy' and 'DeleteResourcePolicy') and modifies the existing 'CreateTable' API for the resource-based policy support. It also modifies several APIs to accept a 'TableArn' for the 'TableName' parameter.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.12.0](service/managedblockchainquery/CHANGELOG.md#v1120-2024-03-20)
  * **Feature**: AMB Query: update GetTransaction to include transactionId as input
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.19.0](service/savingsplans/CHANGELOG.md#v1190-2024-03-20)
  * **Feature**: Introducing the Savings Plans Return feature enabling customers to return their Savings Plans within 7 days of purchase.

# Release (2024-03-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.35.0](service/cloudwatchlogs/CHANGELOG.md#v1350-2024-03-19)
  * **Feature**: Update LogSamples field in Anomaly model to be a list of LogEvent
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.152.0](service/ec2/CHANGELOG.md#v11520-2024-03-19)
  * **Feature**: This release adds the new DescribeMacHosts API operation for getting information about EC2 Mac Dedicated Hosts. Users can now see the latest macOS versions that their underlying Apple Mac can support without needing to be updated.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.23.0](service/finspace/CHANGELOG.md#v1230-2024-03-19)
  * **Feature**: Adding new attributes readWrite and onDemand to dataview models for Database Maintenance operations.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.11.0](service/managedblockchainquery/CHANGELOG.md#v1110-2024-03-19)
  * **Feature**: Introduces a new API for Amazon Managed Blockchain Query: ListFilteredTransactionEvents.

# Release (2024-03-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.26.0
  * **Feature**: Add no-op rate limiting implementation `ratelimit.None`, which allows disabling of client-side retry quota behavior.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.48.0](service/cloudformation/CHANGELOG.md#v1480-2024-03-18)
  * **Feature**: This release supports for a new API ListStackSetAutoDeploymentTargets, which provider auto-deployment configuration as a describable resource. Customers can now view the specific combinations of regions and OUs that are being auto-deployed.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.30.0](service/kms/CHANGELOG.md#v1300-2024-03-18)
  * **Feature**: Adds the ability to use the default policy name by omitting the policyName parameter in calls to PutKeyPolicy and GetKeyPolicy
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.37.0](service/mediatailor/CHANGELOG.md#v1370-2024-03-18)
  * **Feature**: This release adds support to allow customers to show different content within a channel depending on metadata associated with the viewer.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.76.0](service/rds/CHANGELOG.md#v1760-2024-03-18)
  * **Feature**: This release launches the ModifyIntegration API and support for data filtering for zero-ETL Integrations.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.53.0](service/s3/CHANGELOG.md#v1530-2024-03-18)
  * **Feature**: Fix two issues with response root node names.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.22.4](service/timestreamquery/CHANGELOG.md#v1224-2024-03-18)
  * **Documentation**: Documentation updates, March 2024

# Release (2024-03-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.34.0](service/backup/CHANGELOG.md#v1340-2024-03-15)
  * **Feature**: This release introduces a boolean attribute ManagedByAWSBackupOnly as part of ListRecoveryPointsByResource api to filter the recovery points based on ownership. This attribute can be used to filter out the recovery points protected by AWSBackup.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.31.0](service/codebuild/CHANGELOG.md#v1310-2024-03-15)
  * **Feature**: AWS CodeBuild now supports overflow behavior on Reserved Capacity.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.94.0](service/connect/CHANGELOG.md#v1940-2024-03-15)
  * **Feature**: This release adds Hierarchy based Access Control fields to Security Profile public APIs and adds support for UserAttributeFilter to SearchUsers API.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.151.0](service/ec2/CHANGELOG.md#v11510-2024-03-15)
  * **Feature**: Add media accelerator and neuron device information on the describe instance types API.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.25.0](service/kinesisanalyticsv2/CHANGELOG.md#v1250-2024-03-15)
  * **Feature**: Support for Flink 1.18 in Managed Service for Apache Flink
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.52.1](service/s3/CHANGELOG.md#v1521-2024-03-15)
  * **Documentation**: Documentation updates for Amazon S3.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.133.0](service/sagemaker/CHANGELOG.md#v11330-2024-03-15)
  * **Feature**: Adds m6i, m6id, m7i, c6i, c6id, c7i, r6i r6id, r7i, p5 instance type support to Sagemaker Notebook Instances and miscellaneous wording fixes for previous Sagemaker documentation.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.4.0](service/workspacesthinclient/CHANGELOG.md#v140-2024-03-15)
  * **Feature**: Removed unused parameter kmsKeyArn from UpdateDeviceRequest

# Release (2024-03-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.21.3](service/amplify/CHANGELOG.md#v1213-2024-03-14)
  * **Documentation**: Documentation updates for Amplify. Identifies the APIs available only to apps created using Amplify Gen 1.
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.23.0](service/ec2instanceconnect/CHANGELOG.md#v1230-2024-03-14)
  * **Feature**: This release includes a new exception type "SerialConsoleSessionUnsupportedException" for SendSerialConsoleSSHPublicKey API.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.30.3](service/elasticloadbalancingv2/CHANGELOG.md#v1303-2024-03-14)
  * **Documentation**: This release allows you to configure HTTP client keep-alive duration for communication between clients and Application Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.24.0](service/fis/CHANGELOG.md#v1240-2024-03-14)
  * **Feature**: This release adds support for previewing target resources before running a FIS experiment. It also adds resource ARNs for actions, experiments, and experiment templates to API responses.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.75.2](service/rds/CHANGELOG.md#v1752-2024-03-14)
  * **Documentation**: Updates Amazon RDS documentation for EBCDIC collation for RDS for Db2.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.28.3](service/secretsmanager/CHANGELOG.md#v1283-2024-03-14)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb`: [v1.0.0](service/timestreaminfluxdb/CHANGELOG.md#v100-2024-03-14)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon Timestream for InfluxDB. Amazon Timestream for InfluxDB is a new time-series database engine that makes it easy for application developers and DevOps teams to run InfluxDB databases on AWS for near real-time time-series applications using open source APIs.

# Release (2024-03-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.12.0](service/ivsrealtime/CHANGELOG.md#v1120-2024-03-13)
  * **Feature**: adds support for multiple new composition layout configuration options (grid, pip)
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.24.0](service/kinesisanalyticsv2/CHANGELOG.md#v1240-2024-03-13)
  * **Feature**: Support new RuntimeEnvironmentUpdate parameter within UpdateApplication API allowing callers to change the Flink version upon which their application runs.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.52.0](service/s3/CHANGELOG.md#v1520-2024-03-13)
  * **Feature**: This release makes the default option for S3 on Outposts request signing to use the SigV4A algorithm when using AWS Common Runtime (CRT).

# Release (2024-03-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.47.2](service/cloudformation/CHANGELOG.md#v1472-2024-03-12)
  * **Documentation**: CloudFormation documentation update for March, 2024
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.93.0](service/connect/CHANGELOG.md#v1930-2024-03-12)
  * **Feature**: This release increases MaxResults limit to 500 in request for SearchUsers, SearchQueues and SearchRoutingProfiles APIs of Amazon Connect.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.150.1](service/ec2/CHANGELOG.md#v11501-2024-03-12)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.31.0](service/kafka/CHANGELOG.md#v1310-2024-03-12)
  * **Feature**: Added support for specifying the starting position of topic replication in MSK-Replicator.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.49.3](service/ssm/CHANGELOG.md#v1493-2024-03-12)
  * **Documentation**: March 2024 doc-only updates for Systems Manager.

# Release (2024-03-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.25.0](service/codestarconnections/CHANGELOG.md#v1250-2024-03-11)
  * **Feature**: Added a sync configuration enum to disable publishing of deployment status to source providers (PublishDeploymentStatus). Added a sync configuration enum (TriggerStackUpdateOn) to only trigger changes.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.37.3](service/elasticache/CHANGELOG.md#v1373-2024-03-11)
  * **Documentation**: Revisions to API text that are now to be carried over to SDK text, changing usages of "SFO" in code examples to "us-west-1", and some other typos.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.10.0](service/mediapackagev2/CHANGELOG.md#v1100-2024-03-11)
  * **Feature**: This release enables customers to safely update their MediaPackage v2 channel groups, channels and origin endpoints using entity tags.

# Release (2024-03-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.35.0](service/batch/CHANGELOG.md#v1350-2024-03-08)
  * **Feature**: This release adds JobStateTimeLimitActions setting to the Job Queue API. It allows you to configure an action Batch can take for a blocking job in front of the queue after the defined period of time. The new parameter applies for ECS, EKS, and FARGATE Job Queues.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.4.2](service/bedrockagentruntime/CHANGELOG.md#v142-2024-03-08)
  * **Documentation**: Documentation update for Bedrock Runtime Agent
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.39.0](service/cloudtrail/CHANGELOG.md#v1390-2024-03-08)
  * **Feature**: Added exceptions to CreateTrail, DescribeTrails, and ListImportFailures APIs.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.30.3](service/codebuild/CHANGELOG.md#v1303-2024-03-08)
  * **Documentation**: This release adds support for a new webhook event: PULL_REQUEST_CLOSED.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.36.0](service/cognitoidentityprovider/CHANGELOG.md#v1360-2024-03-08)
  * **Feature**: Add ConcurrentModificationException to SetUserPoolMfaConfig
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.40.0](service/guardduty/CHANGELOG.md#v1400-2024-03-08)
  * **Feature**: Add RDS Provisioned and Serverless Usage types
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.44.0](service/transfer/CHANGELOG.md#v1440-2024-03-08)
  * **Feature**: Added DES_EDE3_CBC to the list of supported encryption algorithms for messages sent with an AS2 connector.

# Release (2024-03-07)

## General Highlights
* **Bug Fix**: Remove dependency on go-cmp.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.25.3
  * **Bug Fix**: Remove dependency on go-cmp.
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.29.0](service/appconfig/CHANGELOG.md#v1290-2024-03-07)
  * **Feature**: AWS AppConfig now supports dynamic parameters, which enhance the functionality of AppConfig Extensions by allowing you to provide parameter values to your Extensions at the time you deploy your configuration.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.150.0](service/ec2/CHANGELOG.md#v11500-2024-03-07)
  * **Feature**: This release adds an optional parameter to RegisterImage and CopyImage APIs to support tagging AMIs at the time of creation.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.21.0](service/grafana/CHANGELOG.md#v1210-2024-03-07)
  * **Feature**: Adds support for the new GrafanaToken as part of the Amazon Managed Grafana Enterprise plugins upgrade to associate your AWS account with a Grafana Labs account.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.53.2](service/lambda/CHANGELOG.md#v1532-2024-03-07)
  * **Documentation**: Documentation updates for AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.8.0](service/paymentcryptographydata/CHANGELOG.md#v180-2024-03-07)
  * **Feature**: AWS Payment Cryptography EMV Decrypt Feature  Release
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.75.1](service/rds/CHANGELOG.md#v1751-2024-03-07)
  * **Documentation**: Updates Amazon RDS documentation for io2 storage for Multi-AZ DB clusters
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.26.2](service/snowball/CHANGELOG.md#v1262-2024-03-07)
  * **Documentation**: Doc-only update for change to EKS-Anywhere ordering.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.48.0](service/wafv2/CHANGELOG.md#v1480-2024-03-07)
  * **Feature**: You can increase the max request body inspection size for some regional resources. The size setting is in the web ACL association config. Also, the AWSManagedRulesBotControlRuleSet EnableMachineLearning setting now takes a Boolean instead of a primitive boolean type, for languages like Java.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.38.2](service/workspaces/CHANGELOG.md#v1382-2024-03-07)
  * **Documentation**: Added note for user decoupling

# Release (2024-03-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.30.3](service/dynamodb/CHANGELOG.md#v1303-2024-03-06)
  * **Documentation**: Doc only updates for DynamoDB documentation
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.33.0](service/imagebuilder/CHANGELOG.md#v1330-2024-03-06)
  * **Feature**: Add PENDING status to Lifecycle Execution resource status. Add StartTime and EndTime to ListLifecycleExecutionResource API response.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.26.2](service/mwaa/CHANGELOG.md#v1262-2024-03-06)
  * **Documentation**: Amazon MWAA adds support for Apache Airflow v2.8.1.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.75.0](service/rds/CHANGELOG.md#v1750-2024-03-06)
  * **Feature**: Updated the input of CreateDBCluster and ModifyDBCluster to support setting CA certificates. Updated the output of DescribeDBCluster to show current CA certificate setting value.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.43.2](service/redshift/CHANGELOG.md#v1432-2024-03-06)
  * **Documentation**: Update for documentation only. Covers port ranges, definition updates for data sharing, and definition updates to cluster-snapshot documentation.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.11.0](service/verifiedpermissions/CHANGELOG.md#v1110-2024-03-06)
  * **Feature**: Deprecating details in favor of configuration for GetIdentitySource and ListIdentitySources APIs.

# Release (2024-03-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.23.3](service/apigateway/CHANGELOG.md#v1233-2024-03-05)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.1.2](service/chatbot/CHANGELOG.md#v112-2024-03-05)
  * **Documentation**: Minor update to documentation.
* `github.com/aws/aws-sdk-go-v2/service/internal/presigned-url`: [v1.11.4](service/internal/presigned-url/CHANGELOG.md#v1114-2024-03-05)
  * **Bug Fix**: Restore typo'd API `AddAsIsInternalPresigingMiddleware` as an alias for backwards compatibility.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.27.0](service/organizations/CHANGELOG.md#v1270-2024-03-05)
  * **Feature**: This release contains an endpoint addition
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.27.0](service/sesv2/CHANGELOG.md#v1270-2024-03-05)
  * **Feature**: Adds support for providing custom headers within SendEmail and SendBulkEmail for SESv2.

# Release (2024-03-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/cloudfront/sign`: [v1.7.0](feature/cloudfront/sign/CHANGELOG.md#v170-2024-03-04)
  * **Feature**: Add http.SameSite config in CookieOptions.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.47.0](service/cloudformation/CHANGELOG.md#v1470-2024-03-04)
  * **Feature**: Add DetailedStatus field to DescribeStackEvents and DescribeStacks APIs
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.33.2](service/docdb/CHANGELOG.md#v1332-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.149.3](service/ec2/CHANGELOG.md#v11493-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.43.0](service/fsx/CHANGELOG.md#v1430-2024-03-04)
  * **Feature**: Added support for creating FSx for NetApp ONTAP file systems with up to 12 HA pairs, delivering up to 72 GB/s of read throughput and 12 GB/s of write throughput.
* `github.com/aws/aws-sdk-go-v2/service/internal/endpoint-discovery`: [v1.9.3](service/internal/endpoint-discovery/CHANGELOG.md#v193-2024-03-04)
  * **Bug Fix**: Fix misaligned struct member used in atomic operation. This fixes a panic caused by attempting to atomically access a struct member which is not 64-bit aligned when running on 32-bit arch, due to the smaller sync.Map struct.
* `github.com/aws/aws-sdk-go-v2/service/internal/presigned-url`: [v1.11.3](service/internal/presigned-url/CHANGELOG.md#v1113-2024-03-04)
  * **Bug Fix**: Correct a typo in internal AddAsIsPresigningMiddleware API.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.31.2](service/neptune/CHANGELOG.md#v1312-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.26.0](service/organizations/CHANGELOG.md#v1260-2024-03-04)
  * **Feature**: Documentation update for AWS Organizations
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.39.2](service/polly/CHANGELOG.md#v1392-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.74.1](service/rds/CHANGELOG.md#v1741-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.51.2](service/s3/CHANGELOG.md#v1512-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.28.2](service/sts/CHANGELOG.md#v1282-2024-03-04)
  * **Bug Fix**: Update internal/presigned-url dependency for corrected API name.

# Release (2024-03-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.28.2](service/accessanalyzer/CHANGELOG.md#v1282-2024-03-01)
  * **Documentation**: Fixed a typo in description field.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.40.2](service/autoscaling/CHANGELOG.md#v1402-2024-03-01)
  * **Documentation**: With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.149.2](service/ec2/CHANGELOG.md#v11492-2024-03-01)
  * **Documentation**: With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.

# Release (2024-02-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.9.0](service/docdbelastic/CHANGELOG.md#v190-2024-02-29)
  * **Feature**: Launched Elastic Clusters Readable Secondaries, Start/Stop, Configurable Shard Instance count, Automatic Backups and Snapshot Copying
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.41.0](service/eks/CHANGELOG.md#v1410-2024-02-29)
  * **Feature**: Added support for new AL2023 AMIs to the supported AMITypes.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.43.0](service/lexmodelsv2/CHANGELOG.md#v1430-2024-02-29)
  * **Feature**: This release makes AMAZON.QnAIntent generally available in Amazon Lex. This generative AI feature leverages large language models available through Amazon Bedrock to automate frequently asked questions (FAQ) experience for end-users.
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.9.0](service/migrationhuborchestrator/CHANGELOG.md#v190-2024-02-29)
  * **Feature**: Adds new CreateTemplate, UpdateTemplate and DeleteTemplate APIs.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.59.0](service/quicksight/CHANGELOG.md#v1590-2024-02-29)
  * **Feature**: TooltipTarget for Combo chart visuals; ColumnConfiguration limit increase to 2000; Documentation Update
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.132.0](service/sagemaker/CHANGELOG.md#v11320-2024-02-29)
  * **Feature**: Adds support for ModelDataSource in Model Packages to support unzipped models. Adds support to specify SourceUri for models which allows registration of models without mandating a container for hosting. Using SourceUri, customers can decouple the model from hosting information during registration.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.13.0](service/securitylake/CHANGELOG.md#v1130-2024-02-29)
  * **Feature**: Add capability to update the Data Lake's MetaStoreManager Role in order to perform required data lake updates to use Iceberg table format in their data lake or update the role for any other reason.

# Release (2024-02-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.34.0](service/batch/CHANGELOG.md#v1340-2024-02-28)
  * **Feature**: This release adds Batch support for configuration of multicontainer jobs in ECS, Fargate, and EKS. This support is available for all types of jobs, including both array jobs and multi-node parallel jobs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.4.0](service/bedrockagentruntime/CHANGELOG.md#v140-2024-02-28)
  * **Feature**: This release adds support to override search strategy performed by the Retrieve and RetrieveAndGenerate APIs for Amazon Bedrock Agents
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.36.0](service/costexplorer/CHANGELOG.md#v1360-2024-02-28)
  * **Feature**: This release introduces the new API 'GetApproximateUsageRecords', which retrieves estimated usage records for hourly granularity or resource-level data at daily granularity.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.53.0](service/iot/CHANGELOG.md#v1530-2024-02-28)
  * **Feature**: This release reduces the maximum results returned per query invocation from 500 to 100 for the SearchIndex API. This change has no implications as long as the API is invoked until the nextToken is NULL.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.47.0](service/wafv2/CHANGELOG.md#v1470-2024-02-28)
  * **Feature**: AWS WAF now supports configurable time windows for request aggregation with rate-based rules. Customers can now select time windows of 1 minute, 2 minutes or 10 minutes, in addition to the previously supported 5 minutes.

# Release (2024-02-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.19.0](service/amplifyuibuilder/CHANGELOG.md#v1190-2024-02-27)
  * **Feature**: We have added the ability to tag resources after they are created

# Release (2024-02-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.23.2](service/apigateway/CHANGELOG.md#v1232-2024-02-26)
  * **Documentation**: Documentation updates for Amazon API Gateway.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.25.0](service/drs/CHANGELOG.md#v1250-2024-02-26)
  * **Feature**: Added volume status to DescribeSourceServer replicated volumes.
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.17.0](service/kafkaconnect/CHANGELOG.md#v1170-2024-02-26)
  * **Feature**: Adds support for tagging, with new TagResource, UntagResource and ListTagsForResource APIs to manage tags and updates to existing APIs to allow tag on create. This release also adds support for the new DeleteWorkerConfiguration API.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.74.0](service/rds/CHANGELOG.md#v1740-2024-02-26)
  * **Feature**: This release adds support for gp3 data volumes for Multi-AZ DB Clusters.

# Release (2024-02-23)

## General Highlights
* **Bug Fix**: Move all common, SDK-side middleware stack ops into the service client module to prevent cross-module compatibility issues in the future.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.25.2
  * **Bug Fix**: Export all middleware structures such that service client modules can use them directly.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.31.1](service/appsync/CHANGELOG.md#v1311-2024-02-23)
  * **Documentation**: Documentation only updates for AppSync
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.21.1](service/qldb/CHANGELOG.md#v1211-2024-02-23)
  * **Documentation**: Clarify possible values for KmsKeyArn and EncryptionDescription.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.73.0](service/rds/CHANGELOG.md#v1730-2024-02-23)
  * **Feature**: Add pattern and length based validations for DBShardGroupIdentifier
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.17.1](service/rum/CHANGELOG.md#v1171-2024-02-23)
  * **Documentation**: Doc-only update for new RUM metrics that were added

# Release (2024-02-22)

## General Highlights
* **Feature**: Add middleware stack snapshot tests.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.12.0](service/internetmonitor/CHANGELOG.md#v1120-2024-02-22)
  * **Feature**: This release adds IPv4 prefixes to health events
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.23.0](service/kinesisvideo/CHANGELOG.md#v1230-2024-02-22)
  * **Feature**: Increasing NextToken parameter length restriction for List APIs from 512 to 1024.

# Release (2024-02-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.22.0](service/iotevents/CHANGELOG.md#v1220-2024-02-21)
  * **Feature**: Increase the maximum length of descriptions for Inputs, Detector Models, and Alarm Models
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.25.0](service/lookoutequipment/CHANGELOG.md#v1250-2024-02-21)
  * **Feature**: This release adds a field exposing model quality to read APIs for models. It also adds a model quality field to the API response when creating an inference scheduler.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.47.0](service/medialive/CHANGELOG.md#v1470-2024-02-21)
  * **Feature**: MediaLive now supports the ability to restart pipelines in a running channel.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.48.0](service/ssm/CHANGELOG.md#v1480-2024-02-21)
  * **Feature**: This release adds support for sharing Systems Manager parameters with other AWS accounts.

# Release (2024-02-20)

## General Highlights
* **Bug Fix**: When sourcing values for a service's `EndpointParameters`, the lack of a configured region (i.e. `options.Region == ""`) will now translate to a `nil` value for `EndpointParameters.Region` instead of a pointer to the empty string `""`. This will result in a much more explicit error when calling an operation instead of an obscure hostname lookup failure.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.29.1](service/dynamodb/CHANGELOG.md#v1291-2024-02-20)
  * **Documentation**: Publishing quick fix for doc only update.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.27.0](service/firehose/CHANGELOG.md#v1270-2024-02-20)
  * **Feature**: This release updates a few Firehose related APIs.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.52.0](service/lambda/CHANGELOG.md#v1520-2024-02-20)
  * **Feature**: Add .NET 8 (dotnet8) Runtime support to AWS Lambda.

# Release (2024-02-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.20.0](service/amplify/CHANGELOG.md#v1200-2024-02-19)
  * **Feature**: This release contains API changes that enable users to configure their Amplify domains with their own custom SSL/TLS certificate.
* `github.com/aws/aws-sdk-go-v2/service/chatbot`: [v1.0.0](service/chatbot/CHANGELOG.md#v100-2024-02-19)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for AWS Chatbot. You can now monitor, operate, and troubleshoot your AWS resources with interactive ChatOps using the AWS SDK.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.45.2](service/configservice/CHANGELOG.md#v1452-2024-02-19)
  * **Documentation**: Documentation updates for the AWS Config CLI
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.32.1](service/ivs/CHANGELOG.md#v1321-2024-02-19)
  * **Documentation**: Changed description for latencyMode in Create/UpdateChannel and Channel/ChannelSummary.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.9.2](service/keyspaces/CHANGELOG.md#v192-2024-02-19)
  * **Documentation**: Documentation updates for Amazon Keyspaces
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.35.0](service/mediatailor/CHANGELOG.md#v1350-2024-02-19)
  * **Feature**: MediaTailor: marking #AdBreak.OffsetMillis as required.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.50.1](service/s3/CHANGELOG.md#v1501-2024-02-19)
  * **Bug Fix**: Prevent potential panic caused by invalid comparison of credentials.

# Release (2024-02-16)

## General Highlights
* **Feature**: Add new ClientOptions field to waiter config which allows you to extend the config for operation calls made by waiters.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.22.1](service/connectparticipant/CHANGELOG.md#v1221-2024-02-16)
  * **Documentation**: Doc only update to GetTranscript API reference guide to inform users about presence of events in the chat transcript.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.38.0](service/emr/CHANGELOG.md#v1380-2024-02-16)
  * **Feature**: adds fine grained control over Unhealthy Node Replacement to Amazon ElasticMapReduce
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.26.0](service/firehose/CHANGELOG.md#v1260-2024-02-16)
  * **Feature**: This release adds support for Data Message Extraction for decompressed CloudWatch logs, and to use a custom file extension or time zone for S3 destinations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.51.0](service/lambda/CHANGELOG.md#v1510-2024-02-16)
  * **Documentation**: Documentation-only updates for Lambda to clarify a number of existing actions and properties.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.71.0](service/rds/CHANGELOG.md#v1710-2024-02-16)
  * **Documentation**: Doc only update for a valid option in DB parameter group
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.28.0](service/sns/CHANGELOG.md#v1280-2024-02-16)
  * **Feature**: This release marks phone numbers as sensitive inputs.

# Release (2024-02-15)

## General Highlights
* **Bug Fix**: Correct failure to determine the error type in awsJson services that could occur when errors were modeled with a non-string `code` field.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/artifact`: [v1.0.0](service/artifact/CHANGELOG.md#v100-2024-02-15)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for AWS Artifact. AWS Artifact provides on-demand access to compliance and third-party compliance reports. This release includes access to List and Get reports, along with their metadata. This release also includes access to AWS Artifact notifications settings.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.25.0](service/codepipeline/CHANGELOG.md#v1250-2024-02-15)
  * **Feature**: Add ability to override timeout on action level.
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.26.1](service/detective/CHANGELOG.md#v1261-2024-02-15)
  * **Documentation**: Doc only updates for content enhancement
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.38.0](service/guardduty/CHANGELOG.md#v1380-2024-02-15)
  * **Feature**: Marked fields IpAddressV4, PrivateIpAddress, Email as Sensitive.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.22.0](service/healthlake/CHANGELOG.md#v1220-2024-02-15)
  * **Feature**: This release adds a new response parameter, JobProgressReport, to the DescribeFHIRImportJob and ListFHIRImportJobs API operation. JobProgressReport provides details on the progress of the import job on the server.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.31.0](service/opensearch/CHANGELOG.md#v1310-2024-02-15)
  * **Feature**: Adds additional supported instance types.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.38.0](service/polly/CHANGELOG.md#v1380-2024-02-15)
  * **Feature**: Amazon Polly adds 1 new voice - Burcu (tr-TR)
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.129.0](service/sagemaker/CHANGELOG.md#v11290-2024-02-15)
  * **Feature**: This release adds a new API UpdateClusterSoftware for SageMaker HyperPod. This API allows users to patch HyperPod clusters with latest platform softwares.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.27.1](service/secretsmanager/CHANGELOG.md#v1271-2024-02-15)
  * **Documentation**: Doc only update for Secrets Manager

# Release (2024-02-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.12.0](service/controltower/CHANGELOG.md#v1120-2024-02-14)
  * **Feature**: Adds support for new Baseline and EnabledBaseline APIs for automating multi-account governance.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.24.0](service/lookoutequipment/CHANGELOG.md#v1240-2024-02-14)
  * **Feature**: This feature allows customers to see pointwise model diagnostics results for their models.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.3.0](service/qbusiness/CHANGELOG.md#v130-2024-02-14)
  * **Feature**: This release adds the metadata-boosting feature, which allows customers to easily fine-tune the underlying ranking of retrieved RAG passages in order to optimize Q&A answer relevance. It also adds new feedback reasons for the PutFeedback API.

# Release (2024-02-13)

## General Highlights
* **Feature**: Bump minimum Go version to 1.20 per our language support policy.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.35.0](service/lightsail/CHANGELOG.md#v1350-2024-02-13)
  * **Feature**: This release adds support to upgrade the major version of a database.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.24.0](service/marketplacecatalog/CHANGELOG.md#v1240-2024-02-13)
  * **Feature**: AWS Marketplace Catalog API now supports setting intent on requests
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.9.0](service/resourceexplorer2/CHANGELOG.md#v190-2024-02-13)
  * **Feature**: Resource Explorer now uses newly supported IPv4 'amazonaws.com' endpoints by default.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.11.0](service/securitylake/CHANGELOG.md#v1110-2024-02-13)
  * **Documentation**: Documentation updates for Security Lake

# Release (2024-02-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.29.0](service/appsync/CHANGELOG.md#v1290-2024-02-12)
  * **Feature**: Adds support for new options on GraphqlAPIs, Resolvers and  Data Sources for emitting Amazon CloudWatch metrics for enhanced monitoring of AppSync APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.33.0](service/cloudwatch/CHANGELOG.md#v1330-2024-02-12)
  * **Feature**: This release enables PutMetricData API request payload compression by default.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.3.0](service/neptunegraph/CHANGELOG.md#v130-2024-02-12)
  * **Feature**: Adding a new option "parameters" for data plane api ExecuteQuery to support running parameterized query via SDK.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.21.0](service/route53domains/CHANGELOG.md#v1210-2024-02-12)
  * **Feature**: This release adds bill contact support for RegisterDomain, TransferDomain, UpdateDomainContact and GetDomainDetail API.

# Release (2024-02-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.22.2](service/amp/CHANGELOG.md#v1222-2024-02-09)
  * **Documentation**: Overall documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.31.0](service/batch/CHANGELOG.md#v1310-2024-02-09)
  * **Feature**: This feature allows Batch to support configuration of repository credentials for jobs running on ECS
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.25.0](service/braket/CHANGELOG.md#v1250-2024-02-09)
  * **Feature**: Creating a job will result in DeviceOfflineException when using an offline device, and DeviceRetiredException when using a retired device.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.2.0](service/costoptimizationhub/CHANGELOG.md#v120-2024-02-09)
  * **Feature**: Adding includeMemberAccounts field to the response of ListEnrollmentStatuses API.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.3](service/ecs/CHANGELOG.md#v1383-2024-02-09)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.50.0](service/iot/CHANGELOG.md#v1500-2024-02-09)
  * **Feature**: This release allows AWS IoT Core users to enable Online Certificate Status Protocol (OCSP) Stapling for TLS X.509 Server Certificates when creating and updating AWS IoT Domain Configurations with Custom Domain.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.25.0](service/pricing/CHANGELOG.md#v1250-2024-02-09)
  * **Feature**: Add Throttling Exception to all APIs.

# Release (2024-02-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.23.0](service/codepipeline/CHANGELOG.md#v1230-2024-02-08)
  * **Feature**: Add ability to execute pipelines with new parallel & queued execution modes and add support for triggers with filtering on branches and file paths.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.56.0](service/quicksight/CHANGELOG.md#v1560-2024-02-08)
  * **Feature**: General Interactions for Visuals; Waterfall Chart Color Configuration; Documentation Update
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.36.0](service/workspaces/CHANGELOG.md#v1360-2024-02-08)
  * **Feature**: This release introduces User-Decoupling feature. This feature allows Workspaces Core customers to provision workspaces without providing users. CreateWorkspaces and DescribeWorkspaces APIs will now take a new optional parameter "WorkspaceName".

# Release (2024-02-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.34.0](service/datasync/CHANGELOG.md#v1340-2024-02-07)
  * **Feature**: AWS DataSync now supports manifests for specifying files or objects to transfer.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.39.0](service/lexmodelsv2/CHANGELOG.md#v1390-2024-02-07)
  * **Feature**: This release introduces a new bot replication feature as part of Lex Global Resiliency offering. This feature leverages a new set of APIs that allow customers to create bot replicas and replicate changes to bots across regions.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.40.0](service/redshift/CHANGELOG.md#v1400-2024-02-07)
  * **Feature**: LisRecommendations API to fetch Amazon Redshift Advisor recommendations.

# Release (2024-02-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.28.0](service/appsync/CHANGELOG.md#v1280-2024-02-06)
  * **Feature**: Support for environment variables in AppSync GraphQL APIs
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.32.0](service/cloudwatchlogs/CHANGELOG.md#v1320-2024-02-06)
  * **Feature**: This release adds a new field, logGroupArn, to the response of the logs:DescribeLogGroups action.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.2](service/ecs/CHANGELOG.md#v1382-2024-02-06)
  * **Documentation**: This release is a documentation only update to address customer issues.
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.26.0](service/elasticsearchservice/CHANGELOG.md#v1260-2024-02-06)
  * **Feature**: This release adds clear visibility to the customers on the changes that they make on the domain.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.29.0](service/opensearch/CHANGELOG.md#v1290-2024-02-06)
  * **Feature**: This release adds clear visibility to the customers on the changes that they make on the domain.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.44.0](service/wafv2/CHANGELOG.md#v1440-2024-02-06)
  * **Feature**: You can now delete an API key that you've created for use with your CAPTCHA JavaScript integration API.

# Release (2024-02-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.75.0](service/glue/CHANGELOG.md#v1750-2024-02-05)
  * **Feature**: Introduce Catalog Encryption Role within Glue Data Catalog Settings. Introduce SASL/PLAIN as an authentication method for Glue Kafka connections
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.35.9](service/workspaces/CHANGELOG.md#v1359-2024-02-05)
  * **Documentation**: Added definitions of various WorkSpace states

# Release (2024-02-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.27.1](service/dynamodb/CHANGELOG.md#v1271-2024-02-02)
  * **Documentation**: Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.127.0](service/sagemaker/CHANGELOG.md#v11270-2024-02-02)
  * **Feature**: Amazon SageMaker Canvas adds GenerativeAiSettings support for CanvasAppSettings.

# Release (2024-02-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.33.0](service/cognitoidentityprovider/CHANGELOG.md#v1330-2024-02-01)
  * **Feature**: Added CreateIdentityProvider and UpdateIdentityProvider details for new SAML IdP features
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.31.0](service/ivs/CHANGELOG.md#v1310-2024-02-01)
  * **Feature**: This release introduces a new resource Playback Restriction Policy which can be used to geo-restrict or domain-restrict channel stream playback when associated with a channel.  New APIs to support this resource were introduced in the form of Create/Delete/Get/Update/List.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.8.0](service/managedblockchainquery/CHANGELOG.md#v180-2024-02-01)
  * **Feature**: This release adds support for transactions that have not reached finality. It also removes support for the status property from the response of the GetTransaction operation. You can use the confirmationStatus and executionStatus properties to determine the status of the transaction.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.50.0](service/mediaconvert/CHANGELOG.md#v1500-2024-02-01)
  * **Feature**: This release includes support for broadcast-mixed audio description tracks.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.2.0](service/neptunegraph/CHANGELOG.md#v120-2024-02-01)
  * **Feature**: Adding new APIs in SDK for Amazon Neptune Analytics. These APIs include operations to execute, cancel, list queries and get the graph summary.

# Release (2024-01-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.43.0](service/cloudformation/CHANGELOG.md#v1430-2024-01-31)
  * **Feature**: CloudFormation IaC generator allows you to scan existing resources in your account and select resources to generate a template for a new or existing CloudFormation stack.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.27.0](service/elasticloadbalancingv2/CHANGELOG.md#v1270-2024-01-31)
  * **Feature**: This release enables unhealthy target draining intervals for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.74.0](service/glue/CHANGELOG.md#v1740-2024-01-31)
  * **Feature**: Update page size limits for GetJobRuns and GetTriggers APIs.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.45.0](service/ssm/CHANGELOG.md#v1450-2024-01-31)
  * **Feature**: This release adds an optional Duration parameter to StateManager Associations. This allows customers to specify how long an apply-only-on-cron association execution should run. Once the specified Duration is out all the ongoing cancellable commands or automations are cancelled.

# Release (2024-01-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.4.0](service/datazone/CHANGELOG.md#v140-2024-01-30)
  * **Feature**: Add new skipDeletionCheck to DeleteDomain. Add new skipDeletionCheck to DeleteProject which also automatically deletes dependent objects
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.37.1](service/route53/CHANGELOG.md#v1371-2024-01-30)
  * **Documentation**: Update the SDKs for text changes in the APIs.

# Release (2024-01-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.37.0](service/autoscaling/CHANGELOG.md#v1370-2024-01-29)
  * **Feature**: EC2 Auto Scaling customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.29.7](service/comprehend/CHANGELOG.md#v1297-2024-01-29)
  * **Documentation**: Comprehend PII analysis now supports Spanish input documents.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.146.0](service/ec2/CHANGELOG.md#v11460-2024-01-29)
  * **Feature**: EC2 Fleet customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.24.0](service/mwaa/CHANGELOG.md#v1240-2024-01-29)
  * **Feature**: This release adds MAINTENANCE environment status for Amazon MWAA environments.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.69.0](service/rds/CHANGELOG.md#v1690-2024-01-29)
  * **Feature**: Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS RestoreDBClusterFromSnapshot and RestoreDBClusterToPointInTime API methods. This provides enhanced error handling, ensuring a more robust experience.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.24.7](service/snowball/CHANGELOG.md#v1247-2024-01-29)
  * **Documentation**: Modified description of createaddress to include direction to add path when providing a JSON file.

# Release (2024-01-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.22.0](service/inspector2/CHANGELOG.md#v1220-2024-01-26)
  * **Feature**: This release adds ECR container image scanning based on their lastRecordedPullTime.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.126.0](service/sagemaker/CHANGELOG.md#v11260-2024-01-26)
  * **Feature**: Amazon SageMaker Automatic Model Tuning now provides an API to programmatically delete tuning jobs.

# Release (2024-01-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.26.0](service/acmpca/CHANGELOG.md#v1260-2024-01-25)
  * **Feature**: AWS Private CA now supports an option to omit the CDP extension from issued certificates, when CRL revocation is enabled.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.34.0](service/lightsail/CHANGELOG.md#v1340-2024-01-25)
  * **Feature**: This release adds support for IPv6-only instance plans.

# Release (2024-01-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.145.0](service/ec2/CHANGELOG.md#v11450-2024-01-24)
  * **Feature**: Introduced a new clientToken request parameter on CreateNetworkAcl and CreateRouteTable APIs. The clientToken parameter allows idempotent operations on the APIs.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.1](service/ecs/CHANGELOG.md#v1381-2024-01-24)
  * **Documentation**: Documentation updates for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.35.0](service/outposts/CHANGELOG.md#v1350-2024-01-24)
  * **Feature**: DeviceSerialNumber parameter is now optional in StartConnection API
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.68.0](service/rds/CHANGELOG.md#v1680-2024-01-24)
  * **Feature**: This release adds support for Aurora Limitless Database.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.25.0](service/storagegateway/CHANGELOG.md#v1250-2024-01-24)
  * **Feature**: Add DeprecationDate and SoftwareVersion to response of ListGateways.

# Release (2024-01-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.21.0](service/inspector2/CHANGELOG.md#v1210-2024-01-23)
  * **Feature**: This release adds support for CIS scans on EC2 instances.

# Release (2024-01-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.26.6](config/CHANGELOG.md#v1266-2024-01-22)
  * **Bug Fix**: Remove invalid escaping of shared config values. All values in the shared config file will now be interpreted literally, save for fully-quoted strings which are unwrapped for legacy reasons.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.3](internal/ini/CHANGELOG.md#v173-2024-01-22)
  * **Bug Fix**: Remove invalid escaping of shared config values. All values in the shared config file will now be interpreted literally, save for fully-quoted strings which are unwrapped for legacy reasons.
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.12.0](service/appconfigdata/CHANGELOG.md#v1120-2024-01-22)
  * **Feature**: Fix FIPS Endpoints in aws-us-gov.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.22.7](service/cloud9/CHANGELOG.md#v1227-2024-01-22)
  * **Documentation**: Doc-only update around removing AL1 from list of available AMIs for Cloud9
* `github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore`: [v1.2.0](service/cloudfrontkeyvaluestore/CHANGELOG.md#v120-2024-01-22)
  * **Feature**: This release improves upon the DescribeKeyValueStore API by returning two additional fields, Status of the KeyValueStore and the FailureReason in case of failures during creation of KeyValueStore.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.13.0](service/connectcases/CHANGELOG.md#v1130-2024-01-22)
  * **Feature**: This release adds the ability to view audit history on a case and introduces a new parameter, performedBy, for CreateCase and UpdateCase API's.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.144.1](service/ec2/CHANGELOG.md#v11441-2024-01-22)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.38.0](service/ecs/CHANGELOG.md#v1380-2024-01-22)
  * **Feature**: This release adds support for Transport Layer Security (TLS) and Configurable Timeout to ECS Service Connect. TLS facilitates privacy and data security for inter-service communications, while Configurable Timeout allows customized per-request timeout and idle timeout for Service Connect services.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.23.7](service/organizations/CHANGELOG.md#v1237-2024-01-22)
  * **Documentation**: Doc only update for quota increase change
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.67.0](service/rds/CHANGELOG.md#v1670-2024-01-22)
  * **Feature**: Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS CreateDBCluster API method. This provides enhanced error handling, ensuring a more robust experience when creating database clusters with insufficient instance capacity.

# Release (2024-01-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.38.0](service/athena/CHANGELOG.md#v1380-2024-01-19)
  * **Feature**: Introducing new NotebookS3LocationUri parameter to Athena ImportNotebook API. Payload is no longer required and either Payload or NotebookS3LocationUri needs to be provided (not both) for a successful ImportNotebook API call. If both are provided, an InvalidRequestException will be thrown.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.28.0](service/codebuild/CHANGELOG.md#v1280-2024-01-19)
  * **Feature**: Release CodeBuild Reserved Capacity feature
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.27.0](service/dynamodb/CHANGELOG.md#v1270-2024-01-19)
  * **Feature**: This release adds support for including ApproximateCreationDateTimePrecision configurations in EnableKinesisStreamingDestination API, adds the same as an optional field in the response of DescribeKinesisStreamingDestination, and adds support for a new UpdateKinesisStreamingDestination API.

# Release (2024-01-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.11](service/b2bi/CHANGELOG.md#v100-preview11-2024-01-18)
  * **Feature**: Increasing TestMapping inputFileContent file size limit to 5MB and adding file size limit 250KB for TestParsing input file. This release also includes exposing InternalServerException for Tag APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.36.0](service/cloudtrail/CHANGELOG.md#v1360-2024-01-18)
  * **Feature**: This release adds a new API ListInsightsMetricData to retrieve metric data from CloudTrail Insights.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.90.0](service/connect/CHANGELOG.md#v1900-2024-01-18)
  * **Feature**: GetMetricDataV2 now supports 3 groupings
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.22.0](service/drs/CHANGELOG.md#v1220-2024-01-18)
  * **Feature**: Removed invalid and unnecessary default values.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.15.0](service/emrserverless/CHANGELOG.md#v1150-2024-01-18)
  * **Feature**: **BREAKFIX**: Correct nullability of InitialCapacityConfig's WorkerCount field. The type of this value has changed from int64 to *int64. Due to this field being marked required, with an enforced minimum of 1, but a default of 0, the former type would result in automatic failure behavior without caller intervention. Calling code will need to be updated accordingly.
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.17.0](service/evidently/CHANGELOG.md#v1170-2024-01-18)
  * **Feature**: **BREAKFIX**: Correct nullability of GetExperimentResultsInput's Period field. The type of this value has changed from int64 to *int64. Due to the nature of default value serialization, the former type could cause unexpected/incorrect behavior when set to its zero value. Calling code will need to be updated accordingly.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.24.0](service/firehose/CHANGELOG.md#v1240-2024-01-18)
  * **Feature**: Allow support for Snowflake as a Kinesis Data Firehose delivery destination.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.23.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1230-2024-01-18)
  * **Feature**: Increase BatchGetRecord limits from 10 items to 100 items

# Release (2024-01-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.26.9](service/dynamodb/CHANGELOG.md#v1269-2024-01-17)
  * **Documentation**: Updating note for enabling streams for UpdateTable.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.8.0](service/keyspaces/CHANGELOG.md#v180-2024-01-17)
  * **Feature**: This release adds support for Multi-Region Replication with provisioned tables, and Keyspaces auto scaling APIs

# Release (2024-01-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.49.0](service/iot/CHANGELOG.md#v1490-2024-01-16)
  * **Feature**: Revert release of LogTargetTypes
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.12.0](service/iotfleetwise/CHANGELOG.md#v1120-2024-01-16)
  * **Feature**: Updated APIs: SignalNodeType query parameter has been added to ListSignalCatalogNodesRequest and ListVehiclesResponse has been extended with attributes field.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.35.0](service/macie2/CHANGELOG.md#v1350-2024-01-16)
  * **Feature**: This release adds support for analyzing Amazon S3 objects that are encrypted using dual-layer server-side encryption with AWS KMS keys (DSSE-KMS). It also adds support for reporting DSSE-KMS details in statistics and metadata about encryption settings for S3 buckets and objects.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.7.0](service/paymentcryptography/CHANGELOG.md#v170-2024-01-16)
  * **Feature**: Provide an additional option for key exchange using RSA wrap/unwrap in addition to tr-34/tr-31 in ImportKey and ExportKey operations. Added new key usage (type) TR31_M1_ISO_9797_1_MAC_KEY, for use with Generate/VerifyMac dataplane operations  with ISO9797 Algorithm 1 MAC calculations.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.30.7](service/personalize/CHANGELOG.md#v1307-2024-01-16)
  * **Documentation**: Documentation updates for Amazon Personalize.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.20.7](service/personalizeruntime/CHANGELOG.md#v1207-2024-01-16)
  * **Documentation**: Documentation updates for Amazon Personalize
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.36.0](service/rekognition/CHANGELOG.md#v1360-2024-01-16)
  * **Feature**: This release adds ContentType and TaxonomyLevel attributes to DetectModerationLabels and GetMediaAnalysisJob API responses.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.44.3](service/securityhub/CHANGELOG.md#v1443-2024-01-16)
  * **Documentation**: Documentation updates for AWS Security Hub

# Release (2024-01-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.125.0](service/sagemaker/CHANGELOG.md#v11250-2024-01-14)
  * **Feature**: This release will have ValidationException thrown if certain invalid app types are provided. The release will also throw ValidationException if more than 10 account ids are provided in VpcOnlyTrustedAccounts.

# Release (2024-01-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.89.0](service/connect/CHANGELOG.md#v1890-2024-01-12)
  * **Feature**: Supervisor Barge for Chat is now supported through the MonitorContact API.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.21.0](service/connectparticipant/CHANGELOG.md#v1210-2024-01-12)
  * **Feature**: Introduce new Supervisor participant role
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.35.1](service/location/CHANGELOG.md#v1351-2024-01-12)
  * **Documentation**: Location SDK documentation update. Added missing fonts to the MapConfiguration data type. Updated note for the SubMunicipality property in the place data type.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.23.0](service/mwaa/CHANGELOG.md#v1230-2024-01-12)
  * **Feature**: This Amazon MWAA feature release includes new fields in CreateWebLoginToken response model. The new fields IamIdentity and AirflowIdentity will let you match identifications, as the Airflow identity length is currently hashed to 64 characters.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.42.0](service/s3control/CHANGELOG.md#v1420-2024-01-12)
  * **Feature**: S3 On Outposts team adds dualstack endpoints support for S3Control and S3Outposts API calls.
* `github.com/aws/aws-sdk-go-v2/service/supplychain`: [v1.0.0](service/supplychain/CHANGELOG.md#v100-2024-01-12)
  * **Release**: New AWS service client module
  * **Feature**: This release includes APIs CreateBillOfMaterialsImportJob and GetBillOfMaterialsImportJob.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.40.0](service/transfer/CHANGELOG.md#v1400-2024-01-12)
  * **Feature**: AWS Transfer Family now supports static IP addresses for SFTP & AS2 connectors and for async MDNs on AS2 servers.

# Release (2024-01-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.144.0](service/ec2/CHANGELOG.md#v11440-2024-01-11)
  * **Feature**: This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.37.0](service/ecs/CHANGELOG.md#v1370-2024-01-11)
  * **Feature**: This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.28.0](service/eventbridge/CHANGELOG.md#v1280-2024-01-11)
  * **Feature**: Adding AppSync as an EventBridge Target
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.48.0](service/iot/CHANGELOG.md#v1480-2024-01-11)
  * **Feature**: Add ConflictException to Update APIs of AWS IoT Software Package Catalog
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.11.0](service/iotfleetwise/CHANGELOG.md#v1110-2024-01-11)
  * **Feature**: The following dataTypes have been removed: CUSTOMER_DECODED_INTERFACE in NetworkInterfaceType; CUSTOMER_DECODED_SIGNAL_INFO_IS_NULL in SignalDecoderFailureReason; CUSTOMER_DECODED_SIGNAL_NETWORK_INTERFACE_INFO_IS_NULL in NetworkInterfaceFailureReason; CUSTOMER_DECODED_SIGNAL in SignalDecoderType
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.26.2](service/secretsmanager/CHANGELOG.md#v1262-2024-01-11)
  * **Documentation**: Doc only update for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.35.8](service/workspaces/CHANGELOG.md#v1358-2024-01-11)
  * **Documentation**: Added AWS Workspaces RebootWorkspaces API - Extended Reboot documentation update

# Release (2024-01-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.31.0](service/cloudwatchlogs/CHANGELOG.md#v1310-2024-01-10)
  * **Feature**: Add support for account level subscription filter policies to PutAccountPolicy, DescribeAccountPolicies, and DeleteAccountPolicy APIs. Additionally, PutAccountPolicy has been modified with new optional "selectionCriteria" parameter for resource selection.
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.8.0](service/connectcampaigns/CHANGELOG.md#v180-2024-01-10)
  * **Feature**: Minor pattern updates for Campaign and Dial Request API fields.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.35.0](service/location/CHANGELOG.md#v1350-2024-01-10)
  * **Feature**: This release adds API support for custom layers for the maps service APIs: CreateMap, UpdateMap, DescribeMap.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.3.0](service/qconnect/CHANGELOG.md#v130-2024-01-10)
  * **Feature**: QueryAssistant and GetRecommendations will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.15.7](service/redshiftserverless/CHANGELOG.md#v1157-2024-01-10)
  * **Documentation**: Updates to ConfigParameter for RSS workgroup, removal of use_fips_ssl
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.37.0](service/route53/CHANGELOG.md#v1370-2024-01-10)
  * **Feature**: Route53 now supports geoproximity routing in AWS regions
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.21.0](service/wisdom/CHANGELOG.md#v1210-2024-01-10)
  * **Feature**: QueryAssistant and GetRecommendations will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.

# Release (2024-01-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.27.0](service/codebuild/CHANGELOG.md#v1270-2024-01-08)
  * **Feature**: Aws CodeBuild now supports new compute type BUILD_GENERAL1_XLARGE
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.143.0](service/ec2/CHANGELOG.md#v11430-2024-01-08)
  * **Feature**: Amazon EC2 R7iz bare metal instances are powered by custom 4th generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.25.0](service/route53resolver/CHANGELOG.md#v1250-2024-01-08)
  * **Feature**: This release adds support for query type configuration on firewall rules that enables customers for granular action (ALLOW, ALERT, BLOCK) by DNS query type.

# Release (2024-01-05)

## General Highlights
* **Feature**: Support smithy sigv4a trait for codegen.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.27.9](service/kms/CHANGELOG.md#v1279-2024-01-05)
  * **Documentation**: Documentation updates for AWS Key Management Service (KMS).
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.15.6](service/redshiftserverless/CHANGELOG.md#v1156-2024-01-05)
  * **Documentation**: use_fips_ssl and require_ssl parameter support for Workgroup, UpdateWorkgroup, and CreateWorkgroup

# Release (2024-01-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.24.1
  * **Documentation**: removing incorrect doc string from config
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.44.0](service/configservice/CHANGELOG.md#v1440-2024-01-04)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in November and December 2023.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.30.0](service/docdb/CHANGELOG.md#v1300-2024-01-04)
  * **Feature**: Adding PerformanceInsightsEnabled and PerformanceInsightsKMSKeyId fields to DescribeDBInstances Response.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.36.0](service/ecs/CHANGELOG.md#v1360-2024-01-04)
  * **Feature**: This release adds support for managed instance draining which facilitates graceful termination of Amazon ECS instances.
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.25.0](service/elasticsearchservice/CHANGELOG.md#v1250-2024-01-04)
  * **Feature**: This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.33.0](service/lightsail/CHANGELOG.md#v1330-2024-01-04)
  * **Feature**: This release adds support to set up an HTTPS endpoint on an instance.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.28.0](service/opensearch/CHANGELOG.md#v1280-2024-01-04)
  * **Feature**: This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.124.0](service/sagemaker/CHANGELOG.md#v11240-2024-01-04)
  * **Feature**: Adding support for provisioned throughput mode for SageMaker Feature Groups
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.26.0](service/servicecatalog/CHANGELOG.md#v1260-2024-01-04)
  * **Feature**: Added Idempotency token support to Service Catalog  AssociateServiceActionWithProvisioningArtifact, DisassociateServiceActionFromProvisioningArtifact, DeleteServiceAction API

# Release (2024-01-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.88.0](service/connect/CHANGELOG.md#v1880-2024-01-03)
  * **Feature**: Amazon Connect, Contact Lens Evaluation API increase evaluation notes max length to 3072.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.49.0](service/mediaconvert/CHANGELOG.md#v1490-2024-01-03)
  * **Feature**: This release includes video engine updates including HEVC improvements, support for ingesting VP9 encoded video in MP4 containers, and support for user-specified 3D LUTs.

# Release (2023-12-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.26.0](service/apprunner/CHANGELOG.md#v1260-2023-12-29)
  * **Feature**: AWS App Runner adds Python 3.11 and Node.js 18 runtimes.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.34.0](service/location/CHANGELOG.md#v1340-2023-12-29)
  * **Feature**: This release introduces a new parameter to bypasses an API key's expiry conditions and delete the key.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.55.0](service/quicksight/CHANGELOG.md#v1550-2023-12-29)
  * **Feature**: Add LinkEntityArn support for different partitions; Add UnsupportedUserEditionException in UpdateDashboardLinks API; Add support for New Reader Experience Topics

# Release (2023-12-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.22.0](service/codestarconnections/CHANGELOG.md#v1220-2023-12-28)
  * **Feature**: New integration with the GitLab self-managed provider type.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.21.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1210-2023-12-28)
  * **Feature**: NoDataRetentionException thrown when GetImages requested for a Stream that does not retain data (that is, has a DataRetentionInHours of 0).
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.123.0](service/sagemaker/CHANGELOG.md#v11230-2023-12-28)
  * **Feature**: Amazon SageMaker Studio now supports Docker access from within app container

# Release (2023-12-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.36.0](service/emr/CHANGELOG.md#v1360-2023-12-27)
  * **Feature**: Add support for customers to modify cluster attribute auto-terminate post cluster launch

# Release (2023-12-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.28.6](service/iam/CHANGELOG.md#v1286-2023-12-26)
  * **Documentation**: Documentation updates for AWS Identity and Access Management (IAM).

# Release (2023-12-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.73.0](service/glue/CHANGELOG.md#v1730-2023-12-22)
  * **Feature**: This release adds additional configurations for Query Session Context on the following APIs: GetUnfilteredTableMetadata, GetUnfilteredPartitionMetadata, GetUnfilteredPartitionsMetadata.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.29.0](service/lakeformation/CHANGELOG.md#v1290-2023-12-22)
  * **Feature**: This release adds additional configurations on GetTemporaryGlueTableCredentials for Query Session Context.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.25.0](service/mediaconnect/CHANGELOG.md#v1250-2023-12-22)
  * **Feature**: This release adds the DescribeSourceMetadata API. This API can be used to view the stream information of the flow's source.
* `github.com/aws/aws-sdk-go-v2/service/networkmonitor`: [v1.0.0](service/networkmonitor/CHANGELOG.md#v100-2023-12-22)
  * **Release**: New AWS service client module
  * **Feature**: CloudWatch Network Monitor is a new service within CloudWatch that will help network administrators and operators continuously monitor network performance metrics such as round-trip-time and packet loss between their AWS-hosted applications and their on-premises locations.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.16.6](service/omics/CHANGELOG.md#v1166-2023-12-22)
  * **Documentation**: Provides minor corrections and an updated description of APIs.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.26.0](service/secretsmanager/CHANGELOG.md#v1260-2023-12-22)
  * **Feature**: Update endpoint rules and examples.

# Release (2023-12-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.22.0](service/amp/CHANGELOG.md#v1220-2023-12-21)
  * **Feature**: This release updates Amazon Managed Service for Prometheus APIs to support customer managed KMS keys.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.23.0](service/appintegrations/CHANGELOG.md#v1230-2023-12-21)
  * **Feature**: The Amazon AppIntegrations service adds DeleteApplication API for deleting applications, and updates APIs to support third party applications reacting to workspace events and make data requests to Amazon Connect for agent and contact events.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.2.0](service/bedrockagent/CHANGELOG.md#v120-2023-12-21)
  * **Feature**: This release introduces Amazon Aurora as a vector store on Knowledge Bases for Amazon Bedrock
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.20.0](service/codecommit/CHANGELOG.md#v1200-2023-12-21)
  * **Feature**: AWS CodeCommit now supports customer managed keys from AWS Key Management Service. UpdateRepositoryEncryptionKey is added for updating the key configuration. CreateRepository, GetRepository, BatchGetRepositories are updated with new input or output parameters.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.87.0](service/connect/CHANGELOG.md#v1870-2023-12-21)
  * **Feature**: Adds APIs to manage User Proficiencies and Predefined Attributes. Enhances StartOutboundVoiceContact API input. Introduces SearchContacts API. Enhances DescribeContact API. Adds an API to update Routing Attributes in QueuePriority and QueueTimeAdjustmentSeconds.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.44.0](service/medialive/CHANGELOG.md#v1440-2023-12-21)
  * **Feature**: MediaLive now supports the ability to configure the audio that an AWS Elemental Link UHD device produces, when the device is configured as the source for a flow in AWS Elemental MediaConnect.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.1.0](service/neptunegraph/CHANGELOG.md#v110-2023-12-21)
  * **Feature**: Adds Waiters for successful creation and deletion of Graph, Graph Snapshot, Import Task and Private Endpoints for Neptune Analytics
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.66.0](service/rds/CHANGELOG.md#v1660-2023-12-21)
  * **Feature**: This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.19.0](service/rdsdata/CHANGELOG.md#v1190-2023-12-21)
  * **Feature**: This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.122.0](service/sagemaker/CHANGELOG.md#v11220-2023-12-21)
  * **Feature**: Amazon SageMaker Training now provides model training container access for debugging purposes. Amazon SageMaker Search now provides the ability to use visibility conditions to limit resource access to a single domain or multiple domains.

# Release (2023-12-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.31.0](service/appstream/CHANGELOG.md#v1310-2023-12-20)
  * **Feature**: This release introduces configurable clipboard, allowing admins to specify the maximum length of text that can be copied by the users from their device to the remote session and vice-versa.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.37.0](service/eks/CHANGELOG.md#v1370-2023-12-20)
  * **Feature**: Add support for cluster insights, new EKS capability that surfaces potentially upgrade impacting issues.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.36.0](service/guardduty/CHANGELOG.md#v1360-2023-12-20)
  * **Feature**: This release 1) introduces a new API: GetOrganizationStatistics , and 2) adds a new UsageStatisticType TOP_ACCOUNTS_BY_FEATURE for GetUsageStatistics API
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.7.0](service/managedblockchainquery/CHANGELOG.md#v170-2023-12-20)
  * **Feature**: Adding Confirmation Status and Execution Status to GetTransaction Response.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.33.0](service/mediatailor/CHANGELOG.md#v1330-2023-12-20)
  * **Feature**: Adds the ability to configure time shifting on MediaTailor channels using the TimeShiftConfiguration field
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.36.0](service/route53/CHANGELOG.md#v1360-2023-12-20)
  * **Feature**: Amazon Route 53 now supports the Canada West (Calgary) Region (ca-west-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

# Release (2023-12-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.27.0](service/appsync/CHANGELOG.md#v1270-2023-12-19)
  * **Feature**: This release adds additional configurations on GraphQL APIs for limits on query depth, resolver count, and introspection
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.21.0](service/chimesdkmeetings/CHANGELOG.md#v1210-2023-12-19)
  * **Feature**: Add meeting features to specify a maximum camera resolution, a maximum content sharing resolution, and a maximum number of attendees for a given meeting.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.142.0](service/ec2/CHANGELOG.md#v11420-2023-12-19)
  * **Feature**: Provision BYOIPv4 address ranges and advertise them by specifying the network border groups option in Los Angeles, Phoenix and Dallas AWS Local Zones.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.40.0](service/fsx/CHANGELOG.md#v1400-2023-12-19)
  * **Feature**: Added support for FSx for OpenZFS on-demand data replication across AWS accounts and/or regions.Added the IncludeShared attribute for DescribeSnapshots.Added the CopyStrategy attribute for OpenZFSVolumeConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.23.0](service/marketplacecatalog/CHANGELOG.md#v1230-2023-12-19)
  * **Feature**: AWS Marketplace now supports a new API, BatchDescribeEntities, which returns metadata and content for multiple entities.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.65.0](service/rds/CHANGELOG.md#v1650-2023-12-19)
  * **Feature**: RDS - The release adds two new APIs: DescribeDBRecommendations and ModifyDBRecommendation

# Release (2023-12-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.32.0](service/cognitoidentityprovider/CHANGELOG.md#v1320-2023-12-18)
  * **Feature**: Amazon Cognito now supports trigger versions that define the fields in the request sent to pre token generation Lambda triggers.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.36.0](service/eks/CHANGELOG.md#v1360-2023-12-18)
  * **Feature**: Add support for EKS Cluster Access Management.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.54.1](service/quicksight/CHANGELOG.md#v1541-2023-12-18)
  * **Documentation**: A docs-only release to add missing entities to the API reference.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.24.0](service/route53resolver/CHANGELOG.md#v1240-2023-12-18)
  * **Feature**: Add DOH protocols in resolver endpoints.

# Release (2023-12-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.22.5](service/cloud9/CHANGELOG.md#v1225-2023-12-15)
  * **Documentation**: Updated Cloud9 API documentation for AL2023 release
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.86.0](service/connect/CHANGELOG.md#v1860-2023-12-15)
  * **Feature**: Adds relatedContactId field to StartOutboundVoiceContact API input. Introduces PauseContact API and ResumeContact API for Task contacts. Adds pause duration, number of pauses, timestamps for last paused and resumed events to DescribeContact API response. Adds new Rule type and new Rule action.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.27.6](service/kms/CHANGELOG.md#v1276-2023-12-15)
  * **Documentation**: Documentation updates for AWS Key Management Service
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.64.6](service/rds/CHANGELOG.md#v1646-2023-12-15)
  * **Documentation**: Updates Amazon RDS documentation by adding code examples
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.121.0](service/sagemaker/CHANGELOG.md#v11210-2023-12-15)
  * **Feature**: This release 1) introduces a new API: DeleteCompilationJob , and 2) adds InfraCheckConfig for Create/Describe training job API

# Release (2023-12-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.30.0](service/appstream/CHANGELOG.md#v1300-2023-12-14)
  * **Feature**: This release includes support for images of Windows Server 2022 platform.
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview.9](service/b2bi/CHANGELOG.md#v100-preview9-2023-12-14)
  * **Documentation**: Documentation updates for AWS B2B Data Interchange
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.14.0](service/billingconductor/CHANGELOG.md#v1140-2023-12-14)
  * **Feature**: Billing Conductor is releasing a new API, GetBillingGroupCostReport, which provides the ability to retrieve/view the Billing Group Cost Report broken down by attributes for a specific billing group.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.85.0](service/connect/CHANGELOG.md#v1850-2023-12-14)
  * **Feature**: This release adds support for more granular billing using tags (key:value pairs)
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.10.6](service/controltower/CHANGELOG.md#v1106-2023-12-14)
  * **Documentation**: Documentation updates for AWS Control Tower.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.23.0](service/firehose/CHANGELOG.md#v1230-2023-12-14)
  * **Feature**: This release, 1) adds configurable buffering hints for the Splunk destination, and 2) reduces the minimum configurable buffering interval for supported destinations
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.28.0](service/gamelift/CHANGELOG.md#v1280-2023-12-14)
  * **Feature**: Amazon GameLift adds the ability to add and update the game properties of active game sessions.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.47.0](service/iot/CHANGELOG.md#v1470-2023-12-14)
  * **Feature**: This release adds the ability to self-manage certificate signing in AWS IoT Core fleet provisioning using the new certificate provider resource.
* `github.com/aws/aws-sdk-go-v2/service/neptunegraph`: [v1.0.0](service/neptunegraph/CHANGELOG.md#v100-2023-12-14)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for Amazon Neptune Analytics
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.27.0](service/opensearch/CHANGELOG.md#v1270-2023-12-14)
  * **Feature**: Updating documentation for Amazon OpenSearch Service support for new zero-ETL integration with Amazon S3.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.54.0](service/quicksight/CHANGELOG.md#v1540-2023-12-14)
  * **Feature**: Update Dashboard Links support; SingleAxisOptions support; Scatterplot Query limit support.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.35.6](service/workspaces/CHANGELOG.md#v1356-2023-12-14)
  * **Documentation**: Updated note to ensure customers understand running modes.

# Release (2023-12-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.21.0](service/drs/CHANGELOG.md#v1210-2023-12-13)
  * **Feature**: Adding AgentVersion to SourceServer and RecoveryInstance structures

# Release (2023-12-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.30.0](service/cloudwatchlogs/CHANGELOG.md#v1300-2023-12-12)
  * **Feature**: This release introduces the StartLiveTail API to tail ingested logs in near real time.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.30.0](service/imagebuilder/CHANGELOG.md#v1300-2023-12-12)
  * **Feature**: This release adds the Image Workflows feature to give more flexibility and control over the image building and testing process.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.33.0](service/location/CHANGELOG.md#v1330-2023-12-12)
  * **Feature**: This release 1)  adds sub-municipality field in Places API for searching and getting places information, and 2) allows optimizing route calculation based on expected arrival time.

# Release (2023-12-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.28.0](service/neptune/CHANGELOG.md#v1280-2023-12-11)
  * **Feature**: This release adds a new parameter configuration setting to the Neptune cluster related APIs that can be leveraged to switch between the underlying supported storage modes.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.26.6](service/pinpoint/CHANGELOG.md#v1266-2023-12-11)
  * **Documentation**: This release includes Amazon Pinpoint API documentation updates pertaining to campaign message sending rate limits.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.44.0](service/securityhub/CHANGELOG.md#v1440-2023-12-11)
  * **Feature**: Added new resource detail objects to ASFF, including resources for AwsDynamoDbTable, AwsEc2ClientVpnEndpoint, AwsMskCluster, AwsS3AccessPoint, AwsS3Bucket

# Release (2023-12-08)

## General Highlights
* **Bug Fix**: Reinstate presence of default Retryer in functional options, but still respect max attempts set therein.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.26.1](config/CHANGELOG.md#v1261-2023-12-08)
  * **Bug Fix**: Correct loading of [services *] sections into shared config.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.2](internal/ini/CHANGELOG.md#v172-2023-12-08)
  * **Bug Fix**: Correct loading of [services *] sections into shared config.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.32.0](service/cloudwatch/CHANGELOG.md#v1320-2023-12-08)
  * **Feature**: Adds support for the OpenTelemetry 1.0 output format in CloudWatch Metric Streams.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.141.0](service/ec2/CHANGELOG.md#v11410-2023-12-08)
  * **Feature**: M2 Mac instances are built on Apple M2 Mac mini computers. I4i instances are powered by 3rd generation Intel Xeon Scalable processors. C7i compute optimized, M7i general purpose and R7i memory optimized instances are powered by custom 4th Generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.20.0](service/finspace/CHANGELOG.md#v1200-2023-12-08)
  * **Feature**: Releasing Scaling Group, Dataview, and Volume APIs
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.47.5](service/s3/CHANGELOG.md#v1475-2023-12-08)
  * **Bug Fix**: Add non-vhostable buckets to request path when using legacy V1 endpoint resolver.
  * **Bug Fix**: Improve uniqueness of default S3Express sesssion credentials cache keying to prevent collision in multi-credential scenarios.

# Release (2023-12-07)

## General Highlights
* **Feature**: Support modeled request compression. The only algorithm supported at this time is `gzip`.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.22.0](service/codedeploy/CHANGELOG.md#v1220-2023-12-07)
  * **Feature**: This release adds support for two new CodeDeploy features: 1) zonal deployments for Amazon EC2 in-place deployments, 2) deployments triggered by Auto Scaling group termination lifecycle hook events.

# Release (2023-12-06)

## General Highlights
* **Bug Fix**: Restore pre-refactor auth behavior where all operations could technically be performed anonymously.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.31.0](service/backup/CHANGELOG.md#v1310-2023-12-06)
  * **Feature**: AWS Backup - Features: Add VaultType to the output of DescribeRecoveryPoint, ListRecoveryPointByBackupVault API and add ResourceType to the input of ListRestoreJobs API
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.29.3](service/comprehend/CHANGELOG.md#v1293-2023-12-06)
  * **Documentation**: Documentation updates for Trust and Safety features.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.84.0](service/connect/CHANGELOG.md#v1840-2023-12-06)
  * **Feature**: Releasing Tagging Support for Instance Management APIS
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.140.0](service/ec2/CHANGELOG.md#v11400-2023-12-06)
  * **Feature**: Releasing the new cpuManufacturer attribute within the DescribeInstanceTypes API response which notifies our customers with information on who the Manufacturer is for the processor attached to the instance, for example: Intel.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.6.0](service/paymentcryptography/CHANGELOG.md#v160-2023-12-06)
  * **Feature**: AWS Payment Cryptography IPEK feature release
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.26.3](service/sts/CHANGELOG.md#v1263-2023-12-06)
  * **Bug Fix**: STS `AssumeRoleWithSAML` and `AssumeRoleWithWebIdentity` would incorrectly attempt to use SigV4 authentication.

# Release (2023-12-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.37.0](service/athena/CHANGELOG.md#v1370-2023-12-05)
  * **Feature**: Adding IdentityCenter enabled request for interactive query
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.1.0](service/cleanroomsml/CHANGELOG.md#v110-2023-12-05)
  * **Feature**: Updated service title from cleanroomsml to CleanRoomsML.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.42.1](service/cloudformation/CHANGELOG.md#v1421-2023-12-05)
  * **Documentation**: Documentation update, December 2023
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.139.0](service/ec2/CHANGELOG.md#v11390-2023-12-05)
  * **Feature**: Adds A10G, T4G, and H100 as accelerator name options and Habana as an accelerator manufacturer option for attribute based selection

# Release (2023-12-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.13.0](service/billingconductor/CHANGELOG.md#v1130-2023-12-04)
  * **Feature**: This release adds the ability to specify a linked account of the billing group for the custom line item resource.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.24.0](service/braket/CHANGELOG.md#v1240-2023-12-04)
  * **Feature**: This release enhances service support to create quantum tasks and hybrid jobs associated with Braket Direct Reservations.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.22.0](service/cloud9/CHANGELOG.md#v1220-2023-12-04)
  * **Feature**: This release adds the requirement to include the imageId parameter in the CreateEnvironmentEC2 API call.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.42.0](service/cloudformation/CHANGELOG.md#v1420-2023-12-04)
  * **Feature**: Including UPDATE_* states as a success status for CreateStack waiter.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.19.0](service/finspace/CHANGELOG.md#v1190-2023-12-04)
  * **Feature**: Release General Purpose type clusters
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.43.0](service/medialive/CHANGELOG.md#v1430-2023-12-04)
  * **Feature**: Adds support for custom color correction on channels using 3D LUT files.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.24.3](service/servicecatalogappregistry/CHANGELOG.md#v1243-2023-12-04)
  * **Documentation**: Documentation-only updates for Dawn

# Release (2023-12-01)

## General Highlights
* **Bug Fix**: Correct wrapping of errors in authentication workflow.
* **Bug Fix**: Correctly recognize cache-wrapped instances of AnonymousCredentials at client construction.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.2.0](service/qconnect/CHANGELOG.md#v120-2023-12-01)
  * **Feature**: This release adds the PutFeedback API and allows providing feedback against the specified assistant for the specified target.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.14.0](service/rbin/CHANGELOG.md#v1140-2023-12-01)
  * **Feature**: Added resource identifier in the output and updated error handling.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.8.0](service/verifiedpermissions/CHANGELOG.md#v180-2023-12-01)
  * **Feature**: Adds description field to PolicyStore API's and namespaces field to GetSchema.

# Release (2023-11-30.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.7.0](service/arczonalshift/CHANGELOG.md#v170-2023-11-302)
  * **Feature**: This release adds a new capability, zonal autoshift. You can configure zonal autoshift so that AWS shifts traffic for a resource away from an Availability Zone, on your behalf, when AWS determines that there is an issue that could potentially affect customers in the Availability Zone.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.26.2](service/dynamodb/CHANGELOG.md#v1262-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.72.0](service/glue/CHANGELOG.md#v1720-2023-11-302)
  * **Feature**: Adds observation and analyzer support to the GetDataQualityResult and BatchGetDataQualityResult APIs.
* `github.com/aws/aws-sdk-go-v2/service/internal/endpoint-discovery`: [v1.8.8](service/internal/endpoint-discovery/CHANGELOG.md#v188-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.120.0](service/sagemaker/CHANGELOG.md#v11200-2023-11-302)
  * **Feature**: This release adds support for 1/ Code Editor, based on Code-OSS, Visual Studio Code Open Source, a new fully managed IDE option in SageMaker Studio  2/ JupyterLab, a new fully managed JupyterLab IDE experience in SageMaker Studio
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.20.2](service/timestreamquery/CHANGELOG.md#v1202-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.23.2](service/timestreamwrite/CHANGELOG.md#v1232-2023-11-302)
  * **Bug Fix**: Respect caller region overrides in endpoint discovery.

# Release (2023-11-30)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/marketplaceagreement`: [v1.0.0](service/marketplaceagreement/CHANGELOG.md#v100-2023-11-30)
  * **Release**: New AWS service client module
  * **Feature**: The AWS Marketplace Agreement Service provides an API interface that helps AWS Marketplace sellers manage their agreements, including listing, filtering, and viewing details about their agreements.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.22.0](service/marketplacecatalog/CHANGELOG.md#v1220-2023-11-30)
  * **Feature**: This release enhances the ListEntities API to support new entity type-specific strongly typed filters in the request and entity type-specific strongly typed summaries in the response.
* `github.com/aws/aws-sdk-go-v2/service/marketplacedeployment`: [v1.0.0](service/marketplacedeployment/CHANGELOG.md#v100-2023-11-30)
  * **Release**: New AWS service client module
  * **Feature**: AWS Marketplace Deployment is a new service that provides essential features that facilitate the deployment of software, data, and services procured through AWS Marketplace.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.15.0](service/redshiftserverless/CHANGELOG.md#v1150-2023-11-30)
  * **Feature**: This release adds the following support for Amazon Redshift Serverless: 1) cross-account cross-VPCs, 2) copying snapshots across Regions, 3) scheduling snapshot creation, and 4) restoring tables from a recovery point.

# Release (2023-11-29)

## General Highlights
* **Feature**: Expose Options() accessor on service clients.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.25.0](service/applicationautoscaling/CHANGELOG.md#v1250-2023-11-29)
  * **Feature**: Amazon SageMaker customers can now use Application Auto Scaling to automatically scale the number of Inference Component copies across an endpoint to meet the varying demand of their workloads.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.8.0](service/cleanrooms/CHANGELOG.md#v180-2023-11-29)
  * **Feature**: AWS Clean Rooms now provides differential privacy to protect against user-identification attempts and machine learning modeling to allow two parties to identify similar users in their data.
* `github.com/aws/aws-sdk-go-v2/service/cleanroomsml`: [v1.0.0](service/cleanroomsml/CHANGELOG.md#v100-2023-11-29)
  * **Release**: New AWS service client module
  * **Feature**: Public Preview SDK release of AWS Clean Rooms ML APIs
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.26.0](service/opensearch/CHANGELOG.md#v1260-2023-11-29)
  * **Feature**: Launching Amazon OpenSearch Service support for new zero-ETL integration with Amazon S3. Customers can now manage their direct query data sources to Amazon S3 programatically
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.9.0](service/opensearchserverless/CHANGELOG.md#v190-2023-11-29)
  * **Feature**: Amazon OpenSearch Serverless collections support an additional attribute called standby-replicas. This allows to specify whether a collection should have redundancy enabled.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.119.0](service/sagemaker/CHANGELOG.md#v11190-2023-11-29)
  * **Feature**: This release adds following support 1/ Improved SDK tooling for model deployment. 2/ New Inference Component based features to lower inference costs and latency 3/ SageMaker HyperPod management. 4/ Additional parameters for FM Fine Tuning in Autopilot
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.25.0](service/sagemakerruntime/CHANGELOG.md#v1250-2023-11-29)
  * **Feature**: This release adds InferenceComponentName to InvokeEndpoint and InvokeEndpointWithResponseStream APIs to get inferences from the deployed InferenceComponents.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.26.0](service/sts/CHANGELOG.md#v1260-2023-11-29)
  * **Documentation**: Documentation updates for AWS Security Token Service.

# Release (2023-11-28.3)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.25.8](config/CHANGELOG.md#v1258-2023-11-283)
  * **Bug Fix**: Correct resolution of S3Express auth disable toggle.

# Release (2023-11-28.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.15.0](feature/s3/manager/CHANGELOG.md#v1150-2023-11-282)
  * **Feature**: Add S3Express support.
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.25.0](service/accessanalyzer/CHANGELOG.md#v1250-2023-11-282)
  * **Feature**: This release adds support for external access findings for S3 directory buckets to help you easily identify cross-account access. Updated service API, documentation, and paginators.
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.4.0](service/bedrock/CHANGELOG.md#v140-2023-11-282)
  * **Feature**: This release adds support for customization types, model life cycle status and minor versions/aliases for model identifiers.
* `github.com/aws/aws-sdk-go-v2/service/bedrockagent`: [v1.0.0](service/bedrockagent/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: This release introduces Agents for Amazon Bedrock
* `github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime`: [v1.0.0](service/bedrockagentruntime/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: This release introduces Agents for Amazon Bedrock Runtime
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.4.0](service/bedrockruntime/CHANGELOG.md#v140-2023-11-282)
  * **Feature**: This release adds support for minor versions/aliases for invoke model identifier.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.82.0](service/connect/CHANGELOG.md#v1820-2023-11-282)
  * **Feature**: Added support for following capabilities: Amazon Connect's in-app, web, and video calling. Two-way SMS integrations. Contact Lens real-time chat analytics feature. Amazon Connect Analytics Datalake capability. Capability to configure real time chat rules.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.33.0](service/customerprofiles/CHANGELOG.md#v1330-2023-11-282)
  * **Feature**: This release introduces DetectProfileObjectType API to auto generate object type mapping.
* `github.com/aws/aws-sdk-go-v2/service/qbusiness`: [v1.0.0](service/qbusiness/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Q - a generative AI powered application that your employees can use to ask questions and get answers from knowledge spread across disparate content repositories, summarize reports, write articles, take actions, and much more - all within their company's connected content repositories.
* `github.com/aws/aws-sdk-go-v2/service/qconnect`: [v1.0.0](service/qconnect/CHANGELOG.md#v100-2023-11-282)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Q in Connect, an LLM-enhanced evolution of Amazon Connect Wisdom. This release adds generative AI support to Amazon Q Connect QueryAssistant and GetRecommendations APIs.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.46.0](service/s3/CHANGELOG.md#v1460-2023-11-282)
  * **Feature**: Add S3Express support.
  * **Feature**: Adds support for S3 Express One Zone.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.40.0](service/s3control/CHANGELOG.md#v1400-2023-11-282)
  * **Feature**: Adds support for S3 Express One Zone, and InvocationSchemaVersion 2.0 for S3 Batch Operations.

# Release (2023-11-28)

## General Highlights
* **Bug Fix**: Respect setting RetryMaxAttempts in functional options at client construction.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.33.0](service/elasticache/CHANGELOG.md#v1330-2023-11-28)
  * **Feature**: Launching Amazon ElastiCache Serverless that enables you to create a cache in under a minute without any capacity management. ElastiCache Serverless monitors the cache's memory, CPU, and network usage and scales both vertically and horizontally to support your application's requirements.

# Release (2023-11-27.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.25.0](service/appsync/CHANGELOG.md#v1250-2023-11-272)
  * **Feature**: This update enables introspection of Aurora cluster databases using the RDS Data API
* `github.com/aws/aws-sdk-go-v2/service/b2bi`: [v1.0.0-preview](service/b2bi/CHANGELOG.md#v100-preview-2023-11-272)
  * **Feature**: This is the initial SDK release for AWS B2B Data Interchange.
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.29.0](service/backup/CHANGELOG.md#v1290-2023-11-272)
  * **Feature**: AWS Backup now supports restore testing, a new feature that allows customers to automate restore testing and validating their backups. Additionally, this release adds support for EBS Snapshots Archive tier.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.9.0](service/controltower/CHANGELOG.md#v190-2023-11-272)
  * **Feature**: This release adds the following support: 1. The EnableControl API can configure controls that are configurable.  2. The GetEnabledControl API shows the configured parameters on an enabled control. 3. The new UpdateEnabledControl API can change parameters on an enabled control.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.25.0](service/efs/CHANGELOG.md#v1250-2023-11-272)
  * **Feature**: Adding support for EFS Replication to existing file system.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.20.0](service/fis/CHANGELOG.md#v1200-2023-11-272)
  * **Feature**: AWS FIS adds support for multi-account experiments & empty target resolution. This release also introduces the CreateTargetAccountConfiguration API that allows experiments across multiple AWS accounts, and the ListExperimentResolvedTargets API to list target details.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.70.0](service/glue/CHANGELOG.md#v1700-2023-11-272)
  * **Feature**: add observations support to DQ CodeGen config model + update document for connectiontypes supported by ConnectorData entities
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.63.3](service/rds/CHANGELOG.md#v1633-2023-11-272)
  * **Documentation**: Updates Amazon RDS documentation for support for RDS for Db2.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.42.0](service/securityhub/CHANGELOG.md#v1420-2023-11-272)
  * **Feature**: Adds and updates APIs to support central configuration. This feature allows the Security Hub delegated administrator to configure Security Hub for their entire AWS Org across multiple regions from a home Region. With this release, findings also include account name and application metadata.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.33.0](service/transcribe/CHANGELOG.md#v1330-2023-11-272)
  * **Feature**: This release adds support for AWS HealthScribe APIs within Amazon Transcribe

# Release (2023-11-27)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.24.0](service/accessanalyzer/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: IAM Access Analyzer now continuously monitors IAM roles and users in your AWS account or organization to generate findings for unused access. Additionally, IAM Access Analyzer now provides custom policy checks to validate that IAM policies adhere to your security standards ahead of deployments.
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.20.0](service/amp/CHANGELOG.md#v1200-2023-11-27)
  * **Feature**: This release adds support for the Amazon Managed Service for Prometheus collector, a fully managed, agentless Prometheus metrics scraping capability.
* `github.com/aws/aws-sdk-go-v2/service/bcmdataexports`: [v1.0.0](service/bcmdataexports/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Users can create, read, update, delete Exports of billing and cost management data.  Users can get details of Export Executions and details of Tables for exporting.  Tagging support is provided for Exports
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.34.0](service/cloudtrail/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: CloudTrail Lake now supports federating event data stores. giving users the ability to run queries against their event data using Amazon Athena.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.28.0](service/cloudwatchlogs/CHANGELOG.md#v1280-2023-11-27)
  * **Feature**: Added APIs to Create, Update, Get, List and Delete LogAnomalyDetectors and List and Update Anomalies in Detector. Added LogGroupClass attribute for LogGroups to classify loggroup as Standard loggroup with all capabilities or InfrequentAccess loggroup with limited capabilities.
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.20.0](service/codestarconnections/CHANGELOG.md#v1200-2023-11-27)
  * **Feature**: This release adds support for the CloudFormation Git sync feature. Git sync enables updating a CloudFormation stack from a template stored in a Git repository.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.30.0](service/computeoptimizer/CHANGELOG.md#v1300-2023-11-27)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate recommendations with customization and discounts preferences.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.42.0](service/configservice/CHANGELOG.md#v1420-2023-11-27)
  * **Feature**: Support Periodic Recording for Configuration Recorder
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.8.0](service/controltower/CHANGELOG.md#v180-2023-11-27)
  * **Feature**: Add APIs to create and manage a landing zone.
* `github.com/aws/aws-sdk-go-v2/service/costoptimizationhub`: [v1.0.0](service/costoptimizationhub/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: This release launches Cost Optimization Hub, a new AWS Billing and Cost Management feature that helps you consolidate and prioritize cost optimization recommendations across your AWS Organizations member accounts and AWS Regions, so that you can get the most out of your AWS spend.
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.24.0](service/detective/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: Added new APIs in Detective to support resource investigations
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.34.0](service/ecs/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: Adds a new 'type' property to the Setting structure. Adds a new AccountSetting - guardDutyActivate for ECS.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.24.0](service/efs/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: Adding support for EFS Archive lifecycle configuration.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.34.0](service/eks/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: This release adds support for EKS Pod Identity feature. EKS Pod Identity makes it easy for customers to obtain IAM permissions for the applications running in their EKS clusters.
* `github.com/aws/aws-sdk-go-v2/service/eksauth`: [v1.0.0](service/eksauth/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for EKS Pod Identity feature. EKS Pod Identity makes it easy for customers to obtain IAM permissions for their applications running in the EKS clusters.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.25.0](service/elasticloadbalancingv2/CHANGELOG.md#v1250-2023-11-27)
  * **Feature**: This release enables both mutual authentication (mTLS), and Automatic Target Weights (ATW) for Application Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/freetier`: [v1.0.0](service/freetier/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for the AWS Free Tier GetFreeTierUsage API
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.38.0](service/fsx/CHANGELOG.md#v1380-2023-11-27)
  * **Feature**: Added support for FSx for ONTAP scale-out file systems and FlexGroup volumes. Added the HAPairs field and ThroughputCapacityPerHAPair for filesystem. Added AggregateConfiguration (containing Aggregates and ConstituentsPerAggregate) and SizeInBytes for volume.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.34.0](service/guardduty/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: Add support for Runtime Monitoring for ECS and ECS-EC2.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.9.0](service/iotfleetwise/CHANGELOG.md#v190-2023-11-27)
  * **Feature**: AWS IoT FleetWise introduces new APIs for vision system data, such as data collected from cameras, radars, and lidars. You can now model and decode complex data types.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.27.0](service/lakeformation/CHANGELOG.md#v1270-2023-11-27)
  * **Feature**: This release adds four new APIs "DescribeLakeFormationIdentityCenterConfiguration", "CreateLakeFormationIdentityCenterConfiguration", "DescribeLakeFormationIdentityCenterConfiguration", and "DeleteLakeFormationIdentityCenterConfiguration", and also updates the corresponding documentation.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.37.0](service/lexmodelsv2/CHANGELOG.md#v1370-2023-11-27)
  * **Feature**: This release introduces new generative AI features in AWS Lex: Assisted Slot Resolution, Descriptive Bot Building, and Sample Utterance Generation. These features leverage large language models available through Amazon Bedrock to improve the bot builder and customer experiences.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.22.0](service/lexruntimev2/CHANGELOG.md#v1220-2023-11-27)
  * **Feature**: This release introduces support for interpretationSource in the runtime service response.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.19.0](service/managedblockchain/CHANGELOG.md#v1190-2023-11-27)
  * **Feature**: Add optional NetworkType property to Accessor APIs
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.29.0](service/personalize/CHANGELOG.md#v1290-2023-11-27)
  * **Feature**: Enables metadata in recommendations, recommendations with themes, and next best action recommendations
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.18.0](service/personalizeevents/CHANGELOG.md#v1180-2023-11-27)
  * **Feature**: This release enables PutActions and PutActionInteractions
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.19.0](service/personalizeruntime/CHANGELOG.md#v1190-2023-11-27)
  * **Feature**: Enables metadata in recommendations and next best action recommendations
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.52.0](service/quicksight/CHANGELOG.md#v1520-2023-11-27)
  * **Feature**: This release launches new APIs for trusted identity propagation setup and supports creating datasources using trusted identity propagation as authentication method for QuickSight accounts configured with IAM Identity Center.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.38.0](service/redshift/CHANGELOG.md#v1380-2023-11-27)
  * **Feature**: This release adds support for multi-data warehouse writes through data sharing.
* `github.com/aws/aws-sdk-go-v2/service/repostspace`: [v1.0.0](service/repostspace/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS re:Post Private
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.45.0](service/s3/CHANGELOG.md#v1450-2023-11-27)
  * **Feature**: Adding new params - Key and Prefix, to S3 API operations for supporting S3 Access Grants. Note - These updates will not change any of the existing S3 API functionality.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.39.0](service/s3control/CHANGELOG.md#v1390-2023-11-27)
  * **Feature**: Introduce Amazon S3 Access Grants, a new S3 access control feature that maps identities in directories such as Active Directory, or AWS Identity and Access Management (IAM) Principals, to datasets in S3.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.24.0](service/secretsmanager/CHANGELOG.md#v1240-2023-11-27)
  * **Feature**: AWS Secrets Manager has released the BatchGetSecretValue API, which allows customers to fetch up to 20 Secrets with a single request using a list of secret names or filters.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.41.0](service/securityhub/CHANGELOG.md#v1410-2023-11-27)
  * **Feature**: Adds and updates APIs to support customizable security controls. This feature allows Security Hub customers to provide custom parameters for security controls. With this release, findings for controls that support custom parameters will include the parameters used to generate the findings.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.23.0](service/sfn/CHANGELOG.md#v1230-2023-11-27)
  * **Feature**: Adds new TestState operation which accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.32.0](service/transcribe/CHANGELOG.md#v1320-2023-11-27)
  * **Feature**: This release adds support for transcriptions from audio sources in 64 new languages and introduces generative call summarization in Transcribe Call Analytics (Post call)
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.34.0](service/workspaces/CHANGELOG.md#v1340-2023-11-27)
  * **Feature**: The release introduces Multi-Region Resilience one-way data replication that allows you to replicate data from your primary WorkSpace to a standby WorkSpace in another AWS Region. DescribeWorkspaces now returns the status of data replication.
* `github.com/aws/aws-sdk-go-v2/service/workspacesthinclient`: [v1.0.0](service/workspacesthinclient/CHANGELOG.md#v100-2023-11-27)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon WorkSpaces Thin Client

# Release (2023-11-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.23.0](service/kinesis/CHANGELOG.md#v1230-2023-11-22)
  * **Feature**: This release adds support for resource based policies on streams and consumers.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.38.0](service/s3control/CHANGELOG.md#v1380-2023-11-22)
  * **Feature**: **BREAK FIX**: Convert S3Control PublicAccessBlock field types to nilable. See #2384, #2162.
  * **Feature**: Amazon S3 Batch Operations now manages buckets or prefixes in a single step.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.118.0](service/sagemaker/CHANGELOG.md#v11180-2023-11-22)
  * **Feature**: This feature adds the end user license agreement status as a model access configuration parameter.

# Release (2023-11-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/credentials`: [v1.16.4](credentials/CHANGELOG.md#v1164-2023-11-21)
  * **Bug Fix**: Don't expect error responses to have a JSON payload in the endpointcreds provider.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.31.0](service/cloudfront/CHANGELOG.md#v1310-2023-11-21)
  * **Feature**: This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore`: [v1.0.0](service/cloudfrontkeyvaluestore/CHANGELOG.md#v100-2023-11-21)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.137.1](service/ec2/CHANGELOG.md#v11371-2023-11-21)
  * **Documentation**: Documentation updates for Amazon EC2.
* `github.com/aws/aws-sdk-go-v2/service/inspectorscan`: [v1.0.0](service/inspectorscan/CHANGELOG.md#v100-2023-11-21)
  * **Release**: New AWS service client module
  * **Feature**: This release adds support for the new Amazon Inspector Scan API. The new Inspector Scan API can synchronously scan SBOMs adhering to the CycloneDX v1.5 format.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.33.0](service/iotsitewise/CHANGELOG.md#v1330-2023-11-21)
  * **Feature**: Adds 1/ user-defined unique identifier for asset and model metadata, 2/ asset model components, and 3/ query API for asset metadata and telemetry data. Supports 4/ multi variate anomaly detection using Amazon Lookout for Equipment, 5/ warm storage tier, and 6/ buffered ingestion of time series data.
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.16.0](service/iottwinmaker/CHANGELOG.md#v1160-2023-11-21)
  * **Feature**: This release adds following support. 1. New APIs for metadata bulk operations. 2. Modify the component type API to support composite component types - nesting component types within one another. 3. New list APIs for components and properties. 4. Support the larger scope digital twin modeling.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.44.0](service/s3/CHANGELOG.md#v1440-2023-11-21)
  * **Feature**: Add support for automatic date based partitioning in S3 Server Access Logs.
  * **Bug Fix**: Don't send MaxKeys/MaxUploads=0 when unspecified in ListObjectVersions and ListMultipartUploads paginators.

# Release (2023-11-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.23.1
  * **Bug Fix**: Mark v4.SignHTTPRequestMiddleware as deprecated, this middleware is no longer used by the SDK.
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.19.0](service/codestarconnections/CHANGELOG.md#v1190-2023-11-20)
  * **Feature**: This release updates a few CodeStar Connections related APIs.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.28.0](service/docdb/CHANGELOG.md#v1280-2023-11-20)
  * **Feature**: Amazon DocumentDB updates for new cluster storage configuration: Amazon DocumentDB I/O-Optimized.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.137.0](service/ec2/CHANGELOG.md#v11370-2023-11-20)
  * **Feature**: This release adds support for Security group referencing over Transit gateways, enabling you to simplify Security group management and control of instance-to-instance traffic across VPCs that are connected by Transit gateway.

# Release (2023-11-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/s3/manager`: [v1.14.0](feature/s3/manager/CHANGELOG.md#v1140-2023-11-17)
  * **Feature**: **BREAKING CHANGE** Correct nullability of a large number of S3 structure fields. See https://github.com/aws/aws-sdk-go-v2/issues/2162.
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.22.0](service/appmesh/CHANGELOG.md#v1220-2023-11-17)
  * **Feature**: Change the default value of these fields from 0 to null: MaxConnections, MaxPendingRequests, MaxRequests, HealthCheckThreshold, PortNumber, and HealthCheckPolicy -> port. Users are not expected to perceive the change, except that badRequestException is thrown when required fields missing configured.
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.35.0](service/athena/CHANGELOG.md#v1350-2023-11-17)
  * **Feature**: Adding SerivicePreProcessing time metric
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.20.3](service/cloud9/CHANGELOG.md#v1203-2023-11-17)
  * **Documentation**: A minor doc only update related to changing the date of an API change.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.40.0](service/cloudformation/CHANGELOG.md#v1400-2023-11-17)
  * **Feature**: This release adds a new flag ImportExistingResources to CreateChangeSet. Specify this parameter on a CREATE- or UPDATE-type change set to import existing resources with custom names instead of recreating them.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.21.0](service/codepipeline/CHANGELOG.md#v1210-2023-11-17)
  * **Feature**: CodePipeline now supports overriding source revisions to achieve manual re-deploy of a past revision
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.18.0](service/codestarconnections/CHANGELOG.md#v1180-2023-11-17)
  * **Feature**: This release adds support for the CloudFormation Git sync feature. Git sync enables updating a CloudFormation stack from a template stored in a Git repository.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.81.0](service/connect/CHANGELOG.md#v1810-2023-11-17)
  * **Feature**: This release adds WISDOM_QUICK_RESPONSES as new IntegrationType of Connect IntegrationAssociation resource and bug fixes.
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.21.1](service/dlm/CHANGELOG.md#v1211-2023-11-17)
  * **Documentation**: Added support for SAP HANA in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies with pre and post scripts.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.136.0](service/ec2/CHANGELOG.md#v11360-2023-11-17)
  * **Feature**: This release adds new features for Amazon VPC IP Address Manager (IPAM) Allowing a choice between Free and Advanced Tiers, viewing public IP address insights across regions and in Amazon Cloudwatch, use IPAM to plan your subnet IPs within a VPC and bring your own autonomous system number to IPAM.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.23.0](service/ecr/CHANGELOG.md#v1230-2023-11-17)
  * **Feature**: Documentation and operational updates for Amazon ECR, adding support for pull through cache rules for upstream registries that require authentication.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.34.0](service/emr/CHANGELOG.md#v1340-2023-11-17)
  * **Feature**: Launch support for IAM Identity Center Trusted Identity Propagation and workspace storage encryption using AWS KMS in EMR Studio
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.25.0](service/eventbridge/CHANGELOG.md#v1250-2023-11-17)
  * **Feature**: Introduces a new rule state ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS for matching with Get, List and Describe AWS API call events from CloudTrail.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.9.0](service/internetmonitor/CHANGELOG.md#v190-2023-11-17)
  * **Feature**: Adds new querying capabilities for running data queries on a monitor
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.29.0](service/ivs/CHANGELOG.md#v1290-2023-11-17)
  * **Feature**: type & defaulting refinement to various range properties
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.9.0](service/ivschat/CHANGELOG.md#v190-2023-11-17)
  * **Feature**: type & defaulting refinement to various range properties
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.20.3](service/kinesisvideo/CHANGELOG.md#v1203-2023-11-17)
  * **Documentation**: Docs only build to bring up-to-date with public docs.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.31.0](service/location/CHANGELOG.md#v1310-2023-11-17)
  * **Feature**: Remove default value and allow nullable for request parameters having minimum value larger than zero.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.41.0](service/medialive/CHANGELOG.md#v1410-2023-11-17)
  * **Feature**: MediaLive has now added support for per-output static image overlay.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.24.0](service/mgn/CHANGELOG.md#v1240-2023-11-17)
  * **Feature**: Removed invalid and unnecessary default values.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.5.0](service/osis/CHANGELOG.md#v150-2023-11-17)
  * **Feature**: Add support for enabling a persistent buffer when creating or updating an OpenSearch Ingestion pipeline. Add tags to Pipeline and PipelineSummary response models.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.8.0](service/pipes/CHANGELOG.md#v180-2023-11-17)
  * **Feature**: TargetParameters now properly supports BatchJobParameters.ArrayProperties.Size and BatchJobParameters.RetryStrategy.Attempts being optional, and EcsTaskParameters.Overrides.EphemeralStorage.SizeInGiB now properly required when setting EphemeralStorage
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.63.0](service/rds/CHANGELOG.md#v1630-2023-11-17)
  * **Feature**: This release adds support for option groups and replica enhancements to Amazon RDS Custom.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.37.0](service/redshift/CHANGELOG.md#v1370-2023-11-17)
  * **Feature**: Updated SDK for Amazon Redshift, which you can use to configure a connection with IAM Identity Center to manage access to databases. With these, you can create a connection through a managed application. You can also change a managed application, delete it, or get information about an existing one.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.13.0](service/redshiftserverless/CHANGELOG.md#v1130-2023-11-17)
  * **Feature**: Updated SDK for Amazon Redshift Serverless, which provides the ability to configure a connection with IAM Identity Center to manage user and group access to databases.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.43.0](service/s3/CHANGELOG.md#v1430-2023-11-17)
  * **Feature**: **BREAKING CHANGE** Correct nullability of a large number of S3 structure fields. See https://github.com/aws/aws-sdk-go-v2/issues/2162.
  * **Feature**: Removes all default 0 values for numbers and false values for booleans
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.22.0](service/ssoadmin/CHANGELOG.md#v1220-2023-11-17)
  * **Feature**: Improves support for configuring RefreshToken and TokenExchange grants on applications.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.20.0](service/ssooidc/CHANGELOG.md#v1200-2023-11-17)
  * **Feature**: Adding support for `sso-oauth:CreateTokenWithIAM`.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.25.3](service/sts/CHANGELOG.md#v1253-2023-11-17)
  * **Documentation**: API updates for the AWS Security Token Service
* `github.com/aws/aws-sdk-go-v2/service/trustedadvisor`: [v1.0.0](service/trustedadvisor/CHANGELOG.md#v100-2023-11-17)
  * **Release**: New AWS service client module
  * **Feature**: AWS Trusted Advisor introduces new APIs to enable you to programmatically access Trusted Advisor best practice checks, recommendations, and prioritized recommendations. Trusted Advisor APIs enable you to integrate Trusted Advisor with your operational tools to automate your workloads.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.6.0](service/verifiedpermissions/CHANGELOG.md#v160-2023-11-17)
  * **Feature**: Adding BatchIsAuthorized API which supports multiple authorization requests against a PolicyStore
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.19.0](service/wisdom/CHANGELOG.md#v1190-2023-11-17)
  * **Feature**: This release adds QuickResponse as a new Wisdom resource and Wisdom APIs for import, create, read, search, update and delete QuickResponse resources.

# Release (2023-11-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.1](internal/ini/CHANGELOG.md#v171-2023-11-16)
  * **Bug Fix**: Fix recognition of trailing comments in shared config properties. # or ; separators that aren't preceded by whitespace at the end of a property value should be considered part of it.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.9.0](service/codecatalyst/CHANGELOG.md#v190-2023-11-16)
  * **Feature**: This release includes updates to the Dev Environment APIs to include an optional vpcConnectionName parameter that supports using Dev Environments with Amazon VPC.
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.21.0](service/dlm/CHANGELOG.md#v1210-2023-11-16)
  * **Feature**: This release adds support for Amazon Data Lifecycle Manager default policies for EBS snapshots and EBS-backed AMIs.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.135.0](service/ec2/CHANGELOG.md#v11350-2023-11-16)
  * **Feature**: Enable use of tenant-specific PublicSigningKeyUrl from device trust providers and onboard jumpcloud as a new device trust provider.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.37.0](service/fsx/CHANGELOG.md#v1370-2023-11-16)
  * **Feature**: Enables customers to update their PerUnitStorageThroughput on their Lustre file systems.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.69.0](service/glue/CHANGELOG.md#v1690-2023-11-16)
  * **Feature**: Introduces new column statistics APIs to support statistics generation for tables within the Glue Data Catalog.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.28.0](service/imagebuilder/CHANGELOG.md#v1280-2023-11-16)
  * **Feature**: This release adds the Image Lifecycle Management feature to automate the process of deprecating, disabling and deleting outdated images and their associated resources.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.45.0](service/iot/CHANGELOG.md#v1450-2023-11-16)
  * **Feature**: GA release the ability to index and search devices based on their GeoLocation data. With GeoQueries you can narrow your search to retrieve devices located in the desired geographic boundary.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.8.0](service/ivsrealtime/CHANGELOG.md#v180-2023-11-16)
  * **Feature**: This release introduces server side composition and recording for stages.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.27.0](service/kafka/CHANGELOG.md#v1270-2023-11-16)
  * **Feature**: Added a new API response field which determines if there is an action required from the customer regarding their cluster.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.48.0](service/lambda/CHANGELOG.md#v1480-2023-11-16)
  * **Feature**: Adds support for logging configuration in Lambda Functions. Customers will have more control how their function logs are captured and to which cloud watch log group they are delivered also.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.33.0](service/macie2/CHANGELOG.md#v1330-2023-11-16)
  * **Feature**: This release adds support for configuring Macie to assume an IAM role when retrieving sample occurrences of sensitive data reported by findings.
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.27.0](service/mediapackage/CHANGELOG.md#v1270-2023-11-16)
  * **Feature**: DRM_TOP_LEVEL_COMPACT allows placing content protection elements at the MPD level and referenced at the AdaptationSet level
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.6.0](service/pinpointsmsvoicev2/CHANGELOG.md#v160-2023-11-16)
  * **Feature**: Amazon Pinpoint now offers additional operations as part of version 2 of the SMS and voice APIs. This release includes 26 new APIs to create and manage phone number registrations, add verified destination numbers, and request sender IDs.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.35.0](service/polly/CHANGELOG.md#v1350-2023-11-16)
  * **Feature**: Add new engine - long-form - dedicated for longer content, such as news articles, training materials, or marketing videos.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.51.0](service/quicksight/CHANGELOG.md#v1510-2023-11-16)
  * **Feature**: Custom permission support for QuickSight roles; Three new datasources STARBURST, TRINO, BIGQUERY; Lenient mode changes the default behavior to allow for exporting and importing with certain UI allowed errors, Support for permissions and tags export and import.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.117.0](service/sagemaker/CHANGELOG.md#v11170-2023-11-16)
  * **Feature**: Amazon SageMaker Studio now supports Trainium instance types - trn1.2xlarge, trn1.32xlarge, trn1n.32xlarge.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.43.0](service/ssm/CHANGELOG.md#v1430-2023-11-16)
  * **Feature**: This release introduces the ability to filter automation execution steps which have parent steps. In addition, runbook variable information is returned by GetAutomationExecution and parent step information is returned by the DescribeAutomationStepExecutions API.
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.26.0](service/ssmincidents/CHANGELOG.md#v1260-2023-11-16)
  * **Feature**: Introduces new APIs ListIncidentFindings and BatchGetIncidentFindings to use findings related to an incident.
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.21.0](service/ssoadmin/CHANGELOG.md#v1210-2023-11-16)
  * **Feature**: Instances bound to a single AWS account, API operations for managing instances and applications, and assignments to applications are now supported. Trusted identity propagation is also supported, with new API operations for managing trusted token issuers and application grants and scopes.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.38.0](service/transfer/CHANGELOG.md#v1380-2023-11-16)
  * **Feature**: Introduced S3StorageOptions for servers to enable directory listing optimizations and added Type fields to logical directory mappings.

# Release (2023-11-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.23.0
  * **Feature**: **BREAKING CHANGE**: DisableHTTPS middleware has changed steps from Serialize to Finalize. Middleware that indexes off of this field will need to be updated accordingly.
  * **Feature**: **BREAKING CHANGE**: Request body checksum middlewares (flex checksums, SHA256, etc.) have changed steps from Build to Finalize. Middleware that indexes off of this field will need to be updated accordingly.
  * **Feature**: **BREAKING CHANGE**: V2 endpoint resolution middleware has changed steps from Serialize to Finalize. Middleware that indexes off of this field will need to be updated accordingly.
  * **Feature**: Add client config helpers for overriding SigV4 signing name and region.
  * **Feature**: Refactored endpoint resolution middleware into a single implementation per-service, reducing generated code footprint.
  * **Feature**: Support smithy-modeled identity and auth resolution. Service clients can now be configured to override or use additional authentication schemes.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.35.0](service/autoscaling/CHANGELOG.md#v1350-2023-11-15)
  * **Feature**: This release introduces Instance Maintenance Policy, a new EC2 Auto Scaling capability that allows customers to define whether instances are launched before or after existing instances are terminated during instance replacement operations.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.33.0](service/cloudtrail/CHANGELOG.md#v1330-2023-11-15)
  * **Feature**: The Lake Repricing feature lets customers configure a BillingMode for an event data store. The BillingMode determines the cost for ingesting and storing events and the default and maximum retention period for the event data store.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.8.0](service/codecatalyst/CHANGELOG.md#v180-2023-11-15)
  * **Feature**: This release adds functionality for retrieving information about workflows and workflow runs and starting workflow runs in Amazon CodeCatalyst.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.134.0](service/ec2/CHANGELOG.md#v11340-2023-11-15)
  * **Feature**: AWS EBS now supports Snapshot Lock, giving users the ability to lock an EBS Snapshot to prohibit deletion of the snapshot. This release introduces the LockSnapshot, UnlockSnapshot & DescribeLockedSnapshots APIs to manage lock configuration for snapshots. The release also includes the dl2q_24xlarge.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.17.0](service/finspace/CHANGELOG.md#v1170-2023-11-15)
  * **Feature**: Adding deprecated trait on Dataset Browser Environment APIs
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.21.0](service/finspacedata/CHANGELOG.md#v1210-2023-11-15)
  * **Feature**: Adding deprecated trait to APIs in this name space.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.47.0](service/lambda/CHANGELOG.md#v1470-2023-11-15)
  * **Feature**: Add Java 21 (java21) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.21.0](service/mwaa/CHANGELOG.md#v1210-2023-11-15)
  * **Feature**: This Amazon MWAA release adds support for customer-managed VPC endpoints. This lets you choose whether to create, and manage your environment's VPC endpoints, or to have Amazon MWAA create, and manage them for you.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.4](service/rds/CHANGELOG.md#v1624-2023-11-15)
  * **Documentation**: Updates Amazon RDS documentation for support for upgrading RDS for MySQL snapshots from version 5.7 to version 8.0.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.36.0](service/redshift/CHANGELOG.md#v1360-2023-11-15)
  * **Feature**: The custom domain name SDK for Amazon Redshift provisioned clusters is updated with additional required parameters for modify and delete operations. Additionally, users can provide domain names with longer top-level domains.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.37.0](service/s3control/CHANGELOG.md#v1370-2023-11-15)
  * **Feature**: Add 5 APIs to create, update, get, list, delete S3 Storage Lens group(eg. CreateStorageLensGroup), 3 APIs for tagging(TagResource,UntagResource,ListTagsForResource), and update to StorageLensConfiguration to allow metrics to be aggregated on Storage Lens groups.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.9.0](service/ssmsap/CHANGELOG.md#v190-2023-11-15)
  * **Feature**: Update the default value of MaxResult to 50.

# Release (2023-11-14)

## General Highlights
* **Feature**: Add support for dynamic auth token from file and EKS container host in absolute/relative URIs in the HTTP credential provider.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.28.0](service/backup/CHANGELOG.md#v1280-2023-11-14)
  * **Feature**: AWS Backup - Features: Provide Job Summary for your backup activity.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.7.0](service/cleanrooms/CHANGELOG.md#v170-2023-11-14)
  * **Feature**: This feature provides the ability for the collaboration creator to configure either the member who can run queries or a different member in the collaboration to be billed for query compute costs.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.80.0](service/connect/CHANGELOG.md#v1800-2023-11-14)
  * **Feature**: Introducing SegmentAttributes parameter for StartChatContact API
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.68.0](service/glue/CHANGELOG.md#v1680-2023-11-14)
  * **Feature**: Introduces new storage optimization APIs to support automatic compaction of Apache Iceberg tables.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.44.0](service/iot/CHANGELOG.md#v1440-2023-11-14)
  * **Feature**: This release introduces new attributes in API CreateSecurityProfile, UpdateSecurityProfile and DescribeSecurityProfile to support management of Metrics Export for AWS IoT Device Defender Detect.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.46.0](service/lambda/CHANGELOG.md#v1460-2023-11-14)
  * **Feature**: Add Python 3.12 (python3.12) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.31.0](service/mediatailor/CHANGELOG.md#v1310-2023-11-14)
  * **Feature**: Removed unnecessary default values.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.7.0](service/pipes/CHANGELOG.md#v170-2023-11-14)
  * **Feature**: Added support (via new LogConfiguration field in CreatePipe and UpdatePipe APIs) for logging to Amazon CloudWatch Logs, Amazon Simple Storage Service (Amazon S3), and Amazon Kinesis Data Firehose
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.7.0](service/resourceexplorer2/CHANGELOG.md#v170-2023-11-14)
  * **Feature**: Resource Explorer supports multi-account search. You can now use Resource Explorer to search and discover resources across AWS accounts within your organization or organizational unit.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.116.0](service/sagemaker/CHANGELOG.md#v11160-2023-11-14)
  * **Feature**: This release makes Model Registry Inference Specification fields as not required.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.22.0](service/sfn/CHANGELOG.md#v1220-2023-11-14)
  * **Feature**: This release adds support to redrive executions in AWS Step Functions with a new RedriveExecution operation.
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.18.2](service/signer/CHANGELOG.md#v1182-2023-11-14)
  * **Documentation**: Documentation updates for AWS Signer

# Release (2023-11-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.24.0](config/CHANGELOG.md#v1240-2023-11-13)
  * **Feature**: Replace the legacy config parser with a modern, less-strict implementation. Parsing failures within a section will now simply ignore the invalid line rather than silently drop the entire section.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.7.0](internal/ini/CHANGELOG.md#v170-2023-11-13)
  * **Feature**: Replace the legacy config parser with a modern, less-strict implementation. Parsing failures within a section will now simply ignore the invalid line rather than silently drop the entire section.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.34.0](service/databasemigrationservice/CHANGELOG.md#v1340-2023-11-13)
  * **Feature**: Added new Db2 LUW Target endpoint with related endpoint settings. New executeTimeout endpoint setting for mysql endpoint. New ReplicationDeprovisionTime field for serverless describe-replications.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.25.0](service/dataexchange/CHANGELOG.md#v1250-2023-11-13)
  * **Feature**: Removed Required trait for DataSet.OriginDetails.ProductId.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.133.0](service/ec2/CHANGELOG.md#v11330-2023-11-13)
  * **Feature**: Adds the new EC2 DescribeInstanceTopology API, which you can use to retrieve the network topology of your running instances on select platform types to determine their relative proximity to each other.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.33.0](service/ecs/CHANGELOG.md#v1330-2023-11-13)
  * **Feature**: Adds a Client Token parameter to the ECS RunTask API. The Client Token parameter allows for idempotent RunTask requests.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.33.0](service/emr/CHANGELOG.md#v1330-2023-11-13)
  * **Feature**: Updated GetClusterSessionCredentials API  to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters to support IdentityCenter/PEZ integration.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.23.0](service/servicecatalogappregistry/CHANGELOG.md#v1230-2023-11-13)
  * **Feature**: When the customer associates a resource collection to their application with this new feature, then a new application tag will be applied to all supported resources that are part of that collection. This allows customers to more easily find the application that is associated with those resources.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.14.0](service/transcribestreaming/CHANGELOG.md#v1140-2023-11-13)
  * **Feature**: This release enables customers to call the AWS Transcribe streaming service with the capability of identifying multiple languages in the stream.

# Release (2023-11-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.7.0](service/controltower/CHANGELOG.md#v170-2023-11-10)
  * **Feature**: AWS Control Tower supports tagging for enabled controls. This release introduces TagResource, UntagResource and ListTagsForResource APIs to manage tags in existing enabled controls. It updates EnabledControl API to tag resources at creation time.
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.20.0](service/costandusagereportservice/CHANGELOG.md#v1200-2023-11-10)
  * **Feature**: This release adds support for tagging and customers can now tag report definitions. Additionally, ReportStatus is now added to report definition to show when the last delivered time stamp and if it succeeded or not.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.132.0](service/ec2/CHANGELOG.md#v11320-2023-11-10)
  * **Feature**: EC2 adds API updates to enable ENA Express at instance launch time.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.28.2](service/fms/CHANGELOG.md#v1282-2023-11-10)
  * **Documentation**: Adds optimizeUnassociatedWebACL flag to ManagedServiceData, updates third-party firewall examples, and other minor documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.17.0](service/marketplaceentitlementservice/CHANGELOG.md#v1170-2023-11-10)
  * **Feature**: Add paginators to GetEntitlements.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.47.0](service/mediaconvert/CHANGELOG.md#v1470-2023-11-10)
  * **Feature**: This release includes the ability to specify any input source as the primary input for corresponding follow modes, and allows users to specify fit and fill behaviors without resizing content.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.3](service/rds/CHANGELOG.md#v1623-2023-11-10)
  * **Documentation**: Updates Amazon RDS documentation for zero-ETL integrations.

# Release (2023-11-09.2)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.23.0](config/CHANGELOG.md#v1230-2023-11-092)
  * **Feature**: BREAKFIX: In order to support subproperty parsing, invalid property definitions must not be ignored
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.6.0](internal/ini/CHANGELOG.md#v160-2023-11-092)
  * **Feature**: BREAKFIX: In order to support subproperty parsing, invalid property definitions must not be ignored
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.39.0](service/cloudformation/CHANGELOG.md#v1390-2023-11-092)
  * **Feature**: Added new ConcurrencyMode feature for AWS CloudFormation StackSets for faster deployments to target accounts.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.32.0](service/cloudtrail/CHANGELOG.md#v1320-2023-11-092)
  * **Feature**: The Insights in Lake feature lets customers enable CloudTrail Insights on a source CloudTrail Lake event data store and create a destination event data store to collect Insights events based on unusual management event activity in the source event data store.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.27.0](service/cloudwatchlogs/CHANGELOG.md#v1270-2023-11-092)
  * **Feature**: Update to support new APIs for delivery of logs from AWS services.
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.28.0](service/comprehend/CHANGELOG.md#v1280-2023-11-092)
  * **Feature**: This release adds support for toxicity detection and prompt safety classification.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.79.0](service/connect/CHANGELOG.md#v1790-2023-11-092)
  * **Feature**: This release adds the ability to integrate customer lambda functions with Connect attachments for scanning and updates the ListIntegrationAssociations API to support filtering on IntegrationArn.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.131.0](service/ec2/CHANGELOG.md#v11310-2023-11-092)
  * **Feature**: AWS EBS now supports Block Public Access for EBS Snapshots. This release introduces the EnableSnapshotBlockPublicAccess, DisableSnapshotBlockPublicAccess and GetSnapshotBlockPublicAccessState APIs to manage account-level public access settings for EBS Snapshots in an AWS Region.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.33.0](service/eks/CHANGELOG.md#v1330-2023-11-092)
  * **Feature**: Adding EKS Anywhere subscription related operations.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.45.0](service/lambda/CHANGELOG.md#v1450-2023-11-092)
  * **Feature**: Add Custom runtime on Amazon Linux 2023 (provided.al2023) support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.15.0](service/omics/CHANGELOG.md#v1150-2023-11-092)
  * **Feature**: Support UBAM filetype for Omics Storage and make referenceArn optional

# Release (2023-11-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.22.2
  * **Bug Fix**: added x-amz-expected-bucket-owner to the list of headers we should sign
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.28.0](service/sqs/CHANGELOG.md#v1280-2023-11-09)
  * **Feature**: This release enables customers to call SQS using AWS JSON-1.0 protocol and bug fix.

# Release (2023-11-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.78.0](service/connect/CHANGELOG.md#v1780-2023-11-08)
  * **Feature**: This release clarifies in our public documentation that InstanceId is a requirement for SearchUsers API requests.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.11.0](service/connectcases/CHANGELOG.md#v1110-2023-11-08)
  * **Feature**: This release adds the ability to add/view comment authors through CreateRelatedItem and SearchRelatedItems API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.33.0](service/guardduty/CHANGELOG.md#v1330-2023-11-08)
  * **Feature**: Added API support for new GuardDuty EKS Audit Log finding types.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.44.0](service/lambda/CHANGELOG.md#v1440-2023-11-08)
  * **Feature**: Add Node 20 (nodejs20.x) support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.36.0](service/lexmodelsv2/CHANGELOG.md#v1360-2023-11-08)
  * **Feature**: AWS Lex now supports selective log capture in conversation logs. When you enable this option within the conversation log settings, only the utterances that trigger intents and slots specified in session attributes will be logged.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.14.0](service/omics/CHANGELOG.md#v1140-2023-11-08)
  * **Feature**: Adding Run UUID and Run Output URI: GetRun and StartRun API response has two new fields "uuid" and "runOutputUri".
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.1](service/rds/CHANGELOG.md#v1621-2023-11-08)
  * **Documentation**: This Amazon RDS release adds support for patching the OS of an RDS Custom for Oracle DB instance. You can now upgrade the database or operating system using the modify-db-instance command.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.12.0](service/redshiftserverless/CHANGELOG.md#v1120-2023-11-08)
  * **Feature**: Added a new parameter in the workgroup that helps you control your cost for compute resources. This feature provides a ceiling for RPUs that Amazon Redshift Serverless can scale up to. When automatic compute scaling is required, having a higher value for MaxRPU can enhance query throughput.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.17.0](service/resiliencehub/CHANGELOG.md#v1170-2023-11-08)
  * **Feature**: AWS Resilience Hub enhances Resiliency Score, providing actionable recommendations to improve application resilience. Amazon Elastic Kubernetes Service (EKS) operational recommendations have been added to help improve the resilience posture of your applications.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.27.0](service/sqs/CHANGELOG.md#v1270-2023-11-08)
  * **Feature**: This release enables customers to call SQS using AWS JSON-1.0 protocol.

# Release (2023-11-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.5.1](internal/ini/CHANGELOG.md#v151-2023-11-07)
  * **Bug Fix**: Fix subproperty performance regression
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.20.0](service/dlm/CHANGELOG.md#v1200-2023-11-07)
  * **Feature**: Added support for pre and post scripts in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.62.0](service/rds/CHANGELOG.md#v1620-2023-11-07)
  * **Feature**: This Amazon RDS release adds support for the multi-tenant configuration. In this configuration, an RDS DB instance can contain multiple tenant databases. In RDS for Oracle, a tenant database is a pluggable database (PDB).

# Release (2023-11-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.25.0](service/codebuild/CHANGELOG.md#v1250-2023-11-06)
  * **Feature**: AWS CodeBuild now supports AWS Lambda compute.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.77.0](service/connect/CHANGELOG.md#v1770-2023-11-06)
  * **Feature**: Added new API that allows Amazon Connect Outbound Campaigns to create contacts in Amazon Connect when ingesting your dial requests.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.32.0](service/costexplorer/CHANGELOG.md#v1320-2023-11-06)
  * **Feature**: This release extends the GetReservationPurchaseRecommendation API to support recommendations for Amazon MemoryDB reservations.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.27.0](service/docdb/CHANGELOG.md#v1270-2023-11-06)
  * **Feature**: Update the input of CreateDBInstance and ModifyDBInstance to support setting CA Certificates. Update the output of DescribeDBInstance and DescribeDBEngineVersions to show current and supported CA certificates.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.27.0](service/iam/CHANGELOG.md#v1270-2023-11-06)
  * **Feature**: Add partitional endpoint for iso-e.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.20.0](service/mwaa/CHANGELOG.md#v1200-2023-11-06)
  * **Feature**: This release adds support for Apache Airflow version 2.7.2. This version release includes support for deferrable operators and triggers.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.34.0](service/polly/CHANGELOG.md#v1340-2023-11-06)
  * **Feature**: Amazon Polly adds new US English voices - Danielle and Gregory. Danielle and Gregory are available as Neural voices only.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.34.0](service/route53/CHANGELOG.md#v1340-2023-11-06)
  * **Feature**: Add partitional endpoints for iso-e and iso-f.

# Release (2023-11-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.41.0](service/configservice/CHANGELOG.md#v1410-2023-11-03)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in October 2023.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.76.0](service/connect/CHANGELOG.md#v1760-2023-11-03)
  * **Feature**: Amazon Connect Chat introduces Create Persistent Contact Association API, allowing customers to choose when to resume previous conversations from previous chats, eliminating the need to repeat themselves and allowing agents to provide personalized service with access to entire conversation history.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.33.0](service/iotwireless/CHANGELOG.md#v1330-2023-11-03)
  * **Feature**: Added LoRaWAN version 1.0.4 support
* `github.com/aws/aws-sdk-go-v2/service/launchwizard`: [v1.0.0](service/launchwizard/CHANGELOG.md#v100-2023-11-03)
  * **Release**: New AWS service client module
  * **Feature**: AWS Launch Wizard is a service that helps reduce the time it takes to deploy applications to the cloud while providing a guided deployment experience.

# Release (2023-11-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.22.0](config/CHANGELOG.md#v1220-2023-11-02)
  * **Feature**: Add env and shared config settings for disabling IMDSv1 fallback.
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.24.0](service/apprunner/CHANGELOG.md#v1240-2023-11-02)
  * **Feature**: AWS App Runner now supports using dual-stack address type for the public endpoint of your incoming traffic.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.75.0](service/connect/CHANGELOG.md#v1750-2023-11-02)
  * **Feature**: GetMetricDataV2 API: Update to include new metrics PERCENT_NON_TALK_TIME, PERCENT_TALK_TIME, PERCENT_TALK_TIME_AGENT, PERCENT_TALK_TIME_CUSTOMER
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.26.0](service/gamelift/CHANGELOG.md#v1260-2023-11-02)
  * **Feature**: Amazon GameLift adds support for shared credentials, which allows applications that are deployed on managed EC2 fleets to interact with other AWS resources.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.67.0](service/glue/CHANGELOG.md#v1670-2023-11-02)
  * **Feature**: This release introduces Google BigQuery Source and Target in AWS Glue CodeGenConfigurationNode.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.35.0](service/networkfirewall/CHANGELOG.md#v1350-2023-11-02)
  * **Feature**: This release introduces the stateless rule analyzer, which enables you to analyze your stateless rules for asymmetric routing.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.50.0](service/quicksight/CHANGELOG.md#v1500-2023-11-02)
  * **Feature**: This release introduces Float Decimal Type as SubType in QuickSight SPICE datasets and Custom week start and Custom timezone options in Analysis and Dashboard

# Release (2023-11-01)

## General Highlights
* **Feature**: Adds support for configured endpoints via environment variables and the AWS shared configuration file.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.74.0](service/connect/CHANGELOG.md#v1740-2023-11-01)
  * **Feature**: Adds the BatchGetFlowAssociation API which returns flow associations (flow-resource) corresponding to the list of resourceArns supplied in the request. This release also adds IsDefault, LastModifiedRegion and LastModifiedTime fields to the responses of several Describe and List APIs.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.19.0](service/globalaccelerator/CHANGELOG.md#v1190-2023-11-01)
  * **Feature**: Global Accelerator now support accelerators with cross account endpoints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.61.0](service/rds/CHANGELOG.md#v1610-2023-11-01)
  * **Feature**: This release adds support for customized networking resources to Amazon RDS Custom.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.35.0](service/redshift/CHANGELOG.md#v1350-2023-11-01)
  * **Feature**: Added support for Multi-AZ deployments for Provisioned RA3 clusters that provide 99.99% SLA availability.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.115.0](service/sagemaker/CHANGELOG.md#v11150-2023-11-01)
  * **Feature**: Support for batch transform input in Model dashboard

# Release (2023-10-31)

## General Highlights
* **Feature**: **BREAKING CHANGE**: Bump minimum go version to 1.19 per the revised [go version support policy](https://aws.amazon.com/blogs/developer/aws-sdk-for-go-aligns-with-go-release-policy-on-supported-runtimes/).
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.16.0](service/amplify/CHANGELOG.md#v1160-2023-10-31)
  * **Feature**: Add backend field to CreateBranch and UpdateBranch requests. Add pagination support for ListApps, ListDomainAssociations, ListBranches, and ListJobs
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.20.0](service/applicationinsights/CHANGELOG.md#v1200-2023-10-31)
  * **Feature**: Automate attaching managed policies
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.129.0](service/ec2/CHANGELOG.md#v11290-2023-10-31)
  * **Feature**: Capacity Blocks for ML are a new EC2 purchasing option for reserving GPU instances on a future date to support short duration machine learning (ML) workloads. Capacity Blocks automatically place instances close together inside Amazon EC2 UltraClusters for low-latency, high-throughput networking.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.8.0](service/m2/CHANGELOG.md#v180-2023-10-31)
  * **Feature**: Added name filter ability for ListDataSets API, added ForceUpdate for Updating environment and BatchJob submission using S3BatchJobIdentifier
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.1.0](service/neptunedata/CHANGELOG.md#v110-2023-10-31)
  * **Feature**: Minor change to not retry CancelledByUserException
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.20.0](service/translate/CHANGELOG.md#v1200-2023-10-31)
  * **Feature**: Added support for Brevity translation settings feature.

# Release (2023-10-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.72.0](service/connect/CHANGELOG.md#v1720-2023-10-30)
  * **Feature**: This release adds InstanceId field for phone number APIs.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.22.0](service/dataexchange/CHANGELOG.md#v1220-2023-10-30)
  * **Feature**: We added a new API action: SendDataSetNotification.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.30.0](service/datasync/CHANGELOG.md#v1300-2023-10-30)
  * **Feature**: Platform version changes to support AL1 deprecation initiative.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.14.0](service/finspace/CHANGELOG.md#v1140-2023-10-30)
  * **Feature**: Introducing new API UpdateKxClusterCodeConfiguration, introducing new cache types for clusters and introducing new deployment modes for updating clusters.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.4.0](service/mediapackagev2/CHANGELOG.md#v140-2023-10-30)
  * **Feature**: This feature allows customers to create a combination of manifest filtering, startover and time delay configuration that applies to all egress requests by default.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.59.0](service/rds/CHANGELOG.md#v1590-2023-10-30)
  * **Feature**: This release launches the CreateIntegration, DeleteIntegration, and DescribeIntegrations APIs to manage zero-ETL Integrations.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.9.0](service/redshiftserverless/CHANGELOG.md#v190-2023-10-30)
  * **Feature**: Added support for custom domain names for Amazon Redshift Serverless workgroups. This feature enables customers to create a custom domain name and use ACM to generate fully secure connections to it.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.14.0](service/resiliencehub/CHANGELOG.md#v1140-2023-10-30)
  * **Feature**: Introduced the ability to filter applications by their last assessment date and time and have included metrics for the application's estimated workload Recovery Time Objective (RTO) and estimated workload Recovery Point Objective (RPO).
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.19.0](service/s3outposts/CHANGELOG.md#v1190-2023-10-30)
  * **Feature**: Updated ListOutpostsWithS3 API response to include S3OutpostArn for use with AWS RAM.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.16.1](service/wisdom/CHANGELOG.md#v1161-2023-10-30)
  * **Documentation**: This release added necessary API documents on creating a Wisdom knowledge base to integrate with S3.

# Release (2023-10-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.30.0](service/emr/CHANGELOG.md#v1300-2023-10-27)
  * **Feature**: Updated CreateCluster API request and DescribeCluster API responses to include EbsRootVolumeIops, and EbsRootVolumeThroughput attributes that specify the user configured root volume IOPS and throughput for Amazon EBS root device volume. This feature will be available from Amazon EMR releases 6.15.0
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.24.0](service/neptune/CHANGELOG.md#v1240-2023-10-27)
  * **Feature**: Update TdeCredentialPassword type to SensitiveString
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.23.1](service/pinpoint/CHANGELOG.md#v1231-2023-10-27)
  * **Documentation**: Updated documentation to describe the case insensitivity for EndpointIds.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.33.0](service/redshift/CHANGELOG.md#v1330-2023-10-27)
  * **Feature**: added support to create a dual stack cluster
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.40.1](service/wafv2/CHANGELOG.md#v1401-2023-10-27)
  * **Documentation**: Updates the descriptions for the calls that manage web ACL associations, to provide information for customer-managed IAM policies.

# Release (2023-10-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.26.0](service/appstream/CHANGELOG.md#v1260-2023-10-26)
  * **Feature**: This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.128.0](service/ec2/CHANGELOG.md#v11280-2023-10-26)
  * **Feature**: Launching GetSecurityGroupsForVpc API. This API gets security groups that can be associated by the AWS account making the request with network interfaces in the specified VPC.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.32.0](service/networkfirewall/CHANGELOG.md#v1320-2023-10-26)
  * **Feature**: Network Firewall now supports inspection of outbound SSL/TLS traffic.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.23.0](service/opensearch/CHANGELOG.md#v1230-2023-10-26)
  * **Feature**: You can specify ipv4 or dualstack IPAddressType for cluster endpoints. If you specify IPAddressType as dualstack, the new endpoint will be visible under the 'EndpointV2' parameter and will support IPv4 and IPv6 requests. Whereas, the 'Endpoint' will continue to serve IPv4 requests.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.32.0](service/redshift/CHANGELOG.md#v1320-2023-10-26)
  * **Feature**: Add Redshift APIs GetResourcePolicy, DeleteResourcePolicy, PutResourcePolicy and DescribeInboundIntegrations for the new Amazon Redshift Zero-ETL integration feature, which can be used to control data ingress into Redshift namespace, and view inbound integrations.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.113.0](service/sagemaker/CHANGELOG.md#v11130-2023-10-26)
  * **Feature**: Amazon Sagemaker Autopilot now supports Text Generation jobs.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.23.0](service/sns/CHANGELOG.md#v1230-2023-10-26)
  * **Feature**: Message Archiving and Replay is now supported in Amazon SNS for FIFO topics.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.6.0](service/ssmsap/CHANGELOG.md#v160-2023-10-26)
  * **Feature**: AWS Systems Manager for SAP added support for registration and discovery of SAP ABAP applications
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.35.0](service/transfer/CHANGELOG.md#v1350-2023-10-26)
  * **Feature**: No API changes from previous release. This release migrated the model to Smithy keeping all features unchanged.

# Release (2023-10-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.8.0](service/connectcases/CHANGELOG.md#v180-2023-10-25)
  * **Feature**: Increase maximum length of CommentBody to 3000, and increase maximum length of StringValue to 1500
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.20.0](service/groundstation/CHANGELOG.md#v1200-2023-10-25)
  * **Feature**: This release will allow KMS alias names to be used when creating Mission Profiles
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.24.0](service/iam/CHANGELOG.md#v1240-2023-10-25)
  * **Feature**: Updates to GetAccessKeyLastUsed action to replace NoSuchEntity error with AccessDeniedException error.

# Release (2023-10-24)

## General Highlights
* **Feature**: **BREAKFIX**: Correct nullability and default value representation of various input fields across a large number of services. Calling code that references one or more of the affected fields will need to update usage accordingly. See [2162](https://github.com/aws/aws-sdk-go-v2/issues/2162).
* **Feature**: **BREAKFIX**: Correct nullability representation of APIGateway-based services.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.18.0](service/codepipeline/CHANGELOG.md#v1180-2023-10-24)
  * **Feature**: Add ability to trigger pipelines from git tags, define variables at pipeline level and new pipeline type V2.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.127.0](service/ec2/CHANGELOG.md#v11270-2023-10-24)
  * **Feature**: This release updates the documentation for InstanceInterruptionBehavior and HibernationOptionsRequest to more accurately describe the behavior of these two parameters when using Spot hibernation.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.30.0](service/eks/CHANGELOG.md#v1300-2023-10-24)
  * **Feature**: Added support for Cluster Subnet and Security Group mutability.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.23.0](service/iam/CHANGELOG.md#v1230-2023-10-24)
  * **Feature**: Add the partitional endpoint for IAM in iso-f.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.16.0](service/migrationhubconfig/CHANGELOG.md#v1160-2023-10-24)
  * **Feature**: This release introduces DeleteHomeRegionControl API that customers can use to delete the Migration Hub Home Region configuration
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.12.0](service/migrationhubstrategy/CHANGELOG.md#v1120-2023-10-24)
  * **Feature**: This release introduces multi-data-source feature in Migration Hub Strategy Recommendations. This feature now supports vCenter as a data source to fetch inventory in addition to ADS and Import from file workflow that is currently supported with MHSR collector.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.6.0](service/opensearchserverless/CHANGELOG.md#v160-2023-10-24)
  * **Feature**: This release includes the following new APIs: CreateLifecyclePolicy, UpdateLifecyclePolicy, BatchGetLifecyclePolicy, DeleteLifecyclePolicy, ListLifecyclePolicies and BatchGetEffectiveLifecyclePolicy to support the data lifecycle management feature.

# Release (2023-10-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.15.0](service/marketplacecommerceanalytics/CHANGELOG.md#v1150-2023-10-23)
  * **Feature**: The StartSupportDataExport operation has been deprecated as part of the Product Support Connection deprecation. As of December 2022, Product Support Connection is no longer supported.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.20.0](service/networkmanager/CHANGELOG.md#v1200-2023-10-23)
  * **Feature**: This release adds API support for Tunnel-less Connect (NoEncap Protocol) for AWS Cloud WAN
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.8.0](service/redshiftserverless/CHANGELOG.md#v180-2023-10-23)
  * **Feature**: This release adds support for customers to see the patch version and workgroup version in Amazon Redshift Serverless.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.32.0](service/rekognition/CHANGELOG.md#v1320-2023-10-23)
  * **Feature**: Amazon Rekognition introduces StartMediaAnalysisJob, GetMediaAnalysisJob, and ListMediaAnalysisJobs operations to run a bulk analysis of images with a Detect Moderation model.

# Release (2023-10-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.22.0](service/appconfig/CHANGELOG.md#v1220-2023-10-20)
  * **Feature**: Update KmsKeyIdentifier constraints to support AWS KMS multi-Region keys.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.19.0](service/appintegrations/CHANGELOG.md#v1190-2023-10-20)
  * **Feature**: Updated ScheduleConfig to be an optional input to CreateDataIntegration to support event driven downloading of files from sources such as Amazon s3 using Amazon Connect AppIntegrations.
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.19.0](service/applicationdiscoveryservice/CHANGELOG.md#v1190-2023-10-20)
  * **Feature**: This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.70.0](service/connect/CHANGELOG.md#v1700-2023-10-20)
  * **Feature**: This release adds support for updating phone number metadata, such as phone number description.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.2.3](service/medicalimaging/CHANGELOG.md#v123-2023-10-20)
  * **Documentation**: Updates on documentation links
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.39.0](service/ssm/CHANGELOG.md#v1390-2023-10-20)
  * **Feature**: This release introduces a new API: DeleteOpsItem. This allows deletion of an OpsItem.

# Release (2023-10-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.126.0](service/ec2/CHANGELOG.md#v11260-2023-10-19)
  * **Feature**: Amazon EC2 C7a instances, powered by 4th generation AMD EPYC processors, are ideal for high performance, compute-intensive workloads such as high performance computing. Amazon EC2 R7i instances are next-generation memory optimized and powered by custom 4th Generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.3.0](service/managedblockchainquery/CHANGELOG.md#v130-2023-10-19)
  * **Feature**: This release adds support for Ethereum Sepolia network
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.0.4](service/neptunedata/CHANGELOG.md#v104-2023-10-19)
  * **Documentation**: Doc changes to add IAM action mappings for the data actions.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.11.0](service/omics/CHANGELOG.md#v1110-2023-10-19)
  * **Feature**: This change enables customers to retrieve failure reasons with detailed status messages for their failed runs
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.21.0](service/opensearch/CHANGELOG.md#v1210-2023-10-19)
  * **Feature**: Added Cluster Administrative options for node restart, opensearch process restart and opensearch dashboard restart for Multi-AZ without standby domains
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.46.0](service/quicksight/CHANGELOG.md#v1460-2023-10-19)
  * **Feature**: This release adds the following: 1) Trino and Starburst Database Connectors 2) Custom total for tables and pivot tables 3) Enable restricted folders 4) Add rolling dates for time equality filters 5) Refine DataPathValue and introduce DataPathType 6) Add SeriesType to ReferenceLineDataConfiguration
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.21.6](service/secretsmanager/CHANGELOG.md#v1216-2023-10-19)
  * **Documentation**: Documentation updates for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.22.0](service/servicecatalog/CHANGELOG.md#v1220-2023-10-19)
  * **Feature**: Introduce support for EXTERNAL product and provisioning artifact type in CreateProduct and CreateProvisioningArtifact APIs.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.3.0](service/verifiedpermissions/CHANGELOG.md#v130-2023-10-19)
  * **Feature**: Improving Amazon Verified Permissions Create experience
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.31.3](service/workspaces/CHANGELOG.md#v1313-2023-10-19)
  * **Documentation**: Documentation updates for WorkSpaces

# Release (2023-10-18)

## General Highlights
* **Feature**: Add handwritten paginators that were present in some services in the v1 SDK.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.11](service/cloud9/CHANGELOG.md#v11811-2023-10-18)
  * **Documentation**: Update to imageId parameter behavior and dates updated.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.23.0](service/dynamodb/CHANGELOG.md#v1230-2023-10-18)
  * **Documentation**: Updating descriptions for several APIs.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.44.0](service/kendra/CHANGELOG.md#v1440-2023-10-18)
  * **Feature**: Changes for a new feature in Amazon Kendra's Query API to Collapse/Expand query results
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.57.0](service/rds/CHANGELOG.md#v1570-2023-10-18)
  * **Feature**: This release adds support for upgrading the storage file system configuration on the DB instance using a blue/green deployment or a read replica.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.16.0](service/wisdom/CHANGELOG.md#v1160-2023-10-18)
  * **Feature**: This release adds an max limit of 25 recommendation ids for NotifyRecommendationsReceived API.

# Release (2023-10-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.18.0](service/applicationdiscoveryservice/CHANGELOG.md#v1180-2023-10-17)
  * **Feature**: This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.17.0](service/codepipeline/CHANGELOG.md#v1170-2023-10-17)
  * **Feature**: Add retryMode ALL_ACTIONS to RetryStageExecution API that retries a failed stage starting from first action in the stage
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.30.4](service/ecs/CHANGELOG.md#v1304-2023-10-17)
  * **Documentation**: Documentation only updates to address Amazon ECS tickets.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.29.0](service/guardduty/CHANGELOG.md#v1290-2023-10-17)
  * **Feature**: Add domainWithSuffix finding field to dnsRequestAction
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.23.0](service/kafka/CHANGELOG.md#v1230-2023-10-17)
  * **Feature**: AWS Managed Streaming for Kafka is launching MSK Replicator, a new feature that enables customers to reliably replicate data across Amazon MSK clusters in same or different AWS regions. You can now use SDK to create, list, describe, delete, update, and manage tags of MSK Replicators.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.14.0](service/route53recoverycluster/CHANGELOG.md#v1140-2023-10-17)
  * **Feature**: Adds Owner field to ListRoutingControls API.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.14.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1140-2023-10-17)
  * **Feature**: Adds permissions for GetResourcePolicy to support returning details about AWS Resource Access Manager resource policies for shared resources.

# Release (2023-10-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.19.0](config/CHANGELOG.md#v1190-2023-10-16)
  * **Feature**: Modify logic of retrieving user agent appID from env config
* `github.com/aws/aws-sdk-go-v2/feature/cloudfront/sign`: [v1.4.0](feature/cloudfront/sign/CHANGELOG.md#v140-2023-10-16)
  * **Feature**: Add support for loading PKCS8-formatted private keys.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.35.0](service/cloudformation/CHANGELOG.md#v1350-2023-10-16)
  * **Feature**: SDK and documentation updates for UpdateReplacePolicy
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.17.0](service/drs/CHANGELOG.md#v1170-2023-10-16)
  * **Feature**: Updated exsiting API to allow AWS Elastic Disaster Recovery support of launching recovery into existing EC2 instances.
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.3.0](service/entityresolution/CHANGELOG.md#v130-2023-10-16)
  * **Feature**: This launch expands our matching techniques to include provider-based matching to help customer match, link, and enhance records with minimal data movement. With data service providers, we have removed the need for customers to build bespoke integrations,.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.2.0](service/managedblockchainquery/CHANGELOG.md#v120-2023-10-16)
  * **Feature**: This release introduces two new APIs: GetAssetContract and ListAssetContracts. This release also adds support for Bitcoin Testnet.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.3.0](service/mediapackagev2/CHANGELOG.md#v130-2023-10-16)
  * **Feature**: This release allows customers to manage MediaPackage v2 resource using CloudFormation.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.20.0](service/opensearch/CHANGELOG.md#v1200-2023-10-16)
  * **Feature**: This release allows customers to list and associate optional plugin packages with compatible Amazon OpenSearch Service clusters for enhanced functionality.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.30.0](service/redshift/CHANGELOG.md#v1300-2023-10-16)
  * **Feature**: Added support for managing credentials of provisioned cluster admin using AWS Secrets Manager.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.7.0](service/redshiftserverless/CHANGELOG.md#v170-2023-10-16)
  * **Feature**: Added support for managing credentials of serverless namespace admin using AWS Secrets Manager.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.21.0](service/sesv2/CHANGELOG.md#v1210-2023-10-16)
  * **Feature**: This release provides enhanced visibility into your SES identity verification status. This will offer you more actionable insights, enabling you to promptly address any verification-related issues.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.34.2](service/transfer/CHANGELOG.md#v1342-2023-10-16)
  * **Documentation**: Documentation updates for AWS Transfer Family
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.19.0](service/xray/CHANGELOG.md#v1190-2023-10-16)
  * **Feature**: This releases enhances GetTraceSummaries API to support new TimeRangeType Service to query trace summaries by segment end time.

# Release (2023-10-12)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.21.2
  * **Bug Fix**: Improve recognition of retryable DNS errors.
* `github.com/aws/aws-sdk-go-v2/config`: [v1.18.45](config/CHANGELOG.md#v11845-2023-10-12)
  * **Bug Fix**: Fail to load config if an explicitly provided profile doesn't exist.
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.27.0](service/auditmanager/CHANGELOG.md#v1270-2023-10-12)
  * **Feature**: This release introduces a new limit to the awsAccounts parameter. When you create or update an assessment, there is now a limit of 200 AWS accounts that can be specified in the assessment scope.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.31.0](service/autoscaling/CHANGELOG.md#v1310-2023-10-12)
  * **Feature**: Update the NotificationMetadata field to only allow visible ascii characters. Add paginators to DescribeInstanceRefreshes, DescribeLoadBalancers, and DescribeLoadBalancerTargetGroups
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.37.0](service/configservice/CHANGELOG.md#v1370-2023-10-12)
  * **Feature**: Add enums for resource types supported by Config
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.4.0](service/controltower/CHANGELOG.md#v140-2023-10-12)
  * **Feature**: Added new EnabledControl resource details to ListEnabledControls API and added new GetEnabledControl API.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.29.0](service/customerprofiles/CHANGELOG.md#v1290-2023-10-12)
  * **Feature**: Adds sensitive trait to various shapes in Customer Profiles Calculated Attribute API model.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.125.0](service/ec2/CHANGELOG.md#v11250-2023-10-12)
  * **Feature**: This release adds Ubuntu Pro as a supported platform for On-Demand Capacity Reservations and adds support for setting an Amazon Machine Image (AMI) to disabled state. Disabling the AMI makes it private if it was previously shared, and prevents new EC2 instance launches from it.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.21.6](service/elasticloadbalancingv2/CHANGELOG.md#v1216-2023-10-12)
  * **Documentation**: This release enables routing policies with Availability Zone affinity for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.63.0](service/glue/CHANGELOG.md#v1630-2023-10-12)
  * **Feature**: Extending version control support to GitLab and Bitbucket from AWSGlue
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.17.0](service/inspector2/CHANGELOG.md#v1170-2023-10-12)
  * **Feature**: Add MacOs ec2 platform support
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.5.0](service/ivsrealtime/CHANGELOG.md#v150-2023-10-12)
  * **Feature**: Update GetParticipant to return additional metadata.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.40.0](service/lambda/CHANGELOG.md#v1400-2023-10-12)
  * **Feature**: Adds support for Lambda functions to access Dual-Stack subnets over IPv6, via an opt-in flag in CreateFunction and UpdateFunctionConfiguration APIs
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.28.0](service/location/CHANGELOG.md#v1280-2023-10-12)
  * **Feature**: This release adds endpoint updates for all AWS Location resource operations.
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.18.0](service/machinelearning/CHANGELOG.md#v1180-2023-10-12)
  * **Feature**: This release marks Password field as sensitive
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.21.9](service/pricing/CHANGELOG.md#v1219-2023-10-12)
  * **Documentation**: Documentation updates for Price List
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.56.0](service/rds/CHANGELOG.md#v1560-2023-10-12)
  * **Feature**: This release adds support for adding a dedicated log volume to open-source RDS instances.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.31.0](service/rekognition/CHANGELOG.md#v1310-2023-10-12)
  * **Feature**: Amazon Rekognition introduces support for Custom Moderation. This allows the enhancement of accuracy for detect moderation labels operations by creating custom adapters tuned on customer data.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.111.0](service/sagemaker/CHANGELOG.md#v11110-2023-10-12)
  * **Feature**: Amazon SageMaker Canvas adds KendraSettings and DirectDeploySettings support for CanvasAppSettings
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.25.0](service/textract/CHANGELOG.md#v1250-2023-10-12)
  * **Feature**: This release adds 9 new APIs for adapter and adapter version management, 3 new APIs for tagging, and updates AnalyzeDocument and StartDocumentAnalysis API parameters for using adapters.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.29.0](service/transcribe/CHANGELOG.md#v1290-2023-10-12)
  * **Feature**: This release is to enable m4a format to customers
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.31.2](service/workspaces/CHANGELOG.md#v1312-2023-10-12)
  * **Documentation**: Updated the CreateWorkspaces action documentation to clarify that the PCoIP protocol is only available for Windows bundles.

# Release (2023-10-06)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.124.0](service/ec2/CHANGELOG.md#v11240-2023-10-06)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.33.0](service/fsx/CHANGELOG.md#v1330-2023-10-06)
  * **Feature**: After performing steps to repair the Active Directory configuration of a file system, use this action to initiate the process of attempting to recover to the file system.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.18.0](service/marketplacecatalog/CHANGELOG.md#v1180-2023-10-06)
  * **Feature**: This release adds support for Document type as an alternative for stringified JSON for StartChangeSet, DescribeChangeSet and DescribeEntity APIs
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.45.0](service/quicksight/CHANGELOG.md#v1450-2023-10-06)
  * **Feature**: NullOption in FilterListConfiguration; Dataset schema/table max length increased; Support total placement for pivot table visual; Lenient mode relaxes the validation to create resources with definition; Data sources can be added to folders; Redshift data sources support IAM Role-based authentication
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.34.0](service/transfer/CHANGELOG.md#v1340-2023-10-06)
  * **Feature**: This release updates the max character limit of PreAuthenticationLoginBanner and PostAuthenticationLoginBanner to 4096 characters

# Release (2023-10-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.10.0](service/omics/CHANGELOG.md#v1100-2023-10-05)
  * **Feature**: Add Etag Support for Omics Storage in ListReadSets and GetReadSetMetadata API
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.55.1](service/rds/CHANGELOG.md#v1551-2023-10-05)
  * **Documentation**: Updates Amazon RDS documentation for corrections and minor improvements.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.30.0](service/route53/CHANGELOG.md#v1300-2023-10-05)
  * **Feature**: Add hostedzonetype filter to ListHostedZones API.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.37.0](service/securityhub/CHANGELOG.md#v1370-2023-10-05)
  * **Feature**: Added new resource detail objects to ASFF, including resources for AwsEventsEventbus, AwsEventsEndpoint, AwsDmsEndpoint, AwsDmsReplicationTask, AwsDmsReplicationInstance, AwsRoute53HostedZone, and AwsMskCluster
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.21.0](service/storagegateway/CHANGELOG.md#v1210-2023-10-05)
  * **Feature**: Add SoftwareVersion to response of DescribeGatewayInformation.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.31.0](service/workspaces/CHANGELOG.md#v1310-2023-10-05)
  * **Feature**: This release introduces Manage applications. This feature allows users to manage their WorkSpaces applications by associating or disassociating their WorkSpaces with applications. The DescribeWorkspaces API will now additionally return OperatingSystemName in its responses.

# Release (2023-10-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.21.0](service/appconfig/CHANGELOG.md#v1210-2023-10-04)
  * **Feature**: AWS AppConfig introduces KMS customer-managed key (CMK) encryption support for data saved to AppConfig's hosted configuration store.
* `github.com/aws/aws-sdk-go-v2/service/datazone`: [v1.0.0](service/datazone/CHANGELOG.md#v100-2023-10-04)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon DataZone
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.28.0](service/mediatailor/CHANGELOG.md#v1280-2023-10-04)
  * **Feature**: Updates DescribeVodSource to include a list of ad break opportunities in the response
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.21.0](service/mgn/CHANGELOG.md#v1210-2023-10-04)
  * **Feature**: This release includes the following new APIs: ListConnectors, CreateConnector,  UpdateConnector, DeleteConnector and UpdateSourceServer to support the source action framework feature.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.110.0](service/sagemaker/CHANGELOG.md#v11100-2023-10-04)
  * **Feature**: Adding support for AdditionalS3DataSource, a data source used for training or inference that is in addition to the input dataset or model data.

# Release (2023-10-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.69.0](service/connect/CHANGELOG.md#v1690-2023-10-03)
  * **Feature**: GetMetricDataV2 API: Update to include new metrics CONTACTS_RESOLVED_IN_X , AVG_HOLD_TIME_ALL_CONTACTS , AVG_RESOLUTION_TIME , ABANDONMENT_RATE , AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS with added features: Interval Period, TimeZone, Negate MetricFilters, Extended date time range.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.27.0](service/location/CHANGELOG.md#v1270-2023-10-03)
  * **Feature**: Amazon Location Service adds support for bounding polygon queries. Additionally, the GeofenceCount field has been added to the DescribeGeofenceCollection API response.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.43.0](service/mediaconvert/CHANGELOG.md#v1430-2023-10-03)
  * **Feature**: This release adds the ability to replace video frames without modifying the audio essence.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.4.0](service/oam/CHANGELOG.md#v140-2023-10-03)
  * **Feature**: This release adds support for sharing AWS::ApplicationInsights::Application resources.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.109.0](service/sagemaker/CHANGELOG.md#v11090-2023-10-03)
  * **Feature**: This release allows users to run Selective Execution in SageMaker Pipelines without SourcePipelineExecutionArn if selected steps do not have any dependent steps.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.23.0](service/wellarchitected/CHANGELOG.md#v1230-2023-10-03)
  * **Feature**: AWS Well-Architected now supports Review Templates that allows you to create templates with pre-filled answers for Well-Architected and Custom Lens best practices.

# Release (2023-10-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.1.0](service/bedrock/CHANGELOG.md#v110-2023-10-02)
  * **Feature**: Provisioned throughput feature with Amazon and third-party base models, and update validators for model identifier and taggable resource ARNs.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.1.0](service/bedrockruntime/CHANGELOG.md#v110-2023-10-02)
  * **Feature**: Add model timeout exception for InvokeModelWithResponseStream API and update validator for invoke model identifier.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.123.0](service/ec2/CHANGELOG.md#v11230-2023-10-02)
  * **Feature**: Introducing Amazon EC2 R7iz instances with 3.9 GHz sustained all-core turbo frequency and deliver up to 20% better performance than previous generation z1d instances.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.16.6](service/managedblockchain/CHANGELOG.md#v1166-2023-10-02)
  * **Documentation**: Remove Rinkeby as option from Ethereum APIs
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.55.0](service/rds/CHANGELOG.md#v1550-2023-10-02)
  * **Feature**: Adds DefaultCertificateForNewLaunches field in the DescribeCertificates API response.
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.15.0](service/sso/CHANGELOG.md#v1150-2023-10-02)
  * **Feature**: Fix FIPS Endpoints in aws-us-gov.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.23.0](service/sts/CHANGELOG.md#v1230-2023-10-02)
  * **Feature**: STS API updates for assumeRole
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.33.9](service/transfer/CHANGELOG.md#v1339-2023-10-02)
  * **Documentation**: Documentation updates for AWS Transfer Family

# Release (2023-09-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/bedrock`: [v1.0.0](service/bedrock/CHANGELOG.md#v100-2023-09-28)
  * **Release**: New AWS service client module
  * **Feature**: Model Invocation logging added to enable or disable logs in customer account. Model listing and description support added. Provisioned Throughput feature added. Custom model support added for creating custom models. Also includes list, and delete functions for custom model.
* `github.com/aws/aws-sdk-go-v2/service/bedrockruntime`: [v1.0.0](service/bedrockruntime/CHANGELOG.md#v100-2023-09-28)
  * **Release**: New AWS service client module
  * **Feature**: Run Inference: Added support to run the inference on models.  Includes set of APIs for running inference in streaming and non-streaming mode.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.17.0](service/budgets/CHANGELOG.md#v1170-2023-09-28)
  * **Feature**: Update DescribeBudgets and DescribeBudgetNotificationsForAccount MaxResults limit to 1000.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.122.0](service/ec2/CHANGELOG.md#v11220-2023-09-28)
  * **Feature**: Adds support for Customer Managed Key encryption for Amazon Verified Access resources
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.6.0](service/iotfleetwise/CHANGELOG.md#v160-2023-09-28)
  * **Feature**: AWS IoT FleetWise now supports encryption through a customer managed AWS KMS key. The PutEncryptionConfiguration and GetEncryptionConfiguration APIs were added.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.108.0](service/sagemaker/CHANGELOG.md#v11080-2023-09-28)
  * **Feature**: Online store feature groups supports Standard and InMemory tier storage types for low latency storage for real-time data retrieval. The InMemory tier supports collection types List, Set, and Vector.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.18.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1180-2023-09-28)
  * **Feature**: Feature Store supports read/write of records with collection type features.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.39.1](service/wafv2/CHANGELOG.md#v1391-2023-09-28)
  * **Documentation**: Correct and improve the documentation for the FieldToMatch option JA3 fingerprint.

# Release (2023-09-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.27.0](service/cognitoidentityprovider/CHANGELOG.md#v1270-2023-09-27)
  * **Feature**: The UserPoolType Status field is no longer used.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.19.0](service/firehose/CHANGELOG.md#v1190-2023-09-27)
  * **Feature**: Features : Adding support for new data ingestion source to Kinesis Firehose - AWS Managed Services Kafka.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.40.0](service/iot/CHANGELOG.md#v1400-2023-09-27)
  * **Feature**: Added support for IoT Rules Engine Kafka Action Headers
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.24.0](service/textract/CHANGELOG.md#v1240-2023-09-27)
  * **Feature**: This release adds new feature - Layout to Analyze Document API which can automatically extract layout elements such as titles, paragraphs, headers, section headers, lists, page numbers, footers, table areas, key-value areas and figure areas and order the elements as a human would read.

# Release (2023-09-26)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.18.0](service/appintegrations/CHANGELOG.md#v1180-2023-09-26)
  * **Feature**: The Amazon AppIntegrations service adds a set of APIs (in preview) to manage third party applications to be used in Amazon Connect agent workspace.
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.21.0](service/apprunner/CHANGELOG.md#v1210-2023-09-26)
  * **Feature**: This release allows an App Runner customer to specify a custom source directory to run the build & start command. This change allows App Runner to support monorepo based repositories
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.18.1](service/codedeploy/CHANGELOG.md#v1181-2023-09-26)
  * **Documentation**: CodeDeploy now supports In-place and Blue/Green EC2 deployments with multiple Classic Load Balancers and multiple Target Groups.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.68.0](service/connect/CHANGELOG.md#v1680-2023-09-26)
  * **Feature**: This release updates a set of Amazon Connect APIs that provides the ability to integrate third party applications in the Amazon Connect agent workspace.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.22.0](service/dynamodb/CHANGELOG.md#v1220-2023-09-26)
  * **Feature**: Amazon DynamoDB now supports Incremental Export as an enhancement to the existing Export Table
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.121.0](service/ec2/CHANGELOG.md#v11210-2023-09-26)
  * **Feature**: The release includes AWS verified access to support FIPs compliance in North America regions
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.24.0](service/lakeformation/CHANGELOG.md#v1240-2023-09-26)
  * **Feature**: This release adds three new API support "CreateLakeFormationOptIn", "DeleteLakeFormationOptIn" and "ListLakeFormationOptIns", and also updates the corresponding documentation.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.22.6](service/pinpoint/CHANGELOG.md#v1226-2023-09-26)
  * **Documentation**: Update documentation for RemoveAttributes to more accurately reflect its behavior when attributes are deleted.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.40.0](service/s3/CHANGELOG.md#v1400-2023-09-26)
  * **Feature**: This release adds a new field COMPLETED to the ReplicationStatus Enum. You can now use this field to validate the replication status of S3 objects using the AWS SDK.

# Release (2023-09-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.13.0](service/amplifyuibuilder/CHANGELOG.md#v1130-2023-09-25)
  * **Feature**: Support for generating code that is compatible with future versions of amplify project dependencies.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.9.0](service/chimesdkmediapipelines/CHANGELOG.md#v190-2023-09-25)
  * **Feature**: Adds support for sending WebRTC audio to Amazon Kineses Video Streams.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.11.0](service/emrserverless/CHANGELOG.md#v1110-2023-09-25)
  * **Feature**: This release adds support for application-wide default job configurations.
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.17.0](service/finspacedata/CHANGELOG.md#v1170-2023-09-25)
  * **Feature**: Adding sensitive trait to attributes. Change max SessionDuration from 720 to 60. Correct "ApiAccess" attribute to "apiAccess" to maintain consistency between APIs.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.44.0](service/quicksight/CHANGELOG.md#v1440-2023-09-25)
  * **Feature**: Added ability to tag users upon creation.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.38.0](service/ssm/CHANGELOG.md#v1380-2023-09-25)
  * **Feature**: This release updates the enum values for ResourceType in SSM DescribeInstanceInformation input and ConnectionStatus in GetConnectionStatus output.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.39.0](service/wafv2/CHANGELOG.md#v1390-2023-09-25)
  * **Feature**: You can now perform an exact match against the web request's JA3 fingerprint.

# Release (2023-09-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.18.42](config/CHANGELOG.md#v11842-2023-09-22)
  * **Bug Fix**: Fixed a bug where merging `max_attempts` or `duration_seconds` fields across shared config files with invalid values would silently default them to 0.
  * **Bug Fix**: Move type assertion of config values out of the parsing stage, which resolves an issue where the contents of a profile would silently be dropped with certain numeric formats.
* `github.com/aws/aws-sdk-go-v2/internal/ini`: [v1.3.43](internal/ini/CHANGELOG.md#v1343-2023-09-22)
  * **Bug Fix**: Fixed a bug where merging `max_attempts` or `duration_seconds` fields across shared config files with invalid values would silently default them to 0.
  * **Bug Fix**: Move type assertion of config values out of the parsing stage, which resolves an issue where the contents of a profile would silently be dropped with certain numeric formats.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.20.0](service/braket/CHANGELOG.md#v1200-2023-09-22)
  * **Feature**: This release adds support to view the device queue depth (the number of queued quantum tasks and hybrid jobs on a device) and queue position for a quantum task and hybrid job.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.18.0](service/cloudwatchevents/CHANGELOG.md#v1180-2023-09-22)
  * **Feature**: Adds sensitive trait to various shapes in Jetstream Connections API model.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.31.0](service/databasemigrationservice/CHANGELOG.md#v1310-2023-09-22)
  * **Feature**: new vendors for DMS CSF: MongoDB, MariaDB, DocumentDb and Redshift
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.120.0](service/ec2/CHANGELOG.md#v11200-2023-09-22)
  * **Feature**: EC2 M2 Pro Mac instances are powered by Apple M2 Pro Mac Mini computers featuring 12 core CPU, 19 core GPU, 32 GiB of memory, and 16 core Apple Neural Engine and uniquely enabled by the AWS Nitro System through high-speed Thunderbolt connections.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.21.7](service/efs/CHANGELOG.md#v1217-2023-09-22)
  * **Documentation**: Documentation updates for Elastic File System
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.28.0](service/guardduty/CHANGELOG.md#v1280-2023-09-22)
  * **Feature**: Add `EKS_CLUSTER_NAME` to filter and sort key.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.42.0](service/mediaconvert/CHANGELOG.md#v1420-2023-09-22)
  * **Feature**: This release supports the creation of of audio-only tracks in CMAF output groups.

# Release (2023-09-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.20.0](service/appconfig/CHANGELOG.md#v1200-2023-09-20)
  * **Feature**: Enabling boto3 paginators for list APIs and adding documentation around ServiceQuotaExceededException errors
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.20.0](service/apprunner/CHANGELOG.md#v1200-2023-09-20)
  * **Feature**: This release adds improvements for managing App Runner auto scaling configuration resources. New APIs: UpdateDefaultAutoScalingConfiguration and ListServicesForAutoScalingConfiguration. Updated API: DeleteAutoScalingConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.24.0](service/cloudwatchlogs/CHANGELOG.md#v1240-2023-09-20)
  * **Feature**: Add ClientToken to QueryDefinition CFN Handler in CWL
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.20.0](service/codeartifact/CHANGELOG.md#v1200-2023-09-20)
  * **Feature**: Add support for the Swift package format.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.18.4](service/kinesisvideo/CHANGELOG.md#v1184-2023-09-20)
  * **Documentation**: Updated DescribeMediaStorageConfiguration, StartEdgeConfigurationUpdate, ImageGenerationConfiguration$SamplingInterval, and UpdateMediaStorageConfiguration to match AWS Docs.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.39.0](service/s3/CHANGELOG.md#v1390-2023-09-20)
  * **Feature**: Fix an issue where the SDK can fail to unmarshall response due to NumberFormatException
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.24.0](service/servicediscovery/CHANGELOG.md#v1240-2023-09-20)
  * **Feature**: Adds a new DiscoverInstancesRevision API and also adds InstanceRevision field to the DiscoverInstances API response.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.17.0](service/ssooidc/CHANGELOG.md#v1170-2023-09-20)
  * **Feature**: Update FIPS endpoints in aws-us-gov.

# Release (2023-09-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.119.0](service/ec2/CHANGELOG.md#v11190-2023-09-19)
  * **Feature**: This release adds support for C7i, and R7a instance types.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.30.0](service/outposts/CHANGELOG.md#v1300-2023-09-19)
  * **Feature**: This release adds the InstanceFamilies field to the ListAssets response.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.107.0](service/sagemaker/CHANGELOG.md#v11070-2023-09-19)
  * **Feature**: This release adds support for one-time model monitoring schedules that are executed immediately without delay, explicit data analysis windows for model monitoring schedules and exclude features attributes to remove features from model monitor analysis.

# Release (2023-09-18)

## General Highlights
* **Feature**: Adds several endpoint ruleset changes across all models: smaller rulesets, removed non-unique regional endpoints, fixes FIPS and DualStack endpoints, and make region not required in SDK::Endpoint. Additional breakfix to cognito-sync field.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.21.0](service/accessanalyzer/CHANGELOG.md#v1210-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.19.0](service/acm/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.15.0](service/amplify/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/apigatewaymanagementapi`: [v1.13.0](service/apigatewaymanagementapi/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.19.0](service/appconfig/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.8.0](service/appconfigdata/CHANGELOG.md#v180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appfabric`: [v1.2.0](service/appfabric/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.17.0](service/appintegrations/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler`: [v1.12.0](service/applicationcostprofiler/CHANGELOG.md#v1120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.19.0](service/appmesh/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.3.0](service/arczonalshift/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/autoscalingplans`: [v1.15.0](service/autoscalingplans/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.11.0](service/backupgateway/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/backupstorage`: [v1.3.0](service/backupstorage/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.19.0](service/braket/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.9.0](service/chimesdkvoice/CHANGELOG.md#v190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.15.0](service/clouddirectory/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.16.0](service/cloudhsmv2/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudsearch`: [v1.16.0](service/cloudsearch/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudsearchdomain`: [v1.14.0](service/cloudsearchdomain/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cloudtraildata`: [v1.2.0](service/cloudtraildata/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.22.0](service/codebuild/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.18.0](service/codedeploy/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codeguruprofiler`: [v1.15.0](service/codeguruprofiler/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codegurureviewer`: [v1.19.0](service/codegurureviewer/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.2.0](service/codegurusecurity/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codestar`: [v1.15.0](service/codestar/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/codestarnotifications`: [v1.16.0](service/codestarnotifications/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.17.0](service/cognitoidentity/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/cognitosync`: [v1.14.0](service/cognitosync/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.7.0](service/connectcases/CHANGELOG.md#v170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.15.0](service/connectcontactlens/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.3.0](service/controltower/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/databrew`: [v1.23.0](service/databrew/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.21.0](service/dataexchange/CHANGELOG.md#v1210-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/datapipeline`: [v1.16.0](service/datapipeline/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.14.0](service/dax/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.17.0](service/devicefarm/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.3.0](service/docdbelastic/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.17.0](service/ec2instanceconnect/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.18.0](service/ecrpublic/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.17.0](service/elasticbeanstalk/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing`: [v1.17.0](service/elasticloadbalancing/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.16.0](service/elastictranscoder/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.13.0](service/evidently/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.16.0](service/finspacedata/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.16.0](service/fis/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.27.0](service/forecast/CHANGELOG.md#v1270-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/forecastquery`: [v1.15.0](service/forecastquery/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/gamesparks`: [v1.4.0](service/gamesparks/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/glacier`: [v1.16.0](service/glacier/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/greengrass`: [v1.17.0](service/greengrass/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.24.0](service/greengrassv2/CHANGELOG.md#v1240-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/honeycode`: [v1.15.0](service/honeycode/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/inspector`: [v1.15.0](service/inspector/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickdevicesservice`: [v1.13.0](service/iot1clickdevicesservice/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickprojects`: [v1.14.0](service/iot1clickprojects/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotanalytics`: [v1.16.0](service/iotanalytics/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.17.0](service/iotevents/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ioteventsdata`: [v1.15.0](service/ioteventsdata/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.15.0](service/iotfleethub/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.14.0](service/iotjobsdataplane/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotroborunner`: [v1.3.0](service/iotroborunner/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.17.0](service/iotsecuretunneling/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/iotthingsgraph`: [v1.16.0](service/iotthingsgraph/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.6.0](service/ivschat/CHANGELOG.md#v160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kendraranking`: [v1.2.0](service/kendraranking/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.19.0](service/kinesis/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalytics`: [v1.16.0](service/kinesisanalytics/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.17.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia`: [v1.13.0](service/kinesisvideomedia/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideosignaling`: [v1.13.0](service/kinesisvideosignaling/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.4.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice`: [v1.19.0](service/lexmodelbuildingservice/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimeservice`: [v1.15.0](service/lexruntimeservice/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.19.0](service/lexruntimev2/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.20.0](service/licensemanager/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.3.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.4.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lookoutmetrics`: [v1.21.0](service/lookoutmetrics/CHANGELOG.md#v1210-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.17.0](service/lookoutvision/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.17.0](service/machinelearning/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/macie`: [v1.17.0](service/macie/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.29.7](service/macie2/CHANGELOG.md#v1297-2023-09-18)
  * **Documentation**: This release changes the default managedDataIdentifierSelector setting for new classification jobs to RECOMMENDED. By default, new classification jobs now use the recommended set of managed data identifiers.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.14.0](service/marketplacecommerceanalytics/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.14.0](service/marketplaceentitlementservice/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.16.0](service/marketplacemetering/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.2.0](service/mediapackagev2/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.24.0](service/mediapackagevod/CHANGELOG.md#v1240-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediastore`: [v1.15.0](service/mediastore/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mediastoredata`: [v1.15.0](service/mediastoredata/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.2.0](service/medicalimaging/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.15.0](service/migrationhub/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.15.0](service/migrationhubconfig/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.3.0](service/migrationhuborchestrator/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.11.0](service/migrationhubstrategy/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mobile`: [v1.14.0](service/mobile/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/mturk`: [v1.16.0](service/mturk/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.22.0](service/neptune/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.19.0](service/networkmanager/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.18.0](service/nimble/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.3.0](service/oam/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.5.0](service/opensearchserverless/CHANGELOG.md#v150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.16.0](service/opsworks/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.17.0](service/opsworkscm/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.2.0](service/osis/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.13.0](service/panorama/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.2.0](service/paymentcryptography/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.15.0](service/personalizeevents/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.15.0](service/personalizeruntime/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pinpointemail`: [v1.14.0](service/pinpointemail/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice`: [v1.13.0](service/pinpointsmsvoice/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.3.0](service/pinpointsmsvoicev2/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.4.0](service/pipes/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/qldbsession`: [v1.16.0](service/qldbsession/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.10.0](service/rbin/CHANGELOG.md#v1100-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.15.0](service/rdsdata/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.6.0](service/redshiftserverless/CHANGELOG.md#v160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.4.0](service/resourceexplorer2/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.16.0](service/resourcegroups/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi`: [v1.16.0](service/resourcegroupstaggingapi/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.20.0](service/robomaker/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.13.0](service/route53recoverycluster/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.13.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness`: [v1.11.0](service/route53recoveryreadiness/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.20.0](service/route53resolver/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.12.0](service/rum/CHANGELOG.md#v1120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.18.0](service/s3outposts/CHANGELOG.md#v1180-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime`: [v1.17.0](service/sagemakera2iruntime/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakeredge`: [v1.15.0](service/sagemakeredge/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.5.0](service/sagemakergeospatial/CHANGELOG.md#v150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.2.0](service/sagemakermetrics/CHANGELOG.md#v120-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.3.0](service/scheduler/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/schemas`: [v1.17.0](service/schemas/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/serverlessapplicationrepository`: [v1.14.0](service/serverlessapplicationrepository/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.19.0](service/servicecatalogappregistry/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.23.0](service/servicediscovery/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.20.0](service/shield/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.15.0](service/sms/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/snowdevicemanagement`: [v1.11.0](service/snowdevicemanagement/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.22.0](service/sns/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.17.0](service/ssmcontacts/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.23.0](service/ssmincidents/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.5.0](service/ssmsap/CHANGELOG.md#v150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.14.0](service/sso/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.16.0](service/ssooidc/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.20.0](service/storagegateway/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.22.0](service/sts/CHANGELOG.md#v1220-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/supportapp`: [v1.4.0](service/supportapp/CHANGELOG.md#v140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.19.0](service/synthetics/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.23.0](service/textract/CHANGELOG.md#v1230-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.17.0](service/timestreamquery/CHANGELOG.md#v1170-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.19.0](service/timestreamwrite/CHANGELOG.md#v1190-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.3.0](service/tnb/CHANGELOG.md#v130-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.11.0](service/transcribestreaming/CHANGELOG.md#v1110-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.15.0](service/voiceid/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.14.0](service/waf/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/wafregional`: [v1.15.0](service/wafregional/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.16.0](service/workdocs/CHANGELOG.md#v1160-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/worklink`: [v1.15.0](service/worklink/CHANGELOG.md#v1150-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.20.0](service/workmail/CHANGELOG.md#v1200-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.
  * **Feature**: This release includes four new APIs UpdateUser, UpdateGroup, ListGroupsForEntity and DescribeEntity, along with RemoteUsers and some enhancements to existing APIs.
* `github.com/aws/aws-sdk-go-v2/service/workmailmessageflow`: [v1.14.0](service/workmailmessageflow/CHANGELOG.md#v1140-2023-09-18)
  * **Announcement**: [BREAKFIX] Change in MaxResults datatype from value to pointer type in cognito-sync service.

# Release (2023-09-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.24.0](service/appstream/CHANGELOG.md#v1240-2023-09-15)
  * **Feature**: This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.67.0](service/connect/CHANGELOG.md#v1670-2023-09-15)
  * **Feature**: New rule type (OnMetricDataUpdate) has been added
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.29.1](service/datasync/CHANGELOG.md#v1291-2023-09-15)
  * **Documentation**: Documentation-only updates for AWS DataSync.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.106.0](service/sagemaker/CHANGELOG.md#v11060-2023-09-15)
  * **Feature**: This release introduces Skip Model Validation for Model Packages

# Release (2023-09-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.23.0](service/appstream/CHANGELOG.md#v1230-2023-09-14)
  * **Feature**: This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.34.6](service/cloudformation/CHANGELOG.md#v1346-2023-09-14)
  * **Documentation**: Documentation updates for AWS CloudFormation
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.2.0](service/entityresolution/CHANGELOG.md#v120-2023-09-14)
  * **Feature**: Changed "ResolutionTechniques" and "MappedInputFields" in workflow and schema mapping operations to be required fields.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.19.0](service/lookoutequipment/CHANGELOG.md#v1190-2023-09-14)
  * **Feature**: This release adds APIs for the new scheduled retraining feature.

# Release (2023-09-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.8](service/cloud9/CHANGELOG.md#v1188-2023-09-13)
  * **Documentation**: Update to include information on Ubuntu 18 deprecation.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.16.0](service/drs/CHANGELOG.md#v1160-2023-09-13)
  * **Feature**: Updated existing APIs and added new ones to support using AWS Elastic Disaster Recovery post-launch actions. Added support for new regions.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.18.0](service/firehose/CHANGELOG.md#v1180-2023-09-13)
  * **Feature**: DocumentIdOptions has been added for the Amazon OpenSearch destination.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.27.0](service/guardduty/CHANGELOG.md#v1270-2023-09-13)
  * **Feature**: Add `managementType` field to ListCoverage API response.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.6.0](service/internetmonitor/CHANGELOG.md#v160-2023-09-13)
  * **Feature**: This release updates the Amazon CloudWatch Internet Monitor API domain name.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.4.4](service/ivsrealtime/CHANGELOG.md#v144-2023-09-13)
  * **Documentation**: Doc only update that changes description for ParticipantToken.
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.5.1](service/simspaceweaver/CHANGELOG.md#v151-2023-09-13)
  * **Documentation**: Edited the introductory text for the API reference.
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.18.0](service/xray/CHANGELOG.md#v1180-2023-09-13)
  * **Feature**: Add StartTime field in GetTraceSummaries API response for each TraceSummary.

# Release (2023-09-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.118.0](service/ec2/CHANGELOG.md#v11180-2023-09-12)
  * **Feature**: This release adds support for restricting public sharing of AMIs through AMI Block Public Access
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.22.0](service/eventbridge/CHANGELOG.md#v1220-2023-09-12)
  * **Feature**: Adds sensitive trait to various shapes in Jetstream Connections API model.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.43.0](service/kendra/CHANGELOG.md#v1430-2023-09-12)
  * **Feature**: Amazon Kendra now supports confidence score buckets for retrieved passage results using the Retrieve API.

# Release (2023-09-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.20.0](service/ecr/CHANGELOG.md#v1200-2023-09-11)
  * **Feature**: This release will have ValidationException be thrown from ECR LifecyclePolicy APIs in regions LifecyclePolicy is not supported, this includes existing Amazon Dedicated Cloud (ADC) regions. This release will also change Tag: TagValue and Tag: TagKey to required.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.37.0](service/medialive/CHANGELOG.md#v1370-2023-09-11)
  * **Feature**: AWS Elemental Link now supports attaching a Link UHD device to a MediaConnect flow.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.43.0](service/quicksight/CHANGELOG.md#v1430-2023-09-11)
  * **Feature**: This release launches new updates to QuickSight KPI visuals - support for sparklines, new templated layout and new targets for conditional formatting rules.

# Release (2023-09-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.32.6](service/fsx/CHANGELOG.md#v1326-2023-09-08)
  * **Documentation**: Amazon FSx documentation fixes
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.105.0](service/sagemaker/CHANGELOG.md#v11050-2023-09-08)
  * **Feature**: Autopilot APIs will now support holiday featurization for Timeseries models. The models will now hold holiday metadata and should be able to accommodate holiday effect during inference.
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.18.0](service/ssoadmin/CHANGELOG.md#v1180-2023-09-08)
  * **Feature**: Content updates to IAM Identity Center API for China Regions.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.30.0](service/workspaces/CHANGELOG.md#v1300-2023-09-08)
  * **Feature**: A new field "ErrorDetails" will be added to the output of "DescribeWorkspaceImages" API call. This field provides in-depth details about the error occurred during image import process. These details include the possible causes of the errors and troubleshooting information.

# Release (2023-09-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.36.2](service/securityhub/CHANGELOG.md#v1362-2023-09-07)
  * **Documentation**: Documentation updates for AWS Security Hub
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.5.0](service/simspaceweaver/CHANGELOG.md#v150-2023-09-07)
  * **Feature**: BucketName and ObjectKey are now required for the S3Location data type. BucketName is now required for the S3Destination data type.

# Release (2023-09-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.35.0](service/appflow/CHANGELOG.md#v1350-2023-09-06)
  * **Feature**: Adding OAuth2.0 support for servicenow connector.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.117.0](service/ec2/CHANGELOG.md#v11170-2023-09-06)
  * **Feature**: This release adds 'outpost' location type to the DescribeInstanceTypeOfferings API, allowing customers that have been allowlisted for outpost to query their offerings in the API.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.21.4](service/elasticloadbalancingv2/CHANGELOG.md#v1214-2023-09-06)
  * **Documentation**: This release enables default UDP connection termination and disabling unhealthy target connection termination for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.36.0](service/medialive/CHANGELOG.md#v1360-2023-09-06)
  * **Feature**: Adds advanced Output Locking options for Epoch Locking: Custom Epoch and Jam Sync Time
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.38.0](service/wafv2/CHANGELOG.md#v1380-2023-09-06)
  * **Feature**: The targeted protection level of the Bot Control managed rule group now provides optional, machine-learning analysis of traffic statistics to detect some bot-related activity. You can enable or disable the machine learning functionality through the API.

# Release (2023-09-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.9.0](service/billingconductor/CHANGELOG.md#v190-2023-09-05)
  * **Feature**: This release adds support for line item filtering in for the custom line item resource.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.7](service/cloud9/CHANGELOG.md#v1187-2023-09-05)
  * **Documentation**: Added support for Ubuntu 22.04 that was not picked up in a previous Trebuchet request. Doc-only update.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.27.0](service/computeoptimizer/CHANGELOG.md#v1270-2023-09-05)
  * **Feature**: This release adds support to provide recommendations for G4dn and P3 instances that use NVIDIA GPUs.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.116.0](service/ec2/CHANGELOG.md#v11160-2023-09-05)
  * **Feature**: Introducing Amazon EC2 C7gd, M7gd, and R7gd Instances with up to 3.8 TB of local NVMe-based SSD block-level storage. These instances are powered by AWS Graviton3 processors, delivering up to 25% better performance over Graviton2-based instances.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.30.1](service/ecs/CHANGELOG.md#v1301-2023-09-05)
  * **Documentation**: Documentation only update for Amazon ECS.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.21.0](service/eventbridge/CHANGELOG.md#v1210-2023-09-05)
  * **Feature**: Improve Endpoint Ruleset test coverage.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.54.0](service/rds/CHANGELOG.md#v1540-2023-09-05)
  * **Feature**: Add support for feature integration with AWS Backup.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.104.0](service/sagemaker/CHANGELOG.md#v11040-2023-09-05)
  * **Feature**: SageMaker Neo now supports data input shape derivation for Pytorch 2.0  and XGBoost compilation job for cloud instance targets. You can skip DataInputConfig field during compilation job creation. You can also access derived information from model in DescribeCompilationJob response.
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.2.0](service/vpclattice/CHANGELOG.md#v120-2023-09-05)
  * **Feature**: This release adds Lambda event structure version config support for LAMBDA target groups. It also adds newline support for auth policies.

# Release (2023-09-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.8.0](service/chimesdkmediapipelines/CHANGELOG.md#v180-2023-09-01)
  * **Feature**: This release adds support for the Voice Analytics feature for customer-owned KVS streams as part of the Amazon Chime SDK call analytics.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.66.0](service/connect/CHANGELOG.md#v1660-2023-09-01)
  * **Feature**: Amazon Connect adds the ability to read, create, update, delete, and list view resources, and adds the ability to read, create, delete, and list view versions.
* `github.com/aws/aws-sdk-go-v2/service/identitystore`: [v1.18.0](service/identitystore/CHANGELOG.md#v1180-2023-09-01)
  * **Feature**: New Identity Store content for China Region launch
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.0.1](service/neptunedata/CHANGELOG.md#v101-2023-09-01)
  * **Documentation**: Removed the descriptive text in the introduction.

# Release (2023-08-31)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.7.0](service/chimesdkmediapipelines/CHANGELOG.md#v170-2023-08-31)
  * **Feature**: This release adds support for feature Voice Enhancement for Call Recording as part of Amazon Chime SDK call analytics.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsm`: [v1.15.0](service/cloudhsm/CHANGELOG.md#v1150-2023-08-31)
  * **Feature**: Deprecating CloudHSM Classic API Service.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.17.0](service/cloudwatchevents/CHANGELOG.md#v1170-2023-08-31)
  * **Feature**: Documentation updates for CloudWatch Events.
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.4.0](service/connectcampaigns/CHANGELOG.md#v140-2023-08-31)
  * **Feature**: Amazon Connect outbound campaigns has launched agentless dialing mode which enables customers to make automated outbound calls without agent engagement. This release updates three of the campaign management API's to support the new agentless dialing mode and the new dialing capacity field.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.17.0](service/connectparticipant/CHANGELOG.md#v1170-2023-08-31)
  * **Feature**: Amazon Connect Participant Service adds the ability to get a view resource using a view token, which is provided in a participant message, with the release of the DescribeView API.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.28.0](service/customerprofiles/CHANGELOG.md#v1280-2023-08-31)
  * **Feature**: Adds sensitive trait to various shapes in Customer Profiles API model.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.30.0](service/ecs/CHANGELOG.md#v1300-2023-08-31)
  * **Feature**: This release adds support for an account-level setting that you can use to configure the number of days for AWS Fargate task retirement.
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.19.0](service/health/CHANGELOG.md#v1190-2023-08-31)
  * **Feature**: Adds new API DescribeEntityAggregatesForOrganization that retrieves entity aggregates across your organization. Also adds support for resource status filtering in DescribeAffectedEntitiesForOrganization, resource status aggregates in the DescribeEntityAggregates response, and new resource statuses.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.26.0](service/ivs/CHANGELOG.md#v1260-2023-08-31)
  * **Feature**: Updated "type" description for CreateChannel, UpdateChannel, Channel, and ChannelSummary.
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.11.0](service/kafkaconnect/CHANGELOG.md#v1110-2023-08-31)
  * **Feature**: Minor model changes for Kafka Connect as well as endpoint updates.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.2.0](service/paymentcryptographydata/CHANGELOG.md#v120-2023-08-31)
  * **Feature**: Make KeyCheckValue field optional when using asymmetric keys as Key Check Values typically only apply to symmetric keys
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.21.0](service/sagemakerruntime/CHANGELOG.md#v1210-2023-08-31)
  * **Feature**: This release adds a new InvokeEndpointWithResponseStream API to support streaming of model responses.

# Release (2023-08-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.34.0](service/appflow/CHANGELOG.md#v1340-2023-08-30)
  * **Feature**: Add SAP source connector parallel and pagination feature
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.19.0](service/apprunner/CHANGELOG.md#v1190-2023-08-30)
  * **Feature**: App Runner adds support for Bitbucket. You can now create App Runner connection that connects to your Bitbucket repositories and deploy App Runner service with the source code stored in a Bitbucket repository.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.4.0](service/cleanrooms/CHANGELOG.md#v140-2023-08-30)
  * **Feature**: This release decouples member abilities in a collaboration. With this change, the member who can run queries no longer needs to be the same as the member who can receive results.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.29.0](service/datasync/CHANGELOG.md#v1290-2023-08-30)
  * **Feature**: AWS DataSync introduces Task Reports, a new feature that provides detailed reports of data transfer operations for each task execution.
* `github.com/aws/aws-sdk-go-v2/service/neptunedata`: [v1.0.0](service/neptunedata/CHANGELOG.md#v100-2023-08-30)
  * **Release**: New AWS service client module
  * **Feature**: Allows customers to execute data plane actions like bulk loading graphs, issuing graph queries using Gremlin and openCypher directly from the SDK.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.30.0](service/networkfirewall/CHANGELOG.md#v1300-2023-08-30)
  * **Feature**: Network Firewall increasing pagination token string length
* `github.com/aws/aws-sdk-go-v2/service/pcaconnectorad`: [v1.0.0](service/pcaconnectorad/CHANGELOG.md#v100-2023-08-30)
  * **Release**: New AWS service client module
  * **Feature**: The Connector for AD allows you to use a fully-managed AWS Private CA as a drop-in replacement for your self-managed enterprise CAs without local agents or proxy servers. Enterprises that use AD to manage Windows environments can reduce their private certificate authority (CA) costs and complexity.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.103.0](service/sagemaker/CHANGELOG.md#v11030-2023-08-30)
  * **Feature**: Amazon SageMaker Canvas adds IdentityProviderOAuthSettings support for CanvasAppSettings

# Release (2023-08-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.26.0](service/cognitoidentityprovider/CHANGELOG.md#v1260-2023-08-29)
  * **Feature**: Added API example requests and responses for several operations. Fixed the validation regex for user pools Identity Provider name.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.32.5](service/fsx/CHANGELOG.md#v1325-2023-08-29)
  * **Documentation**: Documentation updates for project quotas.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.9.0](service/omics/CHANGELOG.md#v190-2023-08-29)
  * **Feature**: Add RetentionMode support for Runs.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.20.0](service/sesv2/CHANGELOG.md#v1200-2023-08-29)
  * **Feature**: Adds support for the new Export and Message Insights features: create, get, list and cancel export jobs; get message insights.

# Release (2023-08-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.25.0](service/backup/CHANGELOG.md#v1250-2023-08-28)
  * **Feature**: Add support for customizing time zone for backup window in backup plan rules.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.26.0](service/computeoptimizer/CHANGELOG.md#v1260-2023-08-28)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate licensing optimization recommendations for sql server running on EC2 instances.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.20.6](service/organizations/CHANGELOG.md#v1206-2023-08-28)
  * **Documentation**: Documentation updates for permissions and links.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.7.0](service/securitylake/CHANGELOG.md#v170-2023-08-28)
  * **Feature**: Remove incorrect regex enforcement on pagination tokens.
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.16.0](service/servicequotas/CHANGELOG.md#v1160-2023-08-28)
  * **Feature**: Service Quotas now supports viewing the applied quota value and requesting a quota increase for a specific resource in an AWS account.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.12.0](service/workspacesweb/CHANGELOG.md#v1120-2023-08-28)
  * **Feature**: WorkSpaces Web now enables Admins to configure which cookies are synchronized from an end-user's local browser to the in-session browser. In conjunction with a browser extension, this feature enables enhanced Single-Sign On capability by reducing the number of times an end-user has to authenticate.

# Release (2023-08-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.29.0](service/cloudtrail/CHANGELOG.md#v1290-2023-08-25)
  * **Feature**: Add ThrottlingException with error code 429 to handle CloudTrail Delegated Admin request rate exceeded on organization resources.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.27.7](service/cloudwatch/CHANGELOG.md#v1277-2023-08-25)
  * **Documentation**: Doc-only update to get doc bug fixes into the SDK docs

# Release (2023-08-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.115.0](service/ec2/CHANGELOG.md#v11150-2023-08-24)
  * **Feature**: Amazon EC2 M7a instances, powered by 4th generation AMD EPYC processors, deliver up to 50% higher performance compared to M6a instances. Amazon EC2 Hpc7a instances, powered by 4th Gen AMD EPYC processors, deliver up to 2.5x better performance compared to Amazon EC2 Hpc6a instances.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.62.0](service/glue/CHANGELOG.md#v1620-2023-08-24)
  * **Feature**: Added API attributes that help in the monitoring of sessions.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.41.0](service/mediaconvert/CHANGELOG.md#v1410-2023-08-24)
  * **Feature**: This release includes additional audio channel tags in Quicktime outputs, support for film grain synthesis for AV1 outputs, ability to create audio-only FLAC outputs, and ability to specify Amazon S3 destination storage class.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.35.0](service/medialive/CHANGELOG.md#v1350-2023-08-24)
  * **Feature**: MediaLive now supports passthrough of KLV data to a HLS output group with a TS container. MediaLive now supports setting an attenuation mode for AC3 audio when the coding mode is 3/2 LFE. MediaLive now supports specifying whether to include filler NAL units in RTMP output group settings.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.27.0](service/mediatailor/CHANGELOG.md#v1270-2023-08-24)
  * **Feature**: Adds new source location AUTODETECT_SIGV4 access type.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.42.0](service/quicksight/CHANGELOG.md#v1420-2023-08-24)
  * **Feature**: Excel support in Snapshot Export APIs. Removed Required trait for some insight Computations. Namespace-shared Folders support. Global Filters support. Table pin Column support.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.53.0](service/rds/CHANGELOG.md#v1530-2023-08-24)
  * **Feature**: This release updates the supported versions for Percona XtraBackup in Aurora MySQL.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.33.0](service/s3control/CHANGELOG.md#v1330-2023-08-24)
  * **Feature**: Updates to endpoint ruleset tests to address Smithy validation issues and standardize the capitalization of DualStack.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.2.1](service/verifiedpermissions/CHANGELOG.md#v121-2023-08-24)
  * **Documentation**: Documentation updates for Amazon Verified Permissions.

# Release (2023-08-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.18.0](service/apigateway/CHANGELOG.md#v1180-2023-08-23)
  * **Feature**: This release adds RootResourceId to GetRestApi response.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.31.0](service/polly/CHANGELOG.md#v1310-2023-08-23)
  * **Feature**: Amazon Polly adds 1 new voice - Zayd (ar-AE)

# Release (2023-08-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.28.0](service/costexplorer/CHANGELOG.md#v1280-2023-08-22)
  * **Feature**: This release adds the LastUpdatedDate and LastUsedDate timestamps to help you manage your cost allocation tags.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.17.7](service/globalaccelerator/CHANGELOG.md#v1177-2023-08-22)
  * **Documentation**: Global Accelerator now supports Client Ip Preservation for Network Load Balancer endpoints.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.52.0](service/rds/CHANGELOG.md#v1520-2023-08-22)
  * **Feature**: Adding parameters to CreateCustomDbEngineVersion reserved for future use.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.2.0](service/verifiedpermissions/CHANGELOG.md#v120-2023-08-22)
  * **Feature**: Documentation updates for Amazon Verified Permissions. Increases max results per page for ListPolicyStores, ListPolicies, and ListPolicyTemplates APIs from 20 to 50.

# Release (2023-08-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.21.0
  * **Feature**: Add support for polly SynthesizeSpeech GET request presigner
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.6](service/cloud9/CHANGELOG.md#v1186-2023-08-21)
  * **Documentation**: Doc only update to add Ubuntu 22.04 as an Image ID option for Cloud9
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.114.0](service/ec2/CHANGELOG.md#v11140-2023-08-21)
  * **Feature**: The DeleteKeyPair API has been updated to return the keyPairId when an existing key pair is deleted.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.12.0](service/finspace/CHANGELOG.md#v1120-2023-08-21)
  * **Feature**: Allow customers to manage outbound traffic from their Kx Environment when attaching a transit gateway by providing network acl entries. Allow the customer to choose how they want to update the databases on a cluster allowing updates to possibly be faster than usual.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.30.0](service/polly/CHANGELOG.md#v1300-2023-08-21)
  * **Feature**: Add support for polly SynthesizeSpeech GET request presigner
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.51.0](service/rds/CHANGELOG.md#v1510-2023-08-21)
  * **Feature**: Adding support for RDS Aurora Global Database Unplanned Failover
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.17.3](service/route53domains/CHANGELOG.md#v1173-2023-08-21)
  * **Documentation**: Fixed typos in description fields

# Release (2023-08-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.16.0](service/codecommit/CHANGELOG.md#v1160-2023-08-18)
  * **Feature**: Add new ListFileCommitHistory operation to retrieve commits which introduced changes to a specific file.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.36.0](service/securityhub/CHANGELOG.md#v1360-2023-08-18)
  * **Feature**: Added Inspector Lambda code Vulnerability section to ASFF, including GeneratorDetails, EpssScore, ExploitAvailable, and CodeVulnerabilities.

# Release (2023-08-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.20.2
  * **Bug Fix**: Sign `X-Amz-Server-Side-Encryption-Context` header to fix signing for PutObject requests that set `SSEKMSEncryptionContext`.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.113.0](service/ec2/CHANGELOG.md#v11130-2023-08-17)
  * **Feature**: Adds support for SubnetConfigurations to allow users to select their own IPv4 and IPv6 addresses for Interface VPC endpoints
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.22.0](service/gamelift/CHANGELOG.md#v1220-2023-08-17)
  * **Feature**: Amazon GameLift updates its instance types support.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.32.3](service/s3control/CHANGELOG.md#v1323-2023-08-17)
  * **Announcement**: BREAKFIX: corrected function spelling in environment config from GetS3DisableMultRegionAccessPoints to GetS3DisableMultiRegionAccessPoints
  * **Bug Fix**: Adds DisableMRAP option to config loader, and DisableMRAP client resolver to achieve parity with other S3 options in the config loader. Additionally, added breakfix to correct spelling.

# Release (2023-08-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.27.3](service/cloudwatch/CHANGELOG.md#v1273-2023-08-16)
  * **Documentation**: Doc-only update to incorporate several doc bug fixes

# Release (2023-08-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.17.0](service/chimesdkmeetings/CHANGELOG.md#v1170-2023-08-15)
  * **Feature**: Updated API documentation to include additional exceptions.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.112.0](service/ec2/CHANGELOG.md#v11120-2023-08-15)
  * **Feature**: Documentation updates for Elastic Compute Cloud (EC2).
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.61.0](service/glue/CHANGELOG.md#v1610-2023-08-15)
  * **Feature**: AWS Glue Crawlers can now accept SerDe overrides from a custom csv classifier. The two SerDe options are LazySimpleSerDe and OpenCSVSerDe. In case, the user wants crawler to do the selection, "None" can be selected for this purpose.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.19.0](service/pi/CHANGELOG.md#v1190-2023-08-15)
  * **Feature**: AWS Performance Insights for Amazon RDS is launching Performance Analysis On Demand, a new feature that allows you to analyze database performance metrics and find out the performance issues. You can now use SDK to create, list, get, delete, and manage tags of performance analysis reports.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.17.0](service/route53domains/CHANGELOG.md#v1170-2023-08-15)
  * **Feature**: Provide explanation if CheckDomainTransferability return false. Provide requestId if a request is already submitted.  Add sensitive protection for customer information
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.102.0](service/sagemaker/CHANGELOG.md#v11020-2023-08-15)
  * **Feature**: SageMaker Inference Recommender now provides SupportedResponseMIMETypes from DescribeInferenceRecommendationsJob response

# Release (2023-08-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.23.0](service/mediapackage/CHANGELOG.md#v1230-2023-08-14)
  * **Feature**: Fix SDK logging of certain fields.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.8.0](service/omics/CHANGELOG.md#v180-2023-08-14)
  * **Feature**: This release provides support for annotation store versioning and cross account sharing for Omics Analytics
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.33.4](service/transfer/CHANGELOG.md#v1334-2023-08-14)
  * **Documentation**: Documentation updates for AWS Transfer Family

# Release (2023-08-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifybackend`: [v1.16.0](service/amplifybackend/CHANGELOG.md#v1160-2023-08-11)
  * **Feature**: Adds sensitive trait to required input shapes.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.36.0](service/configservice/CHANGELOG.md#v1360-2023-08-11)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in July 2023.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.111.0](service/ec2/CHANGELOG.md#v11110-2023-08-11)
  * **Feature**: Amazon EC2 P5 instances, powered by the latest NVIDIA H100 Tensor Core GPUs, deliver the highest performance in EC2 for deep learning (DL) and HPC applications. M7i-flex and M7i instances are next-generation general purpose instances powered by custom 4th Generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.41.0](service/quicksight/CHANGELOG.md#v1410-2023-08-11)
  * **Feature**: New Authentication method for Account subscription - IAM Identity Center. Hierarchy layout support, default column width support and related style properties for pivot table visuals. Non-additive topic field aggregations for Topic API
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.16.3](service/ses/CHANGELOG.md#v1163-2023-08-11)
  * **Documentation**: Doc only updates to include: 1) Clarified which part of an email address where it's okay to have Punycode when it contains non-ASCII characters for the SendRawEmail action and other actions where this is applicable. 2) Updated S3Action description with new MB max bucket size from 30 to 40.
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.17.0](service/swf/CHANGELOG.md#v1170-2023-08-11)
  * **Feature**: This release adds new API parameters to override workflow task list for workflow executions.

# Release (2023-08-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.28.3](service/cloudtrail/CHANGELOG.md#v1283-2023-08-10)
  * **Documentation**: Documentation updates for CloudTrail.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.65.0](service/connect/CHANGELOG.md#v1650-2023-08-10)
  * **Feature**: This release adds APIs to provision agents that are global / available in multiple AWS regions and distribute them across these regions by percentage.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.21.0](service/elasticloadbalancingv2/CHANGELOG.md#v1210-2023-08-10)
  * **Feature**: This release enables configuring security groups for Network Load Balancers
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.7.0](service/omics/CHANGELOG.md#v170-2023-08-10)
  * **Feature**: This release adds instanceType to GetRunTask & ListRunTasks responses.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.21.0](service/secretsmanager/CHANGELOG.md#v1210-2023-08-10)
  * **Feature**: Add additional InvalidRequestException to list of possible exceptions for ListSecret.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.33.3](service/transfer/CHANGELOG.md#v1333-2023-08-10)
  * **Documentation**: Documentation updates for AW Transfer Family

# Release (2023-08-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.8.0](service/chimesdkvoice/CHANGELOG.md#v180-2023-08-09)
  * **Feature**: Updating CreatePhoneNumberOrder, UpdatePhoneNumber and BatchUpdatePhoneNumbers APIs, adding phone number name
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.32.0](service/fsx/CHANGELOG.md#v1320-2023-08-09)
  * **Feature**: For FSx for Lustre, add new data repository task type, RELEASE_DATA_FROM_FILESYSTEM, to release files that have been archived to S3. For FSx for Windows, enable support for configuring and updating SSD IOPS, and for updating storage type. For FSx for OpenZFS, add new deployment type, MULTI_AZ_1.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.17.3](service/globalaccelerator/CHANGELOG.md#v1173-2023-08-09)
  * **Documentation**: Documentation update for dualstack EC2 endpoint support
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.26.0](service/guardduty/CHANGELOG.md#v1260-2023-08-09)
  * **Feature**: Added autoEnable ALL to UpdateOrganizationConfiguration and DescribeOrganizationConfiguration APIs.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.101.0](service/sagemaker/CHANGELOG.md#v11010-2023-08-09)
  * **Feature**: This release adds support for cross account access for SageMaker Model Cards through AWS RAM.

# Release (2023-08-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.24.0](service/backup/CHANGELOG.md#v1240-2023-08-08)
  * **Feature**: This release introduces a new logically air-gapped vault (Preview) in AWS Backup that stores immutable backup copies, which are locked by default and isolated with encryption using AWS owned keys. Logically air-gapped vault (Preview) allows secure recovery of application data across accounts.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.29.0](service/elasticache/CHANGELOG.md#v1290-2023-08-08)
  * **Feature**: Added support for cluster mode in online migration and test migration API
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.21.0](service/servicecatalog/CHANGELOG.md#v1210-2023-08-08)
  * **Feature**: Introduce support for HashiCorp Terraform Cloud in Service Catalog by addying TERRAFORM_CLOUD product type in CreateProduct and CreateProvisioningArtifact API.

# Release (2023-08-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.21.0](service/detective/CHANGELOG.md#v1210-2023-08-07)
  * **Feature**: Updated the email validation regex to be in line with the TLD name specifications.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.4.0](service/ivsrealtime/CHANGELOG.md#v140-2023-08-07)
  * **Feature**: Add QUOTA_EXCEEDED and PUBLISHER_NOT_FOUND to EventErrorCode for stage health events.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.18.0](service/kinesisvideo/CHANGELOG.md#v1180-2023-08-07)
  * **Feature**: This release enables minimum of Images SamplingInterval to be as low as 200 milliseconds in Kinesis Video Stream Image feature.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.16.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1160-2023-08-07)
  * **Feature**: This release enables minimum of Images SamplingInterval to be as low as 200 milliseconds in Kinesis Video Stream Image feature.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.30.2](service/rekognition/CHANGELOG.md#v1302-2023-08-07)
  * **Documentation**: This release adds code snippets for Amazon Rekognition Custom Labels.

# Release (2023-08-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.22.2](service/acmpca/CHANGELOG.md#v1222-2023-08-04)
  * **Documentation**: Documentation correction for AWS Private CA
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.64.0](service/connect/CHANGELOG.md#v1640-2023-08-04)
  * **Feature**: Added a new API UpdateRoutingProfileAgentAvailabilityTimer to update agent availability timer of a routing profile.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.28.0](service/datasync/CHANGELOG.md#v1280-2023-08-04)
  * **Feature**: Display cloud storage used capacity at a cluster level.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.29.2](service/ecs/CHANGELOG.md#v1292-2023-08-04)
  * **Documentation**: This is a documentation update to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.100.0](service/sagemaker/CHANGELOG.md#v11000-2023-08-04)
  * **Feature**: Including DataCaptureConfig key in the Amazon Sagemaker Search's transform job object

# Release (2023-08-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.30.2](service/autoscaling/CHANGELOG.md#v1302-2023-08-03)
  * **Documentation**: Documentation changes related to Amazon EC2 Auto Scaling APIs.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.18.2](service/cloud9/CHANGELOG.md#v1182-2023-08-03)
  * **Documentation**: Updated the deprecation date for Amazon Linux. Doc only update.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.30.0](service/databasemigrationservice/CHANGELOG.md#v1300-2023-08-03)
  * **Feature**: The release makes public API for DMS Schema Conversion feature.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.110.0](service/ec2/CHANGELOG.md#v11100-2023-08-03)
  * **Feature**: This release adds new parameter isPrimaryIPv6 to  allow assigning an IPv6 address as a primary IPv6 address to a network interface which cannot be changed to give equivalent functionality available for network interfaces with primary IPv4 address.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.99.0](service/sagemaker/CHANGELOG.md#v1990-2023-08-03)
  * **Feature**: Amazon SageMaker now supports running training jobs on p5.48xlarge instance types.

# Release (2023-08-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.16.0](service/budgets/CHANGELOG.md#v1160-2023-08-02)
  * **Feature**: As part of CAE tagging integration we need to update our budget names regex filter to prevent customers from using "/action/" in their budget names.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.25.0](service/cognitoidentityprovider/CHANGELOG.md#v1250-2023-08-02)
  * **Feature**: New feature that logs Cognito user pool error messages to CloudWatch logs.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.60.0](service/glue/CHANGELOG.md#v1600-2023-08-02)
  * **Feature**: This release includes additional Glue Streaming KAKFA SASL property types.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.13.0](service/resiliencehub/CHANGELOG.md#v1130-2023-08-02)
  * **Feature**: Drift Detection capability added when applications policy has moved from a meet to breach state. Customers will be able to exclude operational recommendations and receive credit in their resilience score. Customers can now add ARH permissions to an existing or new role.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.98.0](service/sagemaker/CHANGELOG.md#v1980-2023-08-02)
  * **Feature**: SageMaker Inference Recommender introduces a new API GetScalingConfigurationRecommendation to recommend auto scaling policies based on completed Inference Recommender jobs.

# Release (2023-08-01)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.26.0](service/batch/CHANGELOG.md#v1260-2023-08-01)
  * **Feature**: This release adds support for price capacity optimized allocation strategy for Spot Instances.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.29.0](service/databasemigrationservice/CHANGELOG.md#v1290-2023-08-01)
  * **Feature**: Adding new API describe-engine-versions which provides information about the lifecycle of a replication instance's version.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.5.0](service/internetmonitor/CHANGELOG.md#v150-2023-08-01)
  * **Feature**: This release adds a new feature for Amazon CloudWatch Internet Monitor that enables customers to set custom thresholds, for performance and availability drops, for impact limited to a single city-network to trigger creation of a health event.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.34.0](service/medialive/CHANGELOG.md#v1340-2023-08-01)
  * **Feature**: AWS Elemental Link devices now report their Availability Zone. Link devices now support the ability to change their Availability Zone.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.29.0](service/polly/CHANGELOG.md#v1290-2023-08-01)
  * **Feature**: Amazon Polly adds new French Belgian voice - Isabelle. Isabelle is available as Neural voice only.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.50.0](service/rds/CHANGELOG.md#v1500-2023-08-01)
  * **Feature**: Added support for deleted clusters PiTR.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.97.0](service/sagemaker/CHANGELOG.md#v1970-2023-08-01)
  * **Feature**: Add Stairs TrafficPattern and FlatInvocations to RecommendationJobStoppingConditions

# Release (2023-07-31)

## General Highlights
* **Feature**: Adds support for smithy-modeled endpoint resolution. A new rules-based endpoint resolution will be added to the SDK which will supercede and deprecate existing endpoint resolution. Specifically, EndpointResolver will be deprecated while BaseEndpoint and EndpointResolverV2 will take its place. For more information, please see the Endpoints section in our Developer Guide.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.12.0](service/amplifyuibuilder/CHANGELOG.md#v1120-2023-07-31)
  * **Feature**: Amplify Studio releases GraphQL support for codegen job action.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.30.0](service/autoscaling/CHANGELOG.md#v1300-2023-07-31)
  * **Feature**: You can now configure an instance refresh to set its status to 'failed' when it detects that a specified CloudWatch alarm has gone into the ALARM state. You can also choose to roll back the instance refresh automatically when the alarm threshold is met.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.3.0](service/cleanrooms/CHANGELOG.md#v130-2023-07-31)
  * **Feature**: This release introduces custom SQL queries - an expanded set of SQL you can run. This release adds analysis templates, a new resource for storing pre-defined custom SQL queries ahead of time. This release also adds the Custom analysis rule, which lets you approve analysis templates for querying.
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.15.0](service/codestarconnections/CHANGELOG.md#v1150-2023-07-31)
  * **Feature**: New integration with the Gitlab provider type.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.15.0](service/drs/CHANGELOG.md#v1150-2023-07-31)
  * **Feature**: Add support for in-aws right sizing
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.16.0](service/inspector2/CHANGELOG.md#v1160-2023-07-31)
  * **Feature**: This release adds 1 new API: BatchGetFindingDetails to retrieve enhanced vulnerability intelligence details for findings.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.18.0](service/lookoutequipment/CHANGELOG.md#v1180-2023-07-31)
  * **Feature**: This release includes new import resource, model versioning and resource policy features.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.6.0](service/omics/CHANGELOG.md#v160-2023-07-31)
  * **Feature**: Add CreationType filter for ListReadSets
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.49.0](service/rds/CHANGELOG.md#v1490-2023-07-31)
  * **Feature**: This release adds support for Aurora MySQL local write forwarding, which allows for forwarding of write operations from reader DB instances to the writer DB instance.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.29.0](service/route53/CHANGELOG.md#v1290-2023-07-31)
  * **Feature**: Amazon Route 53 now supports the Israel (Tel Aviv) Region (il-central-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.2.0](service/scheduler/CHANGELOG.md#v120-2023-07-31)
  * **Feature**: This release introduces automatic deletion of schedules in EventBridge Scheduler. If configured, EventBridge Scheduler automatically deletes a schedule after the schedule has completed its last invocation.

# Release (2023-07-28.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.18.0](service/applicationinsights/CHANGELOG.md#v1180-2023-07-282)
  * **Feature**: This release enable customer to add/remove/update more than one workload for a component
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.33.0](service/cloudformation/CHANGELOG.md#v1330-2023-07-282)
  * **Feature**: This SDK release is for the feature launch of AWS CloudFormation RetainExceptOnCreate. It adds a new parameter retainExceptOnCreate in the following APIs: CreateStack, UpdateStack, RollbackStack, ExecuteChangeSet.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.27.0](service/cloudfront/CHANGELOG.md#v1270-2023-07-282)
  * **Feature**: Add a new JavaScript runtime version for CloudFront Functions.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.62.0](service/connect/CHANGELOG.md#v1620-2023-07-282)
  * **Feature**: This release adds support for new number types.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.21.0](service/kafka/CHANGELOG.md#v1210-2023-07-282)
  * **Feature**: Amazon MSK has introduced new versions of ListClusterOperations and DescribeClusterOperation APIs. These v2 APIs provide information and insights into the ongoing operations of both MSK Provisioned and MSK Serverless clusters.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.21.0](service/pinpoint/CHANGELOG.md#v1210-2023-07-282)
  * **Feature**: Added support for sending push notifications using the FCM v1 API with json credentials. Amazon Pinpoint customers can now deliver messages to Android devices using both FCM v1 API and the legacy FCM/GCM API

# Release (2023-07-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.23.4](service/sqs/CHANGELOG.md#v1234-2023-07-28)
  * **Documentation**: Documentation changes related to SQS APIs.

# Release (2023-07-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.29.0](service/autoscaling/CHANGELOG.md#v1290-2023-07-27)
  * **Feature**: This release updates validation for instance types used in the AllowedInstanceTypes and ExcludedInstanceTypes parameters of the InstanceRequirements property of a MixedInstancesPolicy.
* `github.com/aws/aws-sdk-go-v2/service/ebs`: [v1.17.0](service/ebs/CHANGELOG.md#v1170-2023-07-27)
  * **Feature**: SDK and documentation updates for Amazon Elastic Block Store API
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.108.0](service/ec2/CHANGELOG.md#v11080-2023-07-27)
  * **Feature**: SDK and documentation updates for Amazon Elastic Block Store APIs
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.28.0](service/eks/CHANGELOG.md#v1280-2023-07-27)
  * **Feature**: Add multiple customer error code to handle customer caused failure when managing EKS node groups
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.95.0](service/sagemaker/CHANGELOG.md#v1950-2023-07-27)
  * **Feature**: Expose ProfilerConfig attribute in SageMaker Search API response.

# Release (2023-07-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/entityresolution`: [v1.0.0](service/entityresolution/CHANGELOG.md#v100-2023-07-26)
  * **Release**: New AWS service client module
  * **Feature**: AWS Entity Resolution can effectively match a source record from a customer relationship management (CRM) system with a source record from a marketing system containing campaign information.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.58.0](service/glue/CHANGELOG.md#v1580-2023-07-26)
  * **Feature**: Release Glue Studio Snowflake Connector Node for SDK/CLI
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.16.4](service/healthlake/CHANGELOG.md#v1164-2023-07-26)
  * **Documentation**: Updating the HealthLake service documentation.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchainquery`: [v1.0.0](service/managedblockchainquery/CHANGELOG.md#v100-2023-07-26)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Managed Blockchain (AMB) Query provides serverless access to standardized, multi-blockchain datasets with developer-friendly APIs.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.39.1](service/mediaconvert/CHANGELOG.md#v1391-2023-07-26)
  * **Documentation**: This release includes general updates to user documentation.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.5.2](service/omics/CHANGELOG.md#v152-2023-07-26)
  * **Documentation**: The service is renaming as a part of AWS Health.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.3.0](service/opensearchserverless/CHANGELOG.md#v130-2023-07-26)
  * **Feature**: This release adds new collection type VectorSearch.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.27.0](service/polly/CHANGELOG.md#v1270-2023-07-26)
  * **Feature**: Amazon Polly adds 1 new voice - Lisa (nl-BE)
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.28.5](service/route53/CHANGELOG.md#v1285-2023-07-26)
  * **Documentation**: Update that corrects the documents for received feedback.

# Release (2023-07-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.7.0](service/billingconductor/CHANGELOG.md#v170-2023-07-25)
  * **Feature**: Added support for Auto-Assocate Billing Groups for CreateBillingGroup, UpdateBillingGroup, and ListBillingGroups.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.26.0](service/customerprofiles/CHANGELOG.md#v1260-2023-07-25)
  * **Feature**: Amazon Connect Customer Profiles now supports rule-based resolution to match and merge similar profiles into unified profiles, helping companies deliver faster and more personalized customer service by providing access to relevant customer information for agents and automated experiences.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.26.0](service/datasync/CHANGELOG.md#v1260-2023-07-25)
  * **Feature**: AWS DataSync now supports Microsoft Azure Blob Storage locations.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.20.2](service/dynamodb/CHANGELOG.md#v1202-2023-07-25)
  * **Documentation**: Documentation updates for DynamoDB
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.107.0](service/ec2/CHANGELOG.md#v11070-2023-07-25)
  * **Feature**: This release adds an instance's peak and baseline network bandwidth as well as the memory sizes of an instance's inference accelerators to DescribeInstanceTypes.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.9.0](service/emrserverless/CHANGELOG.md#v190-2023-07-25)
  * **Feature**: This release adds support for publishing application logs to CloudWatch.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.38.0](service/lambda/CHANGELOG.md#v1380-2023-07-25)
  * **Feature**: Add Python 3.11 (python3.11) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.48.0](service/rds/CHANGELOG.md#v1480-2023-07-25)
  * **Feature**: This release adds support for monitoring storage optimization progress on the DescribeDBInstances API.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.94.0](service/sagemaker/CHANGELOG.md#v1940-2023-07-25)
  * **Feature**: Mark ContentColumn and TargetLabelColumn as required Targets in TextClassificationJobConfig in CreateAutoMLJobV2API
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.34.0](service/securityhub/CHANGELOG.md#v1340-2023-07-25)
  * **Feature**: Add support for CONTAINS and NOT_CONTAINS comparison operators for Automation Rules string filters and map filters
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.20.0](service/sts/CHANGELOG.md#v1200-2023-07-25)
  * **Feature**: API updates for the AWS Security Token Service
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.32.0](service/transfer/CHANGELOG.md#v1320-2023-07-25)
  * **Feature**: This release adds support for SFTP Connectors.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.14.0](service/wisdom/CHANGELOG.md#v1140-2023-07-25)
  * **Feature**: This release added two new data types: AssistantIntegrationConfiguration, and SessionIntegrationConfiguration to support Wisdom integration with Amazon Connect Chat

# Release (2023-07-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.13.15](service/apigatewayv2/CHANGELOG.md#v11315-2023-07-24)
  * **Documentation**: Documentation updates for Amazon API Gateway.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.5.0](service/chimesdkmediapipelines/CHANGELOG.md#v150-2023-07-24)
  * **Feature**: AWS Media Pipeline compositing enhancement and Media Insights Pipeline auto language identification.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.32.0](service/cloudformation/CHANGELOG.md#v1320-2023-07-24)
  * **Feature**: This release supports filtering by DRIFT_STATUS for existing API ListStackInstances and adds support for a new API ListStackInstanceResourceDrifts. Customers can now view resource drift information from their StackSet management accounts.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.26.0](service/costexplorer/CHANGELOG.md#v1260-2023-07-24)
  * **Feature**: This release introduces the new API 'GetSavingsPlanPurchaseRecommendationDetails', which retrieves the details for a Savings Plan recommendation. It also updates the existing API 'GetSavingsPlansPurchaseRecommendation' to include the recommendation detail ID.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.106.0](service/ec2/CHANGELOG.md#v11060-2023-07-24)
  * **Feature**: Add "disabled" enum value to SpotInstanceState.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.57.0](service/glue/CHANGELOG.md#v1570-2023-07-24)
  * **Feature**: Added support for Data Preparation Recipe node in Glue Studio jobs
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.39.0](service/quicksight/CHANGELOG.md#v1390-2023-07-24)
  * **Feature**: This release launches new Snapshot APIs for CSV and PDF exports, adds support for info icon for filters and parameters in Exploration APIs, adds modeled exception to the DeleteAccountCustomization API, and introduces AttributeAggregationFunction's ability to add UNIQUE_VALUE aggregation in tooltips.

# Release (2023-07-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.56.0](service/glue/CHANGELOG.md#v1560-2023-07-21)
  * **Feature**: This release adds support for AWS Glue Crawler with Apache Hudi Tables, allowing Crawlers to discover Hudi Tables in S3 and register them in Glue Data Catalog for query engines to query against.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.39.0](service/mediaconvert/CHANGELOG.md#v1390-2023-07-21)
  * **Feature**: This release includes improvements to Preserve 444 handling, compatibility of HEVC sources without frame rates, and general improvements to MP4 outputs.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.47.0](service/rds/CHANGELOG.md#v1470-2023-07-21)
  * **Feature**: Adds support for the DBSystemID parameter of CreateDBInstance to RDS Custom for Oracle.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.28.17](service/workspaces/CHANGELOG.md#v12817-2023-07-21)
  * **Documentation**: Fixed VolumeEncryptionKey descriptions

# Release (2023-07-20.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.4.0](service/codecatalyst/CHANGELOG.md#v140-2023-07-202)
  * **Feature**: This release adds support for updating and deleting spaces and projects in Amazon CodeCatalyst. It also adds support for creating, getting, and deleting source repositories in CodeCatalyst projects.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.5.0](service/connectcases/CHANGELOG.md#v150-2023-07-202)
  * **Feature**: This release adds the ability to assign a case to a queue or user.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.31.0](service/lexmodelsv2/CHANGELOG.md#v1310-2023-07-202)
  * **Feature**: This release updates type for Channel field in SessionSpecification and UtteranceSpecification
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.18.0](service/route53resolver/CHANGELOG.md#v1180-2023-07-202)
  * **Feature**: This release adds support for Route 53 On Outposts, a new feature that allows customers to run Route 53 Resolver and Resolver endpoints locally on their Outposts.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.93.0](service/sagemaker/CHANGELOG.md#v1930-2023-07-202)
  * **Feature**: Cross account support for SageMaker Feature Store
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.16.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1160-2023-07-202)
  * **Feature**: Cross account support for SageMaker Feature Store
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.5.0](service/securitylake/CHANGELOG.md#v150-2023-07-202)
  * **Feature**: Adding support for Tags on Create and Resource Tagging API.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.27.0](service/transcribe/CHANGELOG.md#v1270-2023-07-202)
  * **Feature**: Added API argument --toxicity-detection to startTranscriptionJob API, which allows users to view toxicity scores of submitted audio.

# Release (2023-07-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.12.14](service/savingsplans/CHANGELOG.md#v11214-2023-07-20)
  * **Documentation**: Savings Plans endpoints update

# Release (2023-07-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.31.0](service/cloudformation/CHANGELOG.md#v1310-2023-07-19)
  * **Feature**: SDK and documentation updates for GetTemplateSummary API (unrecognized resources)
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.105.1](service/ec2/CHANGELOG.md#v11051-2023-07-19)
  * **Documentation**: Amazon EC2 documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.14.0](service/grafana/CHANGELOG.md#v1140-2023-07-19)
  * **Feature**: Amazon Managed Grafana now supports grafanaVersion update for existing workspaces with UpdateWorkspaceConfiguration API. DescribeWorkspaceConfiguration API additionally returns grafanaVersion. A new ListVersions API lists available versions or, if given a workspaceId, the versions it can upgrade to.
* `github.com/aws/aws-sdk-go-v2/service/medicalimaging`: [v1.0.0](service/medicalimaging/CHANGELOG.md#v100-2023-07-19)
  * **Release**: New AWS service client module
  * **Feature**: General Availability (GA) release of AWS Health Imaging, enabling customers to store, transform, and analyze medical imaging data at petabyte-scale.
* `github.com/aws/aws-sdk-go-v2/service/ram`: [v1.19.0](service/ram/CHANGELOG.md#v1190-2023-07-19)
  * **Feature**: This release adds support for securely sharing with AWS service principals.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.3.0](service/ssmsap/CHANGELOG.md#v130-2023-07-19)
  * **Feature**: Added support for SAP Hana High Availability discovery (primary and secondary nodes) and Backint agent installation with SSM for SAP.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.36.0](service/wafv2/CHANGELOG.md#v1360-2023-07-19)
  * **Feature**: Added the URI path to the custom aggregation keys that you can specify for a rate-based rule.

# Release (2023-07-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.0.3](service/codegurusecurity/CHANGELOG.md#v103-2023-07-18)
  * **Documentation**: Documentation updates for CodeGuru Security.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.61.1](service/connect/CHANGELOG.md#v1611-2023-07-18)
  * **Documentation**: GetMetricDataV2 API: Update to include Contact Lens Conversational Analytics Metrics
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.30.0](service/lexmodelsv2/CHANGELOG.md#v1300-2023-07-18)
  * **Feature**: This release adds support for Lex Developers to view analytics for their bots.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.6.0](service/m2/CHANGELOG.md#v160-2023-07-18)
  * **Feature**: Allows UpdateEnvironment to update the environment to 0 host capacity. New GetSignedBluinsightsUrl API
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.20.0](service/snowball/CHANGELOG.md#v1200-2023-07-18)
  * **Feature**: Adds support for RACK_5U_C. This is the first AWS Snow Family device designed to meet U.S. Military Ruggedization Standards (MIL-STD-810H) with 208 vCPU device in a portable, compact 5U, half-rack width form-factor.
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.18.4](service/translate/CHANGELOG.md#v1184-2023-07-18)
  * **Documentation**: Added DOCX word document support to TranslateDocument API

# Release (2023-07-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.18.8](service/codeartifact/CHANGELOG.md#v1188-2023-07-17)
  * **Documentation**: Doc only update for AWS CodeArtifact
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.22.0](service/docdb/CHANGELOG.md#v1220-2023-07-17)
  * **Feature**: Added major version upgrade option in ModifyDBCluster API
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.105.0](service/ec2/CHANGELOG.md#v11050-2023-07-17)
  * **Feature**: Add Nitro TPM support on DescribeInstanceTypes
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.55.0](service/glue/CHANGELOG.md#v1550-2023-07-17)
  * **Feature**: Adding new supported permission type flags to get-unfiltered endpoints that callers may pass to indicate support for enforcing Lake Formation fine-grained access control on nested column attributes.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.24.0](service/ivs/CHANGELOG.md#v1240-2023-07-17)
  * **Feature**: This release provides the flexibility to configure what renditions or thumbnail qualities to record when creating recording configuration.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.22.0](service/lakeformation/CHANGELOG.md#v1220-2023-07-17)
  * **Feature**: Adds supports for ReadOnlyAdmins and AllowFullTableExternalDataAccess. Adds NESTED_PERMISSION and NESTED_CELL_PERMISSION to SUPPORTED_PERMISSION_TYPES enum. Adds CREATE_LF_TAG on catalog resource and ALTER, DROP, and GRANT_WITH_LF_TAG_EXPRESSION on LF Tag resource.

# Release (2023-07-13)

## General Highlights
* **Feature**: Modify user agent syntax and introduce support for optional app identifier in UA header
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.23.0](service/cognitoidentityprovider/CHANGELOG.md#v1230-2023-07-13)
  * **Feature**: API model updated in Amazon Cognito
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.61.0](service/connect/CHANGELOG.md#v1610-2023-07-13)
  * **Feature**: Add support for deleting Queues and Routing Profiles.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.27.0](service/databasemigrationservice/CHANGELOG.md#v1270-2023-07-13)
  * **Feature**: Enhanced PostgreSQL target endpoint settings for providing Babelfish support.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.25.0](service/datasync/CHANGELOG.md#v1250-2023-07-13)
  * **Feature**: Added LunCount to the response object of DescribeStorageSystemResourcesResponse, LunCount represents the number of LUNs on a storage system resource.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.104.0](service/ec2/CHANGELOG.md#v11040-2023-07-13)
  * **Feature**: This release adds support for the C7gn and Hpc7g instances. C7gn instances are powered by AWS Graviton3 processors and the fifth-generation AWS Nitro Cards. Hpc7g instances are powered by AWS Graviton 3E processors and provide up to 200 Gbps network bandwidth.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.30.0](service/fsx/CHANGELOG.md#v1300-2023-07-13)
  * **Feature**: Amazon FSx for NetApp ONTAP now supports SnapLock, an ONTAP feature that enables you to protect your files in a volume by transitioning them to a write once, read many (WORM) state.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.21.1](service/iam/CHANGELOG.md#v1211-2023-07-13)
  * **Documentation**: Documentation updates for AWS Identity and Access Management (IAM).
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.25.0](service/mediatailor/CHANGELOG.md#v1250-2023-07-13)
  * **Feature**: Adds categories to MediaTailor channel assembly alerts
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.25.0](service/personalize/CHANGELOG.md#v1250-2023-07-13)
  * **Feature**: This release provides ability to customers to change schema associated with their datasets in Amazon Personalize
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.22.0](service/proton/CHANGELOG.md#v1220-2023-07-13)
  * **Feature**: This release adds support for deployment history for Proton provisioned resources
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.37.0](service/s3/CHANGELOG.md#v1370-2023-07-13)
  * **Feature**: S3 Inventory now supports Object Access Control List and Object Owner as available object metadata fields in inventory reports.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.92.0](service/sagemaker/CHANGELOG.md#v1920-2023-07-13)
  * **Feature**: Amazon SageMaker Canvas adds WorkspeceSettings support for CanvasAppSettings
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.19.11](service/secretsmanager/CHANGELOG.md#v11911-2023-07-13)
  * **Documentation**: Documentation updates for Secrets Manager

# Release (2023-07-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.22.0](service/cloudwatchlogs/CHANGELOG.md#v1220-2023-07-07)
  * **Feature**: Add CMK encryption support for CloudWatch Logs Insights query result data
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.26.0](service/databasemigrationservice/CHANGELOG.md#v1260-2023-07-07)
  * **Feature**: Releasing DMS Serverless. Adding support for PostgreSQL 15.x as source and target endpoint. Adding support for DocDB Elastic Clusters with sharded collections, PostgreSQL datatype mapping customization and disabling hostname validation of the certificate authority in Kafka endpoint settings
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.54.0](service/glue/CHANGELOG.md#v1540-2023-07-07)
  * **Feature**: This release enables customers to create new Apache Iceberg tables and associated metadata in Amazon S3 by using native AWS Glue CreateTable operation.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.32.0](service/medialive/CHANGELOG.md#v1320-2023-07-07)
  * **Feature**: This release enables the use of Thumbnails in AWS Elemental MediaLive.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.24.0](service/mediatailor/CHANGELOG.md#v1240-2023-07-07)
  * **Feature**: The AWS Elemental MediaTailor SDK for Channel Assembly has added support for EXT-X-CUE-OUT and EXT-X-CUE-IN tags to specify ad breaks in HLS outputs, including support for EXT-OATCLS, EXT-X-ASSET, and EXT-X-CUE-OUT-CONT accessory tags.

# Release (2023-07-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.103.0](service/ec2/CHANGELOG.md#v11030-2023-07-06)
  * **Feature**: Add Nitro Enclaves support on DescribeInstanceTypes
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.25.0](service/location/CHANGELOG.md#v1250-2023-07-06)
  * **Feature**: This release adds support for authenticating with Amazon Location Service's Places & Routes APIs with an API Key. Also, with this release developers can publish tracked device position updates to Amazon EventBridge.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.28.0](service/outposts/CHANGELOG.md#v1280-2023-07-06)
  * **Feature**: Added paginator support to several APIs. Added the ISOLATED enum value to AssetState.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.38.0](service/quicksight/CHANGELOG.md#v1380-2023-07-06)
  * **Feature**: This release includes below three changes: small multiples axes improvement, field based coloring, removed required trait from Aggregation function for TopBottomFilter.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.46.1](service/rds/CHANGELOG.md#v1461-2023-07-06)
  * **Documentation**: Updates Amazon RDS documentation for creating DB instances and creating Aurora global clusters.

# Release (2023-07-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.16.3](service/comprehendmedical/CHANGELOG.md#v1163-2023-07-05)
  * **Documentation**: Update to Amazon Comprehend Medical documentation.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.60.1](service/connect/CHANGELOG.md#v1601-2023-07-05)
  * **Documentation**: GetMetricDataV2 API: Channels filters do not count towards overall limitation of 100 filter values.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.23.0](service/kms/CHANGELOG.md#v1230-2023-07-05)
  * **Feature**: Added Dry Run Feature to cryptographic and cross-account mutating KMS APIs (14 in all). This feature allows users to test their permissions and parameters before making the actual API call.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.19.0](service/mgn/CHANGELOG.md#v1190-2023-07-05)
  * **Feature**: This release introduces the Global view feature and new Replication state APIs.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.33.2](service/securityhub/CHANGELOG.md#v1332-2023-07-05)
  * **Documentation**: Documentation updates for AWS Security Hub

# Release (2023-07-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.24.0](service/batch/CHANGELOG.md#v1240-2023-07-03)
  * **Feature**: This feature allows customers to use AWS Batch with Linux with ARM64 CPU Architecture and X86_64 CPU Architecture with Windows OS on Fargate Platform.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.91.0](service/sagemaker/CHANGELOG.md#v1910-2023-07-03)
  * **Feature**: SageMaker Inference Recommender now accepts new fields SupportedEndpointType and ServerlessConfiguration to support serverless endpoints.

# Release (2023-06-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.28.0](service/ecs/CHANGELOG.md#v1280-2023-06-30)
  * **Feature**: Added new field  "credentialspecs" to the ecs task definition to support gMSA of windows/linux in both domainless and domain-joined mode
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.38.1](service/mediaconvert/CHANGELOG.md#v1381-2023-06-30)
  * **Documentation**: This release includes improved color handling of overlays and general updates to user documentation.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.90.0](service/sagemaker/CHANGELOG.md#v1900-2023-06-30)
  * **Feature**: This release adds support for rolling deployment in SageMaker Inference.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.31.0](service/transfer/CHANGELOG.md#v1310-2023-06-30)
  * **Feature**: Add outbound Basic authentication support to AS2 connectors
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.0.4](service/verifiedpermissions/CHANGELOG.md#v104-2023-06-30)
  * **Documentation**: This release corrects several broken links in the documentation.

# Release (2023-06-29)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.21.0](service/appstream/CHANGELOG.md#v1210-2023-06-29)
  * **Feature**: This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.24.0](service/chime/CHANGELOG.md#v1240-2023-06-29)
  * **Feature**: The Amazon Chime SDK APIs in the Chime namespace are no longer supported.  Customers should use APIs in the dedicated Amazon Chime SDK namespaces: ChimeSDKIdentity, ChimeSDKMediaPipelines, ChimeSDKMeetings, ChimeSDKMessaging, and ChimeSDKVoice.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.2.0](service/cleanrooms/CHANGELOG.md#v120-2023-06-29)
  * **Feature**: This release adds support for the OR operator in RSQL join match conditions and the ability to control which operators (AND, OR) are allowed in a join match condition.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.20.0](service/dynamodb/CHANGELOG.md#v1200-2023-06-29)
  * **Feature**: This release adds ReturnValuesOnConditionCheckFailure parameter to PutItem, UpdateItem, DeleteItem, ExecuteStatement, BatchExecuteStatement and ExecuteTransaction APIs. When set to ALL_OLD,  API returns a copy of the item as it was when a conditional write failed
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.20.0](service/gamelift/CHANGELOG.md#v1200-2023-06-29)
  * **Feature**: Amazon GameLift now supports game builds that use the Amazon Linux 2023 (AL2023) operating system.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.53.0](service/glue/CHANGELOG.md#v1530-2023-06-29)
  * **Feature**: This release adds support for AWS Glue Crawler with Iceberg Tables, allowing Crawlers to discover Iceberg Tables in S3 and register them in Glue Data Catalog for query engines to query against.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.89.0](service/sagemaker/CHANGELOG.md#v1890-2023-06-29)
  * **Feature**: Adding support for timeseries forecasting in the CreateAutoMLJobV2 API.

# Release (2023-06-28)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.3.0](service/internetmonitor/CHANGELOG.md#v130-2023-06-28)
  * **Feature**: This release adds a new feature for Amazon CloudWatch Internet Monitor that enables customers to set custom thresholds, for performance and availability drops, for triggering when to create a health event.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.17.0](service/kinesisanalyticsv2/CHANGELOG.md#v1170-2023-06-28)
  * **Feature**: Support for new runtime environment in Kinesis Data Analytics Studio: Zeppelin-0.10, Apache Flink-1.15
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.37.0](service/lambda/CHANGELOG.md#v1370-2023-06-28)
  * **Feature**: Surface ResourceConflictException in DeleteEventSourceMapping
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.5.0](service/omics/CHANGELOG.md#v150-2023-06-28)
  * **Feature**: Add Common Workflow Language (CWL) as a supported language for Omics workflows
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.46.0](service/rds/CHANGELOG.md#v1460-2023-06-28)
  * **Feature**: Amazon Relational Database Service (RDS) now supports joining a RDS for SQL Server instance to a self-managed Active Directory.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.36.0](service/s3/CHANGELOG.md#v1360-2023-06-28)
  * **Feature**: The S3 LISTObjects, ListObjectsV2 and ListObjectVersions API now supports a new optional header x-amz-optional-object-attributes. If header contains RestoreStatus as the value, then S3 will include Glacier restore status i.e. isRestoreInProgress and RestoreExpiryDate in List response.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.88.0](service/sagemaker/CHANGELOG.md#v1880-2023-06-28)
  * **Feature**: This release adds support for Model Cards Model Registry integration.

# Release (2023-06-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appfabric`: [v1.0.0](service/appfabric/CHANGELOG.md#v100-2023-06-27)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS AppFabric for connecting SaaS applications for better productivity and security.
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.32.0](service/appflow/CHANGELOG.md#v1320-2023-06-27)
  * **Feature**: This release adds support to bypass SSO with the SAPOData connector when connecting to an SAP instance.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.8.0](service/emrserverless/CHANGELOG.md#v180-2023-06-27)
  * **Feature**: This release adds support to update the release label of an EMR Serverless application to upgrade it to a different version of Amazon EMR via UpdateApplication API.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.23.0](service/ivs/CHANGELOG.md#v1230-2023-06-27)
  * **Feature**: IVS customers can now revoke the viewer session associated with an auth token, to prevent and stop playback using that token.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.16.0](service/kinesisvideo/CHANGELOG.md#v1160-2023-06-27)
  * **Feature**: General Availability (GA) release of Kinesis Video Streams at Edge, enabling customers to provide a configuration for the Kinesis Video Streams EdgeAgent running on an on-premise IoT device. Customers can now locally record from cameras and stream videos to the cloud on a configured schedule.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.28.0](service/macie2/CHANGELOG.md#v1280-2023-06-27)
  * **Feature**: This release adds support for configuring new classification jobs to use the set of managed data identifiers that we recommend for jobs. For the managed data identifier selection type (managedDataIdentifierSelector), specify RECOMMENDED.
* `github.com/aws/aws-sdk-go-v2/service/privatenetworks`: [v1.3.0](service/privatenetworks/CHANGELOG.md#v130-2023-06-27)
  * **Feature**: This release allows Private5G customers to choose different commitment plans (60-days, 1-year, 3-years) when placing new orders, enables automatic renewal option for 1-year and 3-years commitments. It also allows customers to update the commitment plan of an existing radio unit.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.87.0](service/sagemaker/CHANGELOG.md#v1870-2023-06-27)
  * **Feature**: Introducing TTL for online store records in feature groups.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.15.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1150-2023-06-27)
  * **Feature**: Introducing TTL for online store records for feature groups.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.36.7](service/ssm/CHANGELOG.md#v1367-2023-06-27)
  * **Documentation**: Systems Manager doc-only update for June 2023.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.0.3](service/verifiedpermissions/CHANGELOG.md#v103-2023-06-27)
  * **Documentation**: This update fixes several broken links to the Cedar documentation.

# Release (2023-06-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.60.0](service/connect/CHANGELOG.md#v1600-2023-06-26)
  * **Feature**: This release provides a way to search for existing tags within an instance. Before tagging a resource, ensure consistency by searching for pre-existing key:value pairs.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.52.0](service/glue/CHANGELOG.md#v1520-2023-06-26)
  * **Feature**: Timestamp Starting Position For Kinesis and Kafka Data Sources in a Glue Streaming Job
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.24.0](service/guardduty/CHANGELOG.md#v1240-2023-06-26)
  * **Feature**: Add support for user.extra.sessionName in Kubernetes Audit Logs Findings.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.21.0](service/iam/CHANGELOG.md#v1210-2023-06-26)
  * **Feature**: Support for a new API "GetMFADevice" to present MFA device metadata such as device certifications
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.20.0](service/pinpoint/CHANGELOG.md#v1200-2023-06-26)
  * **Feature**: Added time zone estimation support for journeys

# Release (2023-06-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.24.0](service/devopsguru/CHANGELOG.md#v1240-2023-06-23)
  * **Feature**: This release adds support for encryption via customer managed keys.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.29.3](service/fsx/CHANGELOG.md#v1293-2023-06-23)
  * **Documentation**: Update to Amazon FSx documentation.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.45.3](service/rds/CHANGELOG.md#v1453-2023-06-23)
  * **Documentation**: Documentation improvements for create, describe, and modify DB clusters and DB instances.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.0.2](service/verifiedpermissions/CHANGELOG.md#v102-2023-06-23)
  * **Documentation**: Added improved descriptions and new code samples to SDK documentation.

# Release (2023-06-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkidentity`: [v1.12.0](service/chimesdkidentity/CHANGELOG.md#v1120-2023-06-22)
  * **Feature**: AppInstanceBots can be configured to be invoked or not using the Target or the CHIME.mentions attribute for ChannelMessages
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.16.0](service/chimesdkmessaging/CHANGELOG.md#v1160-2023-06-22)
  * **Feature**: ChannelMessages can be made visible to sender and intended recipient rather than all channel members with the target attribute. For example, a user can send messages to a bot and receive messages back in a group channel without other members seeing them.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.41.0](service/kendra/CHANGELOG.md#v1410-2023-06-22)
  * **Feature**: Introducing Amazon Kendra Retrieve API that can be used to retrieve relevant passages or text excerpts given an input query.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.18.0](service/sfn/CHANGELOG.md#v1180-2023-06-22)
  * **Feature**: Adds support for Versions and Aliases. Adds 8 operations: PublishStateMachineVersion, DeleteStateMachineVersion, ListStateMachineVersions, CreateStateMachineAlias, DescribeStateMachineAlias, UpdateStateMachineAlias, DeleteStateMachineAlias, ListStateMachineAliases

# Release (2023-06-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.19.11](service/dynamodb/CHANGELOG.md#v11911-2023-06-21)
  * **Documentation**: Documentation updates for DynamoDB
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.27.0](service/emr/CHANGELOG.md#v1270-2023-06-21)
  * **Feature**: This release introduces a new Amazon EMR EPI called ListSupportedInstanceTypes that returns a list of all instance types supported by a given EMR release.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.15.0](service/inspector2/CHANGELOG.md#v1150-2023-06-21)
  * **Feature**: This release adds support for Software Bill of Materials (SBOM) export and the general availability of code scanning for AWS Lambda functions.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.38.0](service/mediaconvert/CHANGELOG.md#v1380-2023-06-21)
  * **Feature**: This release introduces the bandwidth reduction filter for the HEVC encoder, increases the limits of outputs per job, and updates support for the Nagra SDK to version 1.14.7.
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.15.0](service/mq/CHANGELOG.md#v1150-2023-06-21)
  * **Feature**: The Cross Region Disaster Recovery feature allows to replicate a brokers state from one region to another in order to provide customers with multi-region resiliency in the event of a regional outage.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.86.0](service/sagemaker/CHANGELOG.md#v1860-2023-06-21)
  * **Feature**: This release provides support in SageMaker for output files in training jobs to be uploaded without compression and enable customer to deploy uncompressed model from S3 to real-time inference Endpoints. In addition, ml.trn1n.32xlarge is added to supported instance type list in training job.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.30.0](service/transfer/CHANGELOG.md#v1300-2023-06-21)
  * **Feature**: This release adds a new parameter StructuredLogDestinations to CreateServer, UpdateServer APIs.

# Release (2023-06-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.31.0](service/appflow/CHANGELOG.md#v1310-2023-06-20)
  * **Feature**: This release adds new API to reset connector metadata cache
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.34.0](service/configservice/CHANGELOG.md#v1340-2023-06-20)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in May 2023.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.102.0](service/ec2/CHANGELOG.md#v11020-2023-06-20)
  * **Feature**: Adds support for targeting Dedicated Host allocations by assetIds in AWS Outposts
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.36.0](service/lambda/CHANGELOG.md#v1360-2023-06-20)
  * **Feature**: This release adds RecursiveInvocationException to the Invoke API and InvokeWithResponseStream API.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.28.0](service/redshift/CHANGELOG.md#v1280-2023-06-20)
  * **Feature**: Added support for custom domain names for Redshift Provisioned clusters. This feature enables customers to create a custom domain name and use ACM to generate fully secure connections to it.

# Release (2023-06-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.30.0](service/cloudformation/CHANGELOG.md#v1300-2023-06-19)
  * **Feature**: Specify desired CloudFormation behavior in the event of ChangeSet execution failure using the CreateChangeSet OnStackFailure parameter
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.101.0](service/ec2/CHANGELOG.md#v11010-2023-06-19)
  * **Feature**: API changes to AWS Verified Access to include data from trust providers in logs
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.27.4](service/ecs/CHANGELOG.md#v1274-2023-06-19)
  * **Documentation**: Documentation only update to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.51.0](service/glue/CHANGELOG.md#v1510-2023-06-19)
  * **Feature**: This release adds support for creating cross region table/database resource links
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.20.0](service/pricing/CHANGELOG.md#v1200-2023-06-19)
  * **Feature**: This release updates the PriceListArn regex pattern.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.15.0](service/route53domains/CHANGELOG.md#v1150-2023-06-19)
  * **Feature**: Update MaxItems upper bound to 1000 for ListPricesRequest
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.85.0](service/sagemaker/CHANGELOG.md#v1850-2023-06-19)
  * **Feature**: Amazon Sagemaker Autopilot releases CreateAutoMLJobV2 and DescribeAutoMLJobV2 for Autopilot customers with ImageClassification, TextClassification and Tabular problem type config support.

# Release (2023-06-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.16.0](service/applicationdiscoveryservice/CHANGELOG.md#v1160-2023-06-16)
  * **Feature**: Add Amazon EC2 instance recommendations export
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.59.0](service/connect/CHANGELOG.md#v1590-2023-06-16)
  * **Feature**: Updates the *InstanceStorageConfig APIs to support a new ResourceType: SCREEN_RECORDINGS to enable screen recording and specify the storage configurations for publishing the recordings. Also updates DescribeInstance and ListInstances APIs to include InstanceAccessUrl attribute in the API response.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.20.3](service/iam/CHANGELOG.md#v1203-2023-06-16)
  * **Documentation**: Documentation updates for AWS Identity and Access Management (IAM).
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.35.0](service/s3/CHANGELOG.md#v1350-2023-06-16)
  * **Feature**: This release adds SDK support for request-payer request header and request-charged response header in the "GetBucketAccelerateConfiguration", "ListMultipartUploads", "ListObjects", "ListObjectsV2" and "ListObjectVersions" S3 APIs.

# Release (2023-06-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.25.0](service/auditmanager/CHANGELOG.md#v1250-2023-06-15)
  * **Feature**: This release introduces 2 Audit Manager features: CSV exports and new manual evidence options. You can now export your evidence finder results in CSV format. In addition, you can now add manual evidence to a control by entering free-form text or uploading a file from your browser.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.20.3](service/efs/CHANGELOG.md#v1203-2023-06-15)
  * **Documentation**: Documentation updates for EFS.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.23.2](service/guardduty/CHANGELOG.md#v1232-2023-06-15)
  * **Documentation**: Updated descriptions for some APIs.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.24.0](service/location/CHANGELOG.md#v1240-2023-06-15)
  * **Feature**: Amazon Location Service adds categories to places, including filtering on those categories in searches. Also, you can now add metadata properties to your geofences.

# Release (2023-06-13)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.27.0](service/cloudtrail/CHANGELOG.md#v1270-2023-06-13)
  * **Feature**: This feature allows users to view dashboards for CloudTrail Lake event data stores.
* `github.com/aws/aws-sdk-go-v2/service/codegurusecurity`: [v1.0.0](service/codegurusecurity/CHANGELOG.md#v100-2023-06-13)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of Amazon CodeGuru Security APIs
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.14.0](service/drs/CHANGELOG.md#v1140-2023-06-13)
  * **Feature**: Added APIs to support network replication and recovery using AWS Elastic Disaster Recovery.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.100.0](service/ec2/CHANGELOG.md#v11000-2023-06-13)
  * **Feature**: This release introduces a new feature, EC2 Instance Connect Endpoint, that enables you to connect to a resource over TCP, without requiring the resource to have a public IPv4 address.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.23.5](service/imagebuilder/CHANGELOG.md#v1235-2023-06-13)
  * **Documentation**: Change the Image Builder ImagePipeline dateNextRun field to more accurately describe the data.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.27.0](service/lightsail/CHANGELOG.md#v1270-2023-06-13)
  * **Feature**: This release adds pagination for the Get Certificates API operation.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.34.0](service/s3/CHANGELOG.md#v1340-2023-06-13)
  * **Feature**: Integrate double encryption feature to SDKs.
  * **Bug Fix**: Fix HeadObject to return types.Nound when an object does not exist. Fixes [2084](https://github.com/aws/aws-sdk-go-v2/issues/2084)
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.33.0](service/securityhub/CHANGELOG.md#v1330-2023-06-13)
  * **Feature**: Add support for Security Hub Automation Rules
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.3.0](service/simspaceweaver/CHANGELOG.md#v130-2023-06-13)
  * **Feature**: This release fixes using aws-us-gov ARNs in API calls and adds documentation for snapshot APIs.
* `github.com/aws/aws-sdk-go-v2/service/verifiedpermissions`: [v1.0.0](service/verifiedpermissions/CHANGELOG.md#v100-2023-06-13)
  * **Release**: New AWS service client module
  * **Feature**: GA release of Amazon Verified Permissions.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.35.0](service/wafv2/CHANGELOG.md#v1350-2023-06-13)
  * **Feature**: You can now detect and block fraudulent account creation attempts with the new AWS WAF Fraud Control account creation fraud prevention (ACFP) managed rule group AWSManagedRulesACFPRuleSet.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.21.0](service/wellarchitected/CHANGELOG.md#v1210-2023-06-13)
  * **Feature**: AWS Well-Architected now supports Profiles that help customers prioritize which questions to focus on first by providing a list of prioritized questions that are better aligned with their business goals and outcomes.

# Release (2023-06-12)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.11.0](service/amplifyuibuilder/CHANGELOG.md#v1110-2023-06-12)
  * **Feature**: AWS Amplify UIBuilder is launching Codegen UI, a new feature that enables you to generate your amplify uibuilder components and forms.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.19.8](service/dynamodb/CHANGELOG.md#v1198-2023-06-12)
  * **Documentation**: Documentation updates for DynamoDB
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.14.12](service/dynamodbstreams/CHANGELOG.md#v11412-2023-06-12)
  * **Documentation**: Documentation updates for DynamoDB Streams
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.29.0](service/fsx/CHANGELOG.md#v1290-2023-06-12)
  * **Feature**: Amazon FSx for NetApp ONTAP now supports joining a storage virtual machine (SVM) to Active Directory after the SVM has been created.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.18.0](service/opensearch/CHANGELOG.md#v1180-2023-06-12)
  * **Feature**: This release adds support for SkipUnavailable connection property for cross cluster search
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.29.0](service/rekognition/CHANGELOG.md#v1290-2023-06-12)
  * **Feature**: This release adds support for improved accuracy with user vector in Amazon Rekognition Face Search. Adds new APIs: AssociateFaces, CreateUser, DeleteUser, DisassociateFaces, ListUsers, SearchUsers, SearchUsersByImage. Also adds new face metadata that can be stored: user vector.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.84.0](service/sagemaker/CHANGELOG.md#v1840-2023-06-12)
  * **Feature**: Sagemaker Neo now supports compilation for inferentia2 (ML_INF2) and Trainium1 (ML_TRN1) as available targets. With these devices, you can run your workloads at highest performance with lowest cost. inferentia2 (ML_INF2) is available in CMH and Trainium1 (ML_TRN1) is available in IAD currently

# Release (2023-06-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.21.13](service/acmpca/CHANGELOG.md#v12113-2023-06-09)
  * **Documentation**: Document-only update to refresh CLI  documentation for AWS Private CA. No change to the service.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.58.0](service/connect/CHANGELOG.md#v1580-2023-06-09)
  * **Feature**: This release adds search APIs for Prompts, Quick Connects and Hours of Operations, which can be used to search for those resources within a Connect Instance.

# Release (2023-06-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.30.0](service/athena/CHANGELOG.md#v1300-2023-06-08)
  * **Feature**: You can now define custom spark properties at start of the session for use cases like cluster encryption, table formats, and general Spark tuning.
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.16.0](service/comprehendmedical/CHANGELOG.md#v1160-2023-06-08)
  * **Feature**: This release supports a new set of entities and traits.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptography`: [v1.0.0](service/paymentcryptography/CHANGELOG.md#v100-2023-06-08)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS Payment Cryptography Control Plane service for creating and managing cryptographic keys used during card payment processing.
* `github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata`: [v1.0.0](service/paymentcryptographydata/CHANGELOG.md#v100-2023-06-08)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS Payment Cryptography DataPlane Plane service for performing cryptographic operations typically used during card payment processing.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.19.0](service/servicecatalog/CHANGELOG.md#v1190-2023-06-08)
  * **Feature**: New parameter added in ServiceCatalog DescribeProvisioningArtifact api - IncludeProvisioningArtifactParameters. This parameter can be used to return information about the parameters used to provision the product
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.17.0](service/timestreamwrite/CHANGELOG.md#v1170-2023-06-08)
  * **Feature**: This release adds the capability for customers to define how their data should be partitioned, optimizing for certain access patterns. This definition will take place as a part of the table creation.

# Release (2023-06-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.29.0](service/cloudformation/CHANGELOG.md#v1290-2023-06-07)
  * **Feature**: AWS CloudFormation StackSets is updating the deployment experience for all stackset operations to skip suspended AWS accounts during deployments. StackSets will skip target AWS accounts that are suspended and set the Detailed Status of the corresponding stack instances as SKIPPED_SUSPENDED_ACCOUNT
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.21.0](service/cloudwatchlogs/CHANGELOG.md#v1210-2023-06-07)
  * **Feature**: This change adds support for account level data protection policies using 3 new APIs, PutAccountPolicy, DeleteAccountPolicy and DescribeAccountPolicy. DescribeLogGroup API has been modified to indicate if account level policy is applied to the LogGroup via "inheritedProperties" list in the response.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.25.0](service/customerprofiles/CHANGELOG.md#v1250-2023-06-07)
  * **Feature**: This release introduces event stream related APIs.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.18.15](service/directconnect/CHANGELOG.md#v11815-2023-06-07)
  * **Documentation**: This update corrects the jumbo frames mtu values from 9100 to 8500 for transit virtual interfaces.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.19.0](service/emrcontainers/CHANGELOG.md#v1190-2023-06-07)
  * **Feature**: EMR on EKS adds support for log rotation of Spark container logs with EMR-6.11.0 onwards, to the StartJobRun API.
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.19.0](service/iotdeviceadvisor/CHANGELOG.md#v1190-2023-06-07)
  * **Feature**: AWS IoT Core Device Advisor now supports new Qualification Suite test case list. With this update, customers can more easily create new qualification test suite with an empty rootGroup input.

# Release (2023-06-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.57.1](service/connect/CHANGELOG.md#v1571-2023-06-06)
  * **Documentation**: GetMetricDataV2 API is now available in AWS GovCloud(US) region.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.26.0](service/emr/CHANGELOG.md#v1260-2023-06-06)
  * **Feature**: This release provides customers the ability to specify an allocation strategies amongst PRICE_CAPACITY_OPTIMIZED, CAPACITY_OPTIMIZED, LOWEST_PRICE, DIVERSIFIED for Spot instances in Instance Feet cluster. This enables customers to choose an allocation strategy best suited for their workload.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.20.0](service/iam/CHANGELOG.md#v1200-2023-06-06)
  * **Feature**: This release updates the AccountAlias regex pattern with the same length restrictions enforced by the length constraint.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.14.0](service/inspector2/CHANGELOG.md#v1140-2023-06-06)
  * **Feature**: Adds new response properties and request parameters for 'last scanned at' on the ListCoverage operation. This feature allows you to search and view the date of which your resources were last scanned by Inspector.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.38.0](service/iot/CHANGELOG.md#v1380-2023-06-06)
  * **Feature**: Adding IoT Device Management Software Package Catalog APIs to register, store, and report system software packages, along with their versions and metadata in a centralized location.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.29.0](service/lexmodelsv2/CHANGELOG.md#v1290-2023-06-06)
  * **Feature**: This release adds support for Lex Developers to create test sets and to execute those test-sets against their bots.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.37.0](service/quicksight/CHANGELOG.md#v1370-2023-06-06)
  * **Feature**: QuickSight support for pivot table field collapse state, radar chart range scale and multiple scope options in conditional formatting.
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.15.0](service/signer/CHANGELOG.md#v1150-2023-06-06)
  * **Feature**: AWS Signer is launching Container Image Signing, a new feature that enables you to sign and verify container images. This feature enables you to validate that only container images you approve are used in your enterprise.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.23.0](service/sqs/CHANGELOG.md#v1230-2023-06-06)
  * **Feature**: Amazon SQS adds three new APIs - StartMessageMoveTask, CancelMessageMoveTask, and ListMessageMoveTasks to automate redriving messages from dead-letter queues to source queues or a custom destination.

# Release (2023-06-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.28.0](service/cloudformation/CHANGELOG.md#v1280-2023-06-05)
  * **Feature**: AWS CloudFormation StackSets provides customers with three new APIs to activate, deactivate, and describe AWS Organizations trusted access which is needed to get started with service-managed StackSets.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.99.0](service/ec2/CHANGELOG.md#v1990-2023-06-05)
  * **Feature**: Making InstanceTagAttribute as the required parameter for the DeregisterInstanceEventNotificationAttributes and RegisterInstanceEventNotificationAttributes APIs.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.10.0](service/finspace/CHANGELOG.md#v1100-2023-06-05)
  * **Feature**: Releasing new Managed kdb Insights APIs
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.25.0](service/frauddetector/CHANGELOG.md#v1250-2023-06-05)
  * **Feature**: Added new variable types, new DateTime data type, and new rules engine functions for interacting and working with DateTime data types.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.3.0](service/keyspaces/CHANGELOG.md#v130-2023-06-05)
  * **Feature**: This release adds support for MRR GA launch, and includes multiregion support in create-keyspace, get-keyspace, and list-keyspace.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.22.0](service/kms/CHANGELOG.md#v1220-2023-06-05)
  * **Feature**: This release includes feature to import customer's asymmetric (RSA and ECC) and HMAC keys into KMS.  It also includes feature to allow customers to specify number of days to schedule a KMS key deletion as a policy condition key.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.35.0](service/lambda/CHANGELOG.md#v1350-2023-06-05)
  * **Feature**: Add Ruby 3.2 (ruby3.2) Runtime support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.16.0](service/mwaa/CHANGELOG.md#v1160-2023-06-05)
  * **Feature**: This release adds ROLLING_BACK and CREATING_SNAPSHOT environment statuses for Amazon MWAA environments.

# Release (2023-06-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.29.0](service/athena/CHANGELOG.md#v1290-2023-06-02)
  * **Feature**: This release introduces the DeleteCapacityReservation API and the ability to manage capacity reservations using CloudFormation
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.26.0](service/cloudtrail/CHANGELOG.md#v1260-2023-06-02)
  * **Feature**: This feature allows users to start and stop event ingestion on a CloudTrail Lake event data store.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.83.0](service/sagemaker/CHANGELOG.md#v1830-2023-06-02)
  * **Feature**: This release adds Selective Execution feature that allows SageMaker Pipelines users to run selected steps in a pipeline.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.34.0](service/wafv2/CHANGELOG.md#v1340-2023-06-02)
  * **Feature**: Added APIs to describe managed products. The APIs retrieve information about rule groups that are managed by AWS and by AWS Marketplace sellers.

# Release (2023-06-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/alexaforbusiness`: [v1.15.11](service/alexaforbusiness/CHANGELOG.md#v11511-2023-06-01)
  * **Documentation**: Alexa for Business has been deprecated and is no longer supported.
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.30.0](service/appflow/CHANGELOG.md#v1300-2023-06-01)
  * **Feature**: Added ability to select DataTransferApiType for DescribeConnector and CreateFlow requests when using Async supported connectors. Added supportedDataTransferType to DescribeConnector/DescribeConnectors/ListConnector response.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.24.0](service/customerprofiles/CHANGELOG.md#v1240-2023-06-01)
  * **Feature**: This release introduces calculated attribute related APIs.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.22.0](service/ivs/CHANGELOG.md#v1220-2023-06-01)
  * **Feature**: API Update for IVS Advanced Channel type
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.82.1](service/sagemaker/CHANGELOG.md#v1821-2023-06-01)
  * **Documentation**: Amazon Sagemaker Autopilot adds support for Parquet file input to NLP text classification jobs.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.33.1](service/wafv2/CHANGELOG.md#v1331-2023-06-01)
  * **Documentation**: Corrected the information for the header order FieldToMatch setting

# Release (2023-05-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.33.0](service/configservice/CHANGELOG.md#v1330-2023-05-31)
  * **Feature**: Resource Types Exclusion feature launch by AWS Config
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.24.0](service/frauddetector/CHANGELOG.md#v1240-2023-05-31)
  * **Feature**: This release enables publishing event predictions from Amazon Fraud Detector (AFD) to Amazon EventBridge. For example, after getting predictions from AFD, Amazon EventBridge rules can be configured to trigger notification through an SNS topic, send a message with SES, or trigger Lambda workflows.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.16.0](service/healthlake/CHANGELOG.md#v1160-2023-05-31)
  * **Feature**: This release adds a new request parameter to the CreateFHIRDatastore API operation. IdentityProviderConfiguration specifies how you want to authenticate incoming requests to your Healthlake Data Store.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.5.0](service/m2/CHANGELOG.md#v150-2023-05-31)
  * **Feature**: Adds an optional create-only 'roleArn' property to Application resources.  Enables PS and PO data set org types.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.45.0](service/rds/CHANGELOG.md#v1450-2023-05-31)
  * **Feature**: This release adds support for changing the engine for Oracle using the ModifyDbInstance API
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.18.5](service/servicecatalog/CHANGELOG.md#v1185-2023-05-31)
  * **Documentation**: Documentation updates for ServiceCatalog.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.10.0](service/workspacesweb/CHANGELOG.md#v1100-2023-05-31)
  * **Feature**: WorkSpaces Web now allows you to control which IP addresses your WorkSpaces Web portal may be accessed from.

# Release (2023-05-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.6.0](service/chimesdkvoice/CHANGELOG.md#v160-2023-05-30)
  * **Feature**: Added optional CallLeg field to StartSpeakerSearchTask API request
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.50.0](service/glue/CHANGELOG.md#v1500-2023-05-30)
  * **Feature**: Added Runtime parameter to allow selection of Ray Runtime
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.18.3](service/groundstation/CHANGELOG.md#v1183-2023-05-30)
  * **Documentation**: Updating description of GetMinuteUsage to be clearer.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.4.0](service/iotfleetwise/CHANGELOG.md#v140-2023-05-30)
  * **Feature**: Campaigns now support selecting Timestream or S3 as the data destination, Signal catalogs now support "Deprecation" keyword released in VSS v2.1 and "Comment" keyword released in VSS v3.0
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.23.0](service/location/CHANGELOG.md#v1230-2023-05-30)
  * **Feature**: This release adds API support for political views for the maps service APIs: CreateMap, UpdateMap, DescribeMap.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.13.0](service/memorydb/CHANGELOG.md#v1130-2023-05-30)
  * **Feature**: Amazon MemoryDB for Redis now supports AWS Identity and Access Management authentication access to Redis clusters starting with redis-engine version 7.0
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.24.0](service/personalize/CHANGELOG.md#v1240-2023-05-30)
  * **Feature**: This release provides support for the exclusion of certain columns for training when creating a solution and creating or updating a recommender with Amazon Personalize.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.26.0](service/polly/CHANGELOG.md#v1260-2023-05-30)
  * **Feature**: Amazon Polly adds 2 new voices - Sofie (da-DK) and Niamh (en-IE)
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.32.0](service/securityhub/CHANGELOG.md#v1320-2023-05-30)
  * **Feature**: Added new resource detail objects to ASFF, including resources for AwsGuardDutyDetector, AwsAmazonMqBroker, AwsEventSchemasRegistry, AwsAppSyncGraphQlApi and AwsStepFunctionStateMachine.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.4.0](service/securitylake/CHANGELOG.md#v140-2023-05-30)
  * **Feature**: Log sources are now versioned. AWS log sources and custom sources will now come with a version identifier that enables producers to vend multiple schema versions to subscribers. Security Lake API have been refactored to more closely align with AWS API conventions.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.33.0](service/wafv2/CHANGELOG.md#v1330-2023-05-30)
  * **Feature**: This SDK release provides customers the ability to use Header Order as a field to match.

# Release (2023-05-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.57.0](service/connect/CHANGELOG.md#v1570-2023-05-26)
  * **Feature**: Documentation update for a new Initiation Method value in DescribeContact API
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.28.0](service/iotwireless/CHANGELOG.md#v1280-2023-05-26)
  * **Feature**: Add Multicast Group support in Network Analyzer Configuration.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.82.0](service/sagemaker/CHANGELOG.md#v1820-2023-05-26)
  * **Feature**: Added ml.p4d and ml.inf1 as supported instance type families for SageMaker Notebook Instances.

# Release (2023-05-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.21.0](service/applicationautoscaling/CHANGELOG.md#v1210-2023-05-25)
  * **Feature**: With this release, ElastiCache customers will be able to use predefined metricType "ElastiCacheDatabaseCapacityUsageCountedForEvictPercentage" for their ElastiCache instances.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.15.0](service/codepipeline/CHANGELOG.md#v1150-2023-05-25)
  * **Feature**: Add PollingDisabledAt time information in PipelineMetadata object of GetPipeline API.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.19.0](service/gamelift/CHANGELOG.md#v1190-2023-05-25)
  * **Feature**: GameLift FleetIQ users can now filter game server claim requests to exclude servers on instances that are draining.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.49.0](service/glue/CHANGELOG.md#v1490-2023-05-25)
  * **Feature**: Added ability to create data quality rulesets for shared, cross-account Glue Data Catalog tables. Added support for dataset comparison rules through a new parameter called AdditionalDataSources. Enhanced the data quality results with a map containing profiled metric values.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.10.0](service/migrationhubrefactorspaces/CHANGELOG.md#v1100-2023-05-25)
  * **Feature**: This SDK update allows for path parameter syntax to be passed to the CreateRoute API. Path parameter syntax require parameters to be enclosed in {} characters. This update also includes a new AppendSourcePath field which lets users forward the source path to the Service URL endpoint.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.81.0](service/sagemaker/CHANGELOG.md#v1810-2023-05-25)
  * **Feature**: Amazon SageMaker Automatic Model Tuning now supports enabling Autotune for tuning jobs which can choose tuning job configurations.

# Release (2023-05-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.21.0](service/appsync/CHANGELOG.md#v1210-2023-05-24)
  * **Feature**: This release introduces AppSync Merged APIs, which provide the ability to compose multiple source APIs into a single federated/merged API.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.56.0](service/connect/CHANGELOG.md#v1560-2023-05-24)
  * **Feature**: Amazon Connect Evaluation Capabilities: validation improvements
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.16.0](service/costandusagereportservice/CHANGELOG.md#v1160-2023-05-24)
  * **Feature**: Add support for split cost allocation data on a report.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.80.0](service/sagemaker/CHANGELOG.md#v1800-2023-05-24)
  * **Feature**: SageMaker now provides an instantaneous deployment recommendation through the DescribeModel API

# Release (2023-05-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.24.0](service/fms/CHANGELOG.md#v1240-2023-05-23)
  * **Feature**: Fixes issue that could cause calls to GetAdminScope and ListAdminAccountsForOrganization to return a 500 Internal Server error.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.79.0](service/sagemaker/CHANGELOG.md#v1790-2023-05-23)
  * **Feature**: Added ModelNameEquals, ModelPackageVersionArnEquals in request and ModelName, SamplePayloadUrl, ModelPackageVersionArn in response of ListInferenceRecommendationsJobs API. Added Invocation timestamps in response of DescribeInferenceRecommendationsJob API & ListInferenceRecommendationsJobSteps API.
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.18.0](service/translate/CHANGELOG.md#v1180-2023-05-23)
  * **Feature**: Added support for calling TranslateDocument API.

# Release (2023-05-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.22.0](service/backup/CHANGELOG.md#v1220-2023-05-22)
  * **Feature**: Added support for tags on restore.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.19.2](service/pinpoint/CHANGELOG.md#v1192-2023-05-22)
  * **Documentation**: Amazon Pinpoint is deprecating the tags parameter in the UpdateSegment, UpdateCampaign, UpdateEmailTemplate, UpdateSmsTemplate, UpdatePushTemplate, UpdateInAppTemplate and UpdateVoiceTemplate. Amazon Pinpoint will end support tags parameter by May 22, 2023.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.36.0](service/quicksight/CHANGELOG.md#v1360-2023-05-22)
  * **Feature**: Add support for Asset Bundle, Geospatial Heatmaps.

# Release (2023-05-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.21.0](service/backup/CHANGELOG.md#v1210-2023-05-19)
  * **Feature**: Add  ResourceArn, ResourceType, and BackupVaultName to ListRecoveryPointsByLegalHold API response.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.4.0](service/connectcases/CHANGELOG.md#v140-2023-05-19)
  * **Feature**: This release adds the ability to create fields with type Url through the CreateField API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `github.com/aws/aws-sdk-go-v2/service/mediapackagev2`: [v1.0.0](service/mediapackagev2/CHANGELOG.md#v100-2023-05-19)
  * **Release**: New AWS service client module
  * **Feature**: Adds support for the MediaPackage Live v2 API
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.18.0](service/sesv2/CHANGELOG.md#v1180-2023-05-19)
  * **Feature**: This release allows customers to update scaling mode property of dedicated IP pools with PutDedicatedIpPoolScalingAttributes call.

# Release (2023-05-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.28.0](service/athena/CHANGELOG.md#v1280-2023-05-18)
  * **Feature**: Removing SparkProperties from EngineConfiguration object for StartSession API call
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.25.0](service/cloudtrail/CHANGELOG.md#v1250-2023-05-18)
  * **Feature**: Add ConflictException to PutEventSelectors, add (Channel/EDS)ARNInvalidException to Tag APIs. These exceptions provide customers with more specific error messages instead of internal errors.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.24.0](service/computeoptimizer/CHANGELOG.md#v1240-2023-05-18)
  * **Feature**: In this launch, we add support for showing integration status with external metric providers such as Instana, Datadog ...etc in GetEC2InstanceRecommendations and ExportEC2InstanceRecommendations apis
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.55.0](service/connect/CHANGELOG.md#v1550-2023-05-18)
  * **Feature**: You can programmatically create and manage prompts using APIs, for example, to extract prompts stored within Amazon Connect and add them to your Amazon S3 bucket. AWS CloudTrail, AWS CloudFormation and tagging are supported.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.98.0](service/ec2/CHANGELOG.md#v1980-2023-05-18)
  * **Feature**: Add support for i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge and i4g.16xlarge instances powered by AWS Graviton2 processors that deliver up to 15% better compute performance than our other storage-optimized instances.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.27.1](service/ecs/CHANGELOG.md#v1271-2023-05-18)
  * **Documentation**: Documentation only release to address various tickets.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.37.0](service/mediaconvert/CHANGELOG.md#v1370-2023-05-18)
  * **Feature**: This release introduces a new MXF Profile for XDCAM which is strictly compliant with the SMPTE RDD 9 standard and improved handling of output name modifiers.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.44.1](service/rds/CHANGELOG.md#v1441-2023-05-18)
  * **Documentation**: RDS documentation update for the EngineVersion parameter of ModifyDBSnapshot
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.3.0](service/sagemakergeospatial/CHANGELOG.md#v130-2023-05-18)
  * **Feature**: This release makes ExecutionRoleArn a required field in the StartEarthObservationJob API.

# Release (2023-05-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.19.0](service/detective/CHANGELOG.md#v1190-2023-05-16)
  * **Feature**: Added and updated API operations in Detective to support the integration of ASFF Security Hub findings.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.18.14](service/directconnect/CHANGELOG.md#v11814-2023-05-16)
  * **Documentation**: This release includes an update to the mtu value for CreateTransitVirtualInterface from 9001 mtu to 8500 mtu.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.48.0](service/glue/CHANGELOG.md#v1480-2023-05-16)
  * **Feature**: Add Support for Tags for Custom Entity Types
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.19.8](service/secretsmanager/CHANGELOG.md#v1198-2023-05-16)
  * **Documentation**: Documentation updates for Secrets Manager
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.32.0](service/wafv2/CHANGELOG.md#v1320-2023-05-16)
  * **Feature**: My AWS Service (placeholder) - You can now rate limit web requests based on aggregation keys other than IP addresses, and you can aggregate using combinations of keys. You can also rate limit all requests that match a scope-down statement, without further aggregation.

# Release (2023-05-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.27.0](service/athena/CHANGELOG.md#v1270-2023-05-15)
  * **Feature**: You can now define custom spark properties at start of the session for use cases like cluster encryption, table formats, and general Spark tuning.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.3.0](service/codecatalyst/CHANGELOG.md#v130-2023-05-15)
  * **Feature**: With this release, the users can list the active sessions connected to their Dev Environment on AWS CodeCatalyst
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.28.0](service/rekognition/CHANGELOG.md#v1280-2023-05-15)
  * **Feature**: This release adds a new EyeDirection attribute in Amazon Rekognition DetectFaces and IndexFaces APIs which predicts the yaw and pitch angles of a person's eye gaze direction for each face detected in the image.
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.2.0](service/rolesanywhere/CHANGELOG.md#v120-2023-05-15)
  * **Feature**: Adds support for custom notification settings in a trust anchor. Introduces PutNotificationSettings and ResetNotificationSettings API's. Updates DurationSeconds max value to 3600.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.29.0](service/transfer/CHANGELOG.md#v1290-2023-05-15)
  * **Feature**: This release introduces the ability to require both password and SSH key when users authenticate to your Transfer Family servers that use the SFTP protocol.

# Release (2023-05-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.54.2](service/connect/CHANGELOG.md#v1542-2023-05-11)
  * **Documentation**: This release updates GetMetricDataV2 API, to support metric data up-to last 35 days
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.27.0](service/elasticache/CHANGELOG.md#v1270-2023-05-11)
  * **Feature**: Added support to modify the cluster mode configuration for the existing ElastiCache ReplicationGroups. Customers can now modify the configuration from cluster mode disabled to cluster mode enabled.
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.19.0](service/elasticsearchservice/CHANGELOG.md#v1190-2023-05-11)
  * **Feature**: This release fixes DescribePackages API error with null filter value parameter.
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.17.0](service/health/CHANGELOG.md#v1170-2023-05-11)
  * **Feature**: Add support for regional endpoints
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.2.0](service/ivsrealtime/CHANGELOG.md#v120-2023-05-11)
  * **Feature**: Add methods for inspecting and debugging stages: ListStageSessions, GetStageSession, ListParticipants, GetParticipant, and ListParticipantEvents.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.4.0](service/omics/CHANGELOG.md#v140-2023-05-11)
  * **Feature**: This release provides support for Ready2Run and GPU workflows, an improved read set filter, the direct upload of read sets into Omics Storage, and annotation parsing for analytics stores.
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.15.0](service/support/CHANGELOG.md#v1150-2023-05-11)
  * **Feature**: This release adds 2 new Support APIs, DescribeCreateCaseOptions and DescribeSupportedLanguages. You can use these new APIs to get available support languages.

# Release (2023-05-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.25.0](service/emr/CHANGELOG.md#v1250-2023-05-10)
  * **Feature**: EMR Studio now supports programmatically executing a Notebooks on an EMR on EKS cluster.  In addition, notebooks can now be executed by specifying its location in S3.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.44.0](service/rds/CHANGELOG.md#v1440-2023-05-10)
  * **Feature**: Amazon Relational Database Service (RDS) updates for the new Aurora I/O-Optimized storage type for Amazon Aurora DB clusters
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.15.0](service/swf/CHANGELOG.md#v1150-2023-05-10)
  * **Feature**: This release adds a new API parameter to exclude old history events from decision tasks.

# Release (2023-05-09)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.20.0](service/applicationautoscaling/CHANGELOG.md#v1200-2023-05-09)
  * **Feature**: With this release, Amazon SageMaker Serverless Inference customers can use Application Auto Scaling to auto scale the provisioned concurrency of their serverless endpoints.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.47.0](service/glue/CHANGELOG.md#v1470-2023-05-09)
  * **Feature**: This release adds AmazonRedshift Source and Target nodes in addition to DynamicTransform OutputSchemas
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.78.0](service/sagemaker/CHANGELOG.md#v1780-2023-05-09)
  * **Feature**: This release includes support for (1) Provisioned Concurrency for Amazon SageMaker Serverless Inference and (2) UpdateEndpointWeightsAndCapacities API for Serverless endpoints.

# Release (2023-05-08)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.46.0](service/glue/CHANGELOG.md#v1460-2023-05-08)
  * **Feature**: Support large worker types G.4x and G.8x for Glue Spark
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.23.0](service/guardduty/CHANGELOG.md#v1230-2023-05-08)
  * **Feature**: Add AccessDeniedException 403 Error message code to support 3 Tagging related APIs
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.29.0](service/iotsitewise/CHANGELOG.md#v1290-2023-05-08)
  * **Feature**: Provide support for 20,000 max results for GetAssetPropertyValueHistory/BatchGetAssetPropertyValueHistory and 15 minute aggregate resolution for GetAssetPropertyAggregates/BatchGetAssetPropertyAggregates
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.19.0](service/sts/CHANGELOG.md#v1190-2023-05-08)
  * **Feature**: Documentation updates for AWS Security Token Service.

# Release (2023-05-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.97.0](service/ec2/CHANGELOG.md#v1970-2023-05-05)
  * **Feature**: This release adds support the inf2 and trn1n instances. inf2 instances are purpose built for deep learning inference while trn1n instances are powered by AWS Trainium accelerators and they build on the capabilities of Trainium-powered trn1 instances.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.13.0](service/inspector2/CHANGELOG.md#v1130-2023-05-05)
  * **Feature**: Amazon Inspector now allows customers to search its vulnerability intelligence database if any of the Inspector scanning types are activated.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.23.0](service/mediatailor/CHANGELOG.md#v1230-2023-05-05)
  * **Feature**: This release adds support for AFTER_LIVE_EDGE mode configuration for avail suppression, and adding a fill-policy setting that sets the avail suppression to PARTIAL_AVAIL or FULL_AVAIL_ONLY when AFTER_LIVE_EDGE is enabled.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.22.0](service/sqs/CHANGELOG.md#v1220-2023-05-05)
  * **Feature**: Revert previous SQS protocol change.

# Release (2023-05-04)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.26.0](service/cloudwatch/CHANGELOG.md#v1260-2023-05-04)
  * **Feature**: Adds support for filtering by metric names in CloudWatch Metric Streams.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.32.0](service/configservice/CHANGELOG.md#v1320-2023-05-04)
  * **Feature**: Updated ResourceType enum with new resource types onboarded by AWS Config in April 2023.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.54.1](service/connect/CHANGELOG.md#v1541-2023-05-04)
  * **Documentation**: Remove unused InvalidParameterException from CreateParticipant API
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.27.0](service/ecs/CHANGELOG.md#v1270-2023-05-04)
  * **Feature**: Documentation update for new error type NamespaceNotFoundException for CreateCluster and UpdateCluster
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.28.0](service/networkfirewall/CHANGELOG.md#v1280-2023-05-04)
  * **Feature**: This release adds support for the Suricata REJECT option in midstream exception configurations.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.17.0](service/opensearch/CHANGELOG.md#v1170-2023-05-04)
  * **Feature**: DescribeDomainNodes: A new API that provides configuration information for nodes part of the domain
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.35.0](service/quicksight/CHANGELOG.md#v1350-2023-05-04)
  * **Feature**: Add support for Topic, Dataset parameters and VPC
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.27.0](service/rekognition/CHANGELOG.md#v1270-2023-05-04)
  * **Feature**: This release adds a new attribute FaceOccluded. Additionally, you can now select attributes individually (e.g. ["DEFAULT", "FACE_OCCLUDED", "AGE_RANGE"] instead of ["ALL"]), which can reduce response time.
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.33.1](service/s3/CHANGELOG.md#v1331-2023-05-04)
  * **Documentation**: Documentation updates for Amazon S3
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.77.0](service/sagemaker/CHANGELOG.md#v1770-2023-05-04)
  * **Feature**: We added support for ml.inf2 and ml.trn1 family of instances on Amazon SageMaker for deploying machine learning (ML) models for Real-time and Asynchronous inference. You can use these instances to achieve high performance at a low cost for generative artificial intelligence (AI) models.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.31.0](service/securityhub/CHANGELOG.md#v1310-2023-05-04)
  * **Feature**: Add support for Finding History.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.21.0](service/sqs/CHANGELOG.md#v1210-2023-05-04)
  * **Feature**: This release enables customers to call SQS using AWS JSON-1.0 protocol.

# Release (2023-05-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.20.0](service/appsync/CHANGELOG.md#v1200-2023-05-03)
  * **Feature**: Private API support for AWS AppSync. With Private APIs, you can now create GraphQL APIs that can only be accessed from your Amazon Virtual Private Cloud ("VPC").
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.96.0](service/ec2/CHANGELOG.md#v1960-2023-05-03)
  * **Feature**: Adds an SDK paginator for GetNetworkInsightsAccessScopeAnalysisFindings
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.12.0](service/inspector2/CHANGELOG.md#v1120-2023-05-03)
  * **Feature**: This feature provides deep inspection for linux based instance
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.12.0](service/iottwinmaker/CHANGELOG.md#v1120-2023-05-03)
  * **Feature**: This release adds a field for GetScene API to return error code and message from dependency services.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.27.0](service/networkfirewall/CHANGELOG.md#v1270-2023-05-03)
  * **Feature**: AWS Network Firewall now supports policy level HOME_NET variable overrides.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.16.0](service/opensearch/CHANGELOG.md#v1160-2023-05-03)
  * **Feature**: Amazon OpenSearch Service adds the option to deploy a domain across multiple Availability Zones, with each AZ containing a complete copy of data and with nodes in one AZ acting as a standby. This option provides 99.99% availability and consistent performance in the event of infrastructure failure.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.20.0](service/wellarchitected/CHANGELOG.md#v1200-2023-05-03)
  * **Feature**: This release deepens integration with AWS Service Catalog AppRegistry to improve workload resource discovery.

# Release (2023-05-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.29.0](service/appflow/CHANGELOG.md#v1290-2023-05-02)
  * **Feature**: This release adds new API to cancel flow executions.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.54.0](service/connect/CHANGELOG.md#v1540-2023-05-02)
  * **Feature**: Amazon Connect Service Rules API update: Added OnContactEvaluationSubmit event source to support user configuring evaluation form rules.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.26.3](service/ecs/CHANGELOG.md#v1263-2023-05-02)
  * **Documentation**: Documentation only update to address Amazon ECS tickets.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.40.0](service/kendra/CHANGELOG.md#v1400-2023-05-02)
  * **Feature**: AWS Kendra now supports configuring document fields/attributes via the GetQuerySuggestions API. You can now base query suggestions on the contents of document fields.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.11.0](service/resiliencehub/CHANGELOG.md#v1110-2023-05-02)
  * **Feature**: This release will improve resource level transparency in applications by discovering previously hidden resources.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.76.0](service/sagemaker/CHANGELOG.md#v1760-2023-05-02)
  * **Feature**: Amazon Sagemaker Autopilot supports training models with sample weights and additional objective metrics.

# Release (2023-05-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.23.0](service/computeoptimizer/CHANGELOG.md#v1230-2023-05-01)
  * **Feature**: support for tag filtering within compute optimizer. ability to filter recommendation results by tag and tag key value pairs. ability to filter by inferred workload type added.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.21.0](service/kms/CHANGELOG.md#v1210-2023-05-01)
  * **Feature**: This release makes the NitroEnclave request parameter Recipient and the response field for CiphertextForRecipient available in AWS SDKs. It also adds the regex pattern for CloudHsmClusterId validation.

# Release (2023-04-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.28.0](service/appflow/CHANGELOG.md#v1280-2023-04-28)
  * **Feature**: Adds Jwt Support for Salesforce Credentials.
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.26.0](service/athena/CHANGELOG.md#v1260-2023-04-28)
  * **Feature**: You can now use capacity reservations on Amazon Athena to run SQL queries on fully-managed compute capacity.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.18.12](service/directconnect/CHANGELOG.md#v11812-2023-04-28)
  * **Documentation**: This release corrects the jumbo frames MTU from 9100 to 8500.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.20.0](service/efs/CHANGELOG.md#v1200-2023-04-28)
  * **Feature**: This release adds PAUSED and PAUSING state as a returned value for DescribeReplicationConfigurations response.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.13.0](service/grafana/CHANGELOG.md#v1130-2023-04-28)
  * **Feature**: This release adds support for the grafanaVersion parameter in CreateWorkspace.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.37.0](service/iot/CHANGELOG.md#v1370-2023-04-28)
  * **Feature**: This release allows AWS IoT Core users to specify a TLS security policy when creating and updating AWS IoT Domain Configurations.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.26.0](service/rekognition/CHANGELOG.md#v1260-2023-04-28)
  * **Feature**: Added support for aggregating moderation labels by video segment timestamps for Stored Video Content Moderation APIs and added additional information about the job to all Stored Video Get API responses.
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.2.0](service/simspaceweaver/CHANGELOG.md#v120-2023-04-28)
  * **Feature**: Added a new CreateSnapshot API. For the StartSimulation API, SchemaS3Location is now optional, added a new SnapshotS3Location parameter. For the DescribeSimulation API, added SNAPSHOT_IN_PROGRESS simulation state, deprecated SchemaError, added new fields: StartError and SnapshotS3Location.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.31.0](service/wafv2/CHANGELOG.md#v1310-2023-04-28)
  * **Feature**: You can now associate a web ACL with a Verified Access instance.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.28.11](service/workspaces/CHANGELOG.md#v12811-2023-04-28)
  * **Documentation**: Added Windows 11 to support Microsoft_Office_2019

# Release (2023-04-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.95.0](service/ec2/CHANGELOG.md#v1950-2023-04-27)
  * **Feature**: This release adds support for AMD SEV-SNP on EC2 instances.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.18.0](service/emrcontainers/CHANGELOG.md#v1180-2023-04-27)
  * **Feature**: This release adds GetManagedEndpointSessionCredentials, a new API that allows customers to generate an auth token to connect to a managed endpoint, enabling features such as self-hosted Jupyter notebooks for EMR on EKS.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.22.0](service/guardduty/CHANGELOG.md#v1220-2023-04-27)
  * **Feature**: Added API support to initiate on-demand malware scan on specific resources.
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.18.0](service/iotdeviceadvisor/CHANGELOG.md#v1180-2023-04-27)
  * **Feature**: AWS IoT Core Device Advisor now supports MQTT over WebSocket. With this update, customers can run all three test suites of AWS IoT Core Device Advisor - qualification, custom, and long duration tests - using Signature Version 4 for MQTT over WebSocket.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.20.0](service/kafka/CHANGELOG.md#v1200-2023-04-27)
  * **Feature**: Amazon MSK has added new APIs that allows multi-VPC private connectivity and cluster policy support for Amazon MSK clusters that simplify connectivity and access between your Apache Kafka clients hosted in different VPCs and AWS accounts and your Amazon MSK clusters.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.34.0](service/lambda/CHANGELOG.md#v1340-2023-04-27)
  * **Feature**: Add Java 17 (java17) support to AWS Lambda
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.0.1](service/osis/CHANGELOG.md#v101-2023-04-27)
  * **Documentation**: Documentation updates for OpenSearch Ingestion
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.15.10](service/qldb/CHANGELOG.md#v11510-2023-04-27)
  * **Documentation**: Documentation updates for Amazon QLDB
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.75.0](service/sagemaker/CHANGELOG.md#v1750-2023-04-27)
  * **Feature**: Added ml.p4d.24xlarge and ml.p4de.24xlarge as supported instances for SageMaker Studio

# Release (2023-04-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/osis`: [v1.0.0](service/osis/CHANGELOG.md#v100-2023-04-26)
  * **Release**: New AWS service client module
  * **Feature**: Initial release for OpenSearch Ingestion

# Release (2023-04-25)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.15.0](service/chimesdkmessaging/CHANGELOG.md#v1150-2023-04-25)
  * **Feature**: Remove non actionable field from UpdateChannelReadMarker and DeleteChannelRequest.  Add precise exceptions to DeleteChannel and DeleteStreamingConfigurations error cases.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.53.0](service/connect/CHANGELOG.md#v1530-2023-04-25)
  * **Feature**: Amazon Connect, Contact Lens Evaluation API release including ability to manage forms and to submit contact evaluations.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.24.0](service/datasync/CHANGELOG.md#v1240-2023-04-25)
  * **Feature**: This release adds 13 new APIs to support AWS DataSync Discovery GA.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.17.0](service/directoryservice/CHANGELOG.md#v1170-2023-04-25)
  * **Feature**: New field added in AWS Managed Microsoft AD DescribeSettings response and regex pattern update for UpdateSettings value.  Added length validation to RemoteDomainName.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.19.0](service/pinpoint/CHANGELOG.md#v1190-2023-04-25)
  * **Feature**: Adds support for journey runs and querying journey execution metrics based on journey runs. Adds execution metrics to campaign activities. Updates docs for Advanced Quiet Time.

# Release (2023-04-24)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.18.0
  * **Feature**: add recursion detection middleware to all SDK requests to avoid recursion invocation in Lambda
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.27.0](service/appflow/CHANGELOG.md#v1270-2023-04-24)
  * **Feature**: Increased the max length for RefreshToken and AuthCode from 2048 to 4096.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.2.5](service/codecatalyst/CHANGELOG.md#v125-2023-04-24)
  * **Documentation**: Documentation updates for Amazon CodeCatalyst.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.94.0](service/ec2/CHANGELOG.md#v1940-2023-04-24)
  * **Feature**: API changes to AWS Verified Access related to identity providers' information.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.36.0](service/mediaconvert/CHANGELOG.md#v1360-2023-04-24)
  * **Feature**: This release introduces a noise reduction pre-filter, linear interpolation deinterlace mode, video pass-through, updated default job settings, and expanded LC-AAC Stereo audio bitrate ranges.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.25.0](service/rekognition/CHANGELOG.md#v1250-2023-04-24)
  * **Feature**: Added new status result to Liveness session status.
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.28.0](service/route53/CHANGELOG.md#v1280-2023-04-24)
  * **Feature**: added paginator for listResourceRecordSets
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.33.0](service/s3/CHANGELOG.md#v1330-2023-04-24)
  * **Feature**: added custom paginators for listMultipartUploads and ListObjectVersions

# Release (2023-04-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.52.0](service/connect/CHANGELOG.md#v1520-2023-04-21)
  * **Feature**: This release adds a new API CreateParticipant. For Amazon Connect Chat, you can use this new API to customize chat flow experiences.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.26.1](service/ecs/CHANGELOG.md#v1261-2023-04-21)
  * **Documentation**: Documentation update to address various Amazon ECS tickets.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.23.0](service/fms/CHANGELOG.md#v1230-2023-04-21)
  * **Feature**: AWS Firewall Manager adds support for multiple administrators. You can now delegate more than one administrator per organization.

# Release (2023-04-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.23.0](service/chime/CHANGELOG.md#v1230-2023-04-20)
  * **Feature**: Adds support for Hindi and Thai languages and additional Amazon Transcribe parameters to the StartMeetingTranscription API.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.4.0](service/chimesdkmediapipelines/CHANGELOG.md#v140-2023-04-20)
  * **Feature**: This release adds support for specifying the recording file format in an S3 recording sink configuration.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.15.0](service/chimesdkmeetings/CHANGELOG.md#v1150-2023-04-20)
  * **Feature**: Adds support for Hindi and Thai languages and additional Amazon Transcribe parameters to the StartMeetingTranscription API.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.18.0](service/gamelift/CHANGELOG.md#v1180-2023-04-20)
  * **Feature**: Amazon GameLift supports creating Builds for Windows 2016 operating system.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.21.0](service/guardduty/CHANGELOG.md#v1210-2023-04-20)
  * **Feature**: This release adds support for the new Lambda Protection feature.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.36.0](service/iot/CHANGELOG.md#v1360-2023-04-20)
  * **Feature**: Support additional OTA states in GetOTAUpdate API
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.74.0](service/sagemaker/CHANGELOG.md#v1740-2023-04-20)
  * **Feature**: Amazon SageMaker Canvas adds ModelRegisterSettings support for CanvasAppSettings.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.19.0](service/snowball/CHANGELOG.md#v1190-2023-04-20)
  * **Feature**: Adds support for Amazon S3 compatible storage. AWS Snow Family customers can now use Amazon S3 compatible storage on Snowball Edge devices. Also adds support for V3_5S. This is a refreshed AWS Snowball Edge Storage Optimized device type with 210TB SSD (customer usable).
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.30.0](service/wafv2/CHANGELOG.md#v1300-2023-04-20)
  * **Feature**: You can now create encrypted API keys to use in a client application integration of the JavaScript CAPTCHA API . You can also retrieve a list of your API keys and the JavaScript application integration URL.

# Release (2023-04-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.24.0](service/comprehend/CHANGELOG.md#v1240-2023-04-19)
  * **Feature**: This release supports native document models for custom classification, in addition to plain-text models. You train native document models using documents (PDF, Word, images) in their native format.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.26.0](service/ecs/CHANGELOG.md#v1260-2023-04-19)
  * **Feature**: This release supports the Account Setting "TagResourceAuthorization" that allows for enhanced Tagging security controls.
* `github.com/aws/aws-sdk-go-v2/service/ram`: [v1.18.0](service/ram/CHANGELOG.md#v1180-2023-04-19)
  * **Feature**: This release adds support for customer managed permissions. Customer managed permissions enable customers to author and manage tailored permissions for resources shared using RAM.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.43.1](service/rds/CHANGELOG.md#v1431-2023-04-19)
  * **Documentation**: Adds support for the ImageId parameter of CreateCustomDBEngineVersion to RDS Custom for Oracle
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.32.0](service/s3/CHANGELOG.md#v1320-2023-04-19)
  * **Feature**: Provides support for "Snow" Storage class.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.19.4](service/secretsmanager/CHANGELOG.md#v1194-2023-04-19)
  * **Documentation**: Documentation updates for Secrets Manager

# Release (2023-04-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.26.0](service/appflow/CHANGELOG.md#v1260-2023-04-17)
  * **Feature**: This release adds a Client Token parameter to the following AppFlow APIs: Create/Update Connector Profile, Create/Update Flow, Start Flow, Register Connector, Update Connector Registration. The Client Token parameter allows idempotent operations for these APIs.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.13.0](service/drs/CHANGELOG.md#v1130-2023-04-17)
  * **Feature**: Changed existing APIs and added new APIs to support using an account-level launch configuration template with AWS Elastic Disaster Recovery.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.19.5](service/dynamodb/CHANGELOG.md#v1195-2023-04-17)
  * **Documentation**: Documentation updates for DynamoDB API
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.7.0](service/emrserverless/CHANGELOG.md#v170-2023-04-17)
  * **Feature**: The GetJobRun API has been updated to include the job's billed resource utilization. This utilization shows the aggregate vCPU, memory and storage that AWS has billed for the job run. The billed resources include a 1-minute minimum usage for workers, plus additional storage over 20 GB per worker.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.2.0](service/internetmonitor/CHANGELOG.md#v120-2023-04-17)
  * **Feature**: This release includes a new configurable value, TrafficPercentageToMonitor, which allows users to adjust the amount of traffic monitored by percentage
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.27.0](service/iotwireless/CHANGELOG.md#v1270-2023-04-17)
  * **Feature**: Supports the new feature of LoRaWAN roaming, allows to configure MaxEirp for LoRaWAN gateway, and allows to configure PingSlotPeriod for LoRaWAN multicast group
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.33.0](service/lambda/CHANGELOG.md#v1330-2023-04-17)
  * **Feature**: Add Python 3.10 (python3.10) support to AWS Lambda

# Release (2023-04-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.25.1](service/ecs/CHANGELOG.md#v1251-2023-04-14)
  * **Documentation**: This release supports  ephemeral storage for AWS Fargate Windows containers.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.32.0](service/lambda/CHANGELOG.md#v1320-2023-04-14)
  * **Feature**: This release adds SnapStart related exceptions to InvokeWithResponseStream API. IAM access related documentation is also added for this API.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.9.8](service/migrationhubrefactorspaces/CHANGELOG.md#v198-2023-04-14)
  * **Documentation**: Doc only update for Refactor Spaces environments without network bridge feature.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.43.0](service/rds/CHANGELOG.md#v1430-2023-04-14)
  * **Feature**: This release adds support of modifying the engine mode of database clusters.

# Release (2023-04-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.5.0](service/chimesdkvoice/CHANGELOG.md#v150-2023-04-13)
  * **Feature**: This release adds tagging support for Voice Connectors and SIP Media Applications
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.19.0](service/mediaconnect/CHANGELOG.md#v1190-2023-04-13)
  * **Feature**: Gateway is a new feature of AWS Elemental MediaConnect. Gateway allows the deployment of on-premises resources for the purpose of transporting live video to and from the AWS Cloud.

# Release (2023-04-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.18.0](service/groundstation/CHANGELOG.md#v1180-2023-04-12)
  * **Feature**: AWS Ground Station Wideband DigIF GA Release
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.15.5](service/managedblockchain/CHANGELOG.md#v1155-2023-04-12)
  * **Documentation**: Removal of the Ropsten network. The Ethereum foundation ceased support of Ropsten on December 31st, 2022..

# Release (2023-04-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.16.0](service/ecrpublic/CHANGELOG.md#v1160-2023-04-11)
  * **Feature**: This release will allow using registry alias as registryId in BatchDeleteImage request.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.6.0](service/emrserverless/CHANGELOG.md#v160-2023-04-11)
  * **Feature**: This release extends GetJobRun API to return job run timeout (executionTimeoutMinutes) specified during StartJobRun call (or default timeout of 720 minutes if none was specified).
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.19.0](service/eventbridge/CHANGELOG.md#v1190-2023-04-11)
  * **Feature**: EventBridge PutTarget support for multiple SQL arguments on RedshiftDataParameters
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.15.0](service/iotdataplane/CHANGELOG.md#v1150-2023-04-11)
  * **Feature**: This release adds support for MQTT5 user properties when calling the AWS IoT GetRetainedMessage API
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.29.0](service/wafv2/CHANGELOG.md#v1290-2023-04-11)
  * **Feature**: For web ACLs that protect CloudFront protections, the default request body inspection size is now 16 KB, and you can use the new association configuration to increase the inspection size further, up to 64 KB. Sizes over 16 KB can incur additional costs.

# Release (2023-04-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.51.0](service/connect/CHANGELOG.md#v1510-2023-04-10)
  * **Feature**: This release adds the ability to configure an agent's routing profile to receive contacts from multiple channels at the same time via extending the UpdateRoutingProfileConcurrency, CreateRoutingProfile and DescribeRoutingProfile APIs.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.25.0](service/ecs/CHANGELOG.md#v1250-2023-04-10)
  * **Feature**: This release adds support for enabling FIPS compliance on Amazon ECS Fargate tasks
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.16.0](service/marketplacecatalog/CHANGELOG.md#v1160-2023-04-10)
  * **Feature**: Added three new APIs to support resource sharing: GetResourcePolicy, PutResourcePolicy, and DeleteResourcePolicy. Added new OwnershipType field to ListEntities request to let users filter on entities that are shared with them. Increased max page size of ListEntities response from 20 to 50 results.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.35.0](service/mediaconvert/CHANGELOG.md#v1350-2023-04-10)
  * **Feature**: AWS Elemental MediaConvert SDK now supports conversion of 608 paint-on captions to pop-on captions for SCC sources.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.3.0](service/omics/CHANGELOG.md#v130-2023-04-10)
  * **Feature**: Remove unexpected API changes.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.24.0](service/rekognition/CHANGELOG.md#v1240-2023-04-10)
  * **Feature**: This release adds support for Face Liveness APIs in Amazon Rekognition. Updates UpdateStreamProcessor to return ResourceInUseException Exception. Minor updates to API documentation.

# Release (2023-04-07)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.15.0](service/dlm/CHANGELOG.md#v1150-2023-04-07)
  * **Announcement**: This release includes breaking changes for the timestamp trait on the data lifecycle management client.
  * **Feature**: Updated timestamp format for GetLifecyclePolicy API
  * **Bug Fix**: Correct timestamp type for data lifecycle manager.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.21.0](service/docdb/CHANGELOG.md#v1210-2023-04-07)
  * **Feature**: This release adds a new parameter 'DBClusterParameterGroupName' to 'RestoreDBClusterFromSnapshot' API to associate the name of the DB cluster parameter group while performing restore.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.28.8](service/fsx/CHANGELOG.md#v1288-2023-04-07)
  * **Documentation**: Amazon FSx for Lustre now supports creating data repository associations on Persistent_1 and Scratch_2 file systems.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.31.0](service/lambda/CHANGELOG.md#v1310-2023-04-07)
  * **Feature**: This release adds a new Lambda InvokeWithResponseStream API to support streaming Lambda function responses. The release also adds a new InvokeMode parameter to Function Url APIs to control whether the response will be streamed or buffered.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.34.0](service/quicksight/CHANGELOG.md#v1340-2023-04-07)
  * **Feature**: This release has two changes: adding the OR condition to tag-based RLS rules in CreateDataSet and UpdateDataSet; adding RefreshSchedule and Incremental RefreshProperties operations for users to programmatically configure SPICE dataset ingestions.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.19.3](service/redshiftdata/CHANGELOG.md#v1193-2023-04-07)
  * **Documentation**: Update documentation of API descriptions as needed in support of temporary credentials with IAM identity.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.18.1](service/servicecatalog/CHANGELOG.md#v1181-2023-04-07)
  * **Documentation**: Updates description for property

# Release (2023-04-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.27.0](service/cloudformation/CHANGELOG.md#v1270-2023-04-06)
  * **Feature**: Including UPDATE_COMPLETE as a failed status for DeleteStack waiter.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.22.0](service/greengrassv2/CHANGELOG.md#v1220-2023-04-06)
  * **Feature**: Add support for SUCCEEDED value in coreDeviceExecutionStatus field. Documentation updates for Greengrass V2.
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.21.0](service/proton/CHANGELOG.md#v1210-2023-04-06)
  * **Feature**: This release adds support for the AWS Proton service sync feature. Service sync enables managing an AWS Proton service (creating and updating instances) and all of it's corresponding service instances from a Git repository.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.42.1](service/rds/CHANGELOG.md#v1421-2023-04-06)
  * **Documentation**: Adds and updates the SDK examples

# Release (2023-04-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.31.0](service/configservice/CHANGELOG.md#v1310-2023-04-05)
  * **Feature**: This release adds resourceType enums for types released in March 2023.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.24.3](service/ecs/CHANGELOG.md#v1243-2023-04-05)
  * **Documentation**: This is a document only updated to add information about Amazon Elastic Inference (EI).
* `github.com/aws/aws-sdk-go-v2/service/identitystore`: [v1.16.7](service/identitystore/CHANGELOG.md#v1167-2023-04-05)
  * **Documentation**: Documentation updates for Identity Store CLI command reference.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.1.0](service/ivsrealtime/CHANGELOG.md#v110-2023-04-05)
  * **Feature**: Fix ParticipantToken ExpirationTime format
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.26.0](service/networkfirewall/CHANGELOG.md#v1260-2023-04-05)
  * **Feature**: AWS Network Firewall now supports IPv6-only subnets.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.18.0](service/servicecatalog/CHANGELOG.md#v1180-2023-04-05)
  * **Feature**: removed incorrect product type value
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.0.1](service/vpclattice/CHANGELOG.md#v101-2023-04-05)
  * **Documentation**: This release removes the entities in the API doc model package for auth policies.

# Release (2023-04-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.10.0](service/amplifyuibuilder/CHANGELOG.md#v1100-2023-04-04)
  * **Feature**: Support StorageField and custom displays for data-bound options in form builder. Support non-string operands for predicates in collections. Support choosing client to get token from.
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.28.1](service/autoscaling/CHANGELOG.md#v1281-2023-04-04)
  * **Documentation**: Documentation updates for Amazon EC2 Auto Scaling
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.93.0](service/ec2/CHANGELOG.md#v1930-2023-04-04)
  * **Feature**: C6in, M6in, M6idn, R6in and R6idn bare metal instances are powered by 3rd Generation Intel Xeon Scalable processors and offer up to 200 Gbps of network bandwidth.
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.13.0](service/elasticinference/CHANGELOG.md#v1130-2023-04-04)
  * **Feature**: Updated public documentation for the Describe and Tagging APIs.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.73.0](service/sagemaker/CHANGELOG.md#v1730-2023-04-04)
  * **Feature**: Amazon SageMaker Asynchronous Inference now allows customer's to receive failure model responses in S3 and receive success/failure model responses in SNS notifications.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.19.0](service/sagemakerruntime/CHANGELOG.md#v1190-2023-04-04)
  * **Feature**: Amazon SageMaker Asynchronous Inference now provides customers a FailureLocation as a response parameter in InvokeEndpointAsync API to capture the model failure responses.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.28.0](service/wafv2/CHANGELOG.md#v1280-2023-04-04)
  * **Feature**: This release rolls back association config feature for webACLs that protect CloudFront protections.

# Release (2023-04-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.45.0](service/glue/CHANGELOG.md#v1450-2023-04-03)
  * **Feature**: Add support for database-level federation
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.21.0](service/lakeformation/CHANGELOG.md#v1210-2023-04-03)
  * **Feature**: Add support for database-level federation
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.18.0](service/licensemanager/CHANGELOG.md#v1180-2023-04-03)
  * **Feature**: This release adds grant override options to the CreateGrantVersion API. These options can be used to specify grant replacement behavior during grant activation.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.15.0](service/mwaa/CHANGELOG.md#v1150-2023-04-03)
  * **Feature**: This Amazon MWAA release adds the ability to customize the Apache Airflow environment by launching a shell script at startup. This shell script is hosted in your environment's Amazon S3 bucket. Amazon MWAA runs the script before installing requirements and initializing the Apache Airflow process.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.17.0](service/servicecatalog/CHANGELOG.md#v1170-2023-04-03)
  * **Feature**: This release introduces Service Catalog support for Terraform open source. It enables 1. The notify* APIs to Service Catalog. These APIs are used by the terraform engine to notify the result of the provisioning engine execution. 2. Adds a new TERRAFORM_OPEN_SOURCE product type in CreateProduct API.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.27.0](service/wafv2/CHANGELOG.md#v1270-2023-04-03)
  * **Feature**: For web ACLs that protect CloudFront protections, the default request body inspection size is now 16 KB, and you can use the new association configuration to increase the inspection size further, up to 64 KB. Sizes over 16 KB can incur additional costs.

# Release (2023-03-31)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.92.1](service/ec2/CHANGELOG.md#v1921-2023-03-31)
  * **Documentation**: Documentation updates for EC2 On Demand Capacity Reservations
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.1.0](service/internetmonitor/CHANGELOG.md#v110-2023-03-31)
  * **Feature**: This release adds a new feature for Amazon CloudWatch Internet Monitor that enables customers to deliver internet measurements to Amazon S3 buckets as well as CloudWatch Logs.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.10.1](service/resiliencehub/CHANGELOG.md#v1101-2023-03-31)
  * **Documentation**: Adding EKS related documentation for appTemplateBody
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.31.1](service/s3/CHANGELOG.md#v1311-2023-03-31)
  * **Documentation**: Documentation updates for Amazon S3
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.14.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1140-2023-03-31)
  * **Feature**: In this release, you can now chose between soft delete and hard delete when calling the DeleteRecord API, so you have more flexibility when it comes to managing online store data.

# Release (2023-03-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.25.0](service/athena/CHANGELOG.md#v1250-2023-03-30)
  * **Feature**: Make DefaultExecutorDpuSize and CoordinatorDpuSize  fields optional  in StartSession
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.28.0](service/autoscaling/CHANGELOG.md#v1280-2023-03-30)
  * **Feature**: Amazon EC2 Auto Scaling now supports Elastic Load Balancing traffic sources with the AttachTrafficSources, DetachTrafficSources, and DescribeTrafficSources APIs. This release also introduces a new activity status, "WaitingForConnectionDraining", for VPC Lattice to the DescribeScalingActivities API.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.23.0](service/batch/CHANGELOG.md#v1230-2023-03-30)
  * **Feature**: This feature allows Batch on EKS to support configuration of Pod Labels through Metadata for Batch on EKS Jobs.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.22.0](service/computeoptimizer/CHANGELOG.md#v1220-2023-03-30)
  * **Feature**: This release adds support for HDD EBS volume types and io2 Block Express. We are also adding support for 61 new instance types and instances that have non consecutive runtime.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.12.0](service/drs/CHANGELOG.md#v1120-2023-03-30)
  * **Feature**: Adding a field to the replication configuration APIs to support the auto replicate new disks feature. We also deprecated RetryDataReplication.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.92.0](service/ec2/CHANGELOG.md#v1920-2023-03-30)
  * **Feature**: This release adds support for Tunnel Endpoint Lifecycle control, a new feature that provides Site-to-Site VPN customers with better visibility and control of their VPN tunnel maintenance updates.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.24.0](service/emr/CHANGELOG.md#v1240-2023-03-30)
  * **Feature**: Updated DescribeCluster and ListClusters API responses to include ErrorDetail that specifies error code, programmatically accessible error data,and an error message. ErrorDetail provides the underlying reason for cluster failure and recommends actions to simplify troubleshooting of EMR clusters.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.44.0](service/glue/CHANGELOG.md#v1440-2023-03-30)
  * **Feature**: This release adds support for AWS Glue Data Quality, which helps you evaluate and monitor the quality of your data and includes the API for creating, deleting, or updating data quality rulesets, runs and evaluations.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.20.0](service/guardduty/CHANGELOG.md#v1200-2023-03-30)
  * **Feature**: Added EKS Runtime Monitoring feature support to existing detector, finding APIs and introducing new Coverage APIs
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.23.0](service/imagebuilder/CHANGELOG.md#v1230-2023-03-30)
  * **Feature**: Adds support for new image workflow details and image vulnerability detection.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.21.0](service/ivs/CHANGELOG.md#v1210-2023-03-30)
  * **Feature**: Amazon Interactive Video Service (IVS) now offers customers the ability to configure IVS channels to allow insecure RTMP ingest.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.39.0](service/kendra/CHANGELOG.md#v1390-2023-03-30)
  * **Feature**: AWS Kendra now supports featured results for a query.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.25.0](service/networkfirewall/CHANGELOG.md#v1250-2023-03-30)
  * **Feature**: AWS Network Firewall added TLS inspection configurations to allow TLS traffic inspection.
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.2.0](service/sagemakergeospatial/CHANGELOG.md#v120-2023-03-30)
  * **Feature**: Amazon SageMaker geospatial capabilities now supports server-side encryption with customer managed KMS key and SageMaker notebooks with a SageMaker geospatial image in a Amazon SageMaker Domain with VPC only mode.
* `github.com/aws/aws-sdk-go-v2/service/vpclattice`: [v1.0.0](service/vpclattice/CHANGELOG.md#v100-2023-03-30)
  * **Release**: New AWS service client module
  * **Feature**: General Availability (GA) release of Amazon VPC Lattice
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.19.0](service/wellarchitected/CHANGELOG.md#v1190-2023-03-30)
  * **Feature**: AWS Well-Architected SDK now supports getting consolidated report metrics and generating a consolidated report PDF.

# Release (2023-03-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.2.0](service/opensearchserverless/CHANGELOG.md#v120-2023-03-29)
  * **Feature**: This release includes two new exception types "ServiceQuotaExceededException" and "OcuLimitExceededException".
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.42.0](service/rds/CHANGELOG.md#v1420-2023-03-29)
  * **Feature**: Add support for creating a read replica DB instance from a Multi-AZ DB cluster.

# Release (2023-03-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.15.0](service/ssmcontacts/CHANGELOG.md#v1150-2023-03-28)
  * **Feature**: This release adds 12 new APIs as part of Oncall Schedule feature release, adds support for a new contact type: ONCALL_SCHEDULE. Check public documentation for AWS ssm-contacts for more information
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.21.0](service/ssmincidents/CHANGELOG.md#v1210-2023-03-28)
  * **Feature**: Increased maximum length of "TriggerDetails.rawData" to 10K characters and "IncidentSummary" to 8K characters.

# Release (2023-03-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.24.0](service/athena/CHANGELOG.md#v1240-2023-03-27)
  * **Feature**: Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.4.0](service/chimesdkvoice/CHANGELOG.md#v140-2023-03-27)
  * **Feature**: Documentation updates for Amazon Chime SDK Voice.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.50.0](service/connect/CHANGELOG.md#v1500-2023-03-27)
  * **Feature**: This release introduces support for RelatedContactId in the StartChatContact API. Interactive message and interactive message response have been added to the list of supported message content types for this API as well.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.15.7](service/connectparticipant/CHANGELOG.md#v1157-2023-03-27)
  * **Documentation**: This release provides an update to the SendMessage API to handle interactive message response content-types.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.26.0](service/iotwireless/CHANGELOG.md#v1260-2023-03-27)
  * **Feature**: Introducing new APIs that enable Sidewalk devices to communicate with AWS IoT Core through Sidewalk gateways. This will empower AWS customers to connect Sidewalk devices with other AWS IoT Services, creating  possibilities for seamless integration and advanced device management.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.31.0](service/medialive/CHANGELOG.md#v1310-2023-03-27)
  * **Feature**: AWS Elemental MediaLive now supports ID3 tag insertion for audio only HLS output groups. AWS Elemental Link devices now support tagging.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.72.1](service/sagemaker/CHANGELOG.md#v1721-2023-03-27)
  * **Documentation**: Fixed some improperly rendered links in SDK documentation.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.30.0](service/securityhub/CHANGELOG.md#v1300-2023-03-27)
  * **Feature**: Added new resource detail objects to ASFF, including resources for AwsEksCluster, AWSS3Bucket, AwsEc2RouteTable and AwsEC2Instance.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.17.0](service/servicecatalogappregistry/CHANGELOG.md#v1170-2023-03-27)
  * **Feature**: In this release, we started supporting ARN in applicationSpecifier and attributeGroupSpecifier. GetAttributeGroup, ListAttributeGroups and ListAttributeGroupsForApplication APIs will now have CreatedBy field in the response.
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.13.0](service/voiceid/CHANGELOG.md#v1130-2023-03-27)
  * **Feature**: Amazon Connect Voice ID now supports multiple fraudster watchlists. Every domain has a default watchlist where all existing fraudsters are placed by default. Custom watchlists may now be created, managed, and evaluated against for known fraudster detection.

# Release (2023-03-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.25.7](service/cloudwatch/CHANGELOG.md#v1257-2023-03-24)
  * **Documentation**: Doc-only update to correct alarm actions list
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.23.0](service/comprehend/CHANGELOG.md#v1230-2023-03-24)
  * **Feature**: This release adds a new field (FlywheelArn) to the EntitiesDetectionJobProperties object. The FlywheelArn field is returned in the DescribeEntitiesDetectionJob and ListEntitiesDetectionJobs responses when the EntitiesDetection job is started with a FlywheelArn instead of an EntityRecognizerArn .
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.41.0](service/rds/CHANGELOG.md#v1410-2023-03-24)
  * **Feature**: Added error code CreateCustomDBEngineVersionFault for when the create custom engine version for Custom engines fails.

# Release (2023-03-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.22.0](service/batch/CHANGELOG.md#v1220-2023-03-23)
  * **Feature**: This feature allows Batch to support configuration of ephemeral storage size for jobs running on FARGATE
* `github.com/aws/aws-sdk-go-v2/service/chimesdkidentity`: [v1.11.0](service/chimesdkidentity/CHANGELOG.md#v1110-2023-03-23)
  * **Feature**: AppInstanceBots can be used to add a bot powered by Amazon Lex to chat channels.  ExpirationSettings provides automatic resource deletion for AppInstanceUsers.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.3.0](service/chimesdkmediapipelines/CHANGELOG.md#v130-2023-03-23)
  * **Feature**: This release adds Amazon Chime SDK call analytics. Call analytics include voice analytics, which provides speaker search and voice tone analysis. These capabilities can be used with Amazon Transcribe and Transcribe Call Analytics to generate machine-learning-powered insights from real-time audio.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.14.0](service/chimesdkmessaging/CHANGELOG.md#v1140-2023-03-23)
  * **Feature**: ExpirationSettings provides automatic resource deletion for Channels.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.3.0](service/chimesdkvoice/CHANGELOG.md#v130-2023-03-23)
  * **Feature**: This release adds Amazon Chime SDK call analytics. Call analytics include voice analytics, which provides speaker search and voice tone analysis. These capabilities can be used with Amazon Transcribe and Transcribe Call Analytics to generate machine-learning-powered insights from real-time audio.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.18.0](service/codeartifact/CHANGELOG.md#v1180-2023-03-23)
  * **Feature**: Repository CreationTime is added to the CreateRepository and ListRepositories API responses.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.19.0](service/guardduty/CHANGELOG.md#v1190-2023-03-23)
  * **Feature**: Adds AutoEnableOrganizationMembers attribute to DescribeOrganizationConfiguration and UpdateOrganizationConfiguration APIs.
* `github.com/aws/aws-sdk-go-v2/service/ivsrealtime`: [v1.0.0](service/ivsrealtime/CHANGELOG.md#v100-2023-03-23)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of the Amazon Interactive Video Service RealTime API.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.34.0](service/mediaconvert/CHANGELOG.md#v1340-2023-03-23)
  * **Feature**: AWS Elemental MediaConvert SDK now supports passthrough of ID3v2 tags for audio inputs to audio-only HLS outputs.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.72.0](service/sagemaker/CHANGELOG.md#v1720-2023-03-23)
  * **Feature**: Amazon SageMaker Autopilot adds two new APIs - CreateAutoMLJobV2 and DescribeAutoMLJobV2. Amazon SageMaker Notebook Instances now supports the ml.geospatial.interactive instance type.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.21.0](service/servicediscovery/CHANGELOG.md#v1210-2023-03-23)
  * **Feature**: Reverted the throttling exception RequestLimitExceeded for AWS Cloud Map APIs introduced in SDK version 1.12.424 2023-03-09 to previous exception specified in the ErrorCode.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.21.0](service/textract/CHANGELOG.md#v1210-2023-03-23)
  * **Feature**: The AnalyzeDocument - Tables feature adds support for new elements in the API: table titles, footers, section titles, summary cells/tables, and table type.

# Release (2023-03-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.19.8](service/iam/CHANGELOG.md#v1198-2023-03-22)
  * **Documentation**: Documentation updates for AWS Identity and Access Management (IAM).
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.11.0](service/iottwinmaker/CHANGELOG.md#v1110-2023-03-22)
  * **Feature**: This release adds support of adding metadata when creating a new scene or updating an existing scene.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.17.8](service/networkmanager/CHANGELOG.md#v1178-2023-03-22)
  * **Documentation**: This release includes an update to create-transit-gateway-route-table-attachment, showing example usage for TransitGatewayRouteTableArn.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.10.0](service/resiliencehub/CHANGELOG.md#v1100-2023-03-22)
  * **Feature**: This release provides customers with the ability to import resources from within an EKS cluster and assess the resiliency of EKS cluster workloads.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.36.0](service/ssm/CHANGELOG.md#v1360-2023-03-22)
  * **Feature**: This Patch Manager release supports creating, updating, and deleting Patch Baselines for AmazonLinux2023, AlmaLinux.

# Release (2023-03-21)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.13.0](service/chimesdkmessaging/CHANGELOG.md#v1130-2023-03-21)
  * **Feature**: Amazon Chime SDK messaging customers can now manage streaming configuration for messaging data for archival and analysis.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.1.0](service/cleanrooms/CHANGELOG.md#v110-2023-03-21)
  * **Feature**: GA Release of AWS Clean Rooms, Added Tagging Functionality
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.91.0](service/ec2/CHANGELOG.md#v1910-2023-03-21)
  * **Feature**: This release adds support for AWS Network Firewall, AWS PrivateLink, and Gateway Load Balancers to Amazon VPC Reachability Analyzer, and it makes the path destination optional as long as a destination address in the filter at source is provided.
* `github.com/aws/aws-sdk-go-v2/service/internal/s3shared`: [v1.14.0](service/internal/s3shared/CHANGELOG.md#v1140-2023-03-21)
  * **Feature**: port v1 sdk 100-continue http header customization for s3 PutObject/UploadPart request and enable user config
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.28.0](service/iotsitewise/CHANGELOG.md#v1280-2023-03-21)
  * **Feature**: Provide support for tagging of data streams and enabling tag based authorization for property alias
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.18.0](service/mgn/CHANGELOG.md#v1180-2023-03-21)
  * **Feature**: This release introduces the Import and export feature and expansion of the post-launch actions
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.31.0](service/s3/CHANGELOG.md#v1310-2023-03-21)
  * **Feature**: port v1 sdk 100-continue http header customization for s3 PutObject/UploadPart request and enable user config

# Release (2023-03-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.19.0](service/applicationautoscaling/CHANGELOG.md#v1190-2023-03-20)
  * **Feature**: With this release customers can now tag their Application Auto Scaling registered targets with key-value pairs and manage IAM permissions for all the tagged resources centrally.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.20.0](service/neptune/CHANGELOG.md#v1200-2023-03-20)
  * **Feature**: This release makes following few changes. db-cluster-identifier is now a required parameter of create-db-instance. describe-db-cluster will now return PendingModifiedValues and GlobalClusterIdentifier fields in the response.
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.16.0](service/s3outposts/CHANGELOG.md#v1160-2023-03-20)
  * **Feature**: S3 On Outposts added support for endpoint status, and a failed endpoint reason, if any
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.14.0](service/workdocs/CHANGELOG.md#v1140-2023-03-20)
  * **Feature**: This release adds a new API, SearchResources, which enable users to search through metadata and content of folders, documents, document versions and comments in a WorkDocs site.

# Release (2023-03-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.6.0](service/billingconductor/CHANGELOG.md#v160-2023-03-17)
  * **Feature**: This release adds a new filter to ListAccountAssociations API and a new filter to ListBillingGroups API.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.30.0](service/configservice/CHANGELOG.md#v1300-2023-03-17)
  * **Feature**: This release adds resourceType enums for types released from October 2022 through February 2023.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.25.0](service/databasemigrationservice/CHANGELOG.md#v1250-2023-03-17)
  * **Feature**: S3 setting to create AWS Glue Data Catalog. Oracle setting to control conversion of timestamp column. Support for Kafka SASL Plain authentication. Setting to map boolean from PostgreSQL to Redshift. SQL Server settings to force lob lookup on inline LOBs and to control access of database logs.

# Release (2023-03-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/config`: [v1.18.18](config/CHANGELOG.md#v11818-2023-03-16)
  * **Bug Fix**: Allow RoleARN to be set as functional option on STS WebIdentityRoleOptions. Fixes aws/aws-sdk-go-v2#2015.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.18.0](service/guardduty/CHANGELOG.md#v1180-2023-03-16)
  * **Feature**: Updated 9 APIs for feature enablement to reflect expansion of GuardDuty to features. Added new APIs and updated existing APIs to support RDS Protection GA.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.2.7](service/resourceexplorer2/CHANGELOG.md#v127-2023-03-16)
  * **Documentation**: Documentation updates for APIs.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.18.7](service/sagemakerruntime/CHANGELOG.md#v1187-2023-03-16)
  * **Documentation**: Documentation updates for SageMaker Runtime

# Release (2023-03-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.9.0](service/migrationhubstrategy/CHANGELOG.md#v190-2023-03-15)
  * **Feature**: This release adds the binary analysis that analyzes IIS application DLLs on Windows and Java applications on Linux to provide anti-pattern report without configuring access to the source code.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.31.0](service/s3control/CHANGELOG.md#v1310-2023-03-15)
  * **Feature**: Added support for S3 Object Lambda aliases.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.3.0](service/securitylake/CHANGELOG.md#v130-2023-03-15)
  * **Feature**: Make Create/Get/ListSubscribers APIs return resource share ARN and name so they can be used to validate the RAM resource share to accept. GetDatalake can be used to track status of UpdateDatalake and DeleteDatalake requests.

# Release (2023-03-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/feature/ec2/imds`: [v1.13.0](feature/ec2/imds/CHANGELOG.md#v1130-2023-03-14)
  * **Feature**: Add flag to disable IMDSv1 fallback
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.18.0](service/applicationautoscaling/CHANGELOG.md#v1180-2023-03-14)
  * **Feature**: Application Auto Scaling customers can now use mathematical functions to customize the metric used with Target Tracking policies within the policy configuration itself, saving the cost and effort of publishing the customizations as a separate metric.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.19.0](service/dataexchange/CHANGELOG.md#v1190-2023-03-14)
  * **Feature**: This release enables data providers to license direct access to S3 objects encrypted with Customer Managed Keys (CMK) in AWS KMS through AWS Data Exchange. Subscribers can use these keys to decrypt, then use the encrypted S3 objects shared with them, without creating or managing copies.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.18.7](service/directconnect/CHANGELOG.md#v1187-2023-03-14)
  * **Documentation**: describe-direct-connect-gateway-associations includes a new status, updating, indicating that the association is currently in-process of updating.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.90.0](service/ec2/CHANGELOG.md#v1900-2023-03-14)
  * **Feature**: This release adds a new DnsOptions key (PrivateDnsOnlyForInboundResolverEndpoint) to CreateVpcEndpoint and ModifyVpcEndpoint APIs.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.19.6](service/iam/CHANGELOG.md#v1196-2023-03-14)
  * **Documentation**: Documentation only updates to correct customer-reported issues
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.2.0](service/keyspaces/CHANGELOG.md#v120-2023-03-14)
  * **Feature**: Adding support for client-side timestamps
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.14.6](service/support/CHANGELOG.md#v1146-2023-03-14)
  * **Announcement**: Model regenerated with support for null string values to properly implement `support` service operations `DescribeTrustedAdvisorCheckRefreshStatuses` and `DescribeTrustedAdvisorCheckSummaries`

# Release (2023-03-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.15.0](service/appintegrations/CHANGELOG.md#v1150-2023-03-13)
  * **Feature**: Adds FileConfiguration to Amazon AppIntegrations CreateDataIntegration supporting scheduled downloading of third party files into Amazon Connect from sources such as Microsoft SharePoint.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.20.2](service/lakeformation/CHANGELOG.md#v1202-2023-03-13)
  * **Documentation**: This release updates the documentation regarding Get/Update DataCellsFilter
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.30.0](service/s3control/CHANGELOG.md#v1300-2023-03-13)
  * **Feature**: Added support for cross-account Multi-Region Access Points. Added support for S3 Replication for S3 on Outposts.
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.1.0](service/tnb/CHANGELOG.md#v110-2023-03-13)
  * **Feature**: This release adds tagging support to the following Network Instance APIs : Instantiate, Update, Terminate.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.13.0](service/wisdom/CHANGELOG.md#v1130-2023-03-13)
  * **Feature**: This release extends Wisdom CreateKnowledgeBase API to support SharePoint connector type by removing the @required trait for objectField

# Release (2023-03-10)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.4.0](service/ivschat/CHANGELOG.md#v140-2023-03-10)
  * **Feature**: This release adds a new exception returned when calling AWS IVS chat UpdateLoggingConfiguration. Now UpdateLoggingConfiguration can return ConflictException when invalid updates are made in sequence to Logging Configurations.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.19.0](service/secretsmanager/CHANGELOG.md#v1190-2023-03-10)
  * **Feature**: The type definitions of SecretString and SecretBinary now have a minimum length of 1 in the model to match the exception thrown when you pass in empty values.

# Release (2023-03-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.17.0](service/codeartifact/CHANGELOG.md#v1170-2023-03-09)
  * **Feature**: This release introduces the generic package format, a mechanism for storing arbitrary binary assets. It also adds a new API, PublishPackageVersion, to allow for publishing generic packages.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.49.0](service/connect/CHANGELOG.md#v1490-2023-03-09)
  * **Feature**: This release adds a new API, GetMetricDataV2, which returns metric data for Amazon Connect.
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.11.0](service/evidently/CHANGELOG.md#v1110-2023-03-09)
  * **Feature**: Updated entity override documentation
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.17.5](service/networkmanager/CHANGELOG.md#v1175-2023-03-09)
  * **Documentation**: This update provides example usage for TransitGatewayRouteTableArn.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.33.0](service/quicksight/CHANGELOG.md#v1330-2023-03-09)
  * **Feature**: This release has two changes: add state persistence feature for embedded dashboard and console in GenerateEmbedUrlForRegisteredUser API; add properties for hidden collapsed row dimensions in PivotTableOptions.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.19.0](service/redshiftdata/CHANGELOG.md#v1190-2023-03-09)
  * **Feature**: Added support for Redshift Serverless workgroup-arn wherever the WorkgroupName parameter is available.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.71.0](service/sagemaker/CHANGELOG.md#v1710-2023-03-09)
  * **Feature**: Amazon SageMaker Inference now allows SSM access to customer's model container by setting the "EnableSSMAccess" parameter for a ProductionVariant in CreateEndpointConfig API.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.20.0](service/servicediscovery/CHANGELOG.md#v1200-2023-03-09)
  * **Feature**: Updated all AWS Cloud Map APIs to provide consistent throttling exception (RequestLimitExceeded)
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.17.0](service/sesv2/CHANGELOG.md#v1170-2023-03-09)
  * **Feature**: This release introduces a new recommendation in Virtual Deliverability Manager Advisor, which detects missing or misconfigured Brand Indicator for Message Identification (BIMI) DNS records for customer sending identities.

# Release (2023-03-08)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.23.0](service/athena/CHANGELOG.md#v1230-2023-03-08)
  * **Feature**: A new field SubstatementType is added to GetQueryExecution API, so customers have an error free way to detect the query type and interpret the result.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.19.0](service/dynamodb/CHANGELOG.md#v1190-2023-03-08)
  * **Feature**: Adds deletion protection support to DynamoDB tables. Tables with deletion protection enabled cannot be deleted. Deletion protection is disabled by default, can be enabled via the CreateTable or UpdateTable APIs, and is visible in TableDescription. This setting is not replicated for Global Tables.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.89.0](service/ec2/CHANGELOG.md#v1890-2023-03-08)
  * **Feature**: Introducing Amazon EC2 C7g, M7g and R7g instances, powered by the latest generation AWS Graviton3 processors and deliver up to 25% better performance over Graviton2-based instances.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.20.0](service/lakeformation/CHANGELOG.md#v1200-2023-03-08)
  * **Feature**: This release adds two new API support "GetDataCellsFiler" and "UpdateDataCellsFilter", and also updates the corresponding documentation.
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.21.0](service/mediapackage/CHANGELOG.md#v1210-2023-03-08)
  * **Feature**: This release provides the date and time live resources were created.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.22.0](service/mediapackagevod/CHANGELOG.md#v1220-2023-03-08)
  * **Feature**: This release provides the date and time VOD resources were created.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.17.0](service/route53resolver/CHANGELOG.md#v1170-2023-03-08)
  * **Feature**: Add dual-stack and IPv6 support for Route 53 Resolver Endpoint,Add IPv6 target IP in Route 53 Resolver Forwarding Rule
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.70.0](service/sagemaker/CHANGELOG.md#v1700-2023-03-08)
  * **Feature**: There needs to be a user identity to specify the SageMaker user who perform each action regarding the entity. However, these is a not a unified concept of user identity across SageMaker service that could be used today.

# Release (2023-03-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.24.0](service/databasemigrationservice/CHANGELOG.md#v1240-2023-03-07)
  * **Feature**: This release adds DMS Fleet Advisor Target Recommendation APIs and exposes functionality for DMS Fleet Advisor. It adds functionality to start Target Recommendation calculation.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.22.1](service/location/CHANGELOG.md#v1221-2023-03-07)
  * **Documentation**: Documentation update for the release of 3 additional map styles for use with Open Data Maps: Open Data Standard Dark, Open Data Visualization Light & Open Data Visualization Dark.

# Release (2023-03-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.10.0](service/account/CHANGELOG.md#v1100-2023-03-06)
  * **Feature**: AWS Account alternate contact email addresses can now have a length of 254 characters and contain the character "|".
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.20.6](service/ivs/CHANGELOG.md#v1206-2023-03-06)
  * **Documentation**: Updated text description in DeleteChannel, Stream, and StreamSummary.

# Release (2023-03-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.18.6](service/dynamodb/CHANGELOG.md#v1186-2023-03-03)
  * **Documentation**: Documentation updates for DynamoDB.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.88.0](service/ec2/CHANGELOG.md#v1880-2023-03-03)
  * **Feature**: This release adds support for a new boot mode for EC2 instances called 'UEFI Preferred'.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.27.1](service/macie2/CHANGELOG.md#v1271-2023-03-03)
  * **Documentation**: Documentation updates for Amazon Macie
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.33.0](service/mediaconvert/CHANGELOG.md#v1330-2023-03-03)
  * **Feature**: The AWS Elemental MediaConvert SDK has improved handling for different input and output color space combinations.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.30.0](service/medialive/CHANGELOG.md#v1300-2023-03-03)
  * **Feature**: AWS Elemental MediaLive adds support for Nielsen watermark timezones.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.26.0](service/transcribe/CHANGELOG.md#v1260-2023-03-03)
  * **Feature**: Amazon Transcribe now supports role access for these API operations: CreateVocabulary, UpdateVocabulary, CreateVocabularyFilter, and UpdateVocabularyFilter.

# Release (2023-03-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.35.0](service/iot/CHANGELOG.md#v1350-2023-03-02)
  * **Feature**: A recurring maintenance window is an optional configuration used for rolling out the job document to all devices in the target group observing a predetermined start time, duration, and frequency that the maintenance window occurs.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.8.0](service/migrationhubstrategy/CHANGELOG.md#v180-2023-03-02)
  * **Feature**: This release updates the File Import API to allow importing servers already discovered by customers with reduced pre-requisites.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.19.0](service/organizations/CHANGELOG.md#v1190-2023-03-02)
  * **Feature**: This release introduces a new reason code, ACCOUNT_CREATION_NOT_COMPLETE, to ConstraintViolationException in CreateOrganization API.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.17.0](service/pi/CHANGELOG.md#v1170-2023-03-02)
  * **Feature**: This release adds a new field PeriodAlignment to allow the customer specifying the returned timestamp of time periods to be either the start or end time.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.2.0](service/pipes/CHANGELOG.md#v120-2023-03-02)
  * **Feature**: This release fixes some input parameter range and patterns.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.69.0](service/sagemaker/CHANGELOG.md#v1690-2023-03-02)
  * **Feature**: Add a new field "EndpointMetrics" in SageMaker Inference Recommender "ListInferenceRecommendationsJobSteps" API response.

# Release (2023-03-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.2.0](service/codecatalyst/CHANGELOG.md#v120-2023-03-01)
  * **Feature**: Published Dev Environments StopDevEnvironmentSession API
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.19.0](service/pricing/CHANGELOG.md#v1190-2023-03-01)
  * **Feature**: This release adds 2 new APIs - ListPriceLists which returns a list of applicable price lists, and GetPriceListFileUrl which outputs a URL to retrieve your price lists from the generated file from ListPriceLists
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.15.0](service/s3outposts/CHANGELOG.md#v1150-2023-03-01)
  * **Feature**: S3 on Outposts introduces a new API ListOutpostsWithS3, with this API you can list all your Outposts with S3 capacity.

# Release (2023-02-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.22.0](service/comprehend/CHANGELOG.md#v1220-2023-02-28)
  * **Feature**: Amazon Comprehend now supports flywheels to help you train and manage new model versions for custom models.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.87.0](service/ec2/CHANGELOG.md#v1870-2023-02-28)
  * **Feature**: This release allows IMDS support to be set to v2-only on an existing AMI, so that all future instances launched from that AMI will use IMDSv2 by default.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.20.6](service/kms/CHANGELOG.md#v1206-2023-02-28)
  * **Documentation**: AWS KMS is deprecating the RSAES_PKCS1_V1_5 wrapping algorithm option in the GetParametersForImport API that is used in the AWS KMS Import Key Material feature. AWS KMS will end support for this wrapping algorithm by October 1, 2023.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.26.0](service/lightsail/CHANGELOG.md#v1260-2023-02-28)
  * **Feature**: This release adds Lightsail for Research feature support, such as GUI session access, cost estimates, stop instance on idle, and disk auto mount.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.15.0](service/managedblockchain/CHANGELOG.md#v1150-2023-02-28)
  * **Feature**: This release adds support for tagging to the accessor resource in Amazon Managed Blockchain
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.2.0](service/omics/CHANGELOG.md#v120-2023-02-28)
  * **Feature**: Minor model changes to accomodate batch imports feature

# Release (2023-02-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.23.0](service/devopsguru/CHANGELOG.md#v1230-2023-02-27)
  * **Feature**: This release adds the description field on ListAnomaliesForInsight and DescribeAnomaly API responses for proactive anomalies.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.11.0](service/drs/CHANGELOG.md#v1110-2023-02-27)
  * **Feature**: New fields were added to reflect availability zone data in source server and recovery instance description commands responses, as well as source server launch status.
* `github.com/aws/aws-sdk-go-v2/service/internetmonitor`: [v1.0.0](service/internetmonitor/CHANGELOG.md#v100-2023-02-27)
  * **Release**: New AWS service client module
  * **Feature**: CloudWatch Internet Monitor is a a new service within CloudWatch that will help application developers and network engineers continuously monitor internet performance metrics such as availability and performance between their AWS-hosted applications and end-users of these applications
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.30.0](service/lambda/CHANGELOG.md#v1300-2023-02-27)
  * **Feature**: This release adds the ability to create ESMs with Document DB change streams as event source. For more information see  https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.32.0](service/mediaconvert/CHANGELOG.md#v1320-2023-02-27)
  * **Feature**: The AWS Elemental MediaConvert SDK has added support for HDR10 to SDR tone mapping, and animated GIF video input sources.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.16.0](service/timestreamwrite/CHANGELOG.md#v1160-2023-02-27)
  * **Feature**: This release adds the ability to ingest batched historical data or migrate data in bulk from S3 into Timestream using CSV files.

# Release (2023-02-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.48.0](service/connect/CHANGELOG.md#v1480-2023-02-24)
  * **Feature**: StartTaskContact API now supports linked task creation with a new optional RelatedContactId parameter
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.3.0](service/connectcases/CHANGELOG.md#v130-2023-02-24)
  * **Feature**: This release adds the ability to delete domains through the DeleteDomain API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.27.5](service/redshift/CHANGELOG.md#v1275-2023-02-24)
  * **Documentation**: Documentation updates for Redshift API bringing it in line with IAM best practices.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.29.0](service/securityhub/CHANGELOG.md#v1290-2023-02-24)
  * **Feature**: New Security Hub APIs and updates to existing APIs that help you consolidate control findings and enable and disable controls across all supported standards
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.16.5](service/servicecatalog/CHANGELOG.md#v1165-2023-02-24)
  * **Documentation**: Documentation updates for Service Catalog

# Release (2023-02-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.25.0](service/appflow/CHANGELOG.md#v1250-2023-02-23)
  * **Feature**: This release enables the customers to choose whether to use Private Link for Metadata and Authorization call when using a private Salesforce connections
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.24.0](service/ecs/CHANGELOG.md#v1240-2023-02-23)
  * **Feature**: This release supports deleting Amazon ECS task definitions that are in the INACTIVE state.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.12.3](service/grafana/CHANGELOG.md#v1123-2023-02-23)
  * **Documentation**: Doc-only update. Updated information on attached role policies for customer provided roles
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.17.6](service/guardduty/CHANGELOG.md#v1176-2023-02-23)
  * **Documentation**: Updated API and data types descriptions for CreateFilter, UpdateFilter, and TriggerDetails.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.25.0](service/iotwireless/CHANGELOG.md#v1250-2023-02-23)
  * **Feature**: In this release, we add additional capabilities for the FUOTA which allows user to configure the fragment size, the sending interval and the redundancy ratio of the FUOTA tasks
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.22.0](service/location/CHANGELOG.md#v1220-2023-02-23)
  * **Feature**: This release adds support for using Maps APIs with an API Key in addition to AWS Cognito. This includes support for adding, listing, updating and deleting API Keys.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.27.0](service/macie2/CHANGELOG.md#v1270-2023-02-23)
  * **Feature**: This release adds support for a new finding type, Policy:IAMUser/S3BucketSharedWithCloudFront, and S3 bucket metadata that indicates if a bucket is shared with an Amazon CloudFront OAI or OAC.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.26.0](service/wafv2/CHANGELOG.md#v1260-2023-02-23)
  * **Feature**: You can now associate an AWS WAF v2 web ACL with an AWS App Runner service.

# Release (2023-02-22)

## General Highlights
* **Bug Fix**: Prevent nil pointer dereference when retrieving error codes.
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.2.0](service/chimesdkvoice/CHANGELOG.md#v120-2023-02-22)
  * **Feature**: This release introduces support for Voice Connector media metrics in the Amazon Chime SDK Voice namespace
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.26.0](service/cloudfront/CHANGELOG.md#v1260-2023-02-22)
  * **Feature**: CloudFront now supports block lists in origin request policies so that you can forward all headers, cookies, or query string from viewer requests to the origin *except* for those specified in the block list.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.23.0](service/datasync/CHANGELOG.md#v1230-2023-02-22)
  * **Feature**: AWS DataSync has relaxed the minimum length constraint of AccessKey for Object Storage locations to 1.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.15.0](service/opensearch/CHANGELOG.md#v1150-2023-02-22)
  * **Feature**: This release lets customers configure Off-peak window and software update related properties for a new/existing domain. It enhances the capabilities of StartServiceSoftwareUpdate API; adds 2 new APIs - ListScheduledActions & UpdateScheduledAction; and allows Auto-tune to make use of Off-peak window.
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.10.0](service/rum/CHANGELOG.md#v1100-2023-02-22)
  * **Feature**: CloudWatch RUM now supports CloudWatch Custom Metrics
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.35.5](service/ssm/CHANGELOG.md#v1355-2023-02-22)
  * **Documentation**: Document only update for Feb 2023

# Release (2023-02-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.32.0](service/quicksight/CHANGELOG.md#v1320-2023-02-21)
  * **Feature**: S3 data sources now accept a custom IAM role.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.9.0](service/resiliencehub/CHANGELOG.md#v190-2023-02-21)
  * **Feature**: In this release we improved resilience hub application creation and maintenance by introducing new resource and app component crud APIs, improving visibility and maintenance of application input sources and added support for additional information attributes to be provided by customers.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.28.4](service/securityhub/CHANGELOG.md#v1284-2023-02-21)
  * **Documentation**: Documentation updates for AWS Security Hub
* `github.com/aws/aws-sdk-go-v2/service/tnb`: [v1.0.0](service/tnb/CHANGELOG.md#v100-2023-02-21)
  * **Release**: New AWS service client module
  * **Feature**: This is the initial SDK release for AWS Telco Network Builder (TNB). AWS Telco Network Builder is a network automation service that helps you deploy and manage telecom networks.

# Release (2023-02-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.17.5
  * **Bug Fix**: fix int overflow bug on 32 bit architecture
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.24.0](service/auditmanager/CHANGELOG.md#v1240-2023-02-20)
  * **Feature**: This release introduces a ServiceQuotaExceededException to the UpdateAssessmentFrameworkShare API operation.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.47.0](service/connect/CHANGELOG.md#v1470-2023-02-20)
  * **Feature**: Reasons for failed diff has been approved by SDK Reviewer

# Release (2023-02-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.17.0](service/apprunner/CHANGELOG.md#v1170-2023-02-17)
  * **Feature**: This release supports removing MaxSize limit for AutoScalingConfiguration.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.43.0](service/glue/CHANGELOG.md#v1430-2023-02-17)
  * **Feature**: Release of Delta Lake Data Lake Format for Glue Studio Service

# Release (2023-02-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.23.0](service/emr/CHANGELOG.md#v1230-2023-02-16)
  * **Feature**: This release provides customers the ability to define a timeout period for procuring capacity during a resize operation for Instance Fleet clusters. Customers can specify this timeout using the ResizeSpecifications parameter supported by RunJobFlow, ModifyInstanceFleet and AddInstanceFleet APIs.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.12.0](service/grafana/CHANGELOG.md#v1120-2023-02-16)
  * **Feature**: With this release Amazon Managed Grafana now supports inbound Network Access Control that helps you to restrict user access to your Grafana workspaces
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.20.3](service/ivs/CHANGELOG.md#v1203-2023-02-16)
  * **Documentation**: Doc-only update. Updated text description in DeleteChannel, Stream, and StreamSummary.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.25.1](service/wafv2/CHANGELOG.md#v1251-2023-02-16)
  * **Documentation**: Added a notice for account takeover prevention (ATP). The interface incorrectly lets you to configure ATP response inspection in regional web ACLs in Region US East (N. Virginia), without returning an error. ATP response inspection is only available in web ACLs that protect CloudFront distributions.

# Release (2023-02-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.19.3](service/accessanalyzer/CHANGELOG.md#v1193-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.9.1](service/account/CHANGELOG.md#v191-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.17.3](service/acm/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.21.2](service/acmpca/CHANGELOG.md#v1212-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/alexaforbusiness`: [v1.15.2](service/alexaforbusiness/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.16.2](service/amp/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.13.2](service/amplify/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/amplifybackend`: [v1.14.2](service/amplifybackend/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.9.2](service/amplifyuibuilder/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.16.3](service/apigateway/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/apigatewaymanagementapi`: [v1.11.2](service/apigatewaymanagementapi/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.13.3](service/apigatewayv2/CHANGELOG.md#v1133-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.17.1](service/appconfig/CHANGELOG.md#v1171-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.6.1](service/appconfigdata/CHANGELOG.md#v161-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.24.2](service/appflow/CHANGELOG.md#v1242-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.14.2](service/appintegrations/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.17.3](service/applicationautoscaling/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler`: [v1.10.2](service/applicationcostprofiler/CHANGELOG.md#v1102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.15.2](service/applicationdiscoveryservice/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.17.3](service/applicationinsights/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.17.2](service/appmesh/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.16.2](service/apprunner/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.20.2](service/appstream/CHANGELOG.md#v1202-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.19.2](service/appsync/CHANGELOG.md#v1192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.1.3](service/arczonalshift/CHANGELOG.md#v113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.22.2](service/athena/CHANGELOG.md#v1222-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.23.2](service/auditmanager/CHANGELOG.md#v1232-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/autoscalingplans`: [v1.13.2](service/autoscalingplans/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.20.1](service/backup/CHANGELOG.md#v1201-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.9.2](service/backupgateway/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/backupstorage`: [v1.1.2](service/backupstorage/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.21.3](service/batch/CHANGELOG.md#v1213-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.5.2](service/billingconductor/CHANGELOG.md#v152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.17.2](service/braket/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.14.2](service/budgets/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.22.2](service/chime/CHANGELOG.md#v1222-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkidentity`: [v1.10.2](service/chimesdkidentity/CHANGELOG.md#v1102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.2.2](service/chimesdkmediapipelines/CHANGELOG.md#v122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.14.3](service/chimesdkmeetings/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.12.2](service/chimesdkmessaging/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.1.2](service/chimesdkvoice/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.0.2](service/cleanrooms/CHANGELOG.md#v102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.17.2](service/cloud9/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudcontrol`: [v1.11.3](service/cloudcontrol/CHANGELOG.md#v1113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.13.2](service/clouddirectory/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsm`: [v1.13.2](service/cloudhsm/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.14.2](service/cloudhsmv2/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudsearchdomain`: [v1.12.2](service/cloudsearchdomain/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.24.0](service/cloudtrail/CHANGELOG.md#v1240-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Feature**: This release adds an InsufficientEncryptionPolicyException type to the StartImport endpoint
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudtraildata`: [v1.0.2](service/cloudtraildata/CHANGELOG.md#v102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.15.3](service/cloudwatchevents/CHANGELOG.md#v1153-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.20.3](service/cloudwatchlogs/CHANGELOG.md#v1203-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.16.2](service/codeartifact/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.20.3](service/codebuild/CHANGELOG.md#v1203-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.1.2](service/codecatalyst/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.14.2](service/codecommit/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.16.3](service/codedeploy/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codeguruprofiler`: [v1.13.2](service/codeguruprofiler/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codegurureviewer`: [v1.17.2](service/codegurureviewer/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.14.2](service/codepipeline/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codestar`: [v1.13.2](service/codestar/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.14.2](service/codestarconnections/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/codestarnotifications`: [v1.14.2](service/codestarnotifications/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.15.2](service/cognitoidentity/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.22.2](service/cognitoidentityprovider/CHANGELOG.md#v1222-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/cognitosync`: [v1.12.2](service/cognitosync/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.21.2](service/comprehend/CHANGELOG.md#v1212-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.15.2](service/comprehendmedical/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.21.1](service/computeoptimizer/CHANGELOG.md#v1211-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.29.3](service/configservice/CHANGELOG.md#v1293-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.46.1](service/connect/CHANGELOG.md#v1461-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.2.3](service/connectcampaigns/CHANGELOG.md#v123-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.2.3](service/connectcases/CHANGELOG.md#v123-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.13.2](service/connectcontactlens/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.15.2](service/connectparticipant/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.1.2](service/controltower/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.15.2](service/costandusagereportservice/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.25.2](service/costexplorer/CHANGELOG.md#v1252-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.23.1](service/customerprofiles/CHANGELOG.md#v1231-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.23.3](service/databasemigrationservice/CHANGELOG.md#v1233-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/databrew`: [v1.21.3](service/databrew/CHANGELOG.md#v1213-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.18.2](service/dataexchange/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/datapipeline`: [v1.14.2](service/datapipeline/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.22.1](service/datasync/CHANGELOG.md#v1221-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.12.2](service/dax/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.18.2](service/detective/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.15.2](service/devicefarm/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.22.2](service/devopsguru/CHANGELOG.md#v1222-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.18.3](service/directconnect/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.16.3](service/directoryservice/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.14.4](service/dlm/CHANGELOG.md#v1144-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.1.2](service/docdbelastic/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.10.2](service/drs/CHANGELOG.md#v1102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.18.3](service/dynamodb/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.14.3](service/dynamodbstreams/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ebs`: [v1.16.4](service/ebs/CHANGELOG.md#v1164-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.15.2](service/ec2instanceconnect/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.18.3](service/ecr/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.15.2](service/ecrpublic/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.23.3](service/ecs/CHANGELOG.md#v1233-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.19.4](service/efs/CHANGELOG.md#v1194-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
  * **Documentation**: Documentation update for EFS to support IAM best practices.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.27.3](service/eks/CHANGELOG.md#v1273-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.12.2](service/elasticinference/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.18.3](service/elasticsearchservice/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.14.2](service/elastictranscoder/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.22.3](service/emr/CHANGELOG.md#v1223-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.17.1](service/emrcontainers/CHANGELOG.md#v1171-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.5.2](service/emrserverless/CHANGELOG.md#v152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.18.3](service/eventbridge/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.10.2](service/evidently/CHANGELOG.md#v1102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.9.2](service/finspace/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.14.2](service/finspacedata/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.16.3](service/firehose/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.14.2](service/fis/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.22.3](service/fms/CHANGELOG.md#v1223-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.25.2](service/forecast/CHANGELOG.md#v1252-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/forecastquery`: [v1.13.2](service/forecastquery/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.23.0](service/frauddetector/CHANGELOG.md#v1230-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Feature**: This release introduces Lists feature which allows customers to reference a set of values in Fraud Detector's rules. With Lists, customers can dynamically manage these attributes in real time. Lists can be created/deleted and its contents can be modified using the Fraud Detector API.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.28.3](service/fsx/CHANGELOG.md#v1283-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.17.2](service/gamelift/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/gamesparks`: [v1.2.2](service/gamesparks/CHANGELOG.md#v122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/glacier`: [v1.14.3](service/glacier/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.16.2](service/globalaccelerator/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.42.0](service/glue/CHANGELOG.md#v1420-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Feature**: Fix DirectJDBCSource not showing up in CLI code gen
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.11.2](service/grafana/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/greengrass`: [v1.15.3](service/greengrass/CHANGELOG.md#v1153-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.21.3](service/greengrassv2/CHANGELOG.md#v1213-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.17.2](service/groundstation/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.17.3](service/guardduty/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.16.2](service/health/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.15.2](service/healthlake/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/honeycode`: [v1.13.2](service/honeycode/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/identitystore`: [v1.16.2](service/identitystore/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.22.2](service/imagebuilder/CHANGELOG.md#v1222-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/inspector`: [v1.13.2](service/inspector/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.11.3](service/inspector2/CHANGELOG.md#v1113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.34.2](service/iot/CHANGELOG.md#v1342-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickdevicesservice`: [v1.11.2](service/iot1clickdevicesservice/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iot1clickprojects`: [v1.12.2](service/iot1clickprojects/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotanalytics`: [v1.14.2](service/iotanalytics/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.14.2](service/iotdataplane/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.17.2](service/iotdeviceadvisor/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.15.2](service/iotevents/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ioteventsdata`: [v1.13.2](service/ioteventsdata/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.13.2](service/iotfleethub/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.3.2](service/iotfleetwise/CHANGELOG.md#v132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.12.2](service/iotjobsdataplane/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotroborunner`: [v1.1.2](service/iotroborunner/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.15.2](service/iotsecuretunneling/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.27.2](service/iotsitewise/CHANGELOG.md#v1272-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotthingsgraph`: [v1.14.2](service/iotthingsgraph/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.10.2](service/iottwinmaker/CHANGELOG.md#v1102-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.24.2](service/iotwireless/CHANGELOG.md#v1242-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.20.2](service/ivs/CHANGELOG.md#v1202-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.3.2](service/ivschat/CHANGELOG.md#v132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.19.2](service/kafka/CHANGELOG.md#v1192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.9.2](service/kafkaconnect/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.38.3](service/kendra/CHANGELOG.md#v1383-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kendraranking`: [v1.0.4](service/kendraranking/CHANGELOG.md#v104-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.1.2](service/keyspaces/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.17.4](service/kinesis/CHANGELOG.md#v1174-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalytics`: [v1.14.2](service/kinesisanalytics/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.16.2](service/kinesisanalyticsv2/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.15.3](service/kinesisvideo/CHANGELOG.md#v1153-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.14.3](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia`: [v1.11.3](service/kinesisvideomedia/CHANGELOG.md#v1113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideosignaling`: [v1.11.3](service/kinesisvideosignaling/CHANGELOG.md#v1113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.2.3](service/kinesisvideowebrtcstorage/CHANGELOG.md#v123-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.20.3](service/kms/CHANGELOG.md#v1203-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.19.2](service/lakeformation/CHANGELOG.md#v1192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.29.2](service/lambda/CHANGELOG.md#v1292-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice`: [v1.17.2](service/lexmodelbuildingservice/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.28.1](service/lexmodelsv2/CHANGELOG.md#v1281-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimeservice`: [v1.13.2](service/lexruntimeservice/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.17.1](service/lexruntimev2/CHANGELOG.md#v1171-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.17.2](service/licensemanager/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.1.2](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.2.2](service/licensemanagerusersubscriptions/CHANGELOG.md#v122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.25.3](service/lightsail/CHANGELOG.md#v1253-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.21.2](service/location/CHANGELOG.md#v1212-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.17.2](service/lookoutequipment/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lookoutmetrics`: [v1.19.2](service/lookoutmetrics/CHANGELOG.md#v1192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.15.2](service/lookoutvision/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.4.2](service/m2/CHANGELOG.md#v142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.15.2](service/machinelearning/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/macie`: [v1.15.2](service/macie/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.26.2](service/macie2/CHANGELOG.md#v1262-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.14.2](service/managedblockchain/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.15.2](service/marketplacecatalog/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.12.2](service/marketplacecommerceanalytics/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.12.2](service/marketplaceentitlementservice/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.14.3](service/marketplacemetering/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.18.2](service/mediaconnect/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.31.1](service/mediaconvert/CHANGELOG.md#v1311-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.29.2](service/medialive/CHANGELOG.md#v1292-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.20.2](service/mediapackage/CHANGELOG.md#v1202-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.21.2](service/mediapackagevod/CHANGELOG.md#v1212-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediastore`: [v1.13.2](service/mediastore/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediastoredata`: [v1.13.2](service/mediastoredata/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.22.2](service/mediatailor/CHANGELOG.md#v1222-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.12.2](service/memorydb/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.17.2](service/mgn/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.13.2](service/migrationhub/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.13.2](service/migrationhubconfig/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.1.2](service/migrationhuborchestrator/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.9.1](service/migrationhubrefactorspaces/CHANGELOG.md#v191-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.7.2](service/migrationhubstrategy/CHANGELOG.md#v172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mobile`: [v1.12.2](service/mobile/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.14.2](service/mq/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mturk`: [v1.14.2](service/mturk/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.14.2](service/mwaa/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.24.2](service/networkfirewall/CHANGELOG.md#v1242-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.17.2](service/networkmanager/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.16.2](service/nimble/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.1.3](service/oam/CHANGELOG.md#v113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.1.2](service/omics/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.14.2](service/opensearch/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.1.3](service/opensearchserverless/CHANGELOG.md#v113-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.14.2](service/opsworks/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.15.2](service/opsworkscm/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.18.2](service/organizations/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.27.2](service/outposts/CHANGELOG.md#v1272-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.11.2](service/panorama/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.23.2](service/personalize/CHANGELOG.md#v1232-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.13.2](service/personalizeevents/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.13.2](service/personalizeruntime/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.16.3](service/pi/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.18.2](service/pinpoint/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pinpointemail`: [v1.12.2](service/pinpointemail/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice`: [v1.11.2](service/pinpointsmsvoice/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.1.2](service/pinpointsmsvoicev2/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.1.2](service/pipes/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.25.1](service/polly/CHANGELOG.md#v1251-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.18.2](service/pricing/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/privatenetworks`: [v1.2.0](service/privatenetworks/CHANGELOG.md#v120-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Feature**: This release introduces a new StartNetworkResourceUpdate API, which enables return/replacement of hardware from a NetworkSite.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.20.1](service/proton/CHANGELOG.md#v1201-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.15.2](service/qldb/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/qldbsession`: [v1.14.2](service/qldbsession/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.31.2](service/quicksight/CHANGELOG.md#v1312-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ram`: [v1.17.3](service/ram/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.8.3](service/rbin/CHANGELOG.md#v183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.40.3](service/rds/CHANGELOG.md#v1403-2023-02-15)
  * **Documentation**: Database Activity Stream support for RDS for SQL Server.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.13.2](service/rdsdata/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.18.2](service/redshiftdata/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.4.3](service/redshiftserverless/CHANGELOG.md#v143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.23.2](service/rekognition/CHANGELOG.md#v1232-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.8.2](service/resiliencehub/CHANGELOG.md#v182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.2.3](service/resourceexplorer2/CHANGELOG.md#v123-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.14.3](service/resourcegroups/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi`: [v1.14.3](service/resourcegroupstaggingapi/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.18.2](service/robomaker/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.1.2](service/rolesanywhere/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.14.2](service/route53domains/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.11.2](service/route53recoverycluster/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.11.2](service/route53recoverycontrolconfig/CHANGELOG.md#v1112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness`: [v1.9.2](service/route53recoveryreadiness/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.16.3](service/route53resolver/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.9.2](service/rum/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.14.2](service/s3outposts/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.68.1](service/sagemaker/CHANGELOG.md#v1681-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime`: [v1.15.2](service/sagemakera2iruntime/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemakeredge`: [v1.13.2](service/sagemakeredge/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.13.2](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.1.2](service/sagemakergeospatial/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.0.5](service/sagemakermetrics/CHANGELOG.md#v105-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.18.3](service/sagemakerruntime/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.12.2](service/savingsplans/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.1.2](service/scheduler/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/schemas`: [v1.15.2](service/schemas/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.18.4](service/secretsmanager/CHANGELOG.md#v1184-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.28.2](service/securityhub/CHANGELOG.md#v1282-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.2.2](service/securitylake/CHANGELOG.md#v122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/serverlessapplicationrepository`: [v1.12.2](service/serverlessapplicationrepository/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.16.2](service/servicecatalog/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.16.3](service/servicecatalogappregistry/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.19.2](service/servicediscovery/CHANGELOG.md#v1192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.14.3](service/servicequotas/CHANGELOG.md#v1143-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.16.2](service/sesv2/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.17.3](service/sfn/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.18.2](service/shield/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.14.2](service/signer/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.1.2](service/simspaceweaver/CHANGELOG.md#v112-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.13.2](service/sms/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.18.1](service/snowball/CHANGELOG.md#v1181-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/snowdevicemanagement`: [v1.9.2](service/snowdevicemanagement/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.35.3](service/ssm/CHANGELOG.md#v1353-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.14.2](service/ssmcontacts/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.20.2](service/ssmincidents/CHANGELOG.md#v1202-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.2.2](service/ssmsap/CHANGELOG.md#v122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.12.2](service/sso/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.16.2](service/ssoadmin/CHANGELOG.md#v1162-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.14.2](service/ssooidc/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.18.3](service/storagegateway/CHANGELOG.md#v1183-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.14.2](service/support/CHANGELOG.md#v1142-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/supportapp`: [v1.2.2](service/supportapp/CHANGELOG.md#v122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.14.4](service/swf/CHANGELOG.md#v1144-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.17.3](service/synthetics/CHANGELOG.md#v1173-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.20.2](service/textract/CHANGELOG.md#v1202-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.15.2](service/timestreamquery/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.15.2](service/timestreamwrite/CHANGELOG.md#v1152-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.25.2](service/transcribe/CHANGELOG.md#v1252-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.9.2](service/transcribestreaming/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.28.3](service/transfer/CHANGELOG.md#v1283-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.17.2](service/translate/CHANGELOG.md#v1172-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.12.2](service/voiceid/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.12.2](service/waf/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/wafregional`: [v1.13.3](service/wafregional/CHANGELOG.md#v1133-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.25.0](service/wafv2/CHANGELOG.md#v1250-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Feature**: For protected CloudFront distributions, you can now use the AWS WAF Fraud Control account takeover prevention (ATP) managed rule group to block new login attempts from clients that have recently submitted too many failed login attempts.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.18.2](service/wellarchitected/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.12.2](service/wisdom/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.13.3](service/workdocs/CHANGELOG.md#v1133-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/worklink`: [v1.13.2](service/worklink/CHANGELOG.md#v1132-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.18.2](service/workmail/CHANGELOG.md#v1182-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/workmailmessageflow`: [v1.12.2](service/workmailmessageflow/CHANGELOG.md#v1122-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.28.3](service/workspaces/CHANGELOG.md#v1283-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.9.2](service/workspacesweb/CHANGELOG.md#v192-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.16.3](service/xray/CHANGELOG.md#v1163-2023-02-15)
  * **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
  * **Bug Fix**: Correct error type parsing for restJson services.

# Release (2023-02-14)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.17.0](service/appconfig/CHANGELOG.md#v1170-2023-02-14)
  * **Feature**: AWS AppConfig now offers the option to set a version label on hosted configuration versions. Version labels allow you to identify specific hosted configuration versions based on an alternate versioning scheme that you define.
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.22.0](service/datasync/CHANGELOG.md#v1220-2023-02-14)
  * **Feature**: With this launch, we are giving customers the ability to use older SMB protocol versions, enabling them to use DataSync to copy data to and from their legacy storage arrays.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.86.0](service/ec2/CHANGELOG.md#v1860-2023-02-14)
  * **Feature**: With this release customers can turn host maintenance on or off when allocating or modifying a supported dedicated host. Host maintenance is turned on by default for supported hosts.

# Release (2023-02-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.9.0](service/account/CHANGELOG.md#v190-2023-02-13)
  * **Feature**: This release of the Account Management API enables customers to view and manage whether AWS Opt-In Regions are enabled or disabled for their Account. For more information, see https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.6.0](service/appconfigdata/CHANGELOG.md#v160-2023-02-13)
  * **Feature**: AWS AppConfig now offers the option to set a version label on hosted configuration versions. If a labeled hosted configuration version is deployed, its version label is available in the GetLatestConfiguration response.
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.18.0](service/snowball/CHANGELOG.md#v1180-2023-02-13)
  * **Feature**: Adds support for EKS Anywhere on Snowball. AWS Snow Family customers can now install EKS Anywhere service on Snowball Edge Compute Optimized devices.

# Release (2023-02-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.27.0](service/autoscaling/CHANGELOG.md#v1270-2023-02-10)
  * **Feature**: You can now either terminate/replace, ignore, or wait for EC2 Auto Scaling instances on standby or protected from scale in. Also, you can also roll back changes from a failed instance refresh.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.46.0](service/connect/CHANGELOG.md#v1460-2023-02-10)
  * **Feature**: This update provides the Wisdom session ARN for contacts enabled for Wisdom in the chat channel.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.85.0](service/ec2/CHANGELOG.md#v1850-2023-02-10)
  * **Feature**: Adds support for waiters that automatically poll for an imported snapshot until it reaches the completed state.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.25.0](service/polly/CHANGELOG.md#v1250-2023-02-10)
  * **Feature**: Amazon Polly adds two new neural Japanese voices - Kazuha, Tomoko
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.68.0](service/sagemaker/CHANGELOG.md#v1680-2023-02-10)
  * **Feature**: Amazon SageMaker Autopilot adds support for selecting algorithms in CreateAutoMLJob API.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.20.2](service/sns/CHANGELOG.md#v1202-2023-02-10)
  * **Documentation**: This release adds support for SNS X-Ray active tracing as well as other updates.

# Release (2023-02-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.14.2](service/chimesdkmeetings/CHANGELOG.md#v1142-2023-02-09)
  * **Documentation**: Documentation updates for Chime Meetings SDK
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.17.0](service/emrcontainers/CHANGELOG.md#v1170-2023-02-09)
  * **Feature**: EMR on EKS allows configuring retry policies for job runs through the StartJobRun API. Using retry policies, a job cause a driver pod to be restarted automatically if it fails or is deleted. The job's status can be seen in the DescribeJobRun and ListJobRun APIs and monitored using CloudWatch events.
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.28.0](service/lexmodelsv2/CHANGELOG.md#v1280-2023-02-09)
  * **Feature**: AWS Lex now supports Network of Bots.
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.17.0](service/lexruntimev2/CHANGELOG.md#v1170-2023-02-09)
  * **Feature**: AWS Lex now supports Network of Bots.
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.25.2](service/lightsail/CHANGELOG.md#v1252-2023-02-09)
  * **Documentation**: Documentation updates for Lightsail
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.9.0](service/migrationhubrefactorspaces/CHANGELOG.md#v190-2023-02-09)
  * **Feature**: This release adds support for creating environments with a network fabric type of NONE
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.13.2](service/workdocs/CHANGELOG.md#v1132-2023-02-09)
  * **Documentation**: Doc only update for the WorkDocs APIs.
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.28.2](service/workspaces/CHANGELOG.md#v1282-2023-02-09)
  * **Documentation**: Removed Windows Server 2016 BYOL and made changes based on IAM campaign.

# Release (2023-02-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.20.0](service/backup/CHANGELOG.md#v1200-2023-02-08)
  * **Feature**: This release added one attribute (resource name) in the output model of our 9 existing APIs in AWS backup so that customers will see the resource name at the output. No input required from Customers.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.25.0](service/cloudfront/CHANGELOG.md#v1250-2023-02-08)
  * **Feature**: CloudFront Origin Access Control extends support to AWS Elemental MediaStore origins.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.41.0](service/glue/CHANGELOG.md#v1410-2023-02-08)
  * **Feature**: DirectJDBCSource + Glue 4.0 streaming options

# Release (2023-02-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.28.2](service/transfer/CHANGELOG.md#v1282-2023-02-07)
  * **Documentation**: Updated the documentation for the ImportCertificate API call, and added examples.

# Release (2023-02-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.21.0](service/computeoptimizer/CHANGELOG.md#v1210-2023-02-06)
  * **Feature**: AWS Compute optimizer can now infer if Kafka is running on an instance.
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.23.0](service/customerprofiles/CHANGELOG.md#v1230-2023-02-06)
  * **Feature**: This release deprecates the PartyType and Gender enum data types from the Profile model and replaces them with new PartyTypeString and GenderString attributes, which accept any string of length up to 255.
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.22.0](service/frauddetector/CHANGELOG.md#v1220-2023-02-06)
  * **Feature**: My AWS Service (Amazon Fraud Detector) - This release introduces Cold Start Model Training which optimizes training for small datasets and adds intelligent methods for treating unlabeled data. You can now train Online Fraud Insights or Transaction Fraud Insights models with minimal historical-data.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.31.0](service/mediaconvert/CHANGELOG.md#v1310-2023-02-06)
  * **Feature**: The AWS Elemental MediaConvert SDK has added improved scene change detection capabilities and a bandwidth reduction filter, along with video quality enhancements, to the AVC encoder.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.27.0](service/outposts/CHANGELOG.md#v1270-2023-02-06)
  * **Feature**: Adds OrderType to Order structure. Adds PreviousOrderId and PreviousLineItemId to LineItem structure. Adds new line item status REPLACED. Increases maximum length of pagination token.

# Release (2023-02-03)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.26.2](service/autoscaling/CHANGELOG.md#v1262-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.26.2](service/cloudformation/CHANGELOG.md#v1262-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/cloudsearch`: [v1.14.1](service/cloudsearch/CHANGELOG.md#v1141-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.25.2](service/cloudwatch/CHANGELOG.md#v1252-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.20.2](service/docdb/CHANGELOG.md#v1202-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.84.1](service/ec2/CHANGELOG.md#v1841-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.26.2](service/elasticache/CHANGELOG.md#v1262-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.15.1](service/elasticbeanstalk/CHANGELOG.md#v1151-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing`: [v1.15.2](service/elasticloadbalancing/CHANGELOG.md#v1152-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.19.3](service/elasticloadbalancingv2/CHANGELOG.md#v1193-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.19.2](service/iam/CHANGELOG.md#v1192-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.19.2](service/neptune/CHANGELOG.md#v1192-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.20.0](service/proton/CHANGELOG.md#v1200-2023-02-03)
  * **Feature**: Add new GetResourcesSummary API
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.40.2](service/rds/CHANGELOG.md#v1402-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.27.2](service/redshift/CHANGELOG.md#v1272-2023-02-03)
  * **Documentation**: Corrects descriptions of the parameters for the API operations RestoreFromClusterSnapshot, RestoreTableFromClusterSnapshot, and CreateCluster.
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.15.1](service/ses/CHANGELOG.md#v1151-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.20.1](service/sns/CHANGELOG.md#v1201-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.20.2](service/sqs/CHANGELOG.md#v1202-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.18.3](service/sts/CHANGELOG.md#v1183-2023-02-03)
  * **Dependency Update**: Upgrade smithy to 1.27.2 and correct empty query list serialization.

# Release (2023-02-02)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.16.0](service/appconfig/CHANGELOG.md#v1160-2023-02-02)
  * **Feature**: AWS AppConfig introduces KMS customer-managed key (CMK) encryption of configuration data, along with AWS Secrets Manager as a new configuration data source. S3 objects using SSE-KMS encryption and SSM Parameter Store SecureStrings are also now supported.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.84.0](service/ec2/CHANGELOG.md#v1840-2023-02-02)
  * **Feature**: Documentation updates for EC2.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.19.2](service/elasticloadbalancingv2/CHANGELOG.md#v1192-2023-02-02)
  * **Documentation**: The GWLB Flex Health Check project updates the default values of healthy-threshold-count from 3 to 5 and unhealthy-threshold-count from 3 to 2
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.31.0](service/quicksight/CHANGELOG.md#v1310-2023-02-02)
  * **Feature**: QuickSight support for Radar Chart and Dashboard Publish Options

# Release (2023-02-01)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.22.0](service/devopsguru/CHANGELOG.md#v1220-2023-02-01)
  * **Feature**: This release adds filter support ListAnomalyForInsight API.
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.25.0](service/forecast/CHANGELOG.md#v1250-2023-02-01)
  * **Feature**: This release will enable customer select INCREMENTAL as ImportModel in Forecast's CreateDatasetImportJob API. Verified latest SDK containing required attribute, following https://w.amazon.com/bin/view/AWS-Seer/Launch/Trebuchet/
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.19.1](service/iam/CHANGELOG.md#v1191-2023-02-01)
  * **Documentation**: Documentation updates for AWS Identity and Access Management (IAM).
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.22.0](service/mediatailor/CHANGELOG.md#v1220-2023-02-01)
  * **Feature**: The AWS Elemental MediaTailor SDK for Channel Assembly has added support for program updates, and the ability to clip the end of VOD sources in programs.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.20.0](service/sns/CHANGELOG.md#v1200-2023-02-01)
  * **Feature**: Additional attributes added for set-topic-attributes.

# Release (2023-01-31)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.19.0](service/appsync/CHANGELOG.md#v1190-2023-01-31)
  * **Feature**: This release introduces the feature to support EventBridge as AppSync data source.
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.23.0](service/cloudtrail/CHANGELOG.md#v1230-2023-01-31)
  * **Feature**: Add new "Channel" APIs to enable users to manage channels used for CloudTrail Lake integrations, and "Resource Policy" APIs to enable users to manage the resource-based permissions policy attached to a channel.
* `github.com/aws/aws-sdk-go-v2/service/cloudtraildata`: [v1.0.0](service/cloudtraildata/CHANGELOG.md#v100-2023-01-31)
  * **Release**: New AWS service client module
  * **Feature**: Add CloudTrail Data Service to enable users to ingest activity events from non-AWS sources into CloudTrail Lake.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.16.0](service/codeartifact/CHANGELOG.md#v1160-2023-01-31)
  * **Feature**: This release introduces a new DeletePackage API, which enables deletion of a package and all of its versions from a repository.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.83.0](service/ec2/CHANGELOG.md#v1830-2023-01-31)
  * **Feature**: This launch allows customers to associate up to 8 IP addresses to their NAT Gateways to increase the limit on concurrent connections to a single destination by eight times from 55K to 440K.
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.17.0](service/groundstation/CHANGELOG.md#v1170-2023-01-31)
  * **Feature**: DigIF Expansion changes to the Customer APIs.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.34.0](service/iot/CHANGELOG.md#v1340-2023-01-31)
  * **Feature**: Added support for IoT Rules Engine Cloudwatch Logs action batch mode.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.14.0](service/opensearch/CHANGELOG.md#v1140-2023-01-31)
  * **Feature**: Amazon OpenSearch Service adds the option for a VPC endpoint connection between two domains when the local domain uses OpenSearch version 1.3 or 2.3. You can now use remote reindex to copy indices from one VPC domain to another without a reverse proxy.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.24.0](service/polly/CHANGELOG.md#v1240-2023-01-31)
  * **Feature**: Amazon Polly adds two new neural American English voices - Ruth, Stephen
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.67.0](service/sagemaker/CHANGELOG.md#v1670-2023-01-31)
  * **Feature**: Amazon SageMaker Automatic Model Tuning now supports more completion criteria for Hyperparameter Optimization.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.28.0](service/securityhub/CHANGELOG.md#v1280-2023-01-31)
  * **Feature**: New fields have been added to the AWS Security Finding Format. Compliance.SecurityControlId is a unique identifier for a security control across standards. Compliance.AssociatedStandards contains all enabled standards in which a security control is enabled.

# Release (2023-01-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.26.0](service/cloudformation/CHANGELOG.md#v1260-2023-01-30)
  * **Feature**: This feature provides a method of obtaining which regions a stackset has stack instances deployed in.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.82.0](service/ec2/CHANGELOG.md#v1820-2023-01-30)
  * **Feature**: We add Prefix Lists as a new route destination option for LocalGatewayRoutes. This will allow customers to create routes to Prefix Lists. Prefix List routes will allow customers to group individual CIDR routes with the same target into a single route.

# Release (2023-01-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.20.0](service/appstream/CHANGELOG.md#v1200-2023-01-27)
  * **Feature**: Fixing the issue where Appstream waiters hang for fleet_started and fleet_stopped.
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.21.0](service/mediatailor/CHANGELOG.md#v1210-2023-01-27)
  * **Feature**: This release introduces the As Run logging type, along with API and documentation updates.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.26.0](service/outposts/CHANGELOG.md#v1260-2023-01-27)
  * **Feature**: Adding support for payment term in GetOrder, CreateOrder responses.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.66.0](service/sagemaker/CHANGELOG.md#v1660-2023-01-27)
  * **Feature**: This release supports running SageMaker Training jobs with container images that are in a private Docker registry.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.18.0](service/sagemakerruntime/CHANGELOG.md#v1180-2023-01-27)
  * **Feature**: Amazon SageMaker Runtime which supports InvokeEndpointAsync asynchronously can now invoke endpoints with custom timeout values. Asynchronous invocations support longer processing times.

# Release (2023-01-26)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.18.0](service/eventbridge/CHANGELOG.md#v1180-2023-01-26)
  * **Feature**: Minor comments for Redshift Serverless workgroup target support.

# Release (2023-01-25)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.81.0](service/ec2/CHANGELOG.md#v1810-2023-01-25)
  * **Feature**: This release adds new functionality that allows customers to provision IPv6 CIDR blocks through Amazon VPC IP Address Manager (IPAM) as well as allowing customers to utilize IPAM Resource Discovery APIs.
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.4.0](service/m2/CHANGELOG.md#v140-2023-01-25)
  * **Feature**: Add returnCode, batchJobIdentifier in GetBatchJobExecution response, for user to view the batch job execution result & unique identifier from engine. Also removed unused headers from REST APIs
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.23.0](service/polly/CHANGELOG.md#v1230-2023-01-25)
  * **Feature**: Add 5 new neural voices - Sergio (es-ES), Andres (es-MX), Remi (fr-FR), Adriano (it-IT) and Thiago (pt-BR).
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.4.1](service/redshiftserverless/CHANGELOG.md#v141-2023-01-25)
  * **Documentation**: Added query monitoring rules as possible parameters for create and update workgroup operations.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.65.0](service/sagemaker/CHANGELOG.md#v1650-2023-01-25)
  * **Feature**: SageMaker Inference Recommender now decouples from Model Registry and could accept Model Name to invoke inference recommendations job; Inference Recommender now provides CPU/Memory Utilization metrics data in recommendation output.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.18.2](service/sts/CHANGELOG.md#v1182-2023-01-25)
  * **Documentation**: Doc only change to update wording in a key topic

# Release (2023-01-24)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.27.0](service/route53/CHANGELOG.md#v1270-2023-01-24)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (Melbourne) Region (ap-southeast-4) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.2.0](service/ssmsap/CHANGELOG.md#v120-2023-01-24)
  * **Feature**: This release provides updates to documentation and support for listing operations performed by AWS Systems Manager for SAP.

# Release (2023-01-23)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.29.0](service/lambda/CHANGELOG.md#v1290-2023-01-23)
  * **Feature**: Release Lambda RuntimeManagementConfig, enabling customers to better manage runtime updates to their Lambda functions. This release adds two new APIs, GetRuntimeManagementConfig and PutRuntimeManagementConfig, as well as support on existing Create/Get/Update function APIs.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.64.0](service/sagemaker/CHANGELOG.md#v1640-2023-01-23)
  * **Feature**: Amazon SageMaker Inference now supports P4de instance types.

# Release (2023-01-20)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.80.0](service/ec2/CHANGELOG.md#v1800-2023-01-20)
  * **Feature**: C6in, M6in, M6idn, R6in and R6idn instances are powered by 3rd Generation Intel Xeon Scalable processors (code named Ice Lake) with an all-core turbo frequency of 3.5 GHz.
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.20.0](service/ivs/CHANGELOG.md#v1200-2023-01-20)
  * **Feature**: API and Doc update. Update to arns field in BatchGetStreamKey. Also updates to operations and structures.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.30.0](service/quicksight/CHANGELOG.md#v1300-2023-01-20)
  * **Feature**: This release adds support for data bars in QuickSight table and increases pivot table field well limit.

# Release (2023-01-19)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.24.0](service/appflow/CHANGELOG.md#v1240-2023-01-19)
  * **Feature**: Adding support for Salesforce Pardot connector in Amazon AppFlow.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.20.0](service/cloudwatchlogs/CHANGELOG.md#v1200-2023-01-19)
  * **Feature**: Bug fix - Removed the regex pattern validation from CoralModel to avoid potential security issue.
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.15.0](service/codeartifact/CHANGELOG.md#v1150-2023-01-19)
  * **Feature**: Documentation updates for CodeArtifact
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.45.0](service/connect/CHANGELOG.md#v1450-2023-01-19)
  * **Feature**: Amazon Connect Chat introduces Persistent Chat, allowing customers to resume previous conversations with context and transcripts carried over from previous chats, eliminating the need to repeat themselves and allowing agents to provide personalized service with access to entire conversation history.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.15.0](service/connectparticipant/CHANGELOG.md#v1150-2023-01-19)
  * **Feature**: This release updates Amazon Connect Participant's GetTranscript api to provide transcripts of past chats on a persistent chat session.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.79.0](service/ec2/CHANGELOG.md#v1790-2023-01-19)
  * **Feature**: Adds SSM Parameter Resource Aliasing support to EC2 Launch Templates. Launch Templates can now store parameter aliases in place of AMI Resource IDs. CreateLaunchTemplateVersion and DescribeLaunchTemplateVersions now support a convenience flag, ResolveAlias, to return the resolved parameter value.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.40.0](service/glue/CHANGELOG.md#v1400-2023-01-19)
  * **Feature**: Release Glue Studio Hudi Data Lake Format for SDK/CLI
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.16.0](service/groundstation/CHANGELOG.md#v1160-2023-01-19)
  * **Feature**: Add configurable prepass and postpass times for DataflowEndpointGroup. Add Waiter to allow customers to wait for a contact that was reserved through ReserveContact
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.29.0](service/medialive/CHANGELOG.md#v1290-2023-01-19)
  * **Feature**: AWS Elemental MediaLive adds support for SCTE 35 preRollMilliSeconds.
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.13.0](service/opensearch/CHANGELOG.md#v1130-2023-01-19)
  * **Feature**: This release adds the enhanced dry run option, that checks for validation errors that might occur when deploying configuration changes and provides a summary of these errors, if any. The feature will also indicate whether a blue/green deployment will be required to apply a change.
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.11.0](service/panorama/CHANGELOG.md#v1110-2023-01-19)
  * **Feature**: Added AllowMajorVersionUpdate option to OTAJobConfig to make appliance software major version updates opt-in.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.63.0](service/sagemaker/CHANGELOG.md#v1630-2023-01-19)
  * **Feature**: HyperParameterTuningJobs now allow passing environment variables into the corresponding TrainingJobs

# Release (2023-01-18)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.25.0](service/cloudwatch/CHANGELOG.md#v1250-2023-01-18)
  * **Feature**: Enable cross-account streams in CloudWatch Metric Streams via Observability Access Manager.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.19.1](service/efs/CHANGELOG.md#v1191-2023-01-18)
  * **Documentation**: Documentation updates for EFS access points limit increase
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.24.2](service/wafv2/CHANGELOG.md#v1242-2023-01-18)
  * **Documentation**: Improved the visibility of the guidance for updating AWS WAF resources, such as web ACLs and rule groups.

# Release (2023-01-17)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.5.0](service/billingconductor/CHANGELOG.md#v150-2023-01-17)
  * **Feature**: This release adds support for SKU Scope for pricing plans.
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.22.0](service/imagebuilder/CHANGELOG.md#v1220-2023-01-17)
  * **Feature**: Add support for AWS Marketplace product IDs as input during CreateImageRecipe for the parent-image parameter. Add support for listing third-party components.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.24.0](service/networkfirewall/CHANGELOG.md#v1240-2023-01-17)
  * **Feature**: Network Firewall now allows creation of dual stack endpoints, enabling inspection of IPv6 traffic.

# Release (2023-01-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.44.0](service/connect/CHANGELOG.md#v1440-2023-01-13)
  * **Feature**: This release updates the responses of UpdateContactFlowContent, UpdateContactFlowMetadata, UpdateContactFlowName and DeleteContactFlow API with empty responses.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.78.0](service/ec2/CHANGELOG.md#v1780-2023-01-13)
  * **Feature**: Documentation updates for EC2.
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.25.0](service/outposts/CHANGELOG.md#v1250-2023-01-13)
  * **Feature**: This release adds POWER_30_KVA as an option for PowerDrawKva. PowerDrawKva is part of the RackPhysicalProperties structure in the CreateSite request.
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.14.0](service/resourcegroups/CHANGELOG.md#v1140-2023-01-13)
  * **Feature**: AWS Resource Groups customers can now turn on Group Lifecycle Events in their AWS account. When you turn this on, Resource Groups monitors your groups for changes to group state or membership. Those changes are sent to Amazon EventBridge as events that you can respond to using rules you create.

# Release (2023-01-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cleanrooms`: [v1.0.0](service/cleanrooms/CHANGELOG.md#v100-2023-01-12)
  * **Release**: New AWS service client module
  * **Feature**: Initial release of AWS Clean Rooms
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.19.0](service/cloudwatchlogs/CHANGELOG.md#v1190-2023-01-12)
  * **Feature**: Bug fix: logGroupName is now not a required field in GetLogEvents, FilterLogEvents, GetLogGroupFields, and DescribeLogStreams APIs as logGroupIdentifier can be provided instead
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.28.0](service/lambda/CHANGELOG.md#v1280-2023-01-12)
  * **Feature**: Add support for MaximumConcurrency parameter for SQS event source. Customers can now limit the maximum concurrent invocations for their SQS Event Source Mapping.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.30.0](service/mediaconvert/CHANGELOG.md#v1300-2023-01-12)
  * **Feature**: The AWS Elemental MediaConvert SDK has added support for compact DASH manifest generation, audio normalization using TruePeak measurements, and the ability to clip the sample range in the color corrector.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.18.1](service/secretsmanager/CHANGELOG.md#v1181-2023-01-12)
  * **Documentation**: Update documentation for new ListSecrets and DescribeSecret parameters

# Release (2023-01-11)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.38.0](service/kendra/CHANGELOG.md#v1380-2023-01-11)
  * **Feature**: This release adds support to new document types - RTF, XML, XSLT, MS_EXCEL, CSV, JSON, MD

# Release (2023-01-10)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.21.0](service/location/CHANGELOG.md#v1210-2023-01-10)
  * **Feature**: This release adds support for two new route travel models, Bicycle and Motorcycle which can be used with Grab data source.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.40.0](service/rds/CHANGELOG.md#v1400-2023-01-10)
  * **Feature**: This release adds support for configuring allocated storage on the CreateDBInstanceReadReplica, RestoreDBInstanceFromDBSnapshot, and RestoreDBInstanceToPointInTime APIs.

# Release (2023-01-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.15.0](service/ecrpublic/CHANGELOG.md#v1150-2023-01-09)
  * **Feature**: This release for Amazon ECR Public makes several change to bring the SDK into sync with the API.
* `github.com/aws/aws-sdk-go-v2/service/kendraranking`: [v1.0.0](service/kendraranking/CHANGELOG.md#v100-2023-01-09)
  * **Release**: New AWS service client module
  * **Feature**: Introducing Amazon Kendra Intelligent Ranking, a new set of Kendra APIs that leverages Kendra semantic ranking capabilities to improve the quality of search results from other search services (i.e. OpenSearch, ElasticSearch, Solr).
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.23.0](service/networkfirewall/CHANGELOG.md#v1230-2023-01-09)
  * **Feature**: Network Firewall now supports the Suricata rule action reject, in addition to the actions pass, drop, and alert.
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.9.0](service/workspacesweb/CHANGELOG.md#v190-2023-01-09)
  * **Feature**: This release adds support for a new portal authentication type: AWS IAM Identity Center (successor to AWS Single Sign-On).

# Release (2023-01-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.21.0](service/acmpca/CHANGELOG.md#v1210-2023-01-06)
  * **Feature**: Added revocation parameter validation: bucket names must match S3 bucket naming rules and CNAMEs conform to RFC2396 restrictions on the use of special characters in URIs.
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.23.0](service/auditmanager/CHANGELOG.md#v1230-2023-01-06)
  * **Feature**: This release introduces a new data retention option in your Audit Manager settings. You can now use the DeregistrationPolicy parameter to specify if you want to delete your data when you deregister Audit Manager.

# Release (2023-01-05)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.19.0](service/accessanalyzer/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/account`: [v1.8.0](service/account/CHANGELOG.md#v180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/acm`: [v1.17.0](service/acm/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/acmpca`: [v1.20.0](service/acmpca/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/alexaforbusiness`: [v1.15.0](service/alexaforbusiness/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/amp`: [v1.16.0](service/amp/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.13.0](service/amplify/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/amplifybackend`: [v1.14.0](service/amplifybackend/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Feature**: Updated GetBackendAPIModels response to include ModelIntrospectionSchema json string
* `github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder`: [v1.9.0](service/amplifyuibuilder/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.16.0](service/apigateway/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/apigatewaymanagementapi`: [v1.11.0](service/apigatewaymanagementapi/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/apigatewayv2`: [v1.13.0](service/apigatewayv2/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/appconfig`: [v1.15.0](service/appconfig/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/appconfigdata`: [v1.5.0](service/appconfigdata/CHANGELOG.md#v150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.23.0](service/appflow/CHANGELOG.md#v1230-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/appintegrations`: [v1.14.0](service/appintegrations/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.17.0](service/applicationautoscaling/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/applicationcostprofiler`: [v1.10.0](service/applicationcostprofiler/CHANGELOG.md#v1100-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/applicationdiscoveryservice`: [v1.15.0](service/applicationdiscoveryservice/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/applicationinsights`: [v1.17.0](service/applicationinsights/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/appmesh`: [v1.17.0](service/appmesh/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/apprunner`: [v1.16.0](service/apprunner/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Feature**: This release adds support of securely referencing secrets and configuration data that are stored in Secrets Manager and SSM Parameter Store by adding them as environment secrets in your App Runner service.
* `github.com/aws/aws-sdk-go-v2/service/appstream`: [v1.19.0](service/appstream/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.18.0](service/appsync/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.1.0](service/arczonalshift/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.22.0](service/athena/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.22.0](service/auditmanager/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.26.0](service/autoscaling/CHANGELOG.md#v1260-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/autoscalingplans`: [v1.13.0](service/autoscalingplans/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.19.0](service/backup/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.9.0](service/backupgateway/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/backupstorage`: [v1.1.0](service/backupstorage/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.21.0](service/batch/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.4.0](service/billingconductor/CHANGELOG.md#v140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/braket`: [v1.17.0](service/braket/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/budgets`: [v1.14.0](service/budgets/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/chime`: [v1.22.0](service/chime/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/chimesdkidentity`: [v1.10.0](service/chimesdkidentity/CHANGELOG.md#v1100-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines`: [v1.2.0](service/chimesdkmediapipelines/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmeetings`: [v1.14.0](service/chimesdkmeetings/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging`: [v1.12.0](service/chimesdkmessaging/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.1.0](service/chimesdkvoice/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloud9`: [v1.17.0](service/cloud9/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudcontrol`: [v1.11.0](service/cloudcontrol/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/clouddirectory`: [v1.13.0](service/clouddirectory/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.25.0](service/cloudformation/CHANGELOG.md#v1250-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.24.0](service/cloudfront/CHANGELOG.md#v1240-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudhsm`: [v1.13.0](service/cloudhsm/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudhsmv2`: [v1.14.0](service/cloudhsmv2/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudsearch`: [v1.14.0](service/cloudsearch/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudsearchdomain`: [v1.12.0](service/cloudsearchdomain/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.22.0](service/cloudtrail/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.24.0](service/cloudwatch/CHANGELOG.md#v1240-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchevents`: [v1.15.0](service/cloudwatchevents/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.18.0](service/cloudwatchlogs/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codeartifact`: [v1.14.0](service/codeartifact/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codebuild`: [v1.20.0](service/codebuild/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.1.0](service/codecatalyst/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codecommit`: [v1.14.0](service/codecommit/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codedeploy`: [v1.16.0](service/codedeploy/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codeguruprofiler`: [v1.13.0](service/codeguruprofiler/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codegurureviewer`: [v1.17.0](service/codegurureviewer/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codepipeline`: [v1.14.0](service/codepipeline/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codestar`: [v1.13.0](service/codestar/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codestarconnections`: [v1.14.0](service/codestarconnections/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/codestarnotifications`: [v1.14.0](service/codestarnotifications/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentity`: [v1.15.0](service/cognitoidentity/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider`: [v1.22.0](service/cognitoidentityprovider/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/cognitosync`: [v1.12.0](service/cognitosync/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.21.0](service/comprehend/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.15.0](service/comprehendmedical/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.20.0](service/computeoptimizer/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.29.0](service/configservice/CHANGELOG.md#v1290-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.43.0](service/connect/CHANGELOG.md#v1430-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Feature**: Documentation update for a new Initiation Method value in DescribeContact API
* `github.com/aws/aws-sdk-go-v2/service/connectcampaigns`: [v1.2.0](service/connectcampaigns/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/connectcases`: [v1.2.0](service/connectcases/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/connectcontactlens`: [v1.13.0](service/connectcontactlens/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.14.0](service/connectparticipant/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/controltower`: [v1.1.0](service/controltower/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/costandusagereportservice`: [v1.15.0](service/costandusagereportservice/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.25.0](service/costexplorer/CHANGELOG.md#v1250-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.22.0](service/customerprofiles/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.23.0](service/databasemigrationservice/CHANGELOG.md#v1230-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/databrew`: [v1.21.0](service/databrew/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.18.0](service/dataexchange/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/datapipeline`: [v1.14.0](service/datapipeline/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.21.0](service/datasync/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/dax`: [v1.12.0](service/dax/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.18.0](service/detective/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/devicefarm`: [v1.15.0](service/devicefarm/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/devopsguru`: [v1.21.0](service/devopsguru/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/directconnect`: [v1.18.0](service/directconnect/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/directoryservice`: [v1.16.0](service/directoryservice/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/dlm`: [v1.14.0](service/dlm/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/docdb`: [v1.20.0](service/docdb/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.1.0](service/docdbelastic/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.10.0](service/drs/CHANGELOG.md#v1100-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.18.0](service/dynamodb/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.14.0](service/dynamodbstreams/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ebs`: [v1.16.0](service/ebs/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ec2instanceconnect`: [v1.15.0](service/ec2instanceconnect/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ecr`: [v1.18.0](service/ecr/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ecrpublic`: [v1.14.0](service/ecrpublic/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.23.0](service/ecs/CHANGELOG.md#v1230-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.19.0](service/efs/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.27.0](service/eks/CHANGELOG.md#v1270-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.26.0](service/elasticache/CHANGELOG.md#v1260-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk`: [v1.15.0](service/elasticbeanstalk/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elasticinference`: [v1.12.0](service/elasticinference/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing`: [v1.15.0](service/elasticloadbalancing/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.19.0](service/elasticloadbalancingv2/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elasticsearchservice`: [v1.18.0](service/elasticsearchservice/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/elastictranscoder`: [v1.14.0](service/elastictranscoder/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.22.0](service/emr/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/emrcontainers`: [v1.16.0](service/emrcontainers/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.5.0](service/emrserverless/CHANGELOG.md#v150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Feature**: Adds support for customized images. You can now provide runtime images when creating or updating EMR Serverless Applications.
* `github.com/aws/aws-sdk-go-v2/service/eventbridge`: [v1.17.0](service/eventbridge/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/evidently`: [v1.10.0](service/evidently/CHANGELOG.md#v1100-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/finspace`: [v1.9.0](service/finspace/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/finspacedata`: [v1.14.0](service/finspacedata/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.16.0](service/firehose/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/fis`: [v1.14.0](service/fis/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.22.0](service/fms/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/forecast`: [v1.24.0](service/forecast/CHANGELOG.md#v1240-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/forecastquery`: [v1.13.0](service/forecastquery/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/frauddetector`: [v1.21.0](service/frauddetector/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.28.0](service/fsx/CHANGELOG.md#v1280-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.17.0](service/gamelift/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/gamesparks`: [v1.2.0](service/gamesparks/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/glacier`: [v1.14.0](service/glacier/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/globalaccelerator`: [v1.16.0](service/globalaccelerator/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.39.0](service/glue/CHANGELOG.md#v1390-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.11.0](service/grafana/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/greengrass`: [v1.15.0](service/greengrass/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.21.0](service/greengrassv2/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/groundstation`: [v1.15.0](service/groundstation/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.17.0](service/guardduty/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/health`: [v1.16.0](service/health/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/healthlake`: [v1.15.0](service/healthlake/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/honeycode`: [v1.13.0](service/honeycode/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iam`: [v1.19.0](service/iam/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/identitystore`: [v1.16.0](service/identitystore/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/imagebuilder`: [v1.21.0](service/imagebuilder/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/inspector`: [v1.13.0](service/inspector/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.11.0](service/inspector2/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.33.0](service/iot/CHANGELOG.md#v1330-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iot1clickdevicesservice`: [v1.11.0](service/iot1clickdevicesservice/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iot1clickprojects`: [v1.12.0](service/iot1clickprojects/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotanalytics`: [v1.14.0](service/iotanalytics/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.14.0](service/iotdataplane/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.17.0](service/iotdeviceadvisor/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotevents`: [v1.15.0](service/iotevents/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ioteventsdata`: [v1.13.0](service/ioteventsdata/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotfleethub`: [v1.13.0](service/iotfleethub/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.3.0](service/iotfleetwise/CHANGELOG.md#v130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane`: [v1.12.0](service/iotjobsdataplane/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotroborunner`: [v1.1.0](service/iotroborunner/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotsecuretunneling`: [v1.15.0](service/iotsecuretunneling/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotsitewise`: [v1.27.0](service/iotsitewise/CHANGELOG.md#v1270-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotthingsgraph`: [v1.14.0](service/iotthingsgraph/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.10.0](service/iottwinmaker/CHANGELOG.md#v1100-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.24.0](service/iotwireless/CHANGELOG.md#v1240-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ivs`: [v1.19.0](service/ivs/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.3.0](service/ivschat/CHANGELOG.md#v130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kafka`: [v1.19.0](service/kafka/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kafkaconnect`: [v1.9.0](service/kafkaconnect/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.37.0](service/kendra/CHANGELOG.md#v1370-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/keyspaces`: [v1.1.0](service/keyspaces/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.17.0](service/kinesis/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalytics`: [v1.14.0](service/kinesisanalytics/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.16.0](service/kinesisanalyticsv2/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.15.0](service/kinesisvideo/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideoarchivedmedia`: [v1.14.0](service/kinesisvideoarchivedmedia/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia`: [v1.11.0](service/kinesisvideomedia/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideosignaling`: [v1.11.0](service/kinesisvideosignaling/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.2.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.20.0](service/kms/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lakeformation`: [v1.19.0](service/lakeformation/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.27.0](service/lambda/CHANGELOG.md#v1270-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lexmodelbuildingservice`: [v1.17.0](service/lexmodelbuildingservice/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lexmodelsv2`: [v1.27.0](service/lexmodelsv2/CHANGELOG.md#v1270-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lexruntimeservice`: [v1.13.0](service/lexruntimeservice/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lexruntimev2`: [v1.16.0](service/lexruntimev2/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/licensemanager`: [v1.17.0](service/licensemanager/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.1.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.2.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lightsail`: [v1.25.0](service/lightsail/CHANGELOG.md#v1250-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Documentation**: Documentation updates for Amazon Lightsail.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.20.0](service/location/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.17.0](service/lookoutequipment/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lookoutmetrics`: [v1.19.0](service/lookoutmetrics/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.15.0](service/lookoutvision/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.3.0](service/m2/CHANGELOG.md#v130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/machinelearning`: [v1.15.0](service/machinelearning/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/macie`: [v1.15.0](service/macie/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.26.0](service/macie2/CHANGELOG.md#v1260-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/managedblockchain`: [v1.14.0](service/managedblockchain/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/marketplacecatalog`: [v1.15.0](service/marketplacecatalog/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/marketplacecommerceanalytics`: [v1.12.0](service/marketplacecommerceanalytics/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.12.0](service/marketplaceentitlementservice/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/marketplacemetering`: [v1.14.0](service/marketplacemetering/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediaconnect`: [v1.18.0](service/mediaconnect/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.29.0](service/mediaconvert/CHANGELOG.md#v1290-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.28.0](service/medialive/CHANGELOG.md#v1280-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediapackage`: [v1.20.0](service/mediapackage/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.21.0](service/mediapackagevod/CHANGELOG.md#v1210-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediastore`: [v1.13.0](service/mediastore/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediastoredata`: [v1.13.0](service/mediastoredata/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mediatailor`: [v1.20.0](service/mediatailor/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.12.0](service/memorydb/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.17.0](service/mgn/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/migrationhub`: [v1.13.0](service/migrationhub/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/migrationhubconfig`: [v1.13.0](service/migrationhubconfig/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/migrationhuborchestrator`: [v1.1.0](service/migrationhuborchestrator/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.8.0](service/migrationhubrefactorspaces/CHANGELOG.md#v180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.7.0](service/migrationhubstrategy/CHANGELOG.md#v170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mobile`: [v1.12.0](service/mobile/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mq`: [v1.14.0](service/mq/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mturk`: [v1.14.0](service/mturk/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/mwaa`: [v1.14.0](service/mwaa/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Documentation**: MWAA supports Apache Airflow version 2.4.3.
* `github.com/aws/aws-sdk-go-v2/service/neptune`: [v1.19.0](service/neptune/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.22.0](service/networkfirewall/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.17.0](service/networkmanager/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.16.0](service/nimble/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.1.0](service/oam/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.1.0](service/omics/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/opensearch`: [v1.12.0](service/opensearch/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.1.0](service/opensearchserverless/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/opsworks`: [v1.14.0](service/opsworks/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/opsworkscm`: [v1.15.0](service/opsworkscm/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.18.0](service/organizations/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/outposts`: [v1.24.0](service/outposts/CHANGELOG.md#v1240-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/panorama`: [v1.10.0](service/panorama/CHANGELOG.md#v1100-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.23.0](service/personalize/CHANGELOG.md#v1230-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.13.0](service/personalizeevents/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/personalizeruntime`: [v1.13.0](service/personalizeruntime/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pi`: [v1.16.0](service/pi/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pinpoint`: [v1.18.0](service/pinpoint/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pinpointemail`: [v1.12.0](service/pinpointemail/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoice`: [v1.11.0](service/pinpointsmsvoice/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2`: [v1.1.0](service/pinpointsmsvoicev2/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.1.0](service/pipes/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.22.0](service/polly/CHANGELOG.md#v1220-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/pricing`: [v1.18.0](service/pricing/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/privatenetworks`: [v1.1.0](service/privatenetworks/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.19.0](service/proton/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/qldb`: [v1.15.0](service/qldb/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/qldbsession`: [v1.14.0](service/qldbsession/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.29.0](service/quicksight/CHANGELOG.md#v1290-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ram`: [v1.17.0](service/ram/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.8.0](service/rbin/CHANGELOG.md#v180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.39.0](service/rds/CHANGELOG.md#v1390-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
  * **Feature**: This release adds support for specifying which certificate authority (CA) to use for a DB instance's server certificate during DB instance creation, as well as other CA enhancements.
* `github.com/aws/aws-sdk-go-v2/service/rdsdata`: [v1.13.0](service/rdsdata/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/redshift`: [v1.27.0](service/redshift/CHANGELOG.md#v1270-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.18.0](service/redshiftdata/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.4.0](service/redshiftserverless/CHANGELOG.md#v140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.23.0](service/rekognition/CHANGELOG.md#v1230-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/resiliencehub`: [v1.8.0](service/resiliencehub/CHANGELOG.md#v180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.2.0](service/resourceexplorer2/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/resourcegroups`: [v1.13.0](service/resourcegroups/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi`: [v1.14.0](service/resourcegroupstaggingapi/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/robomaker`: [v1.18.0](service/robomaker/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/rolesanywhere`: [v1.1.0](service/rolesanywhere/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.26.0](service/route53/CHANGELOG.md#v1260-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.14.0](service/route53domains/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycluster`: [v1.11.0](service/route53recoverycluster/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.11.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/route53recoveryreadiness`: [v1.9.0](service/route53recoveryreadiness/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/route53resolver`: [v1.16.0](service/route53resolver/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.9.0](service/rum/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/s3`: [v1.30.0](service/s3/CHANGELOG.md#v1300-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.29.0](service/s3control/CHANGELOG.md#v1290-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/s3outposts`: [v1.14.0](service/s3outposts/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.62.0](service/sagemaker/CHANGELOG.md#v1620-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sagemakera2iruntime`: [v1.15.0](service/sagemakera2iruntime/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sagemakeredge`: [v1.13.0](service/sagemakeredge/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.13.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.1.0](service/sagemakergeospatial/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sagemakerruntime`: [v1.17.0](service/sagemakerruntime/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/savingsplans`: [v1.12.0](service/savingsplans/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/scheduler`: [v1.1.0](service/scheduler/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/schemas`: [v1.15.0](service/schemas/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.18.0](service/secretsmanager/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.27.0](service/securityhub/CHANGELOG.md#v1270-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.2.0](service/securitylake/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/serverlessapplicationrepository`: [v1.12.0](service/serverlessapplicationrepository/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.16.0](service/servicecatalog/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.16.0](service/servicecatalogappregistry/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/servicediscovery`: [v1.19.0](service/servicediscovery/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/servicequotas`: [v1.14.0](service/servicequotas/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ses`: [v1.15.0](service/ses/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sesv2`: [v1.16.0](service/sesv2/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.17.0](service/sfn/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/shield`: [v1.18.0](service/shield/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/signer`: [v1.14.0](service/signer/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.1.0](service/simspaceweaver/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sms`: [v1.13.0](service/sms/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/snowball`: [v1.17.0](service/snowball/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/snowdevicemanagement`: [v1.9.0](service/snowdevicemanagement/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.19.0](service/sns/CHANGELOG.md#v1190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sqs`: [v1.20.0](service/sqs/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.35.0](service/ssm/CHANGELOG.md#v1350-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ssmcontacts`: [v1.14.0](service/ssmcontacts/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.20.0](service/ssmincidents/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.1.0](service/ssmsap/CHANGELOG.md#v110-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sso`: [v1.12.0](service/sso/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ssoadmin`: [v1.16.0](service/ssoadmin/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/ssooidc`: [v1.14.0](service/ssooidc/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/storagegateway`: [v1.18.0](service/storagegateway/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.18.0](service/sts/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.14.0](service/support/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/supportapp`: [v1.2.0](service/supportapp/CHANGELOG.md#v120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/swf`: [v1.14.0](service/swf/CHANGELOG.md#v1140-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/synthetics`: [v1.17.0](service/synthetics/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.20.0](service/textract/CHANGELOG.md#v1200-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/timestreamquery`: [v1.15.0](service/timestreamquery/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/timestreamwrite`: [v1.15.0](service/timestreamwrite/CHANGELOG.md#v1150-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.25.0](service/transcribe/CHANGELOG.md#v1250-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.9.0](service/transcribestreaming/CHANGELOG.md#v190-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.28.0](service/transfer/CHANGELOG.md#v1280-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.17.0](service/translate/CHANGELOG.md#v1170-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/voiceid`: [v1.12.0](service/voiceid/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/waf`: [v1.12.0](service/waf/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/wafregional`: [v1.13.0](service/wafregional/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.24.0](service/wafv2/CHANGELOG.md#v1240-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/wellarchitected`: [v1.18.0](service/wellarchitected/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.12.0](service/wisdom/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/workdocs`: [v1.13.0](service/workdocs/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/worklink`: [v1.13.0](service/worklink/CHANGELOG.md#v1130-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/workmail`: [v1.18.0](service/workmail/CHANGELOG.md#v1180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/workmailmessageflow`: [v1.12.0](service/workmailmessageflow/CHANGELOG.md#v1120-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.28.0](service/workspaces/CHANGELOG.md#v1280-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/workspacesweb`: [v1.8.0](service/workspacesweb/CHANGELOG.md#v180-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.16.0](service/xray/CHANGELOG.md#v1160-2023-01-05)
  * **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).

# Release (2023-01-04)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/applicationautoscaling`: [v1.16.0](service/applicationautoscaling/CHANGELOG.md#v1160-2023-01-04)
  * **Feature**: Customers can now use the existing DescribeScalingActivities API to also see the detailed and machine-readable reasons for Application Auto Scaling not scaling their resources and, if needed, take the necessary corrective actions.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.17.4](service/cloudwatchlogs/CHANGELOG.md#v1174-2023-01-04)
  * **Documentation**: Update to remove sequenceToken as a required field in PutLogEvents calls.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.34.0](service/ssm/CHANGELOG.md#v1340-2023-01-04)
  * **Feature**: Adding support for QuickSetup Document Type in Systems Manager

# Release (2023-01-03)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.1.0](service/securitylake/CHANGELOG.md#v110-2023-01-03)
  * **Feature**: Allow CreateSubscriber API to take string input that allows setting more descriptive SubscriberDescription field. Make souceTypes field required in model level for UpdateSubscriberRequest as it is required for every API call on the backend. Allow ListSubscribers take any String as nextToken param.

# Release (2022-12-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.23.0](service/cloudfront/CHANGELOG.md#v1230-2022-12-30)
  * **Feature**: Extend response headers policy to support removing headers from viewer responses
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.2.1](service/iotfleetwise/CHANGELOG.md#v121-2022-12-30)
  * **Documentation**: Update documentation - correct the epoch constant value of default value for expiryTime field in CreateCampaign request.

# Release (2022-12-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/apigateway`: [v1.15.28](service/apigateway/CHANGELOG.md#v11528-2022-12-29)
  * **Documentation**: Documentation updates for Amazon API Gateway
* `github.com/aws/aws-sdk-go-v2/service/emr`: [v1.21.0](service/emr/CHANGELOG.md#v1210-2022-12-29)
  * **Feature**: Added GetClusterSessionCredentials API to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters with runtime roles and AWS Lake Formation-based access control for Apache Spark, Apache Hive, and Presto queries.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.17.0](service/secretsmanager/CHANGELOG.md#v1170-2022-12-29)
  * **Feature**: Added owning service filter, include planned deletion flag, and next rotation date response parameter in ListSecrets.
* `github.com/aws/aws-sdk-go-v2/service/wisdom`: [v1.11.0](service/wisdom/CHANGELOG.md#v1110-2022-12-29)
  * **Feature**: This release extends Wisdom CreateContent and StartContentUpload APIs to support PDF and MicrosoftWord docx document uploading.

# Release (2022-12-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.25.0](service/elasticache/CHANGELOG.md#v1250-2022-12-28)
  * **Feature**: This release allows you to modify the encryption in transit setting, for existing Redis clusters. You can now change the TLS configuration of your Redis clusters without the need to re-build or re-provision the clusters or impact application availability.
* `github.com/aws/aws-sdk-go-v2/service/networkfirewall`: [v1.21.0](service/networkfirewall/CHANGELOG.md#v1210-2022-12-28)
  * **Feature**: AWS Network Firewall now provides status messages for firewalls to help you troubleshoot when your endpoint fails.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.38.0](service/rds/CHANGELOG.md#v1380-2022-12-28)
  * **Feature**: This release adds support for Custom Engine Version (CEV) on RDS Custom SQL Server.
* `github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig`: [v1.10.0](service/route53recoverycontrolconfig/CHANGELOG.md#v1100-2022-12-28)
  * **Feature**: Added support for Python paginators in the route53-recovery-control-config List* APIs.

# Release (2022-12-27)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/memorydb`: [v1.11.0](service/memorydb/CHANGELOG.md#v1110-2022-12-27)
  * **Feature**: This release adds support for MemoryDB Reserved nodes which provides a significant discount compared to on-demand node pricing. Reserved nodes are not physical nodes, but rather a billing discount applied to the use of on-demand nodes in your account.
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.27.0](service/transfer/CHANGELOG.md#v1270-2022-12-27)
  * **Feature**: Add additional operations to throw ThrottlingExceptions

# Release (2022-12-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.42.0](service/connect/CHANGELOG.md#v1420-2022-12-23)
  * **Feature**: Support for Routing Profile filter, SortCriteria, and grouping by Routing Profiles for GetCurrentMetricData API. Support for RoutingProfiles, UserHierarchyGroups, and Agents as filters, NextStatus and AgentStatusName for GetCurrentUserData. Adds ApproximateTotalCount to both APIs.
* `github.com/aws/aws-sdk-go-v2/service/connectparticipant`: [v1.13.0](service/connectparticipant/CHANGELOG.md#v1130-2022-12-23)
  * **Feature**: Amazon Connect Chat introduces the Message Receipts feature. This feature allows agents and customers to receive message delivered and read receipts after they send a chat message.
* `github.com/aws/aws-sdk-go-v2/service/detective`: [v1.17.0](service/detective/CHANGELOG.md#v1170-2022-12-23)
  * **Feature**: This release adds a missed AccessDeniedException type to several endpoints.
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.27.0](service/fsx/CHANGELOG.md#v1270-2022-12-23)
  * **Feature**: Fix a bug where a recent release might break certain existing SDKs.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.10.0](service/inspector2/CHANGELOG.md#v1100-2022-12-23)
  * **Feature**: Amazon Inspector adds support for scanning NodeJS 18.x and Go 1.x AWS Lambda function runtimes.

# Release (2022-12-22)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.19.0](service/computeoptimizer/CHANGELOG.md#v1190-2022-12-22)
  * **Feature**: This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for ecs services running on Fargate.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.41.0](service/connect/CHANGELOG.md#v1410-2022-12-22)
  * **Feature**: Amazon Connect Chat introduces the Idle Participant/Autodisconnect feature, which allows users to set timeouts relating to the activity of chat participants, using the new UpdateParticipantRoleConfig API.
* `github.com/aws/aws-sdk-go-v2/service/iotdeviceadvisor`: [v1.16.0](service/iotdeviceadvisor/CHANGELOG.md#v1160-2022-12-22)
  * **Feature**: This release adds the following new features: 1) Documentation updates for IoT Device Advisor APIs. 2) Updated required request parameters for IoT Device Advisor APIs. 3) Added new service feature: ability to provide the test endpoint when customer executing the StartSuiteRun API.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.1.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v110-2022-12-22)
  * **Feature**: Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.37.0](service/rds/CHANGELOG.md#v1370-2022-12-22)
  * **Feature**: Add support for managing master user password in AWS Secrets Manager for the DBInstance and DBCluster.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.16.11](service/secretsmanager/CHANGELOG.md#v11611-2022-12-22)
  * **Documentation**: Documentation updates for Secrets Manager

# Release (2022-12-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions`: [v1.0.0](service/licensemanagerlinuxsubscriptions/CHANGELOG.md#v100-2022-12-21)
  * **Release**: New AWS service client module
  * **Feature**: AWS License Manager now offers cross-region, cross-account tracking of commercial Linux subscriptions on AWS. This includes subscriptions purchased as part of EC2 subscription-included AMIs, on the AWS Marketplace, or brought to AWS via Red Hat Cloud Access Program.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.25.0](service/macie2/CHANGELOG.md#v1250-2022-12-21)
  * **Feature**: This release adds support for analyzing Amazon S3 objects that use the S3 Glacier Instant Retrieval (Glacier_IR) storage class.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.61.0](service/sagemaker/CHANGELOG.md#v1610-2022-12-21)
  * **Feature**: This release enables adding RStudio Workbench support to an existing Amazon SageMaker Studio domain. It allows setting your RStudio on SageMaker environment configuration parameters and also updating the RStudioConnectUrl and RStudioPackageManagerUrl parameters for existing domains
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.33.4](service/ssm/CHANGELOG.md#v1334-2022-12-21)
  * **Documentation**: Doc-only updates for December 2022.
* `github.com/aws/aws-sdk-go-v2/service/support`: [v1.13.22](service/support/CHANGELOG.md#v11322-2022-12-21)
  * **Documentation**: Documentation updates for the AWS Support API
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.26.0](service/transfer/CHANGELOG.md#v1260-2022-12-21)
  * **Feature**: This release adds support for Decrypt as a workflow step type.

# Release (2022-12-20)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.20.0](service/batch/CHANGELOG.md#v1200-2022-12-20)
  * **Feature**: Adds isCancelled and isTerminated to DescribeJobs response.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.77.0](service/ec2/CHANGELOG.md#v1770-2022-12-20)
  * **Feature**: Adds support for pagination in the EC2 DescribeImages API.
* `github.com/aws/aws-sdk-go-v2/service/lookoutequipment`: [v1.16.0](service/lookoutequipment/CHANGELOG.md#v1160-2022-12-20)
  * **Feature**: This release adds support for listing inference schedulers by status.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.27.0](service/medialive/CHANGELOG.md#v1270-2022-12-20)
  * **Feature**: This release adds support for two new features to AWS Elemental MediaLive. First, you can now burn-in timecodes to your MediaLive outputs. Second, we now now support the ability to decode Dolby E audio when it comes in on an input.
* `github.com/aws/aws-sdk-go-v2/service/nimble`: [v1.15.0](service/nimble/CHANGELOG.md#v1150-2022-12-20)
  * **Feature**: Amazon Nimble Studio now supports configuring session storage volumes and persistence, as well as backup and restore sessions through launch profiles.
* `github.com/aws/aws-sdk-go-v2/service/resourceexplorer2`: [v1.1.0](service/resourceexplorer2/CHANGELOG.md#v110-2022-12-20)
  * **Feature**: Documentation updates for AWS Resource Explorer.
* `github.com/aws/aws-sdk-go-v2/service/route53domains`: [v1.13.0](service/route53domains/CHANGELOG.md#v1130-2022-12-20)
  * **Feature**: Use Route 53 domain APIs to change owner, create/delete DS record, modify IPS tag, resend authorization. New: AssociateDelegationSignerToDomain, DisassociateDelegationSignerFromDomain, PushDomain, ResendOperationAuthorization. Updated: UpdateDomainContact, ListOperations, CheckDomainTransferability.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.60.0](service/sagemaker/CHANGELOG.md#v1600-2022-12-20)
  * **Feature**: Amazon SageMaker Autopilot adds support for new objective metrics in CreateAutoMLJob API.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.24.0](service/transcribe/CHANGELOG.md#v1240-2022-12-20)
  * **Feature**: Enable our batch transcription jobs for Swedish and Vietnamese.

# Release (2022-12-19)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.21.0](service/athena/CHANGELOG.md#v1210-2022-12-19)
  * **Feature**: Add missed InvalidRequestException in GetCalculationExecutionCode,StopCalculationExecution APIs. Correct required parameters (Payload and Type) in UpdateNotebook API. Change Notebook size from 15 Mb to 10 Mb.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.22.0](service/ecs/CHANGELOG.md#v1220-2022-12-19)
  * **Feature**: This release adds support for alarm-based rollbacks in ECS, a new feature that allows customers to add automated safeguards for Amazon ECS service rolling updates.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.14.0](service/kinesisvideo/CHANGELOG.md#v1140-2022-12-19)
  * **Feature**: Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideowebrtcstorage`: [v1.0.0](service/kinesisvideowebrtcstorage/CHANGELOG.md#v100-2022-12-19)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.36.0](service/rds/CHANGELOG.md#v1360-2022-12-19)
  * **Feature**: Add support for --enable-customer-owned-ip to RDS create-db-instance-read-replica API for RDS on Outposts.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.59.0](service/sagemaker/CHANGELOG.md#v1590-2022-12-19)
  * **Feature**: AWS Sagemaker - Sagemaker Images now supports Aliases as secondary identifiers for ImageVersions. SageMaker Images now supports additional metadata for ImageVersions for better images management.

# Release (2022-12-16)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.22.0](service/appflow/CHANGELOG.md#v1220-2022-12-16)
  * **Feature**: This release updates the ListConnectorEntities API action so that it returns paginated responses that customers can retrieve with next tokens.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.22.2](service/cloudfront/CHANGELOG.md#v1222-2022-12-16)
  * **Documentation**: Updated documentation for CloudFront
* `github.com/aws/aws-sdk-go-v2/service/datasync`: [v1.20.0](service/datasync/CHANGELOG.md#v1200-2022-12-16)
  * **Feature**: AWS DataSync now supports the use of tags with task executions. With this new feature, you can apply tags each time you execute a task, giving you greater control and management over your task executions.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.18.3](service/efs/CHANGELOG.md#v1183-2022-12-16)
  * **Documentation**: General documentation updates for EFS.
* `github.com/aws/aws-sdk-go-v2/service/guardduty`: [v1.16.6](service/guardduty/CHANGELOG.md#v1166-2022-12-16)
  * **Documentation**: This release provides the valid characters for the Description and Name field.
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.2.0](service/iotfleetwise/CHANGELOG.md#v120-2022-12-16)
  * **Feature**: Updated error handling for empty resource names in "UpdateSignalCatalog" and "GetModelManifest" operations.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.58.0](service/sagemaker/CHANGELOG.md#v1580-2022-12-16)
  * **Feature**: AWS sagemaker - Features: This release adds support for random seed, it's an integer value used to initialize a pseudo-random number generator. Setting a random seed will allow the hyperparameter tuning search strategies to produce more consistent configurations for the same tuning job.

# Release (2022-12-15)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2`: v1.17.3
  * **Bug Fix**: Unify logic between shared config and in finding home directory
* `github.com/aws/aws-sdk-go-v2/config`: [v1.18.5](config/CHANGELOG.md#v1185-2022-12-15)
  * **Bug Fix**: Unify logic between shared config and in finding home directory
* `github.com/aws/aws-sdk-go-v2/credentials`: [v1.13.5](credentials/CHANGELOG.md#v1135-2022-12-15)
  * **Bug Fix**: Unify logic between shared config and in finding home directory
* `github.com/aws/aws-sdk-go-v2/service/backupgateway`: [v1.8.0](service/backupgateway/CHANGELOG.md#v180-2022-12-15)
  * **Feature**: This release adds support for VMware vSphere tags, enabling customer to protect VMware virtual machines using tag-based policies for AWS tags mapped from vSphere tags. This release also adds support for customer-accessible gateway-hypervisor interaction log and upload bandwidth rate limit schedule.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.40.0](service/connect/CHANGELOG.md#v1400-2022-12-15)
  * **Feature**: Added support for "English - New Zealand" and "English - South African" to be used with Amazon Connect Custom Vocabulary APIs.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.21.0](service/ecs/CHANGELOG.md#v1210-2022-12-15)
  * **Feature**: This release adds support for container port ranges in ECS, a new capability that allows customers to provide container port ranges to simplify use cases where multiple ports are in use in a container. This release updates TaskDefinition mutation APIs and the Task description APIs.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.26.0](service/eks/CHANGELOG.md#v1260-2022-12-15)
  * **Feature**: Add support for Windows managed nodes groups.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.38.0](service/glue/CHANGELOG.md#v1380-2022-12-15)
  * **Feature**: This release adds support for AWS Glue Crawler with native DeltaLake tables, allowing Crawlers to classify Delta Lake format tables and catalog them for query engines to query against.
* `github.com/aws/aws-sdk-go-v2/service/kinesis`: [v1.16.0](service/kinesis/CHANGELOG.md#v1160-2022-12-15)
  * **Feature**: Added StreamARN parameter for Kinesis Data Streams APIs. Added a new opaque pagination token for ListStreams. SDKs will auto-generate Account Endpoint when accessing Kinesis Data Streams.
* `github.com/aws/aws-sdk-go-v2/service/location`: [v1.19.5](service/location/CHANGELOG.md#v1195-2022-12-15)
  * **Documentation**: This release adds support for a new style, "VectorOpenDataStandardLight" which can be used with the new data source, "Open Data Maps (Preview)".
* `github.com/aws/aws-sdk-go-v2/service/m2`: [v1.2.0](service/m2/CHANGELOG.md#v120-2022-12-15)
  * **Feature**: Adds an optional create-only `KmsKeyId` property to Environment and Application resources.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.57.0](service/sagemaker/CHANGELOG.md#v1570-2022-12-15)
  * **Feature**: SageMaker Inference Recommender now allows customers to load tests their models on various instance types using private VPC.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.26.0](service/securityhub/CHANGELOG.md#v1260-2022-12-15)
  * **Feature**: Added new resource details objects to ASFF, including resources for AwsEc2LaunchTemplate, AwsSageMakerNotebookInstance, AwsWafv2WebAcl and AwsWafv2RuleGroup.
* `github.com/aws/aws-sdk-go-v2/service/translate`: [v1.16.0](service/translate/CHANGELOG.md#v1160-2022-12-15)
  * **Feature**: Raised the input byte size limit of the Text field in the TranslateText API to 10000 bytes.

# Release (2022-12-14)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.23.0](service/cloudwatch/CHANGELOG.md#v1230-2022-12-14)
  * **Feature**: Adding support for Metrics Insights Alarms
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.24.0](service/costexplorer/CHANGELOG.md#v1240-2022-12-14)
  * **Feature**: This release supports percentage-based thresholds on Cost Anomaly Detection alert subscriptions.
* `github.com/aws/aws-sdk-go-v2/service/networkmanager`: [v1.16.0](service/networkmanager/CHANGELOG.md#v1160-2022-12-14)
  * **Feature**: Appliance Mode support for AWS Cloud WAN.
* `github.com/aws/aws-sdk-go-v2/service/redshiftdata`: [v1.17.0](service/redshiftdata/CHANGELOG.md#v1170-2022-12-14)
  * **Feature**: This release adds a new --client-token field to ExecuteStatement and BatchExecuteStatement operations. Customers can now run queries with the additional client token parameter to ensures idempotency.
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.0.1](service/sagemakermetrics/CHANGELOG.md#v101-2022-12-14)
  * **Documentation**: Update SageMaker Metrics documentation.

# Release (2022-12-13)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudtrail`: [v1.21.0](service/cloudtrail/CHANGELOG.md#v1210-2022-12-13)
  * **Feature**: Merging mainline branch for service model into mainline release branch. There are no new APIs.
* `github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice`: [v1.11.21](service/marketplaceentitlementservice/CHANGELOG.md#v11121-2022-12-13)
  * **Bug Fix**: Fixing a shape type in the marketplaceentitlementservice client
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.35.0](service/rds/CHANGELOG.md#v1350-2022-12-13)
  * **Feature**: This deployment adds ClientPasswordAuthType field to the Auth structure of the DBProxy.

# Release (2022-12-12)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/customerprofiles`: [v1.21.0](service/customerprofiles/CHANGELOG.md#v1210-2022-12-12)
  * **Feature**: This release allows custom strings in PartyType and Gender through 2 new attributes in the CreateProfile and UpdateProfile APIs: PartyTypeString and GenderString.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.76.0](service/ec2/CHANGELOG.md#v1760-2022-12-12)
  * **Feature**: This release updates DescribeFpgaImages to show supported instance types of AFIs in its response.
* `github.com/aws/aws-sdk-go-v2/service/kinesisvideo`: [v1.13.0](service/kinesisvideo/CHANGELOG.md#v1130-2022-12-12)
  * **Feature**: This release adds support for public preview of Kinesis Video Stream at Edge enabling customers to provide configuration for the Kinesis Video Stream EdgeAgent running on an on-premise IoT device. Customers can now locally record from cameras and stream videos to the cloud on configured schedule.
* `github.com/aws/aws-sdk-go-v2/service/lookoutvision`: [v1.14.13](service/lookoutvision/CHANGELOG.md#v11413-2022-12-12)
  * **Documentation**: This documentation update adds kms:GenerateDataKey as a required permission to StartModelPackagingJob.
* `github.com/aws/aws-sdk-go-v2/service/migrationhubrefactorspaces`: [v1.7.0](service/migrationhubrefactorspaces/CHANGELOG.md#v170-2022-12-12)
  * **Feature**: This release adds support for Lambda alias service endpoints. Lambda alias ARNs can now be passed into CreateService.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.34.0](service/rds/CHANGELOG.md#v1340-2022-12-12)
  * **Feature**: Update the RDS API model to support copying option groups during the CopyDBSnapshot operation
* `github.com/aws/aws-sdk-go-v2/service/rekognition`: [v1.22.0](service/rekognition/CHANGELOG.md#v1220-2022-12-12)
  * **Feature**: Adds support for "aliases" and "categories", inclusion and exclusion filters for labels and label categories, and aggregating labels by video segment timestamps for Stored Video Label Detection APIs.
* `github.com/aws/aws-sdk-go-v2/service/sagemakermetrics`: [v1.0.0](service/sagemakermetrics/CHANGELOG.md#v100-2022-12-12)
  * **Release**: New AWS service client module
  * **Feature**: This release introduces support SageMaker Metrics APIs.
* `github.com/aws/aws-sdk-go-v2/service/wafv2`: [v1.23.3](service/wafv2/CHANGELOG.md#v1233-2022-12-12)
  * **Documentation**: Documents the naming requirement for logging destinations that you use with web ACLs.

# Release (2022-12-09)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.17.2](service/cloudwatchlogs/CHANGELOG.md#v1172-2022-12-09)
  * **Documentation**: Doc-only update for CloudWatch Logs, for Tagging Permissions clarifications
* `github.com/aws/aws-sdk-go-v2/service/iotfleetwise`: [v1.1.0](service/iotfleetwise/CHANGELOG.md#v110-2022-12-09)
  * **Feature**: Deprecated assignedValue property for actuators and attributes.  Added a message to invalid nodes and invalid decoder manifest exceptions.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.26.0](service/medialive/CHANGELOG.md#v1260-2022-12-09)
  * **Feature**: Link devices now support buffer size (latency) configuration. A higher latency value means a longer delay in transmitting from the device to MediaLive, but improved resiliency. A lower latency value means a shorter delay, but less resiliency.
* `github.com/aws/aws-sdk-go-v2/service/mediapackagevod`: [v1.20.0](service/mediapackagevod/CHANGELOG.md#v1200-2022-12-09)
  * **Feature**: This release provides the approximate number of assets in a packaging group.

# Release (2022-12-08)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/autoscaling`: [v1.25.0](service/autoscaling/CHANGELOG.md#v1250-2022-12-08)
  * **Feature**: Adds support for metric math for target tracking scaling policies, saving you the cost and effort of publishing a custom metric to CloudWatch. Also adds support for VPC Lattice by adding the Attach/Detach/DescribeTrafficSources APIs and a new health check type to the CreateAutoScalingGroup API.
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.9.0](service/iottwinmaker/CHANGELOG.md#v190-2022-12-08)
  * **Feature**: This release adds the following new features: 1) New APIs for managing a continuous sync of assets and asset models from AWS IoT SiteWise. 2) Support user friendly names for component types (ComponentTypeName) and properties (DisplayName).
* `github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy`: [v1.6.0](service/migrationhubstrategy/CHANGELOG.md#v160-2022-12-08)
  * **Feature**: This release adds known application filtering, server selection for assessments, support for potential recommendations, and indications for configuration and assessment status. For more information, see the AWS Migration Hub documentation at https://docs.aws.amazon.com/migrationhub/index.html

# Release (2022-12-07)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.22.0](service/cloudfront/CHANGELOG.md#v1220-2022-12-07)
  * **Feature**: Introducing UpdateDistributionWithStagingConfig that can be used to promote the staging configuration to the production.
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.23.0](service/costexplorer/CHANGELOG.md#v1230-2022-12-07)
  * **Feature**: This release adds the LinkedAccountName field to the GetAnomalies API response under RootCause
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.25.0](service/eks/CHANGELOG.md#v1250-2022-12-07)
  * **Feature**: Adds support for EKS add-ons configurationValues fields and DescribeAddonConfiguration function
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.19.2](service/kms/CHANGELOG.md#v1192-2022-12-07)
  * **Documentation**: Updated examples and exceptions for External Key Store (XKS).

# Release (2022-12-06)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.3.0](service/billingconductor/CHANGELOG.md#v130-2022-12-06)
  * **Feature**: This release adds the Tiering Pricing Rule feature.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.39.0](service/connect/CHANGELOG.md#v1390-2022-12-06)
  * **Feature**: This release provides APIs that enable you to programmatically manage rules for Contact Lens conversational analytics and third party applications. For more information, see   https://docs.aws.amazon.com/connect/latest/APIReference/rules-api.html
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.33.0](service/rds/CHANGELOG.md#v1330-2022-12-06)
  * **Feature**: This release adds the BlueGreenDeploymentNotFoundFault to the AddTagsToResource, ListTagsForResource, and RemoveTagsFromResource operations.
* `github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime`: [v1.12.0](service/sagemakerfeaturestoreruntime/CHANGELOG.md#v1120-2022-12-06)
  * **Feature**: For online + offline Feature Groups, added ability to target PutRecord and DeleteRecord actions to only online store, or only offline store. If target store parameter is not specified, actions will apply to both stores.

# Release (2022-12-05)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/costexplorer`: [v1.22.0](service/costexplorer/CHANGELOG.md#v1220-2022-12-05)
  * **Feature**: This release introduces two new APIs that offer a 1-click experience to refresh Savings Plans recommendations. The two APIs are StartSavingsPlansPurchaseRecommendationGeneration and ListSavingsPlansPurchaseRecommendationGeneration.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.75.0](service/ec2/CHANGELOG.md#v1750-2022-12-05)
  * **Feature**: Documentation updates for EC2.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.2.0](service/ivschat/CHANGELOG.md#v120-2022-12-05)
  * **Feature**: Adds PendingVerification error type to messaging APIs to block the resource usage for accounts identified as being fraudulent.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.32.0](service/rds/CHANGELOG.md#v1320-2022-12-05)
  * **Feature**: This release adds the InvalidDBInstanceStateFault to the RestoreDBClusterFromSnapshot operation.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.23.0](service/transcribe/CHANGELOG.md#v1230-2022-12-05)
  * **Feature**: Amazon Transcribe now supports creating custom language models in the following languages: Japanese (ja-JP) and German (de-DE).

# Release (2022-12-02)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.17.0](service/appsync/CHANGELOG.md#v1170-2022-12-02)
  * **Feature**: Fixes the URI for the evaluatecode endpoint to include the /v1 prefix (ie. "/v1/dataplane-evaluatecode").
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.20.1](service/ecs/CHANGELOG.md#v1201-2022-12-02)
  * **Documentation**: Documentation updates for Amazon ECS
* `github.com/aws/aws-sdk-go-v2/service/fms`: [v1.21.0](service/fms/CHANGELOG.md#v1210-2022-12-02)
  * **Feature**: AWS Firewall Manager now supports Fortigate Cloud Native Firewall as a Service as a third-party policy type.
* `github.com/aws/aws-sdk-go-v2/service/mediaconvert`: [v1.28.0](service/mediaconvert/CHANGELOG.md#v1280-2022-12-02)
  * **Feature**: The AWS Elemental MediaConvert SDK has added support for configurable ID3 eMSG box attributes and the ability to signal them with InbandEventStream tags in DASH and CMAF outputs.
* `github.com/aws/aws-sdk-go-v2/service/medialive`: [v1.25.0](service/medialive/CHANGELOG.md#v1250-2022-12-02)
  * **Feature**: Updates to Event Signaling and Management (ESAM) API and documentation.
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.21.0](service/polly/CHANGELOG.md#v1210-2022-12-02)
  * **Feature**: Add language code for Finnish (fi-FI)
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.18.0](service/proton/CHANGELOG.md#v1180-2022-12-02)
  * **Feature**: CreateEnvironmentAccountConnection RoleArn input is now optional
* `github.com/aws/aws-sdk-go-v2/service/redshiftserverless`: [v1.3.0](service/redshiftserverless/CHANGELOG.md#v130-2022-12-02)
  * **Feature**: Add Table Level Restore operations for Amazon Redshift Serverless. Add multi-port support for Amazon Redshift Serverless endpoints. Add Tagging support to Snapshots and Recovery Points in Amazon Redshift Serverless.
* `github.com/aws/aws-sdk-go-v2/service/sns`: [v1.18.7](service/sns/CHANGELOG.md#v1187-2022-12-02)
  * **Documentation**: This release adds the message payload-filtering feature to the SNS Subscribe, SetSubscriptionAttributes, and GetSubscriptionAttributes API actions

# Release (2022-12-01)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/codecatalyst`: [v1.0.0](service/codecatalyst/CHANGELOG.md#v100-2022-12-01)
  * **Release**: New AWS service client module
  * **Feature**: This release adds operations that support customers using the AWS Toolkits and Amazon CodeCatalyst, a unified software development service that helps developers develop, deploy, and maintain applications in the cloud. For more information, see the documentation.
* `github.com/aws/aws-sdk-go-v2/service/comprehend`: [v1.20.0](service/comprehend/CHANGELOG.md#v1200-2022-12-01)
  * **Feature**: Comprehend now supports semi-structured documents (such as PDF files or image files) as inputs for custom analysis using the synchronous APIs (ClassifyDocument and DetectEntities).
* `github.com/aws/aws-sdk-go-v2/service/gamelift`: [v1.16.0](service/gamelift/CHANGELOG.md#v1160-2022-12-01)
  * **Feature**: GameLift introduces a new feature, GameLift Anywhere. GameLift Anywhere allows you to integrate your own compute resources with GameLift. You can also use GameLift Anywhere to iteratively test your game servers without uploading the build to GameLift for every iteration.
* `github.com/aws/aws-sdk-go-v2/service/pipes`: [v1.0.0](service/pipes/CHANGELOG.md#v100-2022-12-01)
  * **Release**: New AWS service client module
  * **Feature**: AWS introduces new Amazon EventBridge Pipes which allow you to connect sources (SQS, Kinesis, DDB, Kafka, MQ) to Targets (14+ EventBridge Targets) without any code, with filtering, batching, input transformation, and an optional Enrichment stage (Lambda, StepFunctions, ApiGateway, ApiDestinations)
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.16.0](service/sfn/CHANGELOG.md#v1160-2022-12-01)
  * **Feature**: This release adds support for the AWS Step Functions Map state in Distributed mode. The changes include a new MapRun resource and several new and modified APIs.

# Release (2022-11-30)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/accessanalyzer`: [v1.18.0](service/accessanalyzer/CHANGELOG.md#v1180-2022-11-30)
  * **Feature**: This release adds support for S3 cross account access points. IAM Access Analyzer will now produce public or cross account findings when it detects bucket delegation to external account access points.
* `github.com/aws/aws-sdk-go-v2/service/athena`: [v1.20.0](service/athena/CHANGELOG.md#v1200-2022-11-30)
  * **Feature**: This release includes support for using Apache Spark in Amazon Athena.
* `github.com/aws/aws-sdk-go-v2/service/dataexchange`: [v1.17.0](service/dataexchange/CHANGELOG.md#v1170-2022-11-30)
  * **Feature**: This release enables data providers to license direct access to data in their Amazon S3 buckets or AWS Lake Formation data lakes through AWS Data Exchange. Subscribers get read-only access to the data and can use it in downstream AWS services, like Amazon Athena, without creating or managing copies.
* `github.com/aws/aws-sdk-go-v2/service/docdbelastic`: [v1.0.0](service/docdbelastic/CHANGELOG.md#v100-2022-11-30)
  * **Release**: New AWS service client module
  * **Feature**: Launched Amazon DocumentDB Elastic Clusters. You can now use the SDK to create, list, update and delete Amazon DocumentDB Elastic Cluster resources
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.37.0](service/glue/CHANGELOG.md#v1370-2022-11-30)
  * **Feature**: This release adds support for AWS Glue Data Quality, which helps you evaluate and monitor the quality of your data and includes the API for creating, deleting, or updating data quality rulesets, runs and evaluations.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.28.0](service/s3control/CHANGELOG.md#v1280-2022-11-30)
  * **Feature**: Amazon S3 now supports cross-account access points. S3 bucket owners can now allow trusted AWS accounts to create access points associated with their bucket.
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.56.0](service/sagemaker/CHANGELOG.md#v1560-2022-11-30)
  * **Feature**: Added Models as part of the Search API. Added Model shadow deployments in realtime inference, and shadow testing in managed inference. Added support for shared spaces, geospatial APIs, Model Cards, AutoMLJobStep in pipelines, Git repositories on user profiles and domains, Model sharing in Jumpstart.
* `github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial`: [v1.0.0](service/sagemakergeospatial/CHANGELOG.md#v100-2022-11-30)
  * **Release**: New AWS service client module
  * **Feature**: This release provides Amazon SageMaker geospatial APIs to build, train, deploy and visualize geospatial models.

# Release (2022-11-29.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.74.0](service/ec2/CHANGELOG.md#v1740-2022-11-292)
  * **Feature**: This release adds support for AWS Verified Access and the Hpc6id Amazon EC2 compute optimized instance type, which features 3rd generation Intel Xeon Scalable processors.
* `github.com/aws/aws-sdk-go-v2/service/firehose`: [v1.15.0](service/firehose/CHANGELOG.md#v1150-2022-11-292)
  * **Feature**: Allow support for the Serverless offering for Amazon OpenSearch Service as a Kinesis Data Firehose delivery destination.
* `github.com/aws/aws-sdk-go-v2/service/kms`: [v1.19.0](service/kms/CHANGELOG.md#v1190-2022-11-292)
  * **Feature**: AWS KMS introduces the External Key Store (XKS), a new feature for customers who want to protect their data with encryption keys stored in an external key management system under their control.
* `github.com/aws/aws-sdk-go-v2/service/omics`: [v1.0.0](service/omics/CHANGELOG.md#v100-2022-11-292)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Omics is a new, purpose-built service that can be used by healthcare and life science organizations to store, query, and analyze omics data. The insights from that data can be used to accelerate scientific discoveries and improve healthcare.
* `github.com/aws/aws-sdk-go-v2/service/opensearchserverless`: [v1.0.0](service/opensearchserverless/CHANGELOG.md#v100-2022-11-292)
  * **Release**: New AWS service client module
  * **Feature**: Publish SDK for Amazon OpenSearch Serverless
* `github.com/aws/aws-sdk-go-v2/service/securitylake`: [v1.0.0](service/securitylake/CHANGELOG.md#v100-2022-11-292)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Security Lake automatically centralizes security data from cloud, on-premises, and custom sources into a purpose-built data lake stored in your account. Security Lake makes it easier to analyze security data, so you can improve the protection of your workloads, applications, and data
* `github.com/aws/aws-sdk-go-v2/service/simspaceweaver`: [v1.0.0](service/simspaceweaver/CHANGELOG.md#v100-2022-11-292)
  * **Release**: New AWS service client module
  * **Feature**: AWS SimSpace Weaver is a new service that helps customers build spatial simulations at new levels of scale - resulting in virtual worlds with millions of dynamic entities. See the AWS SimSpace Weaver developer guide for more details on how to get started. https://docs.aws.amazon.com/simspaceweaver

# Release (2022-11-29)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/arczonalshift`: [v1.0.0](service/arczonalshift/CHANGELOG.md#v100-2022-11-29)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Route 53 Application Recovery Controller Zonal Shift is a new service that makes it easy to shift traffic away from an Availability Zone in a Region. See the developer guide for more information: https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html
* `github.com/aws/aws-sdk-go-v2/service/computeoptimizer`: [v1.18.0](service/computeoptimizer/CHANGELOG.md#v1180-2022-11-29)
  * **Feature**: Adds support for a new recommendation preference that makes it possible for customers to optimize their EC2 recommendations by utilizing an external metrics ingestion service to provide metrics.
* `github.com/aws/aws-sdk-go-v2/service/configservice`: [v1.28.0](service/configservice/CHANGELOG.md#v1280-2022-11-29)
  * **Feature**: With this release, you can use AWS Config to evaluate your resources for compliance with Config rules before they are created or updated. Using Config rules in proactive mode enables you to test and build compliant resource templates or check resource configurations at the time they are provisioned.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.73.0](service/ec2/CHANGELOG.md#v1730-2022-11-29)
  * **Feature**: Introduces ENA Express, which uses AWS SRD and dynamic routing to increase throughput and minimize latency, adds support for trust relationships between Reachability Analyzer and AWS Organizations to enable cross-account analysis, and adds support for Infrastructure Performance metric subscriptions.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.24.0](service/eks/CHANGELOG.md#v1240-2022-11-29)
  * **Feature**: Adds support for additional EKS add-ons metadata and filtering fields
* `github.com/aws/aws-sdk-go-v2/service/fsx`: [v1.26.0](service/fsx/CHANGELOG.md#v1260-2022-11-29)
  * **Feature**: This release adds support for 4GB/s / 160K PIOPS FSx for ONTAP file systems and 10GB/s / 350K PIOPS FSx for OpenZFS file systems (Single_AZ_2). For FSx for ONTAP, this also adds support for DP volumes, snapshot policy, copy tags to backups, and Multi-AZ route table updates.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.36.0](service/glue/CHANGELOG.md#v1360-2022-11-29)
  * **Feature**: This release allows the creation of Custom Visual Transforms (Dynamic Transforms) to be created via AWS Glue CLI/SDK.
* `github.com/aws/aws-sdk-go-v2/service/inspector2`: [v1.9.0](service/inspector2/CHANGELOG.md#v190-2022-11-29)
  * **Feature**: This release adds support for Inspector to scan AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.26.0](service/lambda/CHANGELOG.md#v1260-2022-11-29)
  * **Feature**: Adds support for Lambda SnapStart, which helps improve the startup performance of functions. Customers can now manage SnapStart based functions via CreateFunction and UpdateFunctionConfiguration APIs
* `github.com/aws/aws-sdk-go-v2/service/licensemanagerusersubscriptions`: [v1.1.0](service/licensemanagerusersubscriptions/CHANGELOG.md#v110-2022-11-29)
  * **Feature**: AWS now offers fully-compliant, Amazon-provided licenses for Microsoft Office Professional Plus 2021 Amazon Machine Images (AMIs) on Amazon EC2. These AMIs are now available on the Amazon EC2 console and on AWS Marketplace to launch instances on-demand without any long-term licensing commitments.
* `github.com/aws/aws-sdk-go-v2/service/macie2`: [v1.24.0](service/macie2/CHANGELOG.md#v1240-2022-11-29)
  * **Feature**: Added support for configuring Macie to continually sample objects from S3 buckets and inspect them for sensitive data. Results appear in statistics, findings, and other data that Macie provides.
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.28.0](service/quicksight/CHANGELOG.md#v1280-2022-11-29)
  * **Feature**: This release adds new Describe APIs and updates Create and Update APIs to support the data model for Dashboards, Analyses, and Templates.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.27.0](service/s3control/CHANGELOG.md#v1270-2022-11-29)
  * **Feature**: Added two new APIs to support Amazon S3 Multi-Region Access Point failover controls: GetMultiRegionAccessPointRoutes and SubmitMultiRegionAccessPointRoutes. The failover control APIs are supported in the following Regions: us-east-1, us-west-2, eu-west-1, ap-southeast-2, and ap-northeast-1.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.25.0](service/securityhub/CHANGELOG.md#v1250-2022-11-29)
  * **Feature**: Adding StandardsManagedBy field to DescribeStandards API response

# Release (2022-11-28)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/backup`: [v1.18.0](service/backup/CHANGELOG.md#v1180-2022-11-28)
  * **Feature**: AWS Backup introduces support for legal hold and application stack backups. AWS Backup Audit Manager introduces support for cross-Region, cross-account reports.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatch`: [v1.22.0](service/cloudwatch/CHANGELOG.md#v1220-2022-11-28)
  * **Feature**: Adds cross-account support to the GetMetricData API. Adds cross-account support to the ListMetrics API through the usage of the IncludeLinkedAccounts flag and the new OwningAccounts field.
* `github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs`: [v1.17.0](service/cloudwatchlogs/CHANGELOG.md#v1170-2022-11-28)
  * **Feature**: Updates to support CloudWatch Logs data protection and CloudWatch cross-account observability
* `github.com/aws/aws-sdk-go-v2/service/drs`: [v1.9.0](service/drs/CHANGELOG.md#v190-2022-11-28)
  * **Feature**: Non breaking changes to existing APIs, and additional APIs added to support in-AWS failing back using AWS Elastic Disaster Recovery.
* `github.com/aws/aws-sdk-go-v2/service/ecs`: [v1.20.0](service/ecs/CHANGELOG.md#v1200-2022-11-28)
  * **Feature**: This release adds support for ECS Service Connect, a new capability that simplifies writing and operating resilient distributed applications. This release updates the TaskDefinition, Cluster, Service mutation APIs with Service connect constructs and also adds a new ListServicesByNamespace API.
* `github.com/aws/aws-sdk-go-v2/service/efs`: [v1.18.0](service/efs/CHANGELOG.md#v1180-2022-11-28)
  * **Feature**: This release adds elastic as a new ThroughputMode value for EFS file systems and adds AFTER_1_DAY as a value for TransitionToIARules.
* `github.com/aws/aws-sdk-go-v2/service/iot`: [v1.32.0](service/iot/CHANGELOG.md#v1320-2022-11-28)
  * **Feature**: Job scheduling enables the scheduled rollout of a Job with start and end times and a customizable end behavior when end time is reached. This is available for continuous and snapshot jobs. Added support for MQTT5 properties to AWS IoT TopicRule Republish Action.
* `github.com/aws/aws-sdk-go-v2/service/iotdataplane`: [v1.13.0](service/iotdataplane/CHANGELOG.md#v1130-2022-11-28)
  * **Feature**: This release adds support for MQTT5 properties to AWS IoT HTTP Publish API.
* `github.com/aws/aws-sdk-go-v2/service/iotwireless`: [v1.23.0](service/iotwireless/CHANGELOG.md#v1230-2022-11-28)
  * **Feature**: This release includes a new feature for customers to calculate the position of their devices by adding three new APIs: UpdateResourcePosition, GetResourcePosition, and GetPositionEstimate.
* `github.com/aws/aws-sdk-go-v2/service/kendra`: [v1.36.0](service/kendra/CHANGELOG.md#v1360-2022-11-28)
  * **Feature**: Amazon Kendra now supports preview of table information from HTML tables in the search results. The most relevant cells with their corresponding rows, columns are displayed as a preview in the search result. The most relevant table cell or cells are also highlighted in table preview.
* `github.com/aws/aws-sdk-go-v2/service/mgn`: [v1.16.0](service/mgn/CHANGELOG.md#v1160-2022-11-28)
  * **Feature**: This release adds support for Application and Wave management. We also now support custom post-launch actions.
* `github.com/aws/aws-sdk-go-v2/service/oam`: [v1.0.0](service/oam/CHANGELOG.md#v100-2022-11-28)
  * **Release**: New AWS service client module
  * **Feature**: Amazon CloudWatch Observability Access Manager is a new service that allows configuration of the CloudWatch cross-account observability feature.
* `github.com/aws/aws-sdk-go-v2/service/organizations`: [v1.17.0](service/organizations/CHANGELOG.md#v1170-2022-11-28)
  * **Feature**: This release introduces delegated administrator for AWS Organizations, a new feature to help you delegate the management of your Organizations policies, enabling you to govern your AWS organization in a decentralized way. You can now allow member accounts to manage Organizations policies.
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.31.0](service/rds/CHANGELOG.md#v1310-2022-11-28)
  * **Feature**: This release enables new Aurora and RDS feature called Blue/Green Deployments that makes updates to databases safer, simpler and faster.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.19.0](service/textract/CHANGELOG.md#v1190-2022-11-28)
  * **Feature**: This release adds support for classifying and splitting lending documents by type, and extracting information by using the Analyze Lending APIs. This release also includes support for summarized information of the processed lending document package, in addition to per document results.
* `github.com/aws/aws-sdk-go-v2/service/transcribe`: [v1.22.0](service/transcribe/CHANGELOG.md#v1220-2022-11-28)
  * **Feature**: This release adds support for 'inputType' for post-call and real-time (streaming) Call Analytics within Amazon Transcribe.
* `github.com/aws/aws-sdk-go-v2/service/transcribestreaming`: [v1.8.0](service/transcribestreaming/CHANGELOG.md#v180-2022-11-28)
  * **Feature**: This release adds support for real-time (streaming) and post-call Call Analytics within Amazon Transcribe.

# Release (2022-11-23)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/grafana`: [v1.10.0](service/grafana/CHANGELOG.md#v1100-2022-11-23)
  * **Feature**: This release includes support for configuring a Grafana workspace to connect to a datasource within a VPC as well as new APIs for configuring Grafana settings.
* `github.com/aws/aws-sdk-go-v2/service/rbin`: [v1.7.0](service/rbin/CHANGELOG.md#v170-2022-11-23)
  * **Feature**: This release adds support for Rule Lock for Recycle Bin, which allows you to lock retention rules so that they can no longer be modified or deleted.

# Release (2022-11-22)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.21.0](service/appflow/CHANGELOG.md#v1210-2022-11-22)
  * **Feature**: Adding support for Amazon AppFlow to transfer the data to Amazon Redshift databases through Amazon Redshift Data API service. This feature will support the Redshift destination connector on both public and private accessible Amazon Redshift Clusters and Amazon Redshift Serverless.
* `github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2`: [v1.15.0](service/kinesisanalyticsv2/CHANGELOG.md#v1150-2022-11-22)
  * **Feature**: Support for Apache Flink 1.15 in Kinesis Data Analytics.

# Release (2022-11-21)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/route53`: [v1.25.0](service/route53/CHANGELOG.md#v1250-2022-11-21)
  * **Feature**: Amazon Route 53 now supports the Asia Pacific (Hyderabad) Region (ap-south-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

# Release (2022-11-18.2)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/ssmsap`: [v1.0.1](service/ssmsap/CHANGELOG.md#v101-2022-11-182)
  * **Bug Fix**: Removes old model file for ssm sap and uses the new model file to regenerate client

# Release (2022-11-18)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.20.0](service/appflow/CHANGELOG.md#v1200-2022-11-18)
  * **Feature**: AppFlow provides a new API called UpdateConnectorRegistration to update a custom connector that customers have previously registered. With this API, customers no longer need to unregister and then register a connector to make an update.
* `github.com/aws/aws-sdk-go-v2/service/auditmanager`: [v1.21.0](service/auditmanager/CHANGELOG.md#v1210-2022-11-18)
  * **Feature**: This release introduces a new feature for Audit Manager: Evidence finder. You can now use evidence finder to quickly query your evidence, and add the matching evidence results to an assessment report.
* `github.com/aws/aws-sdk-go-v2/service/chimesdkvoice`: [v1.0.0](service/chimesdkvoice/CHANGELOG.md#v100-2022-11-18)
  * **Release**: New AWS service client module
  * **Feature**: Amazon Chime Voice Connector, Voice Connector Group and PSTN Audio Service APIs are now available in the Amazon Chime SDK Voice namespace. See https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html for more details.
* `github.com/aws/aws-sdk-go-v2/service/cloudfront`: [v1.21.0](service/cloudfront/CHANGELOG.md#v1210-2022-11-18)
  * **Feature**: CloudFront API support for staging distributions and associated traffic management policies.
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.38.0](service/connect/CHANGELOG.md#v1380-2022-11-18)
  * **Feature**: Added AllowedAccessControlTags and TagRestrictedResource for Tag Based Access Control on Amazon Connect Webpage
* `github.com/aws/aws-sdk-go-v2/service/dynamodb`: [v1.17.6](service/dynamodb/CHANGELOG.md#v1176-2022-11-18)
  * **Documentation**: Updated minor fixes for DynamoDB documentation.
* `github.com/aws/aws-sdk-go-v2/service/dynamodbstreams`: [v1.13.25](service/dynamodbstreams/CHANGELOG.md#v11325-2022-11-18)
  * **Documentation**: Updated minor fixes for DynamoDB documentation.
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.72.0](service/ec2/CHANGELOG.md#v1720-2022-11-18)
  * **Feature**: This release adds support for copying an Amazon Machine Image's tags when copying an AMI.
* `github.com/aws/aws-sdk-go-v2/service/glue`: [v1.35.0](service/glue/CHANGELOG.md#v1350-2022-11-18)
  * **Feature**: AWSGlue Crawler - Adding support for Table and Column level Comments with database level datatypes for JDBC based crawler.
* `github.com/aws/aws-sdk-go-v2/service/iotroborunner`: [v1.0.0](service/iotroborunner/CHANGELOG.md#v100-2022-11-18)
  * **Release**: New AWS service client module
  * **Feature**: AWS IoT RoboRunner is a new service that makes it easy to build applications that help multi-vendor robots work together seamlessly. See the IoT RoboRunner developer guide for more details on getting started. https://docs.aws.amazon.com/iotroborunner/latest/dev/iotroborunner-welcome.html
* `github.com/aws/aws-sdk-go-v2/service/quicksight`: [v1.27.0](service/quicksight/CHANGELOG.md#v1270-2022-11-18)
  * **Feature**: This release adds the following: 1) Asset management for centralized assets governance 2) QuickSight Q now supports public embedding 3) New Termination protection flag to mitigate accidental deletes 4) Athena data sources now accept a custom IAM role 5) QuickSight supports connectivity to Databricks
* `github.com/aws/aws-sdk-go-v2/service/sagemaker`: [v1.55.0](service/sagemaker/CHANGELOG.md#v1550-2022-11-18)
  * **Feature**: Added DisableProfiler flag as a new field in ProfilerConfig
* `github.com/aws/aws-sdk-go-v2/service/servicecatalog`: [v1.15.0](service/servicecatalog/CHANGELOG.md#v1150-2022-11-18)
  * **Feature**: This release 1. adds support for Principal Name Sharing with Service Catalog portfolio sharing. 2. Introduces repo sourced products which are created and managed with existing SC APIs. These products are synced to external repos and auto create new product versions based on changes in the repo.
* `github.com/aws/aws-sdk-go-v2/service/sfn`: [v1.15.0](service/sfn/CHANGELOG.md#v1150-2022-11-18)
  * **Feature**: This release adds support for using Step Functions service integrations to invoke any cross-account AWS resource, even if that service doesn't support resource-based policies or cross-account calls. See https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.25.0](service/transfer/CHANGELOG.md#v1250-2022-11-18)
  * **Feature**: Adds a NONE encryption algorithm type to AS2 connectors, providing support for skipping encryption of the AS2 message body when a HTTPS URL is also specified.

# Release (2022-11-17)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/amplify`: [v1.12.0](service/amplify/CHANGELOG.md#v1120-2022-11-17)
  * **Feature**: Adds a new value (WEB_COMPUTE) to the Platform enum that allows customers to create Amplify Apps with Server-Side Rendering support.
* `github.com/aws/aws-sdk-go-v2/service/appflow`: [v1.19.0](service/appflow/CHANGELOG.md#v1190-2022-11-17)
  * **Feature**: AppFlow simplifies the preparation and cataloging of SaaS data into the AWS Glue Data Catalog where your data can be discovered and accessed by AWS analytics and ML services. AppFlow now also supports data field partitioning and file size optimization to improve query performance and reduce cost.
* `github.com/aws/aws-sdk-go-v2/service/appsync`: [v1.16.0](service/appsync/CHANGELOG.md#v1160-2022-11-17)
  * **Feature**: This release introduces the APPSYNC_JS runtime, and adds support for JavaScript in AppSync functions and AppSync pipeline resolvers.
* `github.com/aws/aws-sdk-go-v2/service/databasemigrationservice`: [v1.22.0](service/databasemigrationservice/CHANGELOG.md#v1220-2022-11-17)
  * **Feature**: Adds support for Internet Protocol Version 6 (IPv6) on DMS Replication Instances
* `github.com/aws/aws-sdk-go-v2/service/ec2`: [v1.71.0](service/ec2/CHANGELOG.md#v1710-2022-11-17)
  * **Feature**: This release adds a new optional parameter "privateIpAddress" for the CreateNatGateway API. PrivateIPAddress will allow customers to select a custom Private IPv4 address instead of having it be auto-assigned.
* `github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2`: [v1.18.25](service/elasticloadbalancingv2/CHANGELOG.md#v11825-2022-11-17)
  * **Documentation**: Provides new target group attributes to turn on/off cross zone load balancing and configure target group health for Network Load Balancers and Application Load Balancers. Provides improvements to health check configuration for Network Load Balancers.
* `github.com/aws/aws-sdk-go-v2/service/emrserverless`: [v1.4.0](service/emrserverless/CHANGELOG.md#v140-2022-11-17)
  * **Feature**: Adds support for AWS Graviton2 based applications. You can now select CPU architecture when creating new applications or updating existing ones.
* `github.com/aws/aws-sdk-go-v2/service/ivschat`: [v1.1.0](service/ivschat/CHANGELOG.md#v110-2022-11-17)
  * **Feature**: Adds LoggingConfiguration APIs for IVS Chat - a feature that allows customers to store and record sent messages in a chat room to S3 buckets, CloudWatch logs, or Kinesis firehose.
* `github.com/aws/aws-sdk-go-v2/service/lambda`: [v1.25.0](service/lambda/CHANGELOG.md#v1250-2022-11-17)
  * **Feature**: Add Node 18 (nodejs18.x) support to AWS Lambda.
* `github.com/aws/aws-sdk-go-v2/service/personalize`: [v1.22.0](service/personalize/CHANGELOG.md#v1220-2022-11-17)
  * **Feature**: This release provides support for creation and use of metric attributions in AWS Personalize
* `github.com/aws/aws-sdk-go-v2/service/polly`: [v1.20.0](service/polly/CHANGELOG.md#v1200-2022-11-17)
  * **Feature**: Add two new neural voices - Ola (pl-PL) and Hala (ar-AE).
* `github.com/aws/aws-sdk-go-v2/service/rum`: [v1.8.0](service/rum/CHANGELOG.md#v180-2022-11-17)
  * **Feature**: CloudWatch RUM now supports custom events. To use custom events, create an app monitor or update an app monitor with CustomEvent Status as ENABLED.
* `github.com/aws/aws-sdk-go-v2/service/s3control`: [v1.26.0](service/s3control/CHANGELOG.md#v1260-2022-11-17)
  * **Feature**: Added 34 new S3 Storage Lens metrics to support additional customer use cases.
* `github.com/aws/aws-sdk-go-v2/service/secretsmanager`: [v1.16.7](service/secretsmanager/CHANGELOG.md#v1167-2022-11-17)
  * **Documentation**: Documentation updates for Secrets Manager.
* `github.com/aws/aws-sdk-go-v2/service/securityhub`: [v1.24.0](service/securityhub/CHANGELOG.md#v1240-2022-11-17)
  * **Feature**: Added SourceLayerArn and SourceLayerHash field for security findings.  Updated AwsLambdaFunction Resource detail
* `github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry`: [v1.15.0](service/servicecatalogappregistry/CHANGELOG.md#v1150-2022-11-17)
  * **Feature**: This release adds support for tagged resource associations, which allows you to associate a group of resources with a defined resource tag key and value to the application.
* `github.com/aws/aws-sdk-go-v2/service/sts`: [v1.17.4](service/sts/CHANGELOG.md#v1174-2022-11-17)
  * **Documentation**: Documentation updates for AWS Security Token Service.
* `github.com/aws/aws-sdk-go-v2/service/textract`: [v1.18.0](service/textract/CHANGELOG.md#v1180-2022-11-17)
  * **Feature**: This release adds support for specifying and extracting information from documents using the Signatures feature within Analyze Document API
* `github.com/aws/aws-sdk-go-v2/service/workspaces`: [v1.27.0](service/workspaces/CHANGELOG.md#v1270-2022-11-17)
  * **Feature**: The release introduces CreateStandbyWorkspaces, an API that allows you to create standby WorkSpaces associated with a primary WorkSpace in another Region. DescribeWorkspaces now includes related WorkSpaces properties. DescribeWorkspaceBundles and CreateWorkspaceBundle now return more bundle details.

# Release (2022-11-16)

## General Highlights
* **Dependency Update**: Updated to the latest SDK module versions

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/batch`: [v1.19.1](service/batch/CHANGELOG.md#v1191-2022-11-16)
  * **Documentation**: Documentation updates related to Batch on EKS
* `github.com/aws/aws-sdk-go-v2/service/billingconductor`: [v1.2.0](service/billingconductor/CHANGELOG.md#v120-2022-11-16)
  * **Feature**: This release adds a new feature BillingEntity pricing rule.
* `github.com/aws/aws-sdk-go-v2/service/cloudformation`: [v1.24.0](service/cloudformation/CHANGELOG.md#v1240-2022-11-16)
  * **Feature**: Added UnsupportedTarget HandlerErrorCode for use with CFN Resource Hooks
* `github.com/aws/aws-sdk-go-v2/service/comprehendmedical`: [v1.14.0](service/comprehendmedical/CHANGELOG.md#v1140-2022-11-16)
  * **Feature**: This release supports new set of entities and traits. It also adds new category (BEHAVIORAL_ENVIRONMENTAL_SOCIAL).
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.37.0](service/connect/CHANGELOG.md#v1370-2022-11-16)
  * **Feature**: This release adds a new MonitorContact API for initiating monitoring of ongoing Voice and Chat contacts.
* `github.com/aws/aws-sdk-go-v2/service/eks`: [v1.23.0](service/eks/CHANGELOG.md#v1230-2022-11-16)
  * **Feature**: Adds support for customer-provided placement groups for Kubernetes control plane instances when creating local EKS clusters on Outposts
* `github.com/aws/aws-sdk-go-v2/service/elasticache`: [v1.24.0](service/elasticache/CHANGELOG.md#v1240-2022-11-16)
  * **Feature**: for Redis now supports AWS Identity and Access Management authentication access to Redis clusters starting with redis-engine version 7.0
* `github.com/aws/aws-sdk-go-v2/service/iottwinmaker`: [v1.8.0](service/iottwinmaker/CHANGELOG.md#v180-2022-11-16)
  * **Feature**: This release adds the following: 1) ExecuteQuery API allows users to query their AWS IoT TwinMaker Knowledge Graph 2) Pricing plan APIs allow users to configure and manage their pricing mode 3) Support for property groups and tabular property values in existing AWS IoT TwinMaker APIs.
* `github.com/aws/aws-sdk-go-v2/service/personalizeevents`: [v1.12.0](service/personalizeevents/CHANGELOG.md#v1120-2022-11-16)
  * **Feature**: This release provides support for creation and use of metric attributions in AWS Personalize
* `github.com/aws/aws-sdk-go-v2/service/proton`: [v1.17.0](service/proton/CHANGELOG.md#v1170-2022-11-16)
  * **Feature**: Add support for sorting and filtering in ListServiceInstances
* `github.com/aws/aws-sdk-go-v2/service/rds`: [v1.30.0](service/rds/CHANGELOG.md#v1300-2022-11-16)
  * **Feature**: This release adds support for container databases (CDBs) to Amazon RDS Custom for Oracle. A CDB contains one PDB at creation. You can add more PDBs using Oracle SQL. You can also customize your database installation by setting the Oracle base, Oracle home, and the OS user name and group.
* `github.com/aws/aws-sdk-go-v2/service/ssm`: [v1.33.0](service/ssm/CHANGELOG.md#v1330-2022-11-16)
  * **Feature**: This release adds support for cross account access in CreateOpsItem, UpdateOpsItem and GetOpsItem. It introduces new APIs to setup resource policies for SSM resources: PutResourcePolicy, GetResourcePolicies and DeleteResourcePolicy.
* `github.com/aws/aws-sdk-go-v2/service/ssmincidents`: [v1.19.0](service/ssmincidents/CHANGELOG.md#v1190-2022-11-16)
  * **Feature**: Add support for PagerDuty integrations on ResponsePlan, IncidentRecord, and RelatedItem APIs
* `github.com/aws/aws-sdk-go-v2/service/transfer`: [v1.24.0](service/transfer/CHANGELOG.md#v1240-2022-11-16)
  * **Feature**: Allow additional operations to throw ThrottlingException
* `github.com/aws/aws-sdk-go-v2/service/xray`: [v1.15.0](service/xray/CHANGELOG.md#v1150-2022-11-16)
  * **Feature**: This release adds new APIs - PutResourcePolicy, DeleteResourcePolicy, ListResourcePolicies for supporting resource based policies for AWS X-Ray.

# Release (2022-11-15)

## Module Highlights
* `github.com/aws/aws-sdk-go-v2/service/connect`: [v1.36.0](service/connect/CHANGELOG.md#v1360-2022-11-15)
  * **Feature**: This release updates the APIs: UpdateInstanceAttribute, DescribeInstanceAttribute, and ListInstanceAttributes. You can use it to programmatically enable/disable enhanced contact monitoring using attribute type ENHANCED_CONTACT_MONITORING on the specified Amazon Connect instance.
* `github.com/aws/aws-sdk-go-v2/service/greengrassv2`: [v1.20.0](service/greengrassv2/CHANGELOG.md#v1200-2022-11-15)
  * **Feature**: Adds new parent target ARN paramater to CreateDeployment, GetDeployment, and ListDeployments APIs for the new subdeployments feature.
* `githu