/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.classGeneration;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.util.Utilities;

public final class MockedTypeInfo {
    @Nonnull
    public final GenericTypeReflection genericTypeMap;
    @Nonnull
    public final String implementationSignature;

    public MockedTypeInfo(@Nonnull Type mockedType) {
        Class<?> mockedClass = Utilities.getClassType(mockedType);
        this.genericTypeMap = new GenericTypeReflection(mockedClass, mockedType);
        String signature = MockedTypeInfo.getGenericClassSignature(mockedType);
        String classDesc = mockedClass.getName().replace('.', '/');
        this.implementationSignature = 'L' + classDesc + signature;
    }

    @Nonnull
    private static String getGenericClassSignature(@Nonnull Type mockedType) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        StringBuilder signature = new StringBuilder(100);
        if (mockedType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)mockedType).getActualTypeArguments()).length > 0) {
            signature.append('<');
            for (Type typeArg : typeArguments) {
                if (typeArg instanceof Class) {
                    Class classArg = (Class)typeArg;
                    signature.append('L').append(classArg.getName().replace('.', '/')).append(';');
                    continue;
                }
                signature.append('*');
            }
            signature.append('>');
        }
        signature.append(';');
        return signature.toString();
    }
}

