/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.springframework;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.integration.springframework.BeanLookup;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.TestedClassInstantiations;
import mockit.internal.state.TestRun;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.web.context.support.StaticWebApplicationContext;

public final class TestWebApplicationContext
extends StaticWebApplicationContext {
    @Nonnull
    public Object getBean(@Nonnull String name) {
        BeanExporter beanExporter = TestWebApplicationContext.getBeanExporter();
        Object bean = BeanLookup.getBean(beanExporter, name);
        return bean;
    }

    @Nonnull
    private static BeanExporter getBeanExporter() {
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        if (testedClasses == null) {
            throw new BeanDefinitionStoreException("Test class does not define any @Tested fields");
        }
        return testedClasses.getBeanExporter();
    }

    @Nonnull
    public <T> T getBean(@Nonnull String name, @Nullable Class<T> requiredType) {
        BeanExporter beanExporter = TestWebApplicationContext.getBeanExporter();
        T bean = BeanLookup.getBean(beanExporter, name, requiredType);
        return bean;
    }

    @Nonnull
    public <T> T getBean(@Nonnull Class<T> requiredType) {
        BeanExporter beanExporter = TestWebApplicationContext.getBeanExporter();
        T bean = BeanLookup.getBean(beanExporter, requiredType);
        return bean;
    }
}

