/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.fields;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.BaseWriter;
import mockit.asm.SignatureWriter;
import mockit.asm.classes.ClassWriter;
import mockit.asm.util.ByteVector;

public final class FieldVisitor
extends BaseWriter {
    @Nonnegative
    private final int nameItemIndex;
    @Nonnegative
    private final int descItemIndex;
    @Nullable
    private final SignatureWriter signatureWriter;
    @Nonnegative
    private final int valueItemIndex;

    public FieldVisitor(@Nonnull ClassWriter cw, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        super(cw.getConstantPoolGeneration(), access);
        this.nameItemIndex = this.cp.newUTF8(name);
        this.descItemIndex = this.cp.newUTF8(desc);
        this.signatureWriter = signature == null ? null : new SignatureWriter(this.cp, signature);
        this.valueItemIndex = value == null ? 0 : this.cp.newConstItem((Object)value).index;
        this.createMarkerAttributes(cw.getClassVersion());
    }

    @Nonnegative
    public int getSize() {
        int size = 8 + this.getMarkerAttributesSize() + this.getAnnotationsSize();
        if (this.valueItemIndex != 0) {
            this.cp.newUTF8("ConstantValue");
            size += 8;
        }
        if (this.signatureWriter != null) {
            size += this.signatureWriter.getSize();
        }
        return size;
    }

    @Override
    protected void put(@Nonnull ByteVector out) {
        this.putAccess(out, 0);
        out.putShort(this.nameItemIndex);
        out.putShort(this.descItemIndex);
        int attributeCount = this.getAttributeCount();
        out.putShort(attributeCount);
        if (this.valueItemIndex != 0) {
            out.putShort(this.cp.newUTF8("ConstantValue"));
            out.putInt(2).putShort(this.valueItemIndex);
        }
        this.putMarkerAttributes(out);
        if (this.signatureWriter != null) {
            this.signatureWriter.put(out);
        }
        this.putAnnotations(out);
    }

    @Nonnegative
    private int getAttributeCount() {
        int attributeCount = this.getMarkerAttributeCount();
        if (this.valueItemIndex != 0) {
            ++attributeCount;
        }
        if (this.signatureWriter != null) {
            ++attributeCount;
        }
        if (this.annotations != null) {
            ++attributeCount;
        }
        return attributeCount;
    }
}

