// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/clickhouse/v1/cluster.proto

package clickhouse

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Host_Type int32

const (
	// Host type is unspecified. Default value.
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// ClickHouse host.
	Host_CLICKHOUSE Host_Type = 1
	// ZooKeeper host.
	Host_ZOOKEEPER Host_Type = 2
)

// Enum value maps for Host_Type.
var (
	Host_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CLICKHOUSE",
		2: "ZOOKEEPER",
	}
	Host_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"CLICKHOUSE":       1,
		"ZOOKEEPER":        2,
	}
)

func (x Host_Type) Enum() *Host_Type {
	p := new(Host_Type)
	*p = x
	return p
}

func (x Host_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Host_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[3]
}

func (x Host_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Type.Descriptor instead.
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{7, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"UNKNOWN":  0,
		"ALIVE":    1,
		"DEAD":     2,
		"DEGRADED": 3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[4]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{7, 1}
}

type Service_Type int32

const (
	// Service type of the host is unspecified. Default value.
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a ClickHouse server.
	Service_CLICKHOUSE Service_Type = 1
	// The host is a ZooKeeper server.
	Service_ZOOKEEPER Service_Type = 2
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CLICKHOUSE",
		2: "ZOOKEEPER",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"CLICKHOUSE":       1,
		"ZOOKEEPER":        2,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[5]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{8, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown. Default value.
	Service_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
	}
	Service_Health_value = map[string]int32{
		"UNKNOWN": 0,
		"ALIVE":   1,
		"DEAD":    2,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[6].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes[6]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{8, 1}
}

// A ClickHouse Cluster resource. For more information, see the
// [Cluster](/docs/managed-clickhouse/concepts) section in the Developer's Guide.
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the ClickHouse cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the ClickHouse cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the ClickHouse cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the ClickHouse cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the ClickHouse cluster as `key:value` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Deployment environment of the ClickHouse cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the ClickHouse cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the ClickHouse cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Status" json:"status,omitempty"`
	// ID of the service account used for access to Object Storage.
	ServiceAccountId string `protobuf:"bytes,13,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Maintenance window for the cluster.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,14,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Planned maintenance operation to be started for the cluster within the nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,15,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,16,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,17,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// ID of the key to encrypt cluster disks.
	DiskEncryptionKeyId *wrapperspb.StringValue `protobuf:"bytes,19,opt,name=disk_encryption_key_id,json=diskEncryptionKeyId,proto3" json:"disk_encryption_key_id,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetDiskEncryptionKeyId() *wrapperspb.StringValue {
	if x != nil {
		return x.DiskEncryptionKeyId
	}
	return nil
}

// Monitoring system metadata.
type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the ClickHouse cluster.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of the ClickHouse server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration and resource allocation for ClickHouse hosts.
	Clickhouse *ClusterConfig_Clickhouse `protobuf:"bytes,2,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	// Configuration and resource allocation for ZooKeeper hosts.
	Zookeeper *ClusterConfig_Zookeeper `protobuf:"bytes,3,opt,name=zookeeper,proto3" json:"zookeeper,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy for external services.
	Access       *Access       `protobuf:"bytes,5,opt,name=access,proto3" json:"access,omitempty"`
	CloudStorage *CloudStorage `protobuf:"bytes,6,opt,name=cloud_storage,json=cloudStorage,proto3" json:"cloud_storage,omitempty"`
	// Whether database management through SQL commands is enabled.
	SqlDatabaseManagement *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=sql_database_management,json=sqlDatabaseManagement,proto3" json:"sql_database_management,omitempty"`
	// Whether user management through SQL commands is enabled.
	SqlUserManagement *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=sql_user_management,json=sqlUserManagement,proto3" json:"sql_user_management,omitempty"`
	// Whether cluster should use embedded Keeper instead of Zookeeper.
	EmbeddedKeeper *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=embedded_keeper,json=embeddedKeeper,proto3" json:"embedded_keeper,omitempty"`
	// Retain period of automatically created backup in days
	BackupRetainPeriodDays *wrapperspb.Int64Value `protobuf:"bytes,10,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClusterConfig) GetClickhouse() *ClusterConfig_Clickhouse {
	if x != nil {
		return x.Clickhouse
	}
	return nil
}

func (x *ClusterConfig) GetZookeeper() *ClusterConfig_Zookeeper {
	if x != nil {
		return x.Zookeeper
	}
	return nil
}

func (x *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ClusterConfig) GetCloudStorage() *CloudStorage {
	if x != nil {
		return x.CloudStorage
	}
	return nil
}

func (x *ClusterConfig) GetSqlDatabaseManagement() *wrapperspb.BoolValue {
	if x != nil {
		return x.SqlDatabaseManagement
	}
	return nil
}

func (x *ClusterConfig) GetSqlUserManagement() *wrapperspb.BoolValue {
	if x != nil {
		return x.SqlUserManagement
	}
	return nil
}

func (x *ClusterConfig) GetEmbeddedKeeper() *wrapperspb.BoolValue {
	if x != nil {
		return x.EmbeddedKeeper
	}
	return nil
}

func (x *ClusterConfig) GetBackupRetainPeriodDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

type Shard struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configuration of the shard.
	Config        *ShardConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Shard) Reset() {
	*x = Shard{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Shard) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Shard) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Shard) GetConfig() *ShardConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type Shards struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Shards        []*Shard               `protobuf:"bytes,1,rep,name=shards,proto3" json:"shards,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Shards) Reset() {
	*x = Shards{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Shards) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shards) ProtoMessage() {}

func (x *Shards) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shards.ProtoReflect.Descriptor instead.
func (*Shards) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Shards) GetShards() []*Shard {
	if x != nil {
		return x.Shards
	}
	return nil
}

type ShardGroup struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the shard group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the ClickHouse cluster that the shard group belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Description of the shard group. 0-256 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// List of shard names contained in the shard group.
	ShardNames    []string `protobuf:"bytes,4,rep,name=shard_names,json=shardNames,proto3" json:"shard_names,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ShardGroup) Reset() {
	*x = ShardGroup{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShardGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardGroup) ProtoMessage() {}

func (x *ShardGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardGroup.ProtoReflect.Descriptor instead.
func (*ShardGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *ShardGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ShardGroup) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ShardGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ShardGroup) GetShardNames() []string {
	if x != nil {
		return x.ShardNames
	}
	return nil
}

type ShardConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ClickHouse configuration for a shard.
	Clickhouse    *ShardConfig_Clickhouse `protobuf:"bytes,1,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ShardConfig) Reset() {
	*x = ShardConfig{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShardConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardConfig) ProtoMessage() {}

func (x *ShardConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardConfig.ProtoReflect.Descriptor instead.
func (*ShardConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *ShardConfig) GetClickhouse() *ShardConfig_Clickhouse {
	if x != nil {
		return x.Clickhouse
	}
	return nil
}

type Host struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the ClickHouse host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the ClickHouse host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the ClickHouse host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Type of the host. If the field has default value, it is not returned in the response.
	Type Host_Type `protobuf:"varint,4,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Type" json:"type,omitempty"`
	// Resources allocated to the ClickHouse host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Aggregated health of the host. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool   `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ShardName      string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Host) Reset() {
	*x = Host{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

type Service struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the service provided by the host. If the field has default value, it is not returned in the response.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Service_Type" json:"type,omitempty"`
	// Aggregated health of the service. If the field has default value, it is not returned in the response.
	Health        Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Service_Health" json:"health,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_UNKNOWN
}

type Resources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-clickhouse/concepts/instance-types)
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd - network HDD drive,
	// * network-ssd - network SSD drive,
	// * local-ssd - local SSD storage.
	DiskTypeId    string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resources) Reset() {
	*x = Resources{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

type Access struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allow to export data from the cluster to DataLens.
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allow SQL queries to the cluster databases from the management console.
	//
	// See [SQL queries in the management console](/docs/managed-clickhouse/operations/web-sql-query) for more details.
	WebSql bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	// Allow to import data from Yandex Metrica and AppMetrica to the cluster.
	//
	// See [AppMetrica documentation](https://appmetrica.yandex.com/docs/cloud/index.html) for more details.
	Metrika bool `protobuf:"varint,3,opt,name=metrika,proto3" json:"metrika,omitempty"`
	// Allow access to cluster for Serverless.
	Serverless bool `protobuf:"varint,4,opt,name=serverless,proto3" json:"serverless,omitempty"`
	// Allow access for DataTransfer
	DataTransfer bool `protobuf:"varint,5,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
	// Allow access for Query
	YandexQuery   bool `protobuf:"varint,6,opt,name=yandex_query,json=yandexQuery,proto3" json:"yandex_query,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Access) Reset() {
	*x = Access{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

func (x *Access) GetWebSql() bool {
	if x != nil {
		return x.WebSql
	}
	return false
}

func (x *Access) GetMetrika() bool {
	if x != nil {
		return x.Metrika
	}
	return false
}

func (x *Access) GetServerless() bool {
	if x != nil {
		return x.Serverless
	}
	return false
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

func (x *Access) GetYandexQuery() bool {
	if x != nil {
		return x.YandexQuery
	}
	return false
}

type CloudStorage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Whether to use Object Storage for storing ClickHouse data.
	Enabled          bool                    `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	MoveFactor       *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=move_factor,json=moveFactor,proto3" json:"move_factor,omitempty"`
	DataCacheEnabled *wrapperspb.BoolValue   `protobuf:"bytes,3,opt,name=data_cache_enabled,json=dataCacheEnabled,proto3" json:"data_cache_enabled,omitempty"`
	DataCacheMaxSize *wrapperspb.Int64Value  `protobuf:"bytes,4,opt,name=data_cache_max_size,json=dataCacheMaxSize,proto3" json:"data_cache_max_size,omitempty"`
	PreferNotToMerge *wrapperspb.BoolValue   `protobuf:"bytes,5,opt,name=prefer_not_to_merge,json=preferNotToMerge,proto3" json:"prefer_not_to_merge,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *CloudStorage) Reset() {
	*x = CloudStorage{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorage) ProtoMessage() {}

func (x *CloudStorage) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorage.ProtoReflect.Descriptor instead.
func (*CloudStorage) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *CloudStorage) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *CloudStorage) GetMoveFactor() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MoveFactor
	}
	return nil
}

func (x *CloudStorage) GetDataCacheEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.DataCacheEnabled
	}
	return nil
}

func (x *CloudStorage) GetDataCacheMaxSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.DataCacheMaxSize
	}
	return nil
}

func (x *CloudStorage) GetPreferNotToMerge() *wrapperspb.BoolValue {
	if x != nil {
		return x.PreferNotToMerge
	}
	return nil
}

type DiskSizeAutoscaling struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Amount of used storage for automatic disk scaling in the maintenance window, 0 means disabled, in percent.
	PlannedUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Amount of used storage for immediately  automatic disk scaling, 0 means disabled, in percent.
	EmergencyUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// Limit on how large the storage for database instances can automatically grow, in bytes.
	DiskSizeLimit *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.DiskSizeLimit
	}
	return nil
}

type ClusterConfig_Clickhouse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration settings of a ClickHouse server.
	Config *config.ClickhouseConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to ClickHouse hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings.
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ClusterConfig_Clickhouse) Reset() {
	*x = ClusterConfig_Clickhouse{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig_Clickhouse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig_Clickhouse) ProtoMessage() {}

func (x *ClusterConfig_Clickhouse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig_Clickhouse.ProtoReflect.Descriptor instead.
func (*ClusterConfig_Clickhouse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ClusterConfig_Clickhouse) GetConfig() *config.ClickhouseConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ClusterConfig_Clickhouse) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ClusterConfig_Clickhouse) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type ClusterConfig_Zookeeper struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources allocated to ZooKeeper hosts.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings.
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,2,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ClusterConfig_Zookeeper) Reset() {
	*x = ClusterConfig_Zookeeper{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig_Zookeeper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig_Zookeeper) ProtoMessage() {}

func (x *ClusterConfig_Zookeeper) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig_Zookeeper.ProtoReflect.Descriptor instead.
func (*ClusterConfig_Zookeeper) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ClusterConfig_Zookeeper) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ClusterConfig_Zookeeper) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type ShardConfig_Clickhouse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ClickHouse settings for a shard.
	Config *config.ClickhouseConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Computational resources for a shard.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Relative weight of a shard considered when writing data to the cluster.
	// For details, see [ClickHouse documentation](https://clickhouse.com/docs/en/operations/table_engines/distributed/).
	Weight *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=weight,proto3" json:"weight,omitempty"`
	// Disk size autoscaling settings.
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ShardConfig_Clickhouse) Reset() {
	*x = ShardConfig_Clickhouse{}
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShardConfig_Clickhouse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardConfig_Clickhouse) ProtoMessage() {}

func (x *ShardConfig_Clickhouse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardConfig_Clickhouse.ProtoReflect.Descriptor instead.
func (*ShardConfig_Clickhouse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ShardConfig_Clickhouse) GetConfig() *config.ClickhouseConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ShardConfig_Clickhouse) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ShardConfig_Clickhouse) GetWeight() *wrapperspb.Int64Value {
	if x != nil {
		return x.Weight
	}
	return nil
}

func (x *ShardConfig_Clickhouse) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

var File_yandex_cloud_mdb_clickhouse_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDesc = "" +
	"\n" +
	",yandex/cloud/mdb/clickhouse/v1/cluster.proto\x12\x1eyandex.cloud.mdb.clickhouse.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1bgoogle/type/timeofday.proto\x1a6yandex/cloud/mdb/clickhouse/v1/config/clickhouse.proto\x1a0yandex/cloud/mdb/clickhouse/v1/maintenance.proto\x1a\x1dyandex/cloud/validation.proto\"\xfa\n" +
	"\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12K\n" +
	"\x06labels\x18\x06 \x03(\v23.yandex.cloud.mdb.clickhouse.v1.Cluster.LabelsEntryR\x06labels\x12U\n" +
	"\venvironment\x18\a \x01(\x0e23.yandex.cloud.mdb.clickhouse.v1.Cluster.EnvironmentR\venvironment\x12J\n" +
	"\n" +
	"monitoring\x18\b \x03(\v2*.yandex.cloud.mdb.clickhouse.v1.MonitoringR\n" +
	"monitoring\x12E\n" +
	"\x06config\x18\t \x01(\v2-.yandex.cloud.mdb.clickhouse.v1.ClusterConfigR\x06config\x12\x1d\n" +
	"\n" +
	"network_id\x18\n" +
	" \x01(\tR\tnetworkId\x12F\n" +
	"\x06health\x18\v \x01(\x0e2..yandex.cloud.mdb.clickhouse.v1.Cluster.HealthR\x06health\x12F\n" +
	"\x06status\x18\f \x01(\x0e2..yandex.cloud.mdb.clickhouse.v1.Cluster.StatusR\x06status\x12,\n" +
	"\x12service_account_id\x18\r \x01(\tR\x10serviceAccountId\x12`\n" +
	"\x12maintenance_window\x18\x0e \x01(\v21.yandex.cloud.mdb.clickhouse.v1.MaintenanceWindowR\x11maintenanceWindow\x12a\n" +
	"\x11planned_operation\x18\x0f \x01(\v24.yandex.cloud.mdb.clickhouse.v1.MaintenanceOperationR\x10plannedOperation\x12,\n" +
	"\x12security_group_ids\x18\x10 \x03(\tR\x10securityGroupIds\x12/\n" +
	"\x13deletion_protection\x18\x11 \x01(\bR\x12deletionProtection\x12Q\n" +
	"\x16disk_encryption_key_id\x18\x13 \x01(\v2\x1c.google.protobuf.StringValueR\x13diskEncryptionKeyId\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"I\n" +
	"\vEnvironment\x12\x1b\n" +
	"\x17ENVIRONMENT_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"PRODUCTION\x10\x01\x12\r\n" +
	"\tPRESTABLE\x10\x02\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bUPDATING\x10\x04\x12\f\n" +
	"\bSTOPPING\x10\x05\x12\v\n" +
	"\aSTOPPED\x10\x06\x12\f\n" +
	"\bSTARTING\x10\aJ\x04\b\x12\x10\x13\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\xc7\t\n" +
	"\rClusterConfig\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12X\n" +
	"\n" +
	"clickhouse\x18\x02 \x01(\v28.yandex.cloud.mdb.clickhouse.v1.ClusterConfig.ClickhouseR\n" +
	"clickhouse\x12U\n" +
	"\tzookeeper\x18\x03 \x01(\v27.yandex.cloud.mdb.clickhouse.v1.ClusterConfig.ZookeeperR\tzookeeper\x12F\n" +
	"\x13backup_window_start\x18\x04 \x01(\v2\x16.google.type.TimeOfDayR\x11backupWindowStart\x12>\n" +
	"\x06access\x18\x05 \x01(\v2&.yandex.cloud.mdb.clickhouse.v1.AccessR\x06access\x12Q\n" +
	"\rcloud_storage\x18\x06 \x01(\v2,.yandex.cloud.mdb.clickhouse.v1.CloudStorageR\fcloudStorage\x12R\n" +
	"\x17sql_database_management\x18\a \x01(\v2\x1a.google.protobuf.BoolValueR\x15sqlDatabaseManagement\x12J\n" +
	"\x13sql_user_management\x18\b \x01(\v2\x1a.google.protobuf.BoolValueR\x11sqlUserManagement\x12C\n" +
	"\x0fembedded_keeper\x18\t \x01(\v2\x1a.google.protobuf.BoolValueR\x0eembeddedKeeper\x12V\n" +
	"\x19backup_retain_period_days\x18\n" +
	" \x01(\v2\x1b.google.protobuf.Int64ValueR\x16backupRetainPeriodDays\x1a\x92\x02\n" +
	"\n" +
	"Clickhouse\x12R\n" +
	"\x06config\x18\x01 \x01(\v2:.yandex.cloud.mdb.clickhouse.v1.config.ClickhouseConfigSetR\x06config\x12G\n" +
	"\tresources\x18\x02 \x01(\v2).yandex.cloud.mdb.clickhouse.v1.ResourcesR\tresources\x12g\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v23.yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xbd\x01\n" +
	"\tZookeeper\x12G\n" +
	"\tresources\x18\x01 \x01(\v2).yandex.cloud.mdb.clickhouse.v1.ResourcesR\tresources\x12g\n" +
	"\x15disk_size_autoscaling\x18\x02 \x01(\v23.yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\x7f\n" +
	"\x05Shard\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12C\n" +
	"\x06config\x18\x03 \x01(\v2+.yandex.cloud.mdb.clickhouse.v1.ShardConfigR\x06config\"G\n" +
	"\x06Shards\x12=\n" +
	"\x06shards\x18\x01 \x03(\v2%.yandex.cloud.mdb.clickhouse.v1.ShardR\x06shards\"\x82\x01\n" +
	"\n" +
	"ShardGroup\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12 \n" +
	"\vdescription\x18\x03 \x01(\tR\vdescription\x12\x1f\n" +
	"\vshard_names\x18\x04 \x03(\tR\n" +
	"shardNames\"\xaf\x03\n" +
	"\vShardConfig\x12V\n" +
	"\n" +
	"clickhouse\x18\x01 \x01(\v26.yandex.cloud.mdb.clickhouse.v1.ShardConfig.ClickhouseR\n" +
	"clickhouse\x1a\xc7\x02\n" +
	"\n" +
	"Clickhouse\x12R\n" +
	"\x06config\x18\x01 \x01(\v2:.yandex.cloud.mdb.clickhouse.v1.config.ClickhouseConfigSetR\x06config\x12G\n" +
	"\tresources\x18\x02 \x01(\v2).yandex.cloud.mdb.clickhouse.v1.ResourcesR\tresources\x123\n" +
	"\x06weight\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x06weight\x12g\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v23.yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xc1\x04\n" +
	"\x04Host\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12\x17\n" +
	"\azone_id\x18\x03 \x01(\tR\x06zoneId\x12=\n" +
	"\x04type\x18\x04 \x01(\x0e2).yandex.cloud.mdb.clickhouse.v1.Host.TypeR\x04type\x12G\n" +
	"\tresources\x18\x05 \x01(\v2).yandex.cloud.mdb.clickhouse.v1.ResourcesR\tresources\x12C\n" +
	"\x06health\x18\x06 \x01(\x0e2+.yandex.cloud.mdb.clickhouse.v1.Host.HealthR\x06health\x12C\n" +
	"\bservices\x18\a \x03(\v2'.yandex.cloud.mdb.clickhouse.v1.ServiceR\bservices\x12\x1b\n" +
	"\tsubnet_id\x18\b \x01(\tR\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\t \x01(\bR\x0eassignPublicIp\x12\x1d\n" +
	"\n" +
	"shard_name\x18\n" +
	" \x01(\tR\tshardName\";\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"CLICKHOUSE\x10\x01\x12\r\n" +
	"\tZOOKEEPER\x10\x02\"8\n" +
	"\x06Health\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"\xfc\x01\n" +
	"\aService\x12@\n" +
	"\x04type\x18\x01 \x01(\x0e2,.yandex.cloud.mdb.clickhouse.v1.Service.TypeR\x04type\x12F\n" +
	"\x06health\x18\x02 \x01(\x0e2..yandex.cloud.mdb.clickhouse.v1.Service.HealthR\x06health\";\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"CLICKHOUSE\x10\x01\x12\r\n" +
	"\tZOOKEEPER\x10\x02\"*\n" +
	"\x06Health\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\"x\n" +
	"\tResources\x12,\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tR\x10resourcePresetId\x12\x1b\n" +
	"\tdisk_size\x18\x02 \x01(\x03R\bdiskSize\x12 \n" +
	"\fdisk_type_id\x18\x03 \x01(\tR\n" +
	"diskTypeId\"\xc0\x01\n" +
	"\x06Access\x12\x1b\n" +
	"\tdata_lens\x18\x01 \x01(\bR\bdataLens\x12\x17\n" +
	"\aweb_sql\x18\x02 \x01(\bR\x06webSql\x12\x18\n" +
	"\ametrika\x18\x03 \x01(\bR\ametrika\x12\x1e\n" +
	"\n" +
	"serverless\x18\x04 \x01(\bR\n" +
	"serverless\x12#\n" +
	"\rdata_transfer\x18\x05 \x01(\bR\fdataTransfer\x12!\n" +
	"\fyandex_query\x18\x06 \x01(\bR\vyandexQuery\"\xd1\x02\n" +
	"\fCloudStorage\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12F\n" +
	"\vmove_factor\x18\x02 \x01(\v2\x1c.google.protobuf.DoubleValueB\a\xfa\xc71\x030-1R\n" +
	"moveFactor\x12H\n" +
	"\x12data_cache_enabled\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\x10dataCacheEnabled\x12J\n" +
	"\x13data_cache_max_size\x18\x04 \x01(\v2\x1b.google.protobuf.Int64ValueR\x10dataCacheMaxSize\x12I\n" +
	"\x13prefer_not_to_merge\x18\x05 \x01(\v2\x1a.google.protobuf.BoolValueR\x10preferNotToMerge\"\xa6\x02\n" +
	"\x13DiskSizeAutoscaling\x12b\n" +
	"\x17planned_usage_threshold\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueB\r\xe8\xc71\x00\xfa\xc71\x050-100R\x15plannedUsageThreshold\x12f\n" +
	"\x19emergency_usage_threshold\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueB\r\xe8\xc71\x00\xfa\xc71\x050-100R\x17emergencyUsageThreshold\x12C\n" +
	"\x0fdisk_size_limit\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\rdiskSizeLimitBs\n" +
	"\"yandex.cloud.api.mdb.clickhouse.v1ZMgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1;clickhouseb\x06proto3"

var (
	file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),           // 0: yandex.cloud.mdb.clickhouse.v1.Cluster.Environment
	(Cluster_Health)(0),                // 1: yandex.cloud.mdb.clickhouse.v1.Cluster.Health
	(Cluster_Status)(0),                // 2: yandex.cloud.mdb.clickhouse.v1.Cluster.Status
	(Host_Type)(0),                     // 3: yandex.cloud.mdb.clickhouse.v1.Host.Type
	(Host_Health)(0),                   // 4: yandex.cloud.mdb.clickhouse.v1.Host.Health
	(Service_Type)(0),                  // 5: yandex.cloud.mdb.clickhouse.v1.Service.Type
	(Service_Health)(0),                // 6: yandex.cloud.mdb.clickhouse.v1.Service.Health
	(*Cluster)(nil),                    // 7: yandex.cloud.mdb.clickhouse.v1.Cluster
	(*Monitoring)(nil),                 // 8: yandex.cloud.mdb.clickhouse.v1.Monitoring
	(*ClusterConfig)(nil),              // 9: yandex.cloud.mdb.clickhouse.v1.ClusterConfig
	(*Shard)(nil),                      // 10: yandex.cloud.mdb.clickhouse.v1.Shard
	(*Shards)(nil),                     // 11: yandex.cloud.mdb.clickhouse.v1.Shards
	(*ShardGroup)(nil),                 // 12: yandex.cloud.mdb.clickhouse.v1.ShardGroup
	(*ShardConfig)(nil),                // 13: yandex.cloud.mdb.clickhouse.v1.ShardConfig
	(*Host)(nil),                       // 14: yandex.cloud.mdb.clickhouse.v1.Host
	(*Service)(nil),                    // 15: yandex.cloud.mdb.clickhouse.v1.Service
	(*Resources)(nil),                  // 16: yandex.cloud.mdb.clickhouse.v1.Resources
	(*Access)(nil),                     // 17: yandex.cloud.mdb.clickhouse.v1.Access
	(*CloudStorage)(nil),               // 18: yandex.cloud.mdb.clickhouse.v1.CloudStorage
	(*DiskSizeAutoscaling)(nil),        // 19: yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling
	nil,                                // 20: yandex.cloud.mdb.clickhouse.v1.Cluster.LabelsEntry
	(*ClusterConfig_Clickhouse)(nil),   // 21: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse
	(*ClusterConfig_Zookeeper)(nil),    // 22: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Zookeeper
	(*ShardConfig_Clickhouse)(nil),     // 23: yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse
	(*timestamppb.Timestamp)(nil),      // 24: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),          // 25: yandex.cloud.mdb.clickhouse.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),       // 26: yandex.cloud.mdb.clickhouse.v1.MaintenanceOperation
	(*wrapperspb.StringValue)(nil),     // 27: google.protobuf.StringValue
	(*timeofday.TimeOfDay)(nil),        // 28: google.type.TimeOfDay
	(*wrapperspb.BoolValue)(nil),       // 29: google.protobuf.BoolValue
	(*wrapperspb.Int64Value)(nil),      // 30: google.protobuf.Int64Value
	(*wrapperspb.DoubleValue)(nil),     // 31: google.protobuf.DoubleValue
	(*config.ClickhouseConfigSet)(nil), // 32: yandex.cloud.mdb.clickhouse.v1.config.ClickhouseConfigSet
}
var file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_depIdxs = []int32{
	24, // 0: yandex.cloud.mdb.clickhouse.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	20, // 1: yandex.cloud.mdb.clickhouse.v1.Cluster.labels:type_name -> yandex.cloud.mdb.clickhouse.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.clickhouse.v1.Cluster.environment:type_name -> yandex.cloud.mdb.clickhouse.v1.Cluster.Environment
	8,  // 3: yandex.cloud.mdb.clickhouse.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.clickhouse.v1.Monitoring
	9,  // 4: yandex.cloud.mdb.clickhouse.v1.Cluster.config:type_name -> yandex.cloud.mdb.clickhouse.v1.ClusterConfig
	1,  // 5: yandex.cloud.mdb.clickhouse.v1.Cluster.health:type_name -> yandex.cloud.mdb.clickhouse.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.clickhouse.v1.Cluster.status:type_name -> yandex.cloud.mdb.clickhouse.v1.Cluster.Status
	25, // 7: yandex.cloud.mdb.clickhouse.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.clickhouse.v1.MaintenanceWindow
	26, // 8: yandex.cloud.mdb.clickhouse.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.clickhouse.v1.MaintenanceOperation
	27, // 9: yandex.cloud.mdb.clickhouse.v1.Cluster.disk_encryption_key_id:type_name -> google.protobuf.StringValue
	21, // 10: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.clickhouse:type_name -> yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse
	22, // 11: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.zookeeper:type_name -> yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Zookeeper
	28, // 12: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.backup_window_start:type_name -> google.type.TimeOfDay
	17, // 13: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.clickhouse.v1.Access
	18, // 14: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.cloud_storage:type_name -> yandex.cloud.mdb.clickhouse.v1.CloudStorage
	29, // 15: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.sql_database_management:type_name -> google.protobuf.BoolValue
	29, // 16: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.sql_user_management:type_name -> google.protobuf.BoolValue
	29, // 17: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.embedded_keeper:type_name -> google.protobuf.BoolValue
	30, // 18: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	13, // 19: yandex.cloud.mdb.clickhouse.v1.Shard.config:type_name -> yandex.cloud.mdb.clickhouse.v1.ShardConfig
	10, // 20: yandex.cloud.mdb.clickhouse.v1.Shards.shards:type_name -> yandex.cloud.mdb.clickhouse.v1.Shard
	23, // 21: yandex.cloud.mdb.clickhouse.v1.ShardConfig.clickhouse:type_name -> yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse
	3,  // 22: yandex.cloud.mdb.clickhouse.v1.Host.type:type_name -> yandex.cloud.mdb.clickhouse.v1.Host.Type
	16, // 23: yandex.cloud.mdb.clickhouse.v1.Host.resources:type_name -> yandex.cloud.mdb.clickhouse.v1.Resources
	4,  // 24: yandex.cloud.mdb.clickhouse.v1.Host.health:type_name -> yandex.cloud.mdb.clickhouse.v1.Host.Health
	15, // 25: yandex.cloud.mdb.clickhouse.v1.Host.services:type_name -> yandex.cloud.mdb.clickhouse.v1.Service
	5,  // 26: yandex.cloud.mdb.clickhouse.v1.Service.type:type_name -> yandex.cloud.mdb.clickhouse.v1.Service.Type
	6,  // 27: yandex.cloud.mdb.clickhouse.v1.Service.health:type_name -> yandex.cloud.mdb.clickhouse.v1.Service.Health
	31, // 28: yandex.cloud.mdb.clickhouse.v1.CloudStorage.move_factor:type_name -> google.protobuf.DoubleValue
	29, // 29: yandex.cloud.mdb.clickhouse.v1.CloudStorage.data_cache_enabled:type_name -> google.protobuf.BoolValue
	30, // 30: yandex.cloud.mdb.clickhouse.v1.CloudStorage.data_cache_max_size:type_name -> google.protobuf.Int64Value
	29, // 31: yandex.cloud.mdb.clickhouse.v1.CloudStorage.prefer_not_to_merge:type_name -> google.protobuf.BoolValue
	30, // 32: yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling.planned_usage_threshold:type_name -> google.protobuf.Int64Value
	30, // 33: yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling.emergency_usage_threshold:type_name -> google.protobuf.Int64Value
	30, // 34: yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling.disk_size_limit:type_name -> google.protobuf.Int64Value
	32, // 35: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse.config:type_name -> yandex.cloud.mdb.clickhouse.v1.config.ClickhouseConfigSet
	16, // 36: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse.resources:type_name -> yandex.cloud.mdb.clickhouse.v1.Resources
	19, // 37: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse.disk_size_autoscaling:type_name -> yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling
	16, // 38: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Zookeeper.resources:type_name -> yandex.cloud.mdb.clickhouse.v1.Resources
	19, // 39: yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Zookeeper.disk_size_autoscaling:type_name -> yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling
	32, // 40: yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse.config:type_name -> yandex.cloud.mdb.clickhouse.v1.config.ClickhouseConfigSet
	16, // 41: yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse.resources:type_name -> yandex.cloud.mdb.clickhouse.v1.Resources
	30, // 42: yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse.weight:type_name -> google.protobuf.Int64Value
	19, // 43: yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse.disk_size_autoscaling:type_name -> yandex.cloud.mdb.clickhouse.v1.DiskSizeAutoscaling
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_clickhouse_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_clickhouse_v1_maintenance_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_rawDesc)),
			NumEnums:      7,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_clickhouse_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_clickhouse_v1_cluster_proto_depIdxs = nil
}
