//go:build ignore
// +build ignore

package main

import (
	"fmt"
	"os"
	"text/template"
	"time"
)

const (
	fileName   = "version_generated.go"
	versionKey = "RELEASE_VERSION"
)

func main() {
	version := os.Getenv(versionKey)
	file, err := os.Create(fileName)

	if err != nil {
		fmt.Errorf("unable create file %v")
	}

	defer file.Close()

	packageTemplate.Execute(file, struct {
		Timestamp time.Time
		Version   string
	}{
		Timestamp: time.Now(),
		Version:   version,
	})
}

var packageTemplate = template.Must(template.New("version").Parse(`// Code generated by go generate; DO NOT EDIT.
// File was generated at {{ .Timestamp}}

package version

const version = "{{ .Version}}"
`))
