;
;   Coswitch for Icon v8.4 running in 32-bit protected mode
;   with Zortech C v3.0r4 DOS extender.
;
;   The stack segment register is changed to the data segment selector for
;   new coexpressions.  This still provides stack overflow detection for
;   the main C stack.
;
;   The coswitch() code is a slight modification of the code written
;   by Robert Goldberg for Intel's Codebuilder.  Modifications 
;   by E. Neil Viberg.
;
;   Coswitch algorithm in C:
;
;   coswitch( old_cs, new_cs, first )
;   int	*old_cs, *new_cs, first;
;   {
;	/* save SP, frame pointers, and other registers in old_cs */
;	if ( first == 0 )
;	{
;	    /* load sp from new_sp[0] and clear frame pointers */
;	    new_context( 0, 0 );
;	    syserr( "new_context() returned in coswitch" );
;	}
;	else
;	{
;	    /* load sp, frame pointers and other registers from new_cs */
;	}
;   }
	.386
;
;   Define error message in appropriate segment and group.
;
_DATA	segment dword use32 public 'DATA'
	public	errormsg
errormsg db	'new_context() returned in coswitch',0
_DATA	ends
;
;   Define function coswitch in appropriate segment and group.
;
	extrn	_new_context:near
	extrn	_syserr:near
_TEXT	segment	para public 'CODE'
	assume	CS:_TEXT
	public	_coswitch
	db	'coswitch',8
_coswitch    proc    near
;
;   Save environment at point of call.
;
	mov	edx,4[esp]	    ; point to old_cs
	mov	0[edx],esp	    ; save esp
	mov	4[edx],ebp	    ; save ebp
	mov	8[edx],esi	    ; save esi
	mov	12[edx],edi	    ; save edi
	mov	16[edx],ebx	    ; save ebx
	mov	18[edx],ss	    ; save ss
;
;   Check first flag to see if first activation of this coexpression.
;
	mov	eax,12[esp]	    ; load first flag
	or	eax,eax		    ; set condition flags
	jnz	notzero		    ; jump if not zero
;
;   First is 0 -
;
;   Set things up for first activation of this coexpression.
;
	mov	edx,8[esp]	    ; point to new_cs area
	push	ds		    ; set SS for new_cs
	pop	ss
	mov	esp,0[edx]	    ; set ESP from new_cs
	mov	ebp,esp		    ; set EBP equal to ESP (can't hurt?)
	xor	eax,eax		    ; get a zero
	mov	esi,eax		    ; clear ESI
	mov	edi,eax		    ; clear EDI
	push	eax		    ; push two zeros
	push	eax		    ;   onto stack
	call	_new_context	    ; new_context(0,0) - should not return!
	push	offset errormsg	    ; push offset to error messgae
	call	_syserr		    ; terminate with error
;
;   First is not 0 -
;
;   Restore environment from new_cs.
;
notzero:
	mov	edx,8[esp]	    ; point to new_cs
	mov	ss,18[edx]	    ; restore ss
	mov	esp,0[edx]	    ; restore esp
	mov	ebp,4[edx]	    ; restore ebp
	mov	esi,8[edx]	    ; restore esi
	mov	edi,12[edx]	    ; restore edi
	mov	ebx,16[edx]	    ; restore ebx
	ret			    ; return
_coswitch    endp

_TEXT	ends
	end
