; This is the executable header for OS/2 2.x Presentation Manager version 
; of the icon programming language.  The executable built from this
; source is the prefix of every file created by the translator and
; allows direct execution of a translated module.
; This file should be assembled with Turbo Assembler (for OS/2) and linked
; either with TLINK or LINK386.  LINK386 is preferred as it provides 
; a smaller executable.
;   For TLINK:
;       tasm header.asm
;       tlink /aa header,,,os2;
;
;   Using LINK386
;       tasm /oi header.asm
;       LINK386 /noi /exepack /pmtype:pm /base:65536 /align:4 header,,,os2386;
;
; Author: Darren Merrill
; Date: March 28, 1993
;
; PS - this is my first crack at 80386 assembly, so be gentle.
 
ideal
p386

model use32 flat

; result structure from DosExecPgm
STRUC RESULTCODES
resc_codeTerminate      DD      ?       ; termination code/child id
resc_codeResult         DD      ?       ; result code of child
ENDS RESULTCODES

codeseg
extrn DOSEXECPGM:near,DOSEXIT:near
extrn WinInitialize:near,WinMessageBox:near,WinDestroyMsgQueue:near
extrn WinCreateMsgQueue:near,WinTerminate:near

stack 8000h

dataseg
LOADERRSIZE     = 100
EXEC_ASYNC      = 1
EXEC_BACKGROUND = 4
STDERR          = 2
MAXCMDLINE      = 2048

; errors from DosExecPgm
NO_ERROR                        = 0     
ERROR_INVALID_FUNCTION          = 1     
ERROR_FILE_NOT_FOUND            = 2     
ERROR_PATH_NOT_FOUND            = 3
ERROR_ACCESS_DENIED             = 5
ERROR_NOT_ENOUGH_MEMORY         = 8
ERROR_BAD_ENVIRONMENT           = 10
ERROR_BAD_FORMAT                = 11
ERROR_INVALID_DATA              = 13
ERROR_NOT_DOS_DISK              = 26
ERROR_SHARING_VIOLATION         = 32
ERROR_LOCK_VIOLATION            = 33
ERROR_NO_PROC_SLOTS             = 89
ERROR_INVALID_MODULETYPE        = 190
ERROR_INVALID_EXE_SIGNATURE     = 191
ERROR_EXE_MARKED_INVALID        = 192

; flags for WinMessageBox
MB_OK                           = 0000h
MB_OKCANCEL                     = 0001h
MB_RETRYCANCEL                  = 0002h
MB_ABORTRETRYIGNORE             = 0003h
MB_YESNO                        = 0004h
MB_YESNOCANCEL                  = 0005h
MB_CANCEL                       = 0006h
MB_ENTER                        = 0007h
MB_ENTERCANCEL                  = 0008h
MB_NOICON                       = 0000h
MB_CUANOTIFICATION              = 0000h
MB_ICONQUESTION                 = 0010h
MB_ICONEXCLAMATION              = 0020h
MB_CUAWARNING                   = 0020h
MB_ICONASTERISK                 = 0030h
MB_ICONHAND                     = 0040h
MB_CUACRITICAL                  = 0040h
MB_MOVEABLE                     = 4000h

; the desktop window handle
HWND_DESKTOP                    = 1

; ------------------- initialized data --------------------
retval          dd 0    ; the value to DosExit with

errmsg1         db 'The runtime system could not be found or executed. '
                db 'Please ensure that XICONX.EXE is in your PATH.',0
errmsg2         db 'The system could not gain access to XICONX.EXE.',0
errmsg3         db 'Not enough memory to start up runtime system.',0
errmsg4         db 'The file XICONX.EXE is not recognized as a valid '
                db 'executable.  Please obtain a new version of this file.',0
errmsg5         db 'The file XICONX.EXE is locked by another application.'
                db '  The requested program cannot be executed.',0
errmsg6         db 'Process table is full.  Close a dormant application and '
                db 'try again.',0
cmdlineerr      db 'Command line exceeds maximum allowable length of '
                db '2048 characters.  Execution cannot continue.',0
errtitle        db 'Icon Execution Header',0
cmdline         db 'xiconx.exe',0               ; our prepend
pgmlen          = $ - cmdline                   ; length of the program name
                db MAXCMDLINE DUP (?)           ; the rest of the buffer

; -------------------- uninitialized data ------------------
; the return code of the child process started with DosExecPgm.  Since
;  we are running async, this doesn't really get used - just a formality
retcodes        RESULTCODES     ?
; address of the environment block
environ         dd ?
; the buffer that DosExecPgm fills with the error
loaderror       db LOADERRSIZE DUP (?)

hab             dd ?
hmq             dd ?

codeseg
start:
        ; grab the environment and command line
        mov     ebx, [esp + 12]         ; load the environment pointer
        mov     [environ], ebx          ; store the address in our var
        mov     ebx, [esp + 16]         ; load the command line pointer

        ; count the length of the current command line
        cld                             ; set autoincrement (edi, esi)
        mov     edi, ebx                ; idest <- address of command line
        mov     ecx, 0FFFFFFFFh         ; max the counter out
        xor     eax, eax                ; search for NULL
        repne   scasb                   ; repeat 
        repne   scasb                   ; second NULL indicates end of args
        not     ecx                     ; ones complement (flip)

        ; check for potential buffer overrun
        cmp     ecx, MAXCMDLINE
        ja      CmdLineOverRun

        ; copy the command line over to our buffer
        mov     edi, offset cmdline + pgmlen   ; setup destination
        mov     esi, ebx                ; set the source to current cmd
        rep     movsb                   ; move while cx > 0

        ; search for the 2nd NULL and knock it out
        mov     edi, offset cmdline + pgmlen
        not     ecx                     ; 0 ->> FFFFFFFFh
        repne   scasb                   ; search
        mov     [BYTE edi - 1], ' '     ; '\0' ->> ' '

        ; call DosExecPgm to launch our child
        call    DOSEXECPGM C, \
                offset loaderror, \
                LOADERRSIZE, \
                EXEC_ASYNC, \
                offset cmdline, \
                [environ], \ 
                offset retcodes, \
                offset cmdline


        ; check the return of the DosExecPgm call
        cmp     eax, NO_ERROR           ; rc == NO_ERROR?
        je      Exit                    ; no error, get out
        ; set the error message
        cmp     eax, ERROR_ACCESS_DENIED
        je      SHORT NoAccess
        cmp     eax, ERROR_NOT_ENOUGH_MEMORY
        je      SHORT OutOfMem
        cmp     eax, ERROR_INVALID_EXE_SIGNATURE
        je      SHORT InvalExe
        cmp     eax, ERROR_INVALID_MODULETYPE
        je      SHORT InvalExe
        cmp     eax, ERROR_EXE_MARKED_INVALID
        je      SHORT InvalExe
        cmp     eax, ERROR_LOCK_VIOLATION
        je      SHORT ExeLock
       
FileNoFind:                              ; the default
        mov     ebx, offset errmsg1
        jmp     ErrorDisplay

OutOfProcs:
        mov     ebx, offset errmsg6
        jmp     SHORT ErrorDisplay

ExeLock:
        mov     ebx, offset errmsg5
        jmp     SHORT ErrorDisplay

InvalExe:
        mov     ebx, offset errmsg4
        jmp     SHORT ErrorDisplay

OutOfMem:
        mov     ebx, offset errmsg3
        jmp     SHORT ErrorDisplay

NoAccess:
        mov     ebx, offset errmsg2
        jmp     SHORT ErrorDisplay


CmdLineOverRun:
        mov     ebx, offset cmdlineerr
        ; fall through
ErrorDisplay:
        mov     [retval], -1            ; exit code <- -1
        call    WinInitialize C, 0
        mov     [hab], eax
        call    WinCreateMsgQueue C, [hab], 0
        mov     [hmq], eax
        call    WinMessageBox C, \
                HWND_DESKTOP, \         ; parent window handle
                HWND_DESKTOP, \         ; owner window handle
                ebx, \                  ; pointer to messag text
                offset errtitle, \      ; title of window
                0, \                    ; help ID
                4040h                   ; MB_OK | MB_ICONERROR | MB_MOVEABLE

        call    WinDestroyMsgQueue C, [hmq]

        call    WinTerminate C, [hab]
Exit:
        call    DOSEXIT C, 0, [retval]  ; Goodbye
end start

