// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package ozone

// schema: tools.ozone.verification.listVerifications

import (
	"context"

	"github.com/bluesky-social/indigo/lex/util"
)

// VerificationListVerifications_Output is the output of a tools.ozone.verification.listVerifications call.
type VerificationListVerifications_Output struct {
	Cursor        *string                              `json:"cursor,omitempty" cborgen:"cursor,omitempty"`
	Verifications []*VerificationDefs_VerificationView `json:"verifications" cborgen:"verifications"`
}

// VerificationListVerifications calls the XRPC method "tools.ozone.verification.listVerifications".
//
// createdAfter: Filter to verifications created after this timestamp
// createdBefore: Filter to verifications created before this timestamp
// cursor: Pagination cursor
// isRevoked: Filter to verifications that are revoked or not. By default, includes both.
// issuers: Filter to verifications from specific issuers
// limit: Maximum number of results to return
// sortDirection: Sort direction for creation date
// subjects: Filter to specific verified DIDs
func VerificationListVerifications(ctx context.Context, c util.LexClient, createdAfter string, createdBefore string, cursor string, isRevoked bool, issuers []string, limit int64, sortDirection string, subjects []string) (*VerificationListVerifications_Output, error) {
	var out VerificationListVerifications_Output

	params := map[string]interface{}{}
	if createdAfter != "" {
		params["createdAfter"] = createdAfter
	}
	if createdBefore != "" {
		params["createdBefore"] = createdBefore
	}
	if cursor != "" {
		params["cursor"] = cursor
	}
	if isRevoked {
		params["isRevoked"] = isRevoked
	}
	if len(issuers) != 0 {
		params["issuers"] = issuers
	}
	if limit != 0 {
		params["limit"] = limit
	}
	if sortDirection != "" {
		params["sortDirection"] = sortDirection
	}
	if len(subjects) != 0 {
		params["subjects"] = subjects
	}
	if err := c.LexDo(ctx, util.Query, "", "tools.ozone.verification.listVerifications", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
