// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package ozone

// schema: tools.ozone.verification.grantVerifications

import (
	"context"

	"github.com/bluesky-social/indigo/lex/util"
)

// VerificationGrantVerifications_GrantError is a "grantError" in the tools.ozone.verification.grantVerifications schema.
//
// Error object for failed verifications.
type VerificationGrantVerifications_GrantError struct {
	// error: Error message describing the reason for failure.
	Error string `json:"error" cborgen:"error"`
	// subject: The did of the subject being verified
	Subject string `json:"subject" cborgen:"subject"`
}

// VerificationGrantVerifications_Input is the input argument to a tools.ozone.verification.grantVerifications call.
type VerificationGrantVerifications_Input struct {
	// verifications: Array of verification requests to process
	Verifications []*VerificationGrantVerifications_VerificationInput `json:"verifications" cborgen:"verifications"`
}

// VerificationGrantVerifications_Output is the output of a tools.ozone.verification.grantVerifications call.
type VerificationGrantVerifications_Output struct {
	FailedVerifications []*VerificationGrantVerifications_GrantError `json:"failedVerifications" cborgen:"failedVerifications"`
	Verifications       []*VerificationDefs_VerificationView         `json:"verifications" cborgen:"verifications"`
}

// VerificationGrantVerifications_VerificationInput is the input argument to a tools.ozone.verification.grantVerifications call.
type VerificationGrantVerifications_VerificationInput struct {
	// createdAt: Timestamp for verification record. Defaults to current time when not specified.
	CreatedAt *string `json:"createdAt,omitempty" cborgen:"createdAt,omitempty"`
	// displayName: Display name of the subject the verification applies to at the moment of verifying.
	DisplayName string `json:"displayName" cborgen:"displayName"`
	// handle: Handle of the subject the verification applies to at the moment of verifying.
	Handle string `json:"handle" cborgen:"handle"`
	// subject: The did of the subject being verified
	Subject string `json:"subject" cborgen:"subject"`
}

// VerificationGrantVerifications calls the XRPC method "tools.ozone.verification.grantVerifications".
func VerificationGrantVerifications(ctx context.Context, c util.LexClient, input *VerificationGrantVerifications_Input) (*VerificationGrantVerifications_Output, error) {
	var out VerificationGrantVerifications_Output
	if err := c.LexDo(ctx, util.Procedure, "application/json", "tools.ozone.verification.grantVerifications", nil, input, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
