/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.NamespaceHelper;
import org.apache.jackrabbit.core.xml.DocViewImportHandler;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.SysViewImportHandler;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger((Class)ImportHandler.class);
    protected final Importer importer;
    private final NamespaceHelper helper;
    protected Locator locator;
    private TargetImportHandler targetHandler = null;
    private Map localNamespaceMappings;

    public ImportHandler(Importer importer, Session session) throws RepositoryException {
        this.importer = importer;
        this.helper = new NamespaceHelper(session);
        this.localNamespaceMappings = this.helper.getNamespaces();
    }

    public void warning(SAXParseException e) throws SAXException {
        log.warn("warning encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream", (Throwable)e);
    }

    public void error(SAXParseException e) throws SAXException {
        log.error("error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        log.error("fatal error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
        throw e;
    }

    public void endDocument() throws SAXException {
        if (this.targetHandler != null) {
            this.targetHandler.endDocument();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.localNamespaceMappings.put(prefix, uri);
        try {
            this.helper.registerNamespace(prefix, uri);
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.targetHandler == null) {
            this.targetHandler = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI) ? new SysViewImportHandler(this.importer) : new DocViewImportHandler(this.importer);
            this.targetHandler.startDocument();
        }
        this.targetHandler.startNamespaceContext(this.localNamespaceMappings);
        this.localNamespaceMappings.clear();
        this.targetHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.targetHandler.endElement(namespaceURI, localName, qName);
        this.targetHandler.endNamespaceContext();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

