/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.xml.DocumentViewExporter;
import org.apache.jackrabbit.commons.xml.Exporter;
import org.apache.jackrabbit.commons.xml.ParsingContentHandler;
import org.apache.jackrabbit.commons.xml.SerializingContentHandler;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.apache.jackrabbit.commons.xml.ToXmlContentHandler;
import org.apache.jackrabbit.util.XMLChar;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSession
implements Session {
    private final Map namespaces = new HashMap();

    public synchronized void logout() {
        this.namespaces.clear();
    }

    public synchronized String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        String prefix;
        Iterator iterator = this.namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(uri)) continue;
            return (String)entry.getKey();
        }
        String base = prefix = this.getWorkspace().getNamespaceRegistry().getPrefix(uri);
        int i = 2;
        while (this.namespaces.containsKey(prefix)) {
            prefix = base + i;
            ++i;
        }
        this.namespaces.put(prefix, uri);
        return prefix;
    }

    public synchronized String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        String uri = (String)this.namespaces.get(prefix);
        if (uri == null) {
            uri = this.getWorkspace().getNamespaceRegistry().getURI(prefix);
            if (this.namespaces.containsValue(uri)) {
                throw new NamespaceException("Namespace not found: " + prefix);
            }
            this.namespaces.put(prefix, uri);
        }
        return uri;
    }

    public synchronized String[] getNamespacePrefixes() throws RepositoryException {
        NamespaceRegistry registry = this.getWorkspace().getNamespaceRegistry();
        String[] uris = registry.getURIs();
        for (int i = 0; i < uris.length; ++i) {
            this.getNamespacePrefix(uris[i]);
        }
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }

    public synchronized void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Namespace must not be null");
        }
        if (prefix.length() == 0) {
            throw new NamespaceException("Empty prefix is reserved and can not be remapped");
        }
        if (uri.length() == 0) {
            throw new NamespaceException("Default namespace is reserved and can not be remapped");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("XML prefixes are reserved: " + prefix);
        }
        if (!XMLChar.isValidNCName(prefix)) {
            throw new NamespaceException("Prefix is not a valid XML NCName: " + prefix);
        }
        String previous = (String)this.namespaces.get(prefix);
        if (previous != null && !previous.equals(uri)) {
            throw new NamespaceException("Namespace already mapped");
        }
        this.namespaces.remove(prefix);
        Iterator iterator = this.namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(uri)) continue;
            iterator.remove();
        }
        this.namespaces.put(prefix, uri);
    }

    public void exportDocumentView(String path, ContentHandler handler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.export(path, new DocumentViewExporter(this, handler, !noRecurse, !skipBinary));
    }

    public void exportSystemView(String path, ContentHandler handler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.export(path, new SystemViewExporter(this, handler, !noRecurse, !skipBinary));
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        Class c = SerializingContentHandler.class;
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler(out);
            this.exportDocumentView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing document view XML", (Throwable)e);
        }
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        Class c = SerializingContentHandler.class;
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler(out);
            this.exportSystemView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing system view XML", (Throwable)e);
        }
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, InvalidSerializedDataException, RepositoryException {
        try {
            ContentHandler handler = this.getImportContentHandler(parentAbsPath, uuidBehavior);
            new ParsingContentHandler(handler).parse(in);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new InvalidSerializedDataException("XML parse error", (Throwable)e);
        }
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        if (!absPath.startsWith("/")) {
            throw new PathNotFoundException("Not an absolute path: " + absPath);
        }
        Node root = this.getRootNode();
        String relPath = absPath.substring(1);
        if (relPath.length() == 0) {
            return root;
        }
        try {
            return root.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            return root.getProperty(relPath);
        }
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        try {
            this.getItem(absPath);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public Session impersonate(Credentials credentials) throws RepositoryException {
        return this.getRepository().login(credentials, this.getWorkspace().getName());
    }

    private synchronized void export(String path, Exporter exporter) throws PathNotFoundException, SAXException, RepositoryException {
        Item item = this.getItem(path);
        if (!item.isNode()) {
            throw new PathNotFoundException("XML export is not defined for properties: " + path);
        }
        exporter.export((Node)item);
    }
}

